!WRF:DRIVER_LAYER:INTEGRATION
!

MODULE module_integrate

   LOGICAL :: lbc_first_time = .true.

CONTAINS
RECURSIVE SUBROUTINE integrate ( grid , start_step, end_step )

   USE module_domain
   USE module_io_domain
   USE module_timing
   USE module_driver_constants
   USE module_nesting
   USE module_configure

   IMPLICIT NONE

   !  Input data.

   INTEGER , INTENT(IN) :: start_step
   INTEGER , INTENT(IN) :: end_step
   TYPE(domain) , POINTER :: grid

   !  Local data.

   CHARACTER*32                           :: outname, rstname
   TYPE(domain) , POINTER                 :: grid_ptr , new_nest
   INTEGER                                :: step
   INTEGER                                :: nestid , kid
   LOGICAL                                :: nest_opened
   INTEGER                                :: fid , rid
   LOGICAL                                :: lbc_opened
   REAL                                   :: time
   CHARACTER (LEN=256)                     :: message
   TYPE (grid_config_rec_type)            :: config_flags
   LOGICAL , EXTERNAL                     :: wrf_on_monitor, lbc_read_time
   INTEGER                                :: idum1 , idum2 , ierr


   ! interface
   INTERFACE
     SUBROUTINE solve_interface ( grid )
       USE module_domain
       TYPE (domain) grid
     END SUBROUTINE solve_interface
   END INTERFACE

   !  Executable

   IF ( grid%total_time_steps < end_step ) THEN

      CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )
      time = head_grid%dt * head_grid%total_time_steps
      CALL calc_current_date (grid%id, time)

      DO step = start_step, end_step

         IF ( wrf_on_monitor() ) THEN
           CALL start_timing
         END IF

         grid%itimestep=step

         IF ( grid%id .EQ. 1 .AND. config_flags%specified ) THEN
           IF ( ( lbc_read_time( grid%total_time_steps * grid%dt ) ) .AND. &
                ( end_step - step .LE. 1 ) .AND. ( step .NE. 1 ) ) THEN
             CALL wrf_debug( 100 , 'module_integrate: Skipping the attempt to read the lateral boundary file during the last time step ' )
           ELSE IF ( lbc_read_time( grid%total_time_steps * grid%dt ) ) THEN
             IF ( wrf_on_monitor() ) THEN
               INQUIRE ( file = "wrfbdy" , opened = lbc_opened )
             ENDIF
             CALL wrf_dm_bcast_bytes ( lbc_opened , LWORDSIZE )
	     IF ( .NOT. lbc_opened ) THEN
	        CALL open_r_dataset ( head_grid%lbc_fid, 'wrfbdy', grid , config_flags , ierr )
                IF ( ierr .NE. 0 ) THEN
                  CALL WRF_ERROR_FATAL( 'module_integrate: error opening wrfbdy for reading' )
                ENDIF
	     ENDIF
             CALL wrf_debug( 100 , 'module_integrate: calling input_boundary ' )
	     CALL input_boundary ( grid%lbc_fid, grid , config_flags , ierr )
     
             CALL open_w_dataset ( fid , 'wrfbdycheck', grid , config_flags , &
                                   output_boundary , ierr )
             IF ( ierr .NE. 0 ) THEN
                CALL WRF_ERROR_FATAL( 'module_integrate: error opening wrfbdycheck for writing' )
             ENDIF
             CALL output_boundary ( fid, grid, config_flags , ierr )
             CALL close_dataset ( fid , config_flags )

           ENDIF
         ENDIF

         nest_opened = .false.
         DO WHILE ( nests_to_open( grid , nestid , kid ) )
            nest_opened = .true.
            CALL alloc_and_configure_domain ( domain_id  = nestid ,                          &
                                              local_time = grid%total_time_steps *           &
                                                           grid%mother_time_step_ratio , &
                                              grid       = new_nest ,                        &
                                              parent     = grid ,                            &
                                              kid        = kid                               )
            CALL set_scalar_indices_from_config ( new_nest%id , idum1, idum2 )
            CALL open_w_dataset ( fid , 'nestcheck', new_nest , config_flags , &
                                  output_history , ierr )
            IF ( ierr .NE. 0 ) THEN
              CALL WRF_ERROR_FATAL( 'module_integrate: error opening nestcheck  for writing' )
            ENDIF
            CALL output_history  ( fid , new_nest , config_flags , ierr )
            CALL close_dataset ( fid , config_flags )
            CALL set_scalar_indices_from_config ( grid%id , idum1, idum2 )
         END DO

         IF ( nest_opened ) THEN
            CALL set_overlaps ( grid )   ! find overlapping and set pointers
         END IF


! - HISTORY OUTPUT *******************
         IF(mod(head_grid%total_time_steps, grid%time_step_count_output) .eq. 0) THEN
           IF ( wrf_on_monitor() ) THEN
             CALL start_timing
           END IF
           IF ( grid%oid .eq. 0 ) THEN
             CALL construct_filename ( outname , 'wrfout' , grid%id , 2 , grid%total_time_steps , 6 )
             CALL open_w_dataset ( head_grid%oid, TRIM(outname), head_grid ,  &
                                   config_flags , output_history , ierr )
             IF ( ierr .NE. 0 ) THEN
               WRITE ( message , '("module_integrate: error opening ",A32," for writing. ",I3)') TRIM ( outname ), ierr
               CALL WRF_ERROR_FATAL( message )
             ENDIF
             grid%write_metadata = .true.
           ELSE
             grid%write_metadata = .false.
           END IF
           CALL output_history ( grid%oid, grid , config_flags , ierr )
           grid%nframes = grid%nframes + 1
           IF ( grid%nframes >= config_flags%frames_per_outfile ) THEN
             CALL close_dataset ( grid%oid , config_flags )
             grid%nframes = 0
             grid%oid = 0
           ENDIF
           IF ( wrf_on_monitor() ) THEN
             WRITE ( message , FMT = '("Writing output for domain ",I8)' ) grid%id
             CALL end_timing ( TRIM(message) )
           END IF
         END IF


! - RESTART OUTPUT ** (good for 1-million steps on one domain only right now)
         IF(grid%time_step_count_restart .GT. 0 ) THEN
           IF(grid%id .EQ. 1 .AND. &
              mod(grid%total_time_steps, grid%time_step_count_restart) .eq. 0 .AND. &
              grid%total_time_steps .NE. grid%time_step_begin_restart         .AND. &
              grid%total_time_steps > 0 ) THEN
             IF ( wrf_on_monitor() ) THEN
               CALL start_timing
             END IF

             CALL construct_filename ( rstname , 'wrfrst' , grid%id , 2 , grid%total_time_steps , 6 )

             CALL open_w_dataset ( rid, TRIM(rstname), head_grid , &
                                   config_flags , output_restart , ierr )
             IF ( ierr .NE. 0 ) THEN
               WRITE ( message , '("module_integrate: error opening ",A32," for writing")') TRIM ( outname )
               CALL WRF_ERROR_FATAL( message )
             ENDIF
             grid%write_metadata = .true.
             CALL output_restart ( rid, grid , config_flags , ierr )
             IF ( wrf_on_monitor() ) THEN
               WRITE ( message , FMT = '("Writing restart for domain ",I8)' ) grid%id
               CALL end_timing ( TRIM(message) )
             END IF
             CALL close_dataset ( rid , config_flags )
           END IF
         END IF

         grid_ptr => grid
         DO WHILE ( ASSOCIATED( grid_ptr ) )
               CALL wrf_debug( 100 , 'module_integrate: calling solve interface ' )
               CALL solve_interface ( grid_ptr ) 
               CALL wrf_debug( 100 , 'module_integrate: back from solve interface ' )
            grid_ptr => grid_ptr%sibling
         END DO


         grid_ptr => grid
         DO WHILE ( ASSOCIATED( grid_ptr ) )
            DO kid = 1, max_nests
              IF ( ASSOCIATED( grid_ptr%nests(kid)%ptr ) ) THEN
                ! Recursive -- advance nests from previous time level to this time level.
                CALL integrate ( grid_ptr%nests(kid)%ptr ,                  &
                         ( grid_ptr%total_time_steps - 1 )                  &
                         * grid_ptr%nests(kid)%ptr%mother_time_step_ratio , &
                         ( grid_ptr%total_time_steps )                      &
                         * grid_ptr%nests(kid)%ptr%mother_time_step_ratio )
              END IF
            END DO
            grid_ptr => grid_ptr%sibling
         END DO

         time = head_grid%dt * head_grid%total_time_steps
         CALL calc_current_date (grid%id, time)

         !  Report on the timing for a single time step.

         IF ( wrf_on_monitor() ) THEN
           WRITE ( message , FMT = '("main: time step #",I8)' ) grid%total_time_steps
           CALL end_timing ( TRIM(message) )
         END IF

      END DO

! - LAST HISTORY OUTPUT *******************
      IF(grid%id .EQ. 1) THEN
        IF(mod(grid%total_time_steps, grid%time_step_count_output) .eq. 0) THEN
           IF ( wrf_on_monitor() ) THEN
             CALL start_timing
           END IF
           time = head_grid%dt * head_grid%total_time_steps
           CALL calc_current_date (grid%id, time)

           IF ( grid%oid .eq. 0 ) THEN
             CALL construct_filename ( outname , 'wrfout' , grid%id , 2 , grid%total_time_steps , 6 )
             CALL open_w_dataset ( head_grid%oid, TRIM(outname), head_grid , &
                                   config_flags , output_history , ierr )
             IF ( ierr .NE. 0 ) THEN
               WRITE ( message , '("module_integrate: error opening ",A32," for writing")') TRIM ( outname )
               CALL WRF_ERROR_FATAL( message )
             ENDIF
             grid%write_metadata = .true.
           ELSE
             grid%write_metadata = .false.
           END IF
           write(6,*) ' Model output at time ', time, ' grid id ', grid%id
           CALL output_history ( grid%oid, grid , config_flags , ierr )
           grid%nframes = grid%nframes + 1
           IF ( grid%nframes >= config_flags%frames_per_outfile ) THEN
             CALL close_dataset ( grid%oid , config_flags )
             grid%nframes = 0
             grid%oid = 0
           ENDIF

           IF ( wrf_on_monitor() ) THEN
             WRITE ( message , FMT = '("output domain ",I8)' ) grid%id
             CALL end_timing ( TRIM(message) )
           END IF
        END IF
      END IF

! - LAST RESTART OUTPUT 
      IF(grid%time_step_count_restart .GT. 0 ) THEN
        IF(grid%id .EQ. 1 .AND. &
           mod(grid%total_time_steps, grid%time_step_count_restart) .eq. 0 .AND. &
           grid%total_time_steps > 0 ) THEN
          IF ( wrf_on_monitor() ) THEN
            CALL start_timing
          END IF

          CALL construct_filename ( rstname , 'wrfrst' , grid%id , 2 , grid%total_time_steps , 6 )

          CALL open_w_dataset ( rid, TRIM(rstname), head_grid , &
                                config_flags , output_restart , ierr )
          IF ( ierr .NE. 0 ) THEN
            WRITE ( message , '("module_integrate: error opening ",A32," for writing")') TRIM ( outname )
            CALL WRF_ERROR_FATAL( message )
          ENDIF
          grid%write_metadata = .true.
          CALL output_restart ( rid, grid , config_flags , ierr )
          IF ( wrf_on_monitor() ) THEN
            WRITE ( message , FMT = '("Writing restart for domain ",I8)' ) grid%id
            CALL end_timing ( TRIM(message) )
          END IF
          CALL close_dataset ( rid , config_flags )
        END IF
      END IF

   END IF

END SUBROUTINE integrate

END MODULE module_integrate
