!WRF:MEDIATION_LAYER:IO
!

MODULE module_io_domain
USE module_ext_io
USE module_io_mm5
USE module_io_wrf

   PRIVATE open_dataset

CONTAINS

SUBROUTINE output_history ( fid , grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call output_history_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call output_history_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE output_history

SUBROUTINE output_restart ( fid , grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call output_restart_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call output_restart_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE output_restart

SUBROUTINE output_initial ( fid , grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call output_initial_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call output_initial_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE output_initial

SUBROUTINE output_boundary ( fid , grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call output_boundary_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call output_boundary_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE output_boundary

SUBROUTINE input_history ( fid,  grid , config_flags )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call input_history_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call input_history_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE input_history

SUBROUTINE input_restart ( fid,  grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call input_restart_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call input_restart_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE input_restart

SUBROUTINE input_initial ( fid,  grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call input_initial_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call input_initial_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE input_initial

SUBROUTINE input_boundary ( fid,  grid , config_flags , ierr )
   USE module_domain
   USE module_state_description
   USE module_configure
   IMPLICIT NONE
   TYPE(domain) :: grid
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   INTEGER fid, im , ierr
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       call input_boundary_mm5( fid , grid , config_flags ) ; ierr = 0
     CASE ( WRF_IO )
       call input_boundary_wrf( fid , grid , config_flags , ierr )
   END SELECT
   RETURN
END SUBROUTINE input_boundary


SUBROUTINE init_wrfio
   CALL oldext_init_wrfio
   CALL ext_init(ierr)
END SUBROUTINE init_wrfio

SUBROUTINE open_r_dataset ( id , fname , grid , config_flags , ierr )
   USE module_domain
   USE module_io_wrf
   USE module_configure
   TYPE (domain)             :: grid
   CHARACTER*(*), INTENT(IN) :: fname
   INTEGER      , INTENT(INOUT) :: id , ierr
   LOGICAL , EXTERNAL :: wrf_on_monitor
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       CALL open_dataset_mm5 ( id, fname, grid, EXT_READ ) ; ierr = 0
     CASE ( WRF_IO )
       IF ( wrf_on_monitor() ) THEN
         CALL ext_open_for_read ( fname ,                     &
                                 grid%communicator ,         &
                                 "" ,                        &
                                 id ,                        &
                                 ierr )
       ELSE
         ierr = 0
       ENDIF
   END SELECT
   RETURN
END SUBROUTINE

SUBROUTINE open_w_dataset ( id , fname , grid , config_flags , outsub , ierr )
   USE module_domain
   USE module_io_wrf
   USE module_configure
   TYPE (domain)             :: grid
   CHARACTER*(*), INTENT(IN) :: fname
   INTEGER      , INTENT(INOUT) :: id , ierr
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   LOGICAL , EXTERNAL :: wrf_on_monitor
   EXTERNAL outsub
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       CALL open_dataset_mm5 ( id, fname, grid, EXT_WRITE ) ; ierr = 0
     CASE ( WRF_IO )
       IF ( wrf_on_monitor() ) THEN
         CALL wrf_debug ( 100 , 'calling ext_open_for_write_begin in open_w_dataset' )
         CALL ext_open_for_write_begin ( fname ,     &
                                 grid%communicator ,         &
                                 "" ,                        &
                                 id ,                        &
                                 ierr )
         IF ( ierr .LE. 0 ) THEN
           CALL wrf_debug ( 100 , 'calling outsub in open_w_dataset' )
           CALL outsub( id , grid , config_flags , ierr )
         ENDIF
         IF ( ierr .LE. 0 ) THEN
           CALL wrf_debug ( 100 , 'calling ext_open_for_write_commit in open_w_dataset' )
           CALL ext_open_for_write_commit (  &
                                 id ,                        &
                                 ierr )
         ENDIF
       ELSE
         ierr = 0
       ENDIF
   END SELECT
END SUBROUTINE

SUBROUTINE close_dataset( id , config_flags ) 
   USE module_configure
   IMPLICIT NONE
   INTEGER id , ierr
   LOGICAL , EXTERNAL :: wrf_on_monitor
   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
   SELECT CASE ( config_flags%io_form )
     CASE ( MM5_IO )
       CALL oldext_close( id , ierr )
     CASE ( WRF_IO )
       IF ( wrf_on_monitor() ) THEN
         CALL ext_close( id , ierr )
       ENDIF
   END SELECT
END SUBROUTINE close_dataset

! THIS SHOULD BE REMOVED ONCE THE WRF IO API IS SOLID
#define MM5_IO
#ifdef MM5_IO
SUBROUTINE open_dataset_mm5 ( id, fname, grid, rw ) 
   USE module_domain
   IMPLICIT NONE

   ! Input data
   TYPE (domain)             :: grid
   CHARACTER*(*), INTENT(IN) :: fname
   INTEGER      , INTENT(INOUT) :: id
   INTEGER      , INTENT(IN) :: rw

   ! Local data
   INTEGER domain_info ( p_oldext_io_domain_info_len )
   INTEGER ids, ide, jds, jde, kds, kde, &
           ims, ime, jms, jme, kms, kme, &
           ips, ipe, jps, jpe, kps, kpe
   INTEGER i
   INTEGER intname(128), lenname
   INTEGER info

      SELECT CASE ( model_data_order )
         ! need to finish other cases
         CASE ( DATA_ORDER_ZXY )
   domain_info ( p_oldext_io_ids )           = grid%sd32
   domain_info ( p_oldext_io_ide )           = grid%ed32
   domain_info ( p_oldext_io_jds )           = grid%sd33
   domain_info ( p_oldext_io_jde )           = grid%ed33
   domain_info ( p_oldext_io_kds )           = grid%sd31
   domain_info ( p_oldext_io_kde )           = grid%ed31

   domain_info ( p_oldext_io_ims )           = grid%sm32
   domain_info ( p_oldext_io_ime )           = grid%em32
   domain_info ( p_oldext_io_jms )           = grid%sm33
   domain_info ( p_oldext_io_jme )           = grid%em33
   domain_info ( p_oldext_io_kms )           = grid%sm31
   domain_info ( p_oldext_io_kme )           = grid%em31

   domain_info ( p_oldext_io_ips )           = grid%sp32
   domain_info ( p_oldext_io_ipe )           = grid%ep32
   domain_info ( p_oldext_io_jps )           = grid%sp33
   domain_info ( p_oldext_io_jpe )           = grid%ep33
   domain_info ( p_oldext_io_kps )           = grid%sp31
   domain_info ( p_oldext_io_kpe )           = grid%ep31
         CASE ( DATA_ORDER_XYZ )
   domain_info ( p_oldext_io_ids )           = grid%sd31
   domain_info ( p_oldext_io_ide )           = grid%ed31
   domain_info ( p_oldext_io_jds )           = grid%sd32
   domain_info ( p_oldext_io_jde )           = grid%ed32
   domain_info ( p_oldext_io_kds )           = grid%sd33
   domain_info ( p_oldext_io_kde )           = grid%ed33

   domain_info ( p_oldext_io_ims )           = grid%sm31
   domain_info ( p_oldext_io_ime )           = grid%em31
   domain_info ( p_oldext_io_jms )           = grid%sm32
   domain_info ( p_oldext_io_jme )           = grid%em32
   domain_info ( p_oldext_io_kms )           = grid%sm33
   domain_info ( p_oldext_io_kme )           = grid%em33

   domain_info ( p_oldext_io_ips )           = grid%sp31
   domain_info ( p_oldext_io_ipe )           = grid%ep31
   domain_info ( p_oldext_io_jps )           = grid%sp32
   domain_info ( p_oldext_io_jpe )           = grid%ep32
   domain_info ( p_oldext_io_kps )           = grid%sp33
   domain_info ( p_oldext_io_kpe )           = grid%ep33
         CASE ( DATA_ORDER_XZY )
   domain_info ( p_oldext_io_ids )           = grid%sd31
   domain_info ( p_oldext_io_ide )           = grid%ed31
   domain_info ( p_oldext_io_jds )           = grid%sd33
   domain_info ( p_oldext_io_jde )           = grid%ed33
   domain_info ( p_oldext_io_kds )           = grid%sd32
   domain_info ( p_oldext_io_kde )           = grid%ed32

   domain_info ( p_oldext_io_ims )           = grid%sm31
   domain_info ( p_oldext_io_ime )           = grid%em31
   domain_info ( p_oldext_io_jms )           = grid%sm33
   domain_info ( p_oldext_io_jme )           = grid%em33
   domain_info ( p_oldext_io_kms )           = grid%sm32
   domain_info ( p_oldext_io_kme )           = grid%em32

   domain_info ( p_oldext_io_ips )           = grid%sp31
   domain_info ( p_oldext_io_ipe )           = grid%ep31
   domain_info ( p_oldext_io_jps )           = grid%sp33
   domain_info ( p_oldext_io_jpe )           = grid%ep33
   domain_info ( p_oldext_io_kps )           = grid%sp32
   domain_info ( p_oldext_io_kpe )           = grid%ep32
      END SELECT

   domain_info ( p_oldext_io_domdesc )       = grid%domdesc

   CALL oldext_open_dataset ( fname , domain_info ,   &
                           rw ,                    &
                           "" ,                    &
                           id )

END SUBROUTINE open_dataset_mm5

#endif

SUBROUTINE construct_filename ( result , basename , fld1 , len1 , fld2 , len2 )
  IMPLICIT NONE
  CHARACTER*(*) , INTENT(OUT) :: result
  CHARACTER*(*) , INTENT(IN) :: basename
  INTEGER , INTENT(IN) :: fld1 , len1 , fld2 , len2
  CHARACTER*64         :: t1, t2, zeros
  
  CALL zero_pad ( t1 , fld1 , len1 )
  CALL zero_pad ( t2 , fld2 , len2 )
  result = TRIM(basename) // "_" // TRIM(t1) // "_" // TRIM(t2)
  RETURN
END SUBROUTINE construct_filename

SUBROUTINE zero_pad ( result , fld1 , len1 )
  IMPLICIT NONE
  CHARACTER*(*) , INTENT(OUT) :: result
  INTEGER , INTENT (IN)      :: fld1 , len1
  INTEGER                    :: d , x
  CHARACTER*64         :: t2, zeros
  x = fld1 ; d = 0
  DO WHILE ( x > 0 )
    x = x / 10
    d = d + 1
  END DO
  write(t2,'(I9)')fld1
  zeros = '0000000000000000000000000000000'
  result = zeros(1:len1-d) // t2(9-d+1:9)
  RETURN
END SUBROUTINE zero_pad

END MODULE module_io_domain


