#define PLT2 \
write(88,'(i5,i5," ",a30)')ide-ids,jde-jds,plot_label;DO j=jds,jde-1;DO i=ids,ide-1;write(88,*)global_fld2d(i,j);ENDDO;ENDDO
#define PLT3 \
write(88,'(i5,i5," ",a30)')ide-ids,jde-jds,plot_label;DO j=jds,jde-1;DO i=ids,ide-1;write(88,*)global_fld(i,j,k);ENDDO;ENDDO

!-----------------------------------------------------------------------
!  This routine does a quick ncar graphics plots for grid

SUBROUTINE xpose3d( v, w, is,ie,js,je,ks,ke )
   USE module_machine
   IMPLICIT NONE
   INTEGER is,ie,js,je,ks,ke
! JM IJK MOD
   REAL v (is:ie,js:je,ks:ke)
   REAL w (is:ie,js:je,ks:ke)
   INTEGER i,j,k
   SELECT CASE ( model_data_order )
      CASE ( DATA_ORDER_ZXY )
         DO i = is,ie
         DO j = js,je
         DO k = ks,ke
           w(i,j,k) = v(k,i,j)
         ENDDO
         ENDDO
         ENDDO
      CASE ( DATA_ORDER_XYZ )
         DO i = is,ie
         DO j = js,je
         DO k = ks,ke
           w(i,j,k) = v(i,j,k)
         ENDDO
         ENDDO
         ENDDO
   END SELECT
END SUBROUTINE xpose3d

SUBROUTINE arb_look_dump( var, plot_label , domdesc , &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               its,ite, jts,jte, kts,kte    )
#ifdef DM_PARALLEL
   USE module_dm
#endif
   IMPLICIT NONE

   INTEGER, INTENT(IN)  :: ids,ide, jds,jde, kds,kde, &
                           ims,ime, jms,jme, kms,kme, &
                           its,ite, jts,jte, kts,kte
   INTEGER, INTENT(IN)   :: domdesc
! JM IJK MOD
#if 0
   REAL , DIMENSION(kms:kme,ims:ime,jms:jme) :: var
#else
   REAL , DIMENSION(ims:ime,jms:jme,kms:kme) :: var
#endif
   REAL , DIMENSION(ims:ime,jms:jme,kms:kme) :: work
   REAL , DIMENSION(ids:ide,jds:jde,kds:kde) :: global_fld
   INTEGER  size1, size2, i, j, k
   CHARACTER (LEN=80)                   :: plot_label
#ifdef DM_PARALLEL
   LOGICAL , EXTERNAL      :: wrf_on_monitor
#include <rsl.inc>

   glen(1) = ide-ids+1
   glen(2) = jde-jds+1
   glen(3) = kde-kds+1

   llen(1) = ime-ims+1
   llen(2) = jme-jms+1
   llen(3) = kme-kms+1

   k = kde-4
   call xpose3d(var,work,ims,ime,jms,jme,kms,kme)
   call rsl_write( global_fld, IO3D_IJK_INTERNAL, work, domdesc, RSL_REAL, glen(1), llen(1))
   if ( wrf_on_monitor() ) then
     size1 = ide-ids+1
     size2 = jde-jds
     PLT3
   endif
#endif

END SUBROUTINE arb_look_dump




SUBROUTINE quick_look_dump_dm ( grid, time )

   USE module_domain
   USE module_driver_constants
   USE module_state_description
   USE module_machine
   USE module_bc
#ifdef DM_PARALLEL
   USE module_dm
#endif
 
   IMPLICIT NONE

   !  Input data.

   TYPE(domain) , TARGET, INTENT(IN)         :: grid

   REAL, INTENT(IN)                       :: time

#ifdef DM_PARALLEL
   !  Pointers to and copies of domain data
#include <state_defines.inc>


# include <rsl.inc>

   !  WRF state grid_config_rec_type
   TYPE (grid_config_rec_type) , POINTER                :: config_flags

   ! WRF state data
   CHARACTER (LEN=80)                   :: plot_label

   !  Local data.
   INTEGER , DIMENSION(:) , ALLOCATABLE :: i_start , i_end , j_start , j_end 
   INTEGER                              :: k_start , k_end
   INTEGER                              :: ids , ide , jds , jde , kds , kde , &
                                           ims , ime , jms , jme , kms , kme , &
                                           ips , ipe , jps , jpe , kps , kpe
   INTEGER                              :: ij , iteration
   INTEGER                              :: im , num_3d_m , ic , num_3d_c
   INTEGER                              :: loop, coarse_grid, label_length
   INTEGER                              :: i,j,k

   ! storage for horizontal output planes (xy slices)
   REAL , DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) :: work3d
   REAL , DIMENSION(grid%sd31:grid%ed31,grid%sd32:grid%ed32,grid%sd33:grid%ed33) :: global_fld
   REAL , DIMENSION(grid%sd31:grid%ed31,grid%sd32:grid%ed32) :: global_fld2d
   REAL , DIMENSION(grid%sd31:grid%ed31  ,grid%sd32:grid%ed32-1) :: xy_plane_u
   REAL , DIMENSION(grid%sd31:grid%ed31-1,grid%sd32:grid%ed32  ) :: xy_plane_v
   REAL , DIMENSION(grid%sd31:grid%ed31-1,grid%sd32:grid%ed32-1) :: xy_plane_m
   ! storage for y-slice vertical output planes (xz slices)
   REAL , DIMENSION(grid%sd31:grid%ed31  ,grid%sd33:grid%ed33-1) :: xz_plane_u
   REAL , DIMENSION(grid%sd31:grid%ed31-1,grid%sd33:grid%ed33  ) :: xz_plane_w
   REAL , DIMENSION(grid%sd31:grid%ed31-1,grid%sd33:grid%ed33-1) :: xz_plane_m
   ! storage for x-slice vertical output planes (yz slices)
   REAL , DIMENSION(grid%sd32:grid%ed32  ,grid%sd33:grid%ed33-1) :: yz_plane_v
   REAL , DIMENSION(grid%sd32:grid%ed32-1,grid%sd33:grid%ed33  ) :: yz_plane_w
   REAL , DIMENSION(grid%sd32:grid%ed32-1,grid%sd33:grid%ed33-1) :: yz_plane_m

   REAL , DIMENSION(:,:,:,:),  POINTER :: rm, rc

   INTEGER                            :: size1, size2

#ifdef DM_PARALLEL
   LOGICAL , EXTERNAL      :: wrf_on_monitor
#endif

   LOGICAL :: DEBUG, plot_xy, plot_xz, plot_yz

   SELECT CASE ( model_data_order )
      CASE ( DATA_ORDER_ZXY )
    glen(1) = grid%ed32-grid%sd32+1
    glen(2) = grid%ed33-grid%sd33+1
    glen(3) = grid%ed31-grid%sd31+1
    llen(1) = grid%em32-grid%sm32+1
    llen(2) = grid%em33-grid%sm33+1
    llen(3) = grid%em31-grid%sm31+1
      CASE ( DATA_ORDER_XYZ )
    glen(1) = grid%ed31-grid%sd31+1
    glen(2) = grid%ed32-grid%sd32+1
    glen(3) = grid%ed33-grid%sd33+1
    llen(1) = grid%em31-grid%sm31+1
    llen(2) = grid%em32-grid%sm32+1
    llen(3) = grid%em33-grid%sm33+1
   END SELECT

   debug = .false.
   plot_xy = .true.
   plot_xz = .true.
   plot_yz = .true.

   !  De-reference the information stored in the grid data structure.

   SELECT CASE ( model_data_order )
      CASE ( DATA_ORDER_ZXY )
   ids             = grid%sd32 
   ide             = grid%ed32 
   jds             = grid%sd33 
   jde             = grid%ed33 
   kds             = grid%sd31 
   kde             = grid%ed31

   ims             = grid%sm32 
   ime             = grid%em32 
   jms             = grid%sm33 
   jme             = grid%em33 
   kms             = grid%sm31 
   kme             = grid%em31

   ips             = grid%sp32
   ipe             = grid%ep32
   jps             = grid%sp33
   jpe             = grid%ep33
   kps             = grid%sp31
   kpe             = grid%ep31

   k_start         = grid%sd31
   k_end           = grid%ed31
      CASE ( DATA_ORDER_XYZ )
   ids             = grid%sd31 
   ide             = grid%ed31 
   jds             = grid%sd32 
   jde             = grid%ed32 
   kds             = grid%sd33 
   kde             = grid%ed33

   ims             = grid%sm31 
   ime             = grid%em31 
   jms             = grid%sm32 
   jme             = grid%em32 
   kms             = grid%sm33 
   kme             = grid%em33

   ips             = grid%sp31
   ipe             = grid%ep31
   jps             = grid%sp32
   jpe             = grid%ep32
   kps             = grid%sp33
   kpe             = grid%ep33

   k_start         = grid%sd33
   k_end           = grid%ed33
   END SELECT


   num_3d_m        = num_moist
   num_3d_c        = num_chem

! SEE THIS FILE FOR DEREFERENCE STATEMENTS FROM THE GRID
#include <state_derefs.inc>

!
!  presently, quick ncar graphics plots
!

! output ru, rv, rw, rt, and r

! begin with horizontal cross sections

  

#  ifndef NONCARG 
  IF(plot_xy) THEN

#if 0
! ht -----------------
  call rsl_write( global_fld2d, IO2D_IJ_INTERNAL, ht, grid%domdesc, RSL_REAL, glen(1), llen(1))
  if ( wrf_on_monitor() ) then
    label_length = 29
    k = kde/2
    DO j=jds,jde-1
    DO i=ids,ide-1
      xy_plane_m(i,j) = global_fld2d(i,j)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' HT AT TIME ',TIME,' K = ',k
    size1 = ide-ids
    size2 = jde-jds
    PLT2 
    call plot_array(xy_plane_m, size1, size2, plot_label, label_length)
  endif
#endif

! ru -----------------

CALL arb_look_dump( ru_1, 'FINKUS' , 0 , &
                    ids,ide,jds,jde,kds,kde, &
                    ims,ime,jms,jme,kms,kme, &
                    ips,ipe,jps,jpe,kps,kpe )


  call xpose3d(ru_2,work3d,ims,ime,jms,jme,kms,kme)
  call rsl_write( global_fld, IO3D_IJK_INTERNAL, work3d, grid%domdesc, RSL_REAL, glen(1), llen(1))
  if ( wrf_on_monitor() ) then
    label_length = 29
!    k = kde/2
    k = kde-4
    DO j=jds,jde-1
    DO i=ids,ide
      xy_plane_u(i,j) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RU AT TIME ',TIME,' K = ',k
    size1 = ide-ids+1
    size2 = jde-jds
    PLT3 
    call plot_array(xy_plane_u, size1, size2, plot_label, label_length)
    label_length = 29
    j = jde/2-1
    DO i=ids,ide
    DO k=kds,kde-1
      xz_plane_u(i,k) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RU AT TIME ',TIME,' J = ',j
    size1 = ide-ids+1
    size2 = kde-kds
    call plot_array(xz_plane_u, size1, size2, plot_label, label_length)
  endif

! rv -----------------

  call xpose3d(rv_2,work3d,ims,ime,jms,jme,kms,kme)
  call rsl_write( global_fld, IO3D_IJK_INTERNAL, work3d, grid%domdesc, RSL_REAL, glen(1), llen(1))
  if ( wrf_on_monitor() ) then
    label_length = 29
!    k = kde/2
    k = kde-4
    DO j=jds,jde
    DO i=ids,ide-1
      xy_plane_v(i,j) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RV AT TIME ',TIME,' K = ',k
    size1 = ide-ids
    size2 = jde-jds+1
    PLT3 
    call plot_array(xy_plane_v, size1, size2, plot_label, label_length)

    label_length = 29
    j = jde/2-1
    DO i=ids,ide-1
    DO k=kds,kde-1
      xz_plane_m(i,k) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RV AT TIME ',TIME,' J = ',j
    size1 = ide-ids
    size2 = kde-kds
    call plot_array(xz_plane_m, size1, size2, plot_label, label_length)
  endif

! rw -----------------

  call xpose3d(rom_2,work3d,ims,ime,jms,jme,kms,kme)
  call rsl_write( global_fld, IO3D_IJK_INTERNAL, work3d, grid%domdesc, RSL_REAL, glen(1), llen(1))
  if ( wrf_on_monitor() ) then
    label_length = 29
    k = kde/2
    DO j=jds,jde-1
    DO i=ids,ide-1
      xy_plane_m(i,j) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' OM AT TIME ',TIME,' K = ',k
    size1 = ide-ids
    size2 = jde-jds
    PLT3 
    call plot_array(xy_plane_m, size1, size2, plot_label, label_length)

    label_length = 29
    j = jde/2-1
    DO i=ids,ide-1
    DO k=kds,kde
      xz_plane_w(i,k) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' OM AT TIME ',TIME,' J = ',j
    size1 = ide-ids
    size2 = kde-kds+1
    call plot_array(xz_plane_w, size1, size2, plot_label, label_length)

  endif

! rt -----------------

  call xpose3d(rtp_2,work3d,ims,ime,jms,jme,kms,kme)
  call rsl_write( global_fld, IO3D_IJK_INTERNAL, work3d, grid%domdesc, RSL_REAL, glen(1), llen(1))
  if ( wrf_on_monitor() ) then
    label_length = 29
    k = kde/2
    DO j=jds,jde-1
    DO i=ids,ide-1
      xy_plane_m(i,j) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RT AT TIME ',TIME,' K = ',k
    size1 = ide-ids
    size2 = jde-jds
    PLT3 
    call plot_array(xy_plane_m, size1, size2, plot_label, label_length)

    label_length = 29
    j = jde/2-1
    DO i=ids,ide-1
    DO k=kds,kde-1
      xz_plane_m(i,k) = global_fld(i,j,k)
    ENDDO
    ENDDO
    write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RT AT TIME ',TIME,' J = ',j
    size1 = ide-ids
    size2 = kde-kds
    call plot_array(xz_plane_m, size1, size2, plot_label, label_length)

  endif

  END IF

#  endif
#endif

 END SUBROUTINE quick_look_dump_dm

!-----------------------------------------------------------------


