!WRF:MEDIATION_LAYER:ADT_BARRIER
!

SUBROUTINE solve_interface ( grid ) 

   USE module_domain
   USE module_timing
   USE module_driver_constants
   USE module_configure
   USE module_wrf_error

   IMPLICIT NONE

   INTERFACE
#include  <solve.int>
   END INTERFACE

   TYPE(domain) , INTENT(INOUT)  :: grid
   TYPE (grid_config_rec_type)   :: config_flags

#ifdef DEREF_KLUDGE
   INTEGER     :: sm31 , em31 , sm32 , em32 , sm33 , em33
#endif

   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )

#ifdef DEREF_KLUDGE
   sm31             = grid%sm31
   em31             = grid%em31
   sm32             = grid%sm32
   em32             = grid%em32
   sm33             = grid%sm33
   em33             = grid%em33
#endif

! JM/BS IJK MOD
   IF (config_flags%dyn_opt == 1) THEN

     CALL wrf_error_fatal ( 'leapfrog solver not yet implemented ' )

   ELSE IF ( ( config_flags%dyn_opt == 2) .or.          &
             ( config_flags%dyn_opt == 3)      ) THEN

     CALL solve_rk  ( grid ,            &
!
#include <rk_actual_args.inc>
!
               )
   ELSE

     WRITE( wrf_err_message , * ) 'Invalid dynamics option: dyn_opt = ',config_flags%dyn_opt
     CALL wrf_error_fatal ( TRIM ( wrf_err_message ) )
     
   END IF

   grid%total_time_steps = grid%total_time_steps + 1

END SUBROUTINE solve_interface
