!WRF:DRIVER_LAYER:MAIN
!

PROGRAM wrf

   USE module_machine
   USE module_domain
   USE module_start
   USE module_integrate
   USE module_driver_constants
   USE module_io_domain
   USE module_bc
   USE module_configure

   USE module_timing
   USE module_wrf_error
#ifdef DM_PARALLEL
   USE module_dm
#endif

   IMPLICIT NONE

   REAL    :: time

   INTEGER :: loop , &
              levels_to_process

   TYPE(domain) , POINTER :: keep_grid, grid_ptr, null_domain
   TYPE(domain)           :: dummy
   TYPE (grid_config_rec_type)              :: config_flags
   INTEGER                :: number_at_same_level
   INTEGER                :: time_step_begin_restart

   INTEGER :: max_dom , domain_id , fid , oid , idum1 , idum2 , ierr
   INTEGER :: debug_level
   LOGICAL :: input_from_file
#ifdef DM_PARALLEL
   INTEGER                 :: nbytes
   INTEGER, PARAMETER      :: configbuflen = 8*1024
   INTEGER*1               :: configbuf( configbuflen )
   LOGICAL , EXTERNAL      :: wrf_on_monitor
#endif

   CHARACTER (LEN=80)     :: rstname
   CHARACTER (LEN=80)     :: message

   !  Define the name of this program (program_name defined in module_domain)

   program_name = "WRF MODEL"

   !  Get the NAMELIST data for input.

   CALL init_modules

#ifdef DM_PARALLEL
   IF ( wrf_on_monitor() ) THEN
     CALL initial_config
   ENDIF
   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )
   CALL initial_dm_parallel
#else
   CALL initial_config
#endif

   CALL get_debug_level ( debug_level )
   CALL set_wrf_debug_level ( debug_level )

   !  An available simple timer from the timing module.

   CALL start_timing

   ! allocated and configure the mother domain

   NULLIFY( null_domain )

   CALL wrf_debug ( 100 , 'wrf: calling alloc_and_configure_domain ' )
   CALL alloc_and_configure_domain ( domain_id  = 1 ,                  &
                                     local_time = 0 ,                  &
                                     grid       = head_grid ,          &
                                     parent     = null_domain ,        &
                                     kid        = -1                   )

   CALL wrf_debug ( 100 , 'wrf: calling model_to_grid_config_rec ' )
   CALL model_to_grid_config_rec ( head_grid%id , model_config_rec , config_flags )
   CALL wrf_debug ( 100 , 'wrf: calling set_scalar_indices_from_config ' )
   CALL set_scalar_indices_from_config ( head_grid%id , idum1, idum2 )

   CALL end_timing ('main: allocate domains and fields')

   CALL get_time_step_begin_restart( time_step_begin_restart )

   CALL wrf_debug ( 100 , 'wrf: calling init_wrfio' )
   CALL init_wrfio

   IF ( time_step_begin_restart .EQ. 0 ) THEN

     !  Initialize the mother domain.

     CALL start_timing

     head_grid%input_from_file = .true.
     IF ( head_grid%input_from_file ) THEN

        CALL wrf_debug ( 100 , 'wrf main: calling open_r_dataset for wrfinput' )
        CALL open_r_dataset ( fid, 'wrfinput', head_grid , config_flags , ierr )
        IF ( ierr .NE. 0 ) THEN
          WRITE( wrf_err_message , * ) 'program wrf: error opening wrfinput for reading ierr=',ierr
	  CALL WRF_ERROR_FATAL ( wrf_err_message )
	ENDIF
         
        CALL wrf_debug ( 100 , 'wrf: calling input_initial' )
        CALL input_initial ( fid ,   head_grid , config_flags , ierr )
        CALL wrf_debug ( 100 , 'wrf: back from input_initial' )
        CALL close_dataset ( fid , config_flags )
!initialize the lbc reading mechanism to read in the first set of lbcs
        CALL set_time_to_read_again ( -1. )

!      CALL open_r_dataset ( fid, 'wrfbdy', head_grid , config_flags , ierr )
!      IF ( ierr .NE. 0 ) THEN
!        CALL WRF_ERROR_FATAL ( 'program wrf: error opening wrfbdy for reading' )
!      ENDIF
! write(0,*)'wrbdy opened : fid ', fid
!      CALL input_boundary ( fid,   head_grid , config_flags , ierr )
!      CALL close_dataset ( fid , config_flags )

     ENDIF
     CALL start_domain ( head_grid )
   ELSE
     CALL construct_filename ( rstname , 'wrfrst' , head_grid%id , 2 , time_step_begin_restart , 6 )
     WRITE(6,*)'opening ',TRIM(rstname),' for reading'
     CALL open_r_dataset ( fid , TRIM(rstname) , head_grid , config_flags , ierr )
     IF ( ierr .NE. 0 ) THEN
       WRITE( message , '("program wrf: error opening ",A32," for reading")') TRIM(rstname)
       CALL WRF_ERROR_FATAL ( message )
     ENDIF
     CALL input_restart ( fid,   head_grid , config_flags , ierr )
     CALL close_dataset ( fid , config_flags )
     CALL start_domain ( head_grid )
     head_grid%total_time_steps = time_step_begin_restart
   ENDIF

#ifdef DM_PARALLEL
   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )
#endif

   CALL end_timing ('main: start fields')

   !  The forecast integration for the most coarse grid is now started.  The
   !  integration is from the first step (1) to the last step of the simulation.


   CALL wrf_debug ( 100 , 'wrf: calling integrate' )
   CALL integrate ( head_grid , head_grid%total_time_steps+1 , head_grid%time_step_max ) 
   CALL wrf_debug ( 100 , 'wrf: back from integrate' )


   WRITE ( message , FMT = '("main: time step #",I8)' ) head_grid%time_step_max
!   CALL end_timing ( TRIM(message) )

!  Here we deallocate all of the domains.  For the de-allocation of a specific domain, the various
!  linked-list connections would need to be re-established.  This routine is from the data_structure
!  module.

!   CALL start_timing
!   dealloc : DO loop =  max_dom , 2 , -1
!      CALL dealloc_space_domain ( id(loop) )
!   END DO dealloc
!   CALL end_timing ('main: deallocate domains and fields')

   IF ( head_grid%oid > 0 ) CALL close_dataset ( head_grid%oid , config_flags )

   CALL wrf_shutdown

   STOP

END PROGRAM wrf


