
sub write_wrf_io {

  my $fid , $fidin , $fidout ;
  my $key ;

open WRFHISTOUT, ">$wrf_root/inc/wrf_histout.inc" or 
  die "Cannot open $wrf_root/inc/wrf_histout.inc for writing" ;
open WRFRESTARTOUT, ">$wrf_root/inc/wrf_restartout.inc" or 
  die "Cannot open $wrf_root/inc/wrf_restartout.inc for writing" ;
open WRFINITIALOUT, ">$wrf_root/inc/wrf_initialout.inc" or 
  die "Cannot open $wrf_root/inc/wrf_initialout.inc for writing" ;
open WRFBDYOUT, ">$wrf_root/inc/wrf_bdyout.inc" or 
  die "Cannot open $wrf_root/inc/wrf_bdyout.inc for writing" ;

open WRFHISTIN, ">$wrf_root/inc/wrf_histin.inc" or 
  die "Cannot open $wrf_root/inc/wrf_histin.inc for writing" ;
open WRFRESTARTIN, ">$wrf_root/inc/wrf_restartin.inc" or 
  die "Cannot open $wrf_root/inc/wrf_restartin.inc for writing" ;
open WRFINITIALIN, ">$wrf_root/inc/wrf_initialin.inc" or 
  die "Cannot open $wrf_root/inc/wrf_initialin.inc for writing" ;
open WRFBDYIN, ">$wrf_root/inc/wrf_bdyin.inc" or 
  die "Cannot open $wrf_root/inc/wrf_bdyin.inc for writing" ;

open WRFMETAGET, ">$wrf_root/inc/wrf_metaget.inc" or 
  die "Cannot open $wrf_root/inc/wrf_metaget.inc for writing" ;
open WRFMETASET, ">$wrf_root/inc/wrf_metaset.inc" or 
  die "Cannot open $wrf_root/inc/wrf_metaset.inc for writing" ;

foreach $fid ( WRFHISTOUT, WRFRESTARTOUT, WRFINITIALOUT, WRFBDYOUT )
{
print $fid "!\n" ;
print $fid "! WARNING This file is generated automatically by use_registry\n" ;
print $fid "! using the data base in the file named Registry.\n" ;
print $fid "! Do not edit.  Your changes to this file will be lost.\n" ;
print $fid "!\n" ;
}

foreach $fid ( WRFHISTIN, WRFRESTARTIN, WRFINITIALIN, WRFBDYIN )
{
print $fid "!\n" ;
print $fid "! WARNING This file is generated automatically by use_registry\n" ;
print $fid "! using the data base in the file named Registry.\n" ;
print $fid "! Do not edit.  Your changes to this file will be lost.\n" ;
print $fid "\n" ;
}

print WRFMETASET "!\n" ;
print WRFMETASET "! WARNING This file is generated automatically by use_registry\n" ;
print WRFMETASET "! using the data base in the file named Registry.\n" ;
print WRFMETASET "! Do not edit.  Your changes to this file will be lost.\n" ;
print WRFMETASET "!\n" ;

print WRFMETAGET "!\n" ;
print WRFMETAGET "! WARNING This file is generated automatically by use_registry\n" ;
print WRFMETAGET "! using the data base in the file named Registry.\n" ;
print WRFMETAGET "! Do not edit.  Your changes to this file will be lost.\n" ;
print WRFMETAGET "!\n" ;

{
  my $uniqtag_wrfio ;
  foreach $_ ( @inline )                                         ## iterate through input lines
  {                                                              ##
    s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
    if ( $t[$table] ne "state" ) { next ; }                      ## only state entries

    if ( ! $multfieldarrays{$t[$use]} && ($t[$io] eq "m") && ($t[$dims] eq "-") )
    {
        $ttag = "" ;
        if    ( $t[$type] eq "real" )    { $ttag = "r" ; }
        elsif ( $t[$type] eq "integer" ) { $ttag = "i" ; } 
        if ( $ttag )
        {
          print WRFMETAGET "CALL get_bh$ttag ( '$t[$dname]' , $t[$sym] )\n" ;
          print WRFMETASET "CALL set_bh$ttag ( '$t[$dname]' , $t[$sym] )\n" ;
        }
    }

    if ( $t[$type] ne "real" ) { next ; }                       ## only real entries
    $s1 = uc $t[$sym] ;
    $s2 = substr($s1,0,9) ;
    $d1 = uc $t[$dname] ;
    $d1 =~ s/$spc/ / ;
    $d2 = substr($d1,0,9) ;

    $p1 = uc $t[$use] ;
    $dimstr = substr($t[$dims],0,3) ;
    $soilvert = 0 ;
    if    ( $dimstr eq "ikj" )                     { $ndims = 3 ; $memorder = 'XZY' ; }
    elsif ( $dimstr eq "ilj" )                     { $ndims = 3 ; $memorder = 'XZY' ; $soilvert = 1 ; }
    elsif ( $dimstr eq "ij" || $dimstr eq "ji" )   { $ndims = 2 ; $memorder = 'XY' ; }
    elsif ( $dimstr eq "k" )                       { $ndims = 1 ; $memorder = 'Z' ; }
    elsif ( $dimstr eq "l" )                       { $ndims = 1 ; $memorder = 'Z' ; $soilvert = 1 ; }
    elsif ( $dimstr eq "kb" )                      { $ndims = 3 ; $memorder = 'deferred' ; }
    elsif ( $dimstr eq "lb" )                      { $ndims = 3 ; $memorder = 'deferred' ; $soilvert = 1 ; }
    elsif ( $dimstr eq "1b" )                      { $ndims = 2 ; $memorder = 'deferred' ; }
    elsif ( $dimstr eq "b" )                       { $ndims = 1 ; $memorder = 'deferred' ; }
    else                                           { $ndims = 0 ; $memorder = '0' ; }

# this is to avoid having to allocate a fully 3d version of a global integer buffers in module_io_wrf.F
    if ( $ndims == 3 && $t[$type] eq "integer" )
    {
      print "Registry WARNING: this configuration of WRF does not support 3D integer state arrays: $t[$sym]\n" ;
    }

    $xdomainend = "(ide-1)" ;
    $ydomainend = "(jde-1)" ;
    $zdomainend = "(kde-1)" ;
    if ( index( $t[$stag] , "x" ) >= 0 )            { $xdomainend = "ide" ; }
    if ( index( $t[$stag] , "y" ) >= 0 )            { $ydomainend = "jde" ; }
    if ( index( $t[$stag] , "z" ) >= 0 )            { $zdomainend = "kde" ; }

    $desc_string = $t[$desc] ;
    $desc_string =~ s/`/ /g ;
    $desc_string = uc ( $desc_string ) ;
    $desc_string = "N.A." if ( $desc_string eq "" ) ;

    $units_string =  $t[$units] ;
    $units_string =~ s/`/ /g ;
    $units_string = uc ( $units_string ) ;
    $units_string = "N.A." if ( $units_string eq "" ) ;

    $i = "2" ;
    if    ( $t[$ntl] eq "1" || $t[$ntl] eq "-" )
      { $tag = "" }
    else
      { $tag = "_".$i }

    if ( ! $uniqtag_wrfio{ "$t[$sym]"."$tag" } )
    {
      if    ( ! $multfieldarrays{$t[$use]} && ( $dimstr eq "kb" || $dimstr eq "lb" || $dimstr eq "1b" || $dimstr eq "b" ) )
      {
        if ( $dimstr ne "b" )
        {
          for ( $ibdy = 1 ; $ibdy <= 4 ; $ibdy ++ )
          {

            if      ( $ibdy == 1 ) { $bdytag = "XS" ;      # west bdy
            } elsif ( $ibdy == 2 ) { $bdytag = "XE" ;      # east bdy
            } elsif ( $ibdy == 3 ) { $bdytag = "YS" ;      # south bdy
            } elsif ( $ibdy == 4 ) { $bdytag = "YE" ;      # north bdy
            }
            if ( index( $dimstr , "k" ) >= 0 || index( $dimstr , "l" ) >= 0 ) { $memorder = $bdytag . "Z" ; }

            foreach $fid ( WRFBDYOUT , WRFBDYIN )
            {
# First (full) dimension
              if ( $ibdy == 1 || $ibdy == 2 ) { $ds1 = 1 ; $de1 = $ydomainend ;
                                                $ms1 = 1 ; $me1 = "MAX( ide , jde )" ;
                                                $ps1 = 1 ; $pe1 = $ydomainend ; 
						$dimname1 = "SOUTH-NORTH" ;
						$dimname1 = $dimname1."-STAG" if ( index( $t[$stag] , "y" ) >= 0 ) ;
						$dimname2 = "BOT-TOP" ;
						$dimname3 = "BDY-WIDTH" ;
                                              }
              if ( $ibdy == 3 || $ibdy == 4 ) { $ds1 = 1 ; $de1 = $xdomainend ;
                                                $ms1 = 1 ; $me1 = "MAX( ide , jde )" ;
                                                $ps1 = 1 ; $pe1 = $xdomainend ; 
						$dimname1 = "WEST-EAST" ;
						$dimname1 = $dimname1."-STAG" if ( index( $t[$stag] , "x" ) >= 0 ) ;
						$dimname2 = "BOT-TOP" ;
						$dimname3 = "BDY-WIDTH" ;
                                              }
# Second (bdy width) dimension
              $ds3 = 1 ; $de3 = "config_flags%spec_bdy_width" ;
              $ms3 = 1 ; $me3 = "config_flags%spec_bdy_width" ;
              $ps3 = 1 ; $pe3 = "config_flags%spec_bdy_width" ;

# Z
              if ( $ndims == 3 )
              {
                if    ( $soilvert == 1 )
                {
                  $ds2 = 1  ; $de2 = "config_flags%num_soil_layers" ;
                  $ps2 = 1  ; $pe2 = "config_flags%num_soil_layers" ;
                  $ms2 = 1  ; $me2 = "config_flags%num_soil_layers" ;
                }
                else
                {
                  $ds2 = 1     ; $de2 = $zdomainend ;
                  $ps2 = 1     ; $pe2 = "MIN( $zdomainend , kpe )" ;
                  $ms2 = "kms" ; $me2 = "kme" ;
                }
              }
            }

            $fidout = WRFBDYOUT ;
            $lcname = uc substr( $d1, 0 , 9 ) . $bdytag ;

            if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
            {
              print $fidout "IF ( wrf_on_monitor() ) THEN\n" ;
	    }
            print $fidout "CALL wrf_ext_write_field (   &\n"                                  ;
            print $fidout "                       fid ,               &  ! DataHandle\n"  ;
            print $fidout "                       current_date(1:19), &  ! DateStr\n"     ;
            print $fidout "                       '$lcname' ,         &  ! Data Name\n"   ;
            print $fidout "                       grid%${s1}${tag}  ( 1, 1 , 1 , $ibdy ) ,  &  ! Field\n"       ;
            print $fidout "                       WRF_REAL ,          &  ! FieldType\n"   ;
            print $fidout "                       grid%communicator , &  ! Comm\n"        ;
            print $fidout "                       grid%domdesc ,      &  ! DomainDesc\n"  ;
            print $fidout "                       dryrun ,    &  ! flag \n"  ;
            print $fidout "                       '$memorder' ,       &  ! MemoryOrder\n" ;
            print $fidout "      '$dimname1',             &  ! Dimnames\n" ;   # JM 1109
            print $fidout "      '$dimname2',             &  ! Dimnames\n" ;   # JM 1109
            print $fidout "      '$dimname3',             &  ! Dimnames\n" ;   # JM 1109
            print $fidout "      '$desc_string',             &  ! \n" ;   # JM 1109
            print $fidout "      '$units_string',            &  ! \n" ;   # JM 1109
            print $fidout "'wrf_bdyout.inc: ext_write_field $lcname memorder $memorder' , & ! Debug message\n" ;
            print $fidout "$ds1 , $de1 , $ds2 , $de2 , $ds3 , $de3 ,                &\n"  ;
            print $fidout "$ms1 , $me1 , $ms2 , $me2 , $ms3 , $me3 ,                &\n"  ;
            print $fidout "$ps1 , $pe1 , $ps2 , $pe2 , $ps3 , $pe3 ,                &\n"  ;
            print $fidout "                       ierr )\n"                               ;
            if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
            {
              print $fidout "ENDIF\n" ;
	    }

            $fidin = WRFBDYIN ;
            if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
            {
              print $fidin "IF ( wrf_on_monitor() ) THEN\n" ;
	    }
            print $fidin "CALL wrf_ext_read_field (   &\n"                                  ;
            print $fidin "                       fid ,               &  ! DataHandle\n"  ;
            print $fidin "                       current_date(1:19), &  ! DateStr\n"     ;
            print $fidin "                       '$lcname' ,         &  ! Data Name\n"   ;
            print $fidin "                       grid%${s1}${tag}  ( 1, 1 , 1 , $ibdy ) ,  &  ! Field\n"       ;
            print $fidin "                       WRF_REAL ,          &  ! FieldType\n"   ;
            print $fidin "                       grid%communicator , &  ! Comm\n"        ;
            print $fidin "                       grid%domdesc ,      &  ! DomainDesc\n"  ;
            print $fidin "                       '$memorder' ,       &  ! MemoryOrder\n" ;
            print $fidin "'wrf_bdyin.inc: ext_read_field $lcname memorder $memorder' , & ! Debug message\n" ;
            print $fidin "$ds1 , $de1 , $ds2 , $de2 , $ds3 , $de3 ,                &\n"  ;
            print $fidin "$ms1 , $me1 , $ms2 , $me2 , $ms3 , $me3 ,                &\n"  ;
            print $fidin "$ps1 , $pe1 , $ps2 , $pe2 , $ps3 , $pe3 ,                &\n"  ;
            print $fidin "                       ierr )\n"                               ;
            if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
            {
              print $fidin "ENDIF\n" ;
	      print $fidin "CALL wrf_dm_bcast_$t[$type] ( grid%${s1}${tag}  ( 1, 1 , 1 , $ibdy ) , &\n" ;
	      print $fidin "       (($me1)-($ms1)+1)*(($me2)-($ms2)+1)*(($me3)-($ms3)+1)  )\n" ;
	    }

          }
        }
      }
      elsif ( ( ! $multfieldarrays{$t[$use]} && $t[$io] ne "-" ) || 
              ( ($s1 ne "-") && $multfieldarrays{$t[$use]} && ($t[$use] ne "rconfig") && $t[$io] ne "-" )
            )
      {
        for ( $i = 0 ; $i < length( $t[$io] ) ; $i++ )
        {
          $code = substr( $t[$io] , $i , 1 ) ;
          if    ( $code eq "r" )
          {
            $fidin  = WRFRESTARTIN ;
            $fidout = WRFRESTARTOUT ;
          }
          elsif ( $code eq "h" )
          {
            $fidin  = WRFHISTIN ;
            $fidout = WRFHISTOUT ;
          }
          elsif ( $code eq "i" )
          {
            $fidin  = WRFINITIALIN ;
            $fidout = WRFINITIALOUT ;
          }

# in the case of a restart, generate code for both time levels; otherwise generate a copy
label1:
          $thevname = "grid %${s1}${tag}" ;
          $thevname = "grid %$t[$use]${tag}(ims,kms,jms,P_$s1)" if ( $multfieldarrays{$t[$use]} ) ;
          $lcname = uc substr( $d1, 0 , 9 ) ;
          $lcname = $lcname.$tag if ( $code eq "r" ) ;

#            print $fidout uc substr( $d1, 0 , 9 ) ;
#            print $fidout $tag if ( $code eq "r" ) ;
#            print $fidout "' ,&\n" ;



          foreach $fid ( $fidout , $fidin )
          {
            if ( $ndims == 3 )
            {
# X
              $ds1 = "ids" ; $de1 = $xdomainend ;
              $ps1 = "ips" ; $pe1 = "MIN( $xdomainend , ipe )" ;
              $ms1 = "ims" ; $me1 = "ime" ;
	      $dimname1 = "WEST-EAST" ;
	      $dimname1 = $dimname1."-STAG" if ( index( $t[$stag] , "x" ) >= 0 ) ;
# Y
              $ds3 = "jds" ; $de3 = $ydomainend ;
              $ps3 = "jps" ; $pe3 = "MIN( $ydomainend , jpe )" ;
              $ms3 = "jms" ; $me3 = "jme" ;
	      $dimname3 = "SOUTH-NORTH" ;
	      $dimname3 = $dimname3."-STAG" if ( index( $t[$stag] , "y" ) >= 0 ) ;
# Z
              if    ( $soilvert == 1 )
              {
                $ds2 = 1   ; $de2 = "config_flags%num_soil_layers" ;
                $ps2 = 1   ; $pe2 = "config_flags%num_soil_layers" ;
                $ms2 = 1   ; $me2 = "config_flags%num_soil_layers" ;
	        $dimname2 = "TOP-BOT-SOIL" ;
              }
              else
              {
                $ds2 = 1     ; $de2 = $zdomainend ;
                $ps2 = 1     ; $pe2 = "MIN( $zdomainend , kpe )" ;
                $ms2 = "kms" ; $me2 = "kme" ;
	        $dimname2 = "BOT-TOP" ;
	        $dimname2 = $dimname2."-STAG" if ( index( $t[$stag] , "z" ) >= 0 ) ;
              }
            }
            elsif ( $ndims == 2 )
            {
# X
              $ds1 = "ids" ; $de1 = $xdomainend ;
              $ps1 = "ips" ; $pe1 = "MIN( $xdomainend , ipe )" ;
              $ms1 = "ims" ; $me1 = "ime" ;
	      $dimname1 = "WEST-EAST" ;
	      $dimname1 = $dimname1."-STAG" if ( index( $t[$stag] , "x" ) >= 0 ) ;
# Y
              $ds2 = "jds" ; $de2 = $ydomainend ;
              $ps2 = "jps" ; $pe2 = "MIN( $ydomainend , jpe )" ;
              $ms2 = "jms" ; $me2 = "jme" ;
	      $dimname2 = "SOUTH-NORTH" ;
	      $dimname2 = $dimname2."-STAG" if ( index( $t[$stag] , "y" ) >= 0 ) ;

              $dimname3 = "" ;

              $ds3 = 1 ; $de3 = 1 ;
              $ps3 = 1 ; $pe3 = 1 ;
              $ms3 = 1 ; $me3 = 1 ;
            }
            elsif ( $ndims == 1 )
            {
# Z
              if    ( $soilvert == 1 )
              {
                $ds1 = 1  ; $de1 = "config_flags%num_soil_layers" ;
                $ps1 = 1  ; $pe1 = "config_flags%num_soil_layers" ;
                $ms1 = 1  ; $me1 = "config_flags%num_soil_layers" ;
	        $dimname1 = "TOP-BOT-SOIL" ;
              }
              else
              {
                $ds1 = 1     ; $de1 = $zdomainend ;
                $ps1 = 1     ; $pe1 = "MIN( $zdomainend , kpe )" ;
                $ms1 = "kms" ; $me1 = "kme" ;
	        $dimname1 = "BOT-TOP" ;
	        $dimname1 = $dimname1."-STAG" if ( index( $t[$stag] , "z" ) >= 0 ) ;
              }
              $dimname2 = "" ;
              $dimname3 = "" ;
              $ds2 = 1 ; $de2 = 1  ;
              $ps2 = 1 ; $pe2 = 1  ;
              $ms2 = 1 ; $me2 = 1  ;
              $ds3 = 1 ; $de3 = 1  ;
              $ps3 = 1 ; $pe3 = 1  ;
              $ms3 = 1 ; $me3 = 1  ;
            }
            elsif ( $ndims == 0 )
            {
              $dimname1 = "" ;
              $dimname2 = "" ;
              $dimname3 = "" ;
              $ds1 = 1 ; $de1 = 1  ;
              $ps1 = 1 ; $pe1 = 1  ;
              $ms1 = 1 ; $me1 = 1  ;
              $ds2 = 1 ; $de2 = 1  ;
              $ps2 = 1 ; $pe2 = 1  ;
              $ms2 = 1 ; $me2 = 1  ;
              $ds3 = 1 ; $de3 = 1  ;
              $ps3 = 1 ; $pe3 = 1  ;
              $ms3 = 1 ; $me3 = 1  ;
            }
          }

          if ( $multfieldarrays{$t[$use]} )
	  {
            print $fidout "IF ( P_$s1 .GE. PARAM_FIRST_SCALAR ) THEN\n" ;
	  }
          if ( $ndims == 3 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            print $fidout "IF ( .NOT. dryrun ) call dm_patch_to_global_$t[$type] ( $thevname , globbuf_$t[$type] ,&\n" ;
            print $fidout "                                    grid%domdesc, $ndims  ,&\n" ;
            if ( $soilvert == 1 )
            {
              print $fidout "        ids,ide,jds,jde,1,config_flags%num_soil_layers,&\n" ;
#              print $fidout "        $ds1,$de1,$ds3,$de3,1,config_flags%num_soil_layers,  &\n" ;
              print $fidout "        ims,ime,jms,jme,1,config_flags%num_soil_layers,&\n" ;
              print $fidout "        ips,ipe,jps,jpe,1,config_flags%num_soil_layers )\n" ;
            }
            else
            {
              print $fidout "        ids,ide,jds,jde,kds,kde,  &\n" ;
#              print $fidout "        $ds1,$de1,$ds3,$de3,$ds2,$de2,  &\n" ;
              print $fidout "        ims,ime,jms,jme,kms,kme,  &\n" ;
              print $fidout "        ips,ipe,jps,jpe,kps,kpe ) \n" ;
            }
          }
          elsif ( $ndims == 2 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            print $fidout "IF ( .NOT. dryrun ) call dm_patch_to_global_$t[$type] ( $thevname , globbuf_$t[$type] ,&\n" ;
            print $fidout "                                    grid%domdesc, $ndims  ,&\n" ;
            print $fidout "        ids,ide,jds,jde,1,1,  &\n" ;
#            print $fidout "        $ds1,$de1,$ds2,$de2,1,1,  &\n" ;
            print $fidout "        ims,ime,jms,jme,1,1,  &\n" ;
            print $fidout "        ips,ipe,jps,jpe,1,1 ) \n" ;
          }
          if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            print $fidout "IF ( wrf_on_monitor() ) THEN\n" ;
#	    $ms1 = $ds1 ; $ms2 = $ds2 ; $ms3 = $ds3 ; $me1 = $de1 ; $me2 = $de2 ; $me3 = $de3 ;
#	    $ps1 = $ds1 ; $ps2 = $ds2 ; $ps3 = $ds3 ; $pe1 = $de1 ; $pe2 = $de2 ; $pe3 = $de3 ;
	  }
          print $fidout "CALL wrf_ext_write_field (   &\n"                                  ;
          print $fidout "                       fid ,               &  ! DataHandle\n"  ;
          print $fidout "                       current_date(1:19), &  ! DateStr\n"     ;
          print $fidout "                       '$lcname' ,         &  ! Data Name\n"   ;
          if ( $ndims >= 2 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          { print $fidout "                       globbuf_$t[$type]          ,  &  ! Field\n"       ; }
          else
          { print $fidout "                       $thevname        ,  &  ! Field\n"       ; }
          print $fidout "                       WRF_REAL ,          &  ! FieldType\n"   ;
          print $fidout "                       grid%communicator , &  ! Comm\n"        ;
          print $fidout "                       grid%domdesc ,      &  ! DomainDesc\n"  ;
          print $fidout "                       dryrun ,    &  ! flag \n"  ;
          print $fidout "                       '$memorder' ,       &  ! MemoryOrder\n" ;
          print $fidout "      '$dimname1',             &  ! Dimnames\n" ;   # JM 1109
          print $fidout "      '$dimname2',             &  ! Dimnames\n" ;   # JM 1109
          print $fidout "      '$dimname3',             &  ! Dimnames\n" ;   # JM 1109
          print $fidout "      '$desc_string',             &  ! \n" ;   # JM 1109
          print $fidout "      '$units_string',            &  ! \n" ;   # JM 1109
          print $fidout "'ext_write_field $lcname memorder $memorder' , & ! Debug message\n" ;
          print $fidout "$ds1 , $de1 , $ds2 , $de2 , $ds3 , $de3 ,                &\n"  ;
          if    ( $ndims == 3 &&  ! $sw_distrib_io_layer && $sw_dm_parallel )
	  {
            if ( $soilvert == 1 )
	    { print $fidout "ids , ide , 1 , config_flags%num_soil_layers , jds , jde ,    &\n"  ;
              print $fidout "ids , ide , 1 , config_flags%num_soil_layers , jds , jde ,    &\n"  ; }
	    else
	    { print $fidout "ids , ide , kds , kde , jds , jde ,    &\n"  ;
              print $fidout "ids , ide , kds , kde , jds , jde ,    &\n"  ; }
	  }
          elsif ( $ndims == 2 &&  ! $sw_distrib_io_layer && $sw_dm_parallel )
	    { print $fidout "ids , ide , jds , jde , 1 , 1 ,                &\n"  ;
              print $fidout "ids , ide , jds , jde , 1 , 1 ,                &\n"  ; }
	  else
            { print $fidout "$ms1 , $me1 , $ms2 , $me2 , $ms3 , $me3 ,                &\n"  ;
              print $fidout "$ps1 , $pe1 , $ps2 , $pe2 , $ps3 , $pe3 ,                &\n"  ; }
          print $fidout "                       ierr )\n"                               ;
          if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
          { 
            print $fidout "ENDIF\n" ;
          }
          if ( $multfieldarrays{$t[$use]} )
	  {
            print $fidout "ENDIF\n" ;  #  P_$s1 .GE. PARAM_FIRST_SCALAR
	  }

          if ( $multfieldarrays{$t[$use]} )
	  {
            print $fidin "  IF ( P_$s1 .GE. PARAM_FIRST_SCALAR ) THEN\n" ;
	  }
          if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
          { 
            print $fidin "IF ( wrf_on_monitor() ) THEN\n" ;
#	    $ms1 = $ds1 ; $ms2 = $ds2 ; $ms3 = $ds3 ; $me1 = $de1 ; $me2 = $de2 ; $me3 = $de3 ;
#	    $ps1 = $ds1 ; $ps2 = $ds2 ; $ps3 = $ds3 ; $pe1 = $de1 ; $pe2 = $de2 ; $pe3 = $de3 ;
          }
          print $fidin "CALL wrf_ext_read_field (   &\n"                                  ;
          print $fidin "                       fid ,               &  ! DataHandle\n"  ;
          print $fidin "                       current_date(1:19), &  ! DateStr\n"     ;
          print $fidin "                       '$lcname' ,         &  ! Data Name\n"   ;
          if ( $ndims >= 2 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          { print $fidin "                       globbuf_$t[$type]          ,  &  ! Field\n"       ; }
          else
          { print $fidin "                       $thevname        ,  &  ! Field\n"       ; }
          print $fidin "                       WRF_REAL ,          &  ! FieldType\n"   ;
          print $fidin "                       grid%communicator , &  ! Comm\n"        ;
          print $fidin "                       grid%domdesc ,      &  ! DomainDesc\n"  ;
          print $fidin "                       '$memorder' ,       &  ! MemoryOrder\n" ;
          print $fidin "'ext_read_field $lcname memorder $memorder' , & ! Debug message\n" ;
          print $fidin "$ds1 , $de1 , $ds2 , $de2 , $ds3 , $de3 ,                &\n"  ;
          if    ( $ndims == 3 &&  ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            if ( $soilvert == 1 )
            { print $fidin "ids , ide , 1 , config_flags%num_soil_layers , jds , jde ,    &\n"  ;
              print $fidin "ids , ide , 1 , config_flags%num_soil_layers , jds , jde ,    &\n"  ; }
            else
            { print $fidin "ids , ide , kds , kde , jds , jde ,    &\n"  ;
              print $fidin "ids , ide , kds , kde , jds , jde ,    &\n"  ; }
          }
          elsif ( $ndims == 2 &&  ! $sw_distrib_io_layer && $sw_dm_parallel )
            { print $fidin "ids , ide , jds , jde , 1 , 1 ,                &\n"  ;
              print $fidin "ids , ide , jds , jde , 1 , 1 ,                &\n"  ; }
          else
            { print $fidin "$ms1 , $me1 , $ms2 , $me2 , $ms3 , $me3 ,                &\n"  ;
              print $fidin "$ps1 , $pe1 , $ps2 , $pe2 , $ps3 , $pe3 ,                &\n"  ; }
          print $fidin "                       ierr )\n"                               ;

          if ( ! $sw_distrib_io_layer && $sw_dm_parallel )
	  {
            print $fidin "ENDIF\n" ;
	  }
          if ( $ndims == 3 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            print $fidin "call dm_global_to_patch_$t[$type] ( globbuf_$t[$type] , $thevname ,&\n" ;
            print $fidin "                                    grid%domdesc, $ndims  ,&\n" ;
            if ( $soilvert == 1 )
            {
              print $fidin "        ids,ide,jds,jde,1,config_flags%num_soil_layers,&\n" ;
#              print $fidin "        $ds1,$de1,$ds3,$de3,1,config_flags%num_soil_layers,  &\n" ;
              print $fidin "        ims,ime,jms,jme,1,config_flags%num_soil_layers,&\n" ;
              print $fidin "        ips,ipe,jps,jpe,1,config_flags%num_soil_layers )\n" ;
            }
            else
            {
              print $fidin "        ids,ide,jds,jde,kds,kde,&\n" ;
#              print $fidin "        $ds1,$de1,$ds3,$de3,$ds2,$de2,  &\n" ;
              print $fidin "        ims,ime,jms,jme,kms,kme,& \n" ;
              print $fidin "        ips,ipe,jps,jpe,kps,kpe ) \n" ;
            }
          }
          elsif ( $ndims == 2 && ! $sw_distrib_io_layer && $sw_dm_parallel )
          {
            print $fidin "call dm_global_to_patch_$t[$type] ( globbuf_$t[$type] , $thevname ,&\n" ;
            print $fidin "                                    grid%domdesc, $ndims  ,&\n" ;
            print $fidin "        ids,ide,jds,jde,1,1,&\n" ;
#            print $fidin "        $ds1,$de1,$ds2,$de2,1,1,  &\n" ;
            print $fidin "        ims,ime,jms,jme,1,1,& \n" ;
            print $fidin "        ips,ipe,jps,jpe,1,1 ) \n" ;
          }
	  elsif ( $memorder eq 'Z' && ! $sw_distrib_io_layer && $sw_dm_parallel )
	  {
	    print $fidin "CALL wrf_dm_bcast_$t[$type] ( $thevname , ($de1)-($ds1)+1 )\n" ;
	  }
          elsif ( $memorder eq '0' && ! $sw_distrib_io_layer && $sw_dm_parallel )
	  {
	    print $fidin "CALL wrf_dm_bcast_$t[$type] ( $thevname , 1 )\n" ;
	  }
	  elsif ( ! $sw_distrib_io_layer && $sw_dm_parallel )
	  {
	    print "Registry WARNING (and possibly internal error): can't figure out entry for $t[$sym]\n" ;
	  }

          if ( $multfieldarrays{$t[$use]} )
	  {
            print $fidin "ENDIF\n" ;     # if P_$s1 .GE. PARAM_FIRST_SCALAR
	  }

          if ( $tag ne "" )
          {
            if ( $code ne "r" )
            {
              if ( ! $multfieldarrays{$t[$use]} )
              {
                print $fidin "  grid %${s1}_1 = grid %${s1}${tag}\n" ;
              }
              else
              {
                print $fidin "  grid %$t[$use]_1(ims,kms,jms,P_$s1) = grid %$t[$use]_2(ims,kms,jms,P_$s1)\n" ;
              }
            }
            elsif ( $tag eq "_2" )
            {
              $tag = "_1" ;
              goto label1 ;
            }
            else
            {
              $tag = "_2" if ( $tag eq "_1" ) ;
            }
          }
        }
      }
      $uniqtag_wrfio{ "$t[$sym]"."$tag" } = 1 ;
    }
  }
}

foreach $key ( sort keys %multfieldarrays )
{
  $num_time = $multfield_ntl{$key} ;
  if ( $num_time == 2 )
  {
#print "$key  $num_time $multfield_io{$key}\n" ;
    for ( $i = 0 ; $i < length( $multfield_io{$key}  ) ; $i++ )
    {
      $code = substr( $multfield_io{$key} , $i , 1 ) ;
      if    ( $code eq "h" )
      {
        $fidin  = WRFHISTIN ;
      }
      elsif ( $code eq "i" )
      {
        $fidin  = WRFINITIALIN ;
      }

      print $fidin " grid %${key}_1 = grid %${key}_2\n" ;
    }
  }
}

close WRFHISTOUT ;
close WRFRESTARTOUT ;
close WRFINITIALOUT ;
close WRFBDYOUT ;
close WRFHISTIN ;
close WRFRESTARTIN ;
close WRFINITIALIN ;
close WRFBDYIN ;
close MMMETASET ;
close MMMETAGET ;

}

return 1 ;

