#include <stdio.h>
#include <fcntl.h>

#ifdef WRF_RSL_IO
#include <rsl.h>
#endif

#define p_oldext_io_ids    1
#define p_oldext_io_ide    2
#define p_oldext_io_jds    3
#define p_oldext_io_jde    4
#define p_oldext_io_kds    5
#define p_oldext_io_kde    6
#define p_oldext_io_ims    7
#define p_oldext_io_ime    8
#define p_oldext_io_jms    9
#define p_oldext_io_jme   10
#define p_oldext_io_kms   11
#define p_oldext_io_kme   12
#define p_oldext_io_ips   13
#define p_oldext_io_ipe   14
#define p_oldext_io_jps   15
#define p_oldext_io_jpe   16
#define p_oldext_io_kps   17
#define p_oldext_io_kpe   18
#define p_oldext_io_domdesc   19
#define p_oldext_io_domain_info_len  19

#ifdef DOUBLE_PRECISION
# define  REAL double
#else
# define  REAL float
#endif
#ifndef CRAY
# ifdef NOUNDERSCORE
#  define OLDEXT_INIT_WRFIO   oldext_init_wrfio
#  define OLDEXT_WRITE_0D     oldext_write_0d
#  define OLDEXT_WRITE_KIJ    oldext_write_kij
#  define OLDEXT_WRITE_IKJ    oldext_write_ikj
#  define OLDEXT_WRITE_IJK    oldext_write_ijk
#  define OLDEXT_WRITE_IJ     oldext_write_ij
#  define OLDEXT_WRITE_K      oldext_write_k
#  define OLDEXT_READ_0D     oldext_read_0d
#  define OLDEXT_READ_KIJ    oldext_read_kij
#  define OLDEXT_READ_IJK    oldext_read_ijk
#  define OLDEXT_READ_IKJ    oldext_read_ikj
#  define OLDEXT_READ_IJ     oldext_read_ij
#  define OLDEXT_READ_K      oldext_read_k
#  define OLDEXT_OPEN_DATASET_C oldext_open_dataset_c
#  define OLDEXT_CLOSE oldext_close
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read
#  define FORTRAN_READ fortran_read
#  define FORTRAN_WRITE fortran_write
#  define FORTRAN_CLOSE fortran_close
# else
#   ifdef F2CSTYLE
#  define OLDEXT_INIT_WRFIO   oldext_init_wrfio__
#  define OLDEXT_WRITE_0D     oldext_write_0d__
#  define OLDEXT_WRITE_KIJ    oldext_write_kij__
#  define OLDEXT_WRITE_IJK    oldext_write_ijk__
#  define OLDEXT_WRITE_IJ     oldext_write_ij__
#  define OLDEXT_WRITE_K      oldext_write_k__
#  define OLDEXT_READ_0D     oldext_read_0d__
#  define OLDEXT_READ_KIJ    oldext_read_kij__
#  define OLDEXT_READ_IJK    oldext_read_ijk__
#  define OLDEXT_READ_IKJ    oldext_read_ikj__
#  define OLDEXT_READ_IJ     oldext_read_ij__
#  define OLDEXT_READ_K      oldext_read_k__
#  define OLDEXT_OPEN_DATASET_C oldext_open_dataset_c__
#  define OLDEXT_CLOSE oldext_close__
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write__
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read__
#  define FORTRAN_READ fortran_read__
#  define FORTRAN_WRITE fortran_write__
#  define FORTRAN_CLOSE fortran_close__
#   else
#  define OLDEXT_INIT_WRFIO   oldext_init_wrfio_
#  define OLDEXT_WRITE_0D     oldext_write_0d_
#  define OLDEXT_WRITE_KIJ    oldext_write_kij_
#  define OLDEXT_WRITE_IJK    oldext_write_ijk_
#  define OLDEXT_WRITE_IKJ    oldext_write_ikj_
#  define OLDEXT_WRITE_IJ     oldext_write_ij_
#  define OLDEXT_WRITE_K      oldext_write_k_
#  define OLDEXT_READ_0D     oldext_read_0d_
#  define OLDEXT_READ_KIJ    oldext_read_kij_
#  define OLDEXT_READ_IJK    oldext_read_ijk_
#  define OLDEXT_READ_IKJ    oldext_read_ikj_
#  define OLDEXT_READ_IJ     oldext_read_ij_
#  define OLDEXT_READ_K      oldext_read_k_
#  define OLDEXT_OPEN_DATASET_C oldext_open_dataset_c_
#  define OLDEXT_CLOSE oldext_close_
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write_
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read_
#  define FORTRAN_READ fortran_read_
#  define FORTRAN_WRITE fortran_write_
#  define FORTRAN_CLOSE fortran_close_
#   endif
# endif
#endif

#ifndef OLDEXT_MPI_IO
#define MPI_Offset int
#define MPI_File int
#define MPI_Datatype int
#endif

typedef struct fieldrec {
  char * fieldname ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  struct fieldrec_type * next ;
} fieldrec_type ;


typedef struct {
  int id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  fieldrec_type * fieldlist ;
} io_entry ;

/* return a pointer to the field rec for this entry if exist, otherwise null */
fieldrec_type
field_get( name , entry )
{
}

static io_entry iotab[99] ;

static REAL *obuf ; 
static int obuf_sz = NULL ;


store_diminfo( id,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
		   ips, ipe, jps, jpe, kps, kpe,
		   info )
  int *id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
{
  int i ;
  for ( i = 8 ; i < 99 ; i++ )
  {
    if ( iotab[i].id < 0 )
    {
      iotab[i].id = i ;
      *id = i ;
      iotab[i].ids = ids ;
      iotab[i].ide = ide ;
      iotab[i].jds = jds ;
      iotab[i].jde = jde ;
      iotab[i].kds = kds ;
      iotab[i].kde = kde ;
      iotab[i].ims = ims ;
      iotab[i].ime = ime ;
      iotab[i].jms = jms ;
      iotab[i].jme = jme ;
      iotab[i].kms = kms ;
      iotab[i].kme = kme ;
      iotab[i].ips = ips ;
      iotab[i].ipe = ipe ;
      iotab[i].jps = jps ;
      iotab[i].jpe = jpe ;
      iotab[i].kps = kps ;
      iotab[i].kpe = kpe ;
      iotab[i].info = info ;
      break ;
    }
  }
}

set_diminfo( id,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe,
		   info )
  int id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
{
  int i ;
  for ( i = 8 ; i < 99 ; i++ )
  {
    if ( iotab[i].id == id )
    {
      iotab[i].ids = ids ;
      iotab[i].ide = ide ;
      iotab[i].jds = jds ;
      iotab[i].jde = jde ;
      iotab[i].kds = kds ;
      iotab[i].kde = kde ;
      iotab[i].ims = ims ;
      iotab[i].ime = ime ;
      iotab[i].jms = jms ;
      iotab[i].jme = jme ;
      iotab[i].kms = kms ;
      iotab[i].kme = kme ;
      iotab[i].ips = ips ;
      iotab[i].ipe = ipe ;
      iotab[i].jps = jps ;
      iotab[i].jpe = jpe ;
      iotab[i].kps = kps ;
      iotab[i].kpe = kpe ;
      iotab[i].info = info ;
      break ;
    }
  }
}

get_diminfo( id,
             ids, ide, jds, jde, kds, kde,
             ims, ime, jms, jme, kms, kme,
             ips, ipe, jps, jpe, kps, kpe,
	     info)
  int id ; 
  int *ids, *ide, *jds, *jde, *kds, *kde,
      *ims, *ime, *jms, *jme, *kms, *kme,
      *ips, *ipe, *jps, *jpe, *kps, *kpe ;
  int *info ;
{
  if ( id >= 8 && id <= 99 )
  {
    if ( iotab[id].id == id )
    {
      *ids = iotab[id].ids ;
      *ide = iotab[id].ide ;
      *jds = iotab[id].jds ;
      *jde = iotab[id].jde ;
      *kds = iotab[id].kds ;
      *kde = iotab[id].kde ;
      *ims = iotab[id].ims ;
      *ime = iotab[id].ime ;
      *jms = iotab[id].jms ;
      *jme = iotab[id].jme ;
      *kms = iotab[id].kms ;
      *kme = iotab[id].kme ;
      *ips = iotab[id].ips ;
      *ipe = iotab[id].ipe ;
      *jps = iotab[id].jps ;
      *jpe = iotab[id].jpe ;
      *kps = iotab[id].kps ;
      *kpe = iotab[id].kpe ;
      *info  = iotab[id].info ;
      return ;
    }
  }
  fprintf(stderr,"io.c:get_diminfo: internal error\n") ;
  exit(1);
}

clear_diminfo( id )
  int id ;
{
  if ( id >= 0 && id <= 99 )
  {
    if ( iotab[id].id == id ) 
    {
      iotab[id].id = -1 ;
      iotab[id].info = 0 ;
      return ;
    }
  }
  fprintf(stderr,"io.c:clear_diminfo: internal error\n") ;
  exit(1);
}


OLDEXT_INIT_WRFIO ()
{
  int i ;

  for ( i = 0 ; i < 99 ; i++ ) 
  {
    iotab[i].id = -1 ;
  }
}

OLDEXT_OPEN_DATASET_C ( intname , lenname ,             
                     domain_info ,                   
                     mode  ,                         
                     int_dep_info ,  lendepinfo ,    
                     id )       

  int *intname ;
  int *lenname ;
  int *domain_info ;
  int *mode ;
  int *int_dep_info ;
  int *lendepinfo ;
  int *id ;
{
  char fname[256] ;
  char sys_dep_info[2096] ;
  int i ;
  MPI_Offset disp ;
  MPI_File   fh ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe  ;
  int domdesc ;

  ids    = domain_info[ p_oldext_io_ids ] ;
  ide    = domain_info[ p_oldext_io_ide ] ;
  jds    = domain_info[ p_oldext_io_jds ] ;
  jde    = domain_info[ p_oldext_io_jde ] ;
  kds    = domain_info[ p_oldext_io_kds ] ;
  kde    = domain_info[ p_oldext_io_kde ] ;
  ims    = domain_info[ p_oldext_io_ims ] ;
  ime    = domain_info[ p_oldext_io_ime ] ;
  jms    = domain_info[ p_oldext_io_jms ] ;
  jme    = domain_info[ p_oldext_io_jme ] ;
  kms    = domain_info[ p_oldext_io_kms ] ;
  kme    = domain_info[ p_oldext_io_kme ] ;
  ips    = domain_info[ p_oldext_io_ips ] ;
  ipe    = domain_info[ p_oldext_io_ipe ] ;
  jps    = domain_info[ p_oldext_io_jps ] ;
  jpe    = domain_info[ p_oldext_io_jpe ] ;
  kps    = domain_info[ p_oldext_io_kps ] ;
  kpe    = domain_info[ p_oldext_io_kpe ] ;
  domdesc    = domain_info[ p_oldext_io_domdesc ] ;


  for ( i = 0 ; i < *lenname ; i++ )
  {
    fname[i] = intname[i] ;
  }
  fname[i] = '\0' ;
  for ( i = 0 ; i < *lendepinfo ; i++ )
  {
    sys_dep_info[i] = int_dep_info[i] ;
  }
  sys_dep_info[i] = '\0' ;

/* This call returns with an ID; we may reset some of
   the other information with a call to set_diminfo at end */
  store_diminfo( id, 
	         ids, ide, jds, jde, kds, kde,
	         ims, ime, jms, jme, kms, kme,
	         ips, ipe, jps, jpe, kps, kpe, domdesc ) ;

  if      ( *mode == 2 )
  {
    int ierr ;
    FORTRAN_NAMED_OPEN_WRITE ( fname , lenname , id , &ierr ) ;
    if ( ierr != 0 )
    {
      fprintf(stderr,"failed to open %s for writing \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
  else if ( *mode == 1 )
  {
    int ierr ;
    FORTRAN_NAMED_OPEN_READ ( fname , lenname , id , &ierr ) ;
    if ( ierr != 0 )
    {
      fprintf(stderr,"failed to open %s for reading \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
  else
  {
    fprintf(stderr,"oldext_open_dataset: invalid mode argument %d\n",*mode) ;
    exit(2) ;
  }
 
  set_diminfo( *id, 
	       ids, ide, jds, jde, kds, kde,
	       ims, ime, jms, jme, kms, kme,
	       ips, ipe, jps, jpe, kps, kpe,  domdesc ) ;

}

OLDEXT_CLOSE ( id )
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype dummy ;
  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
		&info ) ;

  FORTRAN_CLOSE ( id ) ;
  clear_diminfo( *id ) ;
}

OLDEXT_WRITE_0D ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
		&info ) ;

  wrf_write_field( *id, v, 
		   1,1, 1,1, 1,1,
		   1,1, 1,1, 1,1,
		   1,1, 1,1, 1,1, info ) ;

}

OLDEXT_WRITE_KIJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL *temp ;
  int i,j,k,ix,jx,kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;
  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[i+j*ix+k*ix*jx] = v[k+i*kx+j*kx*ix] ;

  wrf_write_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;
  free (temp) ;
}

OLDEXT_WRITE_IJK ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL *temp ;
  int i,j,k,ix,jx,kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;

#if 0
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[i+j*ix+k*ix*jx] = v[i+j*ix+k*ix*jx] ;
#endif

  wrf_write_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;

#if 0
  free (temp) ;
#endif
}

OLDEXT_WRITE_IKJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL *temp ;
  int i,j,k,ix,jx,kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;

  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[i+j*ix+k*ix*jx] = v[i+k*ix+j*ix*kx] ;

  wrf_write_field( *id, temp,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;

  free (temp) ;
}

OLDEXT_WRITE_IJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;

  wrf_write_field( *id, v,
                   ids, ide, jds, jde, 1, 1,
                   ims, ime, jms, jme, 1, 1,
                   ips, ipe, jps, jpe, 1, 1, disp, fh, type2d, info ) ;
}

OLDEXT_WRITE_K ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;

  wrf_write_field( *id, v,
                   1, 1, 1, 1, kds, kde,
                   1, 1, 1, 1, kms, kme,
                   1, 1, 1, 1, kps, kpe, disp, fh, type1d, info ) ;
}

wrf_write_field ( id, v, 
		  ids, ide, jds, jde, kds, kde,
		  ims, ime, jms, jme, kms, kme,
		  ips, ipe, jps, jpe, kps, kpe,
                  info
	        )
  int id ;
  REAL *v ;
  int ids, ide, jds, jde, kds, kde ;
  int ims, ime, jms, jme, kms, kme ;
  int ips, ipe, jps, jpe, kps, kpe ;
  int info ;
{
  REAL *q ;
  int kx, ix, jx, kl, il, jl, kdom, idom, jdom ;
  int i, j, k ;
  int size ;
  int n ;

  kx = kme - kms + 1 ;
  ix = ime - ims + 1 ;
  jx = jme - jms + 1 ;
  kl = kpe - kps + 1 ;
  il = ipe - ips + 1 ;
  jl = jpe - jps + 1 ;
  kdom = kde - kds + 1 ;
  idom = ide - ids + 1 ;
  jdom = jde - jds + 1 ;

  if ( obuf_sz < kx*ix*jx )
  {
    if ( obuf != NULL ) free (obuf) ;
    obuf = (REAL *) malloc( kx*ix*jx * sizeof(REAL) ) ;
    obuf_sz = kx*ix*jx ;
  }

  for ( i = 0 ; i < kx*ix*jx ; i++ ) obuf[i] = 0. ;
  
  q = obuf ;

#if ! defined WRF_RSL_IO 

  if ( il > 1  && jl > 1 && kl > 1 )
  {
    FORTRAN_WRITE ( &id , obuf ,  idom * jdom * kdom ) ;
  }
  else if ( il > 1 && jl > 1 )
  {
    FORTRAN_WRITE ( &id , obuf ,  idom * jdom ) ;
  }
  else
  {
    FORTRAN_WRITE ( &id , obuf ,  kdom ) ;
  }

#else

  if ( il > 1  && jl > 1 && kl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO3D_IJK ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ; glen[2] = kdom ;
    llen[0] = ix ; llen[1] = jx ; llen[2] = kx ;

    RSL_WRITE ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  if ( il > 1 && jl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO2D_IJ ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ;
    llen[0] = ix ; llen[1] = jx ;
    RSL_WRITE ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  {
    int i_am_monitor ;
    RSL_C_IAMMONITOR( &i_am_monitor ) ;
    if ( i_am_monitor )
    {
      FORTRAN_WRITE ( &id, obuf, &kdom ) ;
    }
  }
#endif

}

OLDEXT_READ_0D ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype dummy ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &dummy, &dummy, &dummy, &info ) ;
  wrf_read_field( *id, v,
                   1,1, 1,1, 1,1,
                   1,1, 1,1, 1,1,
                   1,1, 1,1, 1,1, disp, fh, dummy, info ) ;

}

OLDEXT_READ_KIJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ; 
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL * temp ;
  int i, j, k, ix, jx, kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, 
                &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  wrf_read_field( *id, temp,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, info ) ;
/* transpose */
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        v[k+i*kx+j*kx*ix] = temp[i+j*ix+k*ix*jx] ;
  free(temp) ;
}

OLDEXT_READ_IJK ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL * temp ;
  int i, j, k, ix, jx, kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
                &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
#if 0
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;
#endif

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, info ) ;
/* transpose */
#if 0
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        v[i+j*ix+k*ix*jx] = temp[i+j*ix+k*ix*jx] ;
  free(temp) ;
#endif
}

OLDEXT_READ_IKJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL * temp ;
  int i, j, k, ix, jx, kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
                &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  wrf_read_field( *id, temp,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, info ) ;
  for (j=0;j<jx;j++)
    for (k=0;k<kx;k++)
      for (i=0;i<ix;i++)
        v[i+k*ix+j*ix*kx] = temp[i+j*ix+k*ix*jx] ;
  free(temp) ;
}

OLDEXT_READ_IJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
                &info ) ;

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, 1, 1,
                   ims, ime, jms, jme, 1, 1,
                   ips, ipe, jps, jpe, 1, 1, info ) ;
}

OLDEXT_READ_K ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe,
                &info ) ;

  wrf_read_field( *id, v,
                   1, 1, 1, 1, kds, kde,
                   1, 1, 1, 1, kms, kme,
                   1, 1, 1, 1, kps, kpe, info ) ;
}

wrf_read_field ( id, v, 
		  ids, ide, jds, jde, kds, kde,
		  ims, ime, jms, jme, kms, kme,
		  ips, ipe, jps, jpe, kps, kpe,
                  info
	        )
  int id ;
  REAL *v ;
  int ids, ide, jds, jde, kds, kde ;
  int ims, ime, jms, jme, kms, kme ;
  int ips, ipe, jps, jpe, kps, kpe ;
  int info ;
{
  REAL *q ;
  int kx, ix, jx, kl, il, jl, kdom, idom, jdom ;
  int i, j, k ;
  int n ;
  int size ;

  kl = kpe - kps + 1 ;
  il = ipe - ips + 1 ;
  jl = jpe - jps + 1 ;
  kx = kme - kms + 1 ;
  ix = ime - ims + 1 ;
  jx = jme - jms + 1 ;
  kdom = kde - kds + 1 ;
  idom = ide - ids + 1 ;
  jdom = jde - jds + 1 ;

  if ( obuf_sz < kx*ix*jx )
  {
    if ( obuf != NULL ) free (obuf) ;
    obuf = (REAL *) malloc( kx*ix*jx * sizeof(REAL) ) ;
    obuf_sz = kx*ix*jx ;
  }

  for ( i = 0 ; i < kx*ix*jx ; i++ ) obuf[i] = 0. ;

#if ! defined WRF_RSL_IO

  if ( il > 1  && jl > 1 && kl > 1 )
  {
    FORTRAN_READ ( &id , obuf ,  idom * jdom * kdom ) ;
  }
  else if ( il > 1 && jl > 1 )
  {
    FORTRAN_READ ( &id , obuf ,  idom * jdom ) ;
  }
  else
  {
    FORTRAN_READ ( &id , obuf ,  kdom ) ;
  }
  for ( k = kps ; k <= kpe ; k++ )
    for ( j = jps ; j <= jpe ; j++ )
      for ( i = ips ; i <= ipe ; i++ )
      {
        v[ (i-ims) + (j-jms)*ix + (k-kms)*ix*jx] = *q++ ;
      }
#else

  if ( il > 1  && jl > 1 && kl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO3D_IJK ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ; glen[2] = kdom ;
    llen[0] = ix ; llen[1] = jx ; llen[2] = kx ;
    RSL_READ ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  if ( il > 1 && jl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO2D_IJ ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ;
    llen[0] = ix ; llen[1] = jx ;
    RSL_READ ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  {
    int i_am_monitor, len ;
    RSL_C_IAMMONITOR( &i_am_monitor ) ;
    if ( i_am_monitor )
    {
      FORTRAN_READ ( &id, v, &kdom ) ;
    }
    len = kdom * sizeof(float) ;
    RSL_MON_BCAST ( v, &len ) ;
  }

#endif


}

