!WRF:PACKAGE:RSL
!
MODULE module_dm

#if defined(DM_PARALLEL) && defined(RSL)
   USE module_machine
   USE module_state_description
   USE module_wrf_error

   INTEGER msg,messages(168)
   INTEGER &
      n5w5 ,n5w4 ,n5w3 ,n5w2 ,n5w ,n5 ,n5e ,n5e2 ,n5e3 ,n5e4 ,n5e5  &
     ,n4w5 ,n4w4 ,n4w3 ,n4w2 ,n4w ,n4 ,n4e ,n4e2 ,n4e3 ,n4e4 ,n4e5  &
     ,n3w5 ,n3w4 ,n3w3 ,n3w2 ,n3w ,n3 ,n3e ,n3e2 ,n3e3 ,n3e4 ,n3e5  &
     ,n2w5 ,n2w4 ,n2w3 ,n2w2 ,n2w ,n2 ,n2e ,n2e2 ,n2e3 ,n2e4 ,n2e5  &
     ,nw5  ,nw4  ,nw3  ,nw2  ,nw  ,n1 ,ne  ,ne2  ,ne3  ,ne4  ,ne5   &
     ,w5   ,w4   ,w3   ,w2   ,w1      ,e1  ,e2   ,e3   ,e4   ,e5    &
     ,sw5  ,sw4  ,sw3  ,sw2  ,sw  ,s1 ,se  ,se2  ,se3  ,se4  ,se5   &
     ,s2w5 ,s2w4 ,s2w3 ,s2w2 ,s2w ,s2 ,s2e ,s2e2 ,s2e3 ,s2e4 ,s2e5  &
     ,s3w5 ,s3w4 ,s3w3 ,s3w2 ,s3w ,s3 ,s3e ,s3e2 ,s3e3 ,s3e4 ,s3e5  &
     ,s4w5 ,s4w4 ,s4w3 ,s4w2 ,s4w ,s4 ,s4e ,s4e2 ,s4e3 ,s4e4 ,s4e5  &
     ,s5w5 ,s5w4 ,s5w3 ,s5w2 ,s5w ,s5 ,s5e ,s5e2 ,s5e3 ,s5e4 ,s5e5
   INTEGER glen(3), llen(3), decomp(3), decompx(3), decompy(3)
   INTEGER glen2d(2), llen2d(2), decomp2d(2), decompx2d(2), decompy2d(2)
   INTEGER glenx(3), gleny(3)
   INTEGER glenx2d(2), gleny2d(2)

CONTAINS

   SUBROUTINE MPASPECT( P, MINM, MINN, PROCMIN_M, PROCMIN_N )
      INTEGER P, M, N, MINI, MINM, MINN, PROCMIN_M, PROCMIN_N
      MINI = 2*P
      MINM = 1
      MINN = P
      DO M = 1, P
        IF ( MOD( P, M ) .EQ. 0 ) THEN
          N = P / M
          IF ( ABS(M-N) .LT. MINI                &
               .AND. M .GE. PROCMIN_M            &
               .AND. N .GE. PROCMIN_N            &
             ) THEN
            MINI = ABS(M-N)
            MINM = M
            MINN = N
          ENDIF
        ENDIF
      ENDDO
      IF ( MINM .LT. PROCMIN_M .OR. MINN .LT. PROCMIN_N ) THEN
        WRITE( wrf_err_message , * )'MPASPECT: UNABLE TO GENERATE PROCESSOR MESH.  STOPPING.'
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        WRITE(0,*)' PROCMIN_M ', PROCMIN_M
        WRITE( wrf_err_message , * )' PROCMIN_M ', PROCMIN_M
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        WRITE( wrf_err_message , * )' PROCMIN_N ', PROCMIN_N
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        WRITE( wrf_err_message , * )' P         ', P
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        WRITE( wrf_err_message , * )' MINM      ', MINM
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        WRITE( wrf_err_message , * )' MINN      ', MINN
        CALL wrf_message ( TRIM ( wrf_err_message ) )
        CALL wrf_error_fatal ( 'module_dm: mpaspect' )
      ENDIF
   RETURN
   END SUBROUTINE MPASPECT


   SUBROUTINE initial_dm_parallel
# include <rsl.inc>
      integer nproc_lt, nproc_ln
      CALL RSL_SET_REGULAR_DECOMP
      CALL mpaspect( rsl_nproc , nproc_lt , nproc_ln , 1 , 1 )
      CALL RSL_MESH( nproc_lt, nproc_ln )
      RETURN
   END SUBROUTINE initial_dm_parallel

   SUBROUTINE reset_msgs_48pt
      CALL reset_msgs_24pt
      CALL rsl_create_message(n3w3)
      CALL rsl_create_message(n3w2)
      CALL rsl_create_message(n3w )
      CALL rsl_create_message(n3)
      CALL rsl_create_message(n3e )
      CALL rsl_create_message(n3e2)
      CALL rsl_create_message(n3e3)
      CALL rsl_create_message(n2w3)
      CALL rsl_create_message(n2e3)
      CALL rsl_create_message(nw3)
      CALL rsl_create_message(ne3)
      CALL rsl_create_message(w3)
      CALL rsl_create_message(e3)
      CALL rsl_create_message(sw3)
      CALL rsl_create_message(se3)
      CALL rsl_create_message(s2w3)
      CALL rsl_create_message(s2e3)
      CALL rsl_create_message(s3w3)
      CALL rsl_create_message(s3w2)
      CALL rsl_create_message(s3w )
      CALL rsl_create_message(s3)
      CALL rsl_create_message(s3e )
      CALL rsl_create_message(s3e2)
      CALL rsl_create_message(s3e3)
      RETURN
   END SUBROUTINE reset_msgs_48pt

   SUBROUTINE reset_msgs_24pt
      CALL reset_msgs_12pt
      CALL rsl_create_message(n2w2)
      CALL rsl_create_message(n2w)
      CALL rsl_create_message(n2e)
      CALL rsl_create_message(n2e2)
      CALL rsl_create_message(nw2)
      CALL rsl_create_message(ne2)
      CALL rsl_create_message(sw2)
      CALL rsl_create_message(se2)
      CALL rsl_create_message(s2w2)
      CALL rsl_create_message(s2w)
      CALL rsl_create_message(s2e)
      CALL rsl_create_message(s2e2)
      RETURN
   END SUBROUTINE reset_msgs_24pt

   SUBROUTINE reset_msgs_12pt
      CALL reset_msgs_8pt
      call rsl_create_message(n2)
      call rsl_create_message(w2)
      call rsl_create_message(e2)
      call rsl_create_message(s2)
      RETURN
   END SUBROUTINE reset_msgs_12pt

   SUBROUTINE reset_msgs_8pt
      call reset_msgs_4pt
      call rsl_create_message(ne)
      call rsl_create_message(nw)
      call rsl_create_message(se)
      call rsl_create_message(sw)
      RETURN
   END SUBROUTINE reset_msgs_8pt

   SUBROUTINE reset_msgs_4pt
      call rsl_create_message(n1)
      call rsl_create_message(w1)
      call rsl_create_message(e1)
      call rsl_create_message(s1)
      RETURN
   END SUBROUTINE reset_msgs_4pt

   SUBROUTINE add_msg_4pt ( fld , dim )
      IMPLICIT NONE
# include <rsl.inc>
      integer dim
      real fld(*)
! JM IJK MODS
! JM IKJ MODS
      if      ( dim == 3 ) then
        CALL rsl_build_message(w1,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s1,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(e1,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n1,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
      else if ( dim == 2 ) then
        CALL rsl_build_message(w1,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s1,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(e1,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n1,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
      endif
      RETURN
   END SUBROUTINE add_msg_4pt

   SUBROUTINE add_msg_8pt ( fld , dim )
      IMPLICIT NONE
# include <rsl.inc>
      integer dim
      real fld(*)
! JM IJK MODS
      CALL add_msg_4pt ( fld , dim )
      if (      dim == 3 ) then
        CALL rsl_build_message(nw,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(sw,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(ne,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(se,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
      else if ( dim == 2 ) then
        CALL rsl_build_message(nw,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(sw,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(ne,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(se,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
      endif
      RETURN
   END SUBROUTINE add_msg_8pt

   SUBROUTINE add_msg_12pt ( fld , dim )
      IMPLICIT NONE
# include <rsl.inc>
      integer dim
      real fld(*)
! JM IJK MODS
      CALL add_msg_8pt ( fld , dim )
      if      ( dim == 3 ) then
        CALL rsl_build_message(w2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(e2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
      else if ( dim == 2 ) then
        CALL rsl_build_message(w2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(e2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
      endif
      RETURN
   END SUBROUTINE add_msg_12pt

   SUBROUTINE add_msg_24pt ( fld , dim )
      IMPLICIT NONE
# include <rsl.inc>
      integer dim
      real fld(*)
! JM IJK MODS
      CALL add_msg_8pt ( fld , dim )
      if      ( dim == 3 ) then
        CALL rsl_build_message(n2w2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2w,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2e,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2e2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(nw2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(ne2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(sw2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(se2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2w2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2w,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2e,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2e2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
      else if ( dim == 2 ) then
        CALL rsl_build_message(n2w2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2w,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2e,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2e2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(nw2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(ne2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(sw2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(se2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2w2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2w,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2e,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2e2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
      endif
      RETURN
   END SUBROUTINE add_msg_24pt

   SUBROUTINE add_msg_48pt ( fld , dim )
      IMPLICIT NONE
# include <rsl.inc>
      integer dim
      real fld(*)
! JM IJK MODS
      CALL add_msg_24pt ( fld , dim )
      if      ( dim == 3 ) then
        CALL rsl_build_message(n3w3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3w2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3w,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3e,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3e2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n3e3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2w3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(n2e3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(nw3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(ne3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(w3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(e3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(sw3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(se3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2w3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s2e3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3w3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3w2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3w,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3e,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3e2,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
        CALL rsl_build_message(s3e3,RSL_REAL_F90,fld,dim,decomp(1),glen(1),llen(1))
      else if ( dim == 2 ) then
        CALL rsl_build_message(n3w3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3w2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3w,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3e,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3e2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n3e3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2w3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(n2e3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(nw3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(ne3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(w3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(e3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(sw3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(se3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2w3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s2e3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3w3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3w2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3w,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3e,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3e2,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
        CALL rsl_build_message(s3e3,RSL_REAL_F90,fld,dim,decomp2d(1),glen2d(1),llen2d(1))
      endif
      RETURN
   END SUBROUTINE add_msg_48pt

   SUBROUTINE stencil_4pt ( did, stenid )
      IMPLICIT NONE
# include <rsl.inc>
      INTEGER did, stenid
      messages(1) =          n1
      messages(2) =   w1
      messages(3) =                 e1
      messages(4) =          s1
      CALL rsl_create_stencil( stenid )
      CALL rsl_describe_stencil ( did, stenid, RSL_4PT, messages )
      RETURN
   END SUBROUTINE stencil_4pt

   SUBROUTINE stencil_8pt ( did, stenid )
      IMPLICIT NONE
# include <rsl.inc>
      INTEGER did, stenid
      messages(1) =   nw
      messages(2) =          n1
      messages(3) =                 ne
      messages(4) =   w1
      messages(5) =                 e1
      messages(6) =   sw
      messages(7) =          s1
      messages(8) =                 se
      CALL rsl_create_stencil( stenid )
      CALL rsl_describe_stencil ( did, stenid, RSL_8PT, messages )
      RETURN
   END SUBROUTINE stencil_8pt

   SUBROUTINE stencil_12pt ( did, stenid )
      IMPLICIT NONE
# include <rsl.inc>
      INTEGER did, stenid
      messages(1)  =                 n2
      messages(2)  =          nw
      messages(3)  =                 n1
      messages(4)  =                           ne
      messages(5)  =  w2
      messages(6)  =          w1                  
      messages(7)  =                           e1
      messages(8)  =                                    e2
      messages(9)  =          sw
      messages(10) =                 s1
      messages(11) =                           se
      messages(12) =                 s2
      CALL rsl_create_stencil( stenid )
      CALL rsl_describe_stencil ( did, stenid, RSL_12PT, messages )
      RETURN
   END SUBROUTINE stencil_12pt

   SUBROUTINE stencil_24pt ( did, stenid )
      IMPLICIT NONE
# include <rsl.inc>
      INTEGER did, stenid, i
      messages( 1) = n2w2
      messages( 2) = n2w
      messages( 3) = n2
      messages( 4) = n2e
      messages( 5) = n2e2
      messages( 6) = nw2
      messages( 7) = nw
      messages( 8) = n1
      messages( 9) = ne
      messages(10) = ne2
      messages(11) = w2
      messages(12) = w1
      messages(13) = e1
      messages(14) = e2
      messages(15) = sw2
      messages(16) = sw
      messages(17) = s1
      messages(18) = se
      messages(19) = se2
      messages(20) = s2w2
      messages(21) = s2w
      messages(22) = s2
      messages(23) = s2e
      messages(24) = s2e2
      CALL rsl_create_stencil( stenid )
      CALL rsl_describe_stencil ( did, stenid, RSL_24PT, messages )
      RETURN
   END SUBROUTINE stencil_24pt

   SUBROUTINE stencil_48pt ( did, stenid )
      IMPLICIT NONE
# include <rsl.inc>
      INTEGER did, stenid, i
      messages( 1) = n3w3
      messages( 2) = n3w2
      messages( 3) = n3w
      messages( 4) = n3
      messages( 5) = n3e
      messages( 6) = n3e2
      messages( 7) = n3e3
      messages( 8) = n2w3
      messages( 9) = n2w2
      messages(10) = n2w
      messages(11) = n2
      messages(12) = n2e
      messages(13) = n2e2
      messages(14) = n2e3
      messages(15) = nw3
      messages(16) = nw2
      messages(17) = nw
      messages(18) = n1
      messages(19) = ne
      messages(20) = ne2
      messages(21) = ne3
      messages(22) = w3
      messages(23) = w2
      messages(24) = w1
      messages(25) = e1
      messages(26) = e2
      messages(27) = e3
      messages(28) = sw3
      messages(29) = sw2
      messages(30) = sw
      messages(31) = s1
      messages(32) = se
      messages(33) = se2
      messages(34) = se3
      messages(35) = s2w3
      messages(36) = s2w2
      messages(37) = s2w
      messages(38) = s2
      messages(39) = s2e
      messages(40) = s2e2
      messages(41) = s2e3
      messages(42) = s3w3
      messages(43) = s3w2
      messages(44) = s3w
      messages(45) = s3
      messages(46) = s3e
      messages(47) = s3e2
      messages(48) = s3e3
      CALL rsl_create_stencil( stenid )
      CALL rsl_describe_stencil ( did, stenid, RSL_48PT, messages )
      RETURN
   END SUBROUTINE stencil_48pt

!------------------------------------------------------------------

   SUBROUTINE define_rk_comms_rsl( domdesc, comms, ncoms ,  &
!
# include <rk_dummy_args.inc>
!
)
      IMPLICIT NONE
# include <rsl.inc>
# include <rk_dummy_arg_defines.inc>

#include <rk_i1.inc>

      INTEGER domdesc
      INTEGER ncoms
      INTEGER comms(ncoms)
      INTEGER i, kms, ims, jms

#define REGISTER_I1
# include <rsl_rk_data_calls.inc>

   ! executable
! JM IJK MOD
      SELECT CASE ( model_data_order )
         ! need to finish other cases
         CASE ( DATA_ORDER_ZXY )
            kms = sm31
            ims = sm32
            jms = sm33
            decomp(1) = RSL_NOTDECOMPOSED
            decomp(2) = RSL_M
            decomp(3) = RSL_N
            decomp2d(1) = RSL_M
            decomp2d(2) = RSL_N
            glen2d(1) = ed32 - sd32 + 1
            glen2d(2) = ed33 - sd33 + 1
            llen2d(1) = em32 - sm32 + 1
            llen2d(2) = em33 - sm33 + 1
         CASE ( DATA_ORDER_XYZ )
            kms = sm33
            ims = sm31
            jms = sm32
            decomp(1) = RSL_M
            decomp(2) = RSL_N
            decomp(3) = RSL_NOTDECOMPOSED
            decomp2d(1) = RSL_M
            decomp2d(2) = RSL_N
            glen2d(1) = ed31 - sd31 + 1
            glen2d(2) = ed32 - sd32 + 1
            llen2d(1) = em31 - sm31 + 1
            llen2d(2) = em32 - sm32 + 1
         CASE ( DATA_ORDER_XZY )
            kms = sm32
            ims = sm31
            jms = sm33
            decomp(1) = RSL_M
            decomp(2) = RSL_NOTDECOMPOSED
            decomp(3) = RSL_N
            decomp2d(1) = RSL_M
            decomp2d(2) = RSL_N
            glen2d(1) = ed31 - sd31 + 1
            glen2d(2) = ed33 - sd33 + 1
            llen2d(1) = em31 - sm31 + 1
            llen2d(2) = em33 - sm33 + 1
      END SELECT

      glen(1)   = ed31 - sd31 + 1
      glen(2)   = ed32 - sd32 + 1
      glen(3)   = ed33 - sd33 + 1
      llen(1)   = em31 - sm31 + 1
      llen(2)   = em32 - sm32 + 1
      llen(3)   = em33 - sm33 + 1

#  include "rslhalos.inc"

   ! Define periodic BC's -- for the period routines, the glen
   ! array contains the actual logical size of the field (that is,
   ! staggering is explicitly stated).  Llen is not affected.

      SELECT CASE ( model_data_order )
         ! need to finish other cases
#if 0
         CASE ( DATA_ORDER_ZXY )

      glen(1)    = ed31 - sd31 + 1
      glen(2)    = ed32 - sd32
      glen(3)    = ed33 - sd33
      glenx(1)   = ed31 - sd31 + 1
      glenx(2)   = ed32 - sd32 + 1   ! x-staggering
      glenx(3)   = ed33 - sd33
      gleny(1)   = ed31 - sd31 + 1
      gleny(2)   = ed32 - sd32
      gleny(3)   = ed33 - sd33 + 1   ! y-staggering

      glen2d(1)    = ed32 - sd32
      glen2d(2)    = ed33 - sd33
      glenx2d(1)   = ed32 - sd32 + 1   ! x-staggering
      glenx2d(2)   = ed33 - sd33
      gleny2d(1)   = ed32 - sd32
      gleny2d(2)   = ed33 - sd33 + 1   ! y-staggering
      decomp2d(1)  = RSL_M
      decomp2d(2)  = RSL_N

         CASE ( DATA_ORDER_XYZ )
      glen(1)    = ed31 - sd31
      glen(2)    = ed32 - sd32
      glen(3)    = ed33 - sd33 + 1

      glenx(1)   = ed31 - sd31 + 1
      glenx(2)   = ed32 - sd32       ! x-staggering
      glenx(3)   = ed33 - sd33 + 1

      gleny(1)   = ed31 - sd31
      gleny(2)   = ed32 - sd32 + 1
      gleny(3)   = ed33 - sd33 + 1   ! y-staggering

      glen2d(1)    = ed31 - sd31
      glen2d(2)    = ed32 - sd32
      glenx2d(1)   = ed31 - sd31 + 1   ! x-staggering
      glenx2d(2)   = ed32 - sd32
      gleny2d(1)   = ed31 - sd31
      gleny2d(2)   = ed32 - sd32 + 1   ! y-staggering
      decomp2d(1)  = RSL_M
      decomp2d(2)  = RSL_N

         CASE ( DATA_ORDER_XZY )
      glen(1)    = ed31 - sd31
      glen(2)    = ed32 - sd32 + 1
      glen(3)    = ed33 - sd33

      glenx(1)   = ed31 - sd31 + 1
      glenx(2)   = ed32 - sd32 + 1
      glenx(3)   = ed33 - sd33       ! x-staggering

      gleny(1)   = ed31 - sd31
      gleny(2)   = ed32 - sd32 + 1   ! y-staggering
      gleny(3)   = ed33 - sd33 + 1

      glen2d(1)    = ed31 - sd31
      glen2d(2)    = ed33 - sd33
      glenx2d(1)   = ed31 - sd31 + 1   ! x-staggering
      glenx2d(2)   = ed33 - sd33
      gleny2d(1)   = ed31 - sd31
      gleny2d(2)   = ed33 - sd33 + 1   ! y-staggering
      decomp2d(1)  = RSL_M
      decomp2d(2)  = RSL_N
#else
         CASE ( DATA_ORDER_XZY )
      glen(1)    = ed31 - sd31
      glen(2)    = ed32 - sd32 + 1
      glen(3)    = ed33 - sd33

      glen2d(1)    = ed31 - sd31
      glen2d(2)    = ed33 - sd33

      decompx(1)   = RSL_M_STAG
      decompx(2)   = RSL_NOTDECOMPOSED
      decompx(3)   = RSL_N
      decompy(1)   = RSL_M
      decompy(2)   = RSL_NOTDECOMPOSED
      decompy(3)   = RSL_N_STAG

      decomp2d(1)  = RSL_M
      decomp2d(2)  = RSL_N

      decompx2d(1)  = RSL_M_STAG
      decompx2d(2)  = RSL_N

      decompy2d(1)  = RSL_M
      decompy2d(2)  = RSL_N_STAG

#endif
         CASE DEFAULT
            CALL wrf_error_fatal ( "module_dm: define_rk_comms_rsl: unsuppported data order" )

      END SELECT

#  include <rslperiods.inc>

   ! End of periodic BC defs.  Restore these to normal (that is,
   ! glen is the maximum size of a field.
      glen(1)   = ed31 - sd31 + 1
      glen(2)   = ed32 - sd32 + 1
      glen(3)   = ed33 - sd33 + 1

      RETURN
   END SUBROUTINE define_rk_comms_rsl

!------------------------------------------------------------------

   SUBROUTINE patch_domain_rsl( id  , domdesc , parent_id , parent_domdesc , &
                                sd1 , ed1 , sp1 , ep1 , sm1 , em1 ,        &
                                sd2 , ed2 , sp2 , ep2 , sm2 , em2 ,        &
                                sd3 , ed3 , sp3 , ep3 , sm3 , em3 ,        &
                                sd4 , ed4 , sp4 , ep4 , sm4 , em4 ,        &
                                bdx , bdy )

      USE module_domain
      USE module_machine

      IMPLICIT NONE
      INTEGER, INTENT(IN)   :: sd1 , ed1 , sd2 , ed2 , sd3 , ed3 , sd4 , ed4 , bdx , bdy
      INTEGER, INTENT(OUT)  :: sp1 , ep1 , sp2 , ep2 , sp3 , ep3 , &
                               sm1 , em1 , sm2 , em2 , sm3 , em3
      INTEGER, INTENT(IN)   :: sp4 , ep4 , sm4 , em4
      INTEGER, INTENT(IN)   :: id
      INTEGER, INTENT(OUT)  :: domdesc
      INTEGER, INTENT(IN)   :: parent_id
      INTEGER, INTENT(IN)   :: parent_domdesc

# include <rsl.inc>
      INTEGER               :: mloc , nloc , mglob , nglob
      INTEGER               :: idim , jdim , i
      INTEGER , PARAMETER   :: rsl_jjx_x = 512
      INTEGER , DIMENSION( rsl_jjx_x ) :: rsl_js_x0 , rsl_je_x0 , rsl_is_x0 , rsl_ie_x0
      INTEGER                          :: rsl_xinest_x0 , rsl_idif_x0 , rsl_jdif_x0
      INTEGER               :: i_mother_start , j_mother_start
                     

      SELECT CASE ( model_data_order )
         ! need to finish other cases
         CASE ( DATA_ORDER_ZXY )
            idim = ed2-sd2+1
            jdim = ed3-sd3+1
         CASE ( DATA_ORDER_XYZ )
            idim = ed1-sd1+1
            jdim = ed2-sd2+1
         CASE ( DATA_ORDER_XZY )
            idim = ed1-sd1+1
            jdim = ed3-sd3+1
      END SELECT
      if ( id == 1 ) then
         CALL rsl_mother_domain(domdesc, RSL_24PT, idim, jdim, mloc, nloc )
      else
         CALL get_i_mother_start( id , i_mother_start )
         CALL get_i_mother_start( id , j_mother_start )
         CALL RSL_SPAWN_REGULAR_NEST1(         &
                domdesc,                       &
                parent_domdesc,                &
                RSL_24PT,                      &
                i_mother_start,j_mother_start, &
                idim,jdim,                     &
                3,3,                           &
                mloc,nloc,                     &
                mglob,nglob)
      endif
      CALL show_domain_decomp(domdesc)
      CALL RSL_REG_RUN_INFOP(domdesc , 0 ,               &
                             rsl_jjx_x ,                 &
                             rsl_xinest_x0 ,             &
                             rsl_is_x0 , rsl_ie_x0 ,     &
                             rsl_js_x0 , rsl_je_x0 ,     &
                             rsl_idif_x0 , rsl_jdif_x0   )

      SELECT CASE ( model_data_order )
         CASE ( DATA_ORDER_ZXY )
         ! k dimension
           sp1 = sd1
           ep1 = ed1
           sm1 = sp1
           em1 = ep1

         ! i and j patch dimensions
           sp2 = rsl_is_x0(1) - rsl_idif_x0
           ep2 = rsl_ie_x0(ed2) - rsl_idif_x0
           sp3 = rsl_js_x0(1) - rsl_jdif_x0
           ep3 = rsl_je_x0(ed3) - rsl_jdif_x0

         ! i and j memory dimensions
           sm2 = sp2 - rsl_padarea
           em2 = sm2 + mloc - 1
           sm3 = sp3 - rsl_padarea
           em3 = sm3 + nloc - 1

         CASE ( DATA_ORDER_XZY )

         ! k dimension
           sp2 = sd2
           ep2 = ed2
           sm2 = sp2
           em2 = ep2

         ! i and j patch dimensions
           sp1 = rsl_is_x0(1) - rsl_idif_x0
           ep1 = rsl_ie_x0(ed1) - rsl_idif_x0
           sp3 = rsl_js_x0(1) - rsl_jdif_x0
           ep3 = rsl_je_x0(ed3) - rsl_jdif_x0

         ! i and j memory dimensions
           sm1 = sp1 - rsl_padarea
           em1 = sm1 + mloc - 1
           sm3 = sp3 - rsl_padarea
           em3 = sm3 + nloc - 1

         CASE ( DATA_ORDER_XYZ )

         ! k dimension
           sp3 = sd3
           ep3 = ed3
           sm3 = sp3
           em3 = ep3

         ! i and j patch dimensions
           sp1 = rsl_is_x0(1) - rsl_idif_x0
           ep1 = rsl_ie_x0(ed1) - rsl_idif_x0
           sp2 = rsl_js_x0(1) - rsl_jdif_x0
           ep2 = rsl_je_x0(ed2) - rsl_jdif_x0

         ! i and j memory dimensions
           sm1 = sp1 - rsl_padarea
           em1 = sm1 + mloc - 1
           sm2 = sp2 - rsl_padarea
           em2 = sm2 + nloc - 1

      END SELECT

      RETURN
   END SUBROUTINE patch_domain_rsl

   SUBROUTINE init_module_dm
#  include <rsl.inc>
      external rsl_patch_decomp
      CALL rsl_initialize
# ifndef T3E
      CALL rsl_error_dup
# else
      CALL error_dup( rsl_myproc )
# endif
      CALL set_def_decomp_fcn ( rsl_patch_decomp )
   END SUBROUTINE init_module_dm

#else
  CONTAINS
   SUBROUTINE init_module_dm
   END SUBROUTINE init_module_dm

#endif

END MODULE module_dm

!=========================================================================

#if defined(DM_PARALLEL) && defined(RSL)

SUBROUTINE wrf_get_myproc( myproc )
  IMPLICIT NONE
# include <rsl.inc>
  INTEGER myproc
  myproc = rsl_myproc
  RETURN
END SUBROUTINE wrf_get_myproc

SUBROUTINE patch_domain ( id  , domdesc , parent_id , parent_domdesc , &
                          sd1 , ed1 , sp1 , ep1 , sm1 , em1 , &
                          sd2 , ed2 , sp2 , ep2 , sm2 , em2 , &
                          sd3 , ed3 , sp3 , ep3 , sm3 , em3 , &
                          sd4 , ed4 , sp4 , ep4 , sm4 , em4 , &
                          bdx , bdy )
   USE module_dm
   IMPLICIT NONE
   INTEGER, INTENT(IN)   :: sd1 , ed1 , sd2 , ed2 , sd3 , ed3 , sd4 , ed4 , bdx , bdy
   INTEGER, INTENT(OUT)  :: sp1 , ep1 , sp2 , ep2 , sp3 , ep3 , &
                            sm1 , em1 , sm2 , em2 , sm3 , em3
   INTEGER, INTENT(IN)   :: sp4 , ep4 , sm4 , em4
   INTEGER, INTENT(INOUT):: id  , domdesc , parent_id , parent_domdesc

   CALL patch_domain_rsl ( id  , domdesc , parent_id , parent_domdesc , &
                           sd1 , ed1 , sp1 , ep1 , sm1 , em1 , &
                           sd2 , ed2 , sp2 , ep2 , sm2 , em2 , &
                           sd3 , ed3 , sp3 , ep3 , sm3 , em3 , &
                           sd4 , ed4 , sp4 , ep4 , sm4 , em4 , &
                           bdx , bdy )

   RETURN
END SUBROUTINE patch_domain

SUBROUTINE wrf_dm_bcast_bytes ( buf , size )
   USE module_dm
   IMPLICIT NONE
   INTEGER size
   INTEGER*1 BUF(size)
   CALL rsl_mon_bcast( buf , size )
   RETURN
END SUBROUTINE wrf_dm_bcast_bytes

SUBROUTINE wrf_dm_bcast_string( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   CHARACTER*(*) buf
   INTEGER ibuf(256),i,n
   CHARACTER*256 tstr
   n = n1
   IF (n .GT. 256) n = 256
   IF (n .GT. 0 ) then
     CALL rsl_mon_bcast( n , IWORDSIZE )
     DO i = 1, n
       ibuf(I) = ichar(buf(I:I))
     ENDDO
     CALL rsl_mon_bcast( ibuf, n*IWORDSIZE )
     buf = ''
     DO i = 1, n
       buf(i:i) = char(ibuf(i))
     ENDDO
   ENDIF
   RETURN
END SUBROUTINE wrf_dm_bcast_string

SUBROUTINE wrf_dm_bcast_integer( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   INTEGER  buf(*)
   CALL rsl_mon_bcast( BUF , N1 * IWORDSIZE )
   RETURN
END SUBROUTINE wrf_dm_bcast_integer

SUBROUTINE wrf_dm_bcast_real( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   REAL  buf(*)
   CALL rsl_mon_bcast( BUF , N1 * RWORDSIZE )
   RETURN
END SUBROUTINE wrf_dm_bcast_real

SUBROUTINE wrf_dm_bcast_logical( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   LOGICAL  buf(*)
   CALL rsl_mon_bcast( BUF , N1 * LWORDSIZE )
   RETURN
END SUBROUTINE wrf_dm_bcast_logical

SUBROUTINE wrf_dm_halo ( domdesc , comms , stencil_id )
   USE module_dm
   IMPLICIT NONE
   INTEGER domdesc , comms(*) , stencil_id
   CALL rsl_exch_stencil ( domdesc , comms( stencil_id ) )
   RETURN
END SUBROUTINE wrf_dm_halo

SUBROUTINE wrf_dm_boundary ( domdesc , comms , period_id , &
                             periodic_x , periodic_y )
   USE module_dm
   IMPLICIT NONE
   INTEGER domdesc , comms(*) , period_id
   LOGICAL , INTENT(IN)      :: periodic_x, periodic_y
# include <rsl.inc>

   IF ( periodic_x ) THEN
     CALL rsl_exch_period ( domdesc , comms( period_id ) , RSL_M )
   END IF
   IF ( periodic_y ) THEN
     CALL rsl_exch_period ( domdesc , comms( period_id ) , RSL_N )
   END IF
   RETURN
END SUBROUTINE wrf_dm_boundary

SUBROUTINE define_comms ( grid )
   USE module_domain
   USE module_dm
   IMPLICIT NONE
   TYPE(domain) , INTENT (INOUT) :: grid 
   INTEGER dyn_opt
   INTEGER idum1, idum2

#ifdef DEREF_KLUDGE
   INTEGER     :: sm31 , em31 , sm32 , em32 , sm33 , em33
#endif

#ifdef DEREF_KLUDGE
   sm31             = grid%sm31
   em31             = grid%em31
   sm32             = grid%sm32
   em32             = grid%em32
   sm33             = grid%sm33
   em33             = grid%em33
#endif

   CALL get_dyn_opt( dyn_opt )

   CALL set_scalar_indices_from_config ( grid%id , idum1 , idum2 )

   IF ( dyn_opt .eq. 1 .or. dyn_opt .eq. 2 .or. dyn_opt .eq. 3 ) THEN
     CALL define_rk_comms_rsl( grid%domdesc , grid%comms, WRF_RSL_RK_NCOMMS , &
!
#include <rk_actual_args.inc>
!
                        )
   ELSE
     WRITE ( wrf_err_message , * ) ' RSL-DM not implemented for dyn_opt = ',dyn_opt
     CALL wrf_error_fatal ( TRIM ( wrf_err_message ) ) 
   ENDIF
   RETURN
END SUBROUTINE define_comms

SUBROUTINE write_68( v , s , &
                   ids, ide, jds, jde, kds, kde, &
                   ims, ime, jms, jme, kms, kme, &
                   its, ite, jts, jte, kts, kte )
  IMPLICIT NONE
  CHARACTER *(*) s
  INTEGER ids, ide, jds, jde, kds, kde, &
          ims, ime, jms, jme, kms, kme, &
          its, ite, jts, jte, kts, kte
  REAL, DIMENSION( ims:ime , kms:kme, jms:jme ) :: v
# include <rsl.inc>

  INTEGER i,j,k

  WRITE(rsl_myproc+68,*) ime-ims+1, jme-jms+1 , s
  DO j = jms, jme
  DO i = ims, ime
     WRITE(rsl_myproc+68,*) v(i,1,j)
  ENDDO
  ENDDO
  RETURN
  END

   SUBROUTINE wrf_abort
      CALL mpi_abort(ierr)
   END SUBROUTINE wrf_abort

   SUBROUTINE shutdown_dm_parallel
# include <rsl.inc>
      CALL RSL_SHUTDOWN
      RETURN
   END SUBROUTINE shutdown_dm_parallel

   LOGICAL FUNCTION wrf_on_monitor()
      LOGICAL rsl_iammonitor
      EXTERNAL rsl_iammonitor
      wrf_on_monitor = rsl_iammonitor()
      RETURN
   END FUNCTION wrf_on_monitor

   SUBROUTINE get_dm_communicator ( communicator )
      IMPLICIT NONE
      INTEGER , INTENT(OUT) :: communicator
      CALL rsl_get_communicator ( communicator )
      RETURN
   END SUBROUTINE get_dm_communicator

   SUBROUTINE dm_patch_to_global_real (buf,globbuf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
       USE module_timing
       USE module_wrf_error
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER                         ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
       INTEGER fid,domdesc,ndim,glen(3),llen(3)
       REAL globbuf(*)
       REAL buf(*)
       INTEGER i, j, k

       IF ( wrf_at_debug_level(500) ) THEN
         CALL start_timing
       ENDIF
       IF ( ndim .EQ. 3 ) THEN
         glen(1) = ide-ids+1
         glen(2) = kde-kds+1
         glen(3) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = kme-kms+1
         llen(3) = jme-jms+1
         CALL rsl_write(globbuf,   &
           io3d_ikj_internal,buf,domdesc,rsl_real,glen,llen)
       ELSE
         glen(1) = ide-ids+1
         glen(2) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = jme-jms+1
         CALL RSL_WRITE(globbuf,   &
           io2d_ij_internal, buf,domdesc,rsl_real,glen,llen)
       ENDIF
       IF ( wrf_at_debug_level(500) ) THEN
         CALL end_timing('dm_patch_to_global_real')
       ENDIF
       RETURN
    END SUBROUTINE dm_patch_to_global_real

    SUBROUTINE dm_global_to_patch_real (globbuf,buf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER                         ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
       INTEGER fid,domdesc,ndim,glen(3),llen(3)
       REAL globbuf(*)
       REAL buf(*)
       INTEGER i,j,k


       IF ( ndim .EQ. 3 ) THEN
         glen(1) = ide-ids+1
         glen(2) = kde-kds+1
         glen(3) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = kme-kms+1
         llen(3) = jme-jms+1
         CALL rsl_read(globbuf,          &
           io3d_ikj_internal,buf,domdesc,rsl_real,glen,llen)
       ELSE
         glen(1) = ide-ids+1
         glen(2) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = jme-jms+1
         CALL rsl_read(globbuf,          &
           io2d_ij_internal, buf,domdesc,rsl_real,glen,llen)
       ENDIF
       RETURN
    END SUBROUTINE dm_global_to_patch_real

   SUBROUTINE dm_patch_to_global_integer (buf,globbuf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER                         ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
       INTEGER fid,domdesc,ndim,glen(3),llen(3)
       INTEGER globbuf(*)
       INTEGER buf(*)
       INTEGER i, j, k
       IF ( ndim .EQ. 3 ) THEN
         glen(1) = ide-ids+1
         glen(2) = kde-kds+1
         glen(3) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = kme-kms+1
         llen(3) = jme-jms+1
         CALL rsl_write(globbuf,   &
           io3d_ikj_internal,buf,domdesc,rsl_integer,glen,llen)
       ELSE
         glen(1) = ide-ids+1
         glen(2) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = jme-jms+1
         CALL RSL_WRITE(globbuf,   &
           io2d_ij_internal, buf,domdesc,rsl_integer,glen,llen)
       ENDIF
       RETURN
    END SUBROUTINE dm_patch_to_global_integer

    SUBROUTINE dm_global_to_patch_integer (globbuf,buf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER                         ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
       INTEGER fid,domdesc,ndim,glen(3),llen(3)
       INTEGER globbuf(*)
       INTEGER buf(*)
       INTEGER i,j,k
       IF ( ndim .EQ. 3 ) THEN
         glen(1) = ide-ids+1
         glen(2) = kde-kds+1
         glen(3) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = kme-kms+1
         llen(3) = jme-jms+1
         CALL rsl_read(globbuf,          &
           io3d_ikj_internal,buf,domdesc,rsl_integer,glen,llen)
       ELSE
         glen(1) = ide-ids+1
         glen(2) = jde-jds+1
         llen(1) = ime-ims+1
         llen(2) = jme-jms+1
         CALL rsl_read(globbuf,          &
           io2d_ij_internal, buf,domdesc,rsl_integer,glen,llen)
       ENDIF
       RETURN
    END SUBROUTINE dm_global_to_patch_integer

#else

! These are stub functions that do the right thing (usually nothing)
! in case DM_PARALLEL is not compiled for.

LOGICAL FUNCTION wrf_on_monitor()
  wrf_on_monitor = .true.
END FUNCTION wrf_on_monitor

SUBROUTINE wrf_dm_bcast_string ( buf , size )
  IMPLICIT NONE
  INTEGER size
  INTEGER*1 BUF(size)
  RETURN
END SUBROUTINE wrf_dm_bcast_string

SUBROUTINE wrf_dm_bcast_bytes ( buf , size )
  IMPLICIT NONE
  INTEGER size
  INTEGER*1 BUF(size)
  RETURN
END SUBROUTINE wrf_dm_bcast_bytes

SUBROUTINE wrf_dm_bcast_integer( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   INTEGER  buf(*)
   RETURN
END SUBROUTINE wrf_dm_bcast_integer

SUBROUTINE wrf_dm_bcast_real( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   REAL  buf(*)
   RETURN
END SUBROUTINE wrf_dm_bcast_real

SUBROUTINE wrf_dm_bcast_logical( BUF, N1 )
   IMPLICIT NONE
   INTEGER n1
   LOGICAL  buf(*)
   RETURN
END SUBROUTINE wrf_dm_bcast_logical

SUBROUTINE wrf_dm_halo ( domdesc , comms , stencil_id )
   IMPLICIT NONE
   INTEGER domdesc , comms(*) , stencil_id
   RETURN
END SUBROUTINE wrf_dm_halo

SUBROUTINE wrf_dm_boundary ( domdesc , comms , period_id , &
                             periodic_x , periodic_y )
   IMPLICIT NONE
   INTEGER domdesc , comms(*) , period_id
   LOGICAL , INTENT(IN)      :: periodic_x, periodic_y
   RETURN
END SUBROUTINE wrf_dm_boundary

SUBROUTINE define_comms ( grid )
   USE module_domain
   IMPLICIT NONE
   TYPE(domain) , INTENT (INOUT) :: grid
   RETURN
END SUBROUTINE define_comms

SUBROUTINE get_dm_communicator ( communicator )
   IMPLICIT NONE
   INTEGER , INTENT(OUT) :: communicator
   communicator = 0
   RETURN
END SUBROUTINE get_dm_communicator

SUBROUTINE shutdown_dm_parallel
      RETURN
END SUBROUTINE shutdown_dm_parallel
SUBROUTINE wrf_abort
      STOP 'wrf_abort'
END SUBROUTINE wrf_abort

SUBROUTINE dm_patch_to_global_real (buf,globbuf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
   IMPLICIT NONE
   INTEGER                             ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
   INTEGER fid,domdesc,ndim,glen(3),llen(3)
   REAL globbuf(*)
   REAL buf(*)
   RETURN
END SUBROUTINE dm_patch_to_global_real

SUBROUTINE dm_global_to_patch_real (globbuf,buf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
   IMPLICIT NONE
   INTEGER                             ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
   INTEGER fid,domdesc,ndim,glen(3),llen(3)
   REAL globbuf(*)
   REAL buf(*)
   CALL wrf_message('dm_global_to_patch_real stub')
   RETURN
END SUBROUTINE dm_global_to_patch_real

SUBROUTINE dm_patch_to_global_integer (buf,globbuf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
   IMPLICIT NONE
   INTEGER                             ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
   INTEGER fid,domdesc,ndim,glen(3),llen(3)
   INTEGER globbuf(*)
   INTEGER buf(*)
   RETURN
END SUBROUTINE dm_patch_to_global_integer

SUBROUTINE dm_global_to_patch_integer (globbuf,buf,domdesc,ndim,&
                                       ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe )
   IMPLICIT NONE
   INTEGER                             ids,ide,jds,jde,kds,kde,&
                                       ims,ime,jms,jme,kms,kme,&
                                       ips,ipe,jps,jpe,kps,kpe
   INTEGER fid,domdesc,ndim,glen(3),llen(3)
   INTEGER globbuf(*)
   INTEGER buf(*)
   RETURN
END SUBROUTINE dm_global_to_patch_integer

#endif



