!WRF:MEDIATION_LAYER:SOLVER
!

SUBROUTINE solve_rk ( grid ,               &
!
#include "rk_dummy_args.inc"
!
                 )


! Driver layer modules
   USE module_domain
   USE module_configure
   USE module_driver_constants
   USE module_machine
   USE module_tiles
! Mediation layer modules
! Model layer modules
   USE module_model_constants
   USE module_small_step
   USE module_rk
   USE module_big_step_utilities
   USE module_bc
   USE module_solvedebug
   USE module_microphysics
   USE module_diffusion
! Registry generated module
   USE module_state_description

   IMPLICIT NONE

   !  Subroutine interface block.

   INTERFACE
      INCLUDE 'physics_drive.int'
   END INTERFACE

   !  Input data.

   TYPE(domain) , TARGET          :: grid

   !  Definitions of dummy arguments to solve
#include <rk_dummy_arg_defines.inc>

   !  WRF state bcs
   TYPE (grid_config_rec_type)              :: config_flags

   ! WRF state data

   ! Local data

   INTEGER                         :: k_start , k_end
   INTEGER                         :: ids , ide , jds , jde , kds , kde , &
                                      ims , ime , jms , jme , kms , kme , &
                                      ips , ipe , jps , jpe , kps , kpe
   INTEGER                         :: ij , iteration
   INTEGER                         :: im , num_3d_m , ic , num_3d_c
   INTEGER                         :: loop
   INTEGER                         :: ijds, ijde

! storage for tendencies and decoupled state (generated from Registry)
#include <rk_i1.inc>

integer , dimension(grid%sm31:grid%em31,grid%sm33:grid%em31) :: xxxxx , yyyyy , zzzzz , xx1 , xx2 , xx3

   INTEGER :: number_of_small_timesteps, rk_step
   INTEGER :: klevel,ijm,ijp,i,j,k,size1,size2    ! for prints/plots only
   INTEGER :: idum1, idum2

   INTEGER :: rk_order
   REAL :: dt_rk, dts_rk

#ifdef DM_PARALLEL
#  ifdef RSL
#    define REGISTER_I1
#      include <rsl_rk_data_calls.inc>
#  endif
#endif

   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )
! this sets up the P_* indices into the moisture and chem arrays
   CALL set_scalar_indices_from_config ( grid%id , idum1 , idum2 )

 
!
!  set runge-kutta solver for 2nd or 3rd order scheme
!
   IF (config_flags%dyn_opt == 2) THEN
     rk_order = 2
   ELSE
     rk_order = 3
   ENDIF

   !  De-reference dimension information stored in the grid data structure.

!                    ikj model   kij model

   ids             = grid%sd31 ! grid%sd32 
   ide             = grid%ed31 ! grid%ed32 
   jds             = grid%sd33 ! grid%sd33 
   jde             = grid%ed33 ! grid%ed33 
   kds             = grid%sd32 ! grid%sd31 
   kde             = grid%ed32 ! grid%ed31

   ims             = grid%sm31 ! grid%sm32
   ime             = grid%em31 ! grid%em32 
   jms             = grid%sm33 ! grid%sm33 
   jme             = grid%em33 ! grid%em33 
   kms             = grid%sm32 ! grid%sm31 
   kme             = grid%em32 ! grid%em31

   ips             = grid%sp31 ! grid%sp32
   ipe             = grid%ep31 ! grid%ep32
   jps             = grid%sp33 ! grid%sp33
   jpe             = grid%ep33 ! grid%ep33
   kps             = grid%sp32 ! grid%sp31
   kpe             = grid%ep32 ! grid%ep31

   k_start         = grid%sd32 ! grid%sd31
   k_end           = grid%ed32 ! grid%ed31

   ijds = min(ids, jds)
   ijde = max(ide, jde)

   num_3d_m        = num_moist
   num_3d_c        = num_chem

   !  Compute these starting and stopping locations for each tile and number of tiles.

   CALL set_tiles ( grid , ids , ide , jds , jde , ips , ipe , jps , jpe )

! JM need this to avoid floating point exception in call to moist_physics_prep (12/11/99)
! The other solvers don't need this because they set rt_1 in their prep routines.
   rt_1 = 0

!**********************************************************************
!
!  LET US BEGIN.......
!
!  RK integration loop.  predictor-corrector type time integration.
!  Advection terms are evaluated at time t for the predictor step,
!  and advection is re-evaluated with the latest predicted value for
!  each succeeding time corrector step
!
!  2nd order Runge Kutta (rk_order = 2):
!  Step 1 is taken to the midpoint predictor, step 2 is the full step.
!
!  3rd order Runge Kutta (rk_order = 3):
!  Step 1 is taken to from t to dt/3, step 2 is from t to dt/2,
!  and step 3 is from t to dt.
!
!**********************************************************************


 Runge_Kutta_loop:  DO rk_step = 1, rk_order

   !  Set the step size and number of small timesteps for
   !  each part of the RK step

   IF ( rk_order == 2 ) THEN   ! 2nd order Runge-Kutta timestep

       IF ( rk_step == 1) THEN
             dt_rk  = 0.5*dt
             dts_rk = dts
             number_of_small_timesteps = time_step_sound/2
       ELSE
             dt_rk = dt
             dts_rk = dts
             number_of_small_timesteps = time_step_sound
       ENDIF

   ELSE  ! third order Runge-Kutta

       IF ( rk_step == 1) THEN
            dt_rk = dt/3.
!            dts_rk = dts
!            number_of_small_timesteps = time_step_sound/3
            dts_rk = dt_rk
            number_of_small_timesteps = 1
       ELSE IF (rk_step == 2) THEN
            dt_rk  = 0.5*dt
            dts_rk = dts
            number_of_small_timesteps = time_step_sound/2
       ELSE
            dt_rk = dt
            dts_rk = dts
            number_of_small_timesteps = time_step_sound
       ENDIF

   END IF

!
!  Time level t is in the *_2 variable in the first part 
!  of the step, and in the *_1 variable after the predictor.
!  the latest predicted values are stored in the *_2 variables.
!

   CALL wrf_debug ( 200 , ' call rk_step_prep ' )

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

      CALL rk_step_prep ( config_flags,                           &
                           ru_2, rv_2, rom_2, rtp_2, rrp_2, rr_2,  &
                           u_2, v_2, rw_2, w_2, rt_2, t_2, tp_2,   &
                           moist_2,                                &
                           rtb, rrb, pb, pib, pp, pip,             &
                           zx, zy, msft, zeta_z, z_zeta,           &
                           fzm, fzp, cf1, cf2, cf3,                &
                           num_3d_m,                               &
                           ids, ide, jds, jde, kds, kde,           &
                           ims, ime, jms, jme, kms, kme,           &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start, k_end                         )

   END DO

#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
!  Stencils for patch communications  (WCS, 9 february 1999).
!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * * 
!         *        * * *    * * * * *
!                           * * * * *
!j u_2                          x
!j v_2                          x
!j w_2                          x
!j t_2                          x
!j tp_2                         x
!j rw_2                         x
!j rom_2                        x
!j pp     x                    (x)
!j pip    x                    (x)
!--------------------------------------------------------------
   IF      ( h_mom_adv_order == 3 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_A_3 )
   ELSE IF ( h_mom_adv_order == 5 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_A_5 )
   ELSE
     WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#endif

! set boundary conditions on variables 
! from big_step_prep for use in big_step_proc

#ifdef DM_PARALLEL
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_A , &
                         config_flags%periodic_x , config_flags%periodic_y )
#endif

!   CALL set_tiles ( grid , ids , ide , jds , jde , ips-1 , ipe+1 , jps-1 , jpe+1 )

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call rk_phys_bc_dry_1' )
       CALL rk_phys_bc_dry_1( config_flags, u_2, v_2,        &
                               rw_2, w_2, rr_2,               &
                               t_2, tp_2, pp, pip,            &
                               ids, ide, jds, jde, kds, kde,  &
                               ims, ime, jms, jme, kms, kme,  &
                               ips, ipe, jps, jpe, kps, kpe,  &
                               grid%i_start(ij), grid%i_end(ij),        &
                               grid%j_start(ij), grid%j_end(ij),        &
                               k_start, k_end                )

   END DO

!   CALL set_tiles ( grid , ids , ide , jds , jde , ips , ipe , jps , jpe )

    rk_step_is_one : IF (rk_step == 1) THEN ! only need to initialize diffusion tendencies
                                             ! when rk_step=1

 ! initialize all tendencies to zero in order to update physics
 ! tendencies first (separate from dry dynamics).
 
     !$OMP PARALLEL DO   &
     !$OMP PRIVATE ( ij )

     DO ij = 1 , grid%num_tiles

        CALL wrf_debug ( 200 , ' call init_zero_tendency' )
        CALL init_zero_tendency ( ru_old, rv_old, rom_old, rtp_old,    &
                                  rrp_old, tke_tend, th_mix, qv_mix,   &
                                  moist_tend,chem_tend,                &
                                  num_3d_m,num_3d_c,rk_step,          &
                                  ids, ide, jds, jde, kds, kde,        &
                                  ims, ime, jms, jme, kms, kme,        &
                                  grid%i_start(ij), grid%i_end(ij),              &
                                  grid%j_start(ij), grid%j_end(ij),              &
                                  k_start, k_end                       )

     END DO



#ifdef DM_PARALLEL
! prepare vars for physics.
!         *                         these are needed for 
!         + *                       c to a averaging of u and v
!
! u_2     x
! v_2     x
   CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_PHYS_A )
#endif

      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )
      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call phy_prep' )
         CALL phy_prep ( config_flags, rr_2, rt_2 , th_phy ,           &
                         moist_2, p_phy , pi_phy , pb, pb8w,           &
                         u_phy, v_phy, u_2, v_2, msft,                 &
                         RHOBASE, p8w, dz8w, t_phy, t8w, dzetaw,       &
                         zeta_z, zeta, zetaw, TSK,                     &
                         fzm, fzp, num_3d_m,                           &
                         ids, ide, jds, jde, kds, kde,                 &
                         ims, ime, jms, jme, kms, kme,                 &
                         grid%i_start(ij), grid%i_end(ij),                       &
                         grid%j_start(ij), grid%j_end(ij),                       &
                         k_start, k_end                               )
      ENDDO

!      CALL set_tiles ( grid , ids , ide-1 , jds , jde-1 ips , ipe , jps , jpe )

! radiation

      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call radiation_driver' )
         CALL radiation_driver(itimestep,dt,                         &
                    RTHRATENLW,RTHRATENSW,RTHRATEN,GLW,GSW,          &
                    XLAT,XLONG,ALB,CLDFRA,EMISS,                     &
                    RHOBASE,rr_2,moist_2,num_3d_m,                   &
                    p8w,p_phy,pb,pi_phy,dz8w,t_phy,t8w,              &
                    GMT,JULDAY,config_flags,RADT,STEPRA,ICLOUD,      &
                    taucldi,taucldc,                                 &
                    ids,ide, jds,jde, kds,kde,                       &
                    ims,ime, jms,jme, kms,kme,                       &
                    grid%i_start(ij), min(grid%i_end(ij),ide-1),               &
                    grid%j_start(ij), min(grid%j_end(ij),jde-1),               &
                    k_start    , min(k_end,kde-1)                    )
      ENDDO

! pbl

      print*,'u_frame=',u_frame,v_frame
      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call pbl_driver' )
         CALL pbl_driver(itimestep,dt,u_frame,v_frame,              &
                  RUBLTEN,RVBLTEN,RTHBLTEN,                         &
                  RQVBLTEN,RQCBLTEN,RQIBLTEN,                       &
                  GLW,GSW,EMISS,TSK,TMN,XLAND,ZNT,MAVAIL,           &
                  UST,HOL,MOL,PBLH,CAPG,THC,                        &
                  SNOWC,HFX,QFX,REGIME,                             &
                  rr_2,u_phy,v_phy,th_phy,moist_2,                  &
                  p_phy,pb,pb8w,pi_phy,p8w,t_phy,dz8w,z,            &
                  config_flags,                                     &
                  DX,num_3d_m,                                      &
                  TSLB,ZS,DZS,num_soil_layers,STEPBL,IFSNOW,ISFFLX, &
                  ids,ide, jds,jde, kds,kde,                        &
                  ims,ime, jms,jme, kms,kme,                        &
                  grid%i_start(ij), min(grid%i_end(ij),ide-1),      &
                  grid%j_start(ij), min(grid%j_end(ij),jde-1),      &
                  k_start    , min(k_end,kde-1)                     )
      ENDDO

! cumulus para.

      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call cumulus_driver' )
         CALL cumulus_driver(itimestep,dt,DX,num_3d_m,                 &
                     rr_2,RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN,         &
                     RQICUTEN,RQSCUTEN,RAINC,RAINCV,NCA,               &
                     u_phy,v_phy,th_phy,t_phy,w_2,moist_2,             &
                     dz8w,p8w,p_phy,pi_phy,config_flags,               &
                     W0AVG,RHOBASE,STEPCU,                             &
                     CLDEFI,LOWLYR,XLAND,                              &
                     ids,ide, jds,jde, kds,kde,                        &
                     ims,ime, jms,jme, kms,kme,                        &
                     grid%i_start(ij), min(grid%i_end(ij),ide-1),                &
                     grid%j_start(ij), min(grid%j_end(ij),jde-1),                &
                     k_start    , min(k_end,kde-1)                     )
      ENDDO

     IF(diff_opt .eq. 2) THEN

       !$OMP PARALLEL DO   &
       !$OMP PRIVATE ( ij )

       DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call cal_deform_and_div' )
          CALL cal_deform_and_div ( config_flags,u_2,v_2,w_2,div,        &
                                    defor11,defor22,defor33,defor12,     &
                                    defor13,defor23,                     &
                                    u_base, v_base,msfu,msfv,msft,       &
                                    rdx, rdy, dzeta,dzetaw,              &
                                    fzm,fzp,cf1,cf2,cf3,zeta_z,zx,zy,    &
                                    ids, ide, jds, jde, kds, kde,        &
                                    ims, ime, jms, jme, kms, kme,        &
                                    grid%i_start(ij), grid%i_end(ij),              &
                                    grid%j_start(ij), grid%j_end(ij),              &
                                    k_start    , k_end                   )
       ENDDO


! calculate tke, kmh, and kmv

       !$OMP PARALLEL DO   &
       !$OMP PRIVATE ( ij )

       DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call calculate_km_kh' )
          CALL calculate_km_kh(config_flags,dt,dampcoef,zdamp,damp_opt,  &
                            xkmh,xkmhd,xkmv,xkhh,xkhv,BN2,               &
                            khdif,kvdif,div,                             &
                            defor11,defor22,defor33,defor12,             &
                            defor13,defor23,                             &
                            tke_2(ims,kms,jms),p8w,t8w,th_phy,           &
                            t_phy,p_phy,moist_2,dzeta,dzetaw,zeta_z,     &
                            dx,dy,mix_cr_len,num_3d_m,                   &
                            cf1, cf2, cf3,                               &
                            ids,ide, jds,jde, kds,kde,                   &
                            ims,ime, jms,jme, kms,kme,                   &
                            grid%i_start(ij), grid%i_end(ij),                      &
                            grid%j_start(ij), grid%j_end(ij),                      &
                            k_start    , k_end                           )
       ENDDO

#ifdef DM_PARALLEL
       CALL wrf_debug( 200 , 'calling wrf_dm_boundary for PERIOD_BDY_RK_PHY_BC' )
       CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_PHY_BC , &
                             config_flags%periodic_x , config_flags%periodic_y )
       CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_CHEM , &
                             config_flags%periodic_x , config_flags%periodic_y )
#endif

     ENDIF

     !$OMP PARALLEL DO   &
     !$OMP PRIVATE ( ij )

     DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call phy_bc' )
       CALL phy_bc (config_flags,div,defor11,defor22,defor33,            &
                            defor12,defor13,defor23,                     &
                            xkmh,xkmhd,xkmv,xkhh,xkhv,                   &
                            tke_2(ims,kms,jms),                          &
                            RUBLTEN, RVBLTEN,                            &
                            ids, ide, jds, jde, kds, kde,                &
                            ims, ime, jms, jme, kms, kme,                &
                            ips, ipe, jps, jpe, kps, kpe,                &
                            grid%i_start(ij), grid%i_end(ij),                      &
                            grid%j_start(ij), grid%j_end(ij),                      &
                            k_start    , k_end                           )
     ENDDO

#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
!
! MPP for some physics tendency, km, kh, deformation, and divergence
!
!               *                     *
!             * + *      * + *        +
!               *                     *
!
! (for PBL)
! RUBLTEN                  x
! RVBLTEN                             x
!
! (for diff_opt >= 1)
! defor11                  x
! defor22                             x
! defor12       x
! defor13                  x
! defor23                             x
! div           x
! tke           x
! xkmv          x
! xkmh          x
! xkmhd         x
! xkhv          x
! xkhh          x
!
!-----------------------------------------------------------------------
!     IF ( bl_pbl_physics .ge. 1 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_PHYS_PBL )
!     ENDIF
!     IF ( diff_opt .ge. 1 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_PHYS_DIFFUSION )
!     ENDIF
      IF      ( h_mom_adv_order == 3 ) THEN
        CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_TKE_3 )
      ELSE IF ( h_mom_adv_order == 5 ) THEN
        CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_TKE_5 )
      ELSE
        WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
        CALL wrf_error_fatal(TRIM(wrf_err_message))
      ENDIF
#endif
      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call update_phy_ten' )
        CALL update_phy_ten(rtp_old, ru_old, rv_old,moist_tend,        &
                          RTHRATEN,RTHBLTEN,RTHCUTEN,RUBLTEN,RVBLTEN,  &
                          RQVBLTEN,RQCBLTEN,RQIBLTEN,                  &
                          RQVCUTEN,RQCCUTEN,RQRCUTEN,RQICUTEN,RQSCUTEN,&
                          num_3d_m,config_flags,rk_step,              &
                          ids, ide, jds, jde, kds, kde,                &
                          ims, ime, jms, jme, kms, kme,                &
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                               )

      END DO

     IF( diff_opt .eq. 2 .and. km_opt .eq. 2 ) THEN

       !$OMP PARALLEL DO   &
       !$OMP PRIVATE ( ij )

       DO ij = 1 , grid%num_tiles

          CALL tke_rhs   (tke_tend,BN2,            &
                          config_flags,defor11,defor22,defor33,        &
                          defor12,defor13,defor23,u_2,v_2,w_2,div,     &
                          tke_2(ims,kms,jms),rr_2,                     &
                          th_phy,p_phy,p8w,t8w,z,fzm,fzp,              &
                          cf1,cf2,cf3,msft,xkmh,xkmv,xkhv,rdx,rdy,     &
                          dx,dy,zx,zy,zeta_z,dzetaw,dzeta,mix_cr_len,  &
                          ids, ide, jds, jde, kds, kde,                &
                          ims, ime, jms, jme, kms, kme,                &
                          grid%i_start(ij), grid%i_end(ij),            &
                          grid%j_start(ij), grid%j_end(ij),            &
                          k_start    , k_end                           )

       ENDDO

     ENDIF

! calculate vertical diffusion first and then horizontal
! (keep this order)

     IF(diff_opt .eq. 2) THEN

       IF (bl_pbl_physics .eq. 0) THEN

         !$OMP PARALLEL DO   &
         !$OMP PRIVATE ( ij )
         DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call vertical_diffusion_2' )
           CALL vertical_diffusion_2(ru_old, rv_old, rom_old, tke_tend,   &
                             moist_tend, num_3d_m, chem_tend, num_3d_c,   &
                             th_mix,qv_mix,tp_2,u_base,v_base,qv_base,    &
                             rr_2,tke_2,config_flags,                     &
                             defor13,defor23,defor33,                     &
                             div, moist_2, chem_2, xkmv, xkhv, km_opt,    &
                             fzm, fzp, dzetaw, dzeta, zeta_z,             &
                             ids, ide, jds, jde, kds, kde,                &
                             ims, ime, jms, jme, kms, kme,                &
                             grid%i_start(ij), grid%i_end(ij),                      &
                             grid%j_start(ij), grid%j_end(ij),                      &
                             k_start    , k_end                           )
         ENDDO
       ENDIF
!
       !$OMP PARALLEL DO   &
       !$OMP PRIVATE ( ij )
       DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call horizontal_diffusion_2' )
         CALL horizontal_diffusion_2 (rtp_old, ru_old, rv_old, rom_old, &
                           tke_tend,                                    &
                           moist_tend, num_3d_m, chem_tend, num_3d_c,   &
                           th_mix, qv_mix, tp_2, th_phy,                &
                           rr_2, tke_2, config_flags,                   &
                           defor11, defor22, defor12,                   &
                           defor13, defor23, div,                       &
                           moist_2, chem_2,                             &
                           msfu, msfv, msft, xkmhd, xkhh, km_opt,       &
                           rdx, rdy, fzm, fzp, cf1, cf2, cf3,           &
                           zx, zy, dzetaw, dzeta,                       &
                           ids, ide, jds, jde, kds, kde,                &
                           ims, ime, jms, jme, kms, kme,                &
                           grid%i_start(ij), grid%i_end(ij),                      &
                           grid%j_start(ij), grid%j_end(ij),                      &
                           k_start    , k_end                           )
       ENDDO

     ENDIF

     END IF rk_step_is_one
!

! sue

!---------------------------------------------------------------------
! exchange information for PBL U V tendencies.
!

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )
   DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call rk_tendency' )
    !  In the predictor step (rk_step == 1) the full tendency will be placed
    !  in *_tend, and the tendencies that are always evaluated at time t
    !  (the mixing terms, large step pressure gradient, etc) will be stored
    !  off in the *_old arrays (left over from the leapfrog code).
   
    !  In the second part (rk_step == 2) the full tendency will be placed
    !  again be returned in *_tend, but this tendency will be computed by
    !  recomputing the advection terms and adding back in the previously computed
    !  and stored mixing terms (and pressure gradient terms etc.).

    !  The loop variable rk_step is what is used by the subroutines to
    !  determine which procedure to follow

      CALL rk_tendency ( config_flags, rk_step,                      &
                          ru_tend, rv_tend, rw_tend, rt_tend, rr_tend, &
                          ru_2, rv_2, rom_2, rtp_2, rrp_2,             &
                          ru_old, rv_old, rom_old, rtp_old, rrp_old,   &
                          rr_2, u_2, v_2, rw_2, w_2,                   &
                          rt_2, t_2, tp_2, moist_2,                    &
                          th_mix, qv_mix, h_diabatic,                  &
                          u_base, v_base, qv_base,                     &
                          r, pp, rtb, rrb, zx, zy, z,                  &
                          msfu, msfv, msft, f, e, sina, cosa,          &
                          fzm, fzp, rdzu, rdzw, zeta_z, z_zeta,        &
                          rdx, rdy, khdif, kvdif,                      &
                          cf1, cf2, cf3, num_3d_m,                     &
                          ids, ide, jds, jde, kds, kde,                &
                          ims, ime, jms, jme, kms, kme,                &
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                              )

     IF( config_flags%specified .and. rk_step == 1 ) THEN 
       CALL relax_bdy_dry ( ru_old, rv_old, rtp_old, rrp_old,          & 
                          ru_2, rv_2, rtp_2, rrp_2,                      &
                          ru_b, rv_b, rtp_b, rrp_b,              &
                          ru_bt, rv_bt, rtp_bt, rrp_bt, &
                          spec_bdy_width, spec_zone, relax_zone,       &
                          dtbc, fcx, gcx,             &
                          ijds, ijde,                 & ! min/max(id,jd)
                          ids,ide, jds,jde, kds,kde,  & ! domain dims
                          ims,ime, jms,jme, kms,kme,  & ! memory dims
                          ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                               )
     ENDIF

     CALL rk_addtend_dry(ru_tend, rv_tend, rw_tend, rt_tend, rr_tend, &
                          ru_old, rv_old, rom_old, rtp_old, rrp_old,   &
                          ids,ide, jds,jde, kds,kde,  & ! domain dims
                          ims,ime, jms,jme, kms,kme,  & ! memory dims
                          ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                               )

     IF( config_flags%specified ) THEN 
       CALL spec_bdy_dry  (ru_tend, rv_tend, rt_tend, rr_tend,         &
                          ru_b, rv_b, rtp_b, rrp_b,              &
                          ru_bt, rv_bt, rtp_bt, rrp_bt, &
                          spec_bdy_width, spec_zone,                   &
                          ijds, ijde,                 & ! min/max(id,jd)
                          ids,ide, jds,jde, kds,kde,  & ! domain dims
                          ims,ime, jms,jme, kms,kme,  & ! memory dims
                          ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                               )
     ENDIF

   END DO

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

    ! Calculate coefficients for the vertically implicit acoustic/gravity wave
    ! integration.  We only need calculate these for the first pass through -
    ! the predictor step.  They are reused as is for the corrector step.
    ! For third-order RK, we need to recompute these after the first 
    ! prodictor because we may have changed the small timestep -> dts.

    IF( rk_step < rk_order )                                      &

        CALL wrf_debug ( 200 , ' call calc_coef_w' )
        CALL calc_coef_w ( alpha, gamma, a, cofwz, coftz, cofwt,   &
                           dtseps, dts_rk, zeta_z, rdzu, fzm, fzp, &
                           cofwr, cofrz, rdzw,                     &
                           pip, t_2, pib, rrb, rt_2, config_flags, &
                           spec_zone,                              &
                           ids, ide, jds, jde, kds, kde,           &
                           ims, ime, jms, jme, kms, kme,           &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

    END DO

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

      ! Decouple fields. 

      ! On the first pass (rk_step == 1), we decouple using time t 
      ! fields, and we'll drop the t-dt data
      ! that is presently in the *_1 arrays and replace it with the
      ! time level t data (in the *_2 arrays).  We should have used
      ! the t-dt data to perform any extrapolation we might need by
      ! this point in the algorithm.

      ! On the subsequent passes (rk_step == 2,3), we decouple using 
      ! latest fields (predicted from the previous pass)
      ! because these are the values we used in evaluating the RHS
      ! for the corrector step.  

      ! In the corrector steps (rk_step = 2, 3), we
      ! store the latest predictors 
      ! (ru_2, rv_2, rom_2, rrp_2, and rtp_2) 
      ! in the arrays u_2, v_2, w_2, rr_2 and tp_2

      CALL wrf_debug ( 200 , ' call rk_small_step_decouple' )
      CALL rk_small_step_decouple( rk_step,                        &
                                    ru_1, rv_1, rom_1, rrp_1, rtp_1, &
                                    ru_2, rv_2, rom_2, rrp_2, rtp_2, &
                                     u_2,  v_2,   w_2,  rr_2,  tp_2, &
                                    rw_tend, rt_tend, rtold,         &
                                    zeta_z, smdiv, dts_rk,           &
                                    ids, ide, jds, jde, kds, kde,    &
                                    ims, ime, jms, jme, kms, kme,    &
                                    grid%i_start(ij), grid%i_end(ij),          &
                                    grid%j_start(ij), grid%j_end(ij),          &
                                    k_start    , k_end              )

   END DO

   small_steps : DO iteration = 1 , number_of_small_timesteps
!   small_steps : DO iteration = 1 , 1

   ! Boundary condition time (or communication time).  

#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
!         *        * * *
!       * + *      * + *
!         *        * * *
! rtp_2   x
!--------------------------------------------------------------
   CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_B )
#endif

#ifdef DM_PARALLEL
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_B , &
                         config_flags%periodic_x , config_flags%periodic_y )
#endif

      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

         CALL wrf_debug ( 200 , ' call set_physical_bc3d' )
         CALL set_physical_bc3d( rtp_2, 'p', config_flags,         &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                                 grid%i_start(ij), grid%i_end(ij),       &
                                 grid%j_start(ij), grid%j_end(ij),       &
                                 k_start    , k_end           )

   ! small (acoustic) step for the horizontal momentum

         CALL advance_uv ( ru_2, rv_2, config_flags,     &
                           ru_tend, rv_tend,               &
                           du, dv,                         &
                           zx, zy, pip, pib, zeta_z, msft, &        
                           fzm, fzp, rdzw, rtp_2,          &
                           rdx, rdy, dts_rk,               &
                           cf1, cf2, cf3,                  &
                           spec_zone,                      &
                           ids, ide, jds, jde, kds, kde,   &
                           ims, ime, jms, jme, kms, kme,   &
                           grid%i_start(ij), grid%i_end(ij),         &
                           grid%j_start(ij), grid%j_end(ij),         &
                           k_start    , k_end             )

         IF( config_flags%specified ) THEN
           CALL spec_bdyupdate(ru_2, ru_2, ru_tend, dts_rk,      &
                               'u'         , config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),         &
                               grid%j_start(ij), grid%j_end(ij),         &
                               k_start    , k_end             )

           CALL spec_bdyupdate(rv_2, rv_2, rv_tend, dts_rk,      &
                               'v'         , config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),         &
                               grid%j_start(ij), grid%j_end(ij),         &
                               k_start    , k_end             )

         ENDIF

      END DO

#ifdef DM_PARALLEL
!
!         *                     *
!       * + *      * + *        +
!         *                     *
!
! ru_2               x
!   du               x
! rv_2                          x
!   dv                          x
   CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_C )
#endif

      !$OMP PARALLEL DO   &
      !$OMP PRIVATE ( ij )

      DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call sumflux' )
         ! sumflux accumulates the time-averged mass flux
         ! (time averaged over the acoustic steps) for use
         ! in the scalar advection (flux divergence).  Using
         ! time averaged values gives us exact scalar conservation.

         CALL sumflux ( 1,                              &
                        ru_2, rv_2, rom_2,                    & 
                        ru_m, rv_m, rom_m, epssm,             &
                        iteration, number_of_small_timesteps, &
                        ids, ide, jds, jde, kds, kde,         &
                        ims, ime, jms, jme, kms, kme,         &
                        grid%i_start(ij), grid%i_end(ij),               &
                        grid%j_start(ij), grid%j_end(ij),               &
                        k_start    , k_end                   )

         ! small (acoustic) step for the vertical momentum,
         ! density and coupled potential temperature.

         CALL advance_w( ru_2, du, rv_2, dv,                  &
                         rom_2, rw_tend,                      &
                         rrp_2, rr_tend, rtp_2,               &
                         rt_tend, rtold, msft,                &
                         t_2, a, alpha, gamma,                &
                         cofwz, coftz, cofwt, rdzw, fzm, fzp, &
                         cofwr, cofrz,                        &
                         zx, zy, zeta_z, rdx, rdy,            &
                         dts_rk, smdiv, resm,                 &
                         iteration, time_step_sound,          &
                         config_flags,                        &
                         spec_zone,                           &
                         ids, ide, jds, jde, kds, kde,        &
                         ims, ime, jms, jme, kms, kme,        &
                         grid%i_start(ij), grid%i_end(ij),              &
                         grid%j_start(ij), grid%j_end(ij),              &
                         k_start    , k_end                  )

         IF( config_flags%specified ) THEN
           CALL spec_bdyupdate(rtp_2, rtp_2, rt_tend, dts_rk,     &
                               't'         , config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),         &
                               grid%j_start(ij), grid%j_end(ij),         &
                               k_start    , k_end             )

           CALL spec_bdyupdate(rrp_2, rrp_2, rr_tend, dts_rk,      &
                               'r'         , config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),         &
                               grid%j_start(ij), grid%j_end(ij),         &
                               k_start    , k_end             )

           CALL zero_grad_bdy (rom_2,                      &
                               'w'         , config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),         &
                               grid%j_start(ij), grid%j_end(ij),         &
                               k_start    , k_end             )

         ENDIF

         CALL sumflux (  2,                              &
                         ru_2, rv_2, rom_2,                    &
                         ru_m, rv_m, rom_m, epssm,             &
                         iteration, number_of_small_timesteps, &
                         ids, ide, jds, jde, kds, kde,         &
                         ims, ime, jms, jme, kms, kme,         &
                         grid%i_start(ij), grid%i_end(ij),               &
                         grid%j_start(ij), grid%j_end(ij),               &
                         k_start    , k_end                   )
      END DO

   END DO small_steps

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

      CALL wrf_debug ( 200 , ' call rk_small_step_recouple' )

      ! change time-perturbation variables back to 
      ! full perturbation variables.


      CALL rk_small_step_recouple( dt_rk, rk_step,           &
                                    rk_order,                        &
                                    ru_1, rv_1, rom_1, rrp_1, rtp_1, &
                                    ru_2, rv_2, rom_2, rrp_2, rtp_2, &
                                     u_2,  v_2,   w_2,  rr_2,  tp_2, &
                                    ru_m, rv_m, rom_m, h_diabatic,   &
                                    ids, ide, jds, jde, kds, kde,    &
                                    ims, ime, jms, jme, kms, kme,    &
                                    grid%i_start(ij), grid%i_end(ij),          & 
                                    grid%j_start(ij), grid%j_end(ij),          &
                                    k_start    , k_end              )

      CALL calculate_full ( rr_2, rrb, rrp_2,           &
                            ids, ide, jds, jde, kds, kde, &
                            ims, ime, jms, jme, kms, kme, &
                            grid%i_start(ij), grid%i_end(ij),       &
                            grid%j_start(ij), grid%j_end(ij),       &
                            k_start    , k_end-1         )

      IF (rk_step == 1)                                  &
      CALL calculate_full ( rr_1, rrb, rrp_1,             &
                            ids, ide, jds, jde, kds, kde, &
                            ims, ime, jms, jme, kms, kme, &
                            grid%i_start(ij), grid%i_end(ij),       &
                            grid%j_start(ij), grid%j_end(ij),       &
                            k_start    , k_end-1         )

   END DO

#ifdef DM_PARALLEL
!
!         *                     *
!       * + *      * + *        +
!         *                     *
!
! rrp_2   x
! rr_2    x
! ru_m               x
! ru_2               x
! rv_m                          x
! rv_2                          x
!  need these to 1) fill out advecting velocity, to 2) decouple ru, rv
!  and 3) need ru_m and rv_m for scalar advection
!--------------------------------------------------------------
   IF      ( h_mom_adv_order == 3 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_D_3 )
   ELSE IF ( h_mom_adv_order == 5 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_D_5 )
   ELSE
     WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#endif

  moist_scalar_advance: IF (num_3d_m >= PARAM_FIRST_SCALAR )  THEN

! updateing physics tendency

   moist_variable_loop: do im = PARAM_FIRST_SCALAR, num_3d_m

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   moist_tile_loop_1: DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call rk_scalar_tend' )
       CALL rk_scalar_tend ( 1, im, config_flags,        &
                              rk_step, dt_rk,              &
                              ru_m, rv_m, rom_m,            &
                              rr_1, rr_2,                   &
                              moist_1(ims,kms,jms,im),      &
                              moist_2(ims,kms,jms,im),      &
                              qv_mix, .true.,               &
                              fzm, fzp,                     &
                              moist_tend(ims,kms,jms,im),   &
                              advect_tend,                  &
                              msfu, msfv, msft,             &
                              rdx, rdy, rdzu, rdzw, khdif,  &
                              z, zeta_z, kvdif,             &
                              ids, ide, jds, jde, kds, kde, &
                              ims, ime, jms, jme, kms, kme, &
                              grid%i_start(ij), grid%i_end(ij),       &
                              grid%j_start(ij), grid%j_end(ij),       &
                              k_start    , k_end           )


     IF( config_flags%specified .and. rk_step == 1 ) THEN 
       IF(im .eq. P_QV)THEN
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),          & 
                               moist_2(ims,kms,jms,im),  rr_2,      &
                               rqv_b, rqv_bt,                           &
                               spec_bdy_width, spec_zone, relax_zone, &
                               dtbc, fcx, gcx,             &
                               ijds, ijde,                 & ! min/max(id,jd)
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),                      &
                               grid%j_start(ij), grid%j_end(ij),                      &
                               k_start, k_end                               )
         CALL spec_bdy_scalar  (moist_tend(ims,kms,jms,im),        &
                              rqv_b, rqv_bt,             &
                              spec_bdy_width, spec_zone,                   &
                              ijds, ijde,                 & ! min/max(id,jd)
                              ids,ide, jds,jde, kds,kde,  & ! domain dims
                              ims,ime, jms,jme, kms,kme,  & ! memory dims
                              ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                              grid%i_start(ij), grid%i_end(ij),                      &
                              grid%j_start(ij), grid%j_end(ij),                      &
                              k_start, k_end                               )
       ENDIF
     ENDIF
   ENDDO moist_tile_loop_1

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   moist_tile_loop_2: DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call rk_update_scalar' )
       CALL rk_update_scalar( moist_1(ims,kms,jms,im),      & 
                               moist_2(ims,kms,jms,im),      & 
                               moist_tend(ims,kms,jms,im),   &
                               advect_tend, config_flags,    &
                               rr_1, rr_2, dt_rk,            &
                               rk_step, 1, spec_zone,       &
                               ids, ide, jds, jde, kds, kde, &
                               ims, ime, jms, jme, kms, kme, &
                               grid%i_start(ij), grid%i_end(ij),       &
                               grid%j_start(ij), grid%j_end(ij),       &
                               k_start    , k_end           )
       IF( config_flags%specified ) THEN
         IF(im .eq. P_QV)THEN
!          CALL spec_bdyupdate(moist_1(ims,kms,jms,im),    &
!                              moist_2(ims,kms,jms,im),    &
!                              moist_tend(ims,kms,jms,im), dt_rk,     &
!                              'q'         , config_flags, &
!                              spec_zone,                  &
!                              ids,ide, jds,jde, kds,kde,  & ! domain dims
!                              ims,ime, jms,jme, kms,kme,  & ! memory dims
!                              ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
!                              grid%i_start(ij), grid%i_end(ij),         &
!                              grid%j_start(ij), grid%j_end(ij),         &
!                              k_start    , k_end             )
         ELSE
           CALL flow_dep_bdy  (  moist_2(ims,kms,jms,im),                     &
                               ru_m, rv_m, config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),                      &
                               grid%j_start(ij), grid%j_end(ij),                      &
                               k_start, k_end                               )
         ENDIF
       ENDIF

   ENDDO moist_tile_loop_2

   ENDDO moist_variable_loop

 ENDIF moist_scalar_advance

! handle tke

   IF (km_opt .eq. 2) then

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   tke_tile_loop_1: DO ij = 1 , grid%num_tiles

     CALL wrf_debug ( 200 , ' call rk_scalar_tend for tke' )
     CALL rk_scalar_tend ( 1, ic, config_flags,          &
                           rk_step, dt_rk,               &
                           ru_m, rv_m, rom_m,            &
                           rr_1, rr_2,                   &
                           tke_1(ims,kms,jms),           &
                           tke_2(ims,kms,jms),           &
                           qv_mix, .false.,              &
                           fzm, fzp,                     &
                           tke_tend(ims,kms,jms),        &
                           advect_tend,                  &
                           msfu, msfv, msft,             &
                           rdx, rdy, rdzu, rdzw, khdif,  &
                           z, zeta_z, kvdif,             &
                           ids, ide, jds, jde, kds, kde, &
                           ims, ime, jms, jme, kms, kme, &
                           grid%i_start(ij), grid%i_end(ij),       &
                           grid%j_start(ij), grid%j_end(ij),       &
                           k_start    , k_end           )

     CALL wrf_debug ( 200 , ' call rk_update_scalar' )
     CALL rk_update_scalar( tke_1(ims,kms,jms),           &
                            tke_2(ims,kms,jms),           &
                            tke_tend(ims,kms,jms),        &
                            advect_tend, config_flags,    &
                            rr_1, rr_2, dt_rk,            &
                            rk_step, 1, spec_zone,        &
                            ids, ide, jds, jde, kds, kde, &
                            ims, ime, jms, jme, kms, kme, &
                            grid%i_start(ij), grid%i_end(ij),       &
                            grid%j_start(ij), grid%j_end(ij),       &
                            k_start    , k_end           )
     IF( config_flags%specified ) THEN
         CALL flow_dep_bdy (  tke_2(ims,kms,jms),                     &
                              ru_m, rv_m, config_flags,               &
                              spec_zone,                              &
                              ids,ide, jds,jde, kds,kde,  & ! domain dims
                              ims,ime, jms,jme, kms,kme,  & ! memory dims
                              ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                              grid%i_start(ij), grid%i_end(ij),       &
                              grid%j_start(ij), grid%j_end(ij),       &
                              k_start, k_end                               )
     ENDIF
   ENDDO tke_tile_loop_1

   endif

!  next the chemical species

  chem_scalar_advance: IF (num_3d_c >= PARAM_FIRST_SCALAR)  THEN

   chem_variable_loop: do ic = PARAM_FIRST_SCALAR, num_3d_c

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   chem_tile_loop_1: DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call rk_scalar_tend' )
       CALL rk_scalar_tend ( 1, ic, config_flags,        &
                              rk_step, dt_rk,              &
                              ru_m, rv_m, rom_m,            &
                              rr_1, rr_2,                   &
                              chem_1(ims,kms,jms,ic),       &
                              chem_2(ims,kms,jms,ic),       &
                              qv_mix, .false.,              &
                              fzm, fzp,                     &
                              chem_tend(ims,kms,jms,ic),    &
                              advect_tend,                  &
                              msfu, msfv, msft,             &
                              rdx, rdy, rdzu, rdzw, khdif,  &
                              z, zeta_z, kvdif,             &
                              ids, ide, jds, jde, kds, kde, &
                              ims, ime, jms, jme, kms, kme, &
                              grid%i_start(ij), grid%i_end(ij),       &
                              grid%j_start(ij), grid%j_end(ij),       &
                              k_start    , k_end           )

   ENDDO chem_tile_loop_1


   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   chem_tile_loop_2: DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call rk_update_scalar' )
       CALL rk_update_scalar( chem_1(ims,kms,jms,ic),       & 
                               chem_2(ims,kms,jms,ic),       & 
                               chem_tend(ims,kms,jms,ic),    &
                               advect_tend, config_flags,    &
                               rr_1, rr_2, dt_rk,            &
                               rk_step, 1, spec_zone,       &
                               ids, ide, jds, jde, kds, kde, &
                               ims, ime, jms, jme, kms, kme, &
                               grid%i_start(ij), grid%i_end(ij),       &
                               grid%j_start(ij), grid%j_end(ij),       &
                               k_start    , k_end           )
       IF( config_flags%specified ) THEN
           CALL flow_dep_bdy  (  chem_2(ims,kms,jms,ic),                     &
                               ru_m, rv_m, config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),                      &
                               grid%j_start(ij), grid%j_end(ij),                      &
                               k_start, k_end                               )
       ENDIF

   ENDDO chem_tile_loop_2

   ENDDO chem_variable_loop

 ENDIF chem_scalar_advance


!  Reset the boundary conditions if there is another corrector step.
!  (rk_step < rk_order), else we'll handle it at the end of everything
!  (after the split physics, before exiting the timestep).

   rk_step_1_check: IF ( rk_step < rk_order ) THEN

#ifdef DM_PARALLEL
   CALL wrf_debug ( 200 , 'CALL wrf_dm_boundary PERIOD_BDY_RK_D' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_D , &
                         config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_debug ( 200 , 'CALL wrf_dm_boundary PERIOD_BDY_RK_MOIST' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_MOIST , &
                         config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_debug ( 200 , 'CALL wrf_dm_boundary PERIOD_BDY_RK_CHEM' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_CHEM , &
                         config_flags%periodic_x , config_flags%periodic_y )
#endif

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

    tile_bc_loop_1: DO ij = 1 , grid%num_tiles

      CALL wrf_debug ( 200 , ' call rk_phys_bc_dry_2' )

      CALL rk_phys_bc_dry_2( config_flags,                  &
                             ru_2, rv_2, rom_2,             &
                             rrp_2, rr_2, rtp_2,            &
                             ids, ide, jds, jde, kds, kde,  &
                             ims, ime, jms, jme, kms, kme,  &
                             ips, ipe, jps, jpe, kps, kpe,  &
                             grid%i_start(ij), grid%i_end(ij),        &
                             grid%j_start(ij), grid%j_end(ij),        &
                             k_start    , k_end            )

      CALL set_physical_bc3d( tke_2(ims,kms,jms), 'p', config_flags,   &
                              ids, ide, jds, jde, kds, kde,            &
                              ims, ime, jms, jme, kms, kme,            &
                              ips, ipe, jps, jpe, kps, kpe,            &
                              grid%i_start(ij), grid%i_end(ij),                  &
                              grid%j_start(ij), grid%j_end(ij),                  &
                              k_start    , k_end-1                    )

      IF (num_3d_m >= PARAM_FIRST_SCALAR) THEN

        moisture_loop_bdy_1 : DO im = PARAM_FIRST_SCALAR , num_3d_m
  
          CALL set_physical_bc3d( moist_2(ims,kms,jms,im), 'p', config_flags,   &
                                   ids, ide, jds, jde, kds, kde,             &
                                   ims, ime, jms, jme, kms, kme,             &
                                   ips, ipe, jps, jpe, kps, kpe,             &
                                   grid%i_start(ij), grid%i_end(ij),                   &
                                   grid%j_start(ij), grid%j_end(ij),                   &
                                   k_start    , k_end                       )
         END DO moisture_loop_bdy_1

      ENDIF

      IF (num_3d_c >= PARAM_FIRST_SCALAR) THEN

        chem_species_bdy_loop_1 : DO ic = PARAM_FIRST_SCALAR , num_3d_c

          CALL set_physical_bc3d( chem_2(ims,kms,jms,ic), 'p', config_flags,   &
                                  ids, ide, jds, jde, kds, kde,            &
                                  ims, ime, jms, jme, kms, kme,            &
                                  ips, ipe, jps, jpe, kps, kpe,            &
                                  grid%i_start(ij), grid%i_end(ij),                  &
                                  grid%j_start(ij), grid%j_end(ij),                  &
                                  k_start    , k_end-1                    )

        END DO chem_species_bdy_loop_1

      END IF

    END DO tile_bc_loop_1

#ifdef DM_PARALLEL
!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * *
!         *        * * *    * * * * *
!                           * * * * *
! ru_1                          x
! ru_2                          x
! rv_1                          x
! rv_2                          x
! rom_1                         x
! rom_2                         x
! rrp_1                         x
! rrp_2                         x
! rr_1                          x
! rr_2                          x
! rtp_1                         x
! rtp_2                         x
! tke_1                         x
! tke_2                         x
   IF      ( h_mom_adv_order == 3 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_A_3 )
   ELSE IF ( h_mom_adv_order == 5 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_A_5 )
   ELSE
     WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#endif

#ifdef DM_PARALLEL
   if ( num_moist .gt. 0 ) then

!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * *
!         *        * * *    * * * * *
!                           * * * * *

! moist_2                       x

     IF      ( h_mom_adv_order == 3 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_MOIST_3 )
     ELSE IF ( h_mom_adv_order == 5 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_MOIST_5 )
     ELSE
       WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
   if ( num_chem >= PARAM_FIRST_SCALAR ) then

!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * *
!         *        * * *    * * * * *
!                           * * * * *

! chem_2                        x

     IF      ( h_mom_adv_order == 3 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_CHEM_3 )
     ELSE IF ( h_mom_adv_order == 5 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_CHEM_5 )
     ELSE
       WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
#endif

   ENDIF rk_step_1_check

!**********************************************************
!
!  end of RK predictor-corrector loop
!
!**********************************************************

 END DO Runge_Kutta_loop


   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   DO ij = 1 , grid%num_tiles

      CALL wrf_debug ( 200 , ' call advance_ppt' )
      CALL advance_ppt(RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN, &
                     RQICUTEN,RQSCUTEN,RAINC,RAINCV,NCA,    &
                     config_flags,                          &
                     ids,ide, jds,jde, kds,kde,             &
                     ims,ime, jms,jme, kms,kme,             &
                     grid%i_start(ij), grid%i_end(ij),                &
                     grid%j_start(ij), grid%j_end(ij),                &
                     k_start    , k_end                     )

   ENDDO
!
!  Here is the place to add physics that are time split
!  (that DO use the provisional values of s*(t+dt))
! 
   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   scalar_tile_loop_1: DO ij = 1 , grid%num_tiles

       CALL wrf_debug ( 200 , ' call moist_physics_prep' )
       CALL moist_physics_prep( rt_2, rt_1, rtp_2, rtp_1,      &
                                t_2, t_1, rr_2, rr_1,          &
                                moist_2, moist_1, moist_tend,  &
                                rtb,                           &
                                rtp_old, pi, p, msft, zeta_z,  &
                                fzm, fzp, config_flags, num_3d_m,  &
                                ids, ide, jds, jde, kds, kde,  &
                                ims, ime, jms, jme, kms, kme,  &
                                grid%i_start(ij), grid%i_end(ij),        &
                                grid%j_start(ij), grid%j_end(ij),        &
                                k_start    , k_end            )

       CALL wrf_debug ( 200 , ' call microphysics_driver' )
       CALL microphysics_driver(t_2,moist_2, moist_1, w_2,        &
                               rr_2, pi, p, RAINNC,              &
                               z, ht, dz8w, dt, config_flags,    &
                               num_3d_m, z_zeta, dzetaw,         &
                               ids, ide, jds, jde, kds, kde,     &
                               ims, ime, jms, jme, kms, kme,     &
                               grid%i_start(ij), min(grid%i_end(ij),ide-1),&
                               grid%j_start(ij), min(grid%j_end(ij),jde-1),&
                               k_start    , min(k_end,kde-1)     )

       CALL wrf_debug ( 200 , ' call moist_physics_finish' )
       CALL moist_physics_finish( rt_2, rt_1, rtp_2, rtp_1,    &
                                  t_2, rr_2, rr_1,             &
                                  moist_2, rtb,                &
                                  msft, zeta_z,                &
                                  config_flags, num_3d_m,      &
                                  ids, ide, jds, jde, kds, kde,&
                                  ims, ime, jms, jme, kms, kme,&
                                  grid%i_start(ij), grid%i_end(ij),      &
                                  grid%j_start(ij), grid%j_end(ij),      &
                                  k_start    , k_end           )

       !  compute and store off the diabatic heating term for
       !  the next timestep

       CALL wrf_debug ( 200 , ' call diabatic_heating' )
       CALL diabatic_heating( h_diabatic, rtp_2, dt,        &
                              ids, ide, jds, jde, kds, kde, &
                              ims, ime, jms, jme, kms, kme, &
                              grid%i_start(ij), grid%i_end(ij),       &
                              grid%j_start(ij), grid%j_end(ij),       &
                              k_start    , k_end-1          )

   END DO scalar_tile_loop_1

   scalar_tile_loop_2: DO ij = 1 , grid%num_tiles

          CALL wrf_debug ( 200 , ' call scalar_tile_loop_2' )

     IF ( num_3d_c >= PARAM_FIRST_SCALAR ) then

!  tiled chemistry here

     END IF

   END DO scalar_tile_loop_2


   !  We're finished except for boundary condition (and patch) update

   ! Boundary condition time (or communication time).  At this time, we have
   ! implemented periodic and symmetric physical boundary conditions.

   ! b.c. routine for data within patch.

   ! we need to do both time levels of 
   ! data because the time filter only works in the physical solution space.

   ! First, do patch communications for boundary conditions (periodicity)

#ifdef DM_PARALLEL
   CALL wrf_debug ( 200 , ' solve_rk: calling wrf_dm_boundary PERIOD_BDY_RK_D' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_D , &
                         config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_debug ( 200 , ' solve_rk: calling wrf_dm_boundary PERIOD_BDY_RK_MOIST' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_MOIST , &
                         config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_debug ( 200 , ' solve_rk: calling wrf_dm_boundary PERIOD_BDY_RK_CHEM' )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_CHEM , &
                         config_flags%periodic_x , config_flags%periodic_y )
#endif

!  now set physical b.c on a patch

   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

   tile_bc_loop_2: DO ij = 1 , grid%num_tiles

     CALL wrf_debug ( 200 , ' call set_phys_bc_dry_2' )

     CALL set_phys_bc_dry_2( config_flags,                               &
                             ru_1, ru_2, rv_1, rv_2, rom_1, rom_2,   &
                             rrp_1, rrp_2, rr_1, rr_2, rtp_1, rtp_2, &
                             ids, ide, jds, jde, kds, kde,           &
                             ims, ime, jms, jme, kms, kme,           &
                             ips, ipe, jps, jpe, kps, kpe,           &
                             grid%i_start(ij), grid%i_end(ij),                 &
                             grid%j_start(ij), grid%j_end(ij),                 &
                             k_start    , k_end                     )

     CALL set_physical_bc3d( tke_1(ims,kms,jms), 'p', config_flags,   &
                             ids, ide, jds, jde, kds, kde,            &
                             ims, ime, jms, jme, kms, kme,            &
                             ips, ipe, jps, jpe, kps, kpe,            &
                             grid%i_start(ij), grid%i_end(ij),                  &
                             grid%j_start(ij), grid%j_end(ij),                  &
                             k_start    , k_end-1                    )
     CALL set_physical_bc3d( tke_2(ims,kms,jms) , 'p', config_flags,  &
                             ids, ide, jds, jde, kds, kde,            &
                             ims, ime, jms, jme, kms, kme,            &
                             ips, ipe, jps, jpe, kps, kpe,            &
                             grid%i_start(ij), grid%i_end(ij),                  &
                             grid%j_start(ij), grid%j_end(ij),                  &
                             k_start    , k_end                      )

     moisture_loop_bdy_2 : DO im = PARAM_FIRST_SCALAR , num_3d_m

       CALL set_physical_bc3d( moist_1(ims,kms,jms,im), 'p', config_flags,   &
                               ids, ide, jds, jde, kds, kde,             &
                               ims, ime, jms, jme, kms, kme,             &
                               ips, ipe, jps, jpe, kps, kpe,             &
                               grid%i_start(ij), grid%i_end(ij),                   &
                               grid%j_start(ij), grid%j_end(ij),                   &
                               k_start    , k_end                       )
       CALL set_physical_bc3d( moist_2(ims,kms,jms,im), 'p', config_flags,   &
                               ids, ide, jds, jde, kds, kde,             &
                               ims, ime, jms, jme, kms, kme,             &
                               ips, ipe, jps, jpe, kps, kpe,             &
                               grid%i_start(ij), grid%i_end(ij),                   &
                               grid%j_start(ij), grid%j_end(ij),                   &
                               k_start    , k_end                       )

     END DO moisture_loop_bdy_2

     chem_species_bdy_loop_2 : DO ic = PARAM_FIRST_SCALAR , num_3d_c

       CALL set_physical_bc3d( chem_1(ims,kms,jms,ic), 'p', config_flags,   &
                               ids, ide, jds, jde, kds, kde,            &
                               ims, ime, jms, jme, kms, kme,            &
                               ips, ipe, jps, jpe, kps, kpe,            &
                               grid%i_start(ij), grid%i_end(ij),                  &
                               grid%j_start(ij), grid%j_end(ij),                  &
                               k_start    , k_end-1                    )
       CALL set_physical_bc3d( chem_2(ims,kms,jms,ic) , 'p', config_flags,  &
                               ids, ide, jds, jde, kds, kde,            &
                               ims, ime, jms, jme, kms, kme,            &
                               ips, ipe, jps, jpe, kps, kpe,            &
                               grid%i_start(ij), grid%i_end(ij),                  &
                               grid%j_start(ij), grid%j_end(ij),                  &
                               k_start    , k_end                      )

     END DO chem_species_bdy_loop_2

   END DO tile_bc_loop_2

   IF( config_flags%specified ) THEN 
     dtbc = dtbc + dt
   ENDIF

#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
   CALL wrf_debug ( 200 , ' call HALO_RK_E' )
   IF      ( h_mom_adv_order == 3 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_E_3 )
   ELSE IF ( h_mom_adv_order == 5 ) THEN
     CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_E_5 )
   ELSE
     WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#endif

#ifdef DM_PARALLEL
   if ( num_moist .gt. 0 ) then
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
     CALL wrf_debug ( 200 , ' call HALO_RK_MOIST' )
     IF      ( h_mom_adv_order == 3 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_MOIST_3 )
     ELSE IF ( h_mom_adv_order == 5 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_MOIST_5 )
     ELSE
       WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
   if ( num_chem >= PARAM_FIRST_SCALAR ) then
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
     CALL wrf_debug ( 200 , ' call HALO_RK_CHEM' )
     IF      ( h_mom_adv_order == 3 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_CHEM_3 )
     ELSE IF ( h_mom_adv_order == 5 ) THEN
       CALL wrf_dm_halo( grid%domdesc , grid%comms , HALO_RK_CHEM_5 )
     ELSE
       WRITE(wrf_err_message,*)'solve_rk: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
#endif

   CALL wrf_debug ( 200 , ' call end of solve_rk' )

   RETURN

END SUBROUTINE solve_rk

