sub write_args_and_i1 {
#############################################################################
#############################################################################
#
# 2.  Files that define and specify the actual and dummy arguments
#     for the interface between the solve subroutine, which takes all
#     state data explicitly through its argument list, and the driver
#     layer, which carries all this data around as a single structure.
#
#     solve_actual_args.inc
#     solve_dummy_arg_defines.inc
#     solve_dummy_args.inc
#


#############################################################################
#
# Generate files: solve_actual_args.inc, solve_dummy_args.inc
#
#   The generation of the actual arguments (solve_actual_args.inc) is modified
#   slightly by the setting of the sw_deref_kludge flag (-DDEREF_KLUDGE).
#   This causes the actual array arguments to be generated with explicit starting
#   indices, avoiding a copy on some compilers as the compiler converts
#   from assumed shape outside the routine to explicit shape within.
#
#   For other information, see comments generated in files themselves.
#

foreach $dyntag ( sort ( keys ( %dynsolver_tags ) ) )
{

$arglens = 0 ;
$darglens = 0 ;

open ALLOCSFILE, ">$wrf_root/inc/${dyntag}_allocs.inc" or 
  die "Cannot open $wrf_root/inc/${dyntag}_allocs.inc for writing" ;
print ALLOCSFILE "!\n" ;
print ALLOCSFILE "! WARNING This file is generated automatically by use_registry\n" ;
print ALLOCSFILE "! using the data base in the file named Registry.\n" ;
print ALLOCSFILE "! Do not edit.  Your changes to this file will be lost.\n" ;
print ALLOCSFILE "!\n" ;
#write_fld_decls( ALLOCSFILE, "state", $dyntag, 1, 0, 0, 1, 1, 0 ) ;
write_fld_decls( ALLOCSFILE, "state", $dyntag, 1, 0, 0, 0, 1, 0 ) ;
close ALLOCSFILE ;

open SOLVEACTUALS, ">$wrf_root/inc/${dyntag}_actual_args.inc" or 
  die "Cannot open $wrf_root/inc/${dyntag}_actual_args.inc for writing" ;

print SOLVEACTUALS "!\n" ;
print SOLVEACTUALS "! WARNING This file is generated automatically by use_registry\n" ;
print SOLVEACTUALS "! using the data base in the file named Registry.\n" ;
print SOLVEACTUALS "! Do not edit.  Your changes to this file will be lost.\n" ;
print SOLVEACTUALS "!\n" ;
print SOLVEACTUALS "! This file contains a list of the actual arguments for\n" ;
print SOLVEACTUALS "! calling solve or any routine (there are others) that take\n" ;
print SOLVEACTUALS "! all of the state data through thier argument list.  A call\n" ;
print SOLVEACTUALS "! should look like this:\n" ;
print SOLVEACTUALS "!\n" ;
print SOLVEACTUALS "!    CALL solve  ( grid ,                          &\n" ;
print SOLVEACTUALS "! !\n" ;
print SOLVEACTUALS "! #include \"solve_actual_args.inc\"\n" ;
print SOLVEACTUALS "! !\n" ;
print SOLVEACTUALS "!                )\n" ;
print SOLVEACTUALS "!\n" ;
print SOLVEACTUALS "! Please note that the comment lines around the include are necessary.\n" ;
print SOLVEACTUALS "!\n" ;

open SOLVEDUMMIES, ">$wrf_root/inc/${dyntag}_dummy_args.inc" or 
  die "Cannot open $wrf_root/inc/${dyntag}_dummy_args.inc for writing" ;

print SOLVEDUMMIES "!\n" ;
print SOLVEDUMMIES "! WARNING This file is generated automatically by use_registry\n" ;
print SOLVEDUMMIES "! using the data base in the file named Registry.\n" ;
print SOLVEDUMMIES "! Do not edit.  Your changes to this file will be lost.\n" ;
print SOLVEDUMMIES "!\n" ;
print SOLVEDUMMIES "! This file contains a list of the dummy arguments for\n" ;
print SOLVEDUMMIES "! solve or any routine (there are others) that take\n" ;
print SOLVEDUMMIES "! all of the state data through thier argument list.  A\n" ;
print SOLVEDUMMIES "! subroutine definition should look like this:\n" ;
print SOLVEDUMMIES "!\n" ;
print SOLVEDUMMIES "! SUBROUTINE solve ( grid ,                      &\n" ;
print SOLVEDUMMIES "! !\n" ;
print SOLVEDUMMIES "! #include \"solve_dummy_args.inc\"\n" ;
print SOLVEDUMMIES "! !\n" ;
print SOLVEDUMMIES "!                  )\n" ;
print SOLVEDUMMIES "!\n" ;
print SOLVEDUMMIES "! Please note that the comment lines around the include are necessary.\n" ;
print SOLVEDUMMIES "! These arguments are defined by including solve_dummy_arg_defines.inc\n" ;
print SOLVEDUMMIES "! in the declaration section of the subroutine.\n" ;
print SOLVEDUMMIES "!\n" ;
print SOLVEDUMMIES "! Contains dummy arguments to solve.\n" ;
print SOLVEDUMMIES "!\n" ;

if ( $sw_deref_kludge == 1 )
  { $dexes4 = "(sm31,sm32,sm33,1)" ;
    $dexes3m = "(sm32,sm33,1)"         if ( $index_order_3d eq "kij" ) ;
    $dexes3m = "(sm31,sm33,1)"         if ( $index_order_3d eq "ikj" ) ;
    $dexes3m = "(sm31,sm32,1)"         if ( $index_order_3d eq "ijk" ) ;
    $dexes3 = "(sm31,sm32,sm33)" ;
  }
#  { $dexes4 = "(grid%sm31,grid%sm32,grid%sm33,1)" ;
#    $dexes3m = "(grid%sm32,grid%sm33,1)"         if ( $index_order_3d eq "kij" ) ;
#    $dexes3m = "(grid%sm31,grid%sm33,1)"         if ( $index_order_3d eq "ikj" ) ;
#    $dexes3m = "(grid%sm31,grid%sm32,1)"         if ( $index_order_3d eq "ijk" ) ;
#    $dexes3 = "(grid%sm31,grid%sm32,grid%sm33)" ;
#  }
else
  { $dexes4 = "" ;
    $dexes3m = "" ;
    $dexes3 = "" ; }

$icount = 0 ;
foreach $key ( sort keys %multfieldarrays )
{
  $icount++ ;
  $num_time = $multfield_ntl{$key} ;
  $xdims = $multfieldarrays{$key} ;
  $xdims =~ s/[tf]//g ;
  $ldims = length($xdims) ;    ## number of dimensions from dimstring (remove t and f)
  if    ( $ldims == 2 )
  {
    $dexes_x = $dexes3m ;
  }
  elsif ( $ldims == 3 )
  {
    $dexes_x = $dexes4 ;
  }
  else
  {
    print "REGISTRY WARNING: CURRENT PERL SCRIPT ALLOWS ONLY 2-D OR 3-D FLDS IN MULTI-FIELD ARRAYS\n" ;
  }
  if ( $num_time == 1 )
  {
    print SOLVEACTUALS "grid%$key$dexes_x," ;
    print SOLVEDUMMIES "$key," ;
  }
  else
  {
    for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
    {
      print SOLVEACTUALS "grid%${key}_$i$dexes_x," ;
      print SOLVEDUMMIES "${key}_$i," ;
    }
  }
  if ( $icount % 4 == 0 )
  {
      print SOLVEACTUALS "&\n" ;
      print SOLVEDUMMIES "&\n" ;
  }
}
if ( $icount % 4 != 0 )
{
    print SOLVEACTUALS "&\n" ;
    print SOLVEDUMMIES "&\n" ;
}

$comma = "" ;
$dcomma = "" ;
foreach $_ ( @inline )                                         ## iterate through input lines
{                                                              ##
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] ne "state" ) { next ; }                      ## only state entries
  $num_time = $t[$ntl] ;                                       ## handle multiple time levels
  $s1 = uc $t[$sym] ;
  $p1 = uc $t[$part] ;
                                                               ## only generate args for this solver
  if ( substr($t[$use],0,4) eq "dyn-" && substr($t[$use],4) ne $dyntag) {next;}

  if ( $num_time eq "-" ) { $num_time = 1 }                    ## and generate tags (_1 or _2)
  for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
  {
    if    ( $num_time == 1 )
      { $tag = "" }
    else
      { $tag = "_".$i }

    if ( ! $multfieldarrays{$t[$use]} )
    {
      if ( $sw_deref_kludge == 0 )
      {
        $actual_str = "$comma grid % $t[$sym]$tag" ;
        $comma = "," ;
      }
      else
      {
        $xdims = $t[$dims] ;
        $xdims =~ s/[tf]//g ;
        $ldims = length($xdims) ;    ## number of dimensions from dimstring (remove t and f)
        $ldims = 0  if ( $t[$dims] eq "-" ) ;

        if    ( $xdims eq "kb" || $xdims eq "lb" || $xdims eq "1b" )   # 20000629
        {
          $actual_str = "$comma grid % $t[$sym]${tag}(1,1,1,1)" ; $comma = "," ;
        }
        elsif    ( $xdims eq "b" )   # 20000825
        {
          $actual_str = "$comma grid % $t[$sym]${tag}(1)" ; $comma = "," ;
        }
        elsif    ( $ldims == 3 )
        {
          if ( $xdims eq "ilj" )
          # kludge 20000628
          { 
            $actual_str = "$comma grid % $t[$sym]${tag}(sm31,1,sm33)" ; $comma = "," ; }
          else
          { 
            $actual_str = "$comma grid % $t[$sym]${tag}(sm31,sm32,sm33)" ; $comma = "," ;
          }
        }
        elsif ( $ldims == 2 )
        {
          if ( $index_order_3d eq "kij" )
          {
            $actual_str = "$comma grid % $t[$sym]${tag}(sm32,sm33)" ; $comma = "," ;
          }
          if ( $index_order_3d eq "ikj" )
          {
            $actual_str = "$comma grid % $t[$sym]${tag}(sm31,sm33)"  ; $comma = "," ;
          }
          if ( $index_order_3d eq "ijk" )
          {
            $actual_str = "$comma grid % $t[$sym]${tag}(sm31,sm32)" ; $comma = "," ;
          }
        }
        elsif ( $ldims == 1 )
        { 
          if ( $index_order_3d eq "kij" )
          {
            $actual_str = "$comma grid % $t[$sym]${tag}(sm31)" ; $comma = "," ;
          }
          if ( $index_order_3d eq "ikj" )
          {
            # kludge 20000628
            if ( $xdims eq "l" )
            {
              $actual_str = "$comma grid % $t[$sym]${tag}(1)" ; $comma = "," ;
            }
            else
            {
              $actual_str = "$comma grid % $t[$sym]${tag}(sm32)" ; $comma = "," ;
            }
          }
          if ( $index_order_3d eq "ijk" )
          {
            $actual_str = "$comma grid % $t[$sym]${tag}(sm33)" ; $comma = "," ;
          }
        }
        else
        {
            $actual_str = "$comma grid % $t[$sym]${tag}"  ; $comma = "," ;
        }
      }
      if ( $arglens + length( $actual_str ) >= 128 )
      {
        print SOLVEACTUALS " & \n" ; $arglens = 0 ;
      }
      print SOLVEACTUALS $actual_str ;
      $arglens += length( $actual_str ) ;
      
    }

    if ( ! $multfieldarrays{$t[$use]} )
    {
      $dummy_str = "$dcomma $t[$sym]${tag}" ; $dcomma = "," ;
      if ( $darglens + length( $dummy_str ) >= 128 )
      {
        print SOLVEDUMMIES " & \n" ; $darglens = 0 ;
      }
      print SOLVEDUMMIES $dummy_str ;
      $darglens += length( $dummy_str ) ;

    }

  }
}

if ( $arglens > 0 ) { printf SOLVEACTUALS " & \n" ; $argspace = 0 }
close SOLVEACTUALS ;
if ( $darglens > 0 ) { printf SOLVEDUMMIES " & \n" ; $dargspace = 0 }
close SOLVEDUMMIES ;


#############################################################################
#
# Generate file: solve_dummy_arg_defines.inc,
#
#   The generating of this file is a two step affair; first a temporary file
#   solve_dummy_arg_defines2.inc, is created and written to, then the final
#   version, solve_dummy_arg_defines.inc is written.  This is so that the
#   entries can be sorted, allowing the definitions of the integer variables
#   (including dummy arguments that are array dimensions) to appear first
#   in the declarations, before they are used to define anything.
#   
#   For other information, see comments generated in file itself.
#

open SOLVEDEFINES, ">$wrf_root/inc/${dyntag}_dummy_arg_defines.inc" or 
  die "Cannot open $wrf_root/inc/${dyntag}_dummy_arg_defines.inc for writing" ;
open SOLVEDEFINES2, ">$wrf_root/inc/${dyntag}_dummy_arg_defines2.inc" or 
  die "Cannot open $wrf_root/inc/${dyntag}_dummy_arg_defines2.inc for writing" ;

print SOLVEDEFINES "!\n" ;
print SOLVEDEFINES "! WARNING This file is generated automatically by use_registry\n" ;
print SOLVEDEFINES "! using the data base in the file named Registry.\n" ;
print SOLVEDEFINES "! Do not edit.  Your changes to this file will be lost.\n" ;
print SOLVEDEFINES "!\n" ;
print SOLVEDEFINES "! This file contains definitions of dummy arguments for routines such as\n" ;
print SOLVEDEFINES "! solve that take state data through the argument list.  This routine\n" ;
print SOLVEDEFINES "! should be included in the declaration section.   The dummy arguments\n" ;
print SOLVEDEFINES "! themselves are generated above to the separate include file,\n" ;
print SOLVEDEFINES "! solve_dummy_args.inc .\n" ;
print SOLVEDEFINES "!\n" ;
print SOLVEDEFINES "!\n" ;
print SOLVEDEFINES "! Contains definitions of dummy arguments in solve.\n" ;
print SOLVEDEFINES "!\n" ;

write_fld_decls( SOLVEDEFINES2, "state", $dyntag, 1, 1, 0, 0, 0, 0 ) ;

close SOLVEDEFINES ;                                           ## close and open for second pass
close SOLVEDEFINES2;
open SOLVEDEFINES,  ">>$wrf_root/inc/${dyntag}_dummy_arg_defines.inc" or die "Cannot append solve_dummy_arg_defines.inc" ;
open SOLVEDEFINES2, "<$wrf_root/inc/${dyntag}_dummy_arg_defines2.inc" or die "Cannot open solve_dummy_arg_defines2.inc" ;

$n = 0 ;
while (<SOLVEDEFINES2>)
{
  $t[$n++] = $_ ;
}
@t = sort @t ;
for ( $i = 0 ; $i < $n ; $i++ )
{
  print SOLVEDEFINES $t[$i] ;
}

close SOLVEDEFINES ;
close SOLVEDEFINES2;
unlink "$wrf_root/inc/${dyntag}_dummy_arg_defines2.inc" ;

#############################################################################
#############################################################################
#
# 3.  Files that define data that is (1) local to the top level solver
#     (I1 data) and (2) associated with State variables in the
#     domain structure.
#

#############################################################################
#
#

open I1, ">$wrf_root/inc/${dyntag}_i1.inc" or
  die "Cannot open $wrf_root/inc/${dyntag}_i1.inc for writing" ;

print I1 "!\n" ;
print I1 "! WARNING This file is generated automatically by use_registry\n" ;
print I1 "! using the data base in the file named Registry.\n" ;
print I1 "! Do not edit.  Your changes to this file will be lost.\n" ;
print I1 "!\n" ;
print I1 "! Contains I1 declarations\n" ;
print I1 "!\n" ;

write_fld_decls( I1, "i1", $dyntag, 0, 1, 0, 0, 0, 1 ) ;

close I1 ;

} ### end of foreach $dyntag ( sort ( keys ( %dynsolver_tags ) ) )

}
return 1 ;
