sub write_config_calls{

#############################################################################
#############################################################################
#
# 4.  Files that handle configuration of state via the namelist
#
#     config_namelist_01.inc
#     config_namelist_02.inc
#     config_namelist_03.inc
#     config_namelist_04.inc
#     state_namelist_statements.inc
#     state_namelist_defines.inc
#     state_namelist_assigns.inc
#     state_namelist_reads.inc
#
# 5.  A default (template) namelist file
# 
#     namelist.default
#
#  These sections deal with the namelist configuration mechanism in the
#  model.  They are less general than one would like, since they aribitrarily
#  prescribe that there are 4 records to a namelist, and that the first
#  record, namelist_01,  is for model-wide settings; all the others are
#  per-domain settings.  Thus, every item in namelist_01 is a scalar;
#  each item in the other namelist records is a vector with an element
#  for each domain.
#
#  Here's a brief description of what each file does:
#
#    config_namelist_01.inc
#    config_namelist_02.inc
#    config_namelist_03.inc
#    config_namelist_04.inc
#
#        These contain assignment statements that can be used to assign
#        fields from one record containing the namelist elements to another.
#        Each record (01, 02, ... ) of the namelist is handled with its own
#        file.  Included by module_domain.F.
#
#    state_namelist_statements.inc
#
#        Contains a list of Fortran NAMELIST statements associating each
#        namelist data element with it's record in the namelist.  Included
#        by module_config.F.
#
#    state_namelist_defines.inc
#
#        Contains a list of variable declarations for the identifiers
#        that are associated with namelist records in
#        state_namelist_statements.inc and also for declaring the
#        fields in a model_config_rec_type data structure.
#        Included by module_config.F .
#
#    state_namelist_assigns.inc
#
#        Contains assignment statements for moving data from one set
#        of namelist data elements to another (e.g. from the read-in
#        versions of the namelist variables to the field versions
#        in a model_config_rec_type structure).
#        Included by module_config.F .
#
#    state_namelist_reads.inc
#
#        Contains the read statements for the namelist records.
#        Included by module_config.F .
#
#    namelist.default
#
#        A sample namelist with default values.
#

open NAMELISTDEFINES, ">$wrf_root/inc/state_namelist_defines.inc" or 
  die "Cannot open state_namelist_defines.inc for writing" ;

# same as above except all variables are 0 dimensional
open NAMELISTDEFINES2, ">$wrf_root/inc/state_namelist_defines2.inc" or 
  die "Cannot open state_namelist_defines2.inc for writing" ;

open NAMELISTSTATEMENTS, ">$wrf_root/inc/state_namelist_statements.inc" or 
  die "Cannot open state_namelist_statements.inc for writing" ;

open NAMELISTDEFAULTS, ">$wrf_root/inc/state_namelist_defaults.inc" or 
  die "Cannot open state_namelist_defaults.inc for writing" ;

open NAMELISTASSIGNS, ">$wrf_root/inc/state_namelist_assigns.inc" or 
  die "Cannot open state_namelist_assigns.inc for writing" ;

open NAMELISTREADS, ">$wrf_root/inc/state_namelist_reads.inc" or 
  die "Cannot open state_namelist_reads.inc for writing" ;

open DFLTNAMELIST, ">$wrf_root/run/namelist.default" or
  die "Cannot open namelist.default for writing" ;

print NAMELISTDEFINES "!\n" ;
print NAMELISTDEFINES "! WARNING This file is generated automatically by use_registry\n" ;
print NAMELISTDEFINES "! using the data base in the file named Registry.\n" ;
print NAMELISTDEFINES "! Do not edit.  Your changes to this file will be lost.\n" ;
print NAMELISTDEFINES "!\n" ;
print NAMELISTDEFINES "! Contains data definitions for module_config.F.\n" ;
print NAMELISTDEFINES "!\n" ;

print NAMELISTSTATEMENTS "!\n" ;
print NAMELISTSTATEMENTS "! WARNING This file is generated automatically by use_registry\n" ;
print NAMELISTSTATEMENTS "! using the data base in the file named Registry.\n" ;
print NAMELISTSTATEMENTS "! Do not edit.  Your changes to this file will be lost.\n" ;
print NAMELISTSTATEMENTS "!\n" ;
print NAMELISTSTATEMENTS "! Contains namelist statements for module_config.F.\n" ;
print NAMELISTSTATEMENTS "!\n" ;

print NAMELISTASSIGNS "!\n" ;
print NAMELISTASSIGNS "! WARNING This file is generated automatically by use_registry\n" ;
print NAMELISTASSIGNS "! using the data base in the file named Registry.\n" ;
print NAMELISTASSIGNS "! Do not edit.  Your changes to this file will be lost.\n" ;
print NAMELISTASSIGNS "!\n" ;
print NAMELISTASSIGNS "! Contains namelist statements for module_config.F.\n" ;
print NAMELISTASSIGNS "!\n" ;

print NAMELISTDEFAULTS "!\n" ;
print NAMELISTDEFAULTS "! WARNING This file is generated automatically by use_registry\n" ;
print NAMELISTDEFAULTS "! using the data base in the file named Registry.\n" ;
print NAMELISTDEFAULTS "! Do not edit.  Your changes to this file will be lost.\n" ;
print NAMELISTDEFAULTS "!\n" ;
print NAMELISTDEFAULTS "! Contains default settings of namelist vars for module_config.F.\n" ;
print NAMELISTDEFAULTS "!\n" ;

print NAMELISTREADS "!\n" ;
print NAMELISTREADS "! WARNING This file is generated automatically by use_registry\n" ;
print NAMELISTREADS "! using the data base in the file named Registry.\n" ;
print NAMELISTREADS "! Do not edit.  Your changes to this file will be lost.\n" ;
print NAMELISTREADS "!\n" ;
print NAMELISTREADS "! Contains namelist statements for module_config.F.\n" ;
print NAMELISTREADS "#ifndef NAMELIST_READ_UNIT\n" ;
print NAMELISTREADS "#  define NAMELIST_READ_UNIT nml_unit\n" ;
print NAMELISTREADS "#endif\n" ;
print NAMELISTREADS "#ifndef NAMELIST_READ_ERROR_LABEL\n" ;
print NAMELISTREADS "#  define NAMELIST_READ_ERROR_LABEL 9200\n" ;
print NAMELISTREADS "#endif\n" ;
print NAMELISTREADS "!\n" ;

printf NAMELISTDEFINES  " %-10s :: %-15s\n","integer","first_item_in_struct" ;
printf NAMELISTDEFINES2 " %-10s :: %-15s\n","integer","first_item_in_struct" ;

foreach $_ ( @inline )
{
  s/#.*// ;
  s/[ \t][ \t]*/ /g ;
  $_ = lc $_ ;
  @t = split ' ' ;
  if ( $t[$table] ne "state" ) { next ; }

#   namelist defines file

  if ( substr( $t[$howset], 0, 8 ) eq "namelist" || $t[$howset] eq derived )
  {
    if ( $t[$nentries] eq "1" )
    {
      printf NAMELISTDEFINES " %-10s :: %-15s\n",$t[$type],$t[$sym] ;
    }
    else
    {
      printf NAMELISTDEFINES " %-10s, DIMENSION(%s) :: %-15s\n",$t[$type],$t[$nentries],$t[$sym] ;
    }
    printf NAMELISTDEFINES2 " %-10s :: %-15s\n",$t[$type],$t[$sym] ;
  }

#   namelist statements file
  if ( substr( $t[$howset], 0, 9 ) eq "namelist," )
  {
#    if ( $t[$howset] ne "derived" )
#    {
    $block = substr( $t[$howset],9 ) ;
    $namelist_recs{$block} = $namelist_recs{$block} . " " . $t[$sym] . ";" . $t[$dflt] . ";" . $t[$type] . ";" . $t[$nentries] ;
    printf NAMELISTSTATEMENTS " NAMELIST /%-10s/ %-15s\n",$block,$t[$sym] ;
# this hash contains all the namelist recs, even if defined
    $namelist_drecs{$block} = $namelist_drecs{$block} . " " . $t[$sym] . ";" . $t[$dflt] . ";" . $t[$type] . ";" . $t[$nentries] ;
  }
  elsif ( $t[$howset] eq "derived" )
  {
    $block = $t[$howset] ;
    $namelist_drecs{$block} = $namelist_drecs{$block} . " " . $t[$sym] . ";" . $t[$dflt] . ";" . $t[$type] . ";" . $t[$nentries] ;
  }
#  }

#   namelist defaults file

  if ( substr( $t[$howset], 0, 9 ) eq "namelist," )
  {
    if ( $t[$howset] ne "derived" && $t[$dflt] ne "" && $t[$dflt] ne "-" )
    {
      printf NAMELISTDEFAULTS " %-25s = %-25s\n",$t[$sym],$t[$dflt] ;
    }
  }

#   namelist assigns file

  if ( substr( $t[$howset], 0, 9 ) eq "namelist," )
  {
    if ( $t[$howset] ne "derived" )
    {
      if ( $t[$nentries] eq "1" )
      {
        printf NAMELISTASSIGNS " model_config_rec %% %-25s = %-25s\n",$t[$sym],$t[$sym] ;
      }
      else
      {
        printf NAMELISTASSIGNS " model_config_rec %% %-25s (1:$t[$nentries]) = %-25s (1:$t[$nentries])\n",$t[$sym],$t[$sym] ;
      }
    }
  }

}
printf NAMELISTDEFINES  " %-10s :: %-15s\n","integer","last_item_in_struct" ;
printf NAMELISTDEFINES2 " %-10s :: %-15s\n","integer","last_item_in_struct" ;

foreach $key ( sort keys %namelist_drecs )
{
  if ( $key ne "derived" )
  {
    print NAMELISTREADS "  READ   ( UNIT = NAMELIST_READ_UNIT , NML = $key , ERR = NAMELIST_READ_ERROR_LABEL )\n" ;
    print NAMELISTREADS "  WRITE  ( UNIT = *                  , NML = $key )\n" ;

    print DFLTNAMELIST  " &$key\n" ;
    @namevals = split ' ',$namelist_drecs{$key} ;
    $n = scalar @namevals ;
    for ( $pair = 0 ; $pair < $n ; $pair++ )
    {
      ( $name, $val ) = split ';',$namevals[$pair] ;
      printf DFLTNAMELIST " %-35s = %s",$name,$val ;
      if ( $pair + 1 == $n )     { print DFLTNAMELIST "/\n" }
      else                       { print DFLTNAMELIST ",\n" } ;
    }
    print DFLTNAMELIST  "\n" ;
  }

# May 18, 2000: do not generate assigns, generate subroutine definitions
# for accessing the config record variables out of the model layer, instead.

  open CONFIGASSIGNS, ">$wrf_root/inc/config_assign_$key.inc" or 
    die "Cannot open config_assign_$key.inc for writing" ;
  open CONFIGINQUIRE, ">$wrf_root/inc/config_$key.inc" or 
    die "Cannot open config_$key.inc for writing" ;
  print CONFIGINQUIRE "!\n" ;
  print CONFIGINQUIRE "! WARNING This file is generated automatically by use_registry\n" ;
  print CONFIGINQUIRE "! using the data base in the file named Registry.\n" ;
  print CONFIGINQUIRE "! Do not edit.  Your changes to this file will be lost.\n" ;
  print CONFIGINQUIRE "!\n" ;
  @namevals = split ' ',$namelist_drecs{$key} ;
  $n = scalar @namevals ;

  for ( $pair = 0 ; $pair < $n ; $pair++ )
  {
    ( $name, $val, $typ, $nentr ) = split ';',$namevals[$pair] ;
    if ( $nentr eq "1" )
    {
      printf CONFIGINQUIRE "SUBROUTINE get_%s ( %s )\n", $name, $name ;
      printf CONFIGINQUIRE "  USE module_configure\n" ;
    }
    else
    {
      printf CONFIGINQUIRE "SUBROUTINE get_%s ( id_id , %s )\n", $name, $name ;
      printf CONFIGINQUIRE "  USE module_configure\n" ;
      printf CONFIGINQUIRE "  INTEGER , INTENT(IN) :: id_id\n" ;
    }
    printf CONFIGINQUIRE "  %s , INTENT(OUT)     :: %s\n", $typ, $name ;
    if ( $nentr eq "1" )
    {
      printf CONFIGINQUIRE "  %s = model_config_rec%%%s \n", $name, $name ;
    }
    else
    {
      printf CONFIGINQUIRE "  %s = model_config_rec%%%s (id_id)\n", $name, $name ;
    }
    printf CONFIGINQUIRE "  RETURN\n" ;
    printf CONFIGINQUIRE "END SUBROUTINE get_%s\n", $name ;
  }

  for ( $pair = 0 ; $pair < $n ; $pair++ )
  {
    ( $name, $val, $typ, $nentr ) = split ';',$namevals[$pair] ;
    if ( $nentr eq "1" )
    {
      printf CONFIGINQUIRE "SUBROUTINE set_%s ( %s )\n", $name, $name ;
      printf CONFIGINQUIRE "  USE module_configure\n" ;
    }
    else
    {
      printf CONFIGINQUIRE "SUBROUTINE set_%s ( id_id , %s )\n", $name, $name ;
      printf CONFIGINQUIRE "  USE module_configure\n" ;
      printf CONFIGINQUIRE "  INTEGER , INTENT(IN) :: id_id\n" ;
    }
    printf CONFIGINQUIRE "  %s , INTENT(IN)     :: %s\n", $typ, $name ;
    if ( $nentr eq "1" )
    {
      printf CONFIGINQUIRE "  model_config_rec%%%s = %s \n", $name, $name ;
    }
    else
    {
      printf CONFIGINQUIRE "  model_config_rec%%%s (id_id) = %s\n", $name, $name ;
    }
    printf CONFIGINQUIRE "  RETURN\n" ;
    printf CONFIGINQUIRE "END SUBROUTINE set_%s\n", $name ;
  }

  print CONFIGASSIGNS "! Contains config assign statements for module_domain.F.\n" ;
  print CONFIGASSIGNS "#ifndef SOURCE_RECORD\n" ;
  print CONFIGASSIGNS "#  define SOURCE_RECORD cfg%%\n" ;
  print CONFIGASSIGNS "#endif\n" ;
  print CONFIGASSIGNS "#ifndef SOURCE_REC_DEX\n" ;
  print CONFIGASSIGNS "#  define SOURCE_REC_DEX \n" ;
  print CONFIGASSIGNS "#endif\n" ;
  print CONFIGASSIGNS "#ifndef DEST_RECORD\n" ;
  print CONFIGASSIGNS "#  define DEST_RECORD new_grid%%\n" ;
  print CONFIGASSIGNS "#endif\n" ;
  print CONFIGASSIGNS "!\n" ;
  @namevals = split ' ',$namelist_drecs{$key} ;
  $n = scalar @namevals ;
  for ( $pair = 0 ; $pair < $n ; $pair++ )
  {
    ( $name, $val, $typ, $nentr ) = split ';',$namevals[$pair] ;
    if ( $nentr eq "1" )
    {
      printf CONFIGASSIGNS " DEST_RECORD %-25s = SOURCE_RECORD %s \n",$name,$name ;
    }
    else
    {
      printf CONFIGASSIGNS " DEST_RECORD %-25s = SOURCE_RECORD %s SOURCE_REC_DEX\n",$name,$name ;
    }
  }

  close CONFIGASSIGNS ;
  close CONFIGINQUIRE ;
}


close NAMELISTDEFINES ;
close NAMELISTDEFINES2 ;
close NAMELISTSTATEMENTS ;
close NAMELISTREADS ;
close NAMELISTASSIGNS ;
close CONFIGASSIGNS ;
close DFLTNAMELIST ;

#############################################################################
#############################################################################

open SCALARINDICES, ">$wrf_root/inc/set_scalar_indices.inc" or
  die "Cannot open set_scalar_indices.inc for writing" ;

print SCALARINDICES "!\n" ;
print SCALARINDICES "! WARNING This file is generated automatically by use_registry\n" ;
print SCALARINDICES "! using the data base in the file named Registry.\n" ;
print SCALARINDICES "! Do not edit.  Your changes to this file will be lost.\n" ;
print SCALARINDICES "!\n" ;
print SCALARINDICES "! Contains statements for included in module_configure.F .\n" ;
print SCALARINDICES "!\n" ;

foreach $_ ( @inline )                                         ## iterate through input lines
{                                                              ##
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] eq "state" && $t[$howset] ne "" )
  {
    $rconfig_dims{$t[$sym]} = $t[$dims] ;
  }
}

# generate assignments to initialize the P_* variables to zero
foreach $_ ( @inline )                                         ## iterate through input lines
{                                                              ##
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] eq "state" )
  {
    $s1 = uc $t[$sym] ;
    if ( $s1 ne "-" )
    {
      if ( $multfieldarrays{$t[$use]} )
      { 
#        printf SCALARINDICES   "  %-30s = 0\n", "P_${s1}" ;
        printf SCALARINDICES   "  %-30s = 1\n", "P_${s1}" ;
      }
    }
  }
}

foreach $_ ( @inline )                                         ## iterate through input lines
{                                                              ##
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] eq "package" )
  {
    $x = $t[$assoc] ;
    $associated_namelist_var = substr($x,0,index($x, "=")) ;
    $associated_namelist_choice = substr($x,index($x, "=")+2) ;
    if    ( $rconfig_dims{$associated_namelist_var} eq "" )
    {
      print "WARNING: There is no associated namelist variable $associated_namelist_var for package $t[$package]\n" ;
    }
    elsif ( $rconfig_dims{$associated_namelist_var} == 1 )
    {
      print SCALARINDICES "IF ( model_config_rec%$associated_namelist_var == $associated_namelist_choice ) THEN\n" ;
    }
    else
    {
      print SCALARINDICES "IF ( model_config_rec%$associated_namelist_var(idomain) == $associated_namelist_choice ) THEN\n" ;
    }
    $x = $t[$assocscalars] ;
    @s = split ';', $x ;
    for ( $i = 0 ; $i <= $#s ; $i++ )
    {
      @x1 = split /[:,]/, $s[$i] ;
      $tabname = $x1[0] ;
      for ( $j = 1 ; $j <= $#x1 ; $j++ )
      {
        $varname = uc $x1[$j] ;
#        print SCALARINDICES "  IF ( ${tabname}_index_table( PARAM_$varname , idomain ) .lt. 0 ) THEN\n" ;
        print SCALARINDICES "  IF ( ${tabname}_index_table( PARAM_$varname , idomain ) .lt. 1 ) THEN\n" ;
        print SCALARINDICES "    ${tabname}_num_table(idomain) = ${tabname}_num_table(idomain) + 1\n" ;
        print SCALARINDICES "    P_$varname = ${tabname}_num_table(idomain)\n" ;
        print SCALARINDICES "    ${tabname}_index_table( PARAM_$varname , idomain ) = P_$varname\n" ;
        print SCALARINDICES "  ELSE\n" ;
        print SCALARINDICES "    P_$varname = ${tabname}_index_table( PARAM_$varname , idomain )\n" ;
        print SCALARINDICES "  END IF\n" ;
      }
    }
    print SCALARINDICES "END IF\n" ;
  }
}


close SCALARINDICES ;
}
return 1;
