!IDEAL:DRIVER_LAYER
!
! create an initial data set for the WRF model based on an ideal condition
PROGRAM ideal

   USE module_machine
   USE module_domain
   USE module_initialize
   USE module_io_domain
   USE module_driver_constants
   USE module_bc
   USE module_configure
   USE module_wrf_error

   USE module_timing
#ifdef DM_PARALLEL
   USE module_dm
#endif

   IMPLICIT NONE

   REAL    :: time

   INTEGER :: loop , &
              levels_to_process


   TYPE(domain) , POINTER :: keep_grid, grid_ptr, null_domain, grid
   TYPE(domain)           :: dummy
   TYPE (grid_config_rec_type)              :: config_flags
   INTEGER                :: number_at_same_level

   INTEGER :: max_dom, domain_id
   INTEGER :: id , ierr
   INTEGER :: idum1, idum2 
   INTEGER :: debug_level
#ifdef DM_PARALLEL
   INTEGER                 :: nbytes
   INTEGER, PARAMETER      :: configbuflen = 8*1024
   INTEGER*1               :: configbuf( configbuflen )
   LOGICAL , EXTERNAL      :: wrf_on_monitor
#endif

   CHARACTER (LEN=80)     :: message

   !  Define the name of this program (program_name defined in module_domain)

   program_name = "IDEAL PREPROCESSOR"

   !  Get the NAMELIST data for input.

   CALL init_modules

#ifdef DM_PARALLEL
   IF ( wrf_on_monitor() ) THEN
     CALL initial_config
   ENDIF
   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )
   CALL initial_dm_parallel
#else
   CALL initial_config
#endif
   CALL get_debug_level ( debug_level )
   CALL set_wrf_debug_level ( debug_level )

   !  An available simple timer from the timing module.

   NULLIFY( null_domain )
   CALL alloc_and_configure_domain ( domain_id  = 1 ,                  &
                                     local_time = 0 ,                  &
                                     grid       = head_grid ,          &
                                     parent     = null_domain ,        &
                                     kid        = -1                   )


   CALL set_scalar_indices_from_config ( head_grid%id , idum1, idum2 )
   grid => head_grid

   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )

   !  Initialize the mother domain.

   grid%input_from_file = .false.
   CALL init_domain (  grid )
   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )
   CALL calc_current_date ( grid%id, 0.)

!set some goofy values in the boundary arrays to see if they're working:

grid%ru_b(:,:,:,P_XSB) = 100.1
grid%ru_b(:,:,:,P_XEB) = 200.1
grid%ru_b(:,:,:,P_YSB) = 300.1
grid%ru_b(:,:,:,P_YEB) = 400.1
grid%rv_b(:,:,:,P_XSB) = 100.2
grid%rv_b(:,:,:,P_XEB) = 200.2
grid%rv_b(:,:,:,P_YSB) = 300.2
grid%rv_b(:,:,:,P_YEB) = 400.2

   CALL init_wrfio

! initialize a couple of unused variables that nevertheless can cause trouble
! if they have garbage in them:


   head_grid%write_metadata = .false.
   CALL open_w_dataset ( id, 'wrfinput', head_grid , config_flags , output_initial , ierr )
   IF ( ierr .NE. 0 ) THEN
     WRITE (wrf_err_message,*)'ideal: error opening wrfinput for writing ',ierr
     CALL wrf_error_fatal( wrf_err_message )
   ENDIF
   head_grid%write_metadata = .true.
   CALL output_initial ( id, head_grid , config_flags , ierr )
   CALL close_dataset ( id , config_flags )

   head_grid%write_metadata = .false.
   CALL open_w_dataset ( id, 'wrfbdy', head_grid , config_flags , output_boundary , ierr )
   IF ( ierr .NE. 0 ) THEN
     WRITE (wrf_err_message,*)'ideal: error opening wrfbdy for writing ',ierr
     CALL wrf_error_fatal( wrf_err_message )
   ENDIF
   head_grid%write_metadata = .true.
   CALL output_boundary ( id, head_grid , config_flags , ierr )
   CALL close_dataset ( id , config_flags )

#ifdef DM_PARALLEL
    CALL shutdown_dm_parallel
#endif


END PROGRAM ideal

