!WRF:MODEL_LAYER:CONFIGURATION
!
MODULE module_configure

   USE module_driver_constants
   USE module_state_description
   USE module_wrf_error

   TYPE model_config_rec_type
      SEQUENCE
! Statements that declare namelist variables are in this file
! Note that the namelist is SEQUENCE and generated such that the first item is an
! integer, first_item_in_struct and the last is an integer last_item_in_struct
! this provides a way of converting this to a buffer for passing to and from
! the driver.
#include <state_namelist_defines.inc>
   END TYPE model_config_rec_type

   TYPE grid_config_rec_type
#include <state_namelist_defines2.inc>
   END TYPE grid_config_rec_type

   TYPE(model_config_rec_type) :: model_config_rec

   INTEGER                     :: moist_index_table( param_num_moist, max_domains ) ! indices into moist table this domain
   INTEGER                     :: chem_index_table( param_num_chem, max_domains )   ! indices into chem table this domain
   INTEGER                     :: moist_num_table( max_domains )   ! number of moist table entries this domain
   INTEGER                     :: chem_num_table( max_domains )    ! number of chem table entries this domain

! special entries (put here but not enshrined in Registry for one reason or other)

   CHARACTER (LEN=4) :: mminlu = '    '         ! character string for landuse table

   PRIVATE read_namelist_data

CONTAINS


! Model layer, even though it does I/O -- special case of namelist I/O.

   SUBROUTINE initial_config
      IMPLICIT NONE

      INTEGER              :: io_status, nml_unit

! define as temporaries
#include <state_namelist_defines.inc>

! Statements that specify the namelists
#include <state_namelist_statements.inc>

      OPEN ( UNIT   = 10               ,      &
             FILE   = "namelist.input" ,      &
             FORM   = "FORMATTED"      ,      &
             STATUS = "OLD"            ,      &
             IOSTAT = io_status         )

      IF ( io_status .NE. 0 ) THEN
        CALL WRF_ERROR_FATAL ( 'ERROR OPENING namelist.input' )
      ENDIF

      nml_unit = 10

! Statements that set the namelist vars to default vals
#  include <state_namelist_defaults.inc>

! Statements that read the namelist are in this file
#  define NAMELIST_READ_ERROR_LABEL 9200
#  include <state_namelist_reads.inc>

! Statements that assign the variables to the cfg record are in this file
! except the namelist_derived variables where are assigned below
#include <state_namelist_assigns.inc>

      CLOSE ( UNIT = 10 , IOSTAT = io_status )

      IF ( io_status .NE. 0 ) THEN
        CALL WRF_ERROR_FATAL ( 'ERROR CLOSING namelist.input' )
      ENDIF

      data_ordering : SELECT CASE ( model_data_order )
	CASE  ( DATA_ORDER_XYZ )
          model_config_rec%sd31(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_we(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_sn(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_vert(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_we(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_sn(1:max_dom)

	CASE  ( DATA_ORDER_YXZ )
          model_config_rec%sd31(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_sn(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_we(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_vert(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_we(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_sn(1:max_dom)

	CASE  ( DATA_ORDER_ZXY )
          model_config_rec%sd31(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_vert(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_we(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_sn(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_sn(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_we(1:max_dom)

	CASE  ( DATA_ORDER_ZYX )
          model_config_rec%sd31(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_vert(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_sn(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_we(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_sn(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_we(1:max_dom)

	CASE  ( DATA_ORDER_XZY )
          model_config_rec%sd31(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_we(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_vert(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_sn(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_we(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_sn(1:max_dom)

	CASE  ( DATA_ORDER_YZX )
          model_config_rec%sd31(1:max_dom)       = s_sn(1:max_dom)
          model_config_rec%ed31(1:max_dom)       = e_sn(1:max_dom)
          model_config_rec%sd32(1:max_dom)       = s_vert(1:max_dom)
          model_config_rec%ed32(1:max_dom)       = e_vert(1:max_dom)
          model_config_rec%sd33(1:max_dom)       = s_we(1:max_dom)
          model_config_rec%ed33(1:max_dom)       = e_we(1:max_dom)

	  model_config_rec%sd21(1:max_dom)       = s_sn(1:max_dom)
	  model_config_rec%ed21(1:max_dom)       = e_sn(1:max_dom)
	  model_config_rec%sd22(1:max_dom)       = s_we(1:max_dom)
	  model_config_rec%ed22(1:max_dom)       = e_we(1:max_dom)

      END SELECT data_ordering
      RETURN
9200  CONTINUE
      CALL wrf_error_fatal( 'module_configure: initial_config: error reading namelist' )

   END SUBROUTINE initial_config

#if 1
   SUBROUTINE get_config_as_buffer( buffer, buflen, ncopied )
! note that model_config_rec_type must be defined as a sequence derived type
      INTEGER*1, INTENT(INOUT) ::  buffer(*)
      INTEGER,   INTENT(IN)    ::  buflen
      INTEGER,   INTENT(OUT)   ::  ncopied
!      TYPE(model_config_rec_type) :: model_config_rec
      INTEGER :: nbytes
      CALL wrf_num_bytes_between ( model_config_rec%last_item_in_struct ,   &
                                   model_config_rec%first_item_in_struct ,  &
                                   nbytes )
!      nbytes = loc(model_config_rec%last_item_in_struct) - &
!               loc(model_config_rec%first_item_in_struct)
      IF ( nbytes .gt. buflen ) THEN
	CALL wrf_error_fatal( "get_config_rec_as_buffer: buffer size to small for config_rec" )
      ENDIF
      CALL wrf_mem_copy( model_config_rec, buffer, nbytes )
      ncopied = nbytes
      RETURN
   END SUBROUTINE get_config_as_buffer

   SUBROUTINE set_config_as_buffer( buffer, buflen )
! note that model_config_rec_type must be defined as a sequence derived type
      INTEGER*1, INTENT(INOUT) ::  buffer(*)
      INTEGER,   INTENT(IN)    ::  buflen
!      TYPE(model_config_rec_type) :: model_config_rec
      INTEGER :: nbytes
      CALL wrf_num_bytes_between ( model_config_rec%last_item_in_struct ,  &
                                   model_config_rec%first_item_in_struct , &
                                   nbytes )
!      nbytes = loc(model_config_rec%last_item_in_struct) - &
!               loc(model_config_rec%first_item_in_struct)
      IF ( nbytes .gt. buflen ) THEN
	CALL wrf_error_fatal( "set_config_rec_as_buffer: buffer length too small to fill model config record" )
      ENDIF
      CALL wrf_mem_copy( buffer, model_config_rec, nbytes )
      RETURN
   END SUBROUTINE set_config_as_buffer
#else
   SUBROUTINE get_config_as_buffer( buffer, buflen, ncopied )
! note that model_config_rec_type must be defined as a sequence derived type
      INTEGER*1, INTENT(INOUT) ::  buffer(*)
      INTEGER,   INTENT(IN)    ::  buflen
      INTEGER,   INTENT(OUT)   ::  ncopied
!      TYPE(model_config_rec_type) :: model_config_rec
      INTEGER :: nbytes
      nbytes = loc(model_config_rec%last_item_in_struct) - &
               loc(model_config_rec%first_item_in_struct)
      IF ( nbytes .gt. buflen ) THEN
	CALL wrf_error_fatal( "get_config_rec_as_buffer: buffer size to small for config_rec" )
      ENDIF
      CALL wrf_mem_copy( model_config_rec, buffer, nbytes )
      ncopied = nbytes
      RETURN
   END SUBROUTINE get_config_as_buffer

   SUBROUTINE set_config_as_buffer( buffer, buflen )
! note that model_config_rec_type must be defined as a sequence derived type
      INTEGER*1, INTENT(INOUT) ::  buffer(*)
      INTEGER,   INTENT(IN)    ::  buflen
!      TYPE(model_config_rec_type) :: model_config_rec
      INTEGER :: nbytes
      nbytes = loc(model_config_rec%last_item_in_struct) - &
               loc(model_config_rec%first_item_in_struct)
      IF ( nbytes .gt. buflen ) THEN
	CALL wrf_error_fatal( "set_config_rec_as_buffer: buffer length too small to fill model config record" )
      ENDIF
      CALL wrf_mem_copy( buffer, model_config_rec, nbytes )
      RETURN
   END SUBROUTINE set_config_as_buffer
#endif

   SUBROUTINE model_to_grid_config_rec ( id_id , model_config_rec , grid_config_rec )
      INTEGER , INTENT(IN)                         ::  id_id
      TYPE ( model_config_rec_type ) , INTENT(IN)  ::  model_config_rec
      TYPE ( grid_config_rec_type  ) , INTENT(OUT) ::  grid_config_rec
#define SOURCE_RECORD model_config_rec %
#define SOURCE_REC_DEX (id_id)
#define DEST_RECORD   grid_config_rec %
#include <config_assign_derived.inc>
#include <config_assign_namelist_01.inc>
#include <config_assign_namelist_02.inc>
#include <config_assign_namelist_03.inc>
#include <config_assign_namelist_04.inc>
#include <config_assign_namelist_05.inc>
   END SUBROUTINE model_to_grid_config_rec

! Include the definitions of all the routines that return a namelist values
! back to the driver. These are generated by the registry

   SUBROUTINE init_module_configure
     IMPLICIT NONE
     ! Local vars

     INTEGER i , j

     DO j = 1, max_domains
       moist_num_table(j) = 1    ! 1 means empty
       chem_num_table(j) = 1     ! 1 means empty
     END DO
   END SUBROUTINE init_module_configure

END MODULE module_configure

! Special (outside registry)
SUBROUTINE get_mminlu ( retval )
  USE module_configure
  CHARACTER(LEN=4) , INTENT(OUT) :: retval
  retval = mminlu   ! mminlu is defined in module_configure
  RETURN
END SUBROUTINE get_mminlu
SUBROUTINE set_mminlu ( inval )
  USE module_configure
  CHARACTER(LEN=4) , INTENT(IN) :: inval
  mminlu = inval    ! mminlu is defined in module_configure
  RETURN
END SUBROUTINE set_mminlu

#include <config_namelist_01.inc>
#include <config_namelist_02.inc>
#include <config_namelist_03.inc>
#include <config_namelist_04.inc>
#include <config_namelist_05.inc>
#include <config_derived.inc>

SUBROUTINE set_scalar_indices_from_config ( idomain , nitems_moist, nitems_chem )
  USE module_driver_constants
  USE module_state_description
  USE module_wrf_error
  USE module_configure
  IMPLICIT NONE
  INTEGER , INTENT(IN)  :: idomain
  INTEGER , INTENT(OUT) :: nitems_moist
  INTEGER , INTENT(OUT) :: nitems_chem

#include <set_scalar_indices.inc>
  nitems_moist = moist_num_table(idomain)
  nitems_chem  = chem_num_table(idomain)
  num_moist = nitems_moist           ! set the variables in module_state_description
  num_chem = nitems_chem             ! set the variables in module_state_description
  RETURN
END SUBROUTINE set_scalar_indices_from_config
