!WRF:PACKAGE:IO
!
MODULE module_ext_io

   INTEGER, PARAMETER :: p_oldext_io_ids  =  1
   INTEGER, PARAMETER :: p_oldext_io_ide  =  2
   INTEGER, PARAMETER :: p_oldext_io_jds  =  3
   INTEGER, PARAMETER :: p_oldext_io_jde  =  4
   INTEGER, PARAMETER :: p_oldext_io_kds  =  5
   INTEGER, PARAMETER :: p_oldext_io_kde  =  6

   INTEGER, PARAMETER :: p_oldext_io_ims  =  7
   INTEGER, PARAMETER :: p_oldext_io_ime  =  8
   INTEGER, PARAMETER :: p_oldext_io_jms  =  9 
   INTEGER, PARAMETER :: p_oldext_io_jme  = 10 
   INTEGER, PARAMETER :: p_oldext_io_kms  = 11
   INTEGER, PARAMETER :: p_oldext_io_kme  = 12

   INTEGER, PARAMETER :: p_oldext_io_ips  = 13
   INTEGER, PARAMETER :: p_oldext_io_ipe  = 14
   INTEGER, PARAMETER :: p_oldext_io_jps  = 15
   INTEGER, PARAMETER :: p_oldext_io_jpe  = 16
   INTEGER, PARAMETER :: p_oldext_io_kps  = 17
   INTEGER, PARAMETER :: p_oldext_io_kpe  = 18

   INTEGER, PARAMETER :: p_oldext_io_domdesc  = 19

   INTEGER, PARAMETER :: p_oldext_io_domain_info_len = 19

   INTEGER, PARAMETER :: EXT_READ   = 1
   INTEGER, PARAMETER :: EXT_WRITE  = 2

END MODULE module_ext_io

  SUBROUTINE oldext_open_dataset ( fname , domain_info ,  mode ,  &
                                 sys_dep_info , id )
    USE module_ext_io
    IMPLICIT NONE
    INTEGER , INTENT( IN )  :: mode
    INTEGER , INTENT( IN )  :: domain_info(*)
    INTEGER , INTENT( OUT ) :: id
    CHARACTER*(*)    :: sys_dep_info
    CHARACTER*(*)    :: fname
    ! Local data

    INTEGER                  :: i
    INTEGER                  :: lenname
    INTEGER, DIMENSION(256)  :: intname
    INTEGER                  :: lendepinfo
    INTEGER, DIMENSION(2096) :: int_dep_info

    lenname = LEN_TRIM( fname )
    DO i = 1, MIN(lenname,256)
      intname(i) = ICHAR(fname(i:i))
    ENDDO
    lendepinfo = LEN_TRIM( sys_dep_info )
    DO i = 1, MIN(lendepinfo,2096)
      int_dep_info(i) = ICHAR(sys_dep_info(i:i))
    ENDDO
    CALL oldext_open_dataset_c ( intname , lenname ,              &
                              domain_info ,                    &
                              mode  ,                          &
                              int_dep_info ,  lendepinfo ,     &
                              id )
  END SUBROUTINE oldext_open_dataset

  SUBROUTINE fortran_named_open_write( name, lenname, unit, ierr )
    USE module_ext_io
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: lenname, unit
    INTEGER, INTENT(OUT) :: ierr
    CHARACTER name(*)
    CHARACTER*120 fname
    INTEGER i
    DO i = 1, lenname
      fname(i:i) = name(i)
    ENDDO
    IERR = 0
    OPEN( unit, file=fname(1:lenname), form="unformatted", err=99 )
    RETURN
99  CONTINUE
    IERR = 1
    RETURN
  END SUBROUTINE fortran_named_open_write

  SUBROUTINE fortran_named_open_read( name, lenname, unit, ierr )
    USE module_ext_io
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: lenname, unit
    INTEGER, INTENT(OUT) :: ierr
    CHARACTER name(*)
    CHARACTER*120 fname
    INTEGER i
    DO i = 1, lenname
      fname(i:i) = name(i)
    ENDDO
    IERR = 0
    OPEN( unit, file=fname(1:lenname), form="unformatted", status="old", err=99 )
    RETURN
99  CONTINUE
    IERR = 1
    RETURN
  END SUBROUTINE fortran_named_open_read

  SUBROUTINE fortran_read( unit, buf, n )
    USE module_ext_io
    implicit none
    integer unit, n, i
    real buf(n)
    read( unit ) buf
    return
  END SUBROUTINE fortran_read

  SUBROUTINE fortran_write( unit, buf, n )
    USE module_ext_io
    implicit none
    integer unit, n, i
    real buf(n)
    write( unit ) buf
    return
  END SUBROUTINE fortran_write

  SUBROUTINE fortran_close( unit )
    USE module_ext_io
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: unit
    CLOSE (unit)
    RETURN
  END SUBROUTINE fortran_close




