!WRF:PACKAGE:IO
!

MODULE module_io_mm5

  USE module_wrf_error
  USE module_date_time

   INTEGER, PARAMETER :: bh_flag = 0 , sh_flag = 1 , eot_flag = 2
   INTEGER, PARAMETER :: d3 = 3 , d2 = 2 , d1 = 1
   INTEGER, PARAMETER :: numint=50 , numreal=20 , numprogs=20 , filedone = 919
   INTEGER         , POINTER :: bhi  ( : , : )
   REAL            , POINTER :: bhr  ( : , : )
   CHARACTER*80    , POINTER :: bhic ( : , : )
   CHARACTER*80    , POINTER :: bhrc ( : , : )
! switch parameters
   INTEGER, PARAMETER :: initial_only=1, boundary_only=2, restart_only=3, history_only=4
!
! NOTE THAT IF YOU CHANGE THE HARD CODED FIELD LENGTHS BELOW PLEASE
! ALSO MAKE THE CHANGE IN THE DEFINITIONS OF THE ASSOCIATED INTEGER
! PARAMETERS IN THIS FILE.
!
  INTEGER flag
  INTEGER start_index(4)
  INTEGER end_index(4)
  REAL rtime
  CHARACTER*  4    staggering
  CHARACTER*  4      ordering
  CHARACTER*  9          name
  CHARACTER* 25         units
  CHARACTER* 46   description
!
! INTEGER PARAMETERS OF THE SMALL HEADER FIELD LENGTHS ABOVE
!
  INTEGER , PARAMETER :: len_start_index   = 4
  INTEGER , PARAMETER :: len_end_index     = 4
  INTEGER , PARAMETER :: len_staggering    = 4
  INTEGER , PARAMETER :: len_ordering      = 4
  INTEGER , PARAMETER :: len_name          = 9
  INTEGER , PARAMETER :: len_units         = 25
  INTEGER , PARAMETER :: len_description   = 46

! 
! BIG HEADER META DATA
!
  INTEGER, PARAMETER :: numstring = 100
  INTEGER, DIMENSION(numstring) :: a_r, b_r, a_i, b_i
  CHARACTER*32, DIMENSION(numstring) :: meta_string_r, meta_string_i

CONTAINS

  SUBROUTINE init_module_io_mm5
    NULLIFY ( bhi )
    NULLIFY ( bhr )
    NULLIFY ( bhic )
    NULLIFY ( bhrc )
  END SUBROUTINE init_module_io_mm5

END MODULE module_io_mm5

    SUBROUTINE write_flag( iutl, aflag )
      USE module_io_mm5
      IMPLICIT NONE
#if defined(DM_PARALLEL) && defined(WRF_RSL_IO)
#  include <rsl.inc>
#endif
      INTEGER iutl, aflag
#ifndef DM_PARALLEL
      WRITE (IUTL)AFLAG
#else
# if defined(WRF_RSL_IO)
      CALL rsl_write_1d_data(iutl,aflag,1,RSL_INTEGER)
# endif
#endif
      RETURN
    END SUBROUTINE write_flag

      SUBROUTINE write_big_header( IUNIT, JBHI, JBHR, JBHIC, JBHRC )
      USE module_io_mm5
      IMPLICIT NONE
      INTEGER IUNIT
      INTEGER       jbhi ( numint, numprogs)
      REAL          jbhr ( numreal, numprogs)
      CHARACTER*80  jbhic ( numint, numprogs)
      CHARACTER*80  jbhrc ( numreal, numprogs)
      LOGICAL DM_IONODE
      EXTERNAL DM_IONODE
#ifndef DM_PARALLEL
      WRITE (IUNIT)JBHI,JBHR,JBHIC,JBHRC
#else
! NOTE THAT ON CERTAIN MACHINES (T3E, ALPHA) JBHI AND JBHR MAY                   24SEP99.293
! BE CHANGED/DESTROYED.  RSL SHOULD BE MODIFIED TO MAKE THIS SAFE                24SEP99.294
! BUT RIGHT NOW, THESE ARE NOT REUSED ANYWAY, SO OKAY FOR NOW (v3.1)             24SEP99.295
      CALL RSL_WRITE_MM5V3_BIG_HEADER(               &
                 IUNIT,                              &
                 JBHI,NUMINT*NUMPROGS,               &
                 JBHR,NUMREAL*NUMPROGS,              &
                 JBHIC,80*NUMINT*NUMPROGS,           &
                 JBHRC,80*NUMREAL*NUMPROGS,          &
                 IWORDSIZE,RWORDSIZE )
#endif
      RETURN
      END SUBROUTINE write_big_header

  SUBROUTINE output_initial_mm5 ( fid , grid , config_flags )
    USE module_io_mm5
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL output_mm5 ( fid , grid , config_flags , initial_only )
    RETURN
  END SUBROUTINE output_initial_mm5

  SUBROUTINE output_restart_mm5 ( fid , grid , config_flags )
    USE module_io_mm5
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL output_mm5 ( fid , grid , config_flags , restart_only )
    RETURN
  END SUBROUTINE output_restart_mm5

  SUBROUTINE output_history_mm5 ( fid , grid , config_flags )
    USE module_io_mm5
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL output_mm5 ( fid , grid , config_flags , history_only )
    RETURN
  END SUBROUTINE output_history_mm5

  SUBROUTINE output_boundary_mm5 ( fid , grid , config_flags )
    USE module_io_mm5
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL output_mm5 ( fid , grid , config_flags , boundary_only )
    RETURN
  END SUBROUTINE output_boundary_mm5

  SUBROUTINE output_mm5 ( fid , grid , config_flags, switch )
    USE module_io_mm5
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid, switch

    ! Local data
    INTEGER       jbhi ( numint, numprogs)
    REAL          jbhr ( numreal, numprogs)
    CHARACTER*80  jbhic ( numint, numprogs)
    CHARACTER*80  jbhrc ( numreal, numprogs)
    INTEGER ids , ide , jds , jde , kds , kde , &
            ims , ime , jms , jme , kms , kme , &
            ips , ipe , jps , jpe , kps , kpe
    INTEGER i,j
    INTEGER ny , nm , nd , nh , ni , ns , nt
    INTEGER julyr, julday, idt, iswater, map_proj
    REAL    gmt, cen_lat, bdyfrq
    REAL    cen_lon, truelat1, truelat2 
    CHARACTER*19  new_date
    CHARACTER*24  base_date
    CHARACTER*80  char_junk
integer iii,jjj


    IF ( .not. ASSOCIATED ( bhi  ) ) THEN
      ALLOCATE ( bhi ( numint , numprogs ) )
      bhi = 0
    ENDIF
    IF ( .not. ASSOCIATED ( bhr  ) ) THEN
      ALLOCATE ( bhr ( numreal , numprogs ) )
      bhi = 0.
    ENDIF
    IF ( .not. ASSOCIATED ( bhic ) ) THEN
      ALLOCATE ( bhic ( numint , numprogs ) )
      DO j = 1, numprogs
      DO i = 1, numint
        bhic(i,j) = '                                                                               ' 
      ENDDO
      ENDDO
    ENDIF
    IF ( .not. ASSOCIATED ( bhrc ) ) THEN
      ALLOCATE ( bhrc ( numreal , numprogs ) )
      DO j = 1, numprogs
      DO i = 1, numreal
        bhrc(i,j) = '                                                                               ' 
      ENDDO
      ENDDO
    ENDIF

    staggering   = '    '
    ordering     = '    '
    name         = '         '
    units        = '                         '
    description  = '                                              '

    ids             = grid%sd31 
    ide             = grid%ed31 
    jds             = grid%sd33 
    jde             = grid%ed33 
    kds             = grid%sd32 
    kde             = grid%ed32 
    ims             = grid%sm31 
    ime             = grid%em31 
    jms             = grid%sm33 
    jme             = grid%em33 
    kms             = grid%sm32 
    kme             = grid%em32 
    ips             = grid%sp31 
    ipe             = grid%ep31 
    jps             = grid%sp33 
    jpe             = grid%ep33 
    kps             = grid%sp32 
    kpe             = grid%ep32 

! julyr, julday and gmt can be set in namelist_03 for ideal.exe run
      CALL get_gmt (grid%id, gmt)
      CALL set_bhr ( 'gmt' , gmt , 'gmt' )
      CALL get_julyr (grid%id, julyr)
      CALL set_bhi ( 'julyr' , julyr , 'julyr' )
      CALL get_julday (grid%id, julday)
      CALL set_bhi ( 'julday' , julday , 'julday' )
      CALL get_map_proj (grid%id, map_proj)
      CALL set_bhi ( 'map_proj' , map_proj , 'map_proj' )
      CALL get_mminlu ( char_junk(1:4) )
      CALL get_iswater (grid%id, iswater )
      CALL set_bhi ( 'iswater' , iswater , char_junk(1:4) )
      CALL get_cen_lat ( grid%id , cen_lat )
      CALL set_bhr ( 'cen_lat' , cen_lat , 'cen_lat' )
      CALL get_cen_lon ( grid%id , cen_lon )
      CALL set_bhr ( 'cen_lon' , cen_lon , 'cen_lon' )
      CALL get_truelat1 ( grid%id , truelat1 )
      CALL set_bhr ( 'truelat1' , truelat1 , 'truelat1' )
      CALL get_truelat2 ( grid%id , truelat2 )
      CALL set_bhr ( 'truelat2' , truelat2 , 'truelat2' )
      IF ( switch .EQ. boundary_only ) THEN
        CALL get_bdyfrq ( grid%id , bdyfrq )
        CALL set_bhr ( 'bdyfrq' , bdyfrq , 'bdyfrq' )
      ENDIF

    WRITE(wrf_err_message,*)'current_date: ',current_date
    CALL wrf_debug( 50 , wrf_err_message)
    IF ( grid%write_metadata ) THEN
      jbhi = bhi
      jbhr = bhr
      jbhic = bhic
      jbhrc = bhrc
      jbhi(1,1)        = 11
      jbhic(1,1)(1:80) = &
'OUTPUT FROM PROGRAM WRF                                                          '
      jbhi(5,1) = ime-ims+1
      jbhi(6,1) = jme-jms+1
      jbhi(13,1) = grid%id + bhi(13,1) - 1 
      jbhi(14,1) = bhi(14,1)  ! modify once nesting implemented
      jbhi(15,1) = bhi(15,1)  ! modify once nesting implemented
      jbhi(16,1) = config_flags%e_sn - config_flags%s_sn + 1 ! was IL in MM5
      jbhi(17,1) = config_flags%e_we - config_flags%s_we + 1 ! was JL in MM5
      jbhi(18,1) = bhi(18,1)
      jbhi(19,1) = bhi(19,1)
      jbhi(21,1) = bhi(21,1)
      jbhr(9,1)  = config_flags%dx
      CALL split_date_char ( start_date , ny , nm , nd , nh , ni , ns , nt )
      jbhi(5,11)=NY
      jbhic(5,11)( 1:80) = &
'FOUR-DIGIT YEAR OF START TIME                                                    '
      jbhi(6,11)=NM
      jbhic(6,11)( 1:80) = &
'INTEGER MONTH OF START TIME                                                      '
      jbhi(7,11)=ND
      jbhic(7,11)( 1:80) = &
'DAY OF THE MONTH OF THE START TIME                                               '
      jbhi(8,11)=NH
      jbhic(8,11)( 1:80) = &
'HOUR OF THE START TIME                                                           '
      jbhi(9,11)=NI
      jbhic(9,11)( 1:80) = &
'MINUTES OF THE START TIME                                                        '
      jbhi(10,11)=NS
      jbhic(10,11)(1:80) = &
'SECONDS OF THE START TIME                                                        '
      jbhi(11,11)=NT
      jbhic(11,11)(1:80) = &
'TEN THOUSANDTHS OF A SECOND OF THE START                                         '
      jbhi(12,11)= config_flags%e_vert - config_flags%s_vert
      jbhic(12,11)(1:80) = &
'MKX: NUMBER OF LAYERS IN MM5 OUTPUT                                              '

! WRF Specific 0 D variables in the big header (temporary)

      jbhr(15,11) = grid%cf1
      jbhr(16,11) = grid%cf2
      jbhr(17,11) = grid%cf3
      jbhr(18,11) = grid%zetatop
      
      CALL write_flag ( fid , bh_flag )
      CALL write_big_header ( fid, jbhi , jbhr , jbhic , jbhrc  )

    ENDIF



      IF ( switch .EQ. initial_only ) THEN
#define MM5_IO_UNIT fid
#define MM5_IO_GRID grid
#define MM5_IO_ROUTINE WRITE_FIELDREC
#define MM5_IO_CURRENT_DATE current_date
! generated by the registry
#include <mm5_initialout.inc>
      ELSE IF ( switch .EQ. restart_only ) THEN
#define MM5_IO_UNIT fid
#define MM5_IO_GRID grid
#define MM5_IO_ROUTINE WRITE_FIELDREC
#define MM5_IO_CURRENT_DATE current_date
! generated by the registry
#include <mm5_restartout.inc>
      ELSE IF ( switch .EQ. history_only ) THEN
#define MM5_IO_UNIT fid
#define MM5_IO_GRID grid
#define MM5_IO_ROUTINE WRITE_FIELDREC
#define MM5_IO_CURRENT_DATE current_date
! generated by the registry
#include <mm5_histout.inc>
      ELSE IF ( switch .EQ. boundary_only ) THEN
#define MM5_IO_UNIT fid
#define MM5_IO_GRID grid
#define MM5_IO_ROUTINE WRITE_FIELDREC
#define MM5_IO_CURRENT_DATE current_date
! generated by the registry
#include <mm5_bdyout.inc>
      ENDIF

      CALL write_flag ( fid , eot_flag )

    RETURN
  END SUBROUTINE output_mm5


  SUBROUTINE input_initial_mm5 ( fid , grid , config_flags )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_mm5
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL input_mm5 ( fid , grid , config_flags , initial_only )
    RETURN
  END SUBROUTINE input_initial_mm5

  SUBROUTINE input_restart_mm5 ( fid , grid , config_flags )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_mm5
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL input_mm5 ( fid , grid , config_flags , restart_only )
    RETURN
  END SUBROUTINE input_restart_mm5

  SUBROUTINE input_history_mm5 ( fid , grid , config_flags )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_mm5
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL input_mm5 ( fid , grid , config_flags , history_only )
    RETURN
  END SUBROUTINE input_history_mm5

  SUBROUTINE input_boundary_mm5 ( fid , grid , config_flags )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_mm5
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    CALL input_mm5 ( fid , grid , config_flags , boundary_only )
    RETURN
  END SUBROUTINE input_boundary_mm5

  SUBROUTINE input_mm5 ( fid , grid , config_flags , switch )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_mm5
    USE module_wrf_error
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(IN) :: switch
    ! Local data
    INTEGER ids , ide , jds , jde , kds , kde , &
            ims , ime , jms , jme , kms , kme , &
            ips , ipe , jps , jpe , kps , kpe
    INTEGER       iname(9)
    INTEGER       iordering(3)
    INTEGER       icurrent_date(24)
    INTEGER       i,j,k
    INTEGER       ier
    INTEGER       ndim
    INTEGER       ilen
    INTEGER       lendim1, lendim2, lendim3
    INTEGER       jbhi ( numint, numprogs)
    REAL          jbhr ( numreal, numprogs)
    CHARACTER*80  jbhic ( numint, numprogs)
    CHARACTER*80  jbhrc ( numreal, numprogs)
    CHARACTER*80  char_junk
    CHARACTER*256 errmess
    CHARACTER*9   NAMESTR
    INTEGER       IBDY, NAMELEN
    INTEGER       iswater, map_proj
    INTEGER       julyr,julday
    REAL          bdyfrq, oldtime, newtime,gmt,cen_lat
    REAL          cen_lon, truelat1, truelat2
    LOGICAL wrf_on_monitor
    EXTERNAL wrf_on_monitor

    ids             = grid%sd31 
    ide             = grid%ed31 
    jds             = grid%sd33 
    jde             = grid%ed33 
    kds             = grid%sd32 
    kde             = grid%ed32 
    ims             = grid%sm31 
    ime             = grid%em31 
    jms             = grid%sm33 
    jme             = grid%em33 
    kms             = grid%sm32 
    kme             = grid%em32 
    ips             = grid%sp31 
    ipe             = grid%ep31 
    jps             = grid%sp33 
    jpe             = grid%ep33 
    kps             = grid%sp32 
    kpe             = grid%ep32 

    CALL wrf_debug( 200, 'module_io_mm5: in input_mm5' )

    IF ( .not. ASSOCIATED ( bhi  ) ) THEN
      ALLOCATE ( bhi ( numint , numprogs ) )
      bhi = 0
    ENDIF
    IF ( .not. ASSOCIATED ( bhr  ) ) THEN
      ALLOCATE ( bhr ( numreal , numprogs ) )
      bhr = 0.
    ENDIF
    IF ( .not. ASSOCIATED ( bhic ) ) THEN
      ALLOCATE ( bhic ( numint , numprogs ) )
      DO j = 1, numprogs
      DO i = 1, numint
        bhic(i,j) = '                                                                               '
      ENDDO
      ENDDO
    ENDIF
    IF ( .not. ASSOCIATED ( bhrc ) ) THEN
      ALLOCATE ( bhrc ( numreal , numprogs ) )
      DO j = 1, numprogs
      DO i = 1, numreal
        bhrc(i,j) = '                                                                               '
      ENDDO
      ENDDO
    ENDIF

    CALL wrf_debug( 200, 'module_io_mm5: in input_mm5 2' )


! Loop over records in input file

 10 CONTINUE

    IF ( wrf_on_monitor() ) read ( fid ) flag
    CALL wrf_dm_bcast_bytes ( flag , IWORDSIZE )
    WRITE(errmess,*) 'module_io_mm5: input_mm5: 10 loop: flag = ',flag
    CALL wrf_debug( 500, errmess )

    IF ( flag .eq. 0 ) then
      IF ( wrf_on_monitor() ) THEN
        READ ( fid , iostat=ier ) jbhi , jbhr , jbhic , jbhrc
        bhi = jbhi
        bhr = jbhr
        bhic = jbhic
        bhrc = jbhrc
        IF ( ier .ne. 0 ) THEN
          CALL WRF_ERROR_FATAL ( 'input_mm5: Error reading big header' )
        ENDIF
      ENDIF
      CALL wrf_dm_bcast_bytes ( bhi , NUMINT  * IWORDSIZE )
      CALL wrf_dm_bcast_bytes ( bhr , NUMREAL * RWORDSIZE )

      GO TO 10
    ELSE IF ( flag .eq. 1 ) THEN
      IF ( wrf_on_monitor() ) THEN
        READ (fid,iostat=ier) ndim, start_index, end_index, rtime,       &
             staggering, ordering, current_date, name, units,              &
             description
      ENDIF
      CALL wrf_dm_bcast_bytes ( ndim        , 1 * IWORDSIZE )
      CALL wrf_dm_bcast_bytes ( start_index , len_start_index * IWORDSIZE )
      CALL wrf_dm_bcast_bytes ( end_index   , len_end_index   * IWORDSIZE )
      CALL wrf_dm_bcast_bytes ( rtime       , 1               * RWORDSIZE )
      CALL wrf_dm_bcast_string ( name , LEN_TRIM(name) )
      CALL wrf_dm_bcast_string ( ordering , LEN_TRIM(ordering) )
      CALL wrf_dm_bcast_string ( current_date , LEN_TRIM(current_date) )
      WRITE(errmess,*) 'module_io_mm5: input_mm5: 10 loop: name = ',TRIM(name)
      CALL wrf_debug( 500, errmess )


      lendim1 = (end_index(1)-start_index(1)+1)
      lendim2 = (end_index(2)-start_index(2)+1)
      lendim3 = (end_index(3)-start_index(3)+1)

      IF      ( ndim .EQ. 3 ) THEN
! kludge 20000628
!	IF ( lendim1 .ne. ide-ids+1 .or. lendim2 .ne. jde-jds+1 .or. lendim3 .lt. kde-kds ) THEN
        IF ( ordering(3:3) .EQ. 'B' ) THEN
          IF ( ordering(1:1) .EQ. 'Y' ) THEN
	    IF ( lendim1 .gt. jde-jds+1 ) THEN
	      WRITE( errmess , '(A50,9I4)') 'input_domain_mm5: size error reading Y BDY field', &
	    				     lendim1,lendim2,lendim3,ids,ide,jds,jde,kds,kde
              CALL wrf_error_fatal ( errmess )
            ENDIF
          ELSE
	    IF ( lendim1 .gt. ide-ids+1 ) THEN
	      WRITE( errmess , '(A50,9I4)') 'input_domain_mm5: size error reading X BDY field', &
	    				     lendim1,lendim2,lendim3,ids,ide,jds,jde,kds,kde
              CALL wrf_error_fatal ( errmess )
            ENDIF
          ENDIF
        ELSE
	  IF ( lendim1 .gt. ide-ids+1 .or. lendim2 .gt. jde-jds+1 ) THEN
	    WRITE( errmess , '(A50,9I4)') 'input_domain_mm5: size error reading 3D field', &
					  lendim1,lendim2,lendim3,ids,ide,jds,jde,kds,kde
            CALL wrf_error_fatal ( errmess )
	  ENDIF
        ENDIF
      ELSE IF ( ndim .EQ. 2 ) THEN
	IF ( lendim1 .gt. ide-ids+1 .or. lendim2 .gt. jde-jds+1 ) THEN
	  WRITE( errmess , '(A50,6I4)') 'input_domain_mm5: size error reading 2D field', &
					lendim1,lendim2,ids,ide,jds,jde
          CALL wrf_error_fatal ( errmess )
	ENDIF
      ENDIF

      IF ( switch .EQ. initial_only ) THEN
#include <mm5_initialin.inc>
!       start_date = current_date
      ELSE IF ( switch .EQ. restart_only ) THEN
#include <mm5_restartin.inc>
      ELSE IF ( switch .EQ. history_only ) THEN
#include <mm5_histin.inc>
      ELSE IF ( switch .EQ. boundary_only ) THEN
#include <mm5_bdyin.inc>
      ENDIF

      GO TO 10
    ELSE IF ( flag .eq. 2 ) THEN
      GO TO 100
    ELSE 
      WRITE ( wrf_err_message , * ) 'module_io_mm5: input_domain_mm5: Unrecognized flag value ',flag 
      CALL wrf_error_fatal ( TRIM ( wrf_err_message ) ) 
    ENDIF
100 CONTINUE

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhr ( 'cen_lat' , cen_lat , char_junk )
    ENDIF
    CALL wrf_dm_bcast_bytes ( cen_lat , RWORDSIZE )
    CALL set_cen_lat ( grid%id , cen_lat )
    WRITE(wrf_err_message,*)'module_io_mm5: cen_lat from bhr ',cen_lat
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhr ( 'cen_lon' , cen_lon , char_junk )
    ENDIF
    CALL wrf_dm_bcast_bytes ( cen_lon , RWORDSIZE )
    CALL set_cen_lon ( grid%id , cen_lon )
    WRITE(wrf_err_message,*)'module_io_mm5: cen_lon from bhr ',cen_lon
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhr ( 'truelat1' , truelat1 , char_junk )
    ENDIF
    CALL wrf_dm_bcast_bytes ( truelat1 , RWORDSIZE )
    CALL set_truelat1 ( grid%id , truelat1 )
    WRITE(wrf_err_message,*)'module_io_mm5: truelat1 from bhr ',truelat1
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhr ( 'truelat2' , truelat2 , char_junk )
    ENDIF
    CALL wrf_dm_bcast_bytes ( truelat2 , RWORDSIZE )
    CALL set_truelat2 ( grid%id , truelat2 )
    WRITE(wrf_err_message,*)'module_io_mm5: truelat2 from bhr ',truelat2
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhi ( 'iswater' , iswater , char_junk(1:4) )
    ENDIF
    CALL wrf_dm_bcast_string( char_junk , 4 )
    CALL wrf_dm_bcast_bytes ( iswater , IWORDSIZE )
    CALL set_iswater (grid%id, iswater )
    CALL set_mminlu ( char_junk(1:4) )

    IF ( wrf_on_monitor() ) THEN
      CALL get_bhi ( 'map_proj' , map_proj , char_junk )
    ENDIF
    CALL wrf_dm_bcast_bytes ( map_proj , IWORDSIZE )
    CALL set_map_proj (grid%id, map_proj )
    WRITE(wrf_err_message,*)'module_io_mm5: map_proj from bhr ',map_proj
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( wrf_on_monitor() .AND. switch .NE. boundary_only ) THEN
      CALL get_bhr ( 'gmt' , gmt , char_junk )
      CALL get_bhi ( 'julyr' , julyr , char_junk )
      CALL get_bhi ( 'julday' , julday , char_junk )
    ENDIF
    IF (switch .NE. boundary_only ) THEN
      CALL wrf_dm_bcast_bytes ( gmt , RWORDSIZE )
      CALL wrf_dm_bcast_bytes ( julyr , IWORDSIZE )
      CALL wrf_dm_bcast_bytes ( julday , IWORDSIZE )
      CALL set_gmt (grid%id, gmt)
      CALL set_julyr (grid%id, julyr)
      CALL set_julday (grid%id, julday)
    ENDIF

    WRITE(wrf_err_message,*)'module_io_mm5: mminlu from big header ',mminlu
    CALL wrf_debug( 200, TRIM( wrf_err_message ) )

    IF ( switch .EQ. boundary_only ) THEN
      IF ( wrf_on_monitor() ) THEN
        CALL get_bhr ( 'bdyfrq' , bdyfrq , char_junk )
      ENDIF
      CALL wrf_dm_bcast_bytes ( bdyfrq , RWORDSIZE )
      CALL set_bdyfrq (grid%id, bdyfrq)
      IF ( wrf_on_monitor() ) THEN
        CALL get_time_to_read_again ( oldtime )
        newtime = oldtime + bdyfrq
      ENDIF
      CALL wrf_dm_bcast_bytes ( newtime , RWORDSIZE )
      CALL set_time_to_read_again ( newtime )
    ENDIF

    RETURN
  END SUBROUTINE input_mm5



    SUBROUTINE write_fieldrec(                                                   &
                                  fid,                                         &
                                  ndim,                                          &
                                  inest,                                         &
                                  domdesc,                                       &
                                  buffer,                                        &
                                  aname,                                         &
                                  acurrent_date,                                 &
                                  astaggering,                                   &
                                  aordering,                                     &
                                  aunits,                                        &
                                  adescription,                                  &
                                  axtime,                                        &
                                  ids , ide , jds , jde , kds , kde ,                  &
                                  ims , ime , jms , jme , kms , kme ,                  &
                                  ips , ipe , jps , jpe , kps , kpe )
    USE module_io_mm5
      IMPLICIT NONE
#if defined (DM_PARALLEL) && defined (WRF_RSL_IO)
#  include <rsl.inc>
#endif
      INTEGER        ndim
      INTEGER        fid

      CHARACTER*(*)  aname
      CHARACTER*(*)  astaggering
      CHARACTER*(*)  aordering
      CHARACTER*(*)  acurrent_date
      CHARACTER*(*)  aunits
      CHARACTER*(*)  adescription
!      CHARACTER*9    name
!      CHARACTER*4    staggering
!      CHARACTER*4    ordering
!      CHARACTER*24   current_date
!      CHARACTER*25   units
!      CHARACTER*46   description
      CHARACTER*24   ocurrent_date

      INTEGER*1      sname         (9)
      INTEGER*1      sstaggering   (4)
      INTEGER*1      sordering     (4)
      INTEGER*1      scurrent_date (24)
      INTEGER*1      sunits        (25)
      INTEGER*1      sdescription  (46)

      INTEGER        ids , ide , jds , jde , kds , kde ,                  &
                     ims , ime , jms , jme , kms , kme ,                  &
                     ips , ipe , jps , jpe , kps , kpe

      REAL           buffer(*)
      INTEGER        inest
      INTEGER        domdesc
      REAL           axtime
      INTEGER        ir, jr, kr
      INTEGER        ix, jx, kx
      INTEGER        i,j,k,idf,jdf,kdf
!      INTEGER        sh_flag
      LOGICAL        wrf_on_monitor
      EXTERNAL       wrf_on_monitor

      IF ( ndim .EQ. 3 ) THEN
        ir =  ide - ids + 1
        ix =  ime - ims + 1
        jr =  jde - jds + 1
        jx =  jme - jms + 1
        IF ( aordering .EQ. 'XYW' .OR. aordering .EQ. 'XYL' ) THEN
          kr =  kde - kds + 1
          kx =  kme - kms + 1
        ELSE
          kr =  kde - kds
          kx =  kme - kms + 1
        ENDIF
      ELSE IF ( ndim .EQ. 2 ) THEN
        kr =  1
        kx =  1
        ir =  ide - ids + 1
        ix =  ime - ims + 1
        jr =  jde - jds + 1
        jx =  jme - jms + 1
      ELSE IF ( ndim .EQ. 1 ) THEN
        ir = 1
        ix = 1
        jr = 1
        jx = 1
        IF ( aordering .EQ. 'W' .OR. aordering .EQ. 'L' ) THEN
          kr =  kde - kds + 1
          kx =  kme - kms + 1
	ELSE
          kr =  kde - kds
          kx =  kme - kms + 1
	ENDIF
      ELSE IF ( ndim .EQ. 0 ) THEN
        ir = 1
        ix = 1
        jr = 1
        jx = 1
        kr = 1
        kx = 1
      ENDIF

      name         = '         '
      staggering   = '    '
      ordering     = '    '
      ocurrent_date = '                        '
      units        = '                         '
      description  = '                                              '
      name(1:LEN(aname))=aname
      staggering(1:LEN(astaggering))=astaggering
      ordering(1:LEN(aordering))=aordering
      ocurrent_date(1:LEN(acurrent_date))=acurrent_date
      units(1:LEN(aunits))=aunits
      description(1:LEN(adescription))=adescription
!      sh_flag=1
      CALL write_flag(fid,sh_flag)
#ifndef DM_PARALLEL
      WRITE (fid)ndim,1,1,1,1,ir,jr,kr,1,axtime,staggering,ordering, &
                   ocurrent_date,name,units,description
      IF(ndim.GE.2.AND.ndim.LE.3.AND.ordering(1:2).EQ.'XY')THEN
        WRITE (fid)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ips+ir-1),j=jps,jps+jr-1),k=kps,kps+kr-1)
      ELSE IF ( ndim .EQ. 3 .AND.ordering(3:3).EQ.'B')THEN
        WRITE (fid)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ips+ir-1),k=kps,kps+kr-1),j=jps,jps+jr-1)
      ELSE IF ( ndim .EQ. 1 ) THEN
        WRITE (fid)(buffer(k),k=kps,kps+kr-1)
      ELSE IF ( ndim .EQ. 0 ) THEN
        WRITE (fid)(buffer(1))
      ENDIF
#else
      DO i=1,9
        sname(i)=ICHAR(name(i:i))
      ENDDO
      DO i=1,4
        sstaggering(i)=ICHAR(staggering(i:i))
      ENDDO
      DO i=1,4
        sordering(i)=ICHAR(ordering(i:i))
      ENDDO
      DO i=1,24
        scurrent_date(i)=ICHAR(ocurrent_date(i:i))
      ENDDO
      DO i=1,25
        sunits(i)=ICHAR(units(i:i))
      ENDDO
      DO i=1,46
        sdescription(i)=ICHAR(description(i:i))
      ENDDO
      CALL rsl_write_mm5v3_sm_header(fid,ndim,1,1,1,1,ir,jr,kr,1, &
           IWORDSIZE,axtime,RWORDSIZE,sstaggering,4,sordering,4,   &
           scurrent_date,24,sname,9,sunits,25,sdescription,46)
      IF      ( ndim .GE. 2 .AND. ndim .LE. 3 .AND. ordering(1:2) .EQ. 'XY' )THEN
        CALL dm_dist_write(fid,domdesc,buffer,ndim,ir,jr,kr,ix,jx,kx)
      ELSE IF ( ndim .EQ. 3 .AND.ordering(3:3).EQ.'B')THEN

! WARNING: The following will require that the process that generates the boundary
! conditions be single processor.  JM 20000630

        IF ( wrf_on_monitor() ) THEN
          WRITE (fid)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ips+ir-1),k=kps,kps+kr-1),j=jps,jps+jr-1)
        ENDIF
      ELSE IF ( ndim .EQ. 1 ) THEN
        CALL rsl_write_1d_data(fid,buffer,ir*jr*kr,RSL_REAL)
      ELSE IF ( ndim .EQ. 0 ) THEN
        IF ( wrf_on_monitor() ) write ( fid ) buffer(1)
      ENDIF
#endif
      RETURN
  END SUBROUTINE write_fieldrec

  SUBROUTINE mm5_input_rec ( fid ,  &
                             domdesc , &
                             buffer  , &
                             ndim , &
                             aordering , &
                             aname , &
                             ids , ide , jds , jde , kds , kde , &
                             ims , ime , jms , jme , kms , kme , &
                             ips , ipe , jps , jpe , kps , kpe )

    USE module_io_mm5
    IMPLICIT NONE
    INTEGER fid
    INTEGER domdesc
    CHARACTER*(*)  aordering
    CHARACTER*(*)  aname
    INTEGER ids , ide , jds , jde , kds , kde , &
            ims , ime , jms , jme , kms , kme , &
            ips , ipe , jps , jpe , kps , kpe
!    REAL buffer( ims:ime , kms:kme , jms:jme )
    REAL buffer( * )
    INTEGER ndim
    INTEGER i , j , k , kdf
    INTEGER ix, jx, kx
    INTEGER lendim1, lendim2, lendim3
    CHARACTER*256 errmess
    LOGICAL wrf_on_monitor
    EXTERNAL wrf_on_monitor

    kdf = kde-1
    IF ( aordering .EQ. 'XYW' .OR. aordering .EQ. 'XYW' ) THEN
       kdf = kde
    ENDIF
    IF ( ndim .EQ. 3 ) THEN
      ix =  ime - ims + 1
      jx =  jme - jms + 1
      kx =  kme - kms + 1
    ELSE IF ( ndim .EQ. 2 ) THEN
      kx =  1
      ix =  ime - ims + 1
      jx =  jme - jms + 1
    ELSE IF ( ndim .EQ. 1 ) THEN
      ix = 1
      jx = 1
      kx =  kme - kms + 1
    ELSE IF ( ndim .EQ. 0 ) THEN
      ix = 1
      jx = 1
      kx = 1
    ENDIF
    do i = 1,ix*jx*kx
      buffer(i) = 0.
    enddo

#ifndef DM_PARALLEL
    IF      (ndim.GE.2.AND.ndim.LE.3.AND.aordering(1:2).EQ.'XY')THEN
      READ(fid,ERR=9004)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ipe),j=jps,jpe),k=kps,kpe)
    ELSE IF ( ndim .eq. 3 .and. aordering(3:3) .eq. 'B' ) THEN
      READ(fid,ERR=9004)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ipe),k=kps,kpe),j=jps,jpe)
    ELSE IF ( ndim .eq. 1 ) THEN
      READ(fid,ERR=9004)(buffer(k),k=kps,kpe)
    ELSE IF ( ndim .eq. 0 ) THEN
      READ(fid,ERR=9004)buffer(1)
    ENDIF
#else             
    IF      ( ndim .eq. 3 .and. aordering(3:3) .eq. 'B' ) THEN
      IF ( wrf_on_monitor() ) THEN
        READ(fid,ERR=9004)(((buffer((i-ims+1)+(k-kms)*ix+(j-jms)*ix*kx),i=ips,ipe),k=kps,kpe),j=jps,jpe)
      ENDIF
      lendim1 = ipe-ips+1
      lendim2 = jpe-jps+1
      lendim3 = kpe-kps+1
!      CALL wrf_dm_bcast_bytes ( buffer ,  lendim1*lendim2*lendim3*RWORDSIZE )
      CALL wrf_dm_bcast_bytes ( buffer ,  ix*jx*kx*RWORDSIZE )
    ELSE IF ( ndim .ge. 2 ) THEN
      lendim1 = ipe-ips+1
      lendim2 = jpe-jps+1
      lendim3 = kpe-kps+1

      WRITE(errmess,*)'module_io_mm5: mm5_input_rec: calling dm_dist_read ',lendim1,lendim2,lendim3,ix,jx,kx
      CALL wrf_debug( 500, TRIM(errmess) )
      CALL dm_dist_read(fid,domdesc,buffer,ndim,   &
                        lendim1,lendim2,lendim3,  &
                        ix, jx, kx )
      CALL wrf_debug( 500, 'module_io_mm5: mm5_input_rec: back from dm_dist_read' )

    ELSE IF ( ndim .eq. 1 ) THEN
      lendim3 = kpe-kps+1
      IF ( wrf_on_monitor() ) READ(fid,ERR=9004)buffer(1:lendim3) 
      CALL wrf_dm_bcast_bytes ( buffer , (kme-kms+1)*RWORDSIZE )
    ELSE IF ( ndim .eq. 0 ) THEN
      IF ( wrf_on_monitor() ) READ(fid,ERR=9004)buffer(1) 
      CALL wrf_dm_bcast_bytes ( buffer , 1*RWORDSIZE )
    ENDIF
#endif
    RETURN
9004 CONTINUE
    WRITE( errmess , '(A34,I4)' ) 'mm5_input_rec: error reading unit ',fid
    CALL wrf_error_fatal(errmess)
  END SUBROUTINE mm5_input_rec

  LOGICAL FUNCTION lbc_read_time ( xtime )
    IMPLICIT NONE
    REAL, INTENT(IN) :: xtime
    INTEGER time_to_read_again, last_time
    COMMON /lbc_timekeeping/ time_to_read_again, last_time
    IF ( xtime .LT. time_to_read_again ) THEN
      lbc_read_time = .false.
    ELSE
      lbc_read_time = .true.
    ENDIF
    RETURN
  END FUNCTION lbc_read_time

  SUBROUTINE set_time_to_read_again ( newtime )
    IMPLICIT NONE
    REAL, INTENT(IN) :: newtime
    INTEGER time_to_read_again, last_time
    COMMON /lbc_timekeeping/ time_to_read_again, last_time
    time_to_read_again = newtime
    RETURN
  END SUBROUTINE set_time_to_read_again

  SUBROUTINE get_time_to_read_again ( newtime )
    IMPLICIT NONE
    REAL, INTENT(OUT) :: newtime
    INTEGER time_to_read_again, last_time
    COMMON /lbc_timekeeping/ time_to_read_again, last_time
    newtime = time_to_read_again
    RETURN
  END SUBROUTINE get_time_to_read_again

  SUBROUTINE set_last_time ( newtime )
    IMPLICIT NONE
    REAL, INTENT(IN) :: newtime
    INTEGER time_to_read_again, last_time
    COMMON /lbc_timekeeping/ time_to_read_again, last_time
    last_time = newtime
    RETURN
  END SUBROUTINE set_last_time

  SUBROUTINE get_last_time ( newtime )
    IMPLICIT NONE
    REAL, INTENT(OUT) :: newtime
    INTEGER time_to_read_again, last_time
    COMMON /lbc_timekeeping/ time_to_read_again, last_time
    newtime = last_time
    RETURN
  END SUBROUTINE get_last_time


   SUBROUTINE get_bhr (string, value, value_char)
    USE module_io_mm5
   IMPLICIT NONE
! Arguments
   CHARACTER*(*), INTENT(IN   ) :: string
   CHARACTER*(*), INTENT(OUT  ) :: value_char
   REAL,          INTENT(OUT  ) :: value
! Local and other
   LOGICAL :: init_string = .true.

!  INTEGER, PARAMETER :: numint=50 , numreal=20 , numprogs=20 
!  REAL, DIMENSION(numreal , numprogs ) :: bhr

! Local
   REAL :: error_value = -99999.
   INTEGER :: index, i
!--------------------------------------------------------------------------------   
   IF(init_string)THEN

     DO i = 1, numstring
        meta_string_r(i) = '                                '
     ENDDO
     i=0
     i = i+1 ; meta_string_r(i)(1:8) = 'cen_lat ' ; a_r(i) = 2   ; b_r(i) = 1  
     i = i+1 ; meta_string_r(i)(1:8) = 'cen_lon ' ; a_r(i) = 3   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'conefact' ; a_r(i) = 4   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'truelat1' ; a_r(i) = 5   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'truelat2' ; a_r(i) = 6   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'bdyfrq  ' ; a_r(i) = 1   ; b_r(i) = 7 
     i = i+1 ; meta_string_r(i)(1:8) = 'gmt     ' ; a_r(i) = 6   ; b_r(i) = 5 
 
     init_string = .false.
   ENDIF
   
!--------------------------------------------------------------------------------   
   index = 0
   DO i = 1, numstring
     IF(trim(string) == trim(meta_string_r(i)))index = i
   ENDDO

   IF(index == 0)THEN
     value = error_value
   ELSE
     value      = bhr( a_r(index), b_r(index) )
     value_char = bhrc( a_r(index), b_r(index) )
!    print *,'get ',string,a_r(index), b_r(index),value
   ENDIF
   
   END SUBROUTINE get_bhr
 
   SUBROUTINE get_bhi (string, value, value_char)
    USE module_io_mm5
   IMPLICIT NONE
! Arguments
   CHARACTER*(*), INTENT(IN   ) :: string
   CHARACTER*(*), INTENT(OUT  ) :: value_char
   INTEGER,       INTENT(OUT  ) :: value
! Local and other
   LOGICAL :: init_string = .true.

!  INTEGER, PARAMETER :: numint=50 , numreal=20 , numprogs=20 
!  REAL, DIMENSION(numint , numprogs ) :: bhi

! Local
   REAL :: error_value = -99999.
   INTEGER :: index, i
!--------------------------------------------------------------------------------   
   IF(init_string)THEN

     DO i = 1, numstring
        meta_string_i(i) = '                                '
     ENDDO
     i=0
     i = i+1 ; meta_string_i(i)(1:8) = 'map_proj' ; a_i(i) =  7  ; b_i(i) = 1  
     i = i+1 ; meta_string_i(i)(1:8) = 'iswater ' ; a_i(i) = 23  ; b_i(i) = 1  
     i = i+1 ; meta_string_i(i)(1:8) = 'julyr   ' ; a_i(i) =  5  ; b_i(i) = 5  
     i = i+1 ; meta_string_i(i)(1:8) = 'julday  ' ; a_i(i) = 13  ; b_i(i) = 5  
 
     init_string = .false.
   ENDIF
   
!--------------------------------------------------------------------------------   
   index = 0
   DO i = 1, numstring
     IF(trim(string) == trim(meta_string_i(i)))index = i
   ENDDO

   IF(index == 0)THEN
     value = error_value
   ELSE
     value      = bhi( a_i(index), b_i(index) )
     value_char = bhic( a_i(index), b_i(index) )
!    print *,'get ',string,a_i(index), b_i(index),value,':',value_char,':'
   ENDIF
   
   END SUBROUTINE get_bhi

   SUBROUTINE set_bhr (string, value, value_char)
    USE module_io_mm5
   IMPLICIT NONE
! Arguments
   CHARACTER*(*), INTENT(IN   ) :: string
   CHARACTER*(*), INTENT(IN   ) :: value_char
   REAL,          INTENT(IN   ) :: value
! Local and other
   LOGICAL :: init_string = .true.

!  INTEGER, PARAMETER :: numint=50 , numreal=20 , numprogs=20 
!  REAL, DIMENSION(numreal , numprogs ) :: bhr

! Local
   REAL :: error_value = -99999.
   INTEGER :: index, i
!--------------------------------------------------------------------------------   
   IF(init_string)THEN

     DO i = 1, numstring
        meta_string_r(i) = '                                '
     ENDDO
     i=0
     i = i+1 ; meta_string_r(i)(1:8) = 'cen_lat ' ; a_r(i) = 2   ; b_r(i) = 1  
     i = i+1 ; meta_string_r(i)(1:8) = 'cen_lon ' ; a_r(i) = 3   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'conefact' ; a_r(i) = 4   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'truelat1' ; a_r(i) = 5   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'truelat2' ; a_r(i) = 6   ; b_r(i) = 1 
     i = i+1 ; meta_string_r(i)(1:8) = 'bdyfrq  ' ; a_r(i) = 1   ; b_r(i) = 7 
     i = i+1 ; meta_string_r(i)(1:8) = 'gmt     ' ; a_r(i) = 6   ; b_r(i) = 5 
 
     init_string = .false.
   ENDIF
   
!--------------------------------------------------------------------------------   
   index = 0
   DO i = 1, numstring
     IF(trim(string) == trim(meta_string_r(i)))index = i
   ENDDO

   IF(index == 0)THEN
     print *,'set_bhr: string=',trim(string),' not recognized'
   ELSE
!    print *,'set ',string,a_r(index), b_r(index),value
     bhr( a_r(index), b_r(index) ) = value
     bhrc( a_r(index), b_r(index) ) = value_char
   ENDIF
   
   END SUBROUTINE set_bhr
 
   SUBROUTINE set_bhi (string, value, value_char)
    USE module_io_mm5
   IMPLICIT NONE
! Arguments
   CHARACTER*(*), INTENT(IN  ) :: string
   CHARACTER*(*), INTENT(IN  ) :: value_char
   INTEGER,       INTENT(IN  ) :: value
! Local and other
   LOGICAL :: init_string = .true.

!  INTEGER, PARAMETER :: numint=50 , numreal=20 , numprogs=20 
!  REAL, DIMENSION(numint , numprogs ) :: bhi

! Local
   REAL :: error_value = -99999.
   INTEGER :: index, i
!--------------------------------------------------------------------------------   
   IF(init_string)THEN

     DO i = 1, numstring
        meta_string_i(i) = '                                '
     ENDDO
     i=0
     i = i+1 ; meta_string_i(i)(1:8) = 'map_proj' ; a_i(i) =  7  ; b_i(i) = 1  
     i = i+1 ; meta_string_i(i)(1:8) = 'iswater ' ; a_i(i) = 23  ; b_i(i) = 1  
     i = i+1 ; meta_string_i(i)(1:8) = 'julyr   ' ; a_i(i) =  5  ; b_i(i) = 5  
     i = i+1 ; meta_string_i(i)(1:8) = 'julday  ' ; a_i(i) = 13  ; b_i(i) = 5  
 
     init_string = .false.
   ENDIF
   
!--------------------------------------------------------------------------------   
   index = 0
   DO i = 1, numstring
     IF(trim(string) == trim(meta_string_i(i)))index = i
   ENDDO

   IF(index == 0)THEN
     print *,'set_bhi: string=',trim(string),' not recognized'
   ELSE
!    print *,'set ',string,a_i(index), b_i(index),value,':',value_char,':'
     bhi( a_i(index), b_i(index) ) = value
     bhic( a_i(index), b_i(index) ) = value_char
   ENDIF
   
   END SUBROUTINE set_bhi

#if defined(DM_PARALLEL) && defined(WRF_RSL_IO)
    SUBROUTINE dm_dist_write(fid,domdesc,buf,ndim,il,jl,kl,ix,jx,kx)
      USE module_io_mm5
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER fid,domdesc,ndim,il,jl,kl,ix,jx,kx,glen(3),llen(3)
       REAL buf(*)
       REAL temp(ix,jx,kx)
       INTEGER i, j, k
       glen(1) = il
       glen(2) = jl
       glen(3) = kl
       llen(1) = ix
       llen(2) = jx
       llen(3) = kl
       IF ( ndim .EQ. 3 ) THEN
         ! transpose
	 DO k = 1,kx
	 DO j = 1,jx
	 DO i = 1,ix
	   temp(i,j,k) = buf(i+(k-1)*ix+(j-1)*ix*kx)
	 ENDDO
	 ENDDO
	 ENDDO
         CALL rsl_write(fid,   &
           io3d_ijk,temp,domdesc,rsl_real,glen,llen)
       ELSE
         CALL RSL_WRITE(fid,   &
           io2d_ij, buf,domdesc,rsl_real,glen,llen)
       ENDIF
       RETURN
    END SUBROUTINE dm_dist_write

    SUBROUTINE dm_dist_read(fid,domdesc,buf,ndim,il,jl,kl,ix,jx,kx)
      USE module_io_mm5
       IMPLICIT NONE
#include <rsl.inc>
       INTEGER fid,domdesc,ndim,il,jl,kl,ix,jx,kx,glen(3),llen(3)
       REAL buf(*)
       REAL temp(ix,jx,kx)
       INTEGER i,j,k
       glen(1) = il
       glen(2) = jl
       glen(3) = kl
       llen(1) = ix
       llen(2) = jx
       llen(3) = kl
       IF ( ndim .EQ. 3 ) THEN
         temp = 0.
         CALL rsl_read(fid,          &
           io3d_ijk,temp,domdesc,rsl_real,glen,llen)
         ! transpose
	 DO k = 1,kx
	 DO j = 1,jx
	 DO i = 1,ix
	   buf(i+(k-1)*ix+(j-1)*ix*kx) = temp(i,j,k)
	 ENDDO
	 ENDDO
	 ENDDO
       ELSE
         CALL rsl_read(fid,          &
           io2d_ij, buf,domdesc,rsl_real,glen,llen)
       ENDIF
       RETURN
    END SUBROUTINE DM_DIST_READ
#endif
