!WRF:PACKAGE:IO
!

MODULE module_io_wrf

  USE module_wrf_error
  USE module_date_time

! switch parameters
  INTEGER, PARAMETER :: initial_only=1, boundary_only=2, restart_only=3, history_only=4

  REAL , POINTER      ::   gbuf_real( : ) 
  INTEGER , POINTER   ::   gbuf_integer( : ) 
  INTEGER gbuf_real_size
  INTEGER gbuf_integer_size

CONTAINS
  SUBROUTINE init_module_io_wrf
    ALLOCATE(gbuf_real(1))
    ALLOCATE(gbuf_integer(1))
    gbuf_real_size = 1
    gbuf_integer_size = 1
  END SUBROUTINE init_module_io_wrf

END MODULE module_io_wrf

!#undef NETCDF
#ifndef NETCDF
#  define WRF_REAL 1
#  define WRF_INTEGER 1
 SUBROUTINE ext_read_field( DataHandle, DateStr, VarName, Field, FieldType, Comm,&
  DomainDesc, MemoryOrder,&
  DomainStart, DomainEnd, MemoryStart, MemoryEnd, PatchStart, PatchEnd, Status)
   USE module_wrf_error
   INTEGER, INTENT(IN):: DataHandle
   CHARACTER(LEN=*), INTENT(IN) :: DateStr
   CHARACTER(LEN=*), INTENT(IN) :: VarName
   INTEGER              :: Field ! (Using an implicit interface)
   INTEGER, INTENT(IN)  :: FieldType
   INTEGER                :: Comm
   INTEGER, INTENT(IN)    :: DomainDesc
   CHARACTER(LEN=*),     INTENT(IN) :: MemoryOrder
   INTEGER, DIMENSION(3), INTENT(IN) :: DomainStart, DomainEnd
   INTEGER, DIMENSION(3), INTENT(IN) :: MemoryStart, MemoryEnd
   INTEGER, DIMENSION(3), INTENT(IN) :: PatchStart, PatchEnd
   INTEGER              :: Status
   CHARACTER(LEN=256)               :: message
   WRITE(message,*)'ext_read_field on ',VarName,' for ',DateStr,' ',MemoryOrder
   CALL wrf_message ( TRIM(message) )
   Status = 0 
 END SUBROUTINE ext_read_field
 SUBROUTINE ext_write_field( DataHandle, DateStr, VarName, Field, FieldType, Comm,&
  DomainDesc, MemoryOrder,&
  DomainStart, DomainEnd, MemoryStart, MemoryEnd, PatchStart, PatchEnd, Status)
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER, INTENT(IN):: DataHandle
   CHARACTER(LEN=*), INTENT(IN) :: DateStr
   CHARACTER(LEN=*), INTENT(IN) :: VarName
   INTEGER, INTENT(IN) :: Field ! (Using an implicit interface)
   INTEGER, INTENT(IN) :: FieldType
   INTEGER                :: Comm
   INTEGER, INTENT(IN)    :: DomainDesc
   CHARACTER(LEN=*),     INTENT(IN) :: MemoryOrder
   INTEGER, INTENT(IN), DIMENSION(3) :: DomainStart, DomainEnd
   INTEGER, INTENT(IN), DIMENSION(3) :: MemoryStart, MemoryEnd
   INTEGER, INTENT(IN), DIMENSION(3) :: PatchStart, PatchEnd
   INTEGER              :: Status
   CHARACTER(LEN=256)               :: message
   WRITE(message,*)'ext_write_field on ',VarName,' for ',DateStr,' ',MemoryOrder
   CALL wrf_message ( TRIM(message) )
   Status = 0
   RETURN
 END SUBROUTINE ext_write_field
 SUBROUTINE ext_open_for_read(FileName,Comm,SysDepInfo,DataHandle,Status )
   USE module_wrf_error
   IMPLICIT NONE
   CHARACTER (*) ,INTENT (IN)  :: FileName
   INTEGER       ,INTENT (IN)  :: Comm
   CHARACTER (*) ,INTENT (IN)  :: SysDepInfo
   INTEGER                     :: DataHandle
   INTEGER                     :: Status
   CHARACTER(LEN=256)               :: message
   CALL WRF_MESSAGE ( "ext_open_field_for_read stubbed" )
   CALL WRF_MESSAGE ( FileName )
   WRITE(message,'(" ext_open_dataset_for_read ",A32)')TRIM(Filename)
   CALL WRF_MESSAGE ( TRIM(message) )
   Status = 0
 END SUBROUTINE ext_open_for_read
 SUBROUTINE ext_open_for_write(FileName,Comm,SysDepInfo,DataHandle,Status )
   USE module_wrf_error
   IMPLICIT NONE
   CHARACTER (*) ,INTENT (IN)  :: FileName
   INTEGER       ,INTENT (IN)  :: Comm
   CHARACTER (*) ,INTENT (IN)  :: SysDepInfo
   INTEGER                     :: DataHandle
   INTEGER                     :: Status
   CHARACTER*256               :: message
   WRITE(message,'(" ext_open_for_write ",A32)')TRIM(Filename)
   CALL WRF_MESSAGE ( message )
   Status = 0
 END SUBROUTINE ext_open_for_write
 SUBROUTINE ext_open_for_write_commit(DataHandle,Status)
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER, INTENT(IN)  :: DataHandle
   INTEGER              :: Status
   CHARACTER*256               :: message
   CALL WRF_MESSAGE ( "ext_open_for_write_commit stubbed" )
   Status = 0
 END SUBROUTINE ext_open_for_write_commit
 SUBROUTINE ext_close( DataHandle, Status )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER, INTENT(IN)  :: DataHandle
   INTEGER              :: Status
   CALL WRF_MESSAGE ( "ext_close stubbed" )
   Status = 0
 END SUBROUTINE ext_close
 SUBROUTINE ext_inquire_opened( FileName , FileStatus, Status  )
   USE module_wrf_error
   IMPLICIT NONE
   CHARACTER (*)        ,INTENT(IN)      :: FileName
   INTEGER                               :: FileStatus
   INTEGER                               :: Status
   CALL WRF_MESSAGE ( "ext_inquire_opened stubbed" )
 END SUBROUTINE ext_inquire_opened

 SUBROUTINE ext_put_glb_md_char ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   CHARACTER (LEN=*) , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_glb_md_char ',TRIM(key),TRIM(value)
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_glb_md_char
 SUBROUTINE ext_put_glb_md_integer ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   INTEGER           , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_glb_md_integer ',TRIM(key),value
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_glb_md_integer
 SUBROUTINE ext_put_glb_md_real ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   REAL              , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_glb_md_integer ',TRIM(key),value
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_glb_md_real

 SUBROUTINE ext_put_dom_md_char ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   CHARACTER (LEN=*) , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_dom_md_char ',TRIM(key),TRIM(value)
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_dom_md_char

 SUBROUTINE ext_put_dom_md_integer ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   INTEGER           , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_dom_md_integer ',TRIM(key),value
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_dom_md_integer
 SUBROUTINE ext_put_dom_md_real ( fid , key , value , ierr )
   USE module_wrf_error
   IMPLICIT NONE
   INTEGER , INTENT(IN) :: fid
   CHARACTER (LEN=*) , INTENT(IN) :: key
   REAL              , INTENT(IN) :: value
   INTEGER , INTENT(IN) :: ierr
   CHARACTER*256               :: message
   WRITE(message,*)'ext_put_dom_md_integer ',TRIM(key),value
   CALL wrf_message ( TRIM(message) )
   RETURN
 END SUBROUTINE ext_put_dom_md_real

 SUBROUTINE ext_init
 END SUBROUTINE ext_init
 
 SUBROUTINE ext_open_for_write_begin
 END SUBROUTINE ext_open_for_write_begin

 SUBROUTINE input_boundary_wrf
 END SUBROUTINE input_boundary_wrf

 SUBROUTINE input_initial_wrf
 END SUBROUTINE input_initial_wrf

 SUBROUTINE input_restart_wrf
 END SUBROUTINE input_restart_wrf

 SUBROUTINE input_history_wrf
 END SUBROUTINE input_history_wrf

 SUBROUTINE output_boundary_wrf
 END SUBROUTINE output_boundary_wrf

 SUBROUTINE output_initial_wrf
 END SUBROUTINE output_initial_wrf

 SUBROUTINE output_restart_wrf
 END SUBROUTINE output_restart_wrf

 SUBROUTINE output_history_wrf
 END SUBROUTINE output_history_wrf

#else


  SUBROUTINE output_initial_wrf ( fid , grid , config_flags , ierr )
    USE module_io_wrf
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid 
    INTEGER, INTENT(INOUT) :: ierr
    CALL output_wrf ( fid , grid , config_flags , initial_only , ierr )
    RETURN
  END SUBROUTINE output_initial_wrf

  SUBROUTINE output_restart_wrf ( fid , grid , config_flags , ierr )
    USE module_io_wrf
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr 
    CALL output_wrf ( fid , grid , config_flags , restart_only , ierr )
    RETURN
  END SUBROUTINE output_restart_wrf

  SUBROUTINE output_history_wrf ( fid , grid , config_flags , ierr )
    USE module_io_wrf
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr
    CALL output_wrf ( fid , grid , config_flags , history_only , ierr )
    RETURN
  END SUBROUTINE output_history_wrf

  SUBROUTINE output_boundary_wrf ( fid , grid , config_flags , ierr )
    USE module_io_wrf
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid 
    INTEGER, INTENT(INOUT) :: ierr
    CALL output_wrf ( fid , grid , config_flags , boundary_only , ierr )
    RETURN
  END SUBROUTINE output_boundary_wrf

  SUBROUTINE output_wrf ( fid , grid , config_flags, switch , ierr )
    USE module_domain
    USE module_io_wrf
    USE module_configure
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid, switch
    INTEGER, INTENT(INOUT) :: ierr
    LOGICAL, EXTERNAL :: wrf_on_monitor
    INTEGER rsize , isize
# if defined(DM_PARALLEL) && ! defined (DM_DISTRIB_IO)
    isize =  (grid%ed31-grid%sd31+1) * (grid%ed33-grid%sd33+1)
    rsize =  (grid%ed32-grid%sd32+1) * isize
    IF ( rsize > gbuf_real_size .AND. wrf_on_monitor() ) THEN
      IF ( .NOT. ASSOCIATED ( gbuf_real ) ) THEN
        ALLOCATE ( gbuf_real ( rsize ) )
      ELSE
        DEALLOCATE ( gbuf_real )
        ALLOCATE ( gbuf_real ( rsize ) )
      ENDIF
    ENDIF
    IF ( isize > gbuf_integer_size .AND. wrf_on_monitor() ) THEN
      IF ( .NOT. ASSOCIATED ( gbuf_integer ) ) THEN
        ALLOCATE ( gbuf_integer ( isize ) )
      ELSE
        DEALLOCATE ( gbuf_integer )
        ALLOCATE ( gbuf_integer ( isize ) )
      ENDIF
    ENDIF
#endif
    CALL output_wrf1 ( fid , grid , config_flags , switch , gbuf_real , gbuf_integer ,ierr )
  END SUBROUTINE output_wrf

  SUBROUTINE output_wrf1 ( fid , grid , config_flags, switch , globbuf_real , globbuf_integer , ierr )
    USE module_wrf_error
    USE module_io_wrf
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_date_time
    IMPLICIT NONE
#include <wrf_io_flags.h>
#include <wrf_status_codes.h>
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid, switch
    INTEGER, INTENT(INOUT) :: ierr

    ! Local data
    INTEGER ids , ide , jds , jde , kds , kde , &
            ims , ime , jms , jme , kms , kme , &
            ips , ipe , jps , jpe , kps , kpe
#if 0
# if defined(DM_PARALLEL) && ! defined (DM_DISTRIB_IO)
     REAL          globbuf_real((grid%ed31-grid%sd31+1)*&
                                (grid%ed33-grid%sd33+1)*&
                                (grid%ed32-grid%sd32+1)*2)
     INTEGER       globbuf_integer((grid%ed31-grid%sd31+1)*&
                                   (grid%ed33-grid%sd33+1)*2)
# endif
#else
    REAL            globbuf_real( * ) 
    INTEGER         globbuf_integer( * ) 
#endif
      
    INTEGER , DIMENSION(3) :: domain_start , domain_end
    INTEGER , DIMENSION(3) :: memory_start , memory_end
    INTEGER , DIMENSION(3) :: patch_start , patch_end
    INTEGER i,j
    INTEGER ny , nm , nd , nh , ni , ns , nt
    INTEGER julyr, julday, idt, iswater , map_proj
    INTEGER filestate
    LOGICAL dryrun
    REAL    gmt, cen_lat, cen_lon, bdyfrq , truelat1 , truelat2
    CHARACTER*256 message
    CHARACTER*80  fname
    CHARACTER*80  char_junk

    LOGICAL , EXTERNAL :: wrf_on_monitor

!  integer, parameter  :: WRF_FILE_NOT_OPENED                  = 100
!  integer, parameter  :: WRF_FILE_OPENED_NOT_COMMITTED        = 101
!  integer, parameter  :: WRF_FILE_OPENED_AND_COMMITTED        = 102


    IF ( wrf_on_monitor() ) THEN
      CALL ext_inquire_filename ( fid , fname , filestate , ierr )
      IF ( ierr /= 0 ) THEN
        WRITE(wrf_err_message,*)'module_io_wrf: output_wrf: ext_inquire_filename Status = ',ierr
        CALL wrf_error_fatal( wrf_err_message )
      ENDIF
      dryrun = ( filestate /= WRF_FILE_OPENED_AND_COMMITTED )
    ELSE
      dryrun = .false.   ! this code should never be called on another node if dryrun is true
    ENDIF
    WRITE(wrf_err_message,*)'output_wrf: dryrun = ',dryrun
    CALL wrf_debug( 500 , wrf_err_message )


    ids             = grid%sd31 
    ide             = grid%ed31 
    jds             = grid%sd33 
    jde             = grid%ed33 
    kds             = grid%sd32 
    kde             = grid%ed32 
    ims             = grid%sm31 
    ime             = grid%em31 
    jms             = grid%sm33 
    jme             = grid%em33 
    kms             = grid%sm32 
    kme             = grid%em32 
    ips             = grid%sp31 
    ipe             = grid%ep31 
    jps             = grid%sp33 
    jpe             = grid%ep33 
    kps             = grid%sp32 
    kpe             = grid%ep32 

! julday and gmt can be set in namelist_03 for ideal.exe run
      CALL get_gmt (grid%id, gmt)
      CALL get_julyr (grid%id, julyr)
      CALL get_julday (grid%id, julday)
      CALL get_mminlu ( char_junk(1:4) )
      CALL get_iswater (grid%id, iswater )
      CALL get_cen_lat ( grid%id , cen_lat )
      CALL get_cen_lon ( grid%id , cen_lon )
      IF ( switch .EQ. boundary_only ) THEN
        CALL get_bdyfrq ( grid%id , bdyfrq )
      ENDIF
      CALL get_truelat1 ( grid%id , truelat1 )
      CALL get_truelat2 ( grid%id , truelat2 )
      CALL get_map_proj ( grid%id , map_proj )

    WRITE ( wrf_err_message , * ) 'module_io_wrf: output_wrf: current_date=',current_date
    CALL wrf_debug ( 100 , wrf_err_message )
    IF ( grid%write_metadata .AND. wrf_on_monitor() ) THEN

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_char title' )
      WRITE( message , * ) "OUTPUT FROM " , TRIM(program_name)
      CALL ext_put_glb_md_char ( fid , 'TITLE' , TRIM(message) , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_char start date ' )
      CALL ext_put_glb_md_char ( fid , 'START_DATE', TRIM(start_date) , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_char  start date' )
      CALL ext_put_glb_md_char ( fid , 'START_DATE', TRIM(start_date) , TRIM(start_date) , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer WEST-EAST GRID DIMENSION ' )
      CALL ext_put_glb_md_integer ( fid , 'WEST-EAST_GRID_DIMENSION' ,  &
                     config_flags%e_we - config_flags%s_we + 1 , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer SOUTH-NORTH GRID DIMENSION ' )
      CALL ext_put_glb_md_integer ( fid , 'SOUTH-NORTH_GRID_DIMENSION' , &
                     config_flags%e_sn - config_flags%s_sn + 1 , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer BOTTOM-TOP GRID DIMENSION ' )
      CALL ext_put_glb_md_integer ( fid , 'BOTTOM-TOP_GRID_DIMENSION' , &
                     config_flags%e_vert - config_flags%s_vert , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer map_proj ' )
      CALL ext_put_glb_md_integer ( fid , 'MAP_PROJ' , config_flags%map_proj , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real DX ' )
      CALL ext_put_glb_md_real ( fid , 'DX' ,  config_flags%dx , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real DY ' )
      CALL ext_put_glb_md_real ( fid , 'DY' ,  config_flags%dy , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real DT ' )
      CALL ext_put_glb_md_real ( fid , 'DT' ,  config_flags%dt , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real cen_lat ' )
      CALL ext_put_glb_md_real ( fid , 'CEN_LAT' ,  config_flags%cen_lat , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real cen_lon ' )
      CALL ext_put_glb_md_real ( fid , 'CEN_LON' ,  config_flags%cen_lon , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real truelat1' )
      CALL ext_put_glb_md_real ( fid , 'TRUELAT1',  config_flags%truelat1, 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real truelat2' )
      CALL ext_put_glb_md_real ( fid , 'TRUELAT2',  config_flags%truelat2, 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real gmt ' )
      CALL ext_put_glb_md_real ( fid , 'GMT' ,  config_flags%gmt , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer julyr ' )
      CALL ext_put_glb_md_integer ( fid , 'JULYR' ,  config_flags%julyr , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer julday ' )
      CALL ext_put_glb_md_integer ( fid , 'JULDAY' ,  config_flags%julday , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_integer iswater ' )
      CALL ext_put_glb_md_integer ( fid , 'ISWATER' ,  config_flags%iswater , 1 , ierr )

      CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_char mminlu ' )
      CALL ext_put_glb_md_char ( fid , 'MMINLU',  mminlu(1:4) , ierr )

      IF ( switch .EQ. boundary_only ) THEN
        CALL wrf_debug ( 300 , 'output_wrf: calling ext_put_glb_md_real bdyfrq ' )
        CALL ext_put_glb_md_real ( fid , 'BDYFRQ' ,  config_flags%bdyfrq , 1 , ierr )
      ENDIF

      CALL split_date_char ( start_date , ny , nm , nd , nh , ni , ns , nt )

    ENDIF

    IF ( .NOT. dryrun .OR. ( dryrun .AND. wrf_on_monitor() ) ) THEN
      IF ( switch .EQ. initial_only ) THEN
        CALL wrf_debug ( 300 , 'output_wrf: calling code in wrf_initialout.inc' )
! generated by the registry
#include <wrf_initialout.inc>
      ELSE IF ( switch .EQ. restart_only ) THEN
        CALL wrf_debug ( 300 , 'output_wrf: calling code in wrf_restartout.inc' )
! generated by the registry
#include <wrf_restartout.inc>
      ELSE IF ( switch .EQ. history_only ) THEN
        CALL wrf_debug ( 300 , 'output_wrf: calling code in wrf_histout.inc' )
! generated by the registry
#include <wrf_histout.inc>
      ELSE IF ( switch .EQ. boundary_only ) THEN
        CALL wrf_debug ( 300 , 'output_wrf: calling code in wrf_bdyout.inc' )
! generated by the registry
#include <wrf_bdyout.inc>
      ENDIF
    ENDIF

    CALL wrf_debug ( 300 , 'output_wrf: returning from ' )
    RETURN
  END SUBROUTINE output_wrf1

#if 1

  SUBROUTINE input_initial_wrf ( fid , grid , config_flags , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr
    CALL input_wrf ( fid , grid , config_flags , initial_only , ierr )
    RETURN
  END SUBROUTINE input_initial_wrf

  SUBROUTINE input_restart_wrf ( fid , grid , config_flags , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr
    CALL input_wrf ( fid , grid , config_flags , restart_only , ierr )
    RETURN
  END SUBROUTINE input_restart_wrf

  SUBROUTINE input_history_wrf ( fid , grid , config_flags , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr
    CALL input_wrf ( fid , grid , config_flags , history_only , ierr )
    RETURN
  END SUBROUTINE input_history_wrf

  SUBROUTINE input_boundary_wrf ( fid , grid , config_flags , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    IMPLICIT NONE
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(INOUT) :: ierr
    CALL input_wrf ( fid , grid , config_flags , boundary_only , ierr )
    RETURN
  END SUBROUTINE input_boundary_wrf

  SUBROUTINE input_wrf ( fid , grid , config_flags , switch , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    USE module_date_time
    IMPLICIT NONE
#include <wrf_io_flags.h>
#include <wrf_status_codes.h>
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(IN) :: switch
    INTEGER, INTENT(INOUT) :: ierr
    LOGICAL, EXTERNAL :: wrf_on_monitor
    INTEGER rsize , isize
# if defined(DM_PARALLEL) && ! defined (DM_DISTRIB_IO)
    isize =  (grid%ed31-grid%sd31+1) * (grid%ed33-grid%sd33+1)
    rsize =  (grid%ed32-grid%sd32+1) * isize
    IF ( rsize > gbuf_real_size .AND. wrf_on_monitor() ) THEN
      IF ( .NOT. ASSOCIATED ( gbuf_real ) ) THEN
        ALLOCATE ( gbuf_real ( rsize ) )
      ELSE
        DEALLOCATE ( gbuf_real )
        ALLOCATE ( gbuf_real ( rsize ) )
      ENDIF
    ENDIF
    IF ( isize > gbuf_integer_size .AND. wrf_on_monitor() ) THEN
      IF ( .NOT. ASSOCIATED ( gbuf_integer ) ) THEN
        ALLOCATE ( gbuf_integer ( isize ) )
      ELSE
        DEALLOCATE ( gbuf_integer )
        ALLOCATE ( gbuf_integer ( isize ) )
      ENDIF
    ENDIF
#endif
    CALL input_wrf1 ( fid , grid , config_flags , gbuf_real , gbuf_integer , switch , ierr )
  END SUBROUTINE input_wrf

  SUBROUTINE input_wrf1 ( fid , grid , config_flags , globbuf_real , globbuf_integer , switch , ierr )
    USE module_domain
    USE module_state_description
    USE module_configure
    USE module_io_wrf
    USE module_date_time
    IMPLICIT NONE
#include <wrf_io_flags.h>
#include <wrf_status_codes.h>
    TYPE(domain) :: grid
    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags
    INTEGER, INTENT(IN) :: fid
    INTEGER, INTENT(IN) :: switch
    INTEGER, INTENT(INOUT) :: ierr

    ! Local data
    INTEGER ids , ide , jds , jde , kds , kde , &
            ims , ime , jms , jme , kms , kme , &
            ips , ipe , jps , jpe , kps , kpe
#if 0
#if defined(DM_PARALLEL) && ! defined (DM_DISTRIB_IO)
    REAL          globbuf_real((grid%ed31-grid%sd31+1)*&
                               (grid%ed33-grid%sd33+1)*&
                               (grid%ed32-grid%sd32+1))
    INTEGER       globbuf_integer((grid%ed31-grid%sd31+1)*&
                                  (grid%ed33-grid%sd33+1))
#endif
#else
    REAL          globbuf_real(*)
    INTEGER       globbuf_integer(*)
#endif
    INTEGER       iname(9)
    INTEGER       iordering(3)
    INTEGER       icurrent_date(24)
    INTEGER       i,j,k
    INTEGER       icnt
    INTEGER       ndim
    INTEGER       ilen
    INTEGER , DIMENSION(3) :: domain_start , domain_end
    INTEGER , DIMENSION(3) :: memory_start , memory_end
    INTEGER , DIMENSION(3) :: patch_start , patch_end
    CHARACTER*256 errmess
    CHARACTER*9   NAMESTR
    INTEGER       IBDY, NAMELEN
    LOGICAL wrf_on_monitor
    EXTERNAL wrf_on_monitor
    REAL    time, oldtime, newtime
    CHARACTER*19  new_date
    CHARACTER*24  base_date
    INTEGER ny , nm , nd , nh , ni , ns , nt
    INTEGER idt

    ierr = 0

    IF ( wrf_on_monitor() ) CALL ext_get_next_time(fid, current_date , ierr)
    WRITE(wrf_err_message,*)'input_wrf: ext_get_next_time current_date: ',current_date(1:19),' Status = ',ierr
    CALL wrf_debug ( 300 , TRIM(wrf_err_message ) )
    CALL wrf_dm_bcast_string ( current_date , 24 )

    ids             = grid%sd31 
    ide             = grid%ed31 
    jds             = grid%sd33 
    jde             = grid%ed33 
    kds             = grid%sd32 
    kde             = grid%ed32 
    ims             = grid%sm31 
    ime             = grid%em31 
    jms             = grid%sm33 
    jme             = grid%em33 
    kms             = grid%sm32 
    kme             = grid%em32 
    ips             = grid%sp31 
    ipe             = grid%ep31 
    jps             = grid%sp33 
    jpe             = grid%ep33 
    kps             = grid%sp32 
    kpe             = grid%ep32 


    WRITE(wrf_err_message,*)'input_wrf: current_date = ',current_date
    CALL wrf_debug ( 300 , wrf_err_message )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'CEN_LAT' ,  config_flags%cen_lat , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for CEN_LAT returns ',config_flags%cen_lat
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%cen_lat , RWORDSIZE )
    CALL set_cen_lat ( grid%id , config_flags%cen_lat )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'CEN_LON' ,  config_flags%cen_lon , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for CEN_LON returns ',config_flags%cen_lon
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%cen_lon , RWORDSIZE )
    CALL set_cen_lon ( grid%id , config_flags%cen_lon )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'TRUELAT1' ,  config_flags%truelat1 , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for TRUELAT1 returns ',config_flags%truelat1
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%truelat1 , RWORDSIZE )
    CALL set_truelat1 ( grid%id , config_flags%truelat1 )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'TRUELAT2' ,  config_flags%truelat2 , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for TRUELAT2 returns ',config_flags%truelat2
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%truelat2 , RWORDSIZE )
    CALL set_truelat2 ( grid%id , config_flags%truelat2 )

    IF ( switch .NE. boundary_only ) THEN
      IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'GMT' ,  config_flags%gmt , 1 , icnt , ierr )
      WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for GMT returns ',config_flags%gmt
      CALL wrf_debug ( 300 , wrf_err_message )
      CALL wrf_dm_bcast_bytes ( config_flags%gmt , RWORDSIZE )
      CALL set_gmt ( grid%id , config_flags%gmt )

      IF ( wrf_on_monitor() ) CALL ext_get_glb_md_integer ( fid , 'JULYR' ,  config_flags%julyr , 1 , icnt , ierr )
      WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_integer for JULYR returns ',config_flags%julyr
      CALL wrf_debug ( 300 , wrf_err_message )
      CALL wrf_dm_bcast_bytes ( config_flags%julyr , IWORDSIZE )
      CALL set_julyr ( grid%id , config_flags%julyr )

      IF ( wrf_on_monitor() ) CALL ext_get_glb_md_integer ( fid , 'JULDAY' ,  config_flags%julday , 1 , icnt , ierr )
      WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_integer for JULDAY returns ',config_flags%julday
      CALL wrf_debug ( 300 , wrf_err_message )
      CALL wrf_dm_bcast_bytes ( config_flags%julday , IWORDSIZE )
      CALL set_julday ( grid%id , config_flags%julday )
    ENDIF

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_integer ( fid , 'ISWATER' ,  config_flags%iswater , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_integer for ISWATER returns ',config_flags%iswater
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%iswater , IWORDSIZE )
    CALL set_iswater ( grid%id , config_flags%iswater )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_integer ( fid , 'MAP_PROJ' ,  config_flags%map_proj , 1 , icnt , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_integer for MAP_PROJ returns ',config_flags%map_proj
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_bytes ( config_flags%map_proj , IWORDSIZE )
    CALL set_map_proj ( grid%id , config_flags%map_proj )

    IF ( wrf_on_monitor() ) CALL ext_get_glb_md_char ( fid , 'MMINLU', mminlu(1:4) , ierr )
    WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_char for MMINLU returns ',mminlu(1:4)
    CALL wrf_debug ( 300 , wrf_err_message )
    CALL wrf_dm_bcast_string ( mminlu , 4 )
    CALL set_mminlu ( mminlu(1:4) )

    IF ( switch .EQ. boundary_only ) THEN
        IF ( wrf_on_monitor() ) CALL ext_get_glb_md_real ( fid , 'BDYFRQ' ,  config_flags%bdyfrq , 1 , icnt , ierr )
        WRITE(wrf_err_message,*)'input_wrf: ext_get_glb_md_real for BDYFRQ returns ',config_flags%bdyfrq
        CALL wrf_debug ( 300 , wrf_err_message )
        CALL wrf_dm_bcast_bytes ( config_flags%bdyfrq , RWORDSIZE )
        CALL set_bdyfrq ( grid%id , config_flags%bdyfrq )
        CALL get_time_to_read_again ( oldtime )
        newtime = oldtime + config_flags%bdyfrq
        CALL set_time_to_read_again ( newtime )
    ENDIF


! Loop over records in input file

    IF      ( switch .EQ. initial_only ) THEN
#include <wrf_initialin.inc>
    ELSE IF ( switch .EQ. restart_only ) THEN
#include <wrf_restartin.inc>
    ELSE IF ( switch .EQ. history_only ) THEN
#include <wrf_histin.inc>
    ELSE IF ( switch .EQ. boundary_only ) THEN
#include <wrf_bdyin.inc>
    ENDIF

    RETURN
  END SUBROUTINE input_wrf1

#endif

#endif

  SUBROUTINE debug_io_wrf ( msg , date, ds , de , ps , pe , ms , me )
    USE module_wrf_error
    IMPLICIT NONE
    CHARACTER(LEN=*) , INTENT(IN) :: msg , date
    INTEGER , DIMENSION(3) , INTENT(IN) :: ds , de , ps , pe , ms , me
    IF ( wrf_at_debug_level(300) ) THEN
      CALL wrf_message ( msg )
      WRITE(wrf_err_message,*)'date ',date  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'ds ',ds  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'de ',de  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'ps ',ps  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'pe ',pe  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'ms ',ms  ; CALL wrf_message ( TRIM(wrf_err_message) )
      WRITE(wrf_err_message,*)'me ',me  ; CALL wrf_message ( TRIM(wrf_err_message) )
    ENDIF
    RETURN
  END SUBROUTINE debug_io_wrf

  SUBROUTINE wrf_ext_write_field(DataHandle,DateStr,Var,Field,FieldType,Comm, &
                                 DomainDesc,                      &
                                 write_metadata,                  &
                                 MemoryOrder,                     &
                                 Dimname1, Dimname2, Dimname3 ,   &
                                 Desc, Units,                     &
                                 debug_message ,                              &
                                 ds1, de1, ds2, de2, ds3, de3,                &
                                 ms1, me1, ms2, me2, ms3, me3,                &
                                 ps1, pe1, ps2, pe2, ps3, pe3, Status          )
    USE module_wrf_error
    USE module_timing
    IMPLICIT NONE

    integer                       ,intent(in)    :: DataHandle
    character*(*)                 ,intent(in)    :: DateStr
    character*(*)                 ,intent(in)    :: Var
    integer                       ,intent(inout) :: Field(*)
    integer                       ,intent(in)    :: FieldType
    integer                       ,intent(inout) :: Comm
    integer                       ,intent(in)    :: DomainDesc
    logical                       ,intent(in)    :: write_metadata
    character*(*)                 ,intent(in)    :: MemoryOrder
    character*(*)                 ,intent(in)    :: Dimname1, Dimname2, Dimname3
    character*(*)                 ,intent(in)    :: Desc, Units
    character*(*)                 ,intent(in)    :: debug_message

    INTEGER ,       INTENT(IN   ) :: ds1, de1, ds2, de2, ds3, de3, &
                                     ms1, me1, ms2, me2, ms3, me3, &
                                     ps1, pe1, ps2, pe2, ps3, pe3

    INTEGER , DIMENSION(3) :: domain_start , domain_end
    INTEGER , DIMENSION(3) :: memory_start , memory_end
    INTEGER , DIMENSION(3) :: patch_start , patch_end
    CHARACTER*80 , DIMENSION(3) :: dimnames

    integer                       ,intent(inout)   :: Status

    IF ( wrf_at_debug_level( 500 ) ) THEN
      call start_timing
    ENDIF
    domain_start(1) = ds1 ; domain_end(1) = de1 ;
    patch_start(1)  = ps1 ; patch_end(1)  = pe1 ;
    memory_start(1) = ms1 ; memory_end(1) = me1 ;
    domain_start(2) = ds2 ; domain_end(2) = de2 ;
    patch_start(2)  = ps2 ; patch_end(2)  = pe2 ;
    memory_start(2) = ms2 ; memory_end(2) = me2 ;
    domain_start(3) = ds3 ; domain_end(3) = de3 ;
    patch_start(3)  = ps3 ; patch_end(3)  = pe3 ;
    memory_start(3) = ms3 ; memory_end(3) = me3 ;

    dimnames(1) = Dimname1
    dimnames(2) = Dimname2
    dimnames(3) = Dimname3

    CALL debug_io_wrf ( debug_message,DateStr,                          &
                        domain_start,domain_end,patch_start,patch_end,  &
                        memory_start,memory_end                          )

    CALL ext_write_field (   &
                       DataHandle                 &  ! DataHandle
                      ,DateStr                    &  ! DateStr
                      ,Var                        &  ! Data Name
                      ,Field                      &  ! Field
                      ,FieldType                  &  ! FieldType
                      ,Comm                       &  ! Comm
                      ,DomainDesc                 &  ! DomainDesc
                      ,MemoryOrder                &  ! MemoryOrder
                      ,dimnames                   &  ! JMMODS 1109
                      ,domain_start               &  ! DomainStart
                      ,domain_end                 &  ! DomainEnd
                      ,memory_start               &  ! MemoryStart
                      ,memory_end                 &  ! MemoryEnd
                      ,patch_start                &  ! PatchStart
                      ,patch_end                  &  ! PatchEnd
                      ,Status )

#ifdef NETCDF
    IF ( write_metadata ) THEN
      CALL ext_put_var_md_char( &
                       DataHandle                 &  ! DataHandle
		      ,"description"              &  ! Element
                      ,Var                        &  ! Data Name
                      ,Desc                       &  ! Data
		      ,Status )
      CALL ext_put_var_md_char( &
                       DataHandle                 &  ! DataHandle
		      ,"units"                    &  ! Element
                      ,Var                        &  ! Data Name
                      ,Units                      &  ! Data
		      ,Status )
    ENDIF
#endif

    IF ( wrf_at_debug_level(300) ) THEN
      WRITE(wrf_err_message,*) debug_message,' Status = ',Status
      CALL wrf_message ( TRIM(wrf_err_message) )
    ENDIF

    IF ( wrf_at_debug_level( 500 ) ) THEN
      CALL end_timing('wrf_ext_write_field')
    ENDIF

  END SUBROUTINE wrf_ext_write_field

  SUBROUTINE wrf_ext_read_field( DataHandle,DateStr,Var,Field,FieldType,Comm, &
                                 DomainDesc, MemoryOrder,                     &
                                 debug_message ,                              &
                                 ds1, de1, ds2, de2, ds3, de3,                &
                                 ms1, me1, ms2, me2, ms3, me3,                &
                                 ps1, pe1, ps2, pe2, ps3, pe3, Status          )
    USE module_wrf_error
    IMPLICIT NONE

    integer                       ,intent(in)    :: DataHandle
    character*(*)                 ,intent(in)    :: DateStr
    character*(*)                 ,intent(in)    :: Var
    integer                       ,intent(inout) :: Field(*)
    integer                       ,intent(in)    :: FieldType
    integer                       ,intent(inout) :: Comm
    integer                       ,intent(in)    :: DomainDesc
    character*(*)                 ,intent(in)    :: MemoryOrder
    character*(*)                 ,intent(in)    :: debug_message

    INTEGER ,       INTENT(IN   ) :: ds1, de1, ds2, de2, ds3, de3, &
                                     ms1, me1, ms2, me2, ms3, me3, &
                                     ps1, pe1, ps2, pe2, ps3, pe3

    INTEGER , DIMENSION(3) :: domain_start , domain_end
    INTEGER , DIMENSION(3) :: memory_start , memory_end
    INTEGER , DIMENSION(3) :: patch_start , patch_end
    CHARACTER*80 , DIMENSION(3) :: dimnames

    integer                       ,intent(inout)   :: Status

    domain_start(1) = ds1 ; domain_end(1) = de1 ;
    patch_start(1)  = ps1 ; patch_end(1)  = pe1 ;
    memory_start(1) = ms1 ; memory_end(1) = me1 ;
    domain_start(2) = ds2 ; domain_end(2) = de2 ;
    patch_start(2)  = ps2 ; patch_end(2)  = pe2 ;
    memory_start(2) = ms2 ; memory_end(2) = me2 ;
    domain_start(3) = ds3 ; domain_end(3) = de3 ;
    patch_start(3)  = ps3 ; patch_end(3)  = pe3 ;
    memory_start(3) = ms3 ; memory_end(3) = me3 ;

    CALL debug_io_wrf ( debug_message,DateStr,                          &
                        domain_start,domain_end,patch_start,patch_end,  &
                        memory_start,memory_end                          )


    CALL ext_read_field (   &
                       DataHandle                 &  ! DataHandle
                      ,DateStr                    &  ! DateStr
                      ,Var                        &  ! Data Name
                      ,Field                      &  ! Field
                      ,FieldType                  &  ! FieldType
                      ,Comm                       &  ! Comm
                      ,DomainDesc                 &  ! DomainDesc
                      ,MemoryOrder                &  ! MemoryOrder
                      ,dimnames                   &  ! JMMOD 1109 (not used at present)
                      ,domain_start               &  ! DomainStart
                      ,domain_end                 &  ! DomainEnd
                      ,memory_start               &  ! MemoryStart
                      ,memory_end                 &  ! MemoryEnd
                      ,patch_start                &  ! PatchStart
                      ,patch_end                  &  ! PatchEnd
                      ,Status )
    IF ( wrf_at_debug_level(300) ) THEN
      WRITE(wrf_err_message,*) debug_message,' Status = ',Status
      CALL wrf_message ( TRIM(wrf_err_message) )
    ENDIF

  END SUBROUTINE wrf_ext_read_field


