!WRF:MODEL_LAYER:PHYSICS
!

MODULE module_mp_kessler

CONTAINS
!----------------------------------------------------------------
   SUBROUTINE kessler( t, qv, qc, qcold, qr, qrold, rho, pii,   &
                       RAINNC, dt_in, z, cp,                    &
                       EP2,SVP1,SVP2,SVP3,SVPT0,rhowater,       &
                       dzetaw,                                  &
                       ids,ide, jds,jde, kds,kde,               & ! domain dims
                       ims,ime, jms,jme, kms,kme,               & ! memory dims
                       its,ite, jts,jte, kts,kte                ) ! tile   dims
!----------------------------------------------------------------
   IMPLICIT NONE
!----------------------------------------------------------------
   !  taken from the COMMAS code - WCS 10 May 1999.
   !  converted from FORTRAN 77 to 90, tiled, WCS 10 May 1999.
!  we'll keep "grid" out of here for the time being
!----------------------------------------------------------------
   REAL    , PARAMETER ::  c1 = .001 
   REAL    , PARAMETER ::  c2 = .001 
   REAL    , PARAMETER ::  c3 = 2.2 
   REAL    , PARAMETER ::  c4 = .875 
   REAL    , PARAMETER ::  fudge = 1.0 
   REAL    , PARAMETER ::  mxfall = 10.0 
!----------------------------------------------------------------
   INTEGER,      INTENT(IN   )    :: ids,ide, jds,jde, kds,kde, &
                                     ims,ime, jms,jme, kms,kme, &
                                     its,ite, jts,jte, kts,kte
   REAL   ,      INTENT(IN   )    :: cp
   REAL   ,      INTENT(IN   )    :: EP2,SVP1,SVP2,SVP3,SVPT0
   REAL   ,      INTENT(IN   )    :: rhowater

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ),              &
         INTENT(INOUT) ::                                       &
                                                            t , &
                                                            qv, &
                                                            qc, &
                                                            qr

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ),              &
         INTENT(IN   ) ::                                       &
                                                         qcold, &
                                                         qrold, &
                                                           rho, &
                                                           pii

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ),              &
         INTENT(IN   ) ::                                    z

   REAL, DIMENSION( kms:kme ), INTENT(IN   ) ::              dzetaw

   REAL, DIMENSION( ims:ime , jms:jme ),                        &
         INTENT(INOUT) ::                               RAINNC

   REAL, INTENT(IN   ) :: dt_in

   ! local variables

   REAL :: qrprod, ern, gam, rcgs, rcgsi, vtden
   REAL, DIMENSION( its:ite , kts:kte, jts:jte ) ::            &
                                                         prod, &
                                                           vt    
   INTEGER :: i,j,k
   INTEGER :: nfall, n
   REAL    :: qrr, pressure, temp, es, qvs, dz, dt
   REAL    :: f5, dtfall, rdz, product
   REAL    :: max_heating, max_condense, max_rain, maxqrp
   REAL    :: factor, vtmax, ernmax
   REAL    :: qcr, qroldr, qcoldr, factorr, maxqrold, minqrold, ppt
!----------------------------------------------------------------

   INTEGER :: imax, kmax

!  LEAPFROG MODEL, timestep is over 2*dt
!    dt = 2*dt_in

    dt = dt_in

    f5 = 237.3 * 17.27 * 2.5e6 / cp 
    vtmax = 0.
    ernmax = 0.
    maxqrp = -100.

!------------------------------------------------------------------------------
! parameters for the time split terminal advection
!------------------------------------------------------------------------------

      dz = dzetaw(1)
      nfall = max(1,nint(mxfall*dt/dz))  ! courant number for big timestep.
      dtfall = dt / float(nfall)         ! splitting so courant number for sedimentation
                                         !  is less than one.

!      write(6,*) ' nfall,dz in kessler ',nfall,dz

      max_heating = 0.
      max_condense = 0.
      max_rain = 0.

!-----------------------------------------------------------------------------
! outer J loop for entire microphysics
!-----------------------------------------------------------------------------

  microphysics_outer_j_loop: DO j=jts, jte

!-----------------------------------------------------------------------------
! Compute autoconversion, coalesense, and set tmp arrays for time split
! terminal velocity fall.
!------------------------------------------------------------------------------

   DO k = kts, kte
   DO i = its, ite

!!     prod(i,k,j)   = qrold(i,k,j)
     prod(i,k,j)   = qr(i,k,j)
!!     qrr = amax1(0.,qrold(i,k,j)*0.001*rho(i,k,j))
     qrr = amax1(0.,qr(i,k,j)*0.001*rho(i,k,j))
     vtden = sqrt(rho(i,1,j)/rho(i,k,j))
     vt(i,k,j) = 36.34*(qrr**0.1364) * vtden
!     vtmax = amax1(vt(i,k,j), vtmax)

   ENDDO
   ENDDO

!------------------------------------------------------------------------------
! Terminal velocity calculation and advection
! Do a time split loop on this for stability when vertical grid is fine
! Hold the teriminal velocity constant during the time split loop
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
! Time split loop, Fallout done with flux upstream
!------------------------------------------------------------------------------

       ppt=0.

       DO n = 1,nfall
         DO i = its, ite
            k = 1
            ppt=rho(i,k,j)*prod(i,k,j)*vt(i,k,j)*dtfall/rhowater
! unit = mm
            RAINNC(i,j)=RAINNC(i,j)+ppt*1000.
         ENDDO

         DO k = kts, kte-1
         DO i = its, ite
           rdz = 1./(z(i,k+1,j) - z(i,k,j))
           factor = dtfall*rdz/rho(i,k,j)
           prod(i,k,j) = prod(i,k,j) - factor                 &
                     * (rho(i,k  ,j)*prod(i,k  ,j)*vt(i,k  ,j)   &
                       -rho(i,k+1,j)*prod(i,k+1,j)*vt(i,k+1,j))
         ENDDO
         ENDDO

         k = kte

         DO i = its, ite
           rdz = 1./(z(i,k,j) - z(i,k-1,j))
           factor = dtfall*rdz
           prod(i,k,j) = prod(i,k,j) - factor*prod(i,k  ,j)*vt(i,k  ,j)
         ENDDO

         DO k = kts, kte 
         DO i = its, ite

!!           qrr = amax1(0.,qrold(i,k,j)*0.001*rho(i,k,j))
           qrr = amax1(0.,prod(i,k,j)*0.001*rho(i,k,j))
           vtden = sqrt(rho(i,1,j)/rho(i,k,j))
           vt(i,k,j) = 36.34*(qrr**0.1364) * vtden

         ENDDO
         ENDDO

       ENDDO

!------------------------------------------------------------------------------
! Production of rain and deletion of qc
! Production of qc from supersaturation
! Evaporation of QR
!------------------------------------------------------------------------------

     DO k = kts, kte
     DO i = its, ite
!!       factor = 1.0 / (1.+c3*dt*qrold(i,k,j)**c4)
       factor = 1.0 / (1.+c3*dt*amax1(0.,qr(i,k,j))**c4)
!!       qrprod = qc(i,k,j) * (1.0 - factor)           &
!!             + factor*c1*dt*amax1(qcold(i,k,j)-c2,0.)      
       qrprod = qc(i,k,j) * (1.0 - factor)           &
             + factor*c1*dt*amax1(qc(i,k,j)-c2,0.)      
       rcgs = 0.001*rho(i,k,j)

       qc(i,k,j) = amax1(qc(i,k,j) - qrprod,0.)
!!       qr(i,k,j) = (qr(i,k,j) + prod(i,k,j)-qrold(i,k,j))
       qr(i,k,j) = (qr(i,k,j) + prod(i,k,j)-qr(i,k,j))
       qr(i,k,j) = amax1(qr(i,k,j) + qrprod,0.)

       temp      = pii(i,k,j)*t(i,k,j)
       pressure = 1.000e+05 * (pii(i,k,j)**(1004./287.))
       gam = 2.5e+06/(1004.*pii(i,k,j))
!      qvs       = 380.*exp(17.27*(temp-273.)/(temp- 36.))/pressure
       es        = 1000.*svp1*exp(svp2*(temp-svpt0)/(temp-svp3))
       qvs       = ep2*es/(pressure-es)
       prod(i,k,j) = (qv(i,k,j)-qvs) / (1.+qvs*f5/(temp-36.)**2)
       ern  = amin1(dt*(((1.6+124.9*(rcgs*qr(i,k,j))**.2046)   &
          *(rcgs*qr(i,k,j))**.525)/(2.55e8/(pressure*qvs)       &
          +5.4e5))*(dim(qvs,qv(i,k,j))/(rcgs*qvs)),             &
          amax1(-prod(i,k,j)-qc(i,k,j),0.),qr(i,k,j))

! Update all variables

       product = amax1(prod(i,k,j),-qc(i,k,j))
       t (i,k,j) = t(i,k,j) + gam*(product - ern)
       qv(i,k,j) = amax1(qv(i,k,j) - product + ern,0.)
       qc(i,k,j) =       qc(i,k,j) + product
       qr(i,k,j) = qr(i,k,j) - ern

     ENDDO
     ENDDO

  ENDDO  microphysics_outer_j_loop

  RETURN

  END SUBROUTINE kessler

END MODULE module_mp_kessler
