!WRF:DRIVER_LAYER:NESTING
!

MODULE module_nesting

   USE module_machine
   USE module_driver_constants
   USE module_domain

   LOGICAL, DIMENSION( max_domains )              :: active_domain

CONTAINS

   LOGICAL FUNCTION nests_to_open ( parent , nestid , kid )
      IMPLICIT NONE
      TYPE(domain) , INTENT(IN)  :: parent
      INTEGER, INTENT(OUT)       :: nestid , kid
      ! Local data
      INTEGER                    :: mother_id
      INTEGER                    :: time_step_count_start , time_step_count_end
      INTEGER                    :: rent
#if 1
! commented out because of problems with vpp compiler -- not used yet, anyway
      DO nestid = 2, max_domains
        IF ( .NOT. active_domain( nestid ) ) THEN
          CALL get_mother_id( nestid, mother_id )  ! from namelist
          IF ( mother_id .EQ. parent%id ) THEN
            CALL get_time_step_count_start( nestid, time_step_count_start )
            CALL get_time_step_count_end( nestid, time_step_count_end )
            IF ( time_step_count_start .LE.  head_grid%total_time_steps .AND. &
                 time_step_count_end   .GT.  head_grid%total_time_steps ) THEN
              DO kid = 1 , max_nests
                IF ( .NOT. ASSOCIATED ( parent%nests(kid)%ptr ) ) THEN
                  active_domain( nestid ) = .true.
                  nests_to_open = .true.
                  RETURN
                END IF
              END DO
            END IF
          END IF
        END IF
      END DO
#endif
      nestid = 0
      kid = 0
      nests_to_open = .false.
      RETURN
   END FUNCTION nests_to_open

   ! Descend tree rooted at grid and set sibling pointers for
   ! grids that overlap.  We need some kind of global point space
   ! for working this out.

   SUBROUTINE set_overlaps ( grid )
      IMPLICIT NONE
      TYPE (domain), INTENT(INOUT)    :: grid
      ! stub
   END SUBROUTINE set_overlaps

   SUBROUTINE init_module_nesting
      active_domain = .FALSE.
   END SUBROUTINE init_module_nesting

END MODULE module_nesting

