MODULE module_si_io

   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: t_mm5 , u_mm5 , v_mm5 , q_mm5 , &
                                            w_mm5 , p_mm5 , theta_mm5 , rho_mm5 , &
                                            z_mm5

   REAL , DIMENSION(:,:)   , ALLOCATABLE :: tg_mm5 , res_mm5 , soilt010_mm5 , soilt200_mm5 , &
                                            soilt400_mm5 , soilm010_mm5 , soilm200_mm5 , &
                                            seaice_mm5 , ter_mm5 , landuse_mm5 , lat_mm5 , &
                                            lon_mm5 , snow_mm5 , landmask_mm5

   REAL , DIMENSION(:,:)   , ALLOCATABLE :: msft_wrf , msfu_wrf , msfv_wrf , sina_wrf , cosa_wrf , &
                                            e_wrf , f_wrf , &
                                            zeta_z_wrf , z_zeta_wrf , psurface_wrf
   
   REAL , DIMENSION(:)     , ALLOCATABLE :: zetafull , zetahalf

   LOGICAL , SAVE :: first_time_in = .TRUE.

!   Some constants to allow simple dimensions in the defined types
!   given below.

    INTEGER, PARAMETER		:: max_domains = 10
    INTEGER, PARAMETER          :: var_maxdims = 5
    INTEGER, PARAMETER          :: max_staggers_xy = 3
    INTEGER, PARAMETER          :: max_staggers_z = 2
    INTEGER, PARAMETER          :: max_standard_lats = 4
    INTEGER, PARAMETER          :: max_standard_lons = 4  
    INTEGER, PARAMETER		:: max_fg_variables = 200
    INTEGER, PARAMETER          :: max_vertical_levels = 2000

!   This module defines the items needed for the WRF metadata
!   which is broken up into three levels:  
!      Global metadata:  Those things which apply to the
!                        entire simulation that are 
!                        independent of time, domain, or
!                        variable
!
!      Domain metadata:  Those things which apply to 
!                        a single domain (this may
!                        or may not be time dependent)
!
!      Variable metadata: Those things which apply to 
!                        a specific variable at a 
!                        specific time
!
!      The variable names and definitions can be 
!      found in the wrf_metadata spec, which is still
!      a living document as coding goes on.   The names
!      may not match exactly, but you should be able 
!      to figure things out.  
!

    TYPE wrf_var_metadata
      CHARACTER (LEN=8)		:: name 
      CHARACTER (LEN=16)	:: units
      CHARACTER (LEN=80)	:: description
      INTEGER			:: domain_id
      INTEGER                   :: ndim
      INTEGER          	 	:: dim_val (var_maxdims)
      CHARACTER(LEN=4)		:: dim_desc (var_maxdims)
      INTEGER                   :: start_index(var_maxdims)
      INTEGER			:: stop_index(var_maxdims)
      INTEGER			:: h_stagger_index
      INTEGER              	:: v_stagger_index
      CHARACTER(LEN=8)		:: array_order
      CHARACTER(LEN=4)		:: field_type
      CHARACTER(LEN=8)          :: field_source_prog
      CHARACTER(LEN=80)         :: source_desc
      CHARACTER(LEN=8)          :: field_time_type
      INTEGER			:: vt_date_start
      REAL                      :: vt_time_start
      INTEGER              	:: vt_date_stop
      REAL			:: vt_time_stop
    END TYPE wrf_var_metadata

    TYPE(wrf_var_metadata)  :: var_meta , var_info

    TYPE wrf_domain_metadata
      INTEGER			:: id
      INTEGER			:: parent_id
      CHARACTER(LEN=8)		:: dyn_init_src
      CHARACTER(LEN=8)		:: static_init_src 
      INTEGER			:: vt_date
      REAL			:: vt_time
      INTEGER			:: origin_parent_x
      INTEGER			:: origin_parent_y
      INTEGER			:: ratio_to_parent
      REAL                      :: delta_x
      REAL                      :: delta_y
      REAL                      :: top_level
      INTEGER			:: origin_parent_z
      REAL			:: corner_lats(4,max_staggers_xy)
      REAL			:: corner_lons(4,max_staggers_xy)
      INTEGER			:: xdim
      INTEGER			:: ydim
      INTEGER			:: zdim
    END TYPE wrf_domain_metadata
    TYPE(wrf_domain_metadata) :: dom_meta

    TYPE wrf_global_metadata
      CHARACTER(LEN=80)		:: simulation_name
      CHARACTER(LEN=80)        	:: user_desc
      INTEGER			:: si_version
      INTEGER			:: analysis_version  
      INTEGER			:: wrf_version
      INTEGER			:: post_version
      CHARACTER(LEN=32)		:: map_projection
      REAL			:: moad_known_lat
      REAL			:: moad_known_lon
      CHARACTER(LEN=8)		:: moad_known_loc
      REAL			:: moad_stand_lats(max_standard_lats)
      REAL			:: moad_stand_lons(max_standard_lons)
      REAL			:: moad_delta_x
      REAL			:: moad_delta_y
      CHARACTER(LEN=4)		:: horiz_stagger_type
      INTEGER                   :: num_stagger_xy
      REAL			:: stagger_dir_x(max_staggers_xy)
      REAL			:: stagger_dir_y(max_staggers_xy)
      INTEGER			:: num_stagger_z    
      REAL   			:: stagger_dir_z(max_staggers_z)
      CHARACTER(LEN=8)		:: vertical_coord
      INTEGER			:: num_domains
      INTEGER			:: init_date
      REAL			:: init_time
      INTEGER			:: end_date
      REAL			:: end_time
    END TYPE wrf_global_metadata
    TYPE(wrf_global_metadata)   :: global_meta

    ! Define some values for the var_meta%name tags

    CHARACTER (LEN=80), PARAMETER  :: pressure_id          = 'PRESSURE'
    CHARACTER (LEN=80), PARAMETER  :: height_id            = 'HGT     '
    CHARACTER (LEN=80), PARAMETER  :: soilhgt_id           = 'SOILHGT '
    CHARACTER (LEN=80), PARAMETER  :: u_id                 = 'U       '
    CHARACTER (LEN=80), PARAMETER  :: v_id                 = 'V       '
    CHARACTER (LEN=80), PARAMETER  :: t_id                 = 'T       '
    CHARACTER (LEN=80), PARAMETER  :: rh_id                = 'RH      '
    CHARACTER (LEN=80), PARAMETER  :: press_msl_id         = 'PMSL    '
    CHARACTER (LEN=80), PARAMETER  :: press_sfc_id         = 'PSFC    '
    CHARACTER (LEN=80), PARAMETER  :: terrain_id           = 'TERRAIN '
    CHARACTER (LEN=80), PARAMETER  :: landmask_id          = 'LANDMASK'
    CHARACTER (LEN=80), PARAMETER  :: usgsland_id          = 'USGSLAND'
    CHARACTER (LEN=80), PARAMETER  :: latitude_id          = 'LATITUDE'
    CHARACTER (LEN=80), PARAMETER  :: longitude_id         = 'LONGITUD'
    CHARACTER (LEN=80), PARAMETER  :: rho_id               = 'RHO     '
    CHARACTER (LEN=80), PARAMETER  :: theta_id             = 'THETA   '
    CHARACTER (LEN=80), PARAMETER  :: thetam_id            = 'THETAM  '
    CHARACTER (LEN=80), PARAMETER  :: zetahalf_id          = 'ZETAHALF'
    CHARACTER (LEN=80), PARAMETER  :: zetafull_id          = 'ZETAFULL'
    CHARACTER (LEN=80), PARAMETER  :: qvapor_id            = 'QVAPOR  '
    CHARACTER (LEN=80), PARAMETER  :: qliquid_id           = 'QLIQUID '
    CHARACTER (LEN=80), PARAMETER  :: qice_id              = 'QICE    '
    CHARACTER (LEN=80), PARAMETER  :: qrain_id             = 'QRAIN   '
    CHARACTER (LEN=80), PARAMETER  :: qsnow_id             = 'QSNOW   '
    CHARACTER (LEN=80), PARAMETER  :: qgraupel_id          = 'QGRAUPEL'
    CHARACTER (LEN=80), PARAMETER  :: rhotheta_id          = 'RHOTHETA'
    CHARACTER (LEN=80), PARAMETER  :: tmoist_id            = 'TMOIST  '
    CHARACTER (LEN=80), PARAMETER  :: dzdzeta_id           = 'DZDZETA '
    CHARACTER (LEN=80), PARAMETER  :: dzetadz_id           = 'DZETADZ '
    CHARACTER (LEN=80), PARAMETER  :: dzdx_id              = 'DZDX    '
    CHARACTER (LEN=80), PARAMETER  :: dzdy_id              = 'DZDY    '
    CHARACTER (LEN=80), PARAMETER  :: map_factor_id        = 'MAPFAC  '
    CHARACTER (LEN=80), PARAMETER  :: map_factor_m_id      = 'MAPFAC_M'
    CHARACTER (LEN=80), PARAMETER  :: map_factor_u_id      = 'MAPFAC_U'
    CHARACTER (LEN=80), PARAMETER  :: map_factor_v_id      = 'MAPFAC_V'
    CHARACTER (LEN=80), PARAMETER  :: hcoriolis_id         = 'H_CORIOL'
    CHARACTER (LEN=80), PARAMETER  :: vcoriolis_id         = 'V_CORIOL'
    CHARACTER (LEN=80), PARAMETER  :: cosalpha_id          = 'COSALPHA'
    CHARACTER (LEN=80), PARAMETER  :: sinalpha_id          = 'SINALPHA'
    CHARACTER (LEN=80), PARAMETER  :: tskin_id             = 'SKINTEMP'
    CHARACTER (LEN=80), PARAMETER  :: sst_id               = 'SST     '
    CHARACTER (LEN=80), PARAMETER  :: snow_id              = 'SNOWCOVR'
    CHARACTER (LEN=80), PARAMETER  :: weasd_id             = 'WESNOWDP'  
    CHARACTER (LEN=80), PARAMETER  :: landsea_id           = 'LANDSEA '
    CHARACTER (LEN=80), PARAMETER  :: seaice_id            = 'SEAICE  '
    CHARACTER (LEN=80), PARAMETER  :: soilm0_10_id         = 'SOILM010'
    CHARACTER (LEN=80), PARAMETER  :: soilm10_200_id       = 'SOILM200'
    CHARACTER (LEN=80), PARAMETER  :: soilt0_10_id         = 'SOILT010'
    CHARACTER (LEN=80), PARAMETER  :: soilt10_200_id       = 'SOILT200'
    CHARACTER (LEN=80), PARAMETER  :: soilt200_400_id      = 'SOILT400'

CONTAINS

   SUBROUTINE read_si ( grid , ix , jx , kx , dx , ztop , file_date_string )

      USE module_domain
      USE module_io_mm5

      IMPLICIT NONE

      TYPE(domain) , INTENT(INOUT)  :: grid
      INTEGER , INTENT(IN) :: ix , jx , kx
      REAL , INTENT(IN) :: dx , ztop
      CHARACTER (LEN=19) , INTENT(IN) :: file_date_string

      REAL , DIMENSION(jx,ix) :: dum2d
     
      INTEGER :: i , j , k , loop

      REAL :: dummy

      CHARACTER (LEN= 8) :: dummy_char

      INTEGER :: ok , map_proj

      !  Get the space for the data if this is the first time here.

      IF ( first_time_in ) THEN
         
         IF ( .NOT. ALLOCATED ( zetafull) ) ALLOCATE ( zetafull(kx) )
         IF ( .NOT. ALLOCATED ( zetahalf) ) ALLOCATE ( zetahalf(kx) )

         IF ( .NOT. ALLOCATED ( t_mm5) ) ALLOCATE ( t_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( u_mm5) ) ALLOCATE ( u_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( v_mm5) ) ALLOCATE ( v_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( q_mm5) ) ALLOCATE ( q_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( w_mm5) ) ALLOCATE ( w_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( p_mm5) ) ALLOCATE ( p_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( theta_mm5) ) ALLOCATE ( theta_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( rho_mm5) ) ALLOCATE ( rho_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( z_mm5) ) ALLOCATE ( z_mm5(ix,jx,kx) )

         IF ( .NOT. ALLOCATED ( tg_mm5) ) ALLOCATE ( tg_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( res_mm5) ) ALLOCATE ( res_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt010_mm5) ) ALLOCATE ( soilt010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt200_mm5) ) ALLOCATE ( soilt200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt400_mm5) ) ALLOCATE ( soilt400_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm010_mm5) ) ALLOCATE ( soilm010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm200_mm5) ) ALLOCATE ( soilm200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( seaice_mm5) ) ALLOCATE ( seaice_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( ter_mm5) ) ALLOCATE ( ter_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landuse_mm5) ) ALLOCATE ( landuse_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landmask_mm5) ) ALLOCATE ( landmask_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( snow_mm5) ) ALLOCATE ( snow_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lat_mm5) ) ALLOCATE ( lat_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lon_mm5) ) ALLOCATE ( lon_mm5(ix,jx) )

         IF ( .NOT. ALLOCATED ( msft_wrf) ) ALLOCATE ( msft_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfu_wrf) ) ALLOCATE ( msfu_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfv_wrf) ) ALLOCATE ( msfv_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( sina_wrf) ) ALLOCATE ( sina_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( cosa_wrf) ) ALLOCATE ( cosa_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( e_wrf) ) ALLOCATE ( e_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( f_wrf) ) ALLOCATE ( f_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( zeta_z_wrf) ) ALLOCATE ( zeta_z_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( z_zeta_wrf) ) ALLOCATE ( z_zeta_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( psurface_wrf)  ) ALLOCATE ( psurface_wrf(ix,jx)  )

         CLOSE(12)
         OPEN ( FILE   = 'wrf_input.global.metadata' , &
                UNIT   = 12                          , &
                STATUS = 'OLD'                       , &
                ACCESS = 'SEQUENTIAL'                , &
                FORM   = 'UNFORMATTED'                 )

         READ(12) global_meta%simulation_name, global_meta%user_desc, &
                  global_meta%si_version, global_meta%analysis_version, &
                  global_meta%wrf_version, global_meta%post_version, &
                  global_meta%map_projection, global_meta%moad_known_lat, &
                  global_meta%moad_known_lon, global_meta%moad_known_loc, &
                  global_meta%moad_stand_lats, global_meta%moad_stand_lons, &
                  global_meta%moad_delta_x, global_meta%moad_delta_y, &
                  global_meta%horiz_stagger_type, global_meta%num_stagger_xy, &
                  global_meta%stagger_dir_x, global_meta%stagger_dir_y, &
                  global_meta%num_stagger_z, global_meta%stagger_dir_z, &
                  global_meta%vertical_coord, global_meta%num_domains, &
                  global_meta%init_date, global_meta%init_time, &
                  global_meta%end_date, global_meta%end_time
         CLOSE (12)
   
         print *,'GLOBAL METADATA'
         print *,'global_meta%simulation_name', global_meta%simulation_name
         print *,'global_meta%user_desc', global_meta%user_desc
         print *,'global_meta%user_desc', global_meta%user_desc
         print *,'global_meta%si_version', global_meta%si_version
         print *,'global_meta%analysis_version', global_meta%analysis_version
         print *,'global_meta%wrf_version', global_meta%wrf_version
         print *,'global_meta%post_version', global_meta%post_version
         print *,'global_meta%map_projection', global_meta%map_projection
         print *,'global_meta%moad_known_lat', global_meta%moad_known_lat
         print *,'global_meta%moad_known_lon', global_meta%moad_known_lon
         print *,'global_meta%moad_known_loc', global_meta%moad_known_loc
         print *,'global_meta%moad_stand_lats', global_meta%moad_stand_lats
         print *,'global_meta%moad_stand_lons', global_meta%moad_stand_lons
         print *,'global_meta%moad_delta_x', global_meta%moad_delta_x
         print *,'global_meta%moad_delta_y', global_meta%moad_delta_y
         print *,'global_meta%horiz_stagger_type', global_meta%horiz_stagger_type
         print *,'global_meta%num_stagger_xy', global_meta%num_stagger_xy
         print *,'global_meta%stagger_dir_x', global_meta%stagger_dir_x
         print *,'global_meta%stagger_dir_y', global_meta%stagger_dir_y
         print *,'global_meta%num_stagger_z', global_meta%num_stagger_z
         print *,'global_meta%stagger_dir_z', global_meta%stagger_dir_z
         print *,'global_meta%vertical_coord', global_meta%vertical_coord
         print *,'global_meta%num_domains', global_meta%num_domains
         print *,'global_meta%init_date', global_meta%init_date
         print *,'global_meta%init_time', global_meta%init_time
         print *,'global_meta%end_date', global_meta%end_date
         print *,'global_meta%end_time', global_meta%end_time
         print *,' '

      END IF

#if 0
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      CLOSE(14)
      OPEN ( FILE   = 'TERRAIN_DOMAIN1'                  , &
             UNIT   = 14                                 , &
             STATUS = 'OLD'                              , &
             ACCESS = 'SEQUENTIAL'                       , &
             FORM   = 'UNFORMATTED'                        )

      READ (14) flag

      READ (14) 

      READ (14) flag
      READ (14) 
      READ (14) 
      READ (14) flag
      READ (14) 
      READ (14) dum2d
      CLOSE (14)

      DO i = 1 , 125
      DO j = 1 , 105
         landuse_mm5(i,j) = dum2d(j,i)
      END DO
      END DO
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#endif
     
      CLOSE(13)
      OPEN ( FILE   = 'wrf_input.d01.'//file_date_string , &
             UNIT   = 13                                 , &
             STATUS = 'OLD'                              , &
             ACCESS = 'SEQUENTIAL'                       , &
             FORM   = 'UNFORMATTED'                        )

      READ (13) dom_meta%id,dom_meta%parent_id,dom_meta%dyn_init_src,&
                dom_meta%static_init_src, dom_meta%vt_date, dom_meta%vt_time, &
                dom_meta%origin_parent_x, dom_meta%origin_parent_y, &
                dom_meta%ratio_to_parent, dom_meta%delta_x, dom_meta%delta_y, &
                dom_meta%top_level, dom_meta%origin_parent_z, &
                dom_meta%corner_lats, dom_meta%corner_lons, dom_meta%xdim, &
                dom_meta%ydim, dom_meta%zdim

      print *,'DOMAIN METADATA'
      print *,'dom_meta%id=', dom_meta%id
      print *,'dom_meta%parent_id=', dom_meta%parent_id
      print *,'dom_meta%dyn_init_src=', dom_meta%dyn_init_src
      print *,'dom_meta%static_init_src=', dom_meta%static_init_src
      print *,'dom_meta%vt_date=', dom_meta%vt_date
      print *,'dom_meta%vt_time=', dom_meta%vt_time
      print *,'dom_meta%origin_parent_x=', dom_meta%origin_parent_x
      print *,'dom_meta%origin_parent_y=', dom_meta%origin_parent_y
      print *,'dom_meta%ratio_to_parent=', dom_meta%ratio_to_parent
      print *,'dom_meta%delta_x=', dom_meta%delta_x
      print *,'dom_meta%delta_y=', dom_meta%delta_y
      print *,'dom_meta%top_level=', dom_meta%top_level
      print *,'dom_meta%origin_parent_z=', dom_meta%origin_parent_z
      print *,'dom_meta%corner_lats=', dom_meta%corner_lats
      print *,'dom_meta%corner_lons=', dom_meta%corner_lons
      print *,'dom_meta%xdim=', dom_meta%xdim
      print *,'dom_meta%ydim=', dom_meta%ydim
      print *,'dom_meta%zdim=', dom_meta%zdim
      print *,' '

      !  A simple domain size test.
    
      IF ( ( dom_meta%xdim .NE. ix ) .OR. ( dom_meta%ydim .NE. jx ) .OR. ( dom_meta%zdim .NE. kx ) ) THEN
         PRINT '(A)','Namelist does not match the input data.'
         PRINT '(A,3I5,A)','Namelist dimensions =',ix,jx,kx,'.'
         PRINT '(A,3I5,A)','Input data dimensions =',dom_meta%xdim,dom_meta%ydim,dom_meta%zdim,'.'
         STOP 'Wrong_data_size'
      END IF

      ! How about the grid distance?  Is it the same as in the namelist?

      IF ( ABS ( dom_meta%delta_x - dx ) .GT. 1 ) THEN
         PRINT '(A)','Grid distance differs between input file and namelist.'
         PRINT '(A,F8.1,A)','Grid distance in input file = ',dom_meta%delta_x,' m.'
         PRINT '(A,F8.1,A)','Grid distance in namelist = ',dx,' m.'
         STOP 'Wrong_grid_distance'
      END IF

      CALL set_cen_lat ( grid%id , ( dom_meta%corner_lats(1,1) + dom_meta%corner_lats(2,1) +        &
                                        dom_meta%corner_lats(3,1) + dom_meta%corner_lats(4,1) ) * 0.25 ) 
      CALL set_cen_lon ( grid%id , global_meta%moad_stand_lons(1) )
      CALL set_truelat1 ( grid%id , global_meta%moad_stand_lats(1) )
      CALL set_truelat2 ( grid%id , global_meta%moad_stand_lats(2) )
      IF      ( global_meta%map_projection(1:17) .EQ. 'LAMBERT CONFORMAL'   ) THEN
         map_proj = 1
      ELSE IF ( global_meta%map_projection(1:19) .EQ. 'POLAR STEREOGRAPHIC' ) THEN
         map_proj = 2
      ELSE IF ( global_meta%map_projection(1: 8) .EQ. 'MERCATOR'            ) THEN
         map_proj = 3
      ELSE
         PRINT '(A,A,A)','Undefined map projection: ',TRIM(global_meta%map_projection(1:20)),'.'
         STOP 'Undefined_map_proj_si'
      END IF
      CALL set_map_proj ( grid%id , map_proj ) 
      CALL set_mminlu ( 'USGS' )
      CALL set_iswater (grid%id, 16 )
      CALL set_gmt (grid%id, dom_meta%vt_time / 3600. )
      CALL set_julyr (grid%id, dom_meta%vt_date / 1000 )
      CALL set_julday (grid%id, dom_meta%vt_date - ( dom_meta%vt_date / 1000 ) * 1000 )

      read_all_the_data : DO

         READ (13,IOSTAT=OK) var_info%name, var_info%units, &
                             var_info%description, var_info%domain_id, var_info%ndim, &
                             var_info%dim_val, var_info%dim_desc, var_info%start_index, &
                             var_info%stop_index, var_info%h_stagger_index, var_info%v_stagger_index,&
                             var_info%array_order, var_info%field_type, var_info%field_source_prog, &
                             var_info%source_desc, var_info%field_time_type, var_info%vt_date_start, &
                             var_info%vt_time_start, var_info%vt_date_stop, var_info%vt_time_stop

         IF ( OK .NE. 0 ) THEN
            PRINT '(A,A,A)','End of file found for wrf_input.d01.',file_date_string,'.'
            EXIT read_all_the_data
         END IF

#if 0
         print *,'VARIABLE METADATA'
#endif
         PRINT '(A,A)','var_info%name=', var_info%name 
#if 0
         print *,'var_info%units=', var_info%units 
         print *,'var_info%description=', var_info%description 
         print *,'var_info%domain_id=', var_info%domain_id 
         print *,'var_info%ndim=', var_info%ndim 
         print *,'var_info%dim_val=', var_info%dim_val 
         print *,'var_info%dim_desc=', var_info%dim_desc 
         print *,'var_info%start_index=', var_info%start_index 
         print *,'var_info%stop_index=', var_info%stop_index 
         print *,'var_info%h_stagger_index=', var_info%h_stagger_index 
         print *,'var_info%v_stagger_index=', var_info%v_stagger_index
         print *,'var_info%array_order=', var_info%array_order 
         print *,'var_info%field_type=', var_info%field_type 
         print *,'var_info%field_source_prog=', var_info%field_source_prog 
         print *,'var_info%source_desc=', var_info%source_desc 
         print *,'var_info%field_time_type=', var_info%field_time_type 
         print *,'var_info%vt_date_start=', var_info%vt_date_start 
         print *,'var_info%vt_time_start=', var_info%vt_time_start 
         print *,'var_info%vt_date_stop=', var_info%vt_date_stop 
         print *,'var_info%vt_time_stop=', var_info%vt_time_stop
#endif

         IF      ( var_info%name(1:8) .EQ. 'ZETAHALF' ) THEN
            READ (13) zetahalf
         ELSE IF ( var_info%name(1:8) .EQ. 'ZETAFULL' ) THEN
            READ (13) zetafull
            IF ( ABS ( zetafull(kx) - ztop ) .GT. 1 ) THEN
               PRINT '(A)','Zetatop differs between input file and namelist.'
               PRINT '(A,F8.1,A)','Zetatop in input file = ',zetafull(kx),' m.'
               PRINT '(A,F8.1,A)','Zetatop in namelist = ',ztop,' m.'
               STOP 'Wrong_grid_distance'
            END IF
         ELSE IF ( var_info%name(1:8) .EQ. 'LATITUDE' ) THEN
            READ (13) lat_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'LONGITUD' ) THEN
            READ (13) lon_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'TERRAIN ' ) THEN 
            READ (13) ter_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'MAPFAC_M' ) THEN
            READ (13) msft_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'MAPFAC_U' ) THEN
            READ (13) msfu_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'MAPFAC_V' ) THEN
            READ (13) msfv_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'DZETADZ ' ) THEN
            READ (13) zeta_z_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'DZDZETA ' ) THEN
            READ (13) z_zeta_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'DZDX    ' ) THEN
            READ (13) dummy
         ELSE IF ( var_info%name(1:8) .EQ. 'DZDY    ' ) THEN
            READ (13) dummy
         ELSE IF ( var_info%name(1:8) .EQ. 'PRESSURE' ) THEN
            READ (13) p_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'U       ' ) THEN
            READ (13) u_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'V       ' ) THEN
            READ (13) v_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'THETA   ' ) THEN
            READ (13) theta_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'RHO     ' ) THEN
            READ (13) rho_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'QVAPOR  ' ) THEN
            READ (13) q_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'PSFC    ' ) THEN
            READ (13) psurface_wrf 
         ELSE IF ( var_info%name(1:8) .EQ. 'WEASD   ' ) THEN
            READ (13) dummy
         ELSE IF ( var_info%name(1:8) .EQ. 'SKINTEMP' ) THEN
            READ (13) tg_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'SOILT010' ) THEN
            READ (13) res_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'SOILT200' ) THEN
            READ (13) soilt200_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'SOILT400' ) THEN
            READ (13) dummy
         ELSE IF ( var_info%name(1:8) .EQ. 'SOILM010' ) THEN
            READ (13) soilm010_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'SOILM200' ) THEN
            READ (13) soilm200_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'SEAICE  ' ) THEN
            READ (13) seaice_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'LANDSEA ' ) THEN
            READ (13) dummy
         ELSE IF ( var_info%name(1:8) .EQ. 'LANDMASK' ) THEN
            READ (13) landmask_mm5
         ELSE IF ( var_info%name(1:8) .EQ. 'USGSLAND' ) THEN
!           READ (13) landuse_mm5
            READ (13) 
            landuse_mm5 = 1.e7
         ELSE IF ( var_info%name(1:8) .EQ. 'COSALPHA' ) THEN
            READ (13) cosa_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'SINALPHA' ) THEN
            READ (13) sina_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'H_CORIOL' ) THEN
            READ (13) f_wrf
         ELSE IF ( var_info%name(1:8) .EQ. 'V_CORIOL' ) THEN
            READ (13) e_wrf
         ELSE
            READ (13) dummy
         END IF
 
         print *,' '

      END DO read_all_the_data

      CLOSE (13)

      first_time_in = .FALSE.

   END SUBROUTINE read_si

   SUBROUTINE read_mm5 ( grid , ix , jx , kx , dx , ztop , file_date_string )

      USE module_domain
      USE module_io_mm5

      IMPLICIT NONE

      TYPE(domain) , INTENT(INOUT)  :: grid
      INTEGER , INTENT(IN) :: ix , jx , kx
      REAL , INTENT(IN) :: dx , ztop
      CHARACTER (LEN=19) , INTENT(IN) :: file_date_string

      REAL , DIMENSION(jx,ix) :: dum2d
     
      INTEGER :: i , j , k , loop

      REAL :: dummy

      CHARACTER (LEN= 8) :: dummy_char

      INTEGER :: ok , ix_mm5,jx_mm5,kx_mm5,iswater,julyr,julday,map_proj
      CHARACTER (LEN=4) :: mminlu
      REAL :: gmt,cen_lat, dx_mm5 , truelat1 , truelat2 , cen_lon

      !  Get the space for the data if this is the first time here.

      IF ( first_time_in ) THEN
         
         IF ( .NOT. ALLOCATED ( zetafull) ) ALLOCATE ( zetafull(kx) )
         IF ( .NOT. ALLOCATED ( zetahalf) ) ALLOCATE ( zetahalf(kx) )

         IF ( .NOT. ALLOCATED ( t_mm5) ) ALLOCATE ( t_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( u_mm5) ) ALLOCATE ( u_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( v_mm5) ) ALLOCATE ( v_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( q_mm5) ) ALLOCATE ( q_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( w_mm5) ) ALLOCATE ( w_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( p_mm5) ) ALLOCATE ( p_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( theta_mm5) ) ALLOCATE ( theta_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( rho_mm5) ) ALLOCATE ( rho_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( z_mm5) ) ALLOCATE ( z_mm5(ix,jx,kx) )

         IF ( .NOT. ALLOCATED ( tg_mm5) ) ALLOCATE ( tg_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( res_mm5) ) ALLOCATE ( res_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt010_mm5) ) ALLOCATE ( soilt010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt200_mm5) ) ALLOCATE ( soilt200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt400_mm5) ) ALLOCATE ( soilt400_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm010_mm5) ) ALLOCATE ( soilm010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm200_mm5) ) ALLOCATE ( soilm200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( seaice_mm5) ) ALLOCATE ( seaice_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( ter_mm5) ) ALLOCATE ( ter_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landuse_mm5) ) ALLOCATE ( landuse_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landmask_mm5) ) ALLOCATE ( landmask_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( snow_mm5) ) ALLOCATE ( snow_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lat_mm5) ) ALLOCATE ( lat_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lon_mm5) ) ALLOCATE ( lon_mm5(ix,jx) )

         IF ( .NOT. ALLOCATED ( msft_wrf) ) ALLOCATE ( msft_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfu_wrf) ) ALLOCATE ( msfu_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfv_wrf) ) ALLOCATE ( msfv_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( sina_wrf) ) ALLOCATE ( sina_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( cosa_wrf) ) ALLOCATE ( cosa_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( e_wrf) ) ALLOCATE ( e_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( f_wrf) ) ALLOCATE ( f_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( zeta_z_wrf) ) ALLOCATE ( zeta_z_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( z_zeta_wrf) ) ALLOCATE ( z_zeta_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( psurface_wrf)  ) ALLOCATE ( psurface_wrf(ix,jx)  )

      END IF

      CLOSE(13)
      OPEN ( FILE   = 'wrf_input.d01.'//file_date_string , &
             UNIT   = 13                                 , &
             STATUS = 'OLD'                              , &
             ACCESS = 'SEQUENTIAL'                       , &
             FORM   = 'UNFORMATTED'                        )

      READ (13) ix_mm5,jx_mm5,kx_mm5,mminlu,iswater,gmt,julday,julyr,cen_lat,dx_mm5,&
                map_proj , truelat1 , truelat2 , cen_lon

      !  A simple domain size test.
    
      IF ( ( ix_mm5 .NE. ix ) .OR. ( jx_mm5 .NE. jx ) .OR. ( kx_mm5 .NE. kx ) ) THEN
         PRINT '(A)','Namelist does not match the input data.'
         PRINT '(A,3I5,A)','Namelist dimensions =',ix,jx,kx,'.'
         PRINT '(A,3I5,A)','Input data dimensions =',ix_mm5,jx_mm5,kx_mm5,'.'
         STOP 'Wrong_data_size'
      END IF

      ! How about the grid distance?  Is it the same as in the namelist?

      IF ( ABS ( dx_mm5 - dx ) .GT. 1 ) THEN
         PRINT '(A)','Grid distance differs between input file and namelist.'
         PRINT '(A,F8.1,A)','Grid distance in input file = ',dx_mm5,' m.'
         PRINT '(A,F8.1,A)','Grid distance in namelist = ',dx,' m.'
         STOP 'Wrong_grid_distance'
      END IF

      CALL set_cen_lat ( grid%id , cen_lat )
      CALL set_cen_lon ( grid%id , cen_lon )
      CALL set_truelat1 ( grid%id , truelat1 )
      CALL set_truelat2 ( grid%id , truelat2 )
      CALL set_map_proj ( grid%id , map_proj ) 
      CALL set_mminlu ( mminlu(1:4) )
      CALL set_iswater (grid%id, iswater )
      CALL set_gmt (grid%id, gmt ) 
      CALL set_julyr (grid%id, julyr )
      CALL set_julday (grid%id, julday )

      read_all_the_data : DO

         READ (13,IOSTAT=OK) dummy_char

         IF ( OK .NE. 0 ) THEN
            PRINT '(A,A,A)','End of file found for wrf_input.d01.',file_date_string,'.'
            EXIT read_all_the_data
         END IF

         print *,'name = ',dummy_char

         IF      ( dummy_char(1:8) .EQ. 'ZETAHALF' ) THEN
            READ (13) zetahalf
         ELSE IF ( dummy_char(1:8) .EQ. 'ZETAFULL' ) THEN
            READ (13) zetafull
            IF ( ABS ( zetafull(kx) - ztop ) .GT. 1 ) THEN
               PRINT '(A)','Zetatop differs between input file and namelist.'
               PRINT '(A,F8.1,A)','Zetatop in input file = ',zetafull(kx),' m.'
               PRINT '(A,F8.1,A)','Zetatop in namelist = ',ztop,' m.'
               STOP 'Wrong_grid_distance'
            END IF
         ELSE IF ( dummy_char(1:8) .EQ. 'LATITCRS' ) THEN
            READ (13) lat_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'LONGICRS' ) THEN
            READ (13) lon_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'TERRAIN ' ) THEN 
            READ (13) ter_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'MSFT    ' ) THEN
            READ (13) msft_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'MSFU    ' ) THEN
            READ (13) msfu_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'MSFV    ' ) THEN
            READ (13) msfv_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'PRESSURE' ) THEN
            READ (13) p_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'U       ' ) THEN
            READ (13) u_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'V       ' ) THEN
            READ (13) v_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'THETA   ' ) THEN
            READ (13) theta_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'RHO     ' ) THEN
            READ (13) rho_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'Q       ' ) THEN
            READ (13) q_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'PSURFACE' ) THEN
            READ (13) psurface_wrf 
         ELSE IF ( dummy_char(1:8) .EQ. 'WEASD   ' ) THEN
            READ (13) dummy
         ELSE IF ( dummy_char(1:8) .EQ. 'GROUND T' ) THEN
            READ (13) tg_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'RES TEMP' ) THEN
            READ (13) res_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'SOILT010' ) THEN
            READ (13) soilt010_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'SOILT200' ) THEN
            READ (13) soilt200_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'SOILT400' ) THEN
            READ (13) dummy
         ELSE IF ( dummy_char(1:8) .EQ. 'SOILM010' ) THEN
            READ (13) soilm010_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'SOILM200' ) THEN
            READ (13) soilm200_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'SEAICE  ' ) THEN
            READ (13) seaice_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'LANDSEA ' ) THEN
            READ (13) dummy
         ELSE IF ( dummy_char(1:8) .EQ. 'LANDMASK' ) THEN
            READ (13) landmask_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'LAND USE' ) THEN
            READ (13) landuse_mm5
         ELSE IF ( dummy_char(1:8) .EQ. 'COSA    ' ) THEN
            READ (13) cosa_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'SINA    ' ) THEN
            READ (13) sina_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'F       ' ) THEN
            READ (13) f_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'E       ' ) THEN
            READ (13) e_wrf
         ELSE IF ( dummy_char(1:8) .EQ. 'SNOWCOVR' ) THEN
            READ (13) snow_mm5
         ELSE
            READ (13) dummy
         END IF
 
         print *,' '

      END DO read_all_the_data

      CLOSE (13)

      first_time_in = .FALSE.

   END SUBROUTINE read_mm5

   SUBROUTINE read_generic ( grid , ix , jx , kx , dx , ztop , file_date_string )

      USE module_domain
      USE module_io_mm5

      IMPLICIT NONE

      TYPE(domain) , INTENT(INOUT)  :: grid
      INTEGER , INTENT(IN) :: ix , jx , kx
      REAL , INTENT(IN) :: dx , ztop
      CHARACTER (LEN=19) , INTENT(IN) :: file_date_string

      REAL , DIMENSION(jx,ix) :: dum2d
     
      INTEGER :: i , j , k , loop

      REAL :: dummy

      CHARACTER (LEN= 8) :: dummy_char

      INTEGER :: ok

      !  Get the space for the data if this is the first time here.

      IF ( first_time_in ) THEN
         
         IF ( .NOT. ALLOCATED ( zetafull) ) ALLOCATE ( zetafull(kx) )
         IF ( .NOT. ALLOCATED ( zetahalf) ) ALLOCATE ( zetahalf(kx) )

         IF ( .NOT. ALLOCATED ( u_mm5) ) ALLOCATE ( u_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( v_mm5) ) ALLOCATE ( v_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( q_mm5) ) ALLOCATE ( q_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( p_mm5) ) ALLOCATE ( p_mm5(ix,jx,kx) )
         IF ( .NOT. ALLOCATED ( theta_mm5) ) ALLOCATE ( theta_mm5(ix,jx,kx) )

         IF ( .NOT. ALLOCATED ( tg_mm5) ) ALLOCATE ( tg_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( res_mm5) ) ALLOCATE ( res_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt010_mm5) ) ALLOCATE ( soilt010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt200_mm5) ) ALLOCATE ( soilt200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilt400_mm5) ) ALLOCATE ( soilt400_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm010_mm5) ) ALLOCATE ( soilm010_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( soilm200_mm5) ) ALLOCATE ( soilm200_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( seaice_mm5) ) ALLOCATE ( seaice_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( ter_mm5) ) ALLOCATE ( ter_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landuse_mm5) ) ALLOCATE ( landuse_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( landmask_mm5) ) ALLOCATE ( landmask_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( snow_mm5) ) ALLOCATE ( snow_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lat_mm5) ) ALLOCATE ( lat_mm5(ix,jx) )
         IF ( .NOT. ALLOCATED ( lon_mm5) ) ALLOCATE ( lon_mm5(ix,jx) )

         IF ( .NOT. ALLOCATED ( msft_wrf) ) ALLOCATE ( msft_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfu_wrf) ) ALLOCATE ( msfu_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( msfv_wrf) ) ALLOCATE ( msfv_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( sina_wrf) ) ALLOCATE ( sina_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( cosa_wrf) ) ALLOCATE ( cosa_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( e_wrf) ) ALLOCATE ( e_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( f_wrf) ) ALLOCATE ( f_wrf(ix,jx) )
         IF ( .NOT. ALLOCATED ( psurface_wrf)  ) ALLOCATE ( psurface_wrf(ix,jx)  )

      END IF

      !  Check the i,j,k dimensions against ix,jx,kx.

      !  Set mminlu, iswater, gmt, julyr, julday, cen_lat

      !  Loop over all of the data.

      first_time_in = .FALSE.

   END SUBROUTINE read_generic

END MODULE module_si_io
