!WRF:MODEL_LAYER:INITIALIZATION
!

!  This MODULE holds the routines which are used to perform model start-up operations
!  for the individual domains.  This is the stage after inputting wrfinput and before
!  calling 'integrate'.

!  This MODULE CONTAINS the following routines:


MODULE module_start

   USE module_domain
!  USE module_io_domain
   USE module_state_description
   USE module_model_constants
   USE module_bc
!  USE module_timing
   USE module_configure
   USE module_date_time
#ifdef DM_PARALLEL
   USE module_dm
#endif


CONTAINS

!-------------------------------------------------------------------
! this is a wrapper for the solver-specific start_domain routines.
! Also dereferences the grid variables and passes them down as arguments.
! This is crucial, since the lower level routines may do message passing
! and this will get fouled up on machines that insist on passing down
! copies of assumed-shape arrays (by passing down as arguments, the 
! data are treated as assumed-size -- ie. f77 -- arrays and the copying
! business is avoided).  Fie on the F90 designers.  Fie and a pox.

   SUBROUTINE start_domain ( grid )

   IMPLICIT NONE

   !  Input data.
   TYPE (domain), POINTER :: grid 
   !  Local data.
   INTEGER                :: dyn_opt 
   INTEGER :: idum1, idum2

#ifdef DEREF_KLUDGE
   INTEGER     :: sm31 , em31 , sm32 , em32 , sm33 , em33
#endif

#ifdef DEREF_KLUDGE
   sm31             = grid%sm31
   em31             = grid%em31
   sm32             = grid%sm32
   em32             = grid%em32
   sm33             = grid%sm33
   em33             = grid%em33
#endif

   CALL get_dyn_opt( dyn_opt )
   
   CALL set_scalar_indices_from_config ( head_grid%id , idum1, idum2 )

   CALL start_domain_rk( grid, &
!
#include <rk_actual_args.inc>
!
                        )

   END SUBROUTINE start_domain

!-------------------------------------------------------------------

   SUBROUTINE start_domain_rk ( grid, &
!
# include <rk_dummy_args.inc>
!
)
   USE module_model_constants
   IMPLICIT NONE

   !  Input data.
   TYPE (domain), POINTER :: grid

# include <rk_dummy_arg_defines.inc>

   TYPE (grid_config_rec_type)              :: config_flags

   !  Local data
   INTEGER                             ::                       &
                                  ids, ide, jds, jde, kds, kde, &
                                  ims, ime, jms, jme, kms, kme, &
                                  its, ite, jts, jte, kts, kte, &
                                  i, j, k, loop, error


#ifdef DM_PARALLEL
#  ifdef RSL
#    include <rsl_rk_data_calls.inc>
#  endif
#endif

   SELECT CASE ( model_data_order )
         CASE ( DATA_ORDER_ZXY )
   kds = grid%sd31 ; kde = grid%ed31 ;
   ids = grid%sd32 ; ide = grid%ed32 ;
   jds = grid%sd33 ; jde = grid%ed33 ;

   kms = grid%sm31 ; kme = grid%em31 ;
   ims = grid%sm32 ; ime = grid%em32 ;
   jms = grid%sm33 ; jme = grid%em33 ;

   kts = grid%sp31 ; kte = grid%ep31 ;   ! note that tile is entire patch
   its = grid%sp32 ; ite = grid%ep32 ;   ! note that tile is entire patch
   jts = grid%sp33 ; jte = grid%ep33 ;   ! note that tile is entire patch
         CASE ( DATA_ORDER_XYZ )
   ids = grid%sd31 ; ide = grid%ed31 ;
   jds = grid%sd32 ; jde = grid%ed32 ;
   kds = grid%sd33 ; kde = grid%ed33 ;

   ims = grid%sm31 ; ime = grid%em31 ;
   jms = grid%sm32 ; jme = grid%em32 ;
   kms = grid%sm33 ; kme = grid%em33 ;

   its = grid%sp31 ; ite = grid%ep31 ;   ! note that tile is entire patch
   jts = grid%sp32 ; jte = grid%ep32 ;   ! note that tile is entire patch
   kts = grid%sp33 ; kte = grid%ep33 ;   ! note that tile is entire patch
         CASE ( DATA_ORDER_XZY )
   ids = grid%sd31 ; ide = grid%ed31 ;
   kds = grid%sd32 ; kde = grid%ed32 ;
   jds = grid%sd33 ; jde = grid%ed33 ;

   ims = grid%sm31 ; ime = grid%em31 ;
   kms = grid%sm32 ; kme = grid%em32 ;
   jms = grid%sm33 ; jme = grid%em33 ;

   its = grid%sp31 ; ite = grid%ep31 ;   ! note that tile is entire patch
   kts = grid%sp32 ; kte = grid%ep32 ;   ! note that tile is entire patch
   jts = grid%sp33 ; jte = grid%ep33 ;   ! note that tile is entire patch

   END SELECT


   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )

! here we check to see if the boundary conditions are set properly

   call boundary_condition_check( config_flags, bdyzone, error, grid%id )

    grid%itimestep=0
   
   IF (config_flags%specified)THEN
!
! Arrays for specified boundary conditions
!

     DO loop = spec_zone + 1, spec_zone + relax_zone
       fcx(loop) = 0.1 / dt * (spec_zone + relax_zone - loop) / (relax_zone - 1)
       gcx(loop) = 1.0 / dt / 50. * (spec_zone + relax_zone - loop) / (relax_zone - 1)
     ENDDO

   ENDIF

!
! Set time-step dependent constants here to allow changing timestep
! without having to rerun ideal.exe
!
   resm = (1.-epssm)/(1.+epssm)
   dts    = ( dt / float(time_step_sound) )
   dtseps = .5 * dts * ( 1. + epssm )

   DO k = kts, kte-1
     cofrz(k) = dtseps * rdzw(k)
   ENDDO

   DO j = jts,MIN(jte,jde-1)
     DO i = its,MIN(ite,kde-1)
       cofwr(i,j)=.5 * dtseps * g * zeta_z(i,j)
     ENDDO
   ENDDO

   CALL wrf_debug ( 100 , 'module_start: start_domain_rk: Before call to phy_init' )

   CALL phy_init   (  grid%id , config_flags, DT, TSK, RADT,BLDT,CUDT,  &
                      RTHCUTEN, RQVCUTEN, RQRCUTEN,           &
                      RQCCUTEN, RQSCUTEN, RQICUTEN,           &
                      RUBLTEN,RVBLTEN,RTHBLTEN,               &
                      RQVBLTEN,RQCBLTEN,RQIBLTEN,             &
                      RTHRATEN,RTHRATENLW,RTHRATENSW,         &
                      STEPBL,STEPRA,STEPCU,                   &
                      W0AVG, RAINNC, RAINC, RAINCV, NCA,      &
                      CLDEFI,LOWLYR,                          &
                      CLDFRA,GLW,GSW,EMISS,LU_INDEX,          &
                      XLAT,XLONG,ALB,GMT,JULYR,JULDAY,        &
                      TMN,XLAND,ZNT,UST,MOL,PBLH,             &
                      THC,SNOWC,MAVAIL,HFX,QFX,               &
                      TSLB,ZS,DZS,num_soil_layers,            &
                      ids, ide, jds, jde, kds, kde,           &
                      ims, ime, jms, jme, kms, kme,           &
                      its, ite, jts, jte, kts, kte           )

   CALL wrf_debug ( 100 , 'module_start: start_domain_rk: After call to phy_init' )

!
!

 !  set physical boundary conditions for all initialized variables

#  ifdef DM_PARALLEL

   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_INIT , &
                            config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_MOIST , &
                            config_flags%periodic_x , config_flags%periodic_y )
   CALL wrf_dm_boundary( grid%domdesc , grid%comms , PERIOD_BDY_RK_CHEM , &
                            config_flags%periodic_x , config_flags%periodic_y )
#  endif

   CALL set_physical_bc3d( ru_1 , 'U' , config_flags ,                  &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( ru_2 , 'U' , config_flags ,                  &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rv_1 , 'V' , config_flags ,                  &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( rv_2 , 'V' , config_flags ,                  &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rom_1 , 'W' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( rom_2 , 'W' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( r , 't' , config_flags ,                     &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rtp_1 , 'r' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( rtp_2 , 'r' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rr_1  , 't' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( rr_2  , 't' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rrp_1 , 't' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( rrp_2 , 't' , config_flags ,                 &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   IF (num_moist > 0) THEN

! use of (:,:,:,loop) not efficient on DEC, but (ims,kms,jms,loop) not portable to SGI/Cray

      loop_3d_m   : DO loop = 1 , num_moist
         CALL set_physical_bc3d( moist_1(:,:,:,loop) , 'r' , config_flags ,                 &
                                 ids , ide , jds , jde , kds , kde ,        &
                                 ims , ime , jms , jme , kms , kme ,        &
                                 its , ite , jts , jte , kts , kte ,        &
                                 its , ite , jts , jte , kts , kte )
         CALL set_physical_bc3d( moist_2(:,:,:,loop) , 'r' , config_flags ,                 &
                                 ids , ide , jds , jde , kds , kde ,        &
                                 ims , ime , jms , jme , kms , kme ,        &
                                 its , ite , jts , jte , kts , kte ,        &
                                 its , ite , jts , jte , kts , kte )
      END DO loop_3d_m

   ENDIF

   IF (num_chem >= PARAM_FIRST_SCALAR ) THEN

! use of (:,:,:,loop) not efficient on DEC, but (ims,kms,jms,loop) not portable to SGI/Cray

      loop_3d_c   : DO loop = PARAM_FIRST_SCALAR , num_chem
         CALL set_physical_bc3d( chem_1(:,:,:,loop) , 'r' , config_flags ,                 &
                                 ids , ide , jds , jde , kds , kde ,        &
                                 ims , ime , jms , jme , kms , kme ,        &
                                 its , ite , jts , jte , kts , kte ,        &
                                 its , ite , jts , jte , kts , kte )
         CALL set_physical_bc3d( chem_2(:,:,:,loop) , 'r' , config_flags ,                 &
                                 ids , ide , jds , jde , kds , kde ,        &
                                 ims , ime , jms , jme , kms , kme ,        &
                                 its , ite , jts , jte , kts , kte ,        &
                                 its , ite , jts , jte , kts , kte )
      END DO loop_3d_c

   ENDIF

   CALL set_physical_bc3d( rtb , 'r' , config_flags ,                   &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( rrb , 'r' , config_flags ,                   &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc3d( pib , 'r' , config_flags ,                   &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

   CALL set_physical_bc2d( ht , 'r' , config_flags ,                &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   )
   CALL set_physical_bc2d( msft , 'r' , config_flags ,              &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   )
   CALL set_physical_bc2d( msfu , 'x' , config_flags ,              &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( msfv , 'y' , config_flags ,              &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( sina , 'r' , config_flags ,              &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( cosa , 'r' , config_flags ,              &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( e , 'r' , config_flags ,                 &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( f , 'r' , config_flags ,                 &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( z_zeta , 't' , config_flags ,            &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( zeta_z , 't' , config_flags ,            &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   ) 
   CALL set_physical_bc2d( cofwr , 'r' , config_flags ,             &
                         ids , ide , jds , jde , &
                         ims , ime , jms , jme , &
                         its , ite , jts , jte , &
                         its , ite , jts , jte   )
   CALL set_physical_bc3d( z , 'r' , config_flags ,                     &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( zx , 'x' , config_flags ,                    &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )
   CALL set_physical_bc3d( zy , 'y' , config_flags ,                    &
                         ids , ide , jds , jde , kds , kde ,        &
                         ims , ime , jms , jme , kms , kme ,        &
                         its , ite , jts , jte , kts , kte ,        &
                         its , ite , jts , jte , kts , kte )

!-----------------------------------------------------------------------

!  Stencils for patch communications  (WCS, 9 february 1999).

!  Here is the first and only place for distributed memory communications
!  in the initialization routines.  All other communications
!  are in the solver (subroutine solve; in solve.F)

!  We will fill in the halo region and possibly boundary regions of the
!  patches

!         *        * * *
!       * + *      * + *
!         *        * * *

! ru_1               x
! ru_2               x
! rv_1               x
! rv_2               x
! rom_1   x
! rom_2   x
! r       x
! rtp_1   x
! rtp_2   x
! rr_1    x
! rr_2    x
! rrp_1   x
! rrp_2   x
! rtb     x
! rrb     x
! pib     x
!   z     x
!  zx     x
!  zy     x

! 2d vars
! ht      x
! msft    x
! msfu    x
! msfv    x
! sina    x
! cosa    x
!   e     x
!   f     x

!--------------------------------------------------------------

#ifdef DM_PARALLEL
   CALL wrf_dm_halo ( grid%domdesc , grid%comms , HALO_RK_INIT )
#endif

     CALL wrf_debug ( 100 , 'module_start: start_domain_rk: Returning' )

     RETURN

   END SUBROUTINE start_domain_rk

   SUBROUTINE init_module_start
   END SUBROUTINE init_module_start
   
   SUBROUTINE restart (     ru_1 , ru_2 , rv_1 , rv_2 ,       &
                            rom_1 , rom_2 , rtp_1 , rtp_2 ,   &
                            rrp_1 , rrp_2 , rr_1 , rr_2 ,     &
                            rtb , rrb , &
                            ids , ide , jds , jde , kds , kde ,        &
                            ims , ime , jms , jme , kms , kme         )

!  This subroutine is a place-holder until something more general is coded.
!  It inputs a file of 2d arrays (output from joe_test1.F) and assumes that
!  the WRF domain matches.

   IMPLICIT NONE
  
   ! Input data

   INTEGER ,                                   INTENT(IN   ) :: ids, ide, jds, jde, kds, kde, &
                                                                ims, ime, jms, jme, kms, kme
  
   REAL , DIMENSION( ims: , kms: , jms: ) , INTENT(INOUT) :: ru_1 , rv_1 , rom_1 , &
                                                             rtp_1, rrp_1 , rr_1
   REAL , DIMENSION( ims: , kms: , jms: ) , INTENT(INOUT) :: ru_2 , rv_2 , rom_2 , &
                                                             rtp_2, rrp_2 , rr_2
   REAL , DIMENSION( ims: , kms: , jms: ) ,   INTENT(INOUT) :: rtb , rrb

!  Local data

   INTEGER :: i,j,k

   REAL , DIMENSION(kds:kde-1,ids-1:ide) :: ru1j,ruj
   REAL , DIMENSION(kds:kde,ids:ide) :: rw1j,rwj
   REAL , DIMENSION(kds:kde-1,ids:ide) :: rv1j,rvj,rt1j,rtj,rr1j,rrj,rhoj,rbj,rtbJ


      print *,'READ IN ALL FIELDS FROM UNIT 8'
      read(8)ru1j,ruj,rv1j,rvj,rw1j,rwj,rt1j,rtj,rr1j,rrj,rhoj,rbj,rtbj

   DO j = jds, jde-1
      DO i = ids, ide-1
         DO k = ids, kde-1
            ru_1(i,k,j)=ru1j(k,i-1)
            ru_2(i,k,j)=ruj(k,i-1)
            if(i.eq.ide)then
              ru_1(i+1,k,j)=ru1j(k,i)
              ru_2(i+1,k,j)=ruj(k,i)
            endif
            rv_1(i,k,j)=rv1j(k,i)
            rv_2(i,k,j)=rvj(k,i)
            rom_1(i,k,j)=rw1j(k,i)
            rom_2(i,k,j)=rwj(k,i)
            if(k.eq.kde)then
              rom_1(i,k+1,j)=rw1j(k+1,i)
              rom_2(i,k+1,j)=rwj(k+1,i)
            endif
            rtp_1(i,k,j)=rt1j(k,i)
            rtp_2(i,k,j)=rtj(k,i)
            rrp_1(i,k,j)=rr1j(k,i)
            rrp_2(i,k,j)=rrj(k,i)
            rtb(i,k,j)=rtbj(k,i)
            rrb(i,k,j)=rbj(k,i)
            rr_1(i,k,j)=rrp_1(i,k,j)+rrb(i,k,j)
            rr_2(i,k,j)=rrp_2(i,k,j)+rrb(i,k,j)
         END DO
      END DO
   END DO
   END SUBROUTINE restart



!=================================================================
   SUBROUTINE phy_init ( id, config_flags, DT,TSK,RADT,BLDT,CUDT,&
                         RTHCUTEN, RQVCUTEN, RQRCUTEN,           &
                         RQCCUTEN, RQSCUTEN, RQICUTEN,           &
                         RUBLTEN,RVBLTEN,RTHBLTEN,               &
                         RQVBLTEN,RQCBLTEN,RQIBLTEN,             &
                         RTHRATEN,RTHRATENLW,RTHRATENSW,	 &
                         STEPBL,STEPRA,STEPCU,                   &
                         W0AVG, RAINNC, RAINC, RAINCV, NCA,      &
                         CLDEFI,LOWLYR,                          &
                         CLDFRA,GLW,GSW,EMISS,LU_INDEX,          &
	                 XLAT,XLONG,ALB,GMT,JULYR,JULDAY,        &
                         TMN,XLAND,ZNT,UST,MOL,PBLH,             &
	                 THC,SNOWC,MAVAIL,HFX,QFX,               &
                         TSLB,ZS,DZS,num_soil_layers,            &                  
                         ids, ide, jds, jde, kds, kde,           &
                         ims, ime, jms, jme, kms, kme,           &
                         its, ite, jts, jte, kts, kte           )
!-----------------------------------------------------------------
   USE module_wrf_error
   IMPLICIT NONE
!-----------------------------------------------------------------
   TYPE (grid_config_rec_type)              :: config_flags

   INTEGER , INTENT(IN)        :: id
   INTEGER , INTENT(IN)        :: ids, ide, jds, jde, kds, kde,  &
                                  ims, ime, jms, jme, kms, kme,  &
                                  its, ite, jts, jte, kts, kte

   INTEGER , INTENT(IN)        :: num_soil_layers

   REAL,     INTENT(IN)        :: DT
   REAL,     INTENT(IN)        :: RADT,BLDT,CUDT 

   REAL,     DIMENSION( ims: , jms: ) , INTENT(IN) :: TSK, XLAT, XLONG, &
                                                      SNOWC

! rad

   REAL,     DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) ::    &
             RTHRATEN, RTHRATENLW, RTHRATENSW, CLDFRA

   REAL,     DIMENSION( ims: , jms: ) , INTENT(INOUT) ::         &
             GSW,ALB,GLW,EMISS

   REAL,     INTENT(OUT) :: GMT

   INTEGER , INTENT(OUT) :: STEPRA, STEPBL, STEPCU, JULYR, JULDAY

! cps

   REAL,     DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) ::    &
             RTHCUTEN, RQVCUTEN, RQRCUTEN, RQCCUTEN, RQSCUTEN,   &
             RQICUTEN

   REAL,     DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) :: W0AVG

   REAL,     DIMENSION( ims: , jms: ) , INTENT(OUT) ::           &
             RAINNC, RAINC, RAINCV

   REAL,     DIMENSION( ims: , jms: ) , INTENT(OUT) :: CLDEFI

   INTEGER,  DIMENSION( ims: , jms: ) , INTENT(OUT) :: NCA, LOWLYR

!pbl

   ! soil layer

   REAL,     DIMENSION( ims: , 1: , jms: ), INTENT(OUT) :: TSLB

   REAL,     DIMENSION(1:),      INTENT(OUT) :: ZS,DZS

   REAL,     DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) ::    &
             RUBLTEN,RVBLTEN,RTHBLTEN,RQVBLTEN,RQCBLTEN,RQIBLTEN

   REAL,     DIMENSION( ims: , jms: ) , INTENT(INOUT) ::         &
             XLAND,ZNT,UST,MOL,LU_INDEX,                         &
             PBLH,THC,MAVAIL,HFX,QFX         

   REAL,     DIMENSION( ims: , jms: ) , INTENT(IN   ) :: TMN

! Local data

   REAL    :: ALBLND,ZZLND,ZZWTR,THINLD,XMAVA,CEN_LAT 
   
   CHARACTER*4 :: MMINLU
   CHARACTER*80 :: char_junk
   INTEGER :: ISWATER

   INTEGER :: i, j, itf, jtf

!-----------------------------------------------------------------

!-- should be from the namelist

   CALL wrf_debug(100,'top of phy_init')

   itf=min0(ite,ide-1)
   jtf=min0(jte,jde-1)

   IF ( config_flags%time_step_begin_restart .EQ. 0 ) THEN
     CALL geth_julgmt(julyr,julday, gmt)
   END IF

   ZZLND=0.1
   ZZWTR=0.0001
   THINLD=0.04
   ALBLND=0.2
   XMAVA=0.3
   CALL get_cen_lat(id,cen_lat)
   print*,'cen_lat=',cen_lat
   CALL wrf_debug(100,'calling get_iswater, mminlu')
   CALL get_iswater(id,iswater)
   CALL get_mminlu( mminlu )
   CALL wrf_debug(100,'after get_iswater, mminlu')


!-- initialize common variables

   DO j=jts,jtf
   DO i=its,itf
      XLAND(i,j)=1.
      GSW(i,j)=0.
      GLW(i,j)=0.
      UST(i,j)=0.
      MOL(i,j)=0.0
      PBLH(i,j)=0.0
      HFX(i,j)=0.
      QFX(i,j)=0.
   ENDDO
   ENDDO

   DO j=jts,jtf
   DO i=its,itf
     IF(XLAND(i,j) .LT. 1.5)THEN
       ALB(i,j)=ALBLND
       EMISS(i,j)=0.85
       THC(i,j)=THINLD
       ZNT(i,j)=ZZLND
       MAVAIL(i,j)=XMAVA
     ELSE
       ALB(i,j)=0.08
       EMISS(i,j)=0.98
       THC(i,j)=THINLD
       ZNT(i,j)=ZZWTR
       MAVAIL(i,j)=1.0 
     ENDIF
   ENDDO
   ENDDO

   CALL wrf_debug ( 200 , 'module_start: phy_init: Before call to landuse_init' )

   IF(mminlu .ne. '    ')THEN
!-- initialize surface properties

     CALL landuse_init(lu_index, snowc, alb, mavail, emiss,       &
                znt, thc, xland, julday, cen_lat, iswater, mminlu,       &
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    ) 
   ENDIF


!-- initialize physics
!-- ra: radiation
!-- bl: pbl
!-- cu: cumulus
!-- mp: microphysics

   CALL wrf_debug ( 200 , 'module_start: phy_init: Before call to ra_init' )

   CALL ra_init(STEPRA,RADT,DT,RTHRATEN,RTHRATENLW,             &
                RTHRATENSW,CLDFRA,cen_lat,config_flags,         & 
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    )

   CALL wrf_debug ( 200 , 'module_start: phy_init: Before call to bl_init' )

   CALL bl_init(STEPBL,BLDT,DT,RUBLTEN,RVBLTEN,RTHBLTEN,        &
                RQVBLTEN,RQCBLTEN,RQIBLTEN,TSK,TMN,             &
                config_flags,                                   &
                TSLB,ZS,DZS,num_soil_layers,                    & 
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    )

   CALL wrf_debug ( 200 , 'module_start: phy_init: Before call to cu_init' )

   CALL cu_init(STEPCU,CUDT,DT,RTHCUTEN,RQVCUTEN,RQRCUTEN,      &
                RQCCUTEN,RQSCUTEN,RQICUTEN,NCA,RAINC,           &
                RAINCV,W0AVG,config_flags,                      &
                CLDEFI,LOWLYR,                                  &
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    )

   CALL wrf_debug ( 200 , 'module_start: phy_init: Before call to mp_init' )

   CALL mp_init(RAINNC,config_flags,                            &
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    )

   print*,'STEPRA,STEPCU,STEPBL',STEPRA,STEPCU,STEPBL

   END SUBROUTINE phy_init

!=====================================================================
   SUBROUTINE landuse_init(lu_index, snowc, alb, mavail, emiss, &
                znt, thc, xland, julday, cen_lat, iswater, mminlu,  &
                ids, ide, jds, jde, kds, kde,                   &
                ims, ime, jms, jme, kms, kme,                   &
                its, ite, jts, jte, kts, kte                    )

   USE module_wrf_error
   IMPLICIT NONE

!---------------------------------------------------------------------
   INTEGER , INTENT(IN)           :: ids, ide, jds, jde, kds, kde,   &
                                     ims, ime, jms, jme, kms, kme,   &
                                     its, ite, jts, jte, kts, kte

   INTEGER , INTENT(IN)           :: iswater, julday
   REAL    , INTENT(IN)           :: cen_lat
   CHARACTER*4, INTENT(IN)        :: mminlu
   REAL,     DIMENSION( ims: , jms: ) , INTENT(IN   ) :: lu_index, snowc
   REAL,     DIMENSION( ims: , jms: ) , INTENT(OUT  ) :: alb, mavail, emiss, &
                                                         znt, thc, xland

!---------------------------------------------------------------------
! Local
   CHARACTER*4 LUTYPE
   INTEGER  :: ISICE, LUCATS, LUSEAS
   INTEGER  :: landuse_unit, LS, LC, LI, LUN, NSN
   INTEGER  :: i, j, itf, jtf, is, isn
   INTEGER , PARAMETER :: max_cats = 100 , max_seas = 12 
   REAL, DIMENSION( max_cats, max_seas ) :: ALBD, SLMO, SFEM, SFZ0, THERIN, SFHC
   REAL, DIMENSION( max_cats )     :: SCFX
   LOGICAL :: FOUND_LU
   LOGICAL, EXTERNAL :: wrf_on_monitor

!---------------------------------------------------------------------
      CALL wrf_debug( 100 , 'top of landuse_init' )
      landuse_unit = 29
      IF ( wrf_on_monitor() ) THEN
        OPEN(landuse_unit, FILE='LANDUSE.TBL',FORM='FORMATTED',STATUS='OLD')
      ENDIF
! Determine season (summer=1, winter=2)
      ISN=1                                                            
      IF(JULDAY.LT.105.OR.JULDAY.GT.288)ISN=2                         
      IF(CEN_LAT.LT.0.0)ISN=3-ISN                                   

! Read info from file LANDUSE.TBL
      IF(MMINLU.EQ.'OLD ')THEN
!       ISWATER=7
        ISICE=11 
      ELSE IF(MMINLU.EQ.'USGS')THEN
!       ISWATER=16
        ISICE=24
      ELSE IF(MMINLU.EQ.'SiB ')THEN
!       ISWATER=15
        ISICE=16
      ENDIF
      PRINT *, 'INPUT LANDUSE = ',MMINLU
        FOUND_LU = .FALSE.
 1999   CONTINUE                                                      
      if ( wrf_on_monitor() ) then
        READ (landuse_unit,2000,END=2001)LUTYPE                                
        READ (landuse_unit,*)LUCATS,LUSEAS                                    
        FOUND_LU = LUTYPE.EQ.MMINLU
      endif
      CALL wrf_dm_bcast_bytes (lucats,  IWORDSIZE )
      CALL wrf_dm_bcast_bytes (luseas,  IWORDSIZE )
      CALL wrf_dm_bcast_bytes (found_lu,  LWORDSIZE )
 2000   FORMAT (A4)                                                
        IF(FOUND_LU)THEN                                  
          LUN=LUCATS                                             
          NSN=LUSEAS                                            
            PRINT *, 'LANDUSE TYPE = ',LUTYPE,' FOUND',        &
                   LUCATS,' CATEGORIES',LUSEAS,' SEASONS',     &
                   ' WATER CATEGORY = ',ISWATER,               &
                   ' SNOW CATEGORY = ',ISICE                
        ENDIF                                             
        DO LS=1,LUSEAS                                   
          if ( wrf_on_monitor() ) then
            READ (landuse_unit,*)                                   
          endif
          DO LC=1,LUCATS                               
            IF(FOUND_LU)THEN                  
              IF ( wrf_on_monitor() ) THEN
                READ (landuse_unit,*)LI,ALBD(LC,LS),SLMO(LC,LS),SFEM(LC,LS),        &       
                           SFZ0(LC,LS),THERIN(LC,LS),SCFX(LC),SFHC(LC,LS)       
              ENDIF
              CALL wrf_dm_bcast_bytes (LI,  IWORDSIZE )
              IF(LC.NE.LI)CALL wrf_error_fatal ( 'module_start: MISSING LANDUSE UNIT ' )
            ELSE                                                            
              IF ( wrf_on_monitor() ) THEN
                READ (landuse_unit,*)                                                  
              ENDIF
            ENDIF                                                         
          ENDDO                                                          
        ENDDO                                                           
        CALL wrf_dm_bcast_bytes (albd,   max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (slmo,   max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (sfem,   max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (sfz0,   max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (therin, max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (sfhc,   max_cats * max_seas * RWORDSIZE )
        CALL wrf_dm_bcast_bytes (scfx,   max_cats *            RWORDSIZE )

        IF(.NOT. FOUND_LU) GOTO 1999
 2001   CONTINUE                                                      
        IF(.NOT. FOUND_LU)THEN                                         
          CALL wrf_message ( 'LANDUSE IN INPUT FILE DOES NOT MATCH LUTABLE: TABLE NOT USED' )
        ENDIF                                                     

    IF(FOUND_LU)THEN
! Set arrays according to lu_index
      itf = min0(ite, ide-1)
      jtf = min0(jte, jde-1)
      DO j = jts, jtf
        DO i = its, itf
          IS=nint(lu_index(i,j))
          IF(IS.LT.0.OR.IS.GT.LUN)THEN                                        
            WRITE ( wrf_err_message , * ) 'module_start: landuse_init: ERROR: LANDUSE OUTSIDE RANGE =',IS,' AT ',I,J
            CALL wrf_error_fatal ( TRIM ( wrf_err_message ) )
          ENDIF                                                            
!   SET NO-DATA POINTS (IS=0) TO WATER                                    
          IF(IS.EQ.0)THEN                                                
            IS=ISWATER                                                  
          ENDIF                                                        
          ALB(I,J)=ALBD(IS,ISN)/100.                                  
          THC(I,J)=THERIN(IS,ISN)/100.                               
          ZNT(I,J)=SFZ0(IS,ISN)/100.                                
          EMISS(I,J)=SFEM(IS,ISN)                                  
          MAVAIL(I,J)=SLMO(IS,ISN)                                
          IF(IS.NE.ISWATER)THEN                                  
            XLAND(I,J)=1.0                                      
          ELSE                                                 
            XLAND(I,J)=2.0                                    
          ENDIF                                              
        ENDDO
      ENDDO
    ENDIF
    CALL wrf_debug( 100 , 'returning from of landuse_init' )
    RETURN
        
   END SUBROUTINE landuse_init 
!===================================================================== 
   SUBROUTINE ra_init(STEPRA,RADT,DT,RTHRATEN,RTHRATENLW,            & 
                      RTHRATENSW,CLDFRA,cen_lat,config_flags,        & 
                      ids, ide, jds, jde, kds, kde,                  &
                      ims, ime, jms, jme, kms, kme,                  &
                      its, ite, jts, jte, kts, kte                   )
!---------------------------------------------------------------------
   USE module_ra_rrtm
   USE module_ra_sw
   USE module_ra_gsfcsw
!---------------------------------------------------------------------
   IMPLICIT NONE
!---------------------------------------------------------------------
   TYPE (grid_config_rec_type)              :: config_flags

   INTEGER , INTENT(IN)           :: ids, ide, jds, jde, kds, kde,   &
                                     ims, ime, jms, jme, kms, kme,   &
                                     its, ite, jts, jte, kts, kte

   REAL ,    INTENT(IN)           :: DT, RADT, cen_lat

   INTEGER , INTENT(INOUT)        :: STEPRA

   REAL , DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) ::           &
                                                           RTHRATEN, &
							 RTHRATENLW, &
                                         	         RTHRATENSW, &
						 	     CLDFRA
!---------------------------------------------------------------------

!-- calculate radiation time step

    STEPRA = nint(RADT*60./DT)
    STEPRA = max(STEPRA,1)

!-- chose long wave radiation scheme
 
   lwrad_select: SELECT CASE(config_flags%ra_lw_physics)

        CASE (RRTMSCHEME)
             CALL rrtminit(RTHRATEN,RTHRATENLW,CLDFRA,      &
                           ids, ide, jds, jde, kds, kde,    &
                           ims, ime, jms, jme, kms, kme,    &
                           its, ite, jts, jte, kts, kte     )
        CASE DEFAULT

   END SELECT lwrad_select
 
 
!-- initialize short wave radiation scheme
 
   swrad_select: SELECT CASE(config_flags%ra_sw_physics)

        CASE (SWRADSCHEME)
             CALL swinit(RTHRATEN,RTHRATENSW,              &
                         ids, ide, jds, jde, kds, kde,     &
                         ims, ime, jms, jme, kms, kme,     &
                         its, ite, jts, jte, kts, kte      )

        CASE (GSFCSWSCHEME)
             CALL gsfc_swinit(cen_lat)

        CASE DEFAULT

   END SELECT swrad_select

   END SUBROUTINE ra_init

!====================================================================
   SUBROUTINE bl_init(STEPBL,BLDT,DT,RUBLTEN,RVBLTEN,RTHBLTEN,      &
                      RQVBLTEN,RQCBLTEN,RQIBLTEN,TSK,TMN,           &
	              config_flags,				    &
                      TSLB,ZS,DZS,num_soil_layers,                  & 
                      ids, ide, jds, jde, kds, kde,                 &
                      ims, ime, jms, jme, kms, kme,                 &
                      its, ite, jts, jte, kts, kte                  )
!--------------------------------------------------------------------
   USE module_bl_sfclay
   USE module_bl_slab
   USE module_bl_mrf
!--------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------
   TYPE (grid_config_rec_type) ::     config_flags

   INTEGER , INTENT(IN)        ::     ids, ide, jds, jde, kds, kde, &
                                      ims, ime, jms, jme, kms, kme, &
                                      its, ite, jts, jte, kts, kte
   INTEGER , INTENT(IN)        ::     num_soil_layers

   REAL ,    INTENT(IN)        ::     DT, BLDT
   INTEGER , INTENT(INOUT)     ::     STEPBL

   REAL,     DIMENSION( ims: , 1: , jms: ), INTENT(OUT) :: TSLB

   REAL,     DIMENSION(1:), INTENT(OUT)  ::  ZS,DZS

   REAL,     DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) ::       &
                                                           RUBLTEN, &
                                                           RVBLTEN, &
      				   		          RTHBLTEN, &
						          RQVBLTEN, &
					  	          RQCBLTEN, &
 						          RQIBLTEN

   REAL,  DIMENSION( ims: , jms: ) , INTENT(IN   ) ::     TSK, TMN

!--------------------------------------------------------------------

!-- calculate pbl time step

   STEPBL = nint(BLDT*60./DT)
   STEPBL = max(STEPBL,1)

!-- initialize surface layer scheme

   sfclay_select: SELECT CASE(config_flags%bl_sfclay_physics)

      CASE (SFCLAYSCHEME)
           CALL sfclayinit()
      CASE DEFAULT

   END SELECT sfclay_select


!-- initialize surface scheme

   sfc_select: SELECT CASE(config_flags%bl_surface_physics)

      CASE (SLABSCHEME)
           CALL slabinit(TSK,TMN,                              &
                         TSLB,ZS,DZS,num_soil_layers,          & 
                         ids, ide, jds, jde, kds, kde,         &
                         ims, ime, jms, jme, kms, kme,         &
                         its, ite, jts, jte, kts, kte          )
      CASE DEFAULT

   END SELECT sfc_select


!-- initialize pbl scheme

   pbl_select: SELECT CASE(config_flags%bl_pbl_physics)

      CASE (MRFSCHEME)
           CALL mrfinit(RUBLTEN,RVBLTEN,RTHBLTEN,RQVBLTEN,    &
                        RQCBLTEN,RQIBLTEN,P_QI,               &
                        PARAM_FIRST_SCALAR,                   &
                        ids, ide, jds, jde, kds, kde,         &
                        ims, ime, jms, jme, kms, kme,         &
                        its, ite, jts, jte, kts, kte          )
      CASE DEFAULT

   END SELECT pbl_select

   END SUBROUTINE bl_init

!==================================================================
   SUBROUTINE cu_init(STEPCU,CUDT,DT,RTHCUTEN,RQVCUTEN,RQRCUTEN,  &
                      RQCCUTEN,RQSCUTEN,RQICUTEN,NCA,RAINC,       &
                      RAINCV,W0AVG,config_flags,                  &
                      CLDEFI,LOWLYR,                              &
                      ids, ide, jds, jde, kds, kde,               &
                      ims, ime, jms, jme, kms, kme,               &
                      its, ite, jts, jte, kts, kte                )
!------------------------------------------------------------------
   USE module_cu_kf
   USE MODULE_CU_BMJ
!------------------------------------------------------------------
   IMPLICIT NONE
!------------------------------------------------------------------
   TYPE (grid_config_rec_type) ::     config_flags


   INTEGER , INTENT(IN)        :: ids, ide, jds, jde, kds, kde,   &
                                  ims, ime, jms, jme, kms, kme,   &
                                  its, ite, jts, jte, kts, kte

   REAL ,    INTENT(IN)        :: DT, CUDT
   INTEGER , INTENT(INOUT)     :: STEPCU

   REAL ,   DIMENSION( ims: , kms: , jms: ) , INTENT(INOUT) ::    &
            RTHCUTEN, RQVCUTEN, RQCCUTEN, RQRCUTEN, RQICUTEN,     &
            RQSCUTEN

   REAL ,   DIMENSION( ims: , kms: , jms: ) , INTENT(OUT) :: W0AVG

   REAL ,   DIMENSION( ims: , jms: ), INTENT(OUT):: RAINC, RAINCV

   REAL ,   DIMENSION( ims: , jms: ), INTENT(OUT):: CLDEFI

   INTEGER, DIMENSION( ims: , jms: ), INTENT(INOUT):: NCA

   INTEGER, DIMENSION( ims: , jms: ), INTENT(OUT):: LOWLYR

! LOCAL VAR
   
  INTEGER :: i,j,itf,jtf

!--------------------------------------------------------------------

!-- calculate cumulus parameterization time step

   itf=min0(ite,ide-1)
   jtf=min0(jte,jde-1)
!
   STEPCU = nint(CUDT*60./DT)
   STEPCU = max(STEPCU,1)

!-- initialization

   DO j=jts,jtf
   DO i=its,itf
      RAINC(i,j)=0.
      RAINCV(i,j)=0.
   ENDDO
   ENDDO

   cps_select: SELECT CASE(config_flags%cu_physics)

     CASE (KFSCHEME)
          CALL kfinit(RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN,        &
                      RQICUTEN,RQSCUTEN,NCA,W0AVG,P_QI,P_QS,      &
                      PARAM_FIRST_SCALAR,                         &
                      ids, ide, jds, jde, kds, kde,               &
                      ims, ime, jms, jme, kms, kme,               &
                      its, ite, jts, jte, kts, kte                )

     CASE (BMJSCHEME)
          CALL bmjinit(RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN,       &
                      CLDEFI,LOWLYR,cp,r_d,                       &
                      ids, ide, jds, jde, kds, kde,               &
                      ims, ime, jms, jme, kms, kme,               &
                      its, ite, jts, jte, kts, kte                )

     CASE DEFAULT

   END SELECT cps_select

   END SUBROUTINE cu_init

!==================================================================
   SUBROUTINE mp_init(RAINNC,config_flags,                        &
                      ids, ide, jds, jde, kds, kde,               &
                      ims, ime, jms, jme, kms, kme,               &
                      its, ite, jts, jte, kts, kte                )
!------------------------------------------------------------------
   USE module_mp_ncloud3
!------------------------------------------------------------------
   IMPLICIT NONE
!------------------------------------------------------------------
   TYPE (grid_config_rec_type) ::     config_flags

   INTEGER , INTENT(IN)        :: ids, ide, jds, jde, kds, kde,   &
                                  ims, ime, jms, jme, kms, kme,   &
                                  its, ite, jts, jte, kts, kte

   REAL,     DIMENSION( ims: , jms: ) , INTENT(INOUT) :: RAINNC

   INTEGER :: i, j, itf, jtf

   itf=min0(ite,ide-1)
   jtf=min0(jte,jde-1)

   DO j=jts,jtf
   DO i=its,itf
      RAINNC(i,j) = 0.
   ENDDO
   ENDDO

   mp_select: SELECT CASE(config_flags%mp_physics)

     CASE (NCEPCLOUD3)
          CALL ncloud3init(rhoair0,rhowater,rhosnow,cliq,cv)
     CASE DEFAULT

   END SELECT mp_select

   END SUBROUTINE mp_init


END MODULE module_start
