! #define PLOT_HMV
!-----------------------------------------------------------------------
!  This routine does a quick ncar graphics plots for grid

SUBROUTINE quick_look_dump ( grid, time )

   USE module_domain
   USE module_driver_constants
   USE module_model_constants
   USE module_state_description
   USE module_machine
   USE module_bc
   USE module_configure
 
   IMPLICIT NONE

   !  Input data.

   TYPE(domain) , TARGET, INTENT(IN)         :: grid

   REAL, INTENT(IN)                       :: time

   INTEGER, PARAMETER :: XY   =     1
   INTEGER, PARAMETER :: XYU  =     2
   INTEGER, PARAMETER :: XYV  =     3
   INTEGER, PARAMETER :: XZ   =     4
   INTEGER, PARAMETER :: XZW  =     5
   INTEGER, PARAMETER :: XZU  =     6
   INTEGER, PARAMETER :: XZV  =     7
   INTEGER, PARAMETER :: YZ   =     8
   INTEGER, PARAMETER :: YZW  =     9
   INTEGER, PARAMETER :: YZU  =    10
   INTEGER, PARAMETER :: YZV  =    11

   !  Pointers to and copies of domain data
#include <state_defines.inc>

   !  WRF state grid_config_rec_type
   TYPE (grid_config_rec_type)                :: config_flags

   ! WRF state data
   CHARACTER (LEN=80)                   :: plot_label

   !  Local data.
   INTEGER , DIMENSION(:) , ALLOCATABLE :: i_start , i_end , j_start , j_end 
   INTEGER                              :: k_start , k_end
   INTEGER                              :: ids , ide , jds , jde , kds , kde , &
                                           ims , ime , jms , jme , kms , kme , &
                                           ips , ipe , jps , jpe , kps , kpe
   INTEGER                              :: ij , iteration
   INTEGER                              :: im , num_3d_m , ic , num_3d_c
   INTEGER                              :: loop, coarse_grid, label_length
   INTEGER                              :: i,j,k

   ! storage for horizontal output planes (xy slices)

! JM IKJ MODS
#if 0
   REAL , DIMENSION(grid%sp32:grid%ep32  ,grid%sp33:grid%ep33-1) :: xy_plane_u
   REAL , DIMENSION(grid%sp32:grid%ep32-1,grid%sp33:grid%ep33  ) :: xy_plane_v
   REAL , DIMENSION(grid%sp32:grid%ep32-1,grid%sp33:grid%ep33-1) :: xy_plane_m

   ! storage for y-slice vertical output planes (xz slices)

   REAL , DIMENSION(grid%sp32:grid%ep32  ,grid%sp31:grid%ep31-1) :: xz_plane_u
   REAL , DIMENSION(grid%sp32:grid%ep32-1,grid%sp31:grid%ep31  ) :: xz_plane_w
   REAL , DIMENSION(grid%sp32:grid%ep32-1,grid%sp31:grid%ep31-1) :: xz_plane_m

   ! storage for x-slice vertical output planes (yz slices)

   REAL , DIMENSION(grid%sp33:grid%ep33  ,grid%sp31:grid%ep31-1) :: yz_plane_v
   REAL , DIMENSION(grid%sp33:grid%ep33-1,grid%sp31:grid%ep31  ) :: yz_plane_w
   REAL , DIMENSION(grid%sp33:grid%ep33-1,grid%sp31:grid%ep31-1) :: yz_plane_m

   ! storage for y horizontal output line (y line)

   REAL , DIMENSION(grid%sp33:grid%ep33) :: y_line_v
   REAL , DIMENSION(grid%sp33:grid%ep33-1) :: y_line_w
   REAL , DIMENSION(grid%sp33:grid%ep33-1) :: y_line_m, yaxis

#else
   REAL , DIMENSION(grid%sp31:grid%ep31  ,grid%sp33:grid%ep33-1) :: xy_plane_u
   REAL , DIMENSION(grid%sp31:grid%ep31-1,grid%sp33:grid%ep33  ) :: xy_plane_v
   REAL , DIMENSION(grid%sp31:grid%ep31-1,grid%sp33:grid%ep33-1) :: xy_plane_m

   ! storage for y-slice vertical output planes (xz slices)

   REAL , DIMENSION(grid%sp31:grid%ep31  ,grid%sp32:grid%ep32-1) :: xz_plane_u
   REAL , DIMENSION(grid%sp31:grid%ep31-1,grid%sp32:grid%ep32  ) :: xz_plane_w
   REAL , DIMENSION(grid%sp31:grid%ep31-1,grid%sp32:grid%ep32-1) :: xz_plane_m

   ! storage for x-slice vertical output planes (yz slices)

   REAL , DIMENSION(grid%sp33:grid%ep33  ,grid%sp32:grid%ep32-1) :: yz_plane_v
   REAL , DIMENSION(grid%sp33:grid%ep33-1,grid%sp32:grid%ep32  ) :: yz_plane_w
   REAL , DIMENSION(grid%sp33:grid%ep33-1,grid%sp32:grid%ep32-1) :: yz_plane_m

   ! storage for y horizontal output line (y line)

   REAL , DIMENSION(grid%sp33:grid%ep33) :: y_line_v
   REAL , DIMENSION(grid%sp33:grid%ep33-1) :: y_line_w
   REAL , DIMENSION(grid%sp33:grid%ep33-1) :: y_line_m, yaxis

#endif


   REAL , DIMENSION(:,:,:,:),  POINTER :: rm, rc

   REAL :: pxmin, pxmax, pymin, pymax, pitmp

   INTEGER                            :: size1, size2

   LOGICAL :: DEBUG, plot_xy, plot_xz, plot_yz
   INTEGER :: iminr, imaxr, jminr, jmaxr, im1, ir, km1, jm1, jr


#ifndef DM_PARALLEL

   CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags )

   debug = .false.
   plot_xy = .true.
   plot_xz = .true.
   plot_yz = .true.

   !  De-reference the information stored in the grid data structure.

   SELECT CASE ( model_data_order )
      CASE ( DATA_ORDER_ZXY )

   ids             = grid%sd32 
   ide             = grid%ed32 
   jds             = grid%sd33 
   jde             = grid%ed33 
   kds             = grid%sd31 
   kde             = grid%ed31

   ims             = grid%sm32 
   ime             = grid%em32 
   jms             = grid%sm33 
   jme             = grid%em33 
   kms             = grid%sm31 
   kme             = grid%em31

   ips             = grid%sp32
   ipe             = grid%ep32
   jps             = grid%sp33
   jpe             = grid%ep33
   kps             = grid%sp31
   kpe             = grid%ep31

   k_start         = grid%sd31
   k_end           = grid%ed31

      CASE ( DATA_ORDER_XYZ )

   ids             = grid%sd31
   ide             = grid%ed31
   jds             = grid%sd32
   jde             = grid%ed32
   kds             = grid%sd33
   kde             = grid%ed33

   ims             = grid%sm31
   ime             = grid%em31
   jms             = grid%sm32
   jme             = grid%em32
   kms             = grid%sm33
   kme             = grid%em33

   ips             = grid%sp31
   ipe             = grid%ep31
   jps             = grid%sp32
   jpe             = grid%ep32
   kps             = grid%sp33
   kpe             = grid%ep33

   k_start         = grid%sd33
   k_end           = grid%ed33

      CASE ( DATA_ORDER_XZY )

   ids             = grid%sd31
   ide             = grid%ed31
   jds             = grid%sd33
   jde             = grid%ed33
   kds             = grid%sd32
   kde             = grid%ed32

   ims             = grid%sm31
   ime             = grid%em31
   jms             = grid%sm33
   jme             = grid%em33
   kms             = grid%sm32
   kme             = grid%em32

   ips             = grid%sp31
   ipe             = grid%ep31
   jps             = grid%sp33
   jpe             = grid%ep33
   kps             = grid%sp32
   kpe             = grid%ep32

   k_start         = grid%sd32
   k_end           = grid%ed32

   END SELECT


   num_3d_m        = num_moist
   num_3d_c        = num_chem

!
!  NOTE!!!  Here we are assuming that we have the entire
!           domain in one patch!!!
!

   iminr = ids
   imaxr = ide
   jminr = jds
   jmaxr = jde

    IF( config_flags%open_xs ) iminr = ids
    IF( config_flags%open_xe ) imaxr = ide-1
    IF( config_flags%open_ys ) jminr = jds
    IF( config_flags%open_ye ) jmaxr = jde-1

! SEE THIS FILE FOR DEREFERENCE STATEMENTS FROM THE GRID
#include <state_derefs.inc>

!
!  presently, quick ncar graphics plots
!

! output ru, rv, rw, rt, and r

! begin with horizontal cross sections

!  if (time .lt. 7000.) return
  IF(plot_xy) THEN

  label_length = 29
!  k = kpe/2
!   k = 3

   do k=2,kpe,8

! ht -----------------

  DO j=jps,jpe-1
  DO i=ips,ipe-1
    xy_plane_m(i,j) = ht(i,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' HT AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XYU)

! ru -----------------
  DO j=jps,jpe-1
  DO i=ips,ipe
! JM IJK MODS here and all k,i,j below
    xy_plane_u(i,j) = ru_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RU AT TIME ',TIME,' K = ',k
  size1 = ipe-ips+1
  size2 = jpe-jps
  call plot_array (xy_plane_u, size1, size2, plot_label, label_length,XYU)

! rv -----------------

  DO j=jps,jpe
  DO i=ips,ipe-1
    xy_plane_v(i,j) = rv_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RV AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps+1
  call plot_array (xy_plane_v, size1, size2, plot_label, label_length,XYV)

! rw -----------------

  DO j=jps,jpe-1
  DO i=ips,ipe-1
    xy_plane_m(i,j) = rom_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' OM AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XY)


! rt -----------------

  DO j=jps,jpe-1
  DO i=ips,ipe-1
!   xy_plane_m(i,j) = rtp_2(i,k,j) + rtb(i,k,j)
    xy_plane_m(i,j) = rtp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RTM AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XY)

! theta -----------------

  DO j=jps,jpe-1
  DO i=ips,ipe-1
    xy_plane_m(i,j) =(rtp_2(i,k,j)+rtb(i,k,j))/  &
           (rrp_2(i,k,j)+rrb(i,k,j))
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' TH AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XY)

! rr -----------------

  DO j=jps,jpe-1
  DO i=ips,ipe-1
!   xy_plane_m(i,j) = rrp_2(i,k,j) + rrb(i,k,j)
    xy_plane_m(i,j) = rrp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RR AT TIME ',TIME,' K = ',k
  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XY)

! rm -----------------

  DO im = 1, num_3d_m

  DO j=jps,jpe-1
  DO i=ips,ipe-1
    xy_plane_m(i,j) = moist_2(i,k,j,im)
  ENDDO
  ENDDO

!  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RM4 AT TIME ',TIME,' K = ',k
  if(im == P_QV) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QV AT TIME ',TIME,' K = ',k
  if(im == P_QC) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QC AT TIME ',TIME,' K = ',k
  if(im == P_QR) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QR AT TIME ',TIME,' K = ',k
  if(im == P_QI) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QI AT TIME ',TIME,' K = ',k
  if(im == P_QS) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QS AT TIME ',TIME,' K = ',k
  if(im == P_QG) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QG AT TIME ',TIME,' K = ',k

  size1 = ipe-ips
  size2 = jpe-jps
  call plot_array (xy_plane_m, size1, size2, plot_label, label_length,XY)

  ENDDO

  ENDDO

  END IF

  IF (plot_xz) THEN


! next vertical cross sections, xz first

  label_length = 29
!  j = jpe/2-1
  j = jpe/2

! ru -----------------
  DO i=ips,ipe
  DO k=kps,kpe-1
    xz_plane_u(i,k) = ru_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RU AT TIME ',TIME,' J = ',j
  size1 = ipe-ips+1
  size2 = kpe-kps
  call plot_array (xz_plane_u, size1, size2, plot_label, label_length,XZU)

! u -----------------

  DO i=ips,ipe
  DO k=kps,kpe-1

    im1 = max(i-1,iminr)
    ir = min(i,imaxr)

    xz_plane_u(i,k) = ru_2(i,k,j)/  &
               (0.5*(rrb(ir,k,j)+rrp_2(ir,k,j)+rrb(im1,k,j)+rrp_2(im1,k,j)))
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') '  U AT TIME ',TIME,' J = ',j
  size1 = ipe-ips+1
  size2 = kpe-kps
  call plot_array (xz_plane_u, size1, size2, plot_label, label_length,XZU)

! rv -----------------

  DO i=ips,ipe-1
  DO k=kps,kpe-1
    xz_plane_m(i,k) = rv_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RV AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZV)

! rw -----------------

  DO i=ips,ipe-1
  DO k=kps,kpe
    xz_plane_w(i,k) = rom_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' OM AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps+1
  call plot_array (xz_plane_w, size1, size2, plot_label, label_length,XZW)


!  w -----------------

  DO i=ips,ipe-1
  DO k=kps,kpe
    km1 = max(k-1,1)
    xz_plane_w(i,k) = 2.*rom_2(i,k,j)/   &
               (rrb(i,k,j)+rrp_2(i,k,j)+rrb(i,km1,j)+rrp_2(i,km1,j))
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' W  AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps+1
  call plot_array (xz_plane_w, size1, size2, plot_label, label_length,XZW)

! rt -----------------

  DO i=ips,ipe-1
  DO k=kps,kpe-1
!   xz_plane_m(i,k) = rtp_2(i,k,j) + rtb(i,k,j)
    xz_plane_m(i,k) = rtp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RT AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)

! theta -----------------

  IF( num_3d_m > 0 ) THEN

    DO i=ips,ipe-1
    DO k=kps,kpe-1
!      xz_plane_m(i,k) =(rtp_2(i,k,j)/(1.+rvovrd*moist_2(i,k,j,P_QV))+rtb(i,k,j))/  &
!             (rrp_2(i,k,j)+rrb(i,k,j))
      xz_plane_m(i,k) =(rtp_2(i,k,j)+rtb(i,k,j))/(1.+rvovrd*moist_2(i,k,j,P_QV))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))
    ENDDO
    ENDDO

  ELSE

    DO i=ips,ipe-1
    DO k=kps,kpe-1
      xz_plane_m(i,k) =(rtp_2(i,k,j)+rtb(i,k,j))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))
    ENDDO
    ENDDO

  ENDIF

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' TH AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)


! theta' -----------------

  IF( num_3d_m > 0 ) THEN

    DO i=ips,ipe-1
    DO k=kps,kpe-1
      xz_plane_m(i,k) =(rtp_2(i,k,j)+rtb(i,k,j))/(1.+rvovrd*moist_2(i,k,j,P_QV))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))                                        &
              - rtb(i,k,j)/rrb(i,k,j)
    ENDDO
    ENDDO

  ELSE

    DO i=ips,ipe-1
    DO k=kps,kpe-1
      xz_plane_m(i,k) =(rtp_2(i,k,j)+rtb(i,k,j))/  &
             (rrp_2(i,k,j)+rrb(i,k,j)) - rtb(i,k,j)/rrb(i,k,j)
    ENDDO
    ENDDO

  ENDIF

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'THP AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)

! rr -----------------

  DO i=ips,ipe-1
  DO k=kps,kpe-1
!   xz_plane_m(i,k) = rrp_2(i,k,j) + rrb(i,k,j)
    xz_plane_m(i,k) = rrp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RR AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)

! rm -----------------

  DO im = 1, num_3d_m

  DO i=ips,ipe-1
  DO k=kps,kpe-1
    xz_plane_m(i,k) = moist_2(i,k,j,im)
  ENDDO
  ENDDO

!  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RM4 AT TIME ',TIME,' J = ',j

  if(im == P_QV) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QV AT TIME ',TIME,' J = ',j
  if(im == P_QC) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QC AT TIME ',TIME,' J = ',j
  if(im == P_QR) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QR AT TIME ',TIME,' J = ',j
  if(im == P_QI) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QI AT TIME ',TIME,' J = ',j
  if(im == P_QS) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QS AT TIME ',TIME,' J = ',j
  if(im == P_QG) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QG AT TIME ',TIME,' J = ',j

  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)

  ENDDO

  IF(num_3d_m > 0) THEN

  im = P_QV

  DO i=ips,ipe-1
  DO k=kps,kpe-1
    xz_plane_m(i,k) = moist_2(i,k,j,im) - qv_base(k)
  ENDDO
  ENDDO

!  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RM4 AT TIME ',TIME,' J = ',j

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'QVP AT TIME ',TIME,' J = ',j
  size1 = ipe-ips
  size2 = kpe-kps
  call plot_array (xz_plane_m, size1, size2, plot_label, label_length,XZ)

  ENDIF

  END IF

  IF (plot_yz) THEN

! now yz

  label_length = 29
  i = max(1,ipe/2 - 1)

! ru -----------------

#if 1

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = ru_2(i,k,j)
  ENDDO
  ENDDO

#if 1
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RU AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length,YZU)

#else
   write(99,*)jpe-jps+1,kpe-kps+1
   do j = jps,jpe
   do k = kps,kpe
     write(99,*) yz_plane_v(j,k)
   enddo
   enddo
   stop
#endif
#endif


! rv -----------------


  DO j=jps,jpe
  DO k=kps,kpe-1
    yz_plane_v(j,k) = rv_2(i,k,j)
  ENDDO
  ENDDO

#if 1
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RV AT TIME ',TIME,' I = ',i
  size1 = jpe-jps+1
  size2 = kpe-kps
  call plot_array (yz_plane_v, size1, size2, plot_label, label_length,YZV)
#else
   write(99,*)jpe-jps+1,kpe-kps+1
   do j = jps,jpe
   do k = kps,kpe
     write(99,*) yz_plane_v(j,k)
   enddo
   enddo
   stop
#endif


! v -----------------

  DO j=jps,jpe
  DO k=kps,kpe-1
    jm1 = max(j-1,jminr)
    jr = min(j,jmaxr)

    yz_plane_v(j,k) = rv_2(i,k,j)/ &
               (0.5*(rrb(i,k,jr)+rrp_2(i,k,jr)+rrb(i,k,jm1)+rrp_2(i,k,jm1))) &
               - v_base(k)


  ENDDO
  ENDDO

#if 1
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') '  V AT TIME ',TIME,' I = ',i
  size1 = jpe-jps+1
  size2 = kpe-kps
  call plot_array (yz_plane_v, size1, size2, plot_label, label_length,YZV)
#else
   write(99,*)jpe-jps+1,kpe-kps+1
   do j = jps,jpe
   do k = kps,kpe
     write(99,*) yz_plane_v(j,k)
   enddo
   enddo
   stop
#endif

! rw -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe
    yz_plane_w(j,k) = rom_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' OM AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps+1
  call plot_array (yz_plane_w, size1, size2, plot_label, label_length, YZW)

! w -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe
    km1 = max(k-1,1)
    yz_plane_w(j,k) = 2.*rom_2(i,k,j)/ &
               (rrb(i,k,j)+rrp_2(i,k,j)+rrb(i,km1,j)+rrp_2(i,km1,j))
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') '  W AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps+1
  call plot_array (yz_plane_w, size1, size2, plot_label, label_length, YZW)

! rt -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe-1
!   yz_plane_m(j,k) = rtp_2(i,k,j) + rtb(i,k,j)
    yz_plane_m(j,k) = rtp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RT AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! theta -----------------


  IF( num_3d_m > 0 ) THEN

    DO j=jps,jpe-1
    DO k=kps,kpe-1
      yz_plane_m(j,k) =(rtp_2(i,k,j)+rtb(i,k,j))/(1.+rvovrd*moist_2(i,k,j,P_QV))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))
    ENDDO
    ENDDO

  ELSE

    DO j=ips,jpe-1
    DO k=kps,kpe-1
      yz_plane_m(j,k) =(rtp_2(i,k,j)+rtb(i,k,j))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))
    ENDDO
    ENDDO

  ENDIF

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' TH AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! T -----------------

    DO j=jps,jpe-1
    DO k=kps,kpe-1
      pitmp=((pp(i,k,j)+pb(i,k,j))/100000.)**rcp
      yz_plane_m(j,k) = yz_plane_m(j,k)*pitmp
    ENDDO
    ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'T AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! theta' -----------------

  IF( num_3d_m > 0 ) THEN

    DO j=jps,jpe-1
    DO k=kps,kpe-1
      yz_plane_m(j,k) =(rtp_2(i,k,j)+rtb(i,k,j))/(1.+rvovrd*moist_2(i,k,j,P_QV))/  &
             (rrp_2(i,k,j)+rrb(i,k,j))                                        &
              - rtb(i,k,j)/rrb(i,k,j)
    ENDDO
    ENDDO

  ELSE

    DO j=jps,jpe-1
    DO k=kps,kpe-1
      yz_plane_m(j,k) =(rtp_2(i,k,j)+rtb(i,k,j))/  &
             (rrp_2(i,k,j)+rrb(i,k,j)) - rtb(i,k,j)/rrb(i,k,j)
    ENDDO
    ENDDO

  ENDIF

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'THP AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! rr -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe-1
!   yz_plane_m(j,k) = rrp_2(i,k,j) + rrb(i,k,j)
    yz_plane_m(j,k) = rrp_2(i,k,j)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RR AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! rm -----------------

  DO im = 1, num_3d_m

  DO j=jps,jpe-1
  DO k=kps,kpe-1
!    yz_plane_m(j,k) = rr_2(i,k,j)*moist_2(i,k,j,im)
    yz_plane_m(j,k) = moist_2(i,k,j,im)
  ENDDO
  ENDDO

!  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RM4 AT TIME ',TIME,' I = ',i
  if(im == P_QV) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QV AT TIME ',TIME,' I = ',i
  if(im == P_QC) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QC AT TIME ',TIME,' I = ',i
  if(im == P_QR) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QR AT TIME ',TIME,' I = ',i
  if(im == P_QI) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QI AT TIME ',TIME,' I = ',i
  if(im == P_QS) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QS AT TIME ',TIME,' I = ',i
  if(im == P_QG) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' QG AT TIME ',TIME,' I = ',i

  size1 = jpe-jps
  size2 = kpe-kps

  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  IF (im .eq. P_QV) then

  DO j=jps,jpe-1
  DO k=kps,kpe-1

    yz_plane_m(j,k) = moist_2(i,k,j,im) - qv_base(k)
  ENDDO
  ENDDO

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'QVP AT TIME ',TIME,' I = ',i

  size1 = jpe-jps
  size2 = kpe-kps

  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  END IF

  ENDDO

  DO im = 1, num_3d_c

  DO j=jps,jpe-1
  DO k=kps,kpe-1
!    yz_plane_m(j,k) = rr_2(i,k,j)*moist_2(i,k,j,im)
    yz_plane_m(j,k) = chem_2(i,k,j,im)
  ENDDO
  ENDDO

!  write(plot_label, FMT = '(a12,f8.1,a5,i4)') 'RM4 AT TIME ',TIME,' I = ',i
  if(im == 1) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' C1 AT TIME ',TIME,' I = ',i
  if(im == 2) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' C2 AT TIME ',TIME,' I = ',i
  if(im == 3) &
  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' C3 AT TIME ',TIME,' I = ',i

  size1 = jpe-jps
  size2 = kpe-kps

  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  ENDDO

  IF (config_flags%cu_physics .gt. 0) THEN
! RTHCUTEN -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RTHCUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RTHCUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! RQVCUTEN -----------------
  print*,'RQVCUTEN'
  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQVCUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQVCUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! RQCCUTEN -----------------
  print*,'RQCCUTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQCCUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQCCUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! RQRCUTEN -----------------
  print*,'RQRCUTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQRCUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQRCUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  IF (P_QI .gt. 0) THEN

! RQICUTEN -----------------
  print*,'RQICUTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQICUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQICUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  ENDIF

  IF (P_QS .gt. 0) THEN

! RQSCUTEN -----------------
  print*,'RQSCUTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQSCUTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQSCUTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
! call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  ENDIF

  ENDIF

  IF (config_flags%ra_lw_physics .gt. 0 .and. &
      config_flags%ra_sw_physics .gt. 0) THEN

! RTHRATENLW -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RTHRATENLW(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RTHRATENLW AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! RTHRATENSW -----------------

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RTHRATENSW(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RTHRATENSW AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! GLW -----------------

    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = GLW(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

   write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'GLW AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! GSW -----------------

    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = GSW(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

   write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'GSW AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

  ENDIF 

  IF (config_flags%bl_pbl_physics .gt. 0) THEN

! UBLTEN -----------------
  print*,'UBLTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RUBLTEN(i,k,j)
  ENDDO
  ENDDO

   write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' UBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! VBLTEN -----------------
  print*,'VBLTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RVBLTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' VBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! RTHBLTEN -----------------
  print*,'RTHBLTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RTHBLTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RTHBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! QVBLTEN -----------------
  print*,'QVBLTEN'


  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQVBLTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQVBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

! QCBLTEN -----------------
  print*,'QCBLTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQCBLTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQCBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  IF (P_QI .gt. 0) THEN

! RQIBLTEN -----------------
  print*,'QIBLTEN'

  DO j=jps,jpe-1
  DO k=kps,kpe-1
    yz_plane_m(j,k) = RQIBLTEN(i,k,j)
  ENDDO
  ENDDO

  write(20)yz_plane_m

  write(plot_label, FMT = '(a12,f8.1,a5,i4)') ' RQIBLTEN AT TIME ',TIME,' I = ',i
  size1 = jpe-jps
  size2 = kpe-kps
  call plot_array (yz_plane_m, size1, size2, plot_label, label_length, YZ)

  END IF

! TSK -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = TSK(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'TSK AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! HFX -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = HFX(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'HFX AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! QFX -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = QFX(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'QFX AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! PBL -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = PBLH(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'PBL height AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

    ENDIF

  IF (config_flags%cu_physics .gt. 0) THEN
! RAINC -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = RAINC(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') &
    'Accumulated SUBGRID SCALE RAIN AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)
  
    ENDIF

! RAINNC -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    DO j=jps,jpe-1
      y_line_m(j) = RAINNC(i,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') &
    'Accumulated GRID SCALE RAIN AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! RAIN -----------------
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    IF (config_flags%cu_physics .gt. 0) THEN
       DO j=jps,jpe-1
         y_line_m(j) = RAINC(i,j)+RAINNC(i,j)
         yaxis(j) = float(j)*dy
         pxmin = amin1(pxmin,yaxis(j))
         pxmax = amax1(pxmax,yaxis(j))
         pymin = amin1(pymin,y_line_m(j))
         pymax = amax1(pymax,y_line_m(j))

       ENDDO
    ELSE
       DO j=jps,jpe-1
         y_line_m(j) = RAINNC(i,j)
         yaxis(j) = float(j)*dy
         pxmin = amin1(pxmin,yaxis(j))
         pxmax = amax1(pxmax,yaxis(j))
         pymin = amin1(pymin,y_line_m(j))
         pymax = amax1(pymax,y_line_m(j))

       ENDDO
    ENDIF

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') &
    'Accumulated RAIN AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)

! pp -----------------
    
    pxmin = 100000.
    pxmax = -100000.
    pymin = 100000.
    pymax = -100000.

    k=1

    DO j=jps,jpe-1
      y_line_m(j) = pp(i,1,j)
      yaxis(j) = float(j)*dy
      pxmin = amin1(pxmin,yaxis(j))
      pxmax = amax1(pxmax,yaxis(j))
      pymin = amin1(pymin,y_line_m(j))
      pymax = amax1(pymax,y_line_m(j))

    ENDDO

    write(20)y_line_m

    write(plot_label, FMT = '(a12,f8.1,a5,i4,a5,i4)') 'pp AT TIME ',TIME, &
    ' I = ',i,' K = ',k

    size1 = jpe-1-jps

    CALL plot_1d(y_line_m, yaxis, size1, plot_label, label_length, &
                 pxmin, pxmax, pymin, pymax)


  END IF

#endif

 END SUBROUTINE quick_look_dump

!-----------------------------------------------------------------


  SUBROUTINE plot_array(a,m,n,label,label_length, dir)

  IMPLICIT NONE
      
  INTEGER, INTENT(IN) :: m,n,label_length
  REAL, DIMENSION(m,n), INTENT(IN) :: a
  CHARACTER (LEN=label_length)         :: label
  INTEGER dir
  INTEGER unit, i, j, k

  LOGICAL debug
#ifndef NONCARG

  debug = .false.

  IF(debug) THEN

   write(6,'(''  dimensions in plotarray m,n  '',2i6)')m,n
   write(6,*) ' plot label is '
   write(6,*) label

  END IF

  CALL set(0.,1.,0.,1.,0.,1.,0.,1.,1)
  CALL plchhq(.5,.97,label,0.02,0.,0.)
  CALL set(0.05,0.95,0.05,0.95,0.,1.,0.,1.,1)
  call perim(m-1,0,n-1,0)

  CALL CONREC(a,m,m,n,0,0,0,-1,-638,-922)

  CALL frame

#endif
#ifdef PLOT_HMV

  unit = 60 + dir

  write(unit,*) m,n,label
  do j = 1, n
  do i = 1, m
    write(unit,*) a(i,j)
  enddo
  enddo

#endif

  RETURN

  END SUBROUTINE plot_array

!--------------------------------------------------------
!
  SUBROUTINE plot_1d(a,x,m,label,label_length, &
                     xmin, xmax, ymin, ymax)

  IMPLICIT NONE

  INTEGER, INTENT(IN) :: m,label_length
  REAL, DIMENSION(m), INTENT(IN) :: a, x
  CHARACTER (LEN=label_length)         :: label
  CHARACTER (LEN=38)                   :: vmaxmin,vmaxmin2
  REAL :: xmin, xmax, ymin, ymax

  LOGICAL debug
#ifndef NONCARG

  debug = .false.

  IF(debug) THEN

   write(6,'(''  dimensions in plotarray m  '',2i6)')m
   write(6,*) ' plot label is '
   write(6,*) label

  END IF
  write(vmaxmin, FMT = '(a7,f10.5,a11,f10.5)') ' MAX = ',ymax, &
                                           '     MIN = ',ymin
  IF (xmin .GE. xmax) THEN
      print*,'The coordinate at x axis is incorrect '
      stop
  END IF

  ymax=ymax+0.1*abs((ymax-ymin))
  ymin=ymin-0.1*abs((ymax-ymin))

  IF (ymax .LE. ymin) THEN
      ymax=ymin+0.0001
  END IF

  write(vmaxmin2, FMT = '(a7,f10.5,a11,f10.5)') ' UPPER B. = ',ymax, &
                                           '      LOWER B. = ',ymin
  CALL set(0.,1.,0.,1.,0.,1.,0.,1.,1)
  CALL plchhq(.5,.97,label,0.02,0.,0.)
  CALL plchhq(.3,.03,vmaxmin,0.01,0.,0.)
  CALL plchhq(.7,.03,vmaxmin2,0.01,0.,0.)
  CALL set(0.05,0.95,0.05,0.95,xmin,xmax,ymin,ymax,1)
  call perim(m-1,0,5,0)

  CALL CURVE(x,a,m)

  CALL frame

#endif
  RETURN

  END SUBROUTINE plot_1d

