sub write_mm5_io {

open MM5HISTOUT, ">$wrf_root/inc/mm5_histout.inc" or 
  die "Cannot open $wrf_root/inc/mm5_histout.inc for writing" ;
open MM5RESTARTOUT, ">$wrf_root/inc/mm5_restartout.inc" or 
  die "Cannot open $wrf_root/inc/mm5_restartout.inc for writing" ;
open MM5INITIALOUT, ">$wrf_root/inc/mm5_initialout.inc" or 
  die "Cannot open $wrf_root/inc/mm5_initialout.inc for writing" ;
open MM5BDYOUT, ">$wrf_root/inc/mm5_bdyout.inc" or 
  die "Cannot open $wrf_root/inc/mm5_bdyout.inc for writing" ;

open MM5HISTIN, ">$wrf_root/inc/mm5_histin.inc" or 
  die "Cannot open $wrf_root/inc/mm5_histin.inc for writing" ;
open MM5RESTARTIN, ">$wrf_root/inc/mm5_restartin.inc" or 
  die "Cannot open $wrf_root/inc/mm5_restartin.inc for writing" ;
open MM5INITIALIN, ">$wrf_root/inc/mm5_initialin.inc" or 
  die "Cannot open $wrf_root/inc/mm5_initialin.inc for writing" ;
open MM5BDYIN, ">$wrf_root/inc/mm5_bdyin.inc" or 
  die "Cannot open $wrf_root/inc/mm5_bdyin.inc for writing" ;

open MMMETAGET, ">$wrf_root/inc/mm5_metaget.inc" or 
  die "Cannot open $wrf_root/inc/mm5_metaget.inc for writing" ;
open MMMETASET, ">$wrf_root/inc/mm5_metaset.inc" or 
  die "Cannot open $wrf_root/inc/mm5_metaset.inc for writing" ;

foreach $fid ( MM5HISTOUT, MM5RESTARTOUT, MM5INITIALOUT, MM5BDYOUT )
{
print $fid "!\n" ;
print $fid "! WARNING This file is generated automatically by use_registry\n" ;
print $fid "! using the data base in the file named Registry.\n" ;
print $fid "! Do not edit.  Your changes to this file will be lost.\n" ;
print $fid "!\n" ;
print $fid "#ifndef MM5_IO_ROUTINE\n" ;
print $fid "#  define MM5_IO_ROUTINE write_fieldrec\n" ;
print $fid "#endif\n" ;
print $fid "#ifndef MM5_IO_UNIT\n" ;
print $fid "#  define MM5_IO_UNIT fid\n" ;
print $fid "#endif\n" ;
print $fid "#ifndef MM5_IO_GRID\n" ;
print $fid "#  define MM5_IO_GRID grid\n" ;
print $fid "#endif\n" ;
print $fid "#ifndef MM5_IO_CURRENT_DATE\n" ;
print $fid "#  define MM5_IO_CURRENT_DATE current_date\n" ;
print $fid "#endif\n" ;
print $fid "\n" ;
}

foreach $fid ( MM5HISTIN, MM5RESTARTIN, MM5INITIALIN, MM5BDYIN )
{
print $fid "!\n" ;
print $fid "! WARNING This file is generated automatically by use_registry\n" ;
print $fid "! using the data base in the file named Registry.\n" ;
print $fid "! Do not edit.  Your changes to this file will be lost.\n" ;
print $fid "!\n" ;
print $fid "#ifndef MM5_IO_UNIT\n" ;
print $fid "#  define MM5_IO_UNIT fid\n" ;
print $fid "#endif\n" ;
print $fid "#ifndef MM5_IO_GRID\n" ;
print $fid "#  define MM5_IO_GRID grid\n" ;
print $fid "#endif\n" ;
print $fid "#ifndef MM5_IO_CURRENT_DATE\n" ;
print $fid "#  define MM5_IO_CURRENT_DATE current_date\n" ;
print $fid "#endif\n" ;
print $fid "\n" ;
}

print MMMETASET "!\n" ;
print MMMETASET "! WARNING This file is generated automatically by use_registry\n" ;
print MMMETASET "! using the data base in the file named Registry.\n" ;
print MMMETASET "! Do not edit.  Your changes to this file will be lost.\n" ;
print MMMETASET "!\n" ;

print MMMETAGET "!\n" ;
print MMMETAGET "! WARNING This file is generated automatically by use_registry\n" ;
print MMMETAGET "! using the data base in the file named Registry.\n" ;
print MMMETAGET "! Do not edit.  Your changes to this file will be lost.\n" ;
print MMMETAGET "!\n" ;

{
  my $uniqtag_mm5io ;
  foreach $_ ( @inline )                                         ## iterate through input lines
  {                                                              ##
    s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
    if ( $t[$table] ne "state" ) { next ; }                      ## only state entries

    if ( ! $multfieldarrays{$t[$use]} && ($t[$io] eq "m") && ($t[$dims] eq "-") )
      {
        $ttag = "" ;
        if    ( $t[$type] eq "real" )    { $ttag = "r" ; }
        elsif ( $t[$type] eq "integer" ) { $ttag = "i" ; } 
        if ( $ttag )
        {
          print MMMETAGET "CALL get_bh$ttag ( '$t[$dname]' , $t[$sym] )\n" ;
          print MMMETASET "CALL set_bh$ttag ( '$t[$dname]' , $t[$sym] )\n" ;
        }
    }

    if ( $t[$type] ne "real" ) { next ; }                       ## only real entries
    $num_time = $t[$ntl] ;                                       ## handle multiple time levels
    $s1 = uc $t[$sym] ;
    $s2 = substr($s1,0,9) ;
    $d1 = uc $t[$dname] ;
    $d1 =~ s/$spc/ / ;
    $d2 = substr($d1,0,9) ;

    $p1 = uc $t[$use] ;
    if ( $num_time eq "-" ) { $num_time = 1 }                    ## and generate tags (_1 or _2)
      $dimstr = substr($t[$dims],0,3) ;
      if ( $dimstr eq "ijk" || $dimstr eq "ikj" || $dimstr eq "kij" )
      {
        $ndims = 3 ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $varstag = "'D'" ;
        }
        else
        {
          $varstag = "'C'" ;
        }
        if ( $t[$stag] eq "z" )
        {
          $varvertstag = "'XYW'" ;
        }
        else
        {
          $varvertstag = "'XYS'" ;
        }
      }
      # kludge 20000628
      elsif ( $dimstr eq "ilj" )
      {
        $ndims = 3 ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $varstag = "'D'" ;
        }
        else
        {
          $varstag = "'C'" ;
        }
        $varvertstag = "'XYL'" ;
      }
      elsif ( $dimstr eq "ij" || $dimstr eq "ji" )
      {
        $ndims = 2 ;
        $varstag = "'C'" ;
        $varvertstag = "'XY'" ;
      }
      elsif ( $dimstr eq "k" )
      {
        $ndims = 1 ;
        $varstag = "'H'" ;
        if ( $t[$stag] eq "z" )
        {
          $varvertstag = "'W'" ;
        }
        else
        {
          $varvertstag = "'S'" ;
        }
      }
       # kludge 20000628
      elsif ( $dimstr eq "l" )
      {
        $ndims = 1 ;
        $varstag = "'S'" ;          # S = soil
        $varvertstag = "'L'" ;      # L = L levels
      }
      elsif ( $dimstr eq "kb" )
      {
        $ndims = 3 ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $varstag = "'D'" ;
        }
        else
        {
          $varstag = "'C'" ;
        }
      }
      else 
      {
        $varstag = "'0'" ;
        $varvertstag = "'0'" ;
        $ndims = 0 ;
      }

      $i = "2" ;
      if    ( $t[$ntl] eq "1" || $t[$ntl] eq "-" )
        { $tag = "" }
      else
        { $tag = "_".$i }

    if ( ! $uniqtag_mm5io{ "$t[$sym]"."$tag" } )
    {
      if    ( ! $multfieldarrays{$t[$use]} && ( $dimstr eq "kb" || $dimstr eq "lb" || $dimstr eq "1b" || $dimstr eq "b" ) )
      {
        if ( $dimstr ne "b" )
        {
          for ( $ibdy = 1 ; $ibdy <= 4 ; $ibdy ++ )
          {
            if      ( $ibdy == 1 ) { $bdytag = "XS" ; $varvertstag = "'YSB'" ;     # west bdy
            } elsif ( $ibdy == 2 ) { $bdytag = "XE" ; $varvertstag = "'YSB'" ;     # east bdy
            } elsif ( $ibdy == 3 ) { $bdytag = "YS" ; $varvertstag = "'XSB'" ;     # south bdy
            } elsif ( $ibdy == 4 ) { $bdytag = "YE" ; $varvertstag = "'XSB'" ;     # north bdy
            }
            print MM5BDYOUT "CALL MM5_IO_ROUTINE (   &\n" ;
            print MM5BDYOUT "  MM5_IO_UNIT , $ndims , MM5_IO_GRID %id , MM5_IO_GRID %domdesc ,&\n" ;
            print MM5BDYOUT "  MM5_IO_GRID %${s1}${tag} ( 1, 1 , 1 , $ibdy ) , '" ;
              $vname = uc substr( $d1, 0 , 8 ) ;
              print MM5BDYOUT $vname.$bdytag ;           # append W, E, S, or N to var name
              print MM5BDYOUT "' ,&\n" ;
            print MM5BDYOUT "  MM5_IO_CURRENT_DATE ,&\n" ;
            print MM5BDYOUT "  $varstag , $varvertstag , 'units' , '                        ' , xtime , &\n" ;

            if      ( $ibdy == 1 || $ibdy == 2 ) {                      # east or west bdys
              print MM5BDYOUT "  1 , jde          , 1 , config_flags%spec_bdy_width , kds , kde , &\n" ;
              print MM5BDYOUT "  1 , max(jde,ide) , 1 , config_flags%spec_bdy_width , kms , kme , &\n" ;
              print MM5BDYOUT "  1 , jde          , 1 , config_flags%spec_bdy_width , kps , kpe   )\n" ;
            } elsif ( $ibdy == 3 || $ibdy == 4 ) {                      # south or north bdys
              print MM5BDYOUT "  1 , ide          , 1 , config_flags%spec_bdy_width , kds , kde , &\n" ;
              print MM5BDYOUT "  1 , max(jde,ide) , 1 , config_flags%spec_bdy_width , kms , kme , &\n" ;
              print MM5BDYOUT "  1 , ide          , 1 , config_flags%spec_bdy_width , kps , kpe   )\n" ;
            }

            $taggedvname = $vname.$bdytag ;
            print MM5BDYIN "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$taggedvname\" ) THEN\n" ;
            if      ( $ibdy == 1 || $ibdy == 2 ) {                      # east or west bdys
              print MM5BDYIN "    CALL mm5_input_rec ( MM5_IO_UNIT , &\n" ;
              print MM5BDYIN "                              MM5_IO_GRID %domdesc , &\n" ;
              print MM5BDYIN "                              MM5_IO_GRID %${s1}${tag} ( 1, 1 , 1 , $ibdy ) , &\n" ;
              print MM5BDYIN "                              ndim , &\n" ;
              print MM5BDYIN "                              ordering , &\n" ;
              print MM5BDYIN "                              name , &\n" ;
              print MM5BDYIN "                              1 , jde , 1 , config_flags%spec_bdy_width , kds , kde , &\n" ;
              print MM5BDYIN "                              1 , max(jde,ide) , 1 , config_flags%spec_bdy_width , kms , kme , &\n" ;
              print MM5BDYIN "                              1 , jde , 1 , config_flags%spec_bdy_width , 1, kps+lendim3-1   )\n" ;
            } elsif ( $ibdy == 3 || $ibdy == 4 ) {                      # south or north bdys
              print MM5BDYIN "    CALL mm5_input_rec ( MM5_IO_UNIT , &\n" ;
              print MM5BDYIN "                              MM5_IO_GRID %domdesc , &\n" ;
              print MM5BDYIN "                              MM5_IO_GRID %${s1}${tag} ( 1, 1 , 1 , $ibdy ) , &\n" ;
              print MM5BDYIN "                              ndim , &\n" ;
              print MM5BDYIN "                              ordering , &\n" ;
              print MM5BDYIN "                              name , &\n" ;
              print MM5BDYIN "                              1 , ide , 1 , config_flags%spec_bdy_width , kds , kde , &\n" ;
              print MM5BDYIN "                              1 , max(jde,ide) , 1 , config_flags%spec_bdy_width , kms , kme , &\n" ;
              print MM5BDYIN "                              1 , ide , 1 , config_flags%spec_bdy_width , 1, kps+lendim3-1   )\n" ;
            }
            print MM5BDYIN "ENDIF\n" ;
          }
        }
      }

      elsif ( ( ! $multfieldarrays{$t[$use]} && $t[$io] ne "-" ) )
      {
        for ( $i = 0 ; $i < length( $t[$io] ) ; $i++ )
        {
          $code = substr( $t[$io] , $i , 1 ) ;
          if    ( $code eq "r" )
          {
            $fidin  = MM5RESTARTIN ;
            $fidout = MM5RESTARTOUT ;
          }
          elsif ( $code eq "h" )
          {
            $fidin  = MM5HISTIN ;
            $fidout = MM5HISTOUT ;
          }
          elsif ( $code eq "i" )
          {
            $fidin  = MM5INITIALIN ;
            $fidout = MM5INITIALOUT ;
          }

# in the case of a restart, generate code for both time levels; otherwise generate a copy
label1:
          print $fidout "CALL MM5_IO_ROUTINE (   &\n" ;
          print $fidout "  MM5_IO_UNIT , $ndims , MM5_IO_GRID %id , MM5_IO_GRID %domdesc ,&\n" ;
          print $fidout "  MM5_IO_GRID %${s1}${tag} , '" ;
            print $fidout uc substr( $d1, 0 , 9 ) ;  
            print $fidout $tag if ( $code eq "r" ) ;
            print $fidout "' ,&\n" ;
          print $fidout "  MM5_IO_CURRENT_DATE ,&\n" ;
          print $fidout "  $varstag , $varvertstag , 'units' , '                        ' , xtime , &\n" ;
          # kludge 20000628
          if ( $dimstr eq "ilj" || $dimstr eq "l" )
          {
            print $fidout "  ids , ide , jds , jde , 1 , config_flags%num_soil_layers ,&\n" ;
            print $fidout "  ims , ime , jms , jme , 1 , config_flags%num_soil_layers ,&\n" ;
            print $fidout "  ips , ipe , jps , jpe , 1 , config_flags%num_soil_layers )\n" ;

            if ( $code ne "r" ) { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2\" ) THEN\n" ; }
            else                { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2$tag\" ) THEN\n" ; }
            print $fidin "  CALL mm5_input_rec ( MM5_IO_UNIT , &\n" ;
            print $fidin "                            MM5_IO_GRID %domdesc , &\n" ;
            print $fidin "                            MM5_IO_GRID %${s1}${tag} , &\n" ;
            print $fidin "                            ndim , &\n" ;
            print $fidin "                            ordering , &\n" ;
            print $fidin "                            name , &\n" ;
            print $fidin "                            ids , ide , jds , jde , 1 , config_flags%num_soil_layers , &\n" ;
            print $fidin "                            ims , ime , jms , jme , 1 , config_flags%num_soil_layers , &\n" ;
            print $fidin "                            ips , ips+lendim1-1 , &\n" ;
            print $fidin "                            jps , jps+lendim2-1 , &\n" ;
            print $fidin "                            kps , kps+lendim3-1 )\n" ;

          }
          else
          {
            print $fidout "  ids , ide , jds , jde , kds , kde ,&\n" ;
            print $fidout "  ims , ime , jms , jme , kms , kme ,&\n" ;
            print $fidout "  ips , ipe , jps , jpe , kps , kpe )\n" ;
            if ( $code ne "r" ) { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2\" ) THEN\n" ; }
            else                { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2$tag\" ) THEN\n" ; }
#            print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$s2\" ) THEN\n" ;
            print $fidin "  CALL mm5_input_rec ( MM5_IO_UNIT , &\n" ;
            print $fidin "                            MM5_IO_GRID %domdesc , &\n" ;
            print $fidin "                            MM5_IO_GRID %${s1}${tag} , &\n" ;
            print $fidin "                            ndim , &\n" ;
            print $fidin "                            ordering , &\n" ;
            print $fidin "                            name , &\n" ;
            print $fidin "                            ids , ide , jds , jde , kds , kde , &\n" ;
            print $fidin "                            ims , ime , jms , jme , kms , kme , &\n" ;
            print $fidin "                            ips , ips+lendim1-1 , &\n" ;
            print $fidin "                            jps , jps+lendim2-1 , &\n" ;
            print $fidin "                            kps , kps+lendim3-1 )\n" ;
          }

          if ( $tag ne "" )
          {
            if ( $code ne "r" )
            {
              print $fidin "  MM5_IO_GRID %${s1}_1 = MM5_IO_GRID %${s1}${tag}\n" ;
              print $fidin "END IF\n" ;
            }
            elsif ( $tag eq "_2" )
            {
              print $fidin "END IF\n" ;
              $tag = "_1" ;
              goto label1 ;
            }
            else
            {
              print $fidin "END IF\n" ;
              $tag = "_2" if ( $tag eq "_1" ) ;
            }
          }
          else
          {
            print $fidin "END IF\n" ;
          }
        }
      }
      elsif ( ($s1 ne "-") && $multfieldarrays{$t[$use]} && ($t[$use] ne "rconfig") && $t[$io] ne "-" )
      {
        for ( $i = 0 ; $i < length( $t[$io] ) ; $i++ )
        {
          $code = substr( $t[$io] , $i , 1 ) ;
          if    ( $code eq "r" )
          {
            $fidin  = MM5RESTARTIN ;
            $fidout = MM5RESTARTOUT ;
          }
          elsif ( $code eq "h" )
          {
            $fidin  = MM5HISTIN ;
            $fidout = MM5HISTOUT ;
          }
          elsif ( $code eq "i" )
          {
            $fidin  = MM5INITIALIN ;
            $fidout = MM5INITIALOUT ;
          }

label2:

          print $fidout "IF ( P_$s1 .GE. PARAM_FIRST_SCALAR ) THEN\n" ;
          print $fidout "CALL MM5_IO_ROUTINE (   &\n" ;
          print $fidout "  MM5_IO_UNIT , $ndims , MM5_IO_GRID %id , MM5_IO_GRID %domdesc ,&\n" ;
          print $fidout "  MM5_IO_GRID %$t[$use]${tag}(ims,kms,jms,P_$s1) , '" ;
            print $fidout uc substr( $d1, 0 , 9 ) ;
            print $fidout $tag if ( $code eq "r" ) ;
            print $fidout "' ,&\n" ;
          print $fidout "  MM5_IO_CURRENT_DATE ,&\n" ;
          print $fidout "  $varstag , $varvertstag , 'units' , '                        ' , xtime, &\n" ;
          print $fidout "  ids , ide , jds , jde , kds , kde ,&\n" ;
          print $fidout "  ims , ime , jms , jme , kms , kme ,&\n" ;
          print $fidout "  ips , ipe , jps , jpe , kps , kpe )\n" ;
          print $fidout "END IF\n" ;

          if ( $code ne "r" ) { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2\" .AND. P_$s1 .GE. PARAM_FIRST_SCALAR ) THEN\n" ; }
          else                { print $fidin "IF ( ndim .EQ. $ndims .AND. TRIM(name) .EQ. \"$d2$tag\" .AND. P_$s1 .GE. PARAM_FIRST_SCALAR ) THEN\n" ; }
          print $fidin "  CALL mm5_input_rec ( MM5_IO_UNIT , &\n" ;
          print $fidin "                            MM5_IO_GRID %domdesc , &\n" ;
          print $fidin "                            MM5_IO_GRID %$t[$use]${tag}(ims,kms,jms,P_$s1) , &\n" ;
          print $fidin "                            ndim , &\n" ;
          print $fidin "                            ordering , &\n" ;
          print $fidin "                            name , &\n" ;
          print $fidin "                            ids , ide , jds , jde , kds , kde , &\n" ;
          print $fidin "                            ims , ime , jms , jme , kms , kme , &\n" ;
          print $fidin "                            ips , ips+lendim1-1 , &\n" ;
          print $fidin "                            jps , jps+lendim2-1 , &\n" ;
          print $fidin "                            kps , kps+lendim3-1 )\n" ;
          print $fidin "END IF\n" ;

          if ( $code eq "r" && $tag eq "_2" )
          {
            $tag = "_1" ;
            goto label2 ;
          }
          elsif ( $code eq "r" && $tag eq "_1" )
          {
            $tag = "_2" ;
          }
        }
      }
      $uniqtag_mm5io{ "$t[$sym]"."$tag" } = 1 ;
    }
  }
}

foreach $key ( sort keys %multfieldarrays )
{
  $num_time = $multfield_ntl{$key} ;
  if ( $num_time == 2 )
  {
#print "$key  $num_time $multfield_io{$key}\n" ;
    for ( $i = 0 ; $i < length( $multfield_io{$key}  ) ; $i++ )
    {
      $code = substr( $multfield_io{$key} , $i , 1 ) ;
# restart files has both time levels; no need to copy
#      if    ( $code eq "r" )
#      {
#        $fidin  = MM5RESTARTIN ;
#      }
#      elsif ( $code eq "h" )
      if    ( $code eq "h" )
      {
        $fidin  = MM5HISTIN ;
      }
      elsif ( $code eq "i" )
      {
        $fidin  = MM5INITIALIN ;
      }

      print $fidin " MM5_IO_GRID %${key}_1 = MM5_IO_GRID %${key}_2\n" ;
    }
  }
}

close MM5HISTOUT ;
close MM5RESTARTOUT ;
close MM5INITIALOUT ;
close MM5BDYOUT ;
close MM5HISTIN ;
close MM5RESTARTIN ;
close MM5INITIALIN ;
close MM5BDYIN ;
close MMMETASET ;
close MMMETAGET ;
}
return 1 ;
