sub write_rsl_comms {

open RSLFLAGS, ">$wrf_root/inc/rsl_cpp_flags" or 
  die "Cannot open $wrf_root/inc/rsl_cpp_flags for writing" ;
open RSLHALOOUT, ">$wrf_root/inc/rslhalos.inc" or 
  die "Cannot open $wrf_root/inc/rslhalos.inc for writing" ;
open RSLPEROUT, ">$wrf_root/inc/rslperiods.inc" or 
  die "Cannot open $wrf_root/inc/rslperiods.inc for writing" ;
print RSLHALOOUT "!\n" ;
print RSLHALOOUT "! WARNING This file is generated automatically by use_registry\n" ;
print RSLHALOOUT "! using the data base in the file named Registry.\n" ;
print RSLHALOOUT "! Do not edit.  Your changes to this file will be lost.\n" ;
print RSLHALOOUT "!\n" ;
print RSLPEROUT "!\n" ;
print RSLPEROUT "! WARNING This file is generated automatically by use_registry\n" ;
print RSLPEROUT "! using the data base in the file named Registry.\n" ;
print RSLPEROUT "! Do not edit.  Your changes to this file will be lost.\n" ;
print RSLPEROUT "!\n" ;


# set dimvar with the number of dimensions of each variable

undef %assocvar ;
undef %dimvar ;

foreach $_ ( @inline )                                         ## iterate through input lines
{
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] eq "state" )
  {
    $x = substr($t[$dims],0,3) ;
    if ( $x eq "ikj" || $x eq "ijk" || $x eq "kij" )
    {
      $i = 3 ; $mult = 0 ;
      if ( substr($t[$dims],3,1) eq "f" ) {
        $mult = 1 ;
      } 
    }
    elsif ( $x = "ij" )
    {
      $i = 2 ; $mult = 0 ;
    }
    if ( $mult == 0 )
    {
      if ( $t[$ntl] == 2 && ( $i == 2 || $i == 3 ))
      {
        $dimvar{ "$t[$sym]"."_1" } = $i ;
        $dimvar{ "$t[$sym]"."_2" } = $i ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $stagvar{ "$t[$sym]"."_1" } = lc $t[$stag] ;
          $stagvar{ "$t[$sym]"."_2" } = lc $t[$stag] ;
        }
      }
      else
      {
        $dimvar{ $t[$sym] } = $i ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $stagvar{ $t[$sym] } = lc $t[$stag] ;
        }
      }
    }
    else
    {
      if ( $t[$ntl] == 2 && ( $i == 3 ) )
      {
        $dimvar{ "$t[$use]"."_1" } = $i ;
        $dimvar{ "$t[$use]"."_2" } = $i ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $stagvar{ "$t[$use]"."_1" } = lc $t[$stag] ;
          $stagvar{ "$t[$use]"."_2" } = lc $t[$stag] ;
        }

        if ( $t[$sym] ne '-'  )
        {
          $assocvar{ "$t[$use]"."_1" } = $assocvar{ "$t[$use]"."_1" }.",".$t[$sym] ;
          $assocvar{ "$t[$use]"."_2" } = $assocvar{ "$t[$use]"."_2" }.",".$t[$sym] ;
        }
      }
      else
      {
        $dimvar{ $t[$use] } = $i ;
        if ( $t[$stag] eq "x" || $t[$stag] eq "y" )
        {
          $stagvar{ $t[$use] } = lc $t[$stag] ;
        }
        if ( $t[$sym] ne '-'  )
        {
          $assocvar{ "$t[$use]" } = $assocvar{ "$t[$use]" }.",".$t[$sym] ;
        }
      }
    }
  }
}

$num_comm_objs = 0 ;

foreach $_ ( @inline )                                         ## iterate through input lines
{                                                              ##
  s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
  if ( $t[$table] eq "halo" || $t[$pre_table] eq "period" )
  {
    $commname = uc $t[$comm] ;
    $x = $t[$commdef] ;
    @s = split ';', $x ;
# figure out maximum stencil or period
    $sten = 0 ;
    for ( $i = 0 ; $i <= $#s ; $i++ )
    {
      @x1 = split /[:,]/, $s[$i] ;
      if ( $x1[0] > $sten ) { $sten = $x1[0]  ; }
    }
    $perwdth = $sten ;
#
    if    ( $t[$table] eq "halo" )   { print RSLHALOOUT " CALL reset_msgs_${sten}pt\n" ; }
    elsif ( $t[$table] eq "period" ) { print RSLPEROUT " CALL rsl_create_message ( msg )\n" ; }
    if ( $t[$table] eq "halo" || $t[$table] eq "period" )
    {
      $bbbb = uc $commname ;
      $num_comm_objs++ ;
      print RSLFLAGS "-D$bbbb=$num_comm_objs\n" ;
    }
#
    for ( $i = 0 ; $i <= $#s ; $i++ )
    {
      @x1 = split /[:,]/, $s[$i] ;
      $lsten = $x1[0] ;

      if ( $t[$table] eq "halo" )
      {
        if (($lsten == 4) || ($lsten == 8) || ($lsten == 12) || ($lsten == 24) || ($lsten == 48))
        {
          for ( $j = 1 ; $j <= $#x1 ; $j++ )
          {
            $varname = lc $x1[$j] ;
            if ( $dimvar{$varname} == 2 || $dimvar{$varname} == 3 )
            {
              if ( $assocvar{ $varname } )
              {
                foreach $v ( split ',',substr($assocvar{ $varname },1) )
                {
                  $zz = uc $v ;
                  print RSLHALOOUT "  IF ( P_${zz} .GT. 1 ) " ;
                  print RSLHALOOUT "CALL add_msg_${lsten}pt ( $varname (sm31,sm32,sm33,P_${zz}), $dimvar{$varname} )\n" ;
                }
              }
              else
              {
                print RSLHALOOUT "  CALL add_msg_${lsten}pt ( $varname , $dimvar{$varname} )\n" ;
              }
            }
            else
            {
              print "REGISTRY WARNING: ADDING $varname WITH UNKNOWN DIMENSIONS TO HALO $commname ($dimvar{$varname})\n" ;
            }
          }
        }
        else
        {
          print "REGISTRY WARNING: HALO SIZE OF $lsten NOT SUPPORTED\n" ;
        }
      }

      if ( $t[$table] eq "period" )
      {
          for ( $j = 1 ; $j <= $#x1 ; $j++ )
          {
            $varname = lc $x1[$j] ;
            if ( $dimvar{$varname} == 2 || $dimvar{$varname} == 3 )
            {
              if ( $assocvar{ $varname } )
              {
                foreach $v ( split ',',substr($assocvar{ $varname },1) )
                {
                  $zz = uc $v ;
                  $twod = "" ; 
                  if ( $dimvar{$varname} == 2 ) { $twod = "2d" ; }
                  print RSLPEROUT "  IF ( P_${zz} .GT. 1 ) " ;
                  print RSLPEROUT "  CALL rsl_build_message( msg , RSL_REAL_F90 , $varname (sm31,sm32,sm33,P_${zz}) , $dimvar{$varname} , " ;
#                  print RSLPEROUT "decomp , glen$stagvar{$varname}$twod , llen$twod )\n" ;
                  print RSLPEROUT "decomp$stagvar{$varname}$twod , glen$twod , llen$twod )\n" ;
                }
              }
              else
              {
                print RSLPEROUT "  CALL rsl_build_message( msg , RSL_REAL_F90 , $varname , $dimvar{$varname} , " ;
                if ( $dimvar{$varname} == 2 )
                {
#                  print RSLPEROUT "decomp2d , glen$stagvar{$varname}2d , llen2d )\n" ;
                  print RSLPEROUT "decomp$stagvar{$varname}2d , glen2d , llen2d )\n" ;
                }
                else
                {
#                  print RSLPEROUT "decomp , glen$stagvar{$varname} , llen )\n" ;
                  print RSLPEROUT "decomp$stagvar{$varname} , glen , llen )\n" ;
                }
              }
            }
            else
            {
              print "REGISTRY WARNING: ADDING $varname WITH UNKNOWN DIMENSIONS TO HALO $commname ($dimvar{$varname})\n" ;
            }
          }
      }
    }
#
    if    ( $t[$table] eq "halo" )   
      { print RSLHALOOUT " CALL stencil_${sten}pt ( domdesc , comms ( $commname ) )\n" ; }
    elsif ( $t[$table] eq "period" ) 
      {
        print RSLPEROUT " CALL rsl_create_period ( comms ( $commname ) )\n" ;
        print RSLPEROUT " CALL rsl_describe_period ( domdesc , comms ( $commname ) , $perwdth , msg )\n" ;
      }
#
  }
}
print RSLFLAGS "-DWRF_RSL_RK_NCOMMS=$num_comm_objs\n" ;

close RSLHALOOUT ;
close RSLPEROUT ;
close RSLFLAGS ;

}

#############################################################################
#
#        rsl_data_calls.inc
# 

sub rsl_data_calls {

if ( $sw_rsl == 1 ) {

foreach $dyntag ( sort ( keys ( %dynsolver_tags ) ) )
{

open I1, "<$wrf_root/inc/${dyntag}_i1.inc" or
  die "Cannot open lf_i1.inc for rereading" ;
open DEFINESFILE, "<$wrf_root/inc/state_defines.inc" or
  die "Cannot open state_defines.inc for rereading" ;
open RSLDATALIST, ">$wrf_root/inc/rsl_${dyntag}_data_calls.inc" or
  die "Cannot open rsl_${dyntag}_data_calls.inc for writing" ;

print RSLDATALIST "!\n" ;
print RSLDATALIST "! WARNING This file is generated automatically by use_registry\n" ;
print RSLDATALIST "! using the data base in the file named Registry.\n" ;
print RSLDATALIST "! Do not edit.  Your changes to this file will be lost.\n" ;
print RSLDATALIST "!\n" ;
print RSLDATALIST "! Contains statements for RSL version of module_dm.F .\n" ;
print RSLDATALIST "!\n" ;
print RSLDATALIST " CALL rsl_start_register_f90\n" ;
while (<DEFINESFILE>)
{
  s/!.*// ;
  if ( $_ eq "\n" ) { next ; }
  s/^.*DIMENSION.*::/ CALL rsl_register_f90 (/ ;
  s/$/ ) / ;
  s/[ \t][ \t]*/ /g ;
  if ( substr( $_, 0, 20 ) ne substr(" CALL rsl_register_f90",0,20) ) { next ; }
  @x = split ' ' ;

  if ( $multfieldarrays{substr( $x[3], 0, index( $x[3], '_' ) )} )
  {
    $v = $x[3] ;
    $v =~ s/_.*// ;
    print RSLDATALIST " CALL rsl_register_f90 ( $x[3] (sm31,sm32,sm33,1) )\n" ;
    for ( $i = 1 ; $i <= $mycnt{$v} ; $i++ )
    {
      print RSLDATALIST " CALL rsl_register_f90 ( $x[3] (sm31,sm32,sm33,$i+1) )\n" ;
    }
  }
  else
  {
    print RSLDATALIST ;
  }
}
print RSLDATALIST "#ifdef REGISTER_I1\n" ;
while (<I1>)
{
  s/!.*// ;
  if ( $_ eq "\n" ) { next ; }
  s/^.*DIMENSION.*::/ CALL rsl_register_f90 ( / ;
  s/$/ ) / ;
  if ( substr( $_, 0, 20 ) ne substr(" CALL rsl_register_f90",0,20) ) { next ; }
  print RSLDATALIST ;
}
print RSLDATALIST "#endif\n" ;
print RSLDATALIST " CALL rsl_end_register_f90\n" ;

close I1 ;
close DEFINESFILE ;
close RSLDATALIST ;

}

}
}


return 1 ;
