#############################################################################
#
#   See comments generated in file itself.
#
#    scalarpointers: 1 = make scalars (dimension '-') be pointers;
#                    0 = declare as scalars
#    nopointers    : 1 = no variables are pointers;
#                    0 = arrays are pointers ; scalars are pointers depending on scalarpointers
#    colondims     : 1 = arrays dimensioned with colons ; 0 = arrays dimensioned with start:end
#    gridindex     : 1 = if arrays dimensioned start:end, make the dimensions grid%start:grid%end
#                    0 = if arrays dimensioned start:end, just use start:end
#    genallocs     : 1 = generate allocate statements instead of declarations for state vars
#                  : 0 = generate declarations for state vars
#    multitends    : 1 = generate declaration for a _tend multifield array companion to the
#                        other multifield arrays (e.g. moist_tend(..)

sub write_fld_decls{
  my $FLE = $_[0] ;
  my $tablestring    = $_[1] ;
  my $usestring      = $_[2] ;
  my $scalarpointers = $_[3] ;
  my $nopointers     = $_[4] ;
  my $colondims      = $_[5] ;
  my $gridindex      = $_[6] ;
  my $genallocs      = $_[7] ;
  my $multitends     = $_[8] ;

  my $gx ;
  my $key ;
  my %uniqtab ;       # make sure something only gets generated once -- guard against case
                      # where more than one item would be generated, say, if a variable
                      # or array was used in multiple solvers (e.g., dyn-lf and dyn-rk)

  foreach $_ ( @inline )                                         ## iterate through input lines
  {                                                              ##
    s/#.*// ; s/[ \t][ \t]*/ /g ; $_ = lc $_ ; @t = split ' ' ;  ## tokenize input line
    $num_time = $t[$ntl] ;                                       ## handle multiple time levels
    if ( $num_time eq "-" ) { $num_time = 1 }                    ## and generate tags (_1 or _2)
    if ( $t[$table] ne $tablestring ) { next ; }                      ## only state entries
    if ( substr( $t[$use],0,4 ) eq "dyn-" &&
         $usestring ne "-" &&
         substr( $t[$use], 4 ) ne $usestring ) { next ; }
    $xdims =  $t[$dims] ;
    $xdims =~ s/[ft]//g ;
    $ldims = length($xdims) ;
    $gx = "grid%"   if ( $gridindex == 1 ) ;

    if ( $colondims )
    {
      $dimmy4 = ":,:,:,:" ;  # added 20000629 for bdy arrays
      $dimmy3 = ":,:,:" ; 
      $dimmy2 = ":,:"   ;
      $dimmy1 = ":"     ;
      $dimmyextra = ":" ; 
      if ( $xdims eq "b" ) { $dimmy4 = ":" ; }
    }
    else
    {
      if ( $t[$type] eq "real" )    { $tsize = "RWORDSIZE" ; }
      if ( $t[$type] eq "integer" ) { $tsize = "IWORDSIZE" ; }
      if ( $t[$type] eq "logical" ) { $tsize = "LWORDSIZE" ; }
      if ( $index_order_3d eq "ijk" )                         ## index_order_3d (global) set in first pass
      {
        $dimmy3 = "${gx}sm31:${gx}em31,${gx}sm32:${gx}em32,${gx}sm33:${gx}em33" ;
        $dimmy2 = "${gx}sm31:${gx}em31,${gx}sm32:${gx}em32" ;
        $dimmy1 = "${gx}sm33:${gx}em33" ;
        $accum3 = "((${gx}em31-${gx}sm31+1)*(${gx}em32-${gx}sm32+1)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
        $accum2 = "((${gx}em31-${gx}sm31+1)*(${gx}em32-${gx}sm32+1)*$tsize)" ;
        $accum1 = "((${gx}em32-${gx}sm32+1)*$tsize)" ;
      }
      elsif ( $index_order_3d eq "kij" )
      {
        $dimmy3 = "${gx}sm31:${gx}em31,${gx}sm32:${gx}em32,${gx}sm33:${gx}em33" ;
        $dimmy2 = "${gx}sm32:${gx}em32,${gx}sm33:${gx}em33" ;
        $dimmy1 = "${gx}sm31:${gx}em31" ;
        $accum3 = "((${gx}em31-${gx}sm31+1)*(${gx}em32-${gx}sm32+1)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
        $accum2 = "((${gx}em32-${gx}sm32+1)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
        $accum1 = "((${gx}em31-${gx}sm31+1)*$tsize)" ;
      }
      elsif ( $index_order_3d eq "ikj" )
      {
        # kludge 20000628 for soil-level variables
        if ( $xdims eq "ilj" || $xdims eq "l" )
        {
          $dimmy3 = "${gx}sm31:${gx}em31,num_soil_layers,${gx}sm33:${gx}em33" ;
          $dimmy1 = "num_soil_layers" ;
          $accum3 = "((${gx}em31-${gx}sm31+1)*(num_soil_layers)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
          $accum1 = "(num_soil_layers*$tsize)" ;
        }
        elsif ( $xdims eq "kb" )
        {
          $dimmy4 = "max(${gx}ed31,${gx}ed33),${gx}sd32:${gx}ed32,spec_bdy_width,4" ;
	  $accum4 = "(max(${gx}ed31,${gx}ed33)*(${gx}ed32-${gx}sd32+1)*spec_bdy_width*4*$tsize)" ;
        }
        elsif ( $xdims eq "lb" )
        {
          $dimmy4 = "max(${gx}ed31,${gx}ed33),num_soil_layers,spec_bdy_width,4" ;
	  $accum4 = "(max(${gx}ed31,${gx}ed33)*snum_soil_layers*spec_bdy_width*4*$tsize)" ;
        }
        elsif ( $xdims eq "1b" )
        {
          $dimmy4 = "max(${gx}ed31,${gx}ed33),1,spec_bdy_width,4" ;
	  $accum4 = "(max(${gx}ed31,${gx}ed33)*spec_bdy_width*4*$tsize)" ;
        }
        elsif ( $xdims eq "b" )  # added 8/25/00 at JD's request
        {
          $dimmy4 = "spec_bdy_width" ;
	  $accum4 = "(spec_bdy_width*$tsize)" ;
        }
        else
        {
          $dimmy3 = "${gx}sm31:${gx}em31,${gx}sm32:${gx}em32,${gx}sm33:${gx}em33" ;
          $dimmy1 = "${gx}sm32:${gx}em32" ;
          $accum3 = "((${gx}em31-${gx}sm31+1)*(${gx}em32-${gx}sm32+1)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
          $accum1 = "((${gx}em32-${gx}sm32+1)*$tsize)" ;
        }
        $dimmy2 = "${gx}sm31:${gx}em31,${gx}sm33:${gx}em33" ;
        $accum2 = "((${gx}em31-${gx}sm31+1)*(${gx}em33-${gx}sm33+1)*$tsize)" ;
      }
      else
      {
        print "REGISTRY WARNING: UNKNOWN INDEX ORDER $index_order_3d\n" ;
      }
    }

    if ( ! $nopointers )
    {
      $ptrstr = ",POINTER" ;
    }
    else
    {
      $ptrstr = "" ;
    }

    if ( ! $multfieldarrays{$t[$use]} )
    { 
      if    ( $t[$dims] eq "-" )
      {
        $dimension = "" ;
        if ( $scalarpointers == 1 )
        {
          $pointer = $ptrstr ;
        }
        else
        {
          $pointer = "" ;
        }
      }
      elsif ( $t[$dims] eq "kb" || $t[$dims] eq "lb"  || $t[$dims] eq "1b"  || $t[$dims] eq "b" )
      {
        $dimension = $dimmy4 ; $accume = $accum4 ;  $pointer=$ptrstr ;
      }
      elsif ( length($t[$dims]) == 3 )
      {
        $dimension = $dimmy3 ; $accume = $accum3 ; $pointer=$ptrstr ;
      }
      elsif ( length($t[$dims]) == 2 )
      {
        $dimension = $dimmy2 ; $accume = $accum2 ; $pointer=$ptrstr ;
      }
      elsif ( length($t[$dims]) == 1 )
      {
        $dimension = $dimmy1 ; $accume = $accum1 ; $pointer=$ptrstr ;
      }
      else
      {
        print "REGISTRY WARNING: INVALID DIMSPEC $t[$dims]\n" ;
        print "LINE: $_\n" ;
      }

      if ( $genallocs == 1 ) 
      {
        if ( $t[$dims] ne "-" )
        {
          if ( $num_time <= 1 )
          {
            if ( ! $uniqtab{$t[$sym]} )
            {
              printf $FLE " ALLOCATE(grid%%%s(%s))\n",$t[$sym],$dimension ;
              printf $FLE " num_bytes_allocated = num_bytes_allocated + $accume\n" ;
              printf $FLE " grid%%%s = 0\n ",$t[$sym] ;        ## zero storage
            }
            $uniqtab{$t[$sym]} = 1 ;
          }
          else
          {
            for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
            {
              if ( ! $uniqtab{$t[$sym]."_".$i} )
              {
                printf $FLE " ALLOCATE(grid%%%s_%d(%s))\n",$t[$sym],$i,$dimension ;
                printf $FLE " num_bytes_allocated = num_bytes_allocated + $accume\n" ;
                printf $FLE " grid%%%s_%d = 0\n ",$t[$sym],$i ;        ## zero storage
              }
              $uniqtab{$t[$sym]."_".$i} = 1 ;
            }
          }
        }
        else
        {
          if ( $t[$type] eq "real" || $t[$type] eq "integer" )
          {
            printf $FLE " grid%%%s = 0\n ",$t[$sym] ;
          }
        }
      }
      else
      {
        if ( $dimension eq "" )
        {
          $dimstr = "" ;
        }
        else
        {
          $dimstr = ",DIMENSION($dimension)" ;
        }

        if ( $num_time <= 1 )
        {
          if ( ! $uniqtab{$t[$sym]} )
          {
            printf $FLE " %-9s%-20s%-10s :: %s\n",$t[$type],$dimstr,$pointer,$t[$sym] ;
          }
          $uniqtab{$t[$sym]} = 1 ;
        }
        else
        {
          for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
          {
            if ( ! $uniqtab{$t[$sym]."_".$i} )
            {
              printf $FLE " %-9s%-20s%-10s :: %s_%d\n",$t[$type],$dimstr,$pointer,$t[$sym],$i ;
            }
            $uniqtab{$t[$sym]."_".$i} = 1 ;
          }
        }
      }
    }
  }

  foreach $key ( sort keys %multfieldarrays )
  {
    if ( $colondims && ! $genallocs )
    {
      $dimmyextra = ":" ;
    }
    else
    {
      $dimmyextra = "num_".$key ;
    }
    $num_time = $multfield_ntl{$key} ;
    $xdims = $multfieldarrays{$key} ;
    $xdims =~ s/[tf]//g ;
    $ldims = length($xdims) ;    ## number of dimensions from dimstring (remove t and f)

    if    ( $ldims == 3 )
    {
      $dimension = "$dimmy3,$dimmyextra" ; $accume = "$accum3*$dimmyextra" ; $pointer=$ptrstr ;
    }
    elsif ( $ldims == 2 )
    {
      $dimension = "$dimmy2,$dimmyextra" ; $accume = "$accum2*$dimmyextra" ; $pointer=$ptrstr ;
    }
    elsif ( $ldims == 1 )
    {
      $dimension = "$dimmy1,$dimmyextra" ; $accume = "$accum1*$dimmyextra" ; $pointer=$ptrstr ;
    }
    else
    {
      print "REGISTRY WARNING: INVALID MULTI-FIELD DIMSPEC $multfieldarrays{$key}\n" ;
    }

    if ( $genallocs == 1 ) 
    {
      if ( $mycnt{$key} >= 0 )   # Always allocated at least one, which is unused; for range-checking.
                                 # All actual fields, if any, start at index 2.  (Oct. 2000)
      {
        if ( $num_time == 1 )
        {
          printf $FLE " ALLOCATE(grid%%%s(%s))\n",$key,$dimension ;
          printf $FLE " num_bytes_allocated = num_bytes_allocated + $accume\n " ;
          printf $FLE " grid%%%s = 0\n ",$key ;        ## zero storage
          if ( $sw_bogus_tracers == 1 )
          {
            printf $FLE " grid%%%s = 1. \n",$key ;
          }
        }
        else
        {
          for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
          {
            printf $FLE " ALLOCATE(grid%%%s_%d(%s))\n",$key,$i,$dimension ;
            printf $FLE " num_bytes_allocated = num_bytes_allocated + $accume\n" ;
            printf $FLE " grid%%%s_%d = 0\n ",$key,$i ;        ## zero storage
            if ( $sw_bogus_tracers == 1 )
            {
              printf $FLE " grid%%%s_%d = 1. \n",$key,$i ;
            }
          }
        }
      }
    }
    else
    {
      if ( $num_time == 1 || $multitends == 1 )
      {
        $tendappend = "" ;
        $tendappend = "_tend" if ( $multitends == 1 ) ;
        printf $FLE " %-9s,DIMENSION(%-20s)%-10s :: %s$tendappend\n",
               $multfield_type{$key}, $dimension, $pointer, $key ;
      }
        else
      {
        for ( $i = 1 ; $i <= $num_time ; $i++ )                      ## as needed
        {
          printf $FLE " %-9s,DIMENSION(%-20s)%-10s :: %s_%d\n",
                        $multfield_type{$key}, $dimension, $pointer, $key, $i ;
        }
      }
    }
  }
}
return 1 ;
