
MODULE module_write

!-----------------------------------------------------------------------------!
! Output observations for intputing into MM5 3D-VAR
!
!-----------------------------------------------------------------------------!
!  HISTORY: 
!
!         F. VANDENBERGHE, March 2001
!         01/13/2003 - Updated for Profiler obs.           S. R. H. Rizvi
!
!         02/04/2003 - Updated for Buoy     obs.           S. R. H. Rizvi
!
!         02/11/2003 - Reviewed and modified for Profiler
!                      and Buoy obs.                       Y.-R. Guo
!------------------------------------------------------------------------------

  USE module_type
  USE module_func
  USE module_date
  USE module_mm5
  USE module_map

CONTAINS

!------------------------------------------------------------------------------!
SUBROUTINE output_ssmi_31 (max_number_of_obs, obs, number_of_obs, index, &
                           nssmis, missing_r, time_analysis)

!-------------------------------------------------------------------------------
! Write observation at MM5 3D-VAR SYSTEM VERSION 2.0
! Output file is "obs_ascii.ccyymmddhh
!
! F. VANDENBERGHE, March 2000
!-------------------------------------------------------------------------------


  IMPLICIT NONE

  INTEGER,                                      INTENT (in) :: max_number_of_obs
  TYPE (report), DIMENSION (max_number_of_obs), INTENT (inout) :: obs
  INTEGER,                                      INTENT (in) :: number_of_obs
  INTEGER,       DIMENSION (max_number_of_obs), INTENT (in) :: index
  REAL,                                         INTENT (in) :: missing_r
  CHARACTER (LEN =  19),                        INTENT (in) :: time_analysis
  INTEGER,                                      INTENT (in) :: nssmis

  INTEGER                       :: n, loop_index, fm, i, ssmi_125, ssmi_126
  INTEGER                       :: nvalids, nwrites1, nwrites2
  LOGICAL                       :: connected
  CHARACTER (LEN = 80)          :: filename1, filename2
  CHARACTER (LEN = 120)         :: fmt_info, &
                                   fmt_srfc, &
                                   fmt_each
  REAL                          :: rew_cross, rns_cross
!------------------------------------------------------------------------------

  rew_cross=real(nestjx(idd)-1)
  rns_cross=real(nestix(idd)-1)

      if (nssmis == 0) then
        WRITE(0,'(A,/)') "No SSMI observations available."
        RETURN
      else
        ssmi_125 = 0
        ssmi_126 = 0
counts: &
        DO n = 1, number_of_obs
        loop_index = index (n)
        IF (obs (loop_index)%info%discard ) THEN
          CYCLE  counts
        ELSE 
          READ (obs (loop_index) % info % platform (4:6), '(I3)') fm
          if (fm == 125) THEN
            ssmi_125 = ssmi_125 + 1
          else if (fm == 126) THEN
            ssmi_126 = ssmi_126 + 1
          endif
        ENDIF

        ENDDO counts
      endif

!------------------------------------------------------------------------------!
!     B. PRINT OBS USING THE NEW STRUCUTURE
!------------------------------------------------------------------------------!

      WRITE (0,'(A)')  &
'------------------------------------------------------------------------------'


! 0.  FORMAT
! ==========

     fmt_info = '(a12,1x,a19,1x,a40,1x,i6,3(f12.3,11x),6x,a5)'
     fmt_srfc = '(7(:,f12.3,i4,f7.2))'
     fmt_each = '(3(f12.3,i4,f7.2),11x,3(f12.3,i4,f7.2),11x,1(f12.3,i4,f7.2))'


! 1. OPEN FILE FOR SSMI RETRIEVAL DATA OUTPUT
! ==========================================

! 1.1 Open utput file for retrievals in version 3.1 format
!     ----------------------------------------------------

      if (ssmi_125 > 0) then
        filename1 = 'obs_ssmi_retrieval.3dvar'

        WRITE (0,'(A,A)') &
        "Write 3DVAR SSMI Retrieval obs in files: ", TRIM (filename1)

        INQUIRE (UNIT = 125, OPENED = connected )

        IF ( .NOT. connected ) THEN
          OPEN ( UNIT   = 125,          &
                 FILE   = filename1,     &
                 FORM   = 'FORMATTED',  &
                 ACCESS = 'SEQUENTIAL', &
                 STATUS = 'REPLACE')
        ENDIF

        REWIND ( UNIT = 125)

! 1.2 FILE HEADER FOR NEW FORMAT
!     --------------------------

! 1.2.1 TOTAL NUMBER OF STATIONS CONTAINED IN FILE AND MISSING VALUE
!       ------------------------------------------------------------

        WRITE  (UNIT = 125, FMT = '(A,I7,A))',ADVANCE='no' ) "SSMI  =",ssmi_125,","
        WRITE  (UNIT = 125, FMT = '((A,F8.0),A)') " MISS. = ",missing_r,","

! 1.2.2 REFERENCE STATE INFO
!       --------------------

        WRITE (UNIT = 125, FMT = '(A,F7.2,A,F7.2,4(A,F7.2),A)') &
        "PHIC  =", phic,", XLONC =", xlonc,", TRUE1 =", truelat1,&
        ", TRUE2 =",truelat2,", XIM11 =",xim11(idd),", XJM11 =",xjm11(idd),","
        WRITE (UNIT = 125, FMT = '(2(A,F7.2),A,F7.0,A,F7.0,A)') &
        "TS0   =",  ts0, ", TLP   =", tlp, &
        ", PTOP  =",  ptop,", PS0   =",  ps0,","  

! 1.2.3 DOMAINS INFO
!       ------------

        WRITE (UNIT = 125, FMT = '(5(A,I7),A)' ) &
        "IXC   =", ixc,", JXC   =", jxc,", IPROJ =", iproj,&
        ", IDD   =", idd,", MAXNES=",maxnes,","
        WRITE (UNIT = 125, FMT = '(A,10(:,I7,A))')  &
        "NESTIX=",(nestix (i),", ", i = 1, maxnes)
        WRITE (UNIT = 125, FMT = '(A,10(:,I7,A))')  &
        "NESTJX=",(nestjx (i),", ", i = 1, maxnes)
        WRITE (UNIT = 125, FMT = '(A,10(:,I7,A))')  &
        "NUMC  =",(numc   (i),", ", i = 1, maxnes)
        WRITE (UNIT = 125, FMT = '(A,10(:,F7.2,A))')&
        "DIS   =",(dis    (i),", ",i = 1, maxnes)
        WRITE (UNIT = 125, FMT = '(A,10(:,I7,A))')  &
        "NESTI =",(nesti  (i),", ", i = 1, maxnes)
        WRITE (UNIT = 125, FMT = '(A,10(:,I7,A))')  &
        "NESTJ =",(nestj  (i),", ", i = 1, maxnes)
 
! 1.2.4 VARIABLE NAME AND UNITS
!       -----------------------

        WRITE (UNIT = 125, FMT = '(A)' ) &
        "INFO  = PLATFORM, DATE, NAME, LEVELS, LATITUDE, LONGITUDE, ELEVATION, ID."
        WRITE (UNIT = 125, FMT = '(A)' ) &
        "SRFC  = WIND SPEED, PW (DATA,QC,ERROR)."

! 1.2.5 FORMATS
!       -------

       WRITE (UNIT = 125, FMT = '(2A)' ) 'INFO_FMT = ', TRIM (fmt_info)
       WRITE (UNIT = 125, FMT = '(2A)' ) 'SRFC_FMT = ', TRIM (fmt_srfc)

! 1.2.6 END OF HEADER
!       -------------

        WRITE (UNIT = 125, FMT = '(A)') &
"#------------------------------------------------------------------------------#"

      endif

! 1.3 Open utput file for Tb in version 3.1 format
!     --------------------------------------------

      if (ssmi_126 > 0) then
        filename2 = 'obs_ssmi_Tb.3dvar'

        WRITE (0,'(A,A)') &
        "Write 3DVAR SSMI TB obs in files: ", TRIM (filename2)

        INQUIRE (UNIT = 126, OPENED = connected )

        IF ( .NOT. connected ) THEN
          OPEN ( UNIT   = 126,          &
                 FILE   = filename2,     &
                 FORM   = 'FORMATTED',  &
                 ACCESS = 'SEQUENTIAL', &
                 STATUS = 'REPLACE')
        ENDIF

        REWIND ( UNIT = 126)

! 1.4 FILE HEADER FOR NEW FORMAT
!     --------------------------

! 1.4.1 M TOTAL NUMBER OF STATIONS CONTAINED IN FILE AND ISSING VALUE FLAG 
!       ------------------------------------------------------------------

        WRITE  (UNIT = 126, FMT = '(A,I7,A))',ADVANCE='no' ) "SSMI  =",ssmi_126,","
        WRITE  (UNIT = 126, FMT = '((A,F8.0),A)') " MISS. = ",missing_r,","

! 1.4.2 REFERENCE STATE INFO
!       --------------------

        WRITE (UNIT = 126, FMT = '(A,F7.2,A,F7.2,4(A,F7.2),A)') &
        "PHIC  =", phic,", XLONC =", xlonc,", TRUE1 =", truelat1,&
        ", TRUE2 =",truelat2,", XIM11 =",xim11(idd),", XJM11 =",xjm11(idd),","

        WRITE (UNIT = 126, FMT = '(2(A,F7.2),A,F7.0,A,F7.0,A)') &
        "TS0   =",  ts0, ", TLP   =", tlp, &
        ", PTOP  =",  ptop,", PS0   =",  ps0,","  

! 1.4.3 DOMAINS INFO
!       ------------

        WRITE (UNIT = 126, FMT = '(5(A,I7),A)' ) &
        "IXC   =", ixc,", JXC   =", jxc,", IPROJ =", iproj,&
        ", IDD   =", idd,", MAXNES=",maxnes,","
        WRITE (UNIT = 126, FMT = '(A,10(:,I7,A))')  &
        "NESTIX=",(nestix (i),", ", i = 1, maxnes)
        WRITE (UNIT = 126, FMT = '(A,10(:,I7,A))')  &
        "NESTJX=",(nestjx (i),", ", i = 1, maxnes)
        WRITE (UNIT = 126, FMT = '(A,10(:,I7,A))')  &
        "NUMC  =",(numc   (i),", ", i = 1, maxnes)
        WRITE (UNIT = 126, FMT = '(A,10(:,F7.2,A))')&
        "DIS   =",(dis    (i),", ",i = 1, maxnes)
        WRITE (UNIT = 126, FMT = '(A,10(:,I7,A))')  &
        "NESTI =",(nesti  (i),", ", i = 1, maxnes)
        WRITE (UNIT = 126, FMT = '(A,10(:,I7,A))')  &
        "NESTJ =",(nestj  (i),", ", i = 1, maxnes)

! 1.4.4 VARIABLE NAME AND UNITS
!       -----------------------

        WRITE (UNIT = 126, FMT = '(A)' ) &
        "INFO  = PLATFORM, DATE, NAME, LEVELS, LATITUDE, LONGITUDE, ELEVATION, ID."
        WRITE (UNIT = 126, FMT = '(A)' ) &
        "SRFC  = TB19V, TB19H, TB22V, TB37V, TB37H, TB85V, TB85H (DATA,QC,ERROR)."

! 1.4.5 FORMATS
!       -------

        WRITE (UNIT = 126, FMT = '(2A)' ) 'INFO_FMT = ', TRIM (fmt_info)
        WRITE (UNIT = 126, FMT = '(2A)' ) 'SRFC_FMT = ', TRIM (fmt_srfc)

! 1.4.6 END OF HEADER
!       -------------

        WRITE (UNIT = 126, FMT = '(A)') &
"#------------------------------------------------------------------------------#"

      endif

! 2.  WRITE OBSERVATIONS
! ======================

      nwrites1 = 0
      nwrites2 = 0
      nvalids = 0


! 2.1  Loop over stations
!      ------------------

stations: &
       DO n = 1, number_of_obs

! 2.2 Index of obs
!     ------------

      loop_index = index (n)

! 2.3 Check if station is valid
!     -------------------------

stations_valid: &
      IF (obs (loop_index)%info%discard ) THEN

          CYCLE  stations

      ELSE stations_valid

      READ (obs (loop_index) % info % platform (4:6), '(I3)') fm

      if ((fm /= 125) .AND. (fm /= 126))  CYCLE stations

      nvalids = nvalids + 1

! 2.4 Write station info
!     ------------------

      IF (fm == 125) THEN

      WRITE (UNIT = 125, FMT = TRIM (fmt_info))         &
             obs (loop_index) % info     % platform,    &
             obs (loop_index) % valid_time % date_mm5,  &
             obs (loop_index) % location % name,        &
             obs (loop_index) % info % levels,          &
             obs (loop_index) % location % latitude,    &
             obs (loop_index) % location % longitude,   &
             obs (loop_index) % info     % elevation,   &
             obs (loop_index) % location % id

             nwrites1 = nwrites1 + 1

      ELSE IF (fm == 126) THEN

      WRITE (UNIT = 126, FMT = TRIM (fmt_info))          &
             obs (loop_index) % info     % platform,    &
             obs (loop_index) % valid_time % date_mm5,  &
             obs (loop_index) % location % name,        &
             obs (loop_index) % info % levels,          &
             obs (loop_index) % location % latitude,    &
             obs (loop_index) % location % longitude,   &
             obs (loop_index) % info     % elevation,   &
             obs (loop_index) % location % id

             nwrites2 = nwrites2 + 1

      ENDIF

! 2.4 Write surface info
!     ------------------

      IF (fm == 125) THEN

      IF (ASSOCIATED (obs (loop_index) % surface)) THEN

         if( domain_check_h .and. &
           (obs (loop_index) % location % xjc < 1.0 .or. &
            obs (loop_index) % location % xjc > rew_cross .or. &
            obs (loop_index) % location % yic < 1.0 .or. &
            obs (loop_index) % location % yic > rns_cross) ) then
            obs (loop_index) % ground  % pw   % qc = -88
         end if

         WRITE (UNIT = 125, FMT = TRIM (fmt_srfc))                  &
                obs (loop_index) % surface % meas % speed % data,  &
                obs (loop_index) % surface % meas % speed % qc,    &
                obs (loop_index) % surface % meas % speed % error, &
                obs (loop_index) % ground  % pw   % data, &
                obs (loop_index) % ground  % pw   % qc,   &
                obs (loop_index) % ground  % pw   % error

      ELSE

         if( domain_check_h .and. &
           (obs (loop_index) % location % xjc < 1.0 .or. &
            obs (loop_index) % location % xjc > rew_cross .or. &
            obs (loop_index) % location % yic < 1.0 .or. &
            obs (loop_index) % location % yic > rns_cross) ) then
            obs (loop_index) % ground  % pw   % qc = -88
         end if

         WRITE (UNIT = 125, FMT = TRIM (fmt_srfc))         &
                missing_r, CEILING (missing_r/10000), 2.5, &
                obs (loop_index) % ground % pw  % data,    &
                obs (loop_index) % ground % pw  % qc,      &
                obs (loop_index) % ground % pw  % error

      ENDIF

                nwrites1 = nwrites1 + 1

      ELSE IF (fm == 126) THEN

         if( domain_check_h .and. &
           (obs (loop_index) % location % xjc < 1.0 .or. &
            obs (loop_index) % location % xjc > rew_cross .or. &
            obs (loop_index) % location % yic < 1.0 .or. &
            obs (loop_index) % location % yic > rns_cross) ) then
            obs (loop_index) % ground % tb19v % qc = -88
            obs (loop_index) % ground % tb19h % qc = -88
            obs (loop_index) % ground % tb22v % qc = -88
            obs (loop_index) % ground % tb37v % qc = -88
            obs (loop_index) % ground % tb37h % qc = -88
            obs (loop_index) % ground % tb85v % qc = -88
            obs (loop_index) % ground % tb85h % qc = -88
         end if

         WRITE (UNIT = 126, FMT = TRIM (fmt_srfc))         &
         obs (loop_index) % ground % tb19v % data,  &
         obs (loop_index) % ground % tb19v % qc,    &
         obs (loop_index) % ground % tb19v % error, &
         obs (loop_index) % ground % tb19h % data,  &
         obs (loop_index) % ground % tb19h % qc,    &
         obs (loop_index) % ground % tb19h % error, &
         obs (loop_index) % ground % tb22v % data,  &
         obs (loop_index) % ground % tb22v % qc,    &
         obs (loop_index) % ground % tb22v % error, &
         obs (loop_index) % ground % tb37v % data,  &
         obs (loop_index) % ground % tb37v % qc,    &
         obs (loop_index) % ground % tb37v % error, &
         obs (loop_index) % ground % tb37h % data,  &
         obs (loop_index) % ground % tb37h % qc,    &
         obs (loop_index) % ground % tb37h % error, &
         obs (loop_index) % ground % tb85v % data,  &
         obs (loop_index) % ground % tb85v % qc,    &
         obs (loop_index) % ground % tb85v % error, &
         obs (loop_index) % ground % tb85h % data,  &
         obs (loop_index) % ground % tb85h % qc,    &
         obs (loop_index) % ground % tb85h % error

         nwrites2 = nwrites2 + 1

      ENDIF

! 3.3 Go to next valid station
!     -----------------

      ENDIF stations_valid

! 3.3 Go to next record
!     -----------------

      ENDDO stations


! 4.   CLOSE OUTPUT FILES
! ========================

      CLOSE (UNIT = 125) 
      CLOSE (UNIT = 126) 


! 5.  PRINT DIAGNOSTIC
! =====================
 
      WRITE (0, '(A)') ' ' 

      if (ssmi_125 > 0) WRITE (0, '(A,I7,A,A)') &
      'Wrote ',nwrites1,' lines of data in file: ',TRIM (filename1) 

      if (ssmi_126 > 0) WRITE (0, '(A,I7,A,A)') &
      'Wrote ',nwrites2,' lines of data in file: ',TRIM (filename2) 

      WRITE (0, '(A)') ' ' 


   RETURN

END SUBROUTINE output_ssmi_31

SUBROUTINE output_gts_31 (max_number_of_obs, obs, number_of_obs, index,&
                         nsynops, nshipss, nmetars,                    &
                         npilots, nsounds, nsatems,                    &
                         nsatobs, naireps, ngpspws, ngpsztd, ngpsref,  &
                         nssmt1s, nssmt2s, nssmis,  ntovss,            &
                         nothers, namdars, nqscats, nprofls,nbuoyss,   &
                         nboguss, missing_r, time_analysis)

!-------------------------------------------------------------------------------
! Write observation at MM5 3D-VAR SYSTEM VERSION 2.0
! Output file is "obs_ascii.ccyymmddhh
!
! F. VANDENBERGHE, March 2000
!-------------------------------------------------------------------------------


  IMPLICIT NONE

  INTEGER,                                      INTENT (in) :: max_number_of_obs
  TYPE (report), DIMENSION (max_number_of_obs), INTENT (inout) :: obs
  INTEGER,                                      INTENT (in) :: number_of_obs
  INTEGER,       DIMENSION (max_number_of_obs), INTENT (in) :: index
  REAL,                                         INTENT (in) :: missing_r
  CHARACTER (LEN =  19),                        INTENT (in) :: time_analysis
  INTEGER,                                      INTENT (in) :: nsynops,nmetars,&
                                                               nshipss,nsounds,&
                                                               npilots,naireps,&
                                                               nsatems,nsatobs,&
                                                               ngpspws,nssmt1s,&
                                                               nssmt2s, nssmis,&
                                                               ntovss, namdars,&
                                                               nqscats,nothers,&
                                                               nprofls,nbuoyss,&
                                                               ngpsztd,ngpsref,&
                                                               nboguss

  TYPE (measurement ) , POINTER :: current
  INTEGER                       :: loop_index
  INTEGER                       :: i, ii, n, ntotal
  INTEGER                       :: nvalids, nmultis, nsingles, nlevels, nwrites
  INTEGER                       :: is_sound, fm
  LOGICAL                       :: connected
  CHARACTER (LEN = 80)          :: filename
  CHARACTER (LEN = 120)         :: fmt_info, &
                                   fmt_srfc,  &
                                   fmt_each
  REAL                          :: val_slp, val_pw
  REAL                          :: val_u,  val_v,  val_p, val_t
  REAL                          :: val_td, val_rh, val_qv
!------------------------------------------------------------------------------
  REAL                          :: rew_cross, rns_cross
  LOGICAL                       :: change_qc

  rew_cross=real(nestjx(idd)-1)
  rns_cross=real(nestix(idd)-1)
!------------------------------------------------------------------------------!

      ntotal =   nsynops + nmetars + nshipss + &
                 nsounds + npilots + naireps + &
                 nsatems + nsatobs + ngpspws + &
                 nssmt1s + nssmt2s + ntovss  + &
                 namdars + nqscats + nprofls + &
                 nbuoyss + nothers + ngpsztd + &
                 ngpsref + nboguss 

      if (ntotal == 0) then
         WRITE(0,'(A,I6,A)') "Ntotal=",ntotal, &
                            " No observations other than SSMI is written out."
         RETURN
      endif

!------------------------------------------------------------------------------!
!     B. PRINT OBS USING THE NEW STRUCTURE
!------------------------------------------------------------------------------!

      WRITE (0,'(A)')  &
'------------------------------------------------------------------------------'


! 0.  FORMAT
! ==========

     fmt_info = '(A12,1X,A19,1X,A40,1X,I6,3(F12.3,11X),6X,A5)'
     fmt_srfc = '(F12.3,I4,F7.2,F12.3,I4,F7.3)'
     fmt_each = '(3(F12.3,I4,F7.2),11X,3(F12.3,I4,F7.2),11X,1(F12.3,I4,F7.2)))'


! 1. OPEN FILE FOR VALID OBSERVATIONS OUTPUT
! ==========================================

! 1.1 Name of output file
!     -------------------

      filename = 'obs_gts.3dvar'

      WRITE (0,'(3A)') 'Write 3DVAR GTS observations in file ',&
                        TRIM (filename),' (version 3.1)'


! 1.2 OPEN FILE AT VERSION 3.1 FORMAT
!     -------------------------------

      INQUIRE ( UNIT = 99, OPENED = connected )

      IF ( .NOT. connected ) THEN
          OPEN ( UNIT   = 99,           &
                 FILE   = filename,     &
                 FORM   = 'FORMATTED',  &
                 ACCESS = 'SEQUENTIAL', &
                 STATUS = 'REPLACE')
      ENDIF

      REWIND ( UNIT = 99)

! 1.3 FILE HEADER FOR NEW FORMAT
!     --------------------------

! 1.3.1 TOTAL NUMBER OF STATIONS CONTAINED IN FILE
!       ------------------------------------------

      WRITE  (UNIT = 99, FMT = '((A,I7),A)',ADVANCE='no' )    &
      "TOTAL =",nsynops + nmetars + nshipss + &
                nsounds + npilots + naireps + &
                nsatems + nsatobs + ngpspws + &
                nssmt1s + nssmt2s + namdars + &
                ntovss  + nqscats + nprofls + &
                nbuoyss + nothers + ngpsztd + &
                ngpsref + nboguss,", "

! 1.3.5 MISSING VALUE FLAG 
!       ------------------

       WRITE  (UNIT = 99, FMT = '((A,F8.0),A)') "MISS. =",missing_r,","

! 1.3.2 NUMBER OF STATIONS PER TYPE
!       ---------------------------

!      WRITE  (UNIT = 99, FMT = '(3(6(A,I7,A),/,:))' )    &
      WRITE  (UNIT = 99, FMT = '(6(A,I7,A))' )    &
      "SYNOP =",nsynops,", ", &
      "METAR =",nmetars,", ", &
      "SHIP  =",nshipss,", ", &
      "BUOY  =",nbuoyss,", ", &
      "BOGUS =",nboguss,", ", &
      "TEMP  =",nsounds,", ", &
      "AMDAR =",namdars,", ", &
      "AIREP =",naireps,", ", &
      "PILOT =",npilots,", ", &
      "SATEM =",nsatems,", ", &
      "SATOB =",nsatobs,", ", &
      "GPSPW =",ngpspws,", ", &
      "GPSZD =",ngpsztd,", ", &
      "GPSRF =",ngpsref,", ", &
      "SSMT1 =",nssmt1s,", ", &
      "SSMT2 =",nssmt2s,", ", &
!      "SSMI  =",nssmis, ", ", &
      "TOVS  =",ntovss, ", ", &
      "QSCAT =",nqscats,", ", &
      "PROFL =",nprofls,", ", &
      "OTHER =",nothers,", "


! 1.3.4 REFERENCE STATE INFO
!       --------------------

        WRITE (UNIT = 99, FMT = '(A,F7.2,A,F7.2,4(A,F7.2),A)') &
        "PHIC  =", phic,", XLONC =", xlonc,", TRUE1 =", truelat1,&
      ", TRUE2 =",truelat2,", XIM11 =",xim11(idd),", XJM11 =",xjm11(idd),","

        WRITE (UNIT = 99, FMT = '(2(A,F7.2),A,F7.0,A,F7.0,A)') &
        "TS0   =",  ts0, ", TLP   =", tlp, &
      ", PTOP  =",  ptop,", PS0   =",  ps0,","  

! 1.3.4 DOMAINS INFO
!       ------------

        WRITE (UNIT = 99, FMT = '(5(A,I7),A)' ) &
        "IXC   =", ixc,", JXC   =", jxc,", IPROJ =", iproj,&
        ", IDD   =", idd,", MAXNES=",maxnes,","
        WRITE (UNIT = 99, FMT = '(A,10(:,I7,A))')  &
       "NESTIX=",(nestix (i),", ", i = 1, maxnes)
        WRITE (UNIT = 99, FMT = '(A,10(:,I7,A))')  &
       "NESTJX=",(nestjx (i),", ", i = 1, maxnes)
        WRITE (UNIT = 99, FMT = '(A,10(:,I7,A))')  &
       "NUMC  =",(numc   (i),", ", i = 1, maxnes)
        WRITE (UNIT = 99, FMT = '(A,10(:,F7.2,A))')&
       "DIS   =",(dis    (i),", ",i = 1, maxnes)
        WRITE (UNIT = 99, FMT = '(A,10(:,I7,A))')  &
       "NESTI =",(nesti  (i),", ", i = 1, maxnes)
        WRITE (UNIT = 99, FMT = '(A,10(:,I7,A))')  &
       "NESTJ =",(nestj  (i),", ", i = 1, maxnes)



! 1.3.6 VARIABLE NAME AND UNITS
!       -----------------------

       WRITE (UNIT = 99, FMT = '(A)' ) &
      "INFO  = PLATFORM, DATE, NAME, LEVELS, LATITUDE, LONGITUDE, ELEVATION, ID."
       WRITE (UNIT = 99, FMT = '(A)' ) &
      "SRFC  = SLP, PW (DATA,QC,ERROR)."
       WRITE (UNIT = 99, FMT = '(A)' ) &
      "EACH  = PRES, SPEED, DIR, HEIGHT, TEMP, DEW PT, HUMID (DATA,QC,ERROR)*LEVELS."

! 1.3.7 FORMATS
!       -------

      WRITE (UNIT = 99, FMT = '(2A)' ) 'INFO_FMT = ', TRIM (fmt_info)
      WRITE (UNIT = 99, FMT = '(2A)' ) 'SRFC_FMT = ', TRIM (fmt_srfc)
      WRITE (UNIT = 99, FMT = '(2A)' ) 'EACH_FMT = ', TRIM (fmt_each)


! 1.3.7 END OF HEADER
!       -------------

        WRITE (UNIT = 99, FMT = '(A)') &
"#------------------------------------------------------------------------------#"


! 2.  WRITE OBSERVATIONS
! ======================

      nmultis  = 0
      nsingles = 0
      nlevels  = 0
      nwrites  = 0


! 2.1  Loop over stations
!      ------------------

stations: &
       DO n = 1, number_of_obs

! 2.2 Index of obs
!     ------------

      loop_index = index (n)

! 2.3 Check if station is valid
!     -------------------------

stations_valid: &
      IF (obs (loop_index)%info%discard ) THEN

          CYCLE  stations

      ELSE stations_valid

      READ (obs (loop_index) % info % platform (4:6), '(I3)') fm

      if ((fm == 125) .OR. (fm == 126))  CYCLE stations

      nvalids = nvalids + 1

! SATEM reference pressure is assigned to slp:

      if (fm == 86) then
           obs (loop_index) % ground % slp % data =  &
              obs (loop_index) % ground % ref_pres % data
           obs (loop_index) % ground % slp % qc =  &
              obs (loop_index) % ground % ref_pres % qc
           obs (loop_index) % ground % pw % data =  &
              obs (loop_index) % ground % cloud_cvr % data
!           obs (loop_index) % ground % pw % qc =  &
!              obs (loop_index) % ground % cloud_cvr % qc
      endif

! 2.4 Write station info
!     ------------------

      WRITE (UNIT = 99, FMT = TRIM (fmt_info))          &
             obs (loop_index) % info     % platform,    &
             obs (loop_index) % valid_time % date_mm5,  &
             obs (loop_index) % location % name,        &
             obs (loop_index) % info % levels,          &
             obs (loop_index) % location % latitude,    &
             obs (loop_index) % location % longitude,   &
             obs (loop_index) % info     % elevation,   &
             obs (loop_index) % location % id

! 2.4 Write surface info
!     ------------------

         change_qc = .false.

         if( domain_check_h .and. &
           (obs (loop_index) % location % xjc < 1.0 .or. &
            obs (loop_index) % location % xjc > rew_cross .or. &
            obs (loop_index) % location % yic < 1.0 .or. &
            obs (loop_index) % location % yic > rns_cross) ) then
            obs (loop_index) % ground % slp % qc = -88
            obs (loop_index) % ground % pw  % qc = -88
            change_qc = .true.
         end if

      WRITE (UNIT = 99, FMT = TRIM (fmt_srfc))          &
             obs (loop_index) % ground % slp % data,    &
             obs (loop_index) % ground % slp % qc,      &
             obs (loop_index) % ground % slp % error,   &
             obs (loop_index) % ground % pw  % data,    &
             obs (loop_index) % ground % pw  % qc,      &
             obs (loop_index) % ground % pw  % error

             nwrites = nwrites + 1

! 2.6 Initialise pointer
!     ------------------

      current => obs (loop_index) % surface


! 2.7 Loop over levels
!     ----------------

      is_sound = -1

levels:&
      DO WHILE (ASSOCIATED (current))

      nlevels  = nlevels  + 1
      is_sound = is_sound + 1

! SATEM thickness is assigned to temperature field:

      if (fm == 86) &
         current % meas % temperature = current % meas % thickness

! 2.9 Write height, pressure, temp, mixing ratio, wind and model vertical coord
!     -------------------------------------------------------------------------

      if(change_qc) then
         current % meas % temperature % qc = -88
         current % meas % dew_point   % qc = -88
         current % meas % rh          % qc = -88

         if(current % meas % height   % qc >= 0) then
            current % meas % pressure % qc = -88
         end if
      end if

      WRITE (UNIT = 99, FMT = TRIM (fmt_each))    &
             current % meas % pressure    % data, &
             current % meas % pressure    % qc,   & 
             current % meas % pressure    % error,&
             current % meas % speed       % data, & 
             current % meas % speed       % qc,   & 
             current % meas % speed       % error,&
             current % meas % direction   % data, &
             current % meas % direction   % qc,   & 
             current % meas % direction   % error,&
             current % meas % height      % data, &
             current % meas % height      % qc,   &
             current % meas % height      % error,&
             current % meas % temperature % data, &
             current % meas % temperature % qc,   &
             current % meas % temperature % error,&
             current % meas % dew_point   % data, &
             current % meas % dew_point   % qc,   & 
             current % meas % dew_point   % error,&
             current % meas % rh          % data, &
             current % meas % rh          % qc,   & 
             current % meas % rh          % error

             nwrites = nwrites + 1


! 3.  GO TO NEXT OBS
!     ==============

! 3.1 Go to next level
!     -----------------

      current => current%next

      ENDDO levels

! 3.2 Count surface and sounding
!     --------------------------

      if (is_sound .gt. 0) then
          nmultis = nmultis + 1
      else 
          nsingles  = nsingles + 1
      endif

! 3.3 Go to next valid station
!     -----------------

      ENDIF stations_valid

! 3.3 Go to next record
!     -----------------

      ENDDO stations


! 4.   CLOSE OUTPUT FILES
! ========================

      CLOSE (UNIT = 99) 


! 5.  PRINT DIAGNOSTIC
! =====================
 
      WRITE (0, '(/,A,I7,A,A)') &
     'Wrote ',nwrites,' lines of data in file: ',TRIM (filename) 
      WRITE (0, '(A)') ' ' 


   RETURN

END SUBROUTINE output_gts_31

END MODULE module_write
