c                                                                     c
c*********************************************************************c
c                                                                     c
      module module_getpt

      integer, dimension(:), pointer :: idx_wk

      INTERFACE getpt
        MODULE PROCEDURE get3dt, get2dt
      END INTERFACE getpt

      INTERFACE putpt
        MODULE PROCEDURE put3dt, put2dt
      END INTERFACE putpt

      contains

      subroutine get3dt(miy,mjx,mkzh,ifree,ndim,point,wk,maxslab)
c
      dimension wk(miy,mjx,maxslab)
      dimension point(miy,mjx,mkzh)
c
      include 'comconst'
c
      ifreenew=ifree+mkzh
c     write(12,*) 'get3d, ifree = ',ifree
c     write(12,*) 'get3d, ifreenew = ',ifreenew
      if (ifreenew.gt.maxslab) then
         write(6,*)'The program is trying to allocate more work'
         write(6,*)'space than is available.  Try increasing maxfld'
         write(6,*)'and run rip again.'
         write(6,*) 'ifreenew = ',ifreenew,' maxslab = ',maxslab
         stop 'get3dt'
      else
         do k=ifree, ifreenew-1
            if(idx_wk(k) < 1) then
               write(6,*) 'The program is trying to use wk(', ifree,
     &              ':', ifreenew-1, ') before assigned value to it'
               stop 'get3dt'
            endif
         enddo
      endif
      point(1:miy, 1:mjx, 1:mkzh)=wk(1:miy,1:mjx,ifree:(ifreenew-1))
      ifree=ifreenew
      end subroutine get3dt

      subroutine get2dt(miy,mjx,mkzh,ifree,ndim,point,wk,maxslab)
c
      dimension wk(miy,mjx,maxslab)
      dimension point(miy,mjx)
c
      include 'comconst'
c
      ifreenew=ifree+1
c     write(12,*) 'get2d, ifree = ',ifree
c     write(12,*) 'get2d, ifreenew = ',ifreenew
      if (ifreenew.gt.maxslab) then
         write(6,*)'The program is trying to allocate more work'
         write(6,*)'space than is available.  Try increasing maxfld'
         write(6,*)'and run rip again.'
         write(6,*) 'ifreenew = ',ifreenew,' maxslab = ',maxslab
         stop 'get2dt'
      else
         if(idx_wk(ifree) < 1) then
            write(6,*) 'The program is trying to use wk(', ifree,
     &           ') before assigned value to it'
            stop 'get2dt'
         endif
      endif
      point(1:miy, 1:mjx)=wk(1:miy,1:mjx,ifree)
      ifree=ifreenew
      end subroutine get2dt

      subroutine put3dt(miy,mjx,mkzh,ifree,ndim,point,wk,maxslab)
c
      dimension wk(miy,mjx,maxslab)
      dimension point(miy,mjx,mkzh)
c
      include 'comconst'
c
      ifreenew=ifree+mkzh
c     write(12,*) 'put3d, ifree = ',ifree
c     write(12,*) 'put3d, ifreenew = ',ifreenew
      if (ifreenew.gt.maxslab) then
         write(6,*)'The program is trying to allocate more work'
         write(6,*)'space than is available.  Try increasing maxfld'
         write(6,*)'and run rip again.'
         write(6,*) 'ifreenew = ',ifreenew,' maxslab = ',maxslab
         stop 'put3dt'
      endif
      wk(1:miy,1:mjx,ifree:(ifreenew-1))=point(1:miy, 1:mjx, 1:mkzh)
      idx_wk(ifree:(ifreenew-1))=1
      ifree=ifreenew
      end subroutine put3dt

      subroutine put2dt(miy,mjx,mkzh,ifree,ndim,point,wk,maxslab)
c
      dimension wk(miy,mjx,maxslab)
      dimension point(miy,mjx)
c
      include 'comconst'
c
      ifreenew=ifree+1
c     write(12,*) 'put2d, ifree = ',ifree
c     write(12,*) 'put2d, ifreenew = ',ifreenew
      if (ifreenew.gt.maxslab) then
         write(6,*)'The program is trying to allocate more work'
         write(6,*)'space than is available.  Try increasing maxfld'
         write(6,*)'and run rip again.'
         write(6,*) 'ifreenew = ',ifreenew,' maxslab = ',maxslab
         stop 'put2dt'
      endif
      wk(1:miy,1:mjx,ifree)=point(1:miy, 1:mjx)
      idx_wk(ifree)=1
      ifree=ifreenew
      end subroutine put2dt

      end module module_getpt

