subroutine da_max_error_qc (it, info, n, field, max_error, ix, ixf, iunit, var, failed, print)

   !-----------------------------------------------------------------------
   ! Purpose: TBD
   !-----------------------------------------------------------------------

   implicit none

   integer,           intent(in)    :: it
   type(infa_type), intent(in)    :: info
   integer,           intent(in)    :: n
   type(field_type),  intent(inout) :: field
   real,              intent(in)    :: max_error
   integer,           intent(inout) :: ix, ixf
   integer,           intent(in)    :: iunit
   character (len=*), intent(in)    :: var
   logical,           intent(out)   :: failed
   logical,           intent(in)    :: print

   real                               :: err, err_max
   integer                            :: qc_flag

   if (trace_use_frequent) call da_trace_entry("da_max_error_qc")

   failed = .false.

   qc_flag = field % qc
   err_max = field % error * max_error
   err     = field % inv
   err     = ABS (err)

   ix     = ix + 1
   if (it > 1 .and. qc_flag == fails_error_max) field%qc = 0
   if (err > err_max) then
      if (field % qc > fails_error_max) field % qc = fails_error_max 

      ixf = ixf + 1
      failed = .true.

      if (print .and. failed) then
         if (err_max .LE. 0.0) then
            write (unit=iunit , fmt = '(A,3(F10.1,1X),A,A,A,A5,A,A,3f10.2)')   &
                   "Err_max < 0 ==> ",err,err_max,max_error, " for ", var, &
                   " OBS ID: ", info%id(n), info%platform(n),     &
                   " LA/LON/ELV:", info%lat(1,n), info%lon(1,n), info%elv(n)
            ! call da_error(__FILE__,__LINE__,(/"Erk"/))
         end if

         write (unit=iunit , fmt = '(A,A5,A,A,I5,A,I3,A,F4.1,A,A,A,2e13.6)') &
                "Err_max failed:ID=", info%id(n), info%platform(n),&
                "Ix=", ix, " Ixf=", ixf, " Err_max ratio =",err/err_max, &
                " for ", var, " inv, error:",field % inv, field % error
      end if
      field % inv = 0.0
   end if

   if (trace_use_frequent) call da_trace_exit("da_max_error_qc")

end subroutine da_max_error_qc


