      FUNCTION ADN30(IDN,L30)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    ADN30
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS FUNCTION CONVERTS A DESCRIPTOR FROM ITS BIT-WISE
!   (INTEGER) REPRESENTATION TO ITS FIVE OR SIX CHARACTER ASCII
!   REPRESENTATION.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY
!
! USAGE:    ADN30 (IDN, L30)
!   INPUT ARGUMENT LIST:
!     IDN      - INTEGER: BIT-WISE REPRESENTATION OF DESCRIPTOR (FXY)
!                VALUE
!     L30      - INTEGER: LENGTH OF ADN30 (NUMBER OF CHARACTERS, 5 OR
!                6)
!
!   OUTPUT ARGUMENT LIST:
!     ADN30    - CHARACTER*(*): CHARACTER FORM OF DESCRIPTOR (FXY
!                VALUE)
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT
!    THIS ROUTINE IS CALLED BY: CADN30   DXINIT   ISTDESC  NUMTAB
!                               RDMTBB   RDMTBD   SEQSDX   SNTBDE
!                               UFBQCD   UPDS3    WRITDX
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      CHARACTER*6 ADN30
      CHARACTER*128 BORT_STR

!----------------------------------------------------------------------
!----------------------------------------------------------------------

      IF(LEN(ADN30).LT.L30         ) GOTO 900
      IF(IDN.LT.0 .OR. IDN.GT.65535) GOTO 901
      IF(L30.EQ.5) THEN
         WRITE(ADN30,'(I5)') IDN
      ELSEIF(L30.EQ.6) THEN
         IDF = ISHFT(IDN,-14)
         IDX = ISHFT(ISHFT(IDN,NBITW-14),-(NBITW-6))
         IDY = ISHFT(ISHFT(IDN,NBITW- 8),-(NBITW-8))
         WRITE(ADN30,'(I1,I2,I3)') IDF,IDX,IDY
      ELSE
         GOTO 902
      ENDIF

      DO I=1,L30
      IF(ADN30(I:I).EQ.' ') ADN30(I:I) = '0'
      ENDDO

!  EXITS
!  -----

      RETURN
900   CALL BORT('BUFRLIB: ADN30 - FUNCTION RETURN STRING TOO SHORT')
901   CALL BORT('BUFRLIB: ADN30 - INTEGER REPRESENTATION OF '// &
       'DESCRIPTOR OUT OF 16-BIT RANGE')
902   WRITE(BORT_STR,'("BUFRLIB: ADN30 - CHARACTER LENGTH (",I4,") '// &
       'MUST BE EITHER 5 OR 6")') L30
      CALL BORT(BORT_STR)
      END FUNCTION ADN30
