      SUBROUTINE CLOSMG(LUNIN)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    CLOSMG
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE SHOULD ONLY BE CALLED WHEN LOGICAL UNIT
!   ABS(LUNIN) HAS BEEN OPENED FOR OUTPUT OPERATIONS.  IT CLOSES A BUFR
!   MESSAGE PREVIOUSLY OPENED BY EITHER BUFR ARCHIVE LIBRARY
!   SUBROUTINES OPENMG OR OPENMB AND WRITES IT TO THE UNIT ABS(LUNIN).
!   SINCE OPENMG AND OPENMB NORMALLY CALL THIS INTERNALLY, IT IS NOT
!   CALLED TOO OFTEN FROM AN APPLICATION PROGRAM.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
!                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
!                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
!                           BUFR FILES UNDER THE MPI)
! 2000-09-19  J. WOOLLEN -- MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           10,000 TO 20,000 BYTES
! 2003-05-19  J. WOOLLEN -- CORRECTED A PROBLEM INTRODUCED IN A
!                           PREVIOUS (MAY 2002) IMPLEMENTATION WHICH
!                           PREVENTED THE DUMP CENTER TIME AND
!                           INTITIATION TIME MESSAGES FROM BEING
!                           WRITTEN OUT (THIS AFFECTED APPLICATION
!                           PROGRAM BUFR_DUMPMD, IF IT WERE RECOMPILED,
!                           IN THE DATA DUMPING PROCESS)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY
! 2004-08-09  J. ATOR    -- MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           20,000 TO 50,000 BYTES
! 2005-05-26  D. KEYSER  -- ALLOWS OVERRIDE OF PREVIOUS LOGIC THAT HAD
!                           ALWAYS WRITTEN OUT MESSAGE NUMBERS 1 AND 2
!                           EVEN WHEN THEY CONTAINED ZERO SUBSETS
!                           (ASSUMED THESE ARE DUMMIES, CONTAINING ONLY
!                           CENTER AND DUMP TIME) (NO OTHER EMPTY
!                           MESSAGES WERE WRITTEN OUT), DONE BY PASSING
!                           IN A NEGATIVE UNIT NUMBER ARGUMENT THE
!                           FIRST TIME THIS ROUTINE IS CALLED BY AN
!                           APPLICATION PROGRAM (ALL EMPTY MESSAGES ARE
!                           SKIPPED) (ASSUMES DUMMY MESSAGES ARE NOT IN
!                           INPUT FILE), NOTE: THIS REMAINS SET FOR THE
!                           PARTICULAR FILE BEING WRITTEN TO EACH TIME
!                           CLOSMG IS CALLED, REGARDLESS OF THE SIGN OF
!                           THE UNIT NUMBER - THIS IS NECESSARY BECAUSE
!                           THIS ROUTINE IS CALLED BY OTHER BUFRLIB
!                           ROUTINES WHICH ALWAYS PASS IN A POSITIVE
!                           UNIT NUMBER (THE APPLICATION PROGRAM SHOULD
!                           ALWAYS CALL CLOSMG WITH A NEGATIVE UNIT
!                           NUMBER IMMEDIATELY AFTER CALLING OPENBF FOR
!                           THIS OUTPUT FILE IF THE INTENTION IS TO
!                           NOT WRITE ANY EMPTY MESSAGES)
!
! USAGE:    CALL CLOSMG (LUNIN)
!   INPUT ARGUMENT LIST:
!     LUNIN    - INTEGER: ABSOLUTE VALUE IS FORTRAN LOGICAL UNIT NUMBER
!                FOR BUFR FILE
!                  - IF LUNIN IS GREATER THAN ZERO, THEN MESSAGE NUMBER
!                    1 OR 2 IS WRITTEN OUT EVEN IF THE NUMBER OF
!                    SUBSETS WRITTEN INTO THE MESSAGE IS ZERO (THIS
!                    ALLOWS "DUMMY" MESSAGES CONTAINING DUMP CENTER AND
!                    INITIATION TIME TO BE COPIED), MESSAGE NUMBERS 3
!                    AND HIGHER ARE NOT WRITTEN OUT IF THEY CONTAIN
!                    ZERO SUBSETS
!                  - IF LUNIN IS LESS THAN ZERO, THEN NO MESSAGES WITH
!                    ZERO SUBSETS WRITTEN INTO THEM ARE WRITTEN OUT
!                    FOR A PARTICULAR FILE BOTH IN THIS CALL AND IN ALL
!                    SUBSEQUENT CALLS TO THIS ROUTINE BY AN APPLICATION
!                    PROGRAM
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     MSGWRT   STATUS   WRCMPS
!                               WTSTAT
!    THIS ROUTINE IS CALLED BY: CLOSBF   OPENMB   OPENMG   WRITSA
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /BITBUF/ MAXBYT,IBIT,IBAY(MXMSGLD4),MBYT(NFILES), &
                      MBAY(MXMSGLD4,NFILES)
      COMMON /MSGCWD/ NMSG(NFILES),NSUB(NFILES),MSUB(NFILES), &
                      INODE(NFILES),IDATE(NFILES)

      DIMENSION MSGLIM(NFILES)

      DATA MSGLIM/NFILES*3/

      SAVE MSGLIM

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  CHECK THE FILE STATUS
!  ---------------------

      LUNIT = ABS(LUNIN)
      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(LUNIT.NE.LUNIN) MSGLIM(LUN) = 0
      IF(IL.EQ.0) GOTO 900
      IF(IL.LT.0) GOTO 901
      IF(IM.NE.0) THEN
         IF(NSUB(LUN).GT.0) THEN
            CALL MSGWRT(LUNIT,MBAY(1,LUN),MBYT(LUN))
         ELSE IF(NSUB(LUN).EQ.0.AND.NMSG(LUN).LT.MSGLIM(LUN)) THEN
            CALL MSGWRT(LUNIT,MBAY(1,LUN),MBYT(LUN))
         ELSE IF(NSUB(LUN).LT.0) THEN
            CALL WRCMPS(-LUNIT)
         ENDIF
      ENDIF
      CALL WTSTAT(LUNIT,LUN,IL,0)

!  EXITS
!  -----

      RETURN
900   CALL BORT('BUFRLIB: CLOSMG - OUTPUT BUFR FILE IS CLOSED, IT '// &
       'MUST BE OPEN FOR OUTPUT')
901   CALL BORT('BUFRLIB: CLOSMG - OUTPUT BUFR FILE IS OPEN FOR '// &
       'INPUT, IT MUST BE OPEN FOR OUTPUT')
      END SUBROUTINE CLOSMG
