      FUNCTION I4DY(IDATE)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    I4DY
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1998-07-08
!
! ABSTRACT: THIS FUNCTION CONVERTS AN EIGHT DIGIT INTEGER DATE
!   (YYMMDDHH) TO TEN DIGITS (YYYYMMDDHH) USING THE Y2K "WINDOWING"
!   TECHNIQUE.  ALL TWO-DIGIT YEARS GREATER THAN "20" ARE ASSUMED TO
!   HAVE A FOUR-DIGIT YEAR BEGINNING WITH "19" (1921-1999) AND ALL TWO-
!   DIGIT YEARS LESS THAN OR EQUAL TO "20" ARE ASSUMED TO HAVE A FOUR-
!   DIGIT YEAR BEGINNING WITH "20" (2000-2020).  IF THE INPUT DATE IS
!   ALREADY TEN DIGITS, THIS ROUTINE JUST RETURNS ITS VALUE.
!
! PROGRAM HISTORY LOG:
! 1998-07-08  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-11-24  J. WOOLLEN -- MODIFIED TO CONFORM TO THE NCEP 2-DIGIT
!                           YEAR TIME WINDOW OF 1921-2020 (BUT
!                           INADVERTENTLY SET TO 1911-2010)
! 1998-12-14  J. WOOLLEN -- MODIFIED TO USE 20 AS THE 2-DIGIT YEAR FOR
!                           WINDOWING TO A 4-DIGIT YEAR (00-20 ==> ADD
!                           2000; 21-99 ==> ADD 1900), THIS WINDOWING
!                           TECHNIQUE WAS INADVERTENTLY CHANGED TO 10
!                           IN THE PREVIOUS IMPLEMENTATION OF I4DY
!                           (1998-11-24)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- MODIFIED DATE CALCULATIONS TO NO LONGER USE
!                           FLOATING POINT ARITHMETIC SINCE THIS CAN
!                           LEAD TO ROUND OFF ERROR AND AN IMPROPER
!                           RESULTING DATE ON SOME MACHINES (E.G.,
!                           NCEP IBM FROST/SNOW), INCREASES
!                           PORTABILITY; UNIFIED/PORTABLE FOR WRF;
!                           ADDED DOCUMENTATION (INCLUDING HISTORY)
!
! USAGE:    I4DY (IDATE)
!   INPUT ARGUMENT LIST:
!     IDATE    - INTEGER: DATE (EITHER YYMMDDHH OR YYYYMMDDHH),
!                DEPENDING ON DATELEN() VALUE 
!
!   OUTPUT ARGUMENT LIST:
!     I4DY     - INTEGER: DATE (YYYYMMDDHH)
!
! REMARKS:
!    THIS ROUTINE CALLS:        None
!    THIS ROUTINE IS CALLED BY: CKTABA   CMSGINI  DATEBF   DUMPBF
!                               IUPBS01  OPENMB   OPENMG   REWNBF 
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      IF(IDATE.LT.10**8) THEN
         IY = IDATE/10**6
         IF(IY.GT.20) I4DY = IDATE + 19*100000000
         IF(IY.LE.20) I4DY = IDATE + 20*100000000
      ELSE
         I4DY = IDATE
      ENDIF

      RETURN
      END FUNCTION I4DY
