	FUNCTION ISTDESC( IDN )

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    ISTDESC
!   PRGMMR: ATOR             ORG: NP12       DATE: 2004-08-18
!
! ABSTRACT:  GIVEN THE BIT-WISE REPRESENTATION OF THE FXY VALUE
!   FOR A DESCRIPTOR, THIS FUNCTION DETERMINES WHETHER THE DESCRIPTOR
!   IS A WMO-STANDARD DESCRIPTOR OR A LOCAL DESCRIPTOR.
!
! PROGRAM HISTORY LOG:
! 2004-08-18  J. ATOR    -- ORIGINAL AUTHOR
!
! USAGE:    ISTDESC( IDN )
!   INPUT ARGUMENT LIST:
!     IDN      - INTEGER: BIT-WISE REPRESENTATION OF FXY VALUE
!		 FOR DESCRIPTOR TO BE CHECKED
!
!   OUTPUT ARGUMENT LIST:
!     ISTDESC  - INTEGER: RETURN VALUE:
!		   0 - IDN IS A LOCAL DESCRIPTOR
!		   1 - IDN IS A WMO-STANDARD DESCRIPTOR
!
! REMARKS:
!    THIS ROUTINE CALLS:        ADN30
!    THIS ROUTINE IS CALLED BY: CMSGINI  RESTD       STNDRD
!                               Normally not called by application
!                               programs but it could be.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

	CHARACTER*6	ADSC, ADN30

	ADSC = ADN30( IDN, 6 )

	READ(ADSC,'(I1,I2,I3)') IF,IX,IY
	IF  ( ( IF .EQ. 1 ) .OR. ( IF .EQ. 2 ) )  THEN

!	    ADSC IS EITHER A REPLICATOR OR TABLE C OPERATOR DESCRIPTOR.
!	    SINCE LOCAL VERSIONS OF SUCH DESCRIPTORS ARE NOT ALLOWED,
!	    THEN ADSC IS STANDARD BY DEFAULT.

	    ISTDESC = 1
	ELSE IF  ( ( IX .LT. 48 ) .AND. ( IY .LT. 192 ) )  THEN
	    ISTDESC = 1
	ELSE
	    ISTDESC = 0
	END IF

	RETURN
	END FUNCTION ISTDESC
