      SUBROUTINE MVB(IB1,NB1,IB2,NB2,NBM)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    MVB
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE COPIES A SPECIFIED NUMBER OF BYTES FROM
!   ONE PACKED BINARY ARRAY TO ANOTHER.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 1998-10-27  J. WOOLLEN -- MODIFIED TO CORRECT PROBLEMS CAUSED BY IN-
!                           LINING CODE WITH FPP DIRECTIVES
! 2002-05-14  J. WOOLLEN -- REMOVED OLD CRAY COMPILER DIRECTIVES
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY
! 2005-11-29  J. ATOR    -- MAXIMUM NUMBER OF BYTES TO COPY INCREASED
!                           FROM 24000 TO MXIMB
!
! USAGE:    CALL MVB (IB1, NB1, IB2, NB2, NBM)
!   INPUT ARGUMENT LIST:
!     IB1      - INTEGER: *-WORD PACKED INPUT BINARY ARRAY
!     NB1      - INTEGER: POINTER TO FIRST BYTE IN IB1 TO COPY FROM
!     NB2      - INTEGER: POINTER TO FIRST BYTE IN IB2 TO COPY TO
!     NBM      - INTEGER: NUMBER OF BYTES TO COPY 
!
!   OUTPUT ARGUMENT LIST:
!     IB2      - INTEGER: *-WORD PACKED OUTPUT BINARY ARRAY
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     PKB      UPB
!    THIS ROUTINE IS CALLED BY: CNVED4   CPYUPD   MSGUPD   STNDRD
!                               SUBUPD
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      CHARACTER*128 BORT_STR
      DIMENSION     IB1(*),IB2(*),NVAL(MXIMB)

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      IF(NBM.GT.MXIMB) GOTO 900
      JB1 = 8*(NB1-1)
      JB2 = 8*(NB2-1)

      DO N=1,NBM
      CALL UPB(NVAL(N),8,IB1,JB1)
      ENDDO

      DO N=1,NBM
      CALL PKB(NVAL(N),8,IB2,JB2)
      ENDDO

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: MVB - THE NUMBER OF BYTES BEING '// &
       'REQUESTED TO COPY (",I7,") EXCEEDS THE LIMIT (",I7,")")') &
       NBM, MXIMB
      CALL BORT(BORT_STR)
      END SUBROUTINE MVB
