      SUBROUTINE READDX(LUNIT,LUN,LUNDX)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    READDX
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE GENERATES INTERNAL ARRAYS CONTAINING BUFR
!   DICTIONARY TABLES WHICH ARE NEEDED TO READ, WRITE, INITIALIZE OR
!   APPEND A BUFR FILE.  THE INFORMATION USED TO CREATE THE INTERNAL
!   DICTIONARY TABLE ARRAYS (IN COMMON BLOCK /TABABD/) AND THE
!   DICTIONARY MESSAGE CONTROL WORD PARTITION ARRAYS (IN COMMON BLOCK
!   /MSGCWD/) (WHICH ARE ALWAYS THEN ASSOCIATED WITH THE BUFR FILE IN
!   LUNIT) MAY COME FROM AN EXTERNAL, USER-SUPPLIED, BUFR DICTIONARY
!   TABLE FILE IN CHARACTER FORMAT (I.E., A BUFR MNEMONIC TABLE), FROM
!   THE BUFR FILE BEING ACTED UPON (IN WHICH CASE THE FILE MUST BE
!   OPENED FOR INPUT PROCESSING AND POSITIONED AT A DICTIONARY TABLE
!   MESSAGE SOMEWHERE IN THE FILE), OR FROM ANOTHER CURRENTLY OPENED
!   AND DEFINED BUFR FILE.  IN THIS LATTER CASE, THE BUFR FILE WOULD
!   MOST LIKELY BE OPENED FOR INPUT, HOWEVER THERE IS NOTHING
!   PREVENTING THE USE OF A FILE OPEN FOR OUTPUT AS LONG AS IT IS
!   ASSOCIATED WITH INTERNAL DICTIONARY ARRAYS THAT CAN BE USED.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY OR FOR INFORMATIONAL
!                           PURPOSES
!
! USAGE:    CALL READDX (LUNIT, LUN, LUNDX)
!   INPUT ARGUMENT LIST:
!     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
!                BEING READ, WRITTEN, INITIALIZED OR APPENDED
!     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
!                (ASSOCIATED WITH FILE CONNECTED TO LOGICAL UNIT LUNIT)
!     LUNDX    - INTEGER: FORTRAN LOGICAL UNIT NUMBER CONTAINING
!                DICTIONARY TABLE INFORMATION TO BE USED IN READING/
!                WRITING FROM/TO LUNIT (DEPENDING ON THE CASE); MAY BE
!                SET EQUAL TO LUNIT IF DICTIONARY TABLE INFORMATION IS
!                ALREADY EMBEDDED IN LUNIT (BUT ONLY IF LUNIT IS BEING
!                READ)
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     CPBFDX   RDBFDX   RDUSDX
!                               STATUS
!    THIS ROUTINE IS CALLED BY: OPENBF   WRITDX
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /QUIET/ IPRT

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  GET THE BUFR STATUS OF UNIT LUNDX
!  ---------------------------------

      CALL STATUS(LUNDX,LUD,ILDX,IMDX)

!  READ A DICTIONARY TABLE FROM THE INDICATED SOURCE
!  -------------------------------------------------

      IF (LUNIT.EQ.LUNDX) THEN
!  .... Source is input BUFR file in LUNIT
         IF(IPRT.GE.2) WRITE(*,100) LUNDX
         REWIND LUNIT
         CALL RDBFDX(LUNIT,LUN)
      ELSEIF(ILDX.EQ.-1) THEN
!  .... Source is input BUFR file in LUNDX
!       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) WRITE(*,101) LUNDX,LUNIT
         CALL CPBFDX(LUD,LUN)
      ELSEIF(ILDX.EQ.1) THEN
!  .... Source is output BUFR file in LUNDX
!       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) WRITE(*,102) LUNDX,LUNIT
         CALL CPBFDX(LUD,LUN)
      ELSEIF(ILDX.EQ.0) THEN
!  .... Source is user-suppl char. tbl in LUNDX
!       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) WRITE(*,103) LUNDX
         REWIND LUNDX
         CALL RDUSDX(LUNDX,LUN)
      ELSE
         GOTO 900
      ENDIF

100   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ', &
       '- READING BUFR DICTIONARY TABLE FROM INPUT BUFR FILE IN UNIT ', &
       I2,' INTO INTERNAL ARRAYS'/17('+'),'BUFR ARCHIVE LIBRARY',20('+') &
       /)
101   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ', &
       '- COPYING BUFR DCTY TBL FROM INTERNAL ARRAYS ASSOC. W/ INPUT ', &
       'FILE IN UNIT ',I2,' TO THOSE ASSOC. W/ FILE IN UNIT ',I2/ &
       17('+'),'BUFR ARCHIVE LIBRARY',20('+')/)
102   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ', &
       '- COPYING BUFR DCTY TBL FROM INTERNAL ARRAYS ASSOC. W/ OUTPUT ', &
       'FILE IN UNIT ',I2,' TO THOSE ASSOC. W/ FILE IN UNIT ',I2/ &
       17('+'),'BUFR ARCHIVE LIBRARY',20('+')/)
103   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ', &
       '- READING BUFR DICTIONARY TABLE FROM USER-SUPPLIED TEXT FILE ', &
       'IN UNIT ',I2,' INTO INTERNAL ARRAYS'/17('+'),'BUFR ARCHIVE ', &
       'LIBRARY',20('+')/)

!  EXITS
!  -----

      RETURN
900   CALL BORT('BUFRLIB: READDX - CANNOT DETERMINE SOURCE OF '// &
       'INPUT DICTIONARY TABLE')
      END SUBROUTINE READDX
