      SUBROUTINE READMG(LUNXX,SUBSET,JDATE,IRET)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    READMG
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE READS THE NEXT BUFR MESSAGE FROM LOGICAL
!   UNIT NUMBER ABS(LUNXX) INTO AN INTERNAL MESSAGE BUFFER (I.E. ARRAY
!   MBAY IN COMMON BLOCK /BITBUF/).  ABS(LUNXX) SHOULD ALREADY BE OPENED
!   FOR INPUT OPERATIONS.  IF LUNXX < 0, THEN A READ ERROR FROM
!   ABS(LUNXX) IS TREATED THE SAME AS THE END-OF-FILE (EOF) CONDITION;
!   OTHERWISE, BUFR ARCHIVE LIBRARY SUBROUTINE BORT IS NORMALLY CALLED
!   IN SUCH SITUATIONS.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1996-11-25  J. WOOLLEN -- MODIFIED TO EXIT GRACEFULLY WHEN THE BUFR
!                           FILE IS POSITIONED AFTER AN "END-OF-FILE"
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"; MODIFIED TO MAKE Y2K
!                           COMPLIANT
! 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
!                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
!                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
!                           BUFR FILES UNDER THE MPI); MODIFIED WITH
!                           SEMANTIC ADJUSTMENTS TO AMELIORATE COMPILER
!                           COMPLAINTS FROM LINUX BOXES (INCREASES
!                           PORTABILITY)
! 2000-09-19  J. WOOLLEN -- REMOVED MESSAGE DECODING LOGIC THAT HAD
!                           BEEN REPLICATED IN THIS AND OTHER READ
!                           ROUTINES AND CONSOLIDATED IT INTO A NEW
!                           ROUTINE CKTABA, CALLED HERE, WHICH IS
!                           ENHANCED TO ALLOW COMPRESSED AND STANDARD
!                           BUFR MESSAGES TO BE READ; MAXIMUM MESSAGE
!                           LENGTH INCREASED FROM 10,000 TO 20,000
!                           BYTES
! 2002-05-14  J. WOOLLEN -- REMOVED ENTRY POINT DATELEN (IT BECAME A
!                           SEPARATE ROUTINE IN THE BUFRLIB TO INCREASE
!                           PORTABILITY TO OTHER PLATFORMS)
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION; OUTPUTS MORE COMPLETE
!                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
!                           ABNORMALLY
! 2004-08-09  J. ATOR    -- MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           20,000 TO 50,000 BYTES
! 2005-11-29  J. ATOR    -- ADDED RDMSGW AND RDMSGB CALLS TO SIMULATE
!                           READIBM; ADDED LUNXX < 0 OPTION TO SIMULATE
!                           READFT
!
! USAGE:    CALL READMG (LUNIT, SUBSET, JDATE, IRET)
!   INPUT ARGUMENT LIST:
!     LUNXX    - INTEGER: ABSOLUTE VALUE IS FORTRAN LOGICAL UNIT NUMBER
!                FOR BUFR FILE (IF LUNXX IS LESS THAN ZERO, THEN READ
!                ERRORS FROM ABS(LUNXX) ARE TREATED THE SAME AS EOF)
!
!   OUTPUT ARGUMENT LIST:
!     SUBSET   - CHARACTER*8: TABLE A MNEMONIC FOR TYPE OF BUFR MESSAGE
!                BEING READ
!     JDATE    - INTEGER: DATE-TIME STORED WITHIN SECTION 1 OF BUFR
!                MESSAGE BEING READ, IN FORMAT OF EITHER YYMMDDHH OR
!                YYYYMMDDHH, DEPENDING ON DATELEN() VALUE
!     IRET     - INTEGER: RETURN CODE:
!                       0 = normal return
!                      -1 = there are no more BUFR messages in LUNIT
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     CKTABA   RDMSGB   RDMSGW
!                               STATUS   WTSTAT
!    THIS ROUTINE IS CALLED BY: IREADMG  READFT   READIBM  READNS
!                               RDMGSB   UFBINX   UFBPOS
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /MSGCWD/ NMSG(NFILES),NSUB(NFILES),MSUB(NFILES), &
                      INODE(NFILES),IDATE(NFILES)
      COMMON /BITBUF/ MAXBYT,IBIT,IBAY(MXMSGLD4),MBYT(NFILES), &
                      MBAY(MXMSGLD4,NFILES)
      COMMON /MSGFMT/ MGWRDS(NFILES)

      CHARACTER*8 SUBSET

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      IRET = 0
      LUNIT = ABS(LUNXX)

!  CHECK THE FILE STATUS
!  ---------------------

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.EQ.0) GOTO 900
      IF(IL.GT.0) GOTO 901
      CALL WTSTAT(LUNIT,LUN,IL,1)

!  READ A MESSAGE INTO THE INTERNAL MESSAGE BUFFER
!  -----------------------------------------------

1     IF(MGWRDS(LUN).EQ.0) THEN

!       Read the next message as an array of integer words.

        CALL RDMSGW(LUNIT,MBAY(1,LUN),IER)
        IF(IER.EQ.-1) GOTO 200
        IF(IER.EQ.-2) THEN

!         Backspace and try reading again as an array of bytes.

          BACKSPACE LUNIT
          MGWRDS(LUN) = 1
          GOTO 1
        ENDIF
      ELSE

!       Read the next message as an array of bytes.

        CALL RDMSGB(LUNIT,MBAY(1,LUN),IER)
        IF(IER.EQ.-1) GOTO 200
        IF(IER.EQ.-2) THEN
          IF(LUNXX.LT.0) GOTO 200
          GOTO 902
        ENDIF
      ENDIF

!  PARSE THE MESSAGE SECTION CONTENTS
!  ----------------------------------

      CALL CKTABA(LUN,SUBSET,JDATE,IRET)
      IF(IRET.NE.0) GOTO 1
      GOTO 100

!  EOF ON ATTEMPTED READ
!  ---------------------

200   CALL WTSTAT(LUNIT,LUN,IL,0)
      INODE(LUN) = 0
      IDATE(LUN) = 0
      SUBSET = ' '
      JDATE = 0
      IRET = -1

!  EXITS
!  -----

100   RETURN
900   CALL BORT('BUFRLIB: READMG - INPUT BUFR FILE IS CLOSED, IT MUST'// &
       ' BE OPEN FOR INPUT')
901   CALL BORT('BUFRLIB: READMG - INPUT BUFR FILE IS OPEN FOR OUTPUT'// &
       ', IT MUST BE OPEN FOR INPUT')
902   CALL BORT('BUFRLIB: READMG - ERROR READING A BUFR MESSAGE')
      END SUBROUTINE READMG
