      SUBROUTINE READNS(LUNIT,SUBSET,JDATE,IRET)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    READNS
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE SHOULD ONLY BE CALLED WHEN LOGICAL UNIT
!   LUNIT HAS BEEN OPENED FOR INPUT OPERATIONS.  IT READS THE NEXT
!   SUBSET FROM LOGICAL UNIT NUMBER LUNIT INTO INTERNAL SUBSET ARRAYS.
!   BUFR MESSAGES IN LUNIT MAY BE EITHER COMPRESSED OR UNCOMPRESSED.
!   THIS SUBROUTINE IS ACTUALLY A COMBINATION OF BUFR ARCHIVE LIBRARY
!   SUBROUTINES READMG AND READSB.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
!                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
!                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
!                           BUFR FILES UNDER THE MPI)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- MAXJL (MAXIMUM NUMBER OF JUMP/LINK ENTRIES)
!                           INCREASED FROM 15000 TO 16000 (WAS IN
!                           VERIFICATION VERSION); UNIFIED/PORTABLE FOR
!                           WRF; ADDED DOCUMENTATION (INCLUDING
!                           HISTORY); OUTPUTS MORE COMPLETE DIAGNOSTIC
!                           INFO WHEN ROUTINE TERMINATES ABNORMALLY
!
! USAGE:    CALL READNS (LUNIT, SUBSET, JDATE, IRET)
!   INPUT ARGUMENT LIST:
!     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
!
!   OUTPUT ARGUMENT LIST:
!     SUBSET   - CHARACTER*8: TABLE A MNEMONIC FOR BUFR MESSAGE
!                CONTAINING SUBSET BEING READ
!     JDATE    - INTEGER: DATE-TIME STORED WITHIN SECTION 1 OF BUFR
!                MESSAGE CONTAINING SUBSET BEING READ, IN FORMAT OF
!                EITHER YYMMDDHH OR YYYYMMDDHH, DEPENDING ON DATELEN()
!                VALUE
!     IREADNS  - INTEGER: RETURN CODE:
!                       0 = normal return
!                      -1 = there are no more subsets in the BUFR file
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     READMG   READSB   STATUS
!    THIS ROUTINE IS CALLED BY: IREADNS
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /MSGCWD/ NMSG(NFILES),NSUB(NFILES),MSUB(NFILES), &
                      INODE(NFILES),IDATE(NFILES)
      COMMON /TABLES/ MAXTAB,NTAB,TAG(MAXJL),TYP(MAXJL),KNT(MAXJL), &
                      JUMP(MAXJL),LINK(MAXJL),JMPB(MAXJL), &
                      IBT(MAXJL),IRF(MAXJL),ISC(MAXJL), &
                      ITP(MAXJL),VALI(MAXJL),KNTI(MAXJL), &
                      ISEQ(MAXJL,2),JSEQ(MAXJL)

      CHARACTER*10 TAG
      CHARACTER*8  SUBSET
      CHARACTER*3  TYP

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  REFRESH THE SUBSET AND JDATE PARAMETERS
!  ---------------------------------------

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.EQ.0) GOTO 900
      IF(IL.GT.0) GOTO 901
      SUBSET = TAG(INODE(LUN))
      JDATE  = IDATE(LUN)

!  READ THE NEXT SUBSET IN THE BUFR FILE
!  -------------------------------------

1     CALL READSB(LUNIT,IRET)
      IF(IRET.NE.0) THEN
         CALL READMG(LUNIT,SUBSET,JDATE,IRET)
         IF(IRET.EQ.0) GOTO 1
      ENDIF

!  EXITS
!  -----

      RETURN
900   CALL BORT('BUFRLIB: READNS - INPUT BUFR FILE IS CLOSED, IT MUST'// &
       ' BE OPEN FOR INPUT')
901   CALL BORT('BUFRLIB: READNS - INPUT BUFR FILE IS OPEN FOR OUTPUT'// &
       ', IT MUST BE OPEN FOR INPUT')
      END SUBROUTINE READNS
