      SUBROUTINE WRITSB(LUNIT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    WRITSB
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE SHOULD ONLY BE CALLED WHEN LOGICAL UNIT
!   LUNIT HAS BEEN OPENED FOR OUTPUT OPERATIONS.  IT PACKS UP THE
!   CURRENT SUBSET WITHIN MEMORY AND THEN TRIES TO ADD IT TO THE 
!   BUFR MESSAGE THAT IS CURRENTLY OPEN WITHIN MEMORY FOR THIS LUNIT.
!   THE DETERMINATION AS TO WHETHER OR NOT THE SUBSET CAN BE ADDED TO
!   THE MESSAGE IS MADE VIA AN INTERNAL CALL TO ONE OF THE BUFR ARCHIVE
!   LIBRARY SUBROUTINES WRCMPS OR MSGUPD, DEPENDING UPON WHETHER OR NOT 
!   THE MESSAGE IS COMPRESSED.  IF IT TURNS OUT THAT THE SUBSET CANNOT
!   BE ADDED TO THE CURRENTLY OPEN MESSAGE, THEN THAT MESSAGE IS
!   FLUSHED TO LUNIT AND A NEW ONE IS CREATED IN ORDER TO HOLD THE
!   SUBSET.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION; OUTPUTS MORE COMPLETE
!                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
!                           ABNORMALLY
! 2005-03-09  J. ATOR    -- ADDED CAPABILITY FOR COMPRESSED MESSAGES
!
! USAGE:    CALL WRITSB (LUNIT)
!   INPUT ARGUMENT LIST:
!     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     MSGUPD   STATUS   WRCMPS
!                               WRTREE
!    THIS ROUTINE IS CALLED BY: COPYSB   WRITCP
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /MSGCMP/ CCMF

      CHARACTER*1 CCMF

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  CHECK THE FILE STATUS
!  ---------------------

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.EQ.0) GOTO 900
      IF(IL.LT.0) GOTO 901
      IF(IM.EQ.0) GOTO 902

!  PACK UP THE SUBSET AND PUT IT INTO THE MESSAGE
!  ----------------------------------------------

      CALL WRTREE(LUN)
      IF( CCMF.EQ.'Y' ) THEN
          CALL WRCMPS(LUNIT)
      ELSE
          CALL MSGUPD(LUNIT,LUN)
      ENDIF

!  EXITS
!  -----

      RETURN
900   CALL BORT('BUFRLIB: WRITSB - OUTPUT BUFR FILE IS CLOSED, IT '// &
       'MUST BE OPEN FOR OUTPUT')
901   CALL BORT('BUFRLIB: WRITSB - OUTPUT BUFR FILE IS OPEN FOR '// &
       'INPUT, IT MUST BE OPEN FOR OUTPUT')
902   CALL BORT('BUFRLIB: WRITSB - A MESSAGE MUST BE OPEN IN OUTPUT '// &
       'BUFR FILE, NONE ARE')
      END SUBROUTINE WRITSB
