      SUBROUTINE MSGWRT(LUNIT,MBAY,MBYT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    MSGWRT
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE PERFORMS SOME FINAL CHECKS ON AN OUTPUT
!  BUFR MESSAGE (E.G., CONFIRMING THAT EACH SECTION OF THE MESSAGE HAS
!  AN EVEN NUMBER OF BYTES WHEN NECESSARY, "STANDARDIZING" THE MESSAGE
!  IF REQUESTED VIA A PREVIOUS CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE
!  STDMSG, ETC.), AND THEN PREPARES THE MESSAGE FOR FINAL OUTPUT TO
!  LOGICAL UNIT LUNIT (E.G., ADDING THE STRING "7777" TO THE LAST FOUR
!  BYTES OF THE MESSAGE, APPENDING ZEROED-OUT BYTES UP TO A SUBSEQUENT
!  MACHINE WORD BOUNDARY, ETC.).  IT THEN WRITES OUT THE FINISHED
!  MESSAGE TO LOGICAL UNIT LUNIT AND ALSO STORES A COPY OF IT WITHIN
!  COMMON /BUFRMG/ FOR POSSIBLE LATER RETRIEVAL VIA BUFR ARCHIVE
!  LIBRARY SUBROUTINE WRITSA.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1997-07-29  J. WOOLLEN -- MODIFIED TO UPDATE THE CURRENT BUFR VERSION
!                           WRITTEN IN SECTION 0 FROM 2 TO 3
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 1998-11-24  J. WOOLLEN -- MODIFIED TO ZERO OUT THE PADDING BYTES
!                           WRITTEN AT THE END OF SECTION 4
! 2000-09-19  J. WOOLLEN -- MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           10,000 TO 20,000 BYTES
! 2003-11-04  J. ATOR    -- DON'T WRITE TO LUNIT IF OPENED AS A NULL
!                           FILE BY OPENBF {NULL(LUN) = 1 IN NEW
!                           COMMON BLOCK /NULBFR/} (WAS IN DECODER
!                           VERSION); ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION; OUTPUTS MORE COMPLETE
!                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
!                           ABNORMALLY
! 2004-08-18  J. ATOR    -- IMPROVED DOCUMENTATION; ADDED LOGIC TO CALL
!                           STNDRD IF REQUESTED VIA COMMON /MSGSTD/;
!                           ADDED LOGIC TO CALL OVRBS1 IF NECESSARY;
!                           MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           20,000 TO 50,000 BYTES
! 2005-11-29  J. ATOR    -- USE GETLENS, IUPBS01, PADMSG, PKBS1 AND
!                           NMWRD; ADDED LOGIC TO CALL PKBS1 AND/OR
!                           CNVED4 WHEN NECESSARY
!
! USAGE:    CALL MSGWRT (LUNIT, MBAY, MBYT)
!   INPUT ARGUMENT LIST:
!     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
!     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
!                MESSAGE TO OUTPUT TO LUNIT
!     MBYT     - INTEGER: LENGTH OF BUFR MESSAGE IN BYTES
!
!   OUTPUT FILES:
!     UNIT 06      - STANDARD OUTPUT PRINT
!     UNIT "LUNIT" - BUFR FILE
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     CNVED4   GETLENS  IUPB
!                               IUPBS01  NMWRD    OVRBS1   PADMSG
!                               PKB      PKBS1    PKC      STATUS
!                               STNDRD
!    THIS ROUTINE IS CALLED BY: CLOSMG   COPYMG   CPYMEM   CPYUPD
!                               MSGUPD   SUBUPD   WRCMPS   WRITDX
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      PARAMETER (MXCOD=15)

      COMMON /BUFRMG/ MSGLEN,MSGTXT(MXMSGLD4)
      COMMON /NULBFR/ NULL(NFILES)
      COMMON /QUIET / IPRT
      COMMON /MSGSTD/ CSMF
      COMMON /SECT01/ NCOD,ILCOD(MXCOD),IVCOD(MXCOD)
      COMMON /S01CM/  NS01V,CMNEM(MXS01V),IVMNEM(MXS01V)

      CHARACTER*8 CMNEM
      CHARACTER*4 BUFR0,SEVN
      CHARACTER*1 CSMF
      DIMENSION   MBAY(*)
      DIMENSION   MSGNEW(MXMSGLD4)

      DATA BUFR0/'BUFR'/
      DATA SEVN/'7777'/

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!     OVERWRITE ANY VALUES WITHIN SECTION 0 OR SECTION 1 THAT WERE
!     REQUESTED VIA PREVIOUS CALLS TO BUFR ARCHIVE LIBRARY SUBROUTINE
!     PKVS01.  IF A REQUEST WAS MADE TO CHANGE THE BUFR EDITION NUMBER
!     TO 4, THEN ACTUALLY CONVERT THE MESSAGE AS WELL.

      IF(NS01V.GT.0) THEN
        DO I=1,NS01V
          IF( (CMNEM(I).EQ.'BEN') .AND. (IVMNEM(I).EQ.4) ) THEN

!           INSTALL SECTION 0 BYTE COUNT FOR USE BY SUBROUTINE CNVED4.

            IBIT = 32
            CALL PKB(MBYT,24,MBAY,IBIT)

            CALL CNVED4(MBAY,MXMSGLD4,MSGNEW)

!           COMPUTE MBYT FOR THE NEW EDITION 4 MESSAGE.

            MBYT = IUPBS01(MSGNEW,'LENM')

!           COPY THE MSGNEW ARRAY BACK INTO MBAY.

            DO II = 1, NMWRD(MSGNEW)
              MBAY(II) = MSGNEW(II)
            ENDDO
          ELSE

!           OVERWRITE THE REQUESTED VALUE.

            CALL PKBS1(IVMNEM(I),MBAY,CMNEM(I))
          ENDIF
        ENDDO
      ENDIF

!     GET THE MESSAGE TYPE.

      MTYP = IUPBS01(MBAY,'MTYP')

!     GET THE SECTION LENGTHS.

      CALL GETLENS(MBAY,4,LEN0,LEN1,LEN2,LEN3,LEN4,L5)

!     GET THE COMPRESSION INDICATOR.

      NCMP = IUPB(MBAY,LEN0+LEN1+LEN2+7, 8)

!     "STANDARDIZE" THE MESSAGE IF REQUESTED VIA COMMON /MSGSTD/.
!     HOWEVER, WE DO NOT WANT TO DO THIS IF THE MESSAGE CONTAINS BUFR
!     TABLE (DX) INFORMATION (IN WHICH CASE IT IS ALREADY "STANDARD")
!     OR IF THE MESSAGE CONTAINS COMPRESSED DATA (IN WHICH CASE A
!     PREVIOUS CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE CMSGINI SHOULD
!     HAVE ALREADY "STANDARDIZED" IT).

      IF  ( ( CSMF.EQ.'Y' ) .AND. &
            ( MTYP.NE.11 ) .AND. &
            ( IAND(NCMP,64).EQ.0 ) )  THEN

!       INSTALL SECTION 0 BYTE COUNT AND SECTION 5 '7777' INTO THE
!       ORIGINAL MESSAGE.  THIS IS NECESSARY BECAUSE SUBROUTINE STNDRD
!       REQUIRES A COMPLETE AND WELL-FORMED BUFR MESSAGE AS ITS INPUT.

        IBIT = 32
        CALL PKB(MBYT,24,MBAY,IBIT)
        IBIT = (MBYT-4)*8
        CALL PKC(SEVN,4,MBAY,IBIT)

        CALL STNDRD(LUNIT,MBAY,MXMSGLD4,MSGNEW)

!       COMPUTE MBYT FOR THE NEW "STANDARDIZED" MESSAGE.

        MBYT = IUPBS01(MSGNEW,'LENM')

!       COPY THE MSGNEW ARRAY BACK INTO MBAY.

        DO II = 1, NMWRD(MSGNEW)
          MBAY(II) = MSGNEW(II)
        ENDDO

!       GET THE SECTION LENGTHS OF THE NEW "STANDARDIZED" MESSAGE.

        CALL GETLENS(MBAY,4,LEN0,LEN1,LEN2,LEN3,LEN4,L5)
      ENDIF

!     OVERWRITE ANY VALUES WITHIN SECTION 1 (OR BYTE 8 OF SECTION 0)
!     THAT WERE REQUESTED VIA PREVIOUS CALLS TO BUFR ARCHIVE LIBRARY
!     SUBROUTINE PKVS1.

      IF(NCOD.GT.0) THEN
        DO I=1,NCOD
          CALL OVRBS1(IVCOD(I),MBAY,ILCOD(I))
        ENDDO
      ENDIF

!     DEPENDING ON THE EDITION NUMBER OF THE MESSAGE, WE NEED TO ENSURE
!     THAT EACH SECTION WITHIN THE MESSAGE HAS AN EVEN NUMBER OF BYTES.

      IF(IUPBS01(MBAY,'BEN').LT.4) THEN
        IF(MOD(LEN1,2).NE.0) GOTO 901
        IF(MOD(LEN2,2).NE.0) GOTO 902
        IF(MOD(LEN3,2).NE.0) GOTO 903
        IF(MOD(LEN4,2).NE.0) THEN

!          PAD SECTION 4 WITH AN ADDITIONAL BYTE
!          THAT IS ZEROED OUT.

           IAD4 = LEN0+LEN1+LEN2+LEN3
           IAD5 = IAD4+LEN4
           IBIT = IAD4*8
           LEN4 = LEN4+1
           CALL PKB(LEN4,24,MBAY,IBIT)
           IBIT = IAD5*8
           CALL PKB(0,8,MBAY,IBIT)
           MBYT = MBYT+1
        ENDIF
      ENDIF

!  WRITE SECTION 0 BYTE COUNT AND SECTION 5
!  ----------------------------------------

      IBIT = 0
      CALL PKC(BUFR0, 4,MBAY,IBIT)
      CALL PKB(MBYT,24,MBAY,IBIT)

      KBIT = (MBYT-4)*8
      CALL PKC(SEVN, 4,MBAY,KBIT)

!  ZERO OUT THE EXTRA BYTES WHICH WILL BE WRITTEN
!  ----------------------------------------------

!     I.E. SINCE THE BUFR MESSAGE IS STORED WITHIN THE INTEGER ARRAY
!     MBAY(*) (RATHER THAN WITHIN A CHARACTER ARRAY), WE NEED TO MAKE
!     SURE THAT THE "7777" IS FOLLOWED BY ZEROED-OUT BYTES UP TO THE
!     BOUNDARY OF THE LAST MACHINE WORD THAT WILL BE WRITTEN OUT.

      CALL PADMSG(MBAY,MXMSGLD4,NPBYT)

!  WRITE THE MESSAGE PLUS PADDING TO A WORD BOUNDARY IF NULL(LUN) = 0
!  ------------------------------------------------------------------

      MWRD = NMWRD(MBAY)
      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(NULL(LUN).EQ.0) WRITE(LUNIT) (MBAY(I),I=1,MWRD)

      IF(IPRT.GE.2) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
         PRINT*,'BUFRLIB: MSGWRT - LUNIT=',LUNIT,' BYTES=',MBYT+NPBYT
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
      ENDIF

!  SAVE A MEMORY COPY OF THIS MESSAGE - NO BUFR TABLES THOUGH
!  ----------------------------------------------------------

      IF(MTYP.NE.11) THEN

!        STORE A COPY OF THIS MESSAGE WITHIN COMMON /BUFRMG/,
!        FOR POSSIBLE LATER RETRIEVAL DURING THE NEXT CALL TO
!        SUBROUTINE WRITSA.

         MSGLEN = MWRD
         DO I=1,MSGLEN
           MSGTXT(I) = MBAY(I)
         ENDDO
      ENDIF

!  EXITS
!  -----

      RETURN
901   CALL BORT &
       ('BUFRLIB: MSGWRT - LENGTH OF SECTION 1 IS NOT A MULTIPLE OF 2')
902   CALL BORT &
       ('BUFRLIB: MSGWRT - LENGTH OF SECTION 2 IS NOT A MULTIPLE OF 2')
903   CALL BORT &
       ('BUFRLIB: MSGWRT - LENGTH OF SECTION 3 IS NOT A MULTIPLE OF 2')
      END SUBROUTINE MSGWRT
