      SUBROUTINE PKVS01(S01MNEM,IVAL)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    PKVS01
!   PRGMMR: ATOR            ORG: NP12       DATE: 2005-11-29
!
! ABSTRACT:  THIS SUBROUTINE IS USED TO SPECIFY A VALUE TO BE WRITTEN
!   INTO A SPECIFIED LOCATION WITHIN SECTION 0 OR SECTION 1 OF ALL BUFR
!   MESSAGES THAT WILL BE OUTPUT BY FUTURE CALLS TO ANY OF THE BUFR
!   ARCHIVE LIBRARY SUBROUTINES WHICH CREATE SUCH MESSAGES (E.G. WRITCP,
!   WRITSB, COPYMG, WRITSA, ETC.).  IT WILL WORK ON ANY MESSAGE ENCODED
!   USING BUFR EDITION 2, 3 OR 4, AND IT CAN BE CALLED AT ANY TIME,
!   INCLUDING BEFORE THE FIRST CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE
!   OPENBF IF IT IS DESIRED FOR THE NEW VALUE TO ALSO BE INCLUDED IN ANY
!   DX DICTIONARY TABLE MESSAGES THAT WILL BE OUTPUT BY BUFR ARCHIVE
!   LIBRARY SUBROUTINE WRITDX.  IN ANY CASE, THE LOCATION WITHIN WHICH
!   TO STORE THE VALUE IS SPECIFIED VIA THE MNEMONIC S01MNEM, AS
!   EXPLAINED IN FURTHER DETAIL BELOW.  IF MULTIPLE VALUES ARE DESIRED
!   TO BE CHANGED WITHIN SECTION 0 OR SECTION 1 OF FUTURE OUTPUT
!   MESSAGES, THEN EACH SUCH VALUE (AND CORRESPONDING LOCATION)
!   SHOULD BE SPECIFIED USING A SEPARATE CALL TO THIS SUBROUTINE.
!   NOTE THAT EACH CALL TO THIS SUBROUTINE WITH A PARTICULAR LOCATION
!   SPECIFICATION WILL OVERRIDE THE EFFECT OF ANY PREVIOUS CALL WITH
!   THAT SAME SPECIFICATION (OR, IN THE CASE OF THE FIRST CALL WITH A
!   PARTICULAR LOCATION SPECIFICATION, IT WILL OVERRIDE THE DEFAULT
!   SECTION 0 OR SECTION 1 VALUE FOR THE CORRESPONDING LOCATION!).
!
! PROGRAM HISTORY LOG:
! 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
! 2006-04-14  D. KEYSER  -- UPDATED DOCBLOCK
!
! USAGE:    CALL PKVS01(S01MNEM,IVAL)
!   INPUT ARGUMENT LIST:
!     S01MNEM  - CHARACTER*(*): MNEMONIC SPECIFYING LOCATION WHERE IVAL
!                IS TO BE STORED WITHIN SECTION 0 OR SECTION 1 OF ALL
!                FUTURE OUTPUT BUFR MESSAGES:
!                  'BEN'   = BUFR EDITION NUMBER
!                  'BMT'   = BUFR MASTER TABLE 
!                  'OGCE'  = ORIGINATING CENTER
!                  'GSES'  = ORIGINATING SUBCENTER
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 3 OR 4 MESSAGES!)
!                  'USN'   = UPDATE SEQUENCE NUMBER 
!                  'MTYP'  = DATA CATEGORY
!                  'MSBTI' = DATA SUBCATEGORY (INTERNATIONAL)
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 4 MESSAGES!)
!                  'MSBT'  = DATA SUBCATEGORY (LOCAL)
!                  'MTV'   = VERSION NUMBER OF MASTER TABLE
!                  'MTVL'  = VERSION NUMBER OF LOCAL TABLES
!                  'YCEN'  = YEAR OF CENTURY (1-100)
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 2 AND 3 MESSAGES!)
!                  'CENT'  = CENTURY (I.E., 20 FOR YEARS 1901-2000,
!                                           21 FOR YEARS 2001-2100)
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 2 AND 3 MESSAGES!)
!                  'YEAR'  = YEAR (4-DIGIT)
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 4 MESSAGES!)
!                  'MNTH'  = MONTH
!                  'DAYS'  = DAY
!                  'HOUR'  = HOUR
!                  'MINU'  = MINUTE
!                  'SECO'  = SECOND
!                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
!                                     BUFR EDITION 4 MESSAGES!)
!                  'INIT'  = THIS IS A SPECIAL FLAG TO FORCE THE
!                            INITIALIZATION OF NS01V = 0 WITHIN
!                            COMMON /S01CM/; IN THIS CASE IVAL IS
!                            IGNORED
!                              (NOTE: AN APPLICATION PROGRAM SHOULD
!                                     NEVER ITSELF NEED TO DO THIS!)
!     IVAL     - INTEGER: NEW VALUE FOR LOCATION POINTED TO BY S01MNEM
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT
!    THIS ROUTINE IS CALLED BY: BFRINI
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /S01CM/  NS01V,CMNEM(MXS01V),IVMNEM(MXS01V)

      CHARACTER*(*) S01MNEM

      CHARACTER*128 BORT_STR
      CHARACTER*8   CMNEM

      DATA IFIRST/0/

      SAVE IFIRST

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      IF(IFIRST.EQ.0) THEN

!	NOTE THAT WE ARE INITIALIZING NS01V=0 HERE (RATHER THAN WITHIN
!	SUBROUTINE BFRINI) IN ORDER TO ALLOW FOR THE POSSIBILITY THAT A
!	USER MAY CALL SUBROUTINE PKVS01 PRIOR TO CALLING SUBROUTINE
!	OPENBF (WHICH ITSELF CALLS BFRINI!).  HOWEVER, IF THE USER DOES
!	NOT DO THIS, THEN THE "CALL PKVS01('INIT',-99)" STATEMENT WITHIN
!	BFRINI WILL ENSURE THAT THE REQUIRED INITIALIZATION OF NS01V=0
!	STILL GETS DONE; OTHERWISE, WE WOULD RUN THE RISK OF NS01V BEING
!	UNINITIALIZED WHEN REFERENCED LATER ON WITHIN SUBROUTINE MSGWRT!

        NS01V = 0
        IFIRST = 1
      ENDIF

      IF (S01MNEM.EQ.'INIT') THEN
        RETURN
      ENDIF

!     IF AN IVAL HAS ALREADY BEEN ASSIGNED FOR THIS PARTICULAR S01MNEM,
!     THEN OVERWRITE THAT ENTRY IN COMMON /S01CM/ USING THE NEW IVAL.

      IF(NS01V.GT.0) THEN
        DO I=1,NS01V
          IF(S01MNEM.EQ.CMNEM(I)) THEN
            IVMNEM(I) = IVAL
            RETURN
          ENDIF
        ENDDO
      ENDIF

!     OTHERWISE, USE THE NEXT AVAILABLE UNUSED ENTRY IN COMMON /S01CM/.

      IF(NS01V.GE.MXS01V) GOTO 900

      NS01V = NS01V + 1
      CMNEM(NS01V) = S01MNEM
      IVMNEM(NS01V) = IVAL

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PKVS01 - CANNOT OVERWRITE MORE THAN '// &
       '",I2," DIFFERENT LOCATIONS WITHIN SECTION 0 OR SECTION 1")') &
       MXS01V
      CALL BORT(BORT_STR)
      END SUBROUTINE PKVS01
