      SUBROUTINE STRING(STR,LUN,I1,IO)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    STRING
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE CHECKS TO SEE IF A USER-SPECIFIED CHARACTER
!   STRING IS IN THE STRING CACHE (ARRAYS IN COMMON BLOCKS /STCACH/ AND
!   /STORDS/).  IF IT IS NOT IN THE CACHE, IT MUST CALL THE BUFR
!   ARCHIVE LIBRARY PARSING SUBROUTINE PARUSR TO PERFORM THE TASK OF
!   SEPARATING AND CHECKING THE INDIVIDUAL "PIECES" (I.E., MNEMONICS)
!   SO THAT IT CAN THEN BE ADDED TO THE CACHE.  IF IT IS ALREADY IN THE
!   CACHE, THEN THIS EXTRA WORK DOES NOT NEED TO BE PERFORMED.  THE
!   MNEMONIC STRING CACHE IS A PERFORMANCE ENHANCING DEVICE WHICH SAVES
!   TIME WHEN THE SAME MNEMONIC STRINGS ARE ENCOUNTERED IN A USER
!   PROGRAM, OVER AND OVER AGAIN (THE TYPICAL SCENARIO).
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-04-02  J. WOOLLEN -- MODIFIED TO ENLARGE THE CACHE FROM 50
!                           ELEMENTS TO 1000, MAXIMUM; OPTIMIZATION OF
!                           THE CACHE SEARCH ALGORITHM IN SUPPORT OF A
!                           BIGGER CACHE
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"; CORRECTED SOME MINOR ERRORS
! 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
!                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
!                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
!                           BUFR FILES UNDER THE MPI)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY; CHANGED CALL FROM
!                           BORT TO BORT2
!
! USAGE:    CALL STRING (STR, LUN, I1, IO)
!   INPUT ARGUMENT LIST:
!     STR      - CHARACTER*(*): STRING OF BLANK-SEPARATED MNEMONICS
!     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
!
!   OUTPUT ARGUMENT LIST:
!     I1       - INTEGER: A NUMBER GREATER THAN OR EQUAL TO THE NUMBER
!                OF BLANK-SEPARATED MNEMONICS IN STR
!     IO       - INTEGER: STATUS INDICATOR FOR BUFR FILE ASSOCIATED
!                WITH LUN:
!                       0 = input file
!                       1 = output file
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT2    PARUSR
!    THIS ROUTINE IS CALLED BY: UFBEVN   UFBGET   UFBIN3   UFBINT
!                               UFBOVR   UFBREP   UFBSTP   UFBTAB
!                               UFBTAM
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      PARAMETER (JCONS=52)

      COMMON /MSGCWD/ NMSG(NFILES),NSUB(NFILES),MSUB(NFILES), &
                      INODE(NFILES),IDATE(NFILES)
      COMMON /STCACH/ MSTR,NSTR,LSTR,LUX(MXS,2),USR(MXS),ICON(JCONS,MXS)
      COMMON /USRSTR/ JCON(JCONS)
      COMMON /STORDS/ IORD(MXS),IORX(MXS)

      CHARACTER*(*) STR
      CHARACTER*128 BORT_STR1,BORT_STR2
      CHARACTER*80  USR,UST

!----------------------------------------------------------------------
!----------------------------------------------------------------------

      NXT = 0
      UST = STR
      IND = INODE(LUN)
      IF(LEN(STR).GT.80) GOTO 900

!     Note that LSTR, MSTR and NSTR were initialized via a prior call to
!     subroutine STRCLN, which itself was called by subroutine MAKESTAB.

!  SEE IF STRING IS IN THE CACHE
!  -----------------------------

      DO N=1,NSTR
      IF(LUX(IORD(N),2).EQ.IND) THEN
         IORX(NXT+1) = IORD(N)
         NXT = NXT+1
      ENDIF
      ENDDO
      DO N=1,NXT
      IF(UST.EQ.USR(IORX(N)))GOTO 1
      ENDDO
      GOTO 2

!  IF IT IS IN THE CACHE, COPY PARAMETERS FROM THE CACHE
!  -----------------------------------------------------

1     DO J=1,JCONS
      JCON(J) = ICON(J,IORX(N))
      ENDDO
      GOTO 100

!  IF IT IS NOT IN THE CACHE, PARSE IT AND PUT IT THERE
!  ----------------------------------------------------

2     CALL PARUSR(STR,LUN,I1,IO)
      LSTR = MAX(MOD(LSTR+1,MSTR+1),1)
      NSTR = MIN(NSTR+1,MSTR)
!  .... File
      LUX(LSTR,1) = LUN
!  .... Table A entry
      LUX(LSTR,2) = IND
      USR(LSTR) = STR
      DO J=1,JCONS
      ICON(J,LSTR) = JCON(J)
      ENDDO

!  REARRANGE THE CACHE ORDER AFTER AN UPDATE
!  -----------------------------------------

      DO N=NSTR,2,-1
      IORD(N) = IORD(N-1)
      ENDDO
      IORD(1) = LSTR

100   IF(JCON(1).GT.I1) GOTO 901

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR1,'("BUFRLIB: STRING - INPUT STRING (",A,") HAS")') &
       STR
      WRITE(BORT_STR2,'(18X,"LENGTH (",I4,"), > LIMIT OF 80 CHAR.")') &
        LEN(STR)
      CALL BORT2(BORT_STR1,BORT_STR2)
901   WRITE(BORT_STR1,'("BUFRLIB: STRING - INPUT STRING (",A,")")') STR
      WRITE(BORT_STR2,'(18X,"HAS",I5," STORE NODES (MNEMONICS) - THE '// &
       'LIMIT (THIRD INPUT ARGUMENT) IS",I5)') JCON(1),I1
      CALL BORT2(BORT_STR1,BORT_STR2)
      END SUBROUTINE STRING
