      SUBROUTINE UPC(CHR,NCHR,IBAY,IBIT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    UPC
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE UNPACKS AND RETURNS A CHARACTER STRING OF
!   LENGTH NCHR CONTAINED WITHIN NCHR BYTES OF IBAY, STARTING WITH BIT
!   (IBIT+1).  ON OUTPUT, IBIT IS UPDATED TO POINT TO THE LAST BIT THAT
!   WAS UNPACKED.  NOTE THAT THE STRING TO BE UNPACKED DOES NOT
!   NECESSARILY NEED TO BE ALIGNED ON A BYTE BOUNDARY WITHIN IBAY.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION
!
! USAGE:    CALL UPC (CHR, NCHR, IBAY, IBIT)
!   INPUT ARGUMENT LIST:
!     NCHR     - INTEGER: NUMBER OF BYTES OF IBAY WITHIN WHICH TO
!                UNPACK CHR (I,E, THE NUMBER OF CHARACTERS IN CHR)
!     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING PACKED
!                CHR
!     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING BIT AFTER
!                WHICH TO START UNPACKING
!
!   OUTPUT ARGUMENT LIST:
!     CHR      - CHARACTER*(*): UNPACKED CHARACTER STRING OF LENGTH
!                NCHR
!     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING LAST BIT
!                THAT WAS UNPACKED
!
! REMARKS:
!    THIS SUBROUTINE IS THE INVERSE OF BUFR ARCHIVE LIBRARY ROUTINE
!    PKC.
!
!    THIS ROUTINE CALLS:        IPKM     IUPM     UPB
!    THIS ROUTINE IS CALLED BY: RDCMPS   RDTREE   READLC   STNDRD
!                               UFBGET   UFBTAB   UFBTAM   WRCMPS   
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /CHARAC/ IASCII,IATOE(0:255),IETOA(0:255)
      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      CHARACTER*(*) CHR
      CHARACTER*8   CVAL
      DIMENSION     IBAY(*),IVAL(2)
      EQUIVALENCE   (CVAL,IVAL)

!----------------------------------------------------------------------
!----------------------------------------------------------------------

      LB = IORD(NBYTW)
      DO I=1,NCHR
      CALL UPB(IVAL(1),8,IBAY,IBIT)
      CHR(I:I) = CVAL(LB:LB)
      IF(IASCII.EQ.0) CALL IPKM(CHR(I:I),1,IATOE(IUPM(CHR(I:I),8)))
      ENDDO

      RETURN
      END SUBROUTINE UPC
