      SUBROUTINE READDX(LUNIT,LUN,LUNDX)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    READDX
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE GENERATES INTERNAL ARRAYS CONTAINING BUFR
C   DICTIONARY TABLES WHICH ARE NEEDED TO READ, WRITE, INITIALIZE OR
C   APPEND A BUFR FILE.  THE INFORMATION USED TO CREATE THE INTERNAL
C   DICTIONARY TABLE ARRAYS (IN COMMON BLOCK /TABABD/) AND THE
C   DICTIONARY MESSAGE CONTROL WORD PARTITION ARRAYS (IN COMMON BLOCK
C   /MSGCWD/) (WHICH ARE ALWAYS THEN ASSOCIATED WITH THE BUFR FILE IN
C   LUNIT) MAY COME FROM AN EXTERNAL, USER-SUPPLIED, BUFR DICTIONARY
C   TABLE FILE IN CHARACTER FORMAT (I.E., A BUFR MNEMONIC TABLE), FROM
C   THE BUFR FILE BEING ACTED UPON (IN WHICH CASE THE FILE MUST BE
C   OPENED FOR INPUT PROCESSING AND POSITIONED AT A DICTIONARY TABLE
C   MESSAGE SOMEWHERE IN THE FILE), OR FROM ANOTHER CURRENTLY OPENED
C   AND DEFINED BUFR FILE.  IN THIS LATTER CASE, THE BUFR FILE WOULD
C   MOST LIKELY BE OPENED FOR INPUT, HOWEVER THERE IS NOTHING
C   PREVENTING THE USE OF A FILE OPEN FOR OUTPUT AS LONG AS IT IS
C   ASSOCIATED WITH INTERNAL DICTIONARY ARRAYS THAT CAN BE USED.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY OR FOR INFORMATIONAL
C                           PURPOSES
C
C USAGE:    CALL READDX (LUNIT, LUN, LUNDX)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C                BEING READ, WRITTEN, INITIALIZED OR APPENDED
C     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
C                (ASSOCIATED WITH FILE CONNECTED TO LOGICAL UNIT LUNIT)
C     LUNDX    - INTEGER: FORTRAN LOGICAL UNIT NUMBER CONTAINING
C                DICTIONARY TABLE INFORMATION TO BE USED IN READING/
C                WRITING FROM/TO LUNIT (DEPENDING ON THE CASE); MAY BE
C                SET EQUAL TO LUNIT IF DICTIONARY TABLE INFORMATION IS
C                ALREADY EMBEDDED IN LUNIT (BUT ONLY IF LUNIT IS BEING
C                READ)
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     CPBFDX   RDBFDX   RDUSDX
C                               STATUS
C    THIS ROUTINE IS CALLED BY: OPENBF   WRITDX
C                               Normally not called by any application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /QUIET/ IPRT

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  GET THE BUFR STATUS OF UNIT LUNDX
C  ---------------------------------

      CALL STATUS(LUNDX,LUD,ILDX,IMDX)

C  READ A DICTIONARY TABLE FROM THE INDICATED SOURCE
C  -------------------------------------------------

      IF (LUNIT.EQ.LUNDX) THEN
c  .... Source is input BUFR file in LUNIT
         IF(IPRT.GE.2) PRINT100,LUNDX
         REWIND LUNIT
         CALL RDBFDX(LUNIT,LUN)
      ELSEIF(ILDX.EQ.-1) THEN
c  .... Source is input BUFR file in LUNDX
c       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) PRINT101,LUNDX,LUNIT
         CALL CPBFDX(LUD,LUN)
      ELSEIF(ILDX.EQ.1) THEN
c  .... Source is output BUFR file in LUNDX
c       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) PRINT102,LUNDX,LUNIT
         CALL CPBFDX(LUD,LUN)
      ELSEIF(ILDX.EQ.0) THEN
c  .... Source is user-suppl char. tbl in LUNDX
c       BUFR file in LUNIT may be in- or output
         IF(IPRT.GE.2) PRINT103,LUNDX
         REWIND LUNDX
         CALL RDUSDX(LUNDX,LUN)
      ELSE
         GOTO 900
      ENDIF

100   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ',
     . '- READING BUFR DICTIONARY TABLE FROM INPUT BUFR FILE IN UNIT ',
     . I2,' INTO INTERNAL ARRAYS'/17('+'),'BUFR ARCHIVE LIBRARY',20('+')
     . /)
101   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ',
     . '- COPYING BUFR DCTY TBL FROM INTERNAL ARRAYS ASSOC. W/ INPUT ',
     . 'FILE IN UNIT ',I2,' TO THOSE ASSOC. W/ FILE IN UNIT ',I2/
     . 17('+'),'BUFR ARCHIVE LIBRARY',20('+')/)
102   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ',
     . '- COPYING BUFR DCTY TBL FROM INTERNAL ARRAYS ASSOC. W/ OUTPUT ',
     . 'FILE IN UNIT ',I2,' TO THOSE ASSOC. W/ FILE IN UNIT ',I2/
     . 17('+'),'BUFR ARCHIVE LIBRARY',20('+')/)
103   FORMAT(/17('+'),'BUFR ARCHIVE LIBRARY',20('+')/'BUFRLIB: READDX ',
     . '- READING BUFR DICTIONARY TABLE FROM USER-SUPPLIED TEXT FILE ',
     . 'IN UNIT ',I2,' INTO INTERNAL ARRAYS'/17('+'),'BUFR ARCHIVE ',
     . 'LIBRARY',20('+')/)

C  EXITS
C  -----

      RETURN
900   CALL BORT('BUFRLIB: READDX - CANNOT DETERMINE SOURCE OF '//
     . 'INPUT DICTIONARY TABLE')
      END
