subroutine da_transform_vptox(grid, vp, be, ep)

   !-----------------------------------------------------------------------
   ! Purpose: Physical transform of analysis increment variables.
   !    Updated for Analysis on Arakawa-C grid
   !    Author: Syed RH Rizvi,  MMM/ESSL/NCAR,  Date: 10/22/2008
   ! Updates:
   !
   !       Implementation of multi-variate BE for cv_options=6
   !       Syed RH Rizvi,  MMM/NESL/NCAR,  Date: 02/01/2010
   !-----------------------------------------------------------------------

   implicit none

   type (domain), intent(inout)         :: grid
   
   type (vp_type), intent(inout)        :: vp  ! CV on grid structure.
   type (be_type), intent(in), optional :: be  ! Background errors.
   type (ep_type), intent(in), optional :: ep  ! Ensemble perturbations.

   integer :: i, k, j, k1, ij            ! Loop counters.
   real, allocatable          :: chi_u(:,:,:)  ! Unbalanced chi

   if (trace_use) call da_trace_entry("da_transform_vptox") 

   !---------------------------------------------------------------------------
   !  [1] Add flow-dependent increments in control variable space (vp):
   !---------------------------------------------------------------------------

   if (be % ne > 0 .and. alphacv_method == alphacv_method_vp) then
      call da_add_flow_dependence_vp(be % ne, ep, vp, its,ite, jts,jte, kts,kte)
   end if

   !--------------------------------------------------------------------------
   ! [2] Impose statistical balance constraints:
   !--------------------------------------------------------------------------

   !$OMP PARALLEL DO &
   !$OMP PRIVATE ( ij, k1, k, j, i)
   do ij = 1 , grid%num_tiles

   allocate (chi_u(its:ite,grid%j_start(ij):grid%j_end(ij),kts:kte) )

   ! Chi:
   do k = kts, kte
      do j = grid%j_start(ij), grid%j_end(ij)
         do i = its, ite
            chi_u(i,j,k) = vp%v2(i,j,k)
            vp%v2(i,j,k) = vp%v2(i,j,k) + be%reg_psi_chi(j,k)* vp%v1(i,j,k)
         end do
      end do
   end do
  
   ! Temperature:
   do k = kts, kte
      do j = grid%j_start(ij), grid%j_end(ij)
         do i = its, ite
            grid%xa%t(i,j,k) = vp%v3(i,j,k)
         end do
      end do
   end do


   do k1 = kts, kte
      do k = kts, kte
         do j = grid%j_start(ij), grid%j_end(ij)
            do i = its, ite
              grid%xa%t(i,j,k) = grid%xa%t(i,j,k) + &
              be%reg_psi_t(j,k,k1)*vp%v1(i,j,k1) + be%reg_chi_u_t(j,k,k1)*chi_u(i,j,k1)
            end do
         end do
      end do
   end do

   ! Surface Pressure
   do j = grid%j_start(ij), grid%j_end(ij)
      do i = its, ite
         grid%xa%psfc(i,j) = vp%v5(i,j,1) 
      end do
   end do

   do k = kts,kte
      do j = grid%j_start(ij), grid%j_end(ij)
         do i = its, ite
            grid%xa%psfc(i,j) = grid%xa%psfc(i,j) +  &
            be%reg_psi_ps(j,k)*vp%v1(i,j,k) + be%reg_chi_u_ps(j,k)*chi_u(i,j,k)
         end do
      end do
   end do

   ! Moisture
   do k1 = kts, kte
      do k = kts, kte
         do j = grid%j_start(ij), grid%j_end(ij)
            do i = its, ite
              vp%v4(i,j,k1) = vp%v4(i,j,k1) + be%reg_psi_rh(j,k1,k)*vp%v1(i,j,k) + &
              be%reg_chi_u_rh(j,k1,k)*chi_u(i,j,k) + be%reg_t_u_rh(j,k1,k)*vp%v3(i,j,k)
            end do
         end do
      end do
   end do

!
   do k = kts, kte
      do j = grid%j_start(ij), grid%j_end(ij)
         do i = its, ite
            vp%v4(i,j,k) = vp%v4(i,j,k) + be%reg_ps_u_rh(j,k)*vp%v5(i,j,1)
         end do
      end do
   end do

!
   deallocate (chi_u )

   end do
   !$OMP END PARALLEL DO
   !--------------------------------------------------------------------------
   ! [3] Transform to model variable space:
   !--------------------------------------------------------------------------
  
#ifdef A2C
  if ((fg_format==fg_format_wrf_arw_regional  .or. &
       fg_format==fg_format_wrf_arw_global  ) .and. ide == ipe ) then
     ipe = ipe + 1
     ide = ide + 1
  end if

  if ((fg_format==fg_format_wrf_arw_regional  .or. &
       fg_format==fg_format_wrf_arw_global  ) .and. jde == jpe ) then
     jpe = jpe + 1
     jde = jde + 1
  end if
#endif

#ifdef DM_PARALLEL
#include "HALO_PSICHI_UV.inc"
#endif

#ifdef A2C
  if ((fg_format==fg_format_wrf_arw_regional  .or. &
       fg_format==fg_format_wrf_arw_global  ) .and. ide == ipe ) then
     ipe = ipe - 1
     ide = ide - 1
  end if

  if ((fg_format==fg_format_wrf_arw_regional  .or. &
       fg_format==fg_format_wrf_arw_global  ) .and. jde == jpe ) then
     jpe = jpe - 1
     jde = jde - 1
  end if
#endif

   ! Psi and chi to u and v:

   call da_psichi_to_uv(vp % v1, vp % v2, grid%xb % coefx, &
      grid%xb % coefy , grid%xa % u, grid%xa % v)

  if ( (use_radarobs .and. use_radar_rf) .or. (use_rad .and. crtm_cloud) ) then

   if ( var4d.and.use_radarobs .and. use_radar_rf.and.cloud_cv_options == 1) then
    print*,' 4Dvar run with Radar RF, please use cloud_cv, and set cloud_cv_options to 2 or 2; stop now'
    stop 
   end if

   if ( cloud_cv_options == 1 ) then
      ! Pseudo RH --> Total water mixing ratio:
      !$OMP PARALLEL DO &
      !$OMP PRIVATE ( ij, i, j, k )
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                 grid%xa % qt(i,j,k) = vp%v4(i,j,k) * grid%xb%qs(i,j,k)
               enddo
            enddo
         enddo
      enddo
      !$OMP END PARALLEL DO
   else
      ! Pseudo RH --> Water vapor mixing ratio:
      !$OMP PARALLEL DO &
      !$OMP PRIVATE ( ij, i, j, k )
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                  grid%xa % q(i,j,k) =  vp%v4(i,j,k) * grid%xb%qs(i,j,k)
               enddo
            enddo
         enddo
      enddo
#ifdef CLOUD_CV
!cw
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                  if(cloud_cv_options == 2)then
                   grid%xa % qcw(i,j,k) =  vp%v6(i,j,k) * grid%xb%qs(i,j,k)
                  elseif(cloud_cv_options == 3)then
                   grid%xa % qcw(i,j,k) =  vp%v6(i,j,k)
!                  elseif(mcv_options.eq.1)then
!                   grid%xa % qcw(i,j,k) =  0.0
                  endif
               enddo
            enddo
         enddo
      enddo
!    grid%xa % qcw =  0.0
!rn
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                  if(cloud_cv_options == 2)then
                   grid%xa % qrn(i,j,k) =  vp%v7(i,j,k) * grid%xb%qs(i,j,k)
                  elseif(cloud_cv_options == 3)then
                   grid%xa % qrn(i,j,k) =  vp%v7(i,j,k)
!                  elseif(mcv_options.eq.4)then
!                   grid%xa % qcw(i,j,k) =  0.0
                  endif
               enddo
            enddo
         enddo
      enddo
!     grid%xa % qrn = 0.0
!ice
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                  if(cloud_cv_options == 2)then
                   grid%xa % qci(i,j,k) =  vp%v8(i,j,k) * grid%xb%qs(i,j,k)
                  elseif(cloud_cv_options == 3)then
                   grid%xa % qci(i,j,k) =  vp%v8(i,j,k)
!                  elseif(mcv_options.eq.4)then
!                   grid%xa % qci(i,j,k) =  0.0
                  endif
               enddo
            enddo
         enddo
      enddo
#endif
      !$OMP END PARALLEL DO
   end if
  else  ! no rf or cloud radiance
      ! Pseudo RH --> Water vapor mixing ratio:
      !$OMP PARALLEL DO &
      !$OMP PRIVATE ( ij, i, j, k )
      do ij = 1 , grid%num_tiles
         do k = kts, kte
            do j = grid%j_start(ij), grid%j_end(ij)
               do i = its, ite
                  grid%xa % q(i,j,k) =  vp%v4(i,j,k) * grid%xb%qs(i,j,k)
               enddo
            enddo
         enddo
      enddo
      !$OMP END PARALLEL DO
  end if ! RF or Radiance
   !---------------------------------------------------------------------------
   !  [4] Add flow-dependent increments in model space (grid%xa):
   !---------------------------------------------------------------------------

   if (be % ne > 0 .and. alphacv_method == alphacv_method_xa) then
      call da_add_flow_dependence_xa(grid, be % ne, ep, vp)
   end if

   if (trace_use) call da_trace_exit("da_transform_vptox") 
 
end subroutine da_transform_vptox

