#include "cnames.h"

/*
  Helmut Frank, updated 24.07.2003: UVB, PAR, CAPE
*/

struct ParmTable parm_table_ecmwf_128[256] = {
      /* 0 */ {"var0", "undefined"},
      /* 1 */ {"STRF", "Stream function [m**2 s**-1]"},
      /* 2 */ {"VPOT", "Velocity potential [m**2 s**-1]"},
      /* 3 */ {"PT", "Potential temperature [K]"},
      /* 4 */ {"EQPT", "Equivalent potential temperature [K]"},
      /* 5 */ {"SEPT", "Saturated equivalent potential temperature [K]"},
      /* 6 */ {"var6", "Reserved for Metview"},
      /* 7 */ {"var7", "Reserved for Metview"},
      /* 8 */ {"var8", "Reserved for Metview"},
      /* 9 */ {"var9", "Reserved for Metview"},
      /* 10 */ {"var10", "Reserved for Metview"},
      /* 11 */ {"UDVW", "U component of divergent wind [m s**-1]"},
      /* 12 */ {"VDVW", "V component of divergent wind [m s**-1]"},
      /* 13 */ {"URTW", "U component of rotational wind [m s**-1]"},
      /* 14 */ {"VRTW", "V component of rotational wind [m s**-1]"},
      /* 15 */ {"var15", "Reserved for Metview"},
      /* 16 */ {"var16", "Reserved for Metview"},
      /* 17 */ {"var17", "Reserved for Metview"},
      /* 18 */ {"var18", "Reserved for Metview"},
      /* 19 */ {"var19", "Reserved for Metview"},
      /* 20 */ {"var20", "Reserved for Metview"},
      /* 21 */ {"UCTP", "Unbalanced component of temperature [K]"},
      /* 22 */ {"UCLN", "Unbalanced component of logarithm of surface pressure"},
      /* 23 */ {"UCDV", "Unbalanced component of divergence [s**-1]"},
      /* 24 */ {"var24", "Reserved for future unbalanced components"},
      /* 25 */ {"var25", "Reserved for future unbalanced components"},
      /* 26 */ {"CL", "Lake cover [(0-1)]"},
      /* 27 */ {"CVL", "Low vegetation cover [(0-1)]"},
      /* 28 */ {"CVH", "High vegetation cover [(0-1)]"},
      /* 29 */ {"TVL", "Type of low vegetation"},
      /* 30 */ {"TVH", "Type of high vegetation"},
      /* 31 */ {"CI", "Sea-ice cover [(0-1)]"},
      /* 32 */ {"ASN", "Snow albedo [(0-1)]"},
      /* 33 */ {"RSN", "Snow density [kg m**-3]"},
      /* 34 */ {"SSTK", "Sea surface temperature [K]"},
      /* 35 */ {"ISTL1", "Ice surface temperature layer 1 [K]"},
      /* 36 */ {"ISTL2", "Ice surface temperature layer 2 [K]"},
      /* 37 */ {"ISTL3", "Ice surface temperature layer 3 [K]"},
      /* 38 */ {"ISTL4", "Ice surface temperature layer 4 [K]"},
      /* 39 */ {"SWVL1", "Volumetric soil water layer 1 [m**3 m**-3]"},
      /* 40 */ {"SWVL2", "Volumetric soil water layer 2 [m**3 m**-3]"},
      /* 41 */ {"SWVL3", "Volumetric soil water layer 3 [m**3 m**-3]"},
      /* 42 */ {"SWVL4", "Volumetric soil water layer 4 [m**3 m**-3]"},
      /* 43 */ {"SLT", "Soil type"},
      /* 44 */ {"ES", "Snow evaporation [m of water]"},
      /* 45 */ {"SMLT", "Snowmelt [m of water]"},
      /* 46 */ {"SDUR", "Solar duration [s]"},
      /* 47 */ {"DSRP", "Direct solar radiation [w m**-2]"},
      /* 48 */ {"MAGSS", "Magnitude of surface stress [N m**-2 s]"},
      /* 49 */ {"10FG", "Wind gust at 10 metres [m s**-1]"},
      /* 50 */ {"LSPF", "Large-scale precipitation fraction [s]"},
      /* 51 */ {"MX2T24", "Maximum 2 metre temperature [K]"},
      /* 52 */ {"MN2T24", "Minimum 2 metre temperature [K]"},
      /* 53 */ {"MONT", "Montgomery potential [m**2 s**-2]"},
      /* 54 */ {"PRES", "Pressure [Pa]"},
      /* 55 */ {"var55", "undefined"},
      /* 56 */ {"var56", "undefined"},
      /* 57 */ {"UVB", "Downward UV radiation at the surface (Ultra-violet band B) [W m**-2]"},
      /* 58 */ {"PAR", "Photosynthetically active radiation at the surface [W m**-2]"},
      /* 59 */ {"CAPE", "Convective available potential energy [J kg**-1]"},
      /* 60 */ {"PV", "Potential vorticity [K m**2 kg**-1 s**-1]"},
      /* 61 */ {"var61", "undefined"},
      /* 62 */ {"var62", "undefined"},
      /* 63 */ {"var63", "undefined"},
      /* 64 */ {"var64", "undefined"},
      /* 65 */ {"var65", "undefined"},
      /* 66 */ {"var66", "undefined"},
      /* 67 */ {"var67", "undefined"},
      /* 68 */ {"var68", "undefined"},
      /* 69 */ {"var69", "undefined"},
      /* 70 */ {"var70", "undefined"},
      /* 71 */ {"var71", "undefined"},
      /* 72 */ {"var72", "undefined"},
      /* 73 */ {"var73", "undefined"},
      /* 74 */ {"var74", "undefined"},
      /* 75 */ {"var75", "undefined"},
      /* 76 */ {"var76", "undefined"},
      /* 77 */ {"var77", "undefined"},
      /* 78 */ {"var78", "undefined"},
      /* 79 */ {"var79", "undefined"},
      /* 80 */ {"var80", "undefined"},
      /* 81 */ {"var81", "undefined"},
      /* 82 */ {"var82", "undefined"},
      /* 83 */ {"var83", "undefined"},
      /* 84 */ {"var84", "undefined"},
      /* 85 */ {"var85", "undefined"},
      /* 86 */ {"var86", "undefined"},
      /* 87 */ {"var87", "undefined"},
      /* 88 */ {"var88", "undefined"},
      /* 89 */ {"var89", "undefined"},
      /* 90 */ {"var90", "undefined"},
      /* 91 */ {"var91", "undefined"},
      /* 92 */ {"var92", "undefined"},
      /* 93 */ {"var93", "undefined"},
      /* 94 */ {"var94", "undefined"},
      /* 95 */ {"var95", "undefined"},
      /* 96 */ {"var96", "undefined"},
      /* 97 */ {"var97", "undefined"},
      /* 98 */ {"var98", "undefined"},
      /* 99 */ {"var99", "undefined"},
      /* 100 */ {"100", "Experimental product [Undefined]"},
      /* 101 */ {"101", "Experimental product [Undefined]"},
      /* 102 */ {"102", "Experimental product [Undefined]"},
      /* 103 */ {"103", "Experimental product [Undefined]"},
      /* 104 */ {"104", "Experimental product [Undefined]"},
      /* 105 */ {"105", "Experimental product [Undefined]"},
      /* 106 */ {"106", "Experimental product [Undefined]"},
      /* 107 */ {"107", "Experimental product [Undefined]"},
      /* 108 */ {"108", "Experimental product [Undefined]"},
      /* 109 */ {"109", "Experimental product [Undefined]"},
      /* 110 */ {"110", "Experimental product [Undefined]"},
      /* 111 */ {"111", "Experimental product [Undefined]"},
      /* 112 */ {"112", "Experimental product [Undefined]"},
      /* 113 */ {"113", "Experimental product [Undefined]"},
      /* 114 */ {"114", "Experimental product [Undefined]"},
      /* 115 */ {"115", "Experimental product [Undefined]"},
      /* 116 */ {"116", "Experimental product [Undefined]"},
      /* 117 */ {"117", "Experimental product [Undefined]"},
      /* 118 */ {"118", "Experimental product [Undefined]"},
      /* 119 */ {"119", "Experimental product [Undefined]"},
      /* 120 */ {"120", "Experimental product [Undefined]"},
      /* 121 */ {"var121", "undefined"},
      /* 122 */ {"var122", "undefined"},
      /* 123 */ {"var123", "undefined"},
      /* 124 */ {"var124", "undefined"},
      /* 125 */ {"var125", "undefined"},
      /* 126 */ {"var126", "undefined"},
      /* 127 */ {"AT", "Atmospheric tide"},
      /* 128 */ {"BV", "Budget values"},
      /* 129 */ {"Z", "Geopotential [m**2 s**-2]"},
      /* 130 */ {"T", "Temperature [K]"},
      /* 131 */ {"U", "U velocity [m s**-1]"},
      /* 132 */ {"V", "V velocity [m s**-1]"},
      /* 133 */ {"Q", "Specific humidity [kg kg**-1]"},
      /* 134 */ {"SP", "Surface pressure [Pa]"},
      /* 135 */ {"W", "Vertical velocity [Pa s**-1]"},
      /* 136 */ {"TCW", "Total column water [kg m**-2]"},
      /* 137 */ {"TCWV", "Total column water vapour [kg m**-2]"},
      /* 138 */ {"VO", "Vorticity (relative) [s**-1]"},
      /* 139 */ {"STL1", "Soil temperature level 1 [K]"},
      /* 140 */ {"SWL1", "Soil wetness level 1 [m of water]"},
      /* 141 */ {"SD", "Snow depth [m of water equivalent]"},
      /* 142 */ {"LSP", "Stratiform precipitation [m]"},
      /* 143 */ {"CP", "Convective precipitation [m]"},
      /* 144 */ {"SF", "Snowfall (convective + stratiform) [m of water equivalent]"},
      /* 145 */ {"BLD", "Boundary layer dissipation [W m**-2 s]"},
      /* 146 */ {"SSHF", "Surface sensible heat flux [W m**-2 s]"},
      /* 147 */ {"SLHF", "Surface latent heat flux [W m**-2 s]"},
      /* 148 */ {"CHNK", "Charnock"},
      /* 149 */ {"SNR", "Surface net radiation [W m**-2 s]"},
      /* 150 */ {"TNR", "Top net radiation"},
      /* 151 */ {"MSL", "Mean sea-level pressure [Pa]"},
      /* 152 */ {"LNSP", "Logarithm of surface pressure"},
      /* 153 */ {"SWHR", "Short-wave heating rate [K]"},
      /* 154 */ {"LWHR", "Long-wave heating rate [K]"},
      /* 155 */ {"D", "Divergence [s**-1]"},
      /* 156 */ {"GH", "Height [m]"},
      /* 157 */ {"R", "Relative humidity [%]"},
      /* 158 */ {"TSP", "Tendency of surface pressure [Pa s**-1]"},
      /* 159 */ {"BLH", "Boundary layer height [m]"},
      /* 160 */ {"SDOR", "Standard deviation of orography"},
      /* 161 */ {"ISOR", "Anisotropy of sub-gridscale orography"},
      /* 162 */ {"ANOR", "Angle of sub-gridscale orography [rad]"},
      /* 163 */ {"SLOR", "Slope of sub-gridscale orography"},
      /* 164 */ {"TCC", "Total cloud cover [(0 - 1)]"},
      /* 165 */ {"10U", "10 metre U wind component [m s**-1]"},
      /* 166 */ {"10V", "10 metre V wind component [m s**-1]"},
      /* 167 */ {"2T", "2 metre temperature [K]"},
      /* 168 */ {"2D", "2 metre dewpoint temperature [K]"},
      /* 169 */ {"SSRD", "Surface solar radiation downwards [W m**-2 s]"},
      /* 170 */ {"STL2", "Soil temperature level 2 [K]"},
      /* 171 */ {"SWL2", "Soil wetness level 2 [m of water]"},
      /* 172 */ {"LSM", "Land/sea mask [(0, 1)]"},
      /* 173 */ {"SR", "Surface roughness [m]"},
      /* 174 */ {"AL", "Albedo [(0 - 1)]"},
      /* 175 */ {"STRD", "Surface thermal radiation downwards [W m**-2 s]"},
      /* 176 */ {"SSR", "Surface solar radiation [W m**-2 s]"},
      /* 177 */ {"STR", "Surface thermal radiation [W m**-2 s]"},
      /* 178 */ {"TSR", "Top solar radiation [W m**-2 s]"},
      /* 179 */ {"TTR", "Top thermal radiation [W m**-2 s]"},
      /* 180 */ {"EWSS", "East/West surface stress [N m**-2 s]"},
      /* 181 */ {"NSSS", "North/South surface stress [N m**-2 s]"},
      /* 182 */ {"E", "Evaporation [m of water]"},
      /* 183 */ {"STL3", "Soil temperature level 3 [K]"},
      /* 184 */ {"SWL3", "Soil wetness level 3 [m of water]"},
      /* 185 */ {"CCC", "Convective cloud cover [(0 - 1)]"},
      /* 186 */ {"LCC", "Low cloud cover [(0 - 1)]"},
      /* 187 */ {"MCC", "Medium cloud cover [(0 - 1)]"},
      /* 188 */ {"HCC", "High cloud cover [(0 - 1)]"},
      /* 189 */ {"SUND", "Sunshine duration [s]"},
      /* 190 */ {"EWOV", "EW component of subgrid orographic variance [m**2]"},
      /* 191 */ {"NSOV", "NS component of subgrid orographic variance [m**2]"},
      /* 192 */ {"NWOV", "NWSE component of subgrid orographic variance [m**2]"},
      /* 193 */ {"NEOV", "NESW component of subgrid orographic variance [m**2]"},
      /* 194 */ {"BTMP", "Brightness temperature [K]"},
      /* 195 */ {"LGWS", "Lat. component of gravity wave stress [N m**-2 s]"},
      /* 196 */ {"MGWS", "Meridional component of gravity wave stress [N m**-2 s]"},
      /* 197 */ {"GWD", "Gravity wave dissipation [W m**-2 s]"},
      /* 198 */ {"SRC", "Skin reservoir content [m of water]"},
      /* 199 */ {"VEG", "Vegetation fraction [(0 - 1)]"},
      /* 200 */ {"VSO", "Variance of sub-gridscale orography [m**2]"},
      /* 201 */ {"MX2T", "Maximum 2 metre temperature since previous post-processing [K]"},
      /* 202 */ {"MN2T", "Minimum 2 metre temperature since previous post-processing [K]"},
      /* 203 */ {"O3", "Ozone mass mixing ratio [kg kg**-1]"},
      /* 204 */ {"PAW", "Precipiation analysis weights"},
      /* 205 */ {"RO", "Runoff [m]"},
      /* 206 */ {"TCO3", "Total column ozone [Dobson]"},
      /* 207 */ {"10SI", "10 meter windspeed [m s**-1]"},
      /* 208 */ {"TSRC", "Top net solar radiation, clear sky [W m**-2]"},
      /* 209 */ {"TTRC", "Top net thermal radiation, clear sky [W m**-2]"},
      /* 210 */ {"SSRC", "Surface net solar radiation, clear sky [W m**-2]"},
      /* 211 */ {"STRC", "Surface net thermal radiation, clear sky [W m**-2]"},
      /* 212 */ {"SI", "Solar insolation [W m**-2]"},
      /* 213 */ {"var213", "undefined"},
      /* 214 */ {"DHR", "Diabatic heating by radiation [K]"},
      /* 215 */ {"DHVD", "Diabatic heating by vertical diffusion [K]"},
      /* 216 */ {"DHCC", "Diabatic heating by cumulus convection [K]"},
      /* 217 */ {"DHLC", "Diabatic heating large-scale condensation [K]"},
      /* 218 */ {"VDZW", "Vertical diffusion of zonal wind [m s**-1]"},
      /* 219 */ {"VDMW", "Vertical diffusion of meridional wind [m s**-1]"},
      /* 220 */ {"EWGD", "EW gravity wave drag tendency [m s**-1]"},
      /* 221 */ {"NSGD", "NS gravity wave drag tendency [m s**-1]"},
      /* 222 */ {"CTZW", "Convective tendency of zonal wind [m s**-1]"},
      /* 223 */ {"CTMW", "Convective tendency of meridional wind [m s**-1]"},
      /* 224 */ {"VDH", "Vertical diffusion of humidity [kg kg**-1]"},
      /* 225 */ {"HTCC", "Humidity tendency by cumulus convection [kg kg**-1]"},
      /* 226 */ {"HTLC", "Humidity tendency large-scale condensation [kg kg**-1]"},
      /* 227 */ {"CRNH", "Change from removing negative humidity [kg kg**-1]"},
      /* 228 */ {"TP", "Total precipitation [m]"},
      /* 229 */ {"IEWS", "Instantaneous X surface stress [N m**-2]"},
      /* 230 */ {"INSS", "Instantaneous Y surface stress [N m**-2]"},
      /* 231 */ {"ISHF", "Instantaneous surface heat flux [W m**-2]"},
      /* 232 */ {"IE", "Instantaneous moisture flux [kg m**-2 s]"},
      /* 233 */ {"ASQ", "Apparent surface humidity [kg kg**-1]"},
      /* 234 */ {"LSRH", "Logarithm of surface roughness length for heat"},
      /* 235 */ {"SKT", "Skin temperature [K]"},
      /* 236 */ {"STL4", "Soil temperature level 4 [K]"},
      /* 237 */ {"SWL4", "Soil wetness level 4 [m]"},
      /* 238 */ {"TSN", "Temperature of snow layer [K]"},
      /* 239 */ {"CSF", "Convective snowfall [m of water equivalent]"},
      /* 240 */ {"LSF", "Large-scale snowfall [m of water equivalent]"},
      /* 241 */ {"ACF", "Accumulated cloud fraction tendency [(-1 to 1)]"},
      /* 242 */ {"ALW", "Accumulated liquid water tendency [(-1 to 1)]"},
      /* 243 */ {"FAL", "Forecast albedo [(0 - 1)]"},
      /* 244 */ {"FSR", "Forecast surface roughness [m]"},
      /* 245 */ {"FLSR", "Forecast log of surface roughness for heat"},
      /* 246 */ {"CLWC", "Cloud liquid water content [kg kg**-1]"},
      /* 247 */ {"CIWC", "Cloud ice water content [kg kg**-1]"},
      /* 248 */ {"CC", "Cloud cover [(0 - 1)]"},
      /* 249 */ {"AIW", "Accumulated ice water tendency [(-1 to 1)]"},
      /* 250 */ {"ICE", "Ice age [1,0]"},
      /* 251 */ {"ATTE", "Adiabatic tendency of temperature [K]"},
      /* 252 */ {"ATHE", "Adiabatic tendency of humidity [kg kg**-1]"},
      /* 253 */ {"ATZE", "Adiabatic tendency of zonal wind [m s**-1]"},
      /* 254 */ {"ATMW", "Adiabatic tendency of meridional wind [m s**-1]"},
      /* 255 */ {"var255", "Indicates a missing value"},
};
