      SUBROUTINE SKEWT_BACKGROUND
C
C  SKEWT_BACKGROUND:  PLOTS BACKGROUND FOR A SKEWT, LOG P THERMODYNAMIC DIAGRAM
C
      COMMON /SKWDRW/ ISKDRW
C
C  ENCODE BUFFER
C
      CHARACTER*4 ITIT
C
C  SKEWT BORDER
C
      DIMENSION XB(7),YB(7)
      DATA XB/-19.,27.1,27.1,18.6,18.6,-19.,-19./
      DATA YB/-.9346217,-.9346217,9.,17.53,44.061,44.061,-.9346217/
C
C  PRESSURE LINE SPECS
C
      DIMENSION PLV(11),PLN(11,2)
      DATA PLV/100.,200.,300.,400.,500.,600.,700.,800.,900.,
     &         1000.,1050./
      DATA PLN/11*-19.,4*18.6,22.83,26.306,5*27.1/
C
C  TEMPERATURE LINE SPECS
C
      DIMENSION TP(15,2)
      DATA TP/8*1050.,855.,625.,459.,337.,247.,181.,132.,730.,580.,
     &        500.,430.,342.,251.,185.,135.,7*100./
C
C  MIXING RATIO SPECS
C
      REAL        RAT(8)
      CHARACTER*2 LRAT(8)
      DATA RAT/20.,12.,8.,5.,3.,2.,1.,0.4/
      DATA LRAT/'20','12',' 8',' 5',' 3',' 2',' 1','.4'/
C
C  DRY/SATURATED ADAIBAT BUFFERS
C
      DIMENSION SX(162),SY(162),Y45(162)
C
C  DEGREES TO RADIANS, ABSOLUTE ZERO
C
      PARAMETER (ABZ = 273.16)
C
C  MAPPINGS FROM (P,T) TO CM ON SKEWT
C
      FY(P)=132.182-44.061*ALOG10(P)
      FX(T,Y)=0.54*T+0.90692*Y
C
C  DRAW SKEWT BORDER
C
      CALL GFLAS1 (1)
      CALL SET(.05,.95,.05,.95,-19.0,27.1,-.9346217,44.061,1)
      CALL CURVE(XB,YB,7)
C
C  DRAW THE PRESSURE LINES
C
      DO 10 K=1,11
         Y1=FY(PLV(K))
         IF(K.NE.1.AND.K.NE.11) CALL LINE(PLN(K,1),Y1,PLN(K,2),Y1)
         ITS=NINT(PLV(K))
      WRITE (ITIT,101) ITS
  101    FORMAT(I4)
C        CALL PWRY(-20.9,Y1,ITIT,4,1.9,0,0)
      CALL WTSTR (-19.2,Y1,ITIT,11,0,1)
   10 CONTINUE
C
C  DRAW TEMPERATURE LINES
C
      T=40.
      DO 20 I=1,15
         Y1=FY(TP(I,1))
         Y2=FY(TP(I,2))
         X1=FX(T,Y1)
         X2=FX(T,Y2)
         CALL LINE(X1,Y1,X2,Y2)
         ITS=NINT(T)
         IF(ITS.EQ.20) GO TO 19
            X2=X2+0.4
            Y2=Y2+0.441
      WRITE (ITIT,101) ITS
C           CALL PWRY(X2,Y2,ITIT,4,12,.83422,0)
      CALL WTSTR (X2,Y2,ITIT,12,47,-1)
   19    T=T-10.
   20 CONTINUE
C
C  TICK MARKS AT 500 MB
C
      Y1=13.2627
      Y2=13.75
      T=-52.
      DO 25 I=1,31
         T=T+2.
         IF(AMOD(T,10.).EQ.0.)GO TO 25
         X1=FX(T,Y1)
         X2=FX(T,Y2)
         CALL LINE(X1,Y1,X2,Y2)
   25 CONTINUE
C
C  DRAW MIXING RATIO LINES
C
      CALL DASHDB (3855)      ! PATTERN = 0000111100001111
      Y1=FY(1050.)
      Y2=FY(700.)
      DO 30 I=1,8
         X1=FX(SKEWT_TMR(RAT(I),1050.)-ABZ,Y1)
         X2=FX(SKEWT_TMR(RAT(I), 700.)-ABZ,Y2)
         CALL LINED(X1,Y1,X2,Y2)
C        CALL PWRY(X2,Y2+0.6,LRAT(I),2,10,0,1)
      CALL WTSTR (X2,Y2+0.6,LRAT(I),10,0,0)
   30 CONTINUE
C
C  DRAW SATURATED ADIABATS
C
      CALL DASHDB (31710)     ! PATTERN = 0111101111011110
      TS=32.
      DO 40 I=1,7
         P=1060.
         TK=TS+ABZ
         AOS=SKEWT_OS(TK,1000.)
         DO 35 J=1,86
            P=P-10.
            ATSA=SKEWT_TSA(AOS,P)-ABZ
            SY(J)=FY(P)
            SX(J)=FX(ATSA,SY(J))
   35    CONTINUE
         CALL CURVED(SX,SY,86)
         ITS=NINT(TS)
      WRITE (ITIT,102) ITS
  102    FORMAT(I2)
C        CALL PWRY(SX(86),SY(86)+0.6,ITIT,2,10,0,1)
      CALL WTSTR (SX(86),SY(86)+0.6,ITIT(1:2),10,0,0)
         TS=TS-4.0
   40 CONTINUE
C
C  DRAW DRY ADIABAT LINES
C
      CALL DASHDB (21845)     ! PATTERN = 0101010101010101
C     CALL DASHD(4444B)
      T=51.
      DO 45 I=1,162
         Y45(I)=66.67*(5.7625544-ALOG(T+ABZ))
         T=T-1.0
   45 CONTINUE
      T=450.
      TD=52.
      DO 55 I=1,20
         T=T-10.
         K=0
         YD=66.67*(ALOG(T)-5.7625544)
         DO 50 J=1,162
            YPD=Y45(J)+YD
            TX=TD-FLOAT(J)
            IF(YPD.GT.44.061) GO TO 54
            IF(YPD.LT.-.9346217) GO TO 50
            XPD=FX(TX,YPD)
            IF(XPD.LT.-19.0)GO TO 54
            IF(XPD.GT.27.1)GO TO 50
            IF(XPD.GT.18.6.AND.T.GT.350.0)GO TO 50
               K=K+1
               SX(K)=XPD
               SY(K)=YPD
   50    CONTINUE
C
   54    CALL CURVED(SX,SY,K)
         ITS=NINT(T)
      WRITE (ITIT,103) ITS
  103    FORMAT(I3)
C        IF(ITS .GE. 320) THEN
C           CALL PWRY(SX(K-3),43.0,ITIT,3,10,0,1)
C           ELSE
C           CALL PWRY(-18.0,SY(K-3),ITIT,3,10,0,1)
C        END IF
         X=SX(K-3)
         Y=SY(K-3)
         IF(X.LT.-15.0) X = -17.95
         IF(Y.GT.40.0)  Y = 42.9
      CALL WTSTR (X,Y,ITIT(1:3),10,0,0)
   55 CONTINUE
C
      CALL GFLAS2
      ISKDRW = 1
      RETURN
      END
