      SUBROUTINE JSTCHR(STR)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    JSTCHR
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE REMOVES ALL LEADING BLANKS FROM A CHARACTER
C   STRING (LEFT JUSTIFIES).  THE RESULTANT STRING MAY CONTAIN ANY
C   VALID ASCII CHARACTER.  IT IS SIMILAR TO BUFR ARCHIVE LIBRARY
C   FUNCTION LJUST, EXCEPT LJUST RETURNS THE ORIGINAL BLANK STRING IN
C   STR IF THE INPUT CHARACTER STRING IS ALL BLANKS WHILE JSTCHR MAKES
C   AN APPROPRIATE CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE BORT IN THIS
C   CASE.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR (ENTRY POINT IN JSTIFY)
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT" (IN PARENT ROUTINE JSTIFY)
C 2002-05-14  J. WOOLLEN -- CHANGED FROM AN ENTRY POINT TO INCREASE
C                           PORTABILITY TO OTHER PLATFORMS (JSTIFY WAS
C                           THEN REMOVED BECAUSE IT WAS JUST A DUMMY
C                           ROUTINE WITH ENTRIES)
C 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
C                           DOCUMENTATION; OUTPUTS MORE COMPLETE
C                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
C                           ABNORMALLY
C
C USAGE:    CALL JSTCHR (STR)
C   INPUT ARGUMENT LIST:
C     STR      - CHARACTER*(*): STRING
C
C   OUTPUT ARGUMENT LIST:
C     STR      - CHARACTER*(*): COPY OF INPUT STR WITH LEADING BLANKS
C                REMOVED
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT
C    THIS ROUTINE IS CALLED BY: ELEMDX
C                               Normally not called by any application
C                               programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      CHARACTER*(*) STR

      IF(STR.EQ.' ') GOTO 900

      LSTR = LEN(STR)
1     IF(STR(1:1).EQ.' ') THEN
         STR  = STR(2:LSTR)
         GOTO 1
      ENDIF

C  EXITS
C  -----

      RETURN
900   CALL BORT('BUFRLIB: JSTCHR - INPUT BLANK CHARACTER STRING NOT '//
     . 'ALLOWED')
      END
