!
!   WRF-chem V3.0 : Original version of chem_driver written by Georg Grell (ESRL/GSD)
!                   Further developments, bugfixes and improvements  by
!                   William Gustafson (PNNL), Marc Salzmann (GFDL), and Georg Grell
!
#if ( NMM_CORE == 1 )
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!NCEP_MESO:MEDIATION_LAYER:SOLVER
!
!-----------------------------------------------------------------------
#include "../dyn_nmm/nmm_loop_basemacros.h"
#include "../dyn_nmm/nmm_loop_macros.h"
!-----------------------------------------------------------------------
#endif
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    subroutine chem_driver ( grid , config_flags   &
 
#include "dummy_new_args.inc"
 
                 )
!----------------------------------------------------------------------
  USE module_domain
  USE module_configure
#if ( EM_CORE == 1 )
  USE module_driver_constants
  USE module_machine
  USE module_tiles
#endif
  USE module_dm
  USE module_model_constants
  USE module_state_description
#if ( NMM_CORE == 1 )
  USE MODULE_PHYSICS_CALLS 
#endif
  USE module_data_radm2
  USE module_data_sorgam
  USE module_radm
  USE module_dep_simple
  USE module_bioemi_simple
  USE module_phot_mad
  USE module_aerosols_sorgam
  USE module_chem_utilities
  USE module_ctrans_grell
  USE module_convtrans_prep
  USE module_dry_dep_driver
  USE module_emissions_driver
  USE module_wetscav_driver, only: wetscav_driver
  USE module_input_chem_data, only:                 &
#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
                                     chem_dbg,      &
#endif
                                     get_last_gas
   IMPLICIT NONE

   !  Input data.

   TYPE(domain) , TARGET          :: grid
   !
   !  Definitions of dummy arguments to solve
# include <dummy_new_decl.inc>
#if ( EM_CORE == 1 )
# define NO_I1_OLD
#endif
#if ( NMM_CORE == 1 )
# ifdef DM_PARALLEL
      INCLUDE "mpif.h"
# endif
#endif

   TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags

   INTEGER                     :: ids,ide, jds,jde, kds,kde,    &
                                  ims,ime, jms,jme, kms,kme,    &
                                  ips,ipe, jps,jpe, kps,kpe,    &
                                  its,ite, jts,jte, kts,kte
! ..
! .. Local Scalars ..
      INTEGER :: stepave,i,j,k,l,numgas,nv,n, nr,ktauc, ktau,k_start,k_end,idf,jdf,kdf
      REAL    :: convtrans_avglen_m


! ................................................................
! ..
!
! necessary for aerosols (module dependent)
!
#if ( NMM_CORE == 1 )
      real, dimension(grid%sm31:grid%em31,grid%sm33:grid%em33,grid%sm32:grid%em32) ::vcsulf_old,vcso2_old
      real, dimension(grid%sm31:grid%em31,grid%sm33:grid%em33,grid%sm32:grid%em32,ldrog) ::vdrog3,vcso2_old
      real, dimension(grid%sm31:grid%em31,grid%sm33:grid%em33,grid%sm32:grid%em32) ::n2o5_het
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33,grid%sm32:grid%em32) ::              &
                                                              p_phy,u_phy,v_phy                   &
                                                             ,t_phy,dz8w,t8w,p8w                  &
                                                             ,rho,rri,z_at_w,vvel,zmid
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32) :: pbl_h
      REAL,DIMENSION(grid%sm33:grid%em33-1) :: QL,TL
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32) :: REXNSFC,FACTRS                &
                                        ,TOT,TSFC
      REAL, ALLOCATABLE, DIMENSION(:,:,:,:) :: moist_trans
      REAL, ALLOCATABLE, DIMENSION(:,:,:,:) :: scalar_trans
#endif
#if ( EM_CORE == 1 )
      real, dimension(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) ::vcsulf_old,vcso2_old,vch2o2_old
      real, dimension(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33,ldrog) ::vdrog3
      real, dimension(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) ::n2o5_het 
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) ::              &
                                                              p_phy,u_phy,v_phy                   &
                                                             ,t_phy,dz8w,t8w,p8w                  &
                                                             ,rho,rri,z_at_w,vvel,zmid
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33) :: pbl_h
      REAL,DIMENSION(grid%sm32:grid%em32-1) :: QL,TL
      REAL,DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33) :: REXNSFC,FACTRS                &
                                        ,TOT,TSFC
     
#endif
! Variables for adaptive time steps...
      TYPE(WRFU_TimeInterval) :: tmpTimeInterval
!     REAL(KIND=8) :: curr_secs
!     REAL(KIND=8) :: real_time_r8                                 !ext. function in adapt_timestep_em.F
      REAL         :: curr_secs, real_time
      LOGICAL :: adapt_step_flag   ! , do_chemstep, do_photstep


      REAL :: DAYI,DPL,FICE,FRAIN,HOUR,PLYR          &
     &       ,QI,QR,QW,RADT,TIMES,WC,TDUM,WMSK,RWMSK
 

      INTEGER                         :: ij 
      INTEGER                         :: im , num_3d_m , ic , num_3d_c, num_3d_s
      INTEGER                         :: ijds, ijde
      INTEGER                         :: ksubt

      REAL :: chem_minval, dtstepc

      INTEGER :: numgas_aqfrac    ! last dimension of gas_aqfrac
      REAL, ALLOCATABLE, DIMENSION(:,:,:,:) :: gas_aqfrac
                                      ! fraction of gas that is in cloud water
      LOGICAL :: haveaer
      CHARACTER (LEN=256) :: current_date_char !shc
      integer :: current_month                 !shc
! ..
! .. Intrinsic Functions ..
      INTRINSIC max, min
!<DESCRIPTION>
!<pre>
! chem_driver is the main driver for handling chemistry related tasks
! for a particular timestep. chem_driver is a mediation-layer routine ->
! DM and SM calls are made where needed for parallel processing.
!
! The main sections of chem_driver are:
!
! (1) Initialization of meteorology variables as needed for chemistry
!
! (2) Calls to drivers for the various chemistry tasks:
!        emissions_driver
!        photolysis_driver
!        dry_dep_driver
!        grelldrvct (convective tracer transport)
!        mechanism_driver (gases)
!        cloud_chem_driver
!        aerosols_driver
!        wetscav_driver
!        sum_pm_driver
!
! Handling of tile indices in chem_driver is as close as possible to
! what is done in solve_em. For subroutines called from chem_driver,
! the its:ite, jts:jte, and kts:kte variables represent the extent of
! the domain that each processor should loop over. For example, a do
! loop in the vertical for the chem array should go from kts to kte.
! For the EM core, kte=kde-1. For the NMM core, kte=kde-2.
!
! Note that the tile indices for the chemistry initialization differ
! from the integration loop indices in that the initializataion routines
! use kte=kde. Go figure, this is how the met. folks set things up.
!
!</pre>
!</DESCRIPTION>

! ..

! Number of levels to exclude from the chem calculations counting from
! the model top.
!  ksubt=0

!
! Setup the adaptive timestep for the chem routines. Most of this follows
! what is in solve_em, except for the call to adjust time_step.
!
#if ( NMM_CORE == 1)
  !NMM defaults to the old step counting methodology in physics so we
  !will do the same here in chemistry. In theory, adapt_step_flag can
  !probably be set to TRUE for NMM too using the curr_secs calculated
  !with ktau, but I do not have input files to test NMM. (wig, 12-May-2008)
  adapt_step_flag = .FALSE.
  KTAU=GRID%NTSD
  curr_secs = (ktau-1)*grid%dt
#endif
#if ( EM_CORE == 1 )
  !The necesssary variables exist for the EM core and using the adaptive
  !techniques will work even with a constant time step. In fact, they
  !prevent issues with restarts and changed time steps. So, we will
  !always use them with the EM core.
  adapt_step_flag = .FALSE.
  ktau = grid%itimestep
  tmpTimeInterval = domain_get_time_since_sim_start(grid)
  curr_secs = real_time(tmpTimeInterval)
#endif

! ..

!
! Some stuff for convective transport...
!
  convtrans_avglen_m = 30.  !Averaging time for convective transport in min.
  stepave=convtrans_avglen_m*60./grid%dt
! stepave=1800./grid%dt

  CALL get_ijk_from_grid (  grid ,                   &
                            ids, ide, jds, jde, kds, kde,    &
                            ims, ime, jms, jme, kms, kme,    &
                            ips, ipe, jps, jpe, kps, kpe    )
! ktau = grid%itimestep
! following two lines needed for MEGAN
  CALL domain_clock_get( grid, current_timestr=current_date_char )
  read(current_date_char(6:7),FMT='(I2)') current_month
!
!initialize
!
#if ( NMM_CORE == 1 )
!***  IN NMM SET CONTROLS FOR TILES TO PATCHES
!
!-----------------------------------------------------------------------
      IDF=IDE-1
      JDF=JDE-1
      KDF=KDE-2 ! DO NOT do chem at the top level to mimic what used to be done (also prevents a solver failure at kde-1 for MADE/SORGAM)
      ITS=IPS
      ITE=MIN(IPE,IDF)
      JTS=JPS
      JTE=MIN(JPE,JDF)
      KTS=KPS
      KTE=MIN(KPE,KDF)

#endif


  num_3d_m        = num_moist
  num_3d_c        = num_chem
  num_3d_s        = num_scalar
  numgas          = get_last_gas(config_flags%chem_opt)
  numgas_aqfrac   = 0    !will be set upon allocation of gas_aqfrac


#if ( EM_CORE == 1 )

   !  Compute these starting and stopping locations for each tile and number of tiles.
  CALL set_tiles ( grid , ids , ide , jds , jde , ips , ipe , jps , jpe )
  k_start         = kps
  k_end           = kpe

#endif
  ijds = min(ids, jds)
  ijde = max(ide, jde)
#if ( NMM_CORE ==1) 
  allocate(moist_trans(ims:ime,kms:kme,jms:jme,num_3d_m))
  allocate(scalar_trans(ims:ime,kms:kme,jms:jme,num_3d_s))
      DO l=1,num_3d_m
       DO j=jts,jte
         DO k=kts,kte
             DO i=its,ite
                moist_trans(i,k,j,l)=moist(i,j,k,l)
             ENDDO
         ENDDO
       ENDDO
       ENDDO
       DO l=1,num_3d_s
       DO j=jts,jte
         DO k=kts,kte
             DO i=its,ite
               scalar_trans(i,k,j,l)=scalar(i,j,k,l)
             ENDDO
         ENDDO
       ENDDO
       ENDDO
#endif
   chem_minval = epsilc !chem_minval can be case dependant and set below...
   chem_select: SELECT CASE(config_flags%chem_opt)
     CASE (RADM2)
       CALL wrf_debug(15,'calling radm2 from chem_driver')
       haveaer = .false.
     CASE (RADM2_KPP)
       CALL wrf_debug(15,'calling radm2_kpp from chem_driver')
       haveaer = .false.
     CASE (RADM2SORG)
       CALL wrf_debug(15,'calling radm2sorg aerosols driver from chem_driver')
       haveaer = .true.
     CASE (RADM2SORG_KPP)
       CALL wrf_debug(15,'calling radm2sorg aerosols driver from chem_driver')
       haveaer = .false.
     CASE (RADM2SORG_AQ)
       CALL wrf_debug(15,'calling radm2sorg_aq aerosols driver from chem_driver')
       haveaer = .true.
     CASE (RACM)
       CALL wrf_debug(15,'calling racm from chem_driver')
       haveaer = .false.
     CASE (RACM_KPP)
       CALL wrf_debug(15,'calling racm_kpp from chem_driver')
     CASE (RACMPM_KPP)
       CALL wrf_debug(15,'calling racmpm_kpp from chem_driver')
       haveaer = .false.
     CASE (RACM_MIM_KPP)
       CALL wrf_debug(15,'calling racm_mim_kpp from chem_driver')
       haveaer = .false.
     CASE (RACMSORG)
       CALL wrf_debug(15,'calling racmsorg aerosols driver from chem_driver')
       haveaer = .true.
     CASE (RACMSORG_KPP)
       CALL wrf_debug(15,'calling racmsorg_kpp aerosols driver from chem_driver')
       haveaer = .false.
     CASE (GOCART_SIMPLE)
       CALL wrf_debug(15,'calling only gocart aerosols driver from chem_driver')
       haveaer = .false.
     CASE (GOCARTRACM_KPP)
       CALL wrf_debug(15,'calling gocart and racm driver from chem_driver')
       haveaer = .false.
     CASE (CBMZ)
       CALL wrf_debug(15,'calling cbmz from chem_driver')
       haveaer = .false.
     CASE (CBMZ_BB)
       CALL wrf_debug(15,'calling cbmz_bb from chem_driver')
       haveaer = .false.
     CASE (CBMZ_MOSAIC_4BIN)
       CALL wrf_debug(15,'calling cbmz_mosaic_4bin aerosols driver from chem_driver')
       haveaer = .true.
     CASE (CBMZ_MOSAIC_8BIN)
       CALL wrf_debug(15,'calling cbmz_mosaic_8bin aerosols driver from chem_driver')
       haveaer = .true.
     CASE (CBMZ_MOSAIC_4BIN_AQ)
       CALL wrf_debug(15,'calling cbmz_mosaic_4bin_aq aerosols driver from chem_driver')
       haveaer = .true.
     CASE (CBMZ_MOSAIC_8BIN_AQ)
       CALL wrf_debug(15,'calling cbmz_mosaic_8bin_aq aerosols driver from chem_driver')
       haveaer = .true.
    CASE (CHEM_TRACER,CHEM_TRACE2)
       CALL wrf_debug(15,'tracer mode: only doing emissions and dry dep in chem_driver')
     CASE DEFAULT
       CALL wrf_debug(15,'calling chem_opt=? from chem_driver')
   END SELECT chem_select                              
!
!
!
#if ( NMM_CORE == 1 )
  k_start         = kts
  k_end           = min(kpe,kde-1)
! this should be in seperate routine!!!!!!
      GRID%SIGMA=1
      grid%HYDRO=.FALSE.
      its=max(its,MYIS1)
      jts=max(jts,MYJS2)
      ite=min(ite,MYIE1)
      jte=min(jte,MYJE2)
      DO J=jts,jte
      DO I=its,ite
        pbl_h(i,j)=grid%pblh(i,j)
!
!       PDSL=PD(I,J)*RES(I,J)
!-----------------------------------------------------------------------
!*** LONG AND SHORTWAVE FLUX AT GROUND SURFACE
!-----------------------------------------------------------------------
        IF(grid%CZMEAN(I,J)>0.) THEN
          FACTRS(I,J)=grid%CZEN(I,J)/grid%CZMEAN(I,J)
        ELSE
          FACTRS(I,J)=0.
        ENDIF
        grid%GSW(I,J)=(grid%RSWIN(I,J)-grid%RSWOUT(I,J))*grid%HBM2(I,J)*FACTRS(I,J)
        P8W(I,KTE+1,J)=grid%PT
        grid%XLAT(I,J)=grid%GLAT(I,J)/DEGRAD
        grid%XLONG(I,J)=grid%GLON(I,J)/DEGRAD
        grid%XLAND(I,J)=grid%SM(I,J)+1.
        grid%PSFC(i,j)=grid%PD(I,J)+grid%PDTOP+grid%PT
        grid%UST(I,J)=grid%USTAR(I,J)
        REXNSFC(I,J)=(grid%PSFC(i,j)*1.E-5)**CAPA
        TSFC(I,J)=grid%THS(I,J)*REXNSFC(I,J)
        grid%TSK(I,J)=TSFC(I,J)

        T8W(I,1,J)=TSFC(I,J) 
        P8W(I,KTS,J)=grid%ETA1(KTS)*grid%PDTOP+grid%ETA2(KTS)*grid%PDSL(i,j)+grid%PT
!       
!-----------------------------------------------------------------------
!***  FILL THE SINGLE-COLUMN INPUT
!-----------------------------------------------------------------------
!
        z_at_w(i,kts,j)=grid%fis(i,j)/g
        DO K=KTS,KTE+1
           vvel(i,k,j)=grid%w(i,j,k)
           DPL=grid%DETA1(K)*grid%PDTOP+grid%DETA2(K)*grid%PDSL(i,j)
          QL(K)=AMAX1(grid%Q(I,J,K),EPSQ)
          PLYR=grid%AETA1(K)*grid%PDTOP+grid%AETA2(K)*grid%PDSL(i,j)+grid%PT
          TL(K)=grid%T(I,J,K)
!
! here rri is inverse density!
!
          RHO(I,K,J)=PLYR/(R_D*TL(K)*(1.+P608*QL(K)))
          RRI(I,K,J)=1./RHO(i,k,j)
          T_PHY(I,K,J)=TL(K)
          moist_trans(I,K,J,P_QV)=QL(K)/(1.-QL(K))
          P8W(I,K+1,J)=grid%ETA1(K+1)*grid%PDTOP+grid%ETA2(K+1)*grid%PDSL(i,j)+grid%PT
          P_PHY(I,K,J)=PLYR
          DZ8W(I,K,J)=TL(K)*(P608*QL(K)+1.)*R_D                           &
     &                 *(P8W(I,K,J)-P8W(I,K+1,J))                       &
     &                 /(P_PHY(I,K,J)*G)
          if(K.gt.kts)then
            Z_AT_W(i,k,j)=Z_AT_W(I,k-1,j)+DZ8W(I,K-1,J)
            ZMID(I,K-1,J)=.5*(Z_AT_W(I,K-1,J)+Z_AT_W(I,K,J))
          endif

         ENDDO
!         
        DO K=KTS+1,KTE+1
          T8W(I,K,J)=0.5*(TL(K-1)+TL(K))
        ENDDO 
        T8W(I,KTE+2,J)=-1.E20
        ZMID(I,KTE+1,J)=Z_AT_W(I,KTE+1,J)
!         
      ENDDO
      ENDDO
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
!
!***  COMPUTE VELOCITY COMPONENTS AT MASS POINTS
!
!-----------------------------------------------------------------------
!$omp parallel do                                                       &
!$omp& private(i,j,k,rwmsk,wmsk)
      DO J=MYJS1_P1,MYJE1_P1
!
        DO K=KTS,KTE
          DO I=MYIS_P1,MYIE_P1
            WMSK=grid%VTM(I+grid%IHE(J),J,K)+grid%VTM(I+grid%IHW(J),J,K)                    &
     &          +grid%VTM(I,J+1,K)+grid%VTM(I,J-1,K)
            IF(WMSK>0.)THEN
              RWMSK=1./WMSK
              U_PHY(I,K,J)=(grid%U(I+grid%IHE(J),J,K)*grid%VTM(I+grid%IHE(J),J,K)           &
     &                     +grid%U(I+grid%IHW(J),J,K)*grid%VTM(I+grid%IHW(J),J,K)       &
     &                     +grid%U(I,J+1,K)*grid%VTM(I,J+1,K)                 &
     &                     +grid%U(I,J-1,K)*grid%VTM(I,J-1,K))*RWMSK
              V_PHY(I,K,J)=(grid%V(I+grid%IHE(J),J,K)*grid%VTM(I+grid%IHE(J),J,K)           &
     &                     +grid%V(I+grid%IHW(J),J,K)*grid%VTM(I+grid%IHW(J),J,K)       &
     &                     +grid%V(I,J+1,K)*grid%VTM(I,J+1,K)                 &
     &                     +grid%V(I,J-1,K)*grid%VTM(I,J-1,K))*RWMSK
            ELSE
              U_PHY(I,K,J)=0.
              V_PHY(I,K,J)=0.
            ENDIF
          ENDDO
        ENDDO
      ENDDO     
#endif

      do nv=1,num_chem
         do j=jps,jpe
            do k=kps,kpe
               do i=ips,ipe
                  chem(i,k,j,nv)=max(chem(i,k,j,nv),chem_minval)
               enddo
            enddo
         enddo
      enddo
      select case (config_flags%chem_opt)
      case (RADM2SORG, RADM2SORG_KPP,RACMSORG,RACMSORG_KPP)
         do j=jps,jpe
            do k=kps,kpe
               do i=ips,ipe
                  if(chem(i,k,j,p_nu0).lt.1.e07) then
                     chem(i,k,j,p_nu0)=1.e7
                  endif
               enddo
            enddo
         enddo
      end select


      vdrog3=0.
#if ( EM_CORE == 1 )
      do j=jps,min(jde-1,jpe)
         do k=kps,kpe
            do i=ips,min(ide-1,ipe)
              vvel(i,k,j)=grid%w_2(i,k,j)
              zmid(i,k,j)=grid%z(i,k,j)
            enddo
         enddo
      enddo
      do j=jps,min(jde-1,jpe)
         do k=kps,min(kde-1,kpe)
            do i=ips,min(ide-1,ipe)
              rri(i,k,j)=grid%alt(i,k,j)
            enddo
         enddo
      enddo
      do j=jps,min(jde-1,jpe)
         do i=ips,min(ide-1,ipe)
            pbl_h(i,j)=grid%pblh(i,j)
         enddo
      enddo

!------------------------------------------------------------------------
! Main chemistry tile loop
!------------------------------------------------------------------------
     
!$OMP PARALLEL DO   &
!$OMP PRIVATE ( ij, its, ite, jts, jte )
   chem_tile_loop_1: DO ij = 1 , grid%num_tiles
       its = grid%i_start(ij) 
       ite = min(grid%i_end(ij),ide-1)
       jts = grid%j_start(ij)
       jte = min(grid%j_end(ij),jde-1) 

       kts=k_start
       kte=min(k_end,kde-1)

#endif
! 
! no time average available in first half hour
!   
       if( config_flags%chem_conv_tr>0)then
           call convtrans_prep(grid%gd_cloud,grid%gd_cloud2,grid%gd_cloud_a,&
               grid%gd_cloud_b,grid%raincv,grid%raincv_a,grid%raincv_b,     &
               grid%gd_cloud2_a,grid%gd_cloud2_b,convtrans_avglen_m,stepave,&
               adapt_step_flag,curr_secs,grid%stepave_count,                &
               ktau,grid%dt,                                                &
               config_flags%cu_rad_feedback,  config_flags%cu_physics,      &
               ids,ide, jds,jde, kds,kde,                                   &
               ims,ime, jms,jme, kms,kme,                                   &
               its,ite, jts,jte,kts,kte                                     )
       endif ! chem_conv_tr

!       if( config_flags%chem_conv_tr>0)then
!           call convtrans_prep(grid%gd_cloud,grid%gd_cloud2,grid%gd_cloud_a,&
!               grid%gd_cloud_b,grid%raincv,grid%raincv_a,grid%raincv_b,     &
!               grid%gd_cloud2_a,grid%gd_cloud2_b,stepave,ktau,grid%dt,        &
!               config_flags%cu_rad_feedback,  config_flags%cu_physics,      &
!               ids,ide, jds,jde, kds,kde,                                   &
!               ims,ime, jms,jme, kms,kme,                                   &
!               its,ite, jts,jte,kts,kte                                     )
!       endif ! chem_conv_tr
!
!
#if ( EM_CORE == 1 )
         CALL wrf_debug ( 15 , ' call chem_prep' )
         CALL chem_prep ( config_flags,                                               &
                         grid%u_2, grid%v_2, grid%p, grid%pb,             &
                         grid%alt,grid%ph_2, grid%phb, grid%t_2,          &
                         moist, num_3d_m, rho,                                        &
                         p_phy,  u_phy, v_phy,                                        &
                         p8w, t_phy, t8w, grid%z, z_at_w,                          &
                         dz8w, grid%fnm, grid%fnp,                              &
                         ids, ide, jds, jde, kds, kde,                                &
                         ims, ime, jms, jme, kms, kme,                                &
                         its,ite,jts,jte,                                             &
                         k_start, k_end                                               )
#endif

#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
       if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and.                          &
           (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and.                          &
           (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,"calling chem_dbg at top of chem_driver")
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                       &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte,kts,kte,                                              &
               config_flags%kemit                                                     )
       end if
#endif

!--- emissions

    if(config_flags%emiss_inpt_opt > 0)then
      call wrf_debug(15,'calling emissions driver')

      call emissions_driver(grid%id,ktau,grid%dt,grid%DX,grid%stepfirepl,               &
              config_flags, grid%stepbioe,                                                 &
#if (NMM_CORE == 1)
              grid%gmt,grid%julday,rri,t_phy,moist_trans,p8w,t8w,u_phy,v_phy,vvel,         &
#endif
#if (EM_CORE == 1 )
              grid%gmt,grid%julday,rri,t_phy,moist,p8w,t8w,u_phy,v_phy,vvel,               &
#endif
              grid%e_bio,p_phy,chem,rho,dz8w,grid%ne_area,emis_ant,grid%tsk,grid%erod,g,emis_seas,emis_dust, &
              grid%ebu_no,grid%ebu_co,grid%ebu_co2,grid%ebu_eth,grid%ebu_hc3,grid%ebu_hc5, &
              grid%ebu_hc8,grid%ebu_ete,grid%ebu_olt,grid%ebu_oli,grid%ebu_pm25,           &
              grid%ebu_pm10,grid%ebu_dien,grid%ebu_iso,grid%ebu_api,grid%ebu_lim,          &
              grid%ebu_tol,grid%ebu_xyl,grid%ebu_csl,grid%ebu_hcho,grid%ebu_ald,           &
              grid%ebu_ket,grid%ebu_macr,grid%ebu_ora1,grid%ebu_ora2,grid%ebu_bc,          &
              grid%ebu_oc,grid%ebu_so2,grid%ebu_dms,grid%ebu_sulf,grid%mean_fct_agtf,      &
              grid%mean_fct_agef,grid%mean_fct_agsv,grid%mean_fct_aggr,grid%firesize_agtf, &
              grid%firesize_agef,grid%firesize_agsv,grid%firesize_aggr,                    &
              grid%u10,grid%v10,grid%ivgtyp,grid%isltyp,grid%gsw,grid%vegfra,grid%rmol,    &
              grid%ust,grid%znt,grid%dms_0,                                                &
              grid%xland,grid%xlat,grid%xlong,                                             &
              z_at_w,zmid,grid%smois,                                                      &
              grid%sebio_iso,grid%sebio_oli,grid%sebio_api,grid%sebio_lim,                 &
              grid%sebio_xyl,grid%sebio_hc3,grid%sebio_ete,grid%sebio_olt,                 &
              grid%sebio_ket,grid%sebio_ald,grid%sebio_hcho,grid%sebio_eth,                &
              grid%sebio_ora2,grid%sebio_co,grid%sebio_nr,                                 &
              grid%noag_grow,grid%noag_nongrow,grid%nononag,grid%slai,                     &
              grid%ebio_iso,grid%ebio_oli,grid%ebio_api,grid%ebio_lim,grid%ebio_xyl,       &
              grid%ebio_hc3,grid%ebio_ete,grid%ebio_olt,grid%ebio_ket,grid%ebio_ald,       &
              grid%ebio_hcho,grid%ebio_eth,grid%ebio_ora2,grid%ebio_co,grid%ebio_nr,       &
              grid%ebio_no,                                                                &
#if (NMM_CORE == 1)
              grid%T2,grid%RSWIN,                                                         &
#endif
#if (EM_CORE == 1 )
              grid%T2,grid%swdown,                                                         &
#endif
              grid%nmegan,grid%EFmegan,                                                    &
              grid%msebio_isop,                                                            &
              grid%mlai,                                                                   &
              grid%pftp_bt, grid%pftp_nt, grid%pftp_sb, grid%pftp_hb,                      &
              grid%mtsa,                                                                   &
              grid%mswdown,                                                                &
              grid%mebio_isop,grid%mebio_apin,grid%mebio_bpin, grid%mebio_bcar,            &
              grid%mebio_acet,grid%mebio_mbo,grid%mebio_no,                                &
              current_month,                                                               &
              ids,ide, jds,jde, kds,kde,                                                   &
              ims,ime, jms,jme, kms,kme,                                                   &
              its,ite,jts,jte,kts,kte)

#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
       if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and.                          &
           (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and.                          &
           (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,'calling chem_dbg after emissions_driver')
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                                    &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts, kte,                                            &
               config_flags%kemit                                                     )
       end if
#endif 
     endif

!
! calculate aerosol optical properities
!
      if((ktau.eq.1 .or. mod(ktau,grid%stepphot).eq.0)      &
           .and. config_flags%chem_opt /= CHEM_TRACER       &
           .and. config_flags%chem_opt /= CHEM_TRACE2) then
         call wrf_debug(15,'calling optical driver')
         call optical_driver (grid%id,ktau,grid%dt,config_flags,haveaer,              &
              chem,dz8w,rri,                                                          &
              grid%h2oai,grid%h2oaj,                                                  &
              grid%tauaer1,grid%tauaer2,grid%tauaer3,grid%tauaer4,                    &
              grid%gaer1,grid%gaer2,grid%gaer3,grid%gaer4,                            &
              grid%waer1,grid%waer2,grid%waer3,grid%waer4,                            &
              grid%bscoef1,grid%bscoef2,grid%bscoef3,grid%bscoef4,                    &
              grid%l2aer,grid%l3aer,grid%l4aer,grid%l5aer,grid%l6aer,grid%l7aer,      &
              ids,ide, jds,jde, kds,kde,                                              &
              ims,ime, jms,jme, kms,kme,                                              &
              its,ite, jts,jte, kts,kte)
      endif

!
! calculate photolysis rates
      if((ktau.eq.1 .or. mod(ktau,grid%stepphot).eq.0)   &
           .and. config_flags%chem_opt /= CHEM_TRACE2    &
           .and. config_flags%chem_opt /= CHEM_TRACER) then
         call wrf_debug(15,'calling photolysis driver')
         call photolysis_driver (grid%id,ktau,grid%dt,config_flags,haveaer,           &
#if (NMM_CORE == 1)
              grid%gmt,grid%julday,t_phy,moist_trans,grid%aerwrf,p8w,t8w,p_phy,       &
#endif
#if (EM_CORE == 1)
              grid%gmt,grid%julday,t_phy,moist,grid%aerwrf,p8w,t8w,p_phy,             &
#endif
              chem,rho,dz8w,grid%xlat,grid%xlong,                                     &
              z_at_w,                                                                 &
              grid%gd_cloud_b,grid%gd_cloud2_b,                                       &
              grid%ph_macr,grid%ph_o31d,grid%ph_o33p,grid%ph_no2,grid%ph_no3o2,       &
              grid%ph_no3o,grid%ph_hno2,grid%ph_hno3,grid%ph_hno4,grid%ph_h2o2,       &
              grid%ph_ch2or,grid%ph_ch2om,grid%ph_ch3cho,grid%ph_ch3coch3,            &
              grid%ph_ch3coc2h5,grid%ph_hcocho,grid%ph_ch3cocho,                      &
              grid%ph_hcochest,grid%ph_ch3o2h,grid%ph_ch3coo2h,grid%ph_ch3ono2,       &
              grid%ph_hcochob,grid%ph_n2o5,grid%ph_o2,                                &
              grid%tauaer1,grid%tauaer2,grid%tauaer3,grid%tauaer4,                    &
              grid%gaer1,grid%gaer2,grid%gaer3,grid%gaer4,                            &
              grid%waer1,grid%waer2,grid%waer3,grid%waer4,                            &
              grid%bscoef1,grid%bscoef2,grid%bscoef3,grid%bscoef4,                    &
              grid%l2aer,grid%l3aer,grid%l4aer,grid%l5aer,grid%l6aer,grid%l7aer,      &
              grid%pm2_5_dry,grid%pm2_5_water,grid%uvrad,                             &
              ids,ide, jds,jde, kds,kde,                                              &
              ims,ime, jms,jme, kms,kme,                                              &
              its,ite,jts,jte,kts,kte)

#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
         if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and. &
             (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and. &
             (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,'calling chem_dbg after photolysis_driver')
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                                             &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts,kte,                                             &
               config_flags%kemit,                                                    &
               grid%ph_macr,grid%ph_o31d,grid%ph_o33p,grid%ph_no2,grid%ph_no3o2,      &
               grid%ph_no3o,grid%ph_hno2,grid%ph_hno3,grid%ph_hno4,grid%ph_h2o2,      &
               grid%ph_ch2or,grid%ph_ch2om,grid%ph_ch3cho,grid%ph_ch3coch3,           &
               grid%ph_ch3coc2h5,grid%ph_hcocho,grid%ph_ch3cocho,                     &
               grid%ph_hcochest,grid%ph_ch3o2h,grid%ph_ch3coo2h,                      &
               grid%ph_ch3ono2,grid%ph_hcochob,grid%ph_n2o5,grid%ph_o2                &
                                                                                      )
       end if
#endif
      endif

!
! do vertical mixing with dry deposition
!
      if (config_flags%vertmix_onoff>0) then
         if (ktau.gt.2) then
            call wrf_debug(15,'calling dry_deposition_driver')
            call dry_dep_driver(grid%id,ktau,grid%dt,config_flags,                    &
#if (NMM_CORE == 1)
                 grid%gmt,grid%julday,t_phy,moist_trans,scalar_trans,p8w,t8w,vvel,    &
#endif
#if (EM_CORE == 1)
                 grid%gmt,grid%julday,t_phy,moist,scalar,p8w,t8w,vvel,                &
#endif
                 rri,p_phy,chem,rho,dz8w,grid%exch_h,grid%hfx,grid%dx,                &
                 grid%cldfra, grid%cldfra_old,                                        &
	         grid%ccn1, grid%ccn2, grid%ccn3, grid%ccn4, grid%ccn5, grid%ccn6,    &
                 grid%qndropsource,grid%ivgtyp,grid%tsk,grid%gsw,grid%vegfra,pbl_h,   &
                 grid%rmol,grid%ust,grid%znt,grid%xlat,grid%xlong,                    &
                 zmid,z_at_w,grid%xland,                                              &
                 grid%h2oaj,grid%h2oai,grid%nu3,grid%ac3,grid%cor3,grid%asulf,        &
                 grid%ahno3,grid%anh3,grid%cvaro1,grid%cvaro2,grid%cvalk1,grid%cvole1,&
                 grid%cvapi1,grid%cvapi2,grid%cvlim1,grid%cvlim2,grid%dep_vel_o3,     &
                 emis_ant(ims,kms,jms,p_e_co),config_flags%kemit,numgas,                                 &
                 ids,ide, jds,jde, kds,kde,                                           &
                 ims,ime, jms,jme, kms,kme,                                           &
                 its,ite,jts,jte,kts,kte)
         end if

#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
       if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and. &
           (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and. &
           (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,'calling chem_dbg after dry_deposition_driver')
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                                             &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts, kte,                                            &
               config_flags%kemit,                                                    &
                                                                                      )
       end if
#endif
      end if



!
!   convective transport/wet deposition
!
!
     if( config_flags%cu_physics>0 .and. config_flags%chem_conv_tr>0)then
        call wrf_debug(15,'calling conv transport')
        call grelldrvct(grid%DT,ktau,grid%DX,grid%id,config_flags,                    &
             rho,grid%RAINCV_B,chem,                                                  &
#if (NMM_CORE == 1)
             U_phy,V_phy,t_phy,moist_trans,dz8w,                                      &
#endif
#if (EM_CORE == 1)
             U_phy,V_phy,t_phy,moist,dz8w,                                            &
#endif
             p_phy,XLV,CP,G,r_v,                                                      &
             z_at_w,                                                                  &
             grid%cu_co_ten,                                                          &
             numgas,config_flags%chem_opt,                                          &
             ids,ide, jds,jde, kds,kde,                                               &
             ims,ime, jms,jme, kms,kme,                                               &
             its,ite,jts,jte,kts,k_end)
     end if
!
!
!
!
n2o5_het=0.
! Calculate rate of n2o5 hydrolysis 
       call wrf_debug(15,'calling calc_het_n2o5')



!
! For the chemistry tracer mode, only emissions and vertical mixing are done.
! So, finish any remaining tiles and then skip to the end of chem_driver.
!

      if((ktau.eq.1.or.mod(ktau,grid%stepchem).eq.0)        &
           .and. config_flags%chem_opt /= CHEM_TRACER       &
           .and. config_flags%chem_opt /= CHEM_TRACE2) then
        dtstepc=grid%dt*float(grid%stepchem)
        ktauc=max(ktau/grid%stepchem,1)
        if(ktau.eq.1) then
           dtstepc=grid%dt
        else if( ktau==grid%stepchem .and. grid%stepchem>1 ) then
           dtstepc=grid%dt*(grid%stepchem - 1)
        end if
        if(config_flags%gaschem_onoff>0)then
!
! chemical mechanisms
!
        call mechanism_driver(grid%id,ktau,grid%dt,ktauc,dtstepc,config_flags,        &
#if (NMM_CORE == 1)
              grid%gmt,grid%julday,t_phy,moist_trans,p8w,t8w,                         &
#endif
#if (EM_CORE == 1)
              grid%gmt,grid%julday,t_phy,moist,p8w,t8w,                               &
#endif
              p_phy,chem,rho,dz8w,grid%dx,g,                                          &
              zmid,z_at_w,grid%xlat,grid%xlong,                                       &
              vdrog3,vcsulf_old,vcso2_old,vch2o2_old,grid%ttday,grid%tcosz,                      &
              grid%ph_macr,grid%ph_o31d,grid%ph_o33p,grid%ph_no2,grid%ph_no3o2,       &
              grid%ph_no3o,grid%ph_hno2,grid%ph_hno3,grid%ph_hno4,grid%ph_h2o2,       &
              grid%ph_ch2or,grid%ph_ch2om,grid%ph_ch3cho,grid%ph_ch3coch3,            &
              grid%ph_ch3coc2h5,grid%ph_hcocho,grid%ph_ch3cocho,grid%ph_hcochest,     &
              grid%ph_ch3o2h,grid%ph_ch3coo2h,grid%ph_ch3ono2,grid%ph_hcochob,        &
              grid%ph_n2o5,grid%ph_o2,grid%backg_oh,grid%backg_h2o2,grid%backg_no3,   &
              grid%addt,grid%addx,grid%addc,grid%etep,                                &
              grid%oltp,grid%olip,grid%cslp,grid%limp,grid%hc5p,grid%hc8p,grid%tolp,  &
              grid%xylp,grid%apip,grid%isop,grid%hc3p,grid%ethp,grid%o3p,grid%tco3,   &
              grid%mo2,grid%o1d,grid%olnn,grid%rpho,grid%xo2,                         &
              grid%ketp,grid%olnd,                                                    &
              ids,ide, jds,jde, kds,kde,                                              &
              ims,ime, jms,jme, kms,kme,                                              &
              its,ite,jts,jte,kts,kte        )
!

#ifdef WRF_KPP
   CALL wrf_debug(15,'calling kpp_mechanism_driver')
CALL kpp_mechanism_driver (chem,                                                      &
   grid%id,dtstepc,config_flags,                                                      &
   p_phy,t_phy,rho,                                                                   &
#if (NMM_CORE == 1)
   moist_trans,                                                                       &
#endif
#if (EM_CORE == 1)
   moist,                                                                             &
#endif
   vdrog3, ldrog,                                                                     &
!
#include <call_to_kpp_mech_drive.inc>
!
   ids,ide, jds,jde, kds,kde,                                                         &
   ims,ime, jms,jme, kms,kme,                                                         &
   its,ite,jts,jte,kts,kte)
    if(config_flags%chem_opt == 301 ) then
       chem(its:ite,kts:kte,jts:jte,p_sulf)=vcsulf_old(its:ite,kts:kte,jts:jte)
       chem(its:ite,kts:kte,jts:jte,p_so2)=vcso2_old(its:ite,kts:kte,jts:jte)
!      chem(its:ite,kts:kte,jts:jte,p_h2o2)=vch2o2_old(its:ite,kts:kte,jts:jte)
   endif



!
#endif
#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
       if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and.                          &
           (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and.                          &
           (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,'calling chem_dbg after mechanism_driver')
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                                             &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts,kte,                                             &
               config_flags%kemit,                                                    &
               grid%ph_macr,grid%ph_o31d,grid%ph_o33p,grid%ph_no2,grid%ph_no3o2,      &
               grid%ph_no3o,grid%ph_hno2,grid%ph_hno3,grid%ph_hno4,grid%ph_h2o2,      &
               grid%ph_ch2or,grid%ph_ch2om,grid%ph_ch3cho,grid%ph_ch3coch3,           &
               grid%ph_ch3coc2h5,grid%ph_hcocho,grid%ph_ch3cocho,                     &
               grid%ph_hcochest,grid%ph_ch3o2h,grid%ph_ch3coo2h,                      &
               grid%ph_ch3ono2,grid%ph_hcochob,grid%ph_n2o5,grid%ph_o2                &
       end if
#endif
       endif


!   allocate gas_aqfrac if either cldchem or wetscav is on
        if ( (config_flags%cldchem_onoff > 0) .or.                                    &
             (config_flags%wetscav_onoff > 0) ) then
            numgas_aqfrac = max( numgas, 1 )
#if  (NMM_CORE==1)
            allocate( gas_aqfrac( grid%sm31:grid%em31, grid%sm33:grid%em33,           &
                                  grid%sm32:grid%em32, numgas_aqfrac ) )
#endif
#if  (EM_CORE==1)
            allocate( gas_aqfrac( grid%sm31:grid%em31, grid%sm32:grid%em32,           &
                                  grid%sm33:grid%em33, numgas_aqfrac ) )
#endif
        gas_aqfrac(its:ite,kts:kte,jts:jte,:) = 0.0
        end if

!
!   now do cloud chemistry
!
        if (config_flags%cldchem_onoff > 0) then

        call cloudchem_driver(                                                        &
               grid%id, ktau, ktauc, grid%dt, dtstepc, config_flags,                  &
               t_phy, p_phy, rho, rri,                                                &
#if (NMM_CORE == 1)
               moist_trans, grid%cldfra, grid%ph_no2,                                 &
#endif
#if (EM_CORE == 1)
               moist, grid%cldfra, grid%ph_no2,                                       &
#endif
               chem, gas_aqfrac, numgas_aqfrac,                                       &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts,kte                                              )
       
       endif


!
!   now do aerosols
!
	if(config_flags%aerchem_onoff>0)then

        call aerosols_driver (grid%id,ktau,grid%dt,ktauc,config_flags,dtstepc,grid%dx,&
#if (NMM_CORE==1)
              rri,t_phy,moist_trans,grid%aerwrf,p8w,t8w,                              &
#endif
#if (EM_CORE == 1)
              rri,t_phy,moist,grid%aerwrf,p8w,t8w,                                    &
#endif
              p_phy,chem,rho,dz8w,                                                    &
              zmid,z_at_w,                                                            &
              grid%h2oaj,grid%h2oai,grid%nu3,grid%ac3,grid%cor3,grid%asulf,           &
              grid%ahno3,grid%anh3,grid%cvaro1,grid%cvaro2,grid%cvalk1,grid%cvole1,   &
              grid%cvapi1,grid%cvapi2,grid%cvlim1,grid%cvlim2,vcsulf_old,             &
              vdrog3,                                                                 &
              ids,ide, jds,jde, kds,kde,                                              &
              ims,ime, jms,jme, kms,kme,                                              &
              its,ite,jts,jte,kts,kte)

#if (defined(CHEM_DBG_I) && defined(CHEM_DBG_J) && defined(CHEM_DBG_K))
       if( (its <= CHEM_DBG_I .and. ite >= CHEM_DBG_I) .and.                          &
           (jts <= CHEM_DBG_J .and. jte >= CHEM_DBG_J) .and.                          &
           (k_start <= CHEM_DBG_K .and. k_end >= CHEM_DBG_K)  ) then
          call wrf_debug(15,'calling chem_dbg after aerosols_driver')
          call chem_dbg(CHEM_DBG_I,CHEM_DBG_J,CHEM_DBG_K,grid%dt,ktau,                &
               dz8w,t_phy,p_phy,rho,chem,emis_ant,                                             &
               ids,ide, jds,jde, kds,kde,                                             &
               ims,ime, jms,jme, kms,kme,                                             &
               its,ite, jts,jte, kts, kte,                                            &
               config_flags%kemit,                                                    &
               grid%ph_macr,grid%ph_o31d,grid%ph_o33p,grid%ph_no2,grid%ph_no3o2,      &
               grid%ph_no3o,grid%ph_hno2,grid%ph_hno3,grid%ph_hno4,grid%ph_h2o2,      &
               grid%ph_ch2or,grid%ph_ch2om,grid%ph_ch3cho,grid%ph_ch3coch3,           &
               grid%ph_ch3coc2h5,grid%ph_hcocho,grid%ph_ch3cocho,                     &
               grid%ph_hcochest,grid%ph_ch3o2h,grid%ph_ch3coo2h,                      &
               grid%ph_ch3ono2,grid%ph_hcochob,grid%ph_n2o5,grid%ph_o2                &
                                                                                      )
       end if
#endif
       endif


!
!   now do wet removal
!
	if (config_flags%wetscav_onoff > 0) then
        call wetscav_driver (grid%id,ktau,grid%dt,ktauc,config_flags,dtstepc,         &
#if (NMM_CORE == 1)
              rri,t_phy,moist_trans,p8w,t8w,                                          &
#endif
#if (EM_CORE == 1)
              rri,t_phy,moist,p8w,t8w,                                                &
#endif
              p_phy,chem,rho,grid%cldfra,                                             &
              grid%qlsink,grid%precr,grid%preci,grid%precs,grid%precg,                &
              gas_aqfrac, numgas_aqfrac,                                              &
              grid%h2oaj,grid%h2oai,grid%nu3,grid%ac3,grid%cor3,                      &
              grid%asulf,grid%ahno3,grid%anh3,grid%cvaro1,grid%cvaro2,                &
              grid%cvalk1,grid%cvole1,grid%cvapi1,grid%cvapi2,                        &
              grid%cvlim1,grid%cvlim2,                                                &
              ids,ide, jds,jde, kds,kde,                                              &
              ims,ime, jms,jme, kms,kme,                                              &
              its,ite, jts,jte, kts,kte)                                              
       
       endif
       
       if (numgas_aqfrac > 0) then
           deallocate( gas_aqfrac )
           numgas_aqfrac = 0
       end if

end if !Chemistry time step check
!
! Sum up the aerosol mass for radiation and diagnostic purposes. Unlike
! aerosol_driver, which is called every dtchem, this must be done every
! time step because of emissions and deposition.
!
      call sum_pm_driver ( config_flags,                                              &
           rri, chem, grid%h2oaj, grid%h2oai,                                         &
           grid%pm2_5_dry, grid%pm2_5_water, grid%pm2_5_dry_ec, grid%pm10,            &
           ids,ide, jds,jde, kds,kde,                                                 &
           ims,ime, jms,jme, kms,kme,                                                 &
           its,ite, jts,jte, kts, kte                                                 )

! Fill top level to prevent spurious interpolation results (no extrapolation)
      do nv=1,num_chem
         do j=jts,jte
            do i=its,ite
                  chem(i,k_end,j,nv)=chem(i,kte,j,nv)
            enddo
         enddo
      enddo
      call wrf_debug(15,'done tileloop in chem_driver')
# if ( EM_CORE == 1 ) 
   END DO chem_tile_loop_1
#endif
#if (NMM_CORE==1) 
       DO l=1,num_3d_m
       DO k=kts,kte   
         DO j=jts,jte
             DO i=its,ite
                moist(i,j,k,l)=moist_trans(i,k,j,l)
             ENDDO
         ENDDO
       ENDDO
       ENDDO
       DO l=1,num_3d_s
       DO k=kts,kte   
         DO j=jts,jte
             DO i=its,ite
               scalar(i,j,k,l)=scalar_trans(i,k,j,l)
             ENDDO
         ENDDO
       ENDDO
       ENDDO
    deallocate(moist_trans)
    deallocate(scalar_trans)
#endif
    END subroutine chem_driver
