!**********************************************************************************  
! This computer software was prepared by Battelle Memorial Institute, hereinafter
! the Contractor, under Contract No. DE-AC05-76RL0 1830 with the Department of 
! Energy (DOE). NEITHER THE GOVERNMENT NOR THE CONTRACTOR MAKES ANY WARRANTY,
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
! Fast-J module: see module_phot_fastj.F for information and terms of use
!**********************************************************************************  
!   file module_fastj_jvcmn.f
!   based on fastj include file jv_cmn.h
!-----------------------------------------------------------------------
!  Parameters
!     NB    Number of levels in CTM plus one for above model top
!     NC    Number of levels in the fundamental Fast-J grid
!     NS    Maximum number of species which require J-values calculating
!     NW    Maximum number of wavelength bins that can be used
!     NP    Maximum number of aerosol/cloud types that can be used
!     NH    Maximum number of Herzberg X-sections that can be used
!     MX    Number of aerosol/cloud types supplied from CTM
!-----------------------------------------------------------------------
	module module_fastj_data

!jdf	use module_fastj_cmnh, only:  double, kmaxd, jppj
        USE module_data_mosaic_other, only : kmaxd
!jdf
       integer, parameter :: double = 8        !compiler dependent value real*8
       integer,parameter :: jppj=14        !Number of photolytic reactions supplied
!jdf

        INTEGER  NB, NC !values set in fastj_driver, don't confuse
                        !this nc with the one in module_fastj_mie
        INTEGER, PARAMETER :: NS=15, NW=15, NP=21, NH=7, MX=3

!titls variables
        CHARACTER*55 TITLE0(3)
        CHARACTER*20 TITLEA(NP)
        CHARACTER*7  TITLEJ(3,NS)
! atmos variables
        REAL(kind=double), dimension(KMAXD+1)         :: TJ, DM, DO3, DBC, Z
        REAL(kind=double), dimension(KMAXD+2)         :: PJ
        REAL(kind=double), dimension(MX,KMAXD+1)      :: AER
        REAL(kind=double), dimension(KMAXD+1,KMAXD+1) :: AMF        
        REAL(kind=double) ::  RAD,RFLECT,SZA,U0,TANHT,ZZHT  
! ccwvl variables
	REAL(kind=double), dimension(NW) :: WL, FL, QBC 
	REAL(kind=double), dimension(NW+1) :: WBIN, QRAYL
	REAL(kind=double), dimension(NW,3) :: QO2, QO3, Q1D
	REAL(kind=double), dimension(NW,2,NS-3) :: QQQ
	REAL(kind=double), dimension(3,NS) :: TQQ
	REAL(kind=double), dimension(4,NP) :: WAA, QAA, RAA, SSA
	REAL(kind=double), dimension(8,4,NP) :: PAA
	REAL(kind=double), dimension(NW, kmaxd) :: FFF
	REAL(kind=double), dimension(NS) :: VALJ
	INTEGER, dimension(MX) :: MIEDX
	INTEGER :: NJVAL,NW1,NW2,NAA,NLBATM
! clim variables
 	 REAL(kind=double), dimension(51,18,12) :: TREF, OREF
 	 REAL(kind=double), dimension(51) :: BREF
! jcntr variables
 	REAL(kind=double) :: dtaumax,szamax
! jvals variables	
 	REAL(kind=double), dimension(kmaxd,jppj) :: zj
 	REAL(kind=double), dimension(NW,3) :: zpdep
 	REAL(kind=double), dimension(jppj) :: jfacta
 	INTEGER, dimension(NS) :: jpdep
 	INTEGER, dimension(jppj) :: jind
 	INTEGER :: npdep
 	CHARACTER*7, dimension(jppj) :: jlabel 	
! jvsub variables
	REAL(kind=double) :: dtausub,dsubdiv
	INTEGER, dimension(2*(KMAXD+1)) :: jadsub
 ! herz variables
 	REAL(kind=double) :: hzo2,hzo3
 	REAL(kind=double), dimension(NH) :: hztoa
 	REAL(kind=double), dimension(kmaxd) :: fhz
 	INTEGER :: nhz
 	INTEGER, dimension(nh) :: hzind
 	CHARACTER*7, dimension(nh) :: hzlab 
 	REAL(kind=double), dimension(nh) :: hztmp
 	
! data declarations
! from inphot2 	
        data RAD, ZZHT, dtaumax, dsubdiv   &
!jdf      / 0.6375D+09,  0.5000D+06,  0.1000D+01,  0.1000D+02/
!jdf needed to reduce dsubdiv, otherwise too many vertical subdivisions for clouds
!wig doubled dtaumax to reduce instances when layer subdivision occurs
          / 0.6375D+09,  0.5000D+06,  0.2000D+01,  0.2000D+01/
       data dtausub, szamax   &
          / 0.1000D+01,  0.9800D+02/ 
          
! from set_aer2          
        data MIEDX   &
         /   &
           15,    10,    14   &
         /
       data BREF   &
         /   &
         0.1000D-09,  0.1000D-09,  0.1000D-09,  0.1000D-09,   &
         0.1000D-09,  0.1000D-09,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
         0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
         
! from rd_js2
       data jfacta   &
         /   &
           0.1000D+01,  0.1000D+01,  0.1000D+01,   &
           0.1000D+01,  0.1000D+01,  0.1000D+01,   &
           0.1000D+01,  0.1000D+01,  0.1000D+01,   &
           0.1000D+01,  0.1000D+01,  0.1000D+01,   &
           0.1000D+01,  0.1000D+01   &
         /
       data jlabel   &
         /   &
          'NO2    ', 'O3     ', 'O3_1d  ',   &
          'H2O2   ', 'HCHO_a ', 'HCHO_b ',   &
          'MeOOH  ', 'NO3_X  ', 'NO3_L  ',   &
          'HONO   ', 'N2O5   ', 'HONO2  ',   &
          'HO2NO2 ', 'C2H5O2 '   &
         /         

! from rd_tjpl2
       data TITLE0(1)   &
         /   &
       '          jv_spec.dat FAST J-code for Troposphere std J'   &
         /
       data NJVAL,NWWW,NW1,NW2   &
         /   &
          15,    7,    1,    7   &
         /
       data (WBIN(IW),IW=1,  8)   &
         /   &
             289.00,    298.25,    307.45,    312.45,   &
             320.30,    345.00,    412.45,    850.00   &
         /
       data (WL(IW),IW=1,  7)   &
         /   &
               294.,      303.,      310.,      316.,   &
               333.,      380.,      574.   &
         /
       data (FL(IW),IW=1,  7)   &
         /   &
          0.7352E+15, 0.7332E+15, 0.5022E+15, 0.8709E+15,   &
          0.3786E+16, 0.1544E+17, 0.2110E+18   &
         /
       data (QRAYL(IW),IW=1,  7)   &
         /   &
           0.618E-25,  0.543E-25,  0.492E-25,  0.454E-25,   &
           0.363E-25,  0.209E-25,  0.383E-26   &
         /
       data (QBC(IW),IW=1,  7)   &
         /   &
            10.08,    9.96,    9.87,    9.79,   &
             9.58,    9.00,    6.50   &
         /
        data (TITLEJ(KTMP,1), KTMP=1,3)   &
         /   &
         'O2     ', 'O2     ', 'O2     '   &
         /
        data (TITLEJ(KTMP,2), KTMP=1,3)   &
         /   &
         'O3     ', 'O3     ', 'O3     '   &
         /
        data (TITLEJ(KTMP,3), KTMP=1,3)   &
         /   &
         'O3_1d  ', 'O3_1d  ', 'O3_1d  '   &
         /
        data (TQQ(KTMP,1), KTMP=1,3)   &
         /   &
          180.,   260.,   300.   &
         /
        data (TQQ(KTMP,2), KTMP=1,3)   &
         /   &
          180.,   260.,   300.   &
         /
        data (TQQ(KTMP,3), KTMP=1,3)   &
         /   &
          180.,   260.,   300.   &
         /
        data (QO2(IW, 1), IW=1,  7)   &
         /   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (QO2(IW, 2), IW=1,  7)   &
         /   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (QO2(IW, 3), IW=1,  7)   &
         /   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00,   0.0000E+00,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (QO3(IW, 1), IW=1,  7)   &
         /   &
          0.8693E-18,   0.2365E-18,   0.8722E-19,   &
          0.3694E-19,   0.4295E-20,   0.1804E-22,   &
          0.1630E-20   &
         /
        data (QO3(IW, 2), IW=1,  7)   &
         /   &
          0.9189E-18,   0.2571E-18,   0.9673E-19,   &
          0.4141E-19,   0.5457E-20,   0.2775E-22,   &
          0.1630E-20   &
         /
        data (QO3(IW, 3), IW=1,  7)   &
         /   &
          0.9574E-18,   0.2777E-18,   0.1075E-18,   &
          0.4725E-19,   0.6782E-20,   0.4824E-22,   &
          0.1630E-20   &
         /
        data (Q1D(IW, 1), IW=1,  7)   &
         /   &
          0.9500E+00,   0.9330E+00,   0.4270E+00,   &
          0.6930E-01,   0.6060E-01,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (Q1D(IW, 2), IW=1,  7)   &
         /   &
          0.9500E+00,   0.9420E+00,   0.4890E+00,   &
          0.1360E+00,   0.7110E-01,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (Q1D(IW, 3), IW=1,  7)   &
         /   &
          0.9500E+00,   0.9550E+00,   0.5870E+00,   &
          0.2370E+00,   0.8570E-01,   0.0000E+00,   &
          0.0000E+00   &
         /
        data (TITLEJ(1,JTMP), JTMP=4,15)   &
         /   &
        'H2O2   ',  'HCHO_a ',  'HCHO_b ',  'MeOOH  ',   &
        'NO2    ',  'NO3_X  ',  'NO3_L  ',  'N2O5   ',   &
        'HONO   ',  'HONO2  ',  'HO2NO2 ',  'C2H5O2 '   &
         /
       data (TITLEJ(2,JTMP), JTMP=4,15)   &
         /   &
        'H2O2   ',  'HCHO_a ',  'HCHO_b ',  'MeOOH  ',   &
        'NO2    ',  'NO3_X  ',  'NO3_L  ',  'N2O5   ',   &
        'HONO   ',  'HONO2  ',  'HO2NO2 ',  'C2H5O2 '   &
         /
        data (TQQ(1,JTMP), JTMP= 4,15)   &
         /   &
         200.,   223.,   223.,   200.,   &
         200.,   200.,   200.,   225.,   &
         200.,   200.,   200.,   200.   &
         /
        data (TQQ(2,JTMP), JTMP= 4,15)   &
         /   &
         300.,   293.,   293.,   300.,   &
         300.,   300.,   300.,   300.,   &
         300.,   300.,   300.,   300.   &
         /
        data (QQQ(IW,1, 1), IW=1, 7)   &
         /   &
         0.88510E-20,   0.50080E-20,   0.32150E-20,   0.21160E-20,   &
         0.80100E-21,   0.20880E-22,   0.00000E+00   &
         /
        data (QQQ(IW,1, 2), IW=1, 7)   &
         /   &
         0.00000E+00,   0.19420E-19,   0.12740E-19,   0.19710E-19,   &
         0.43550E-20,   0.50740E-25,   0.00000E+00   &
         /
        data (QQQ(IW,1, 3), IW=1, 7)   &
         /   &
         0.00000E+00,   0.63870E-20,   0.43920E-20,   0.90270E-20,   &
         0.10410E-19,   0.19490E-21,   0.00000E+00   &
         /
        data (QQQ(IW,1, 4), IW=1, 7)   &
         /   &
         0.58830E-20,   0.35730E-20,   0.24370E-20,   0.17560E-20,   &
         0.74280E-21,   0.42360E-22,   0.00000E+00   &
         /
        data (QQQ(IW,1, 5), IW=1, 7)   &
         /   &
         0.10480E-18,   0.14940E-18,   0.18980E-18,   0.22950E-18,   &
         0.33910E-18,   0.42300E-18,   0.40470E-21   &
         /
        data (QQQ(IW,1, 6), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.74310E-18   &
         /
        data (QQQ(IW,1, 7), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.95730E-19   &
         /
        data (QQQ(IW,1, 8), IW=1, 7)   &
         /   &
         0.41300E-19,   0.19980E-19,   0.11670E-19,   0.72500E-20,   &
         0.22960E-20,   0.11630E-21,   0.00000E+00   &
         /
        data (QQQ(IW,1, 9), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.12000E-19,   0.34690E-19,   &
         0.10900E-18,   0.86450E-19,   0.00000E+00   &
         /
        data (QQQ(IW,1,10), IW=1, 7)   &
         /   &
         0.37060E-20,   0.13770E-20,   0.54510E-21,   0.21020E-21,   &
         0.21540E-22,   0.87680E-25,   0.00000E+00   &
         /
        data (QQQ(IW,1,11), IW=1, 7)   &
         /   &
         0.28690E-19,   0.11020E-19,   0.52220E-20,   0.27940E-20,   &
         0.23010E-21,   0.00000E+00,   0.00000E+00   &
         /
        data (QQQ(IW,1,12), IW=1, 7)   &
         /   &
         0.47500E-18,   0.12130E-19,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.00000E+00   &
         /
        data (QQQ(IW,2, 1), IW=1, 7)   &
         /   &
         0.98180E-20,   0.57350E-20,   0.37970E-20,   0.25850E-20,   &
         0.10490E-20,   0.26990E-22,   0.00000E+00   &
         /
        data (QQQ(IW,2, 2), IW=1, 7)   &
         /   &
         0.00000E+00,   0.18470E-19,   0.13040E-19,   0.18960E-19,   &
         0.39490E-20,   0.44400E-25,   0.00000E+00   &
         /
        data (QQQ(IW,2, 3), IW=1, 7)   &
         /   &
         0.00000E+00,   0.60770E-20,   0.45000E-20,   0.87150E-20,   &
         0.94340E-20,   0.18920E-21,   0.00000E+00   &
         /
        data (QQQ(IW,2, 4), IW=1, 7)   &
         /   &
         0.58830E-20,   0.35730E-20,   0.24370E-20,   0.17560E-20,   &
         0.74280E-21,   0.42360E-22,   0.00000E+00   &
         /
        data (QQQ(IW,2, 5), IW=1, 7)   &
         /   &
         0.10390E-18,   0.14620E-18,   0.18450E-18,   0.22230E-18,   &
         0.32560E-18,   0.41500E-18,   0.40200E-21   &
         /
        data (QQQ(IW,2, 6), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.74310E-18   &
         /
        data (QQQ(IW,2, 7), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.95730E-19   &
         /
        data (QQQ(IW,2, 8), IW=1, 7)   &
         /   &
         0.57180E-19,   0.33170E-19,   0.22230E-19,   0.15520E-19,   &
         0.64090E-20,   0.54290E-21,   0.00000E+00   &
         /
        data (QQQ(IW,2, 9), IW=1, 7)   &
         /   &
         0.00000E+00,   0.00000E+00,   0.12000E-19,   0.34690E-19,   &
         0.10900E-18,   0.86450E-19,   0.00000E+00   &
         /
        data (QQQ(IW,2,10), IW=1, 7)   &
         /   &
         0.47470E-20,   0.19230E-20,   0.83140E-21,   0.35890E-21,   &
         0.47640E-22,   0.26670E-24,   0.00000E+00   &
         /
        data (QQQ(IW,2,11), IW=1, 7)   &
         /   &
         0.28690E-19,   0.11020E-19,   0.52220E-20,   0.27940E-20,   &
         0.23010E-21,   0.00000E+00,   0.00000E+00   &
         /
        data (QQQ(IW,2,12), IW=1, 7)   &
         /   &
         0.47500E-18,   0.12130E-19,   0.00000E+00,   0.00000E+00,   &
         0.00000E+00,   0.00000E+00,   0.00000E+00   &
         /
       data TITLE0(2)   &
         /   &
       '          ============================================='   &
         /
       data TITLE0(3)   &
         /   &
       '          NW-SCATTER                                   '   &
         /
       data NAA   &
         /   &
           21   &
         /
       data (TITLEA(jtmp), jtmp=1, 21)   &
         /   &
        'RAYLE  = Rayleigh ph',  'ISOTR  = isotropic  ',   &
        'ABSRB  = fully absor',  'S_Bkg = backgrnd str',   &
        'S_Vol = volcanic str',  'W_H01 = water haze (',   &
        'W_H04 = water haze (',  'W_C02 = water cloud ',   &
        'W_C04 = water cloud ',  'W_C08 = water cloud ',   &
        'W_C13 = water cloud ',  'W_L06 = water cloud ',   &
        'Ice-H = hexagonal ic',  'Ice-I = irregular ic',   &
        'Mdust 0.15 = mineral',  'Mdust 0.25 = mineral',   &
        'Mdust 0.4 = mineral ',  'Mdust 0.8 = mineral ',   &
        'Mdust 1.5 = mineral ',  'Mdust 2.5 = mineral ',   &
        'Mdust 4.0 = mineral '   &
         /
       data ((WAA(ktmp,jtmp), ktmp=1, 4), jtmp=1,21)   &
         /   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03,   &
          0.3000D+03,  0.4000D+03,  0.6000D+03,  0.9990D+03   &
         /
       data ((QAA(ktmp,jtmp), ktmp=1, 4), jtmp=1,21)   &
         /   &
          0.1235D+03,  0.3910D+02,  0.7700D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.2754D+01,  0.2402D+01,  0.1645D+01,  0.7449D+00,   &
          0.2644D+01,  0.2560D+01,  0.2222D+01,  0.1532D+01,   &
          0.2844D+01,  0.2350D+01,  0.1404D+01,  0.5034D+00,   &
          0.2300D+01,  0.2474D+01,  0.2672D+01,  0.2957D+01,   &
          0.2141D+01,  0.2178D+01,  0.2229D+01,  0.2307D+01,   &
          0.2083D+01,  0.2106D+01,  0.2135D+01,  0.2192D+01,   &
          0.2054D+01,  0.2064D+01,  0.2088D+01,  0.2124D+01,   &
          0.2044D+01,  0.2053D+01,  0.2072D+01,  0.2098D+01,   &
          0.2062D+01,  0.2075D+01,  0.2100D+01,  0.2142D+01,   &
          0.2000D+01,  0.2000D+01,  0.2000D+01,  0.2000D+01,   &
          0.2000D+01,  0.2000D+01,  0.2000D+01,  0.2000D+01,   &
          0.3004D+01,  0.2476D+01,  0.1277D+01,  0.3595D+00,   &
          0.2941D+01,  0.3105D+01,  0.2614D+01,  0.1243D+01,   &
          0.2607D+01,  0.2824D+01,  0.3116D+01,  0.2477D+01,   &
          0.2346D+01,  0.2434D+01,  0.2642D+01,  0.3040D+01,   &
          0.2223D+01,  0.2273D+01,  0.2371D+01,  0.2575D+01,   &
          0.2158D+01,  0.2192D+01,  0.2256D+01,  0.2372D+01,   &
          0.2115D+01,  0.2140D+01,  0.2185D+01,  0.2264D+01   &
         /
       data ((RAA(ktmp,jtmp), ktmp=1, 4), jtmp=1,21)   &
         /   &
          0.1000D-02,  0.1000D-02,  0.1000D-02,  0.1000D-02,   &
          0.1000D-02,  0.1000D-02,  0.1000D-02,  0.1000D-02,   &
          0.1000D-02,  0.1000D-02,  0.1000D-02,  0.1000D-02,   &
          0.2210D+00,  0.2210D+00,  0.2210D+00,  0.2210D+00,   &
          0.3860D+00,  0.3860D+00,  0.3860D+00,  0.3860D+00,   &
          0.2500D+00,  0.2500D+00,  0.2500D+00,  0.2500D+00,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.3000D+01,  0.3000D+01,  0.3000D+01,  0.3000D+01,   &
          0.6000D+01,  0.6000D+01,  0.6000D+01,  0.6000D+01,   &
          0.1200D+02,  0.1200D+02,  0.1200D+02,  0.1200D+02,   &
          0.2000D+02,  0.2000D+02,  0.2000D+02,  0.2000D+02,   &
          0.1000D+02,  0.1000D+02,  0.1000D+02,  0.1000D+02,   &
          0.6700D+02,  0.6700D+02,  0.6700D+02,  0.6700D+02,   &
          0.5000D+02,  0.5000D+02,  0.5000D+02,  0.5000D+02,   &
          0.1500D+00,  0.1500D+00,  0.1500D+00,  0.1500D+00,   &
          0.2500D+00,  0.2500D+00,  0.2500D+00,  0.2500D+00,   &
          0.4000D+00,  0.4000D+00,  0.4000D+00,  0.4000D+00,   &
          0.8000D+00,  0.8000D+00,  0.8000D+00,  0.8000D+00,   &
          0.1500D+01,  0.1500D+01,  0.1500D+01,  0.1500D+01,   &
          0.2500D+01,  0.2500D+01,  0.2500D+01,  0.2500D+01,   &
          0.4000D+01,  0.4000D+01,  0.4000D+01,  0.4000D+01   &
         /
       data ((SSA(ktmp,jtmp), ktmp=1, 4), jtmp=1,21)   &
         /   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.1000D+01,  0.1000D+01,  0.1000D+01,  0.1000D+01,   &
          0.8840D+00,  0.9370D+00,  0.9790D+00,  0.9580D+00,   &
          0.8200D+00,  0.9130D+00,  0.9800D+00,  0.9740D+00,   &
          0.7390D+00,  0.8600D+00,  0.9710D+00,  0.9750D+00,   &
          0.6400D+00,  0.7630D+00,  0.9360D+00,  0.9570D+00,   &
          0.5790D+00,  0.6760D+00,  0.8900D+00,  0.9130D+00,   &
          0.5560D+00,  0.6160D+00,  0.8420D+00,  0.8690D+00,   &
          0.5500D+00,  0.5770D+00,  0.7860D+00,  0.8190D+00   &
         /
       data (PAA(itmp, 1,   1),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.5000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 2,   1),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.5000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 3,   1),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.5000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 4,   1),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.5000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 1,   2),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 2,   2),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 3,   2),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 4,   2),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 1,   3),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 2,   3),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 3,   3),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 4,   3),itmp=1,8)   &
         /   &
          0.1000D+01,  0.0000D+00,  0.0000D+00,  0.0000D+00,   &
          0.0000D+00,  0.0000D+00,  0.0000D+00,  0.0000D+00   &
         /
       data (PAA(itmp, 1,   4),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2157D+01,  0.2767D+01,  0.2627D+01,   &
          0.2457D+01,  0.2098D+01,  0.1792D+01,  0.1518D+01   &
         /
       data (PAA(itmp, 2,   4),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2146D+01,  0.2641D+01,  0.2422D+01,   &
          0.2122D+01,  0.1709D+01,  0.1357D+01,  0.1070D+01   &
         /
       data (PAA(itmp, 3,   4),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2076D+01,  0.2377D+01,  0.2023D+01,   &
          0.1608D+01,  0.1177D+01,  0.8460D+00,  0.5990D+00   &
         /
       data (PAA(itmp, 4,   4),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1877D+01,  0.1920D+01,  0.1412D+01,   &
          0.9700D+00,  0.6140D+00,  0.3880D+00,  0.2380D+00   &
         /
       data (PAA(itmp, 1,   5),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2152D+01,  0.2901D+01,  0.2856D+01,   &
          0.2971D+01,  0.2772D+01,  0.2709D+01,  0.2587D+01   &
         /
       data (PAA(itmp, 2,   5),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2142D+01,  0.2810D+01,  0.2706D+01,   &
          0.2691D+01,  0.2421D+01,  0.2254D+01,  0.2066D+01   &
         /
       data (PAA(itmp, 3,   5),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2127D+01,  0.2673D+01,  0.2488D+01,   &
          0.2308D+01,  0.1963D+01,  0.1698D+01,  0.1461D+01   &
         /
       data (PAA(itmp, 4,   5),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2076D+01,  0.2458D+01,  0.2165D+01,   &
          0.1841D+01,  0.1449D+01,  0.1142D+01,  0.8980D+00   &
         /
       data (PAA(itmp, 1,   6),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2454D+01,  0.3376D+01,  0.3624D+01,   &
          0.3608D+01,  0.3300D+01,  0.2911D+01,  0.2526D+01   &
         /
       data (PAA(itmp, 2,   6),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2431D+01,  0.3235D+01,  0.3355D+01,   &
          0.3108D+01,  0.2686D+01,  0.2180D+01,  0.1690D+01   &
         /
       data (PAA(itmp, 3,   6),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2328D+01,  0.2789D+01,  0.2593D+01,   &
          0.2062D+01,  0.1492D+01,  0.1013D+01,  0.6320D+00   &
         /
       data (PAA(itmp, 4,   6),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1916D+01,  0.1870D+01,  0.1233D+01,   &
          0.7040D+00,  0.3380D+00,  0.1540D+00,  0.6200D-01   &
         /
       data (PAA(itmp, 1,   7),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2433D+01,  0.3625D+01,  0.4104D+01,   &
          0.4645D+01,  0.5020D+01,  0.5409D+01,  0.5802D+01   &
         /
       data (PAA(itmp, 2,   7),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2341D+01,  0.3475D+01,  0.3863D+01,   &
          0.4330D+01,  0.4589D+01,  0.4878D+01,  0.5125D+01   &
         /
       data (PAA(itmp, 3,   7),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2325D+01,  0.3334D+01,  0.3624D+01,   &
          0.3896D+01,  0.3939D+01,  0.3968D+01,  0.3964D+01   &
         /
       data (PAA(itmp, 4,   7),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2434D+01,  0.3393D+01,  0.3685D+01,   &
          0.3709D+01,  0.3528D+01,  0.3213D+01,  0.2903D+01   &
         /
       data (PAA(itmp, 1,   8),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2544D+01,  0.3886D+01,  0.4572D+01,   &
          0.5256D+01,  0.5933D+01,  0.6530D+01,  0.7291D+01   &
         /
       data (PAA(itmp, 2,   8),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2513D+01,  0.3834D+01,  0.4480D+01,   &
          0.5160D+01,  0.5785D+01,  0.6356D+01,  0.7044D+01   &
         /
       data (PAA(itmp, 3,   8),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2483D+01,  0.3767D+01,  0.4359D+01,   &
          0.4998D+01,  0.5542D+01,  0.6054D+01,  0.6639D+01   &
         /
       data (PAA(itmp, 4,   8),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2395D+01,  0.3597D+01,  0.4063D+01,   &
          0.4648D+01,  0.5052D+01,  0.5478D+01,  0.5857D+01   &
         /
       data (PAA(itmp, 1,   9),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2596D+01,  0.3973D+01,  0.4725D+01,   &
          0.5406D+01,  0.6129D+01,  0.6751D+01,  0.7607D+01   &
         /
       data (PAA(itmp, 2,   9),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2571D+01,  0.3936D+01,  0.4660D+01,   &
          0.5345D+01,  0.6056D+01,  0.6670D+01,  0.7492D+01   &
         /
       data (PAA(itmp, 3,   9),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2557D+01,  0.3902D+01,  0.4596D+01,   &
          0.5263D+01,  0.5923D+01,  0.6507D+01,  0.7267D+01   &
         /
       data (PAA(itmp, 4,   9),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2499D+01,  0.3799D+01,  0.4418D+01,   &
          0.5081D+01,  0.5667D+01,  0.6213D+01,  0.6851D+01   &
         /
       data (PAA(itmp, 1,  10),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2619D+01,  0.4013D+01,  0.4798D+01,   &
          0.5476D+01,  0.6232D+01,  0.6870D+01,  0.7780D+01   &
         /
       data (PAA(itmp, 2,  10),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2611D+01,  0.3999D+01,  0.4773D+01,   &
          0.5451D+01,  0.6194D+01,  0.6826D+01,  0.7716D+01   &
         /
       data (PAA(itmp, 3,  10),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2589D+01,  0.3965D+01,  0.4712D+01,   &
          0.5394D+01,  0.6121D+01,  0.6744D+01,  0.7599D+01   &
         /
       data (PAA(itmp, 4,  10),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2563D+01,  0.3917D+01,  0.4625D+01,   &
          0.5302D+01,  0.5992D+01,  0.6593D+01,  0.7385D+01   &
         /
       data (PAA(itmp, 1,  11),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2627D+01,  0.4026D+01,  0.4822D+01,   &
          0.5499D+01,  0.6264D+01,  0.6907D+01,  0.7833D+01   &
         /
       data (PAA(itmp, 2,  11),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2620D+01,  0.4014D+01,  0.4800D+01,   &
          0.5477D+01,  0.6234D+01,  0.6872D+01,  0.7783D+01   &
         /
       data (PAA(itmp, 3,  11),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2604D+01,  0.3990D+01,  0.4755D+01,   &
          0.5435D+01,  0.6178D+01,  0.6807D+01,  0.7690D+01   &
         /
       data (PAA(itmp, 4,  11),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2585D+01,  0.3955D+01,  0.4691D+01,   &
          0.5368D+01,  0.6077D+01,  0.6688D+01,  0.7520D+01   &
         /
       data (PAA(itmp, 1,  12),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2613D+01,  0.4002D+01,  0.4779D+01,   &
          0.5458D+01,  0.6205D+01,  0.6839D+01,  0.7735D+01   &
         /
       data (PAA(itmp, 2,  12),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2601D+01,  0.3984D+01,  0.4745D+01,   &
          0.5425D+01,  0.6158D+01,  0.6785D+01,  0.7657D+01   &
         /
       data (PAA(itmp, 3,  12),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2580D+01,  0.3947D+01,  0.4679D+01,   &
          0.5359D+01,  0.6070D+01,  0.6684D+01,  0.7514D+01   &
         /
       data (PAA(itmp, 4,  12),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2545D+01,  0.3884D+01,  0.4568D+01,   &
          0.5244D+01,  0.5909D+01,  0.6496D+01,  0.7250D+01   &
         /
       data (PAA(itmp, 1,  13),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2435D+01,  0.3712D+01,  0.4756D+01,   &
          0.5960D+01,  0.6908D+01,  0.7865D+01,  0.8954D+01   &
         /
       data (PAA(itmp, 2,  13),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2435D+01,  0.3712D+01,  0.4756D+01,   &
          0.5960D+01,  0.6908D+01,  0.7865D+01,  0.8954D+01   &
         /
       data (PAA(itmp, 3,  13),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2435D+01,  0.3712D+01,  0.4756D+01,   &
          0.5960D+01,  0.6908D+01,  0.7865D+01,  0.8954D+01   &
         /
       data (PAA(itmp, 4,  13),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2435D+01,  0.3712D+01,  0.4756D+01,   &
          0.5960D+01,  0.6908D+01,  0.7865D+01,  0.8954D+01   &
         /
       data (PAA(itmp, 1,  14),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2257D+01,  0.3164D+01,  0.4096D+01,   &
          0.5088D+01,  0.6018D+01,  0.6897D+01,  0.7794D+01   &
         /
       data (PAA(itmp, 2,  14),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2257D+01,  0.3164D+01,  0.4096D+01,   &
          0.5088D+01,  0.6018D+01,  0.6897D+01,  0.7794D+01   &
         /
       data (PAA(itmp, 3,  14),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2257D+01,  0.3164D+01,  0.4096D+01,   &
          0.5088D+01,  0.6018D+01,  0.6897D+01,  0.7794D+01   &
         /
       data (PAA(itmp, 4,  14),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2257D+01,  0.3164D+01,  0.4096D+01,   &
          0.5088D+01,  0.6018D+01,  0.6897D+01,  0.7794D+01   &
         /
       data (PAA(itmp, 1,  15),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2030D+01,  0.2363D+01,  0.2082D+01,   &
          0.1710D+01,  0.1290D+01,  0.9410D+00,  0.6380D+00   &
         /
       data (PAA(itmp, 2,  15),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1988D+01,  0.2151D+01,  0.1735D+01,   &
          0.1248D+01,  0.8090D+00,  0.5030D+00,  0.2790D+00   &
         /
       data (PAA(itmp, 3,  15),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1816D+01,  0.1675D+01,  0.1075D+01,   &
          0.6040D+00,  0.2810D+00,  0.1320D+00,  0.4900D-01   &
         /
       data (PAA(itmp, 4,  15),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1320D+01,  0.9940D+00,  0.3770D+00,   &
          0.1260D+00,  0.3100D-01,  0.8000D-02,  0.1000D-02   &
         /
       data (PAA(itmp, 1,  16),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2046D+01,  0.2643D+01,  0.2593D+01,   &
          0.2634D+01,  0.2406D+01,  0.2244D+01,  0.1944D+01   &
         /
       data (PAA(itmp, 2,  16),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2021D+01,  0.2486D+01,  0.2264D+01,   &
          0.2047D+01,  0.1671D+01,  0.1362D+01,  0.1039D+01   &
         /
       data (PAA(itmp, 3,  16),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2026D+01,  0.2296D+01,  0.1926D+01,   &
          0.1470D+01,  0.1013D+01,  0.6680D+00,  0.4030D+00   &
         /
       data (PAA(itmp, 4,  16),itmp=1,8)   &
         /   &
          0.1000D+01,  0.1824D+01,  0.1689D+01,  0.1087D+01,   &
          0.6110D+00,  0.2860D+00,  0.1340D+00,  0.5000D-01   &
         /
       data (PAA(itmp, 1,  17),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2192D+01,  0.3070D+01,  0.3393D+01,   &
          0.3903D+01,  0.4021D+01,  0.4248D+01,  0.4168D+01   &
         /
       data (PAA(itmp, 2,  17),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2027D+01,  0.2711D+01,  0.2679D+01,   &
          0.2900D+01,  0.2734D+01,  0.2723D+01,  0.2478D+01   &
         /
       data (PAA(itmp, 3,  17),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2017D+01,  0.2537D+01,  0.2306D+01,   &
          0.2136D+01,  0.1761D+01,  0.1466D+01,  0.1151D+01   &
         /
       data (PAA(itmp, 4,  17),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2036D+01,  0.2286D+01,  0.1903D+01,   &
          0.1428D+01,  0.9660D+00,  0.6230D+00,  0.3680D+00   &
         /
       data (PAA(itmp, 1,  18),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2517D+01,  0.3780D+01,  0.4729D+01,   &
          0.5755D+01,  0.6524D+01,  0.7339D+01,  0.7903D+01   &
         /
       data (PAA(itmp, 2,  18),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2295D+01,  0.3320D+01,  0.3800D+01,   &
          0.4578D+01,  0.4913D+01,  0.5482D+01,  0.5662D+01   &
         /
       data (PAA(itmp, 3,  18),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2023D+01,  0.2830D+01,  0.2805D+01,   &
          0.3279D+01,  0.3178D+01,  0.3418D+01,  0.3275D+01   &
         /
       data (PAA(itmp, 4,  18),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2019D+01,  0.2618D+01,  0.2441D+01,   &
          0.2414D+01,  0.2106D+01,  0.1895D+01,  0.1610D+01   &
         /
       data (PAA(itmp, 1,  19),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2705D+01,  0.4250D+01,  0.5641D+01,   &
          0.7023D+01,  0.8293D+01,  0.9539D+01,  0.1066D+02   &
         /
       data (PAA(itmp, 2,  19),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2539D+01,  0.3821D+01,  0.4771D+01,   &
          0.5881D+01,  0.6738D+01,  0.7733D+01,  0.8463D+01   &
         /
       data (PAA(itmp, 3,  19),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2240D+01,  0.3259D+01,  0.3544D+01,   &
          0.4375D+01,  0.4592D+01,  0.5292D+01,  0.5471D+01   &
         /
       data (PAA(itmp, 4,  19),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2083D+01,  0.2944D+01,  0.3008D+01,   &
          0.3555D+01,  0.3538D+01,  0.3852D+01,  0.3789D+01   &
         /
       data (PAA(itmp, 1,  20),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2780D+01,  0.4476D+01,  0.6085D+01,   &
          0.7664D+01,  0.9186D+01,  0.1067D+02,  0.1210D+02   &
         /
       data (PAA(itmp, 2,  20),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2678D+01,  0.4164D+01,  0.5458D+01,   &
          0.6813D+01,  0.8046D+01,  0.9325D+01,  0.1046D+02   &
         /
       data (PAA(itmp, 3,  20),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2391D+01,  0.3526D+01,  0.4044D+01,   &
          0.5035D+01,  0.5527D+01,  0.6483D+01,  0.6961D+01   &
         /
       data (PAA(itmp, 4,  20),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2268D+01,  0.3300D+01,  0.3634D+01,   &
          0.4458D+01,  0.4720D+01,  0.5401D+01,  0.5624D+01   &
         /
       data (PAA(itmp, 1,  21),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2809D+01,  0.4574D+01,  0.6281D+01,   &
          0.7960D+01,  0.9607D+01,  0.1122D+02,  0.1281D+02   &
         /
       data (PAA(itmp, 2,  21),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2761D+01,  0.4405D+01,  0.5941D+01,   &
          0.7485D+01,  0.8974D+01,  0.1046D+02,  0.1188D+02   &
         /
       data (PAA(itmp, 3,  21),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2505D+01,  0.3744D+01,  0.4488D+01,   &
          0.5599D+01,  0.6354D+01,  0.7485D+01,  0.8238D+01   &
         /
       data (PAA(itmp, 4,  21),itmp=1,8)   &
         /   &
          0.1000D+01,  0.2413D+01,  0.3563D+01,  0.4133D+01,   &
          0.5118D+01,  0.5652D+01,  0.6582D+01,  0.7097D+01   &
         /
       data NHZ, HZO2, HZO3, QRAYL( 8)   &
         /   &
           5,    0.8150D-23,    0.4400D-18,    0.3290D-24   &
         /
       data hzlab   &
         /   &
        'O2     ',  'H1211  ',  'H2402  ',  'CCl4   ',  'F11    ',   &
        '       ',  '       '   &
         /
       data hztmp   &
         /   &
            0.1670D-09,    0.2760D-04,    0.2750D-04,   &
            0.1310D-04,    0.7240D-05,   &
            0.0000D00,     0.0000D00   &
         /
! from rd_prof2                                 	
 	

       data (OREF( 1, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2400D-01,  0.2500D-01,  0.2400D-01,  0.2500D-01,   &
         0.2600D-01,  0.2600D-01,  0.2500D-01,  0.2400D-01   &
         /
       data (OREF( 1, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2400D-01,  0.2500D-01,  0.2400D-01,  0.2500D-01,   &
         0.2600D-01,  0.2600D-01,  0.2500D-01,  0.2400D-01   &
         /
       data (OREF( 1, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2400D-01,  0.2500D-01,  0.2400D-01,  0.2400D-01,   &
         0.2500D-01,  0.2400D-01,  0.2400D-01,  0.2400D-01   &
         /
       data (OREF( 1, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2400D-01,  0.2400D-01,  0.2400D-01,  0.2400D-01,   &
         0.2400D-01,  0.2400D-01,  0.2400D-01,  0.2400D-01   &
         /
       data (OREF( 1, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2400D-01,  0.2400D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2600D-01,  0.2600D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2500D-01,  0.2600D-01,  0.2600D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2400D-01,  0.2400D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01,   &
         0.2400D-01,  0.2400D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2600D-01,  0.2600D-01,  0.2600D-01,   &
         0.2600D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2600D-01   &
         /
       data (OREF( 1,10, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2600D-01,  0.2600D-01,  0.2500D-01,   &
         0.2600D-01,  0.2600D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2600D-01,  0.2600D-01   &
         /
       data (OREF( 1,11, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1,12, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1,13, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2600D-01,  0.2600D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2600D-01,  0.2600D-01   &
         /
       data (OREF( 1,14, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01,   &
         0.2400D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2600D-01,  0.2500D-01   &
         /
       data (OREF( 1,15, mtmp), mtmp=1,12)   &
         /   &
         0.2400D-01,  0.2300D-01,  0.2300D-01,  0.2400D-01,   &
         0.2400D-01,  0.2400D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2400D-01   &
         /
       data (OREF( 1,16, mtmp), mtmp=1,12)   &
         /   &
         0.2400D-01,  0.2300D-01,  0.2200D-01,  0.2300D-01,   &
         0.2300D-01,  0.2400D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1,17, mtmp), mtmp=1,12)   &
         /   &
         0.2400D-01,  0.2300D-01,  0.2200D-01,  0.2200D-01,   &
         0.2300D-01,  0.2300D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 1,18, mtmp), mtmp=1,12)   &
         /   &
         0.2400D-01,  0.2300D-01,  0.2200D-01,  0.2200D-01,   &
         0.2300D-01,  0.2300D-01,  0.2500D-01,  0.2500D-01,   &
         0.2500D-01,  0.2500D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 2, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3600D-01,  0.3500D-01,  0.3600D-01,   &
         0.3200D-01,  0.3200D-01,  0.3200D-01,  0.3400D-01,   &
         0.3500D-01,  0.3400D-01,  0.3400D-01,  0.3200D-01   &
         /
       data (OREF( 2, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3600D-01,  0.3500D-01,  0.3600D-01,   &
         0.3200D-01,  0.3200D-01,  0.3200D-01,  0.3400D-01,   &
         0.3500D-01,  0.3400D-01,  0.3400D-01,  0.3200D-01   &
         /
       data (OREF( 2, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3300D-01,  0.3300D-01,  0.3300D-01,  0.3200D-01,   &
         0.3200D-01,  0.3200D-01,  0.3200D-01,  0.3200D-01,   &
         0.3300D-01,  0.3100D-01,  0.3100D-01,  0.3100D-01   &
         /
       data (OREF( 2, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3300D-01,  0.3400D-01,  0.3400D-01,  0.3300D-01,   &
         0.3100D-01,  0.3100D-01,  0.3100D-01,  0.3200D-01,   &
         0.3200D-01,  0.3100D-01,  0.3100D-01,  0.3200D-01   &
         /
       data (OREF( 2, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3500D-01,  0.3500D-01,  0.3500D-01,   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3300D-01,   &
         0.3200D-01,  0.3200D-01,  0.3300D-01,  0.3400D-01   &
         /
       data (OREF( 2, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3500D-01,  0.3500D-01,  0.3500D-01,   &
         0.3500D-01,  0.3500D-01,  0.3400D-01,  0.3300D-01,   &
         0.3300D-01,  0.3300D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3200D-01,   &
         0.3200D-01,  0.3200D-01,  0.3300D-01,  0.3300D-01   &
         /
       data (OREF( 2, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3200D-01,   &
         0.3200D-01,  0.3200D-01,  0.3300D-01,  0.3300D-01   &
         /
       data (OREF( 2, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3500D-01,  0.3500D-01,  0.3500D-01,   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3300D-01,   &
         0.3200D-01,  0.3300D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2,10, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3500D-01,  0.3400D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3300D-01,   &
         0.3300D-01,  0.3400D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2,11, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3200D-01,   &
         0.3200D-01,  0.3300D-01,  0.3300D-01,  0.3200D-01,   &
         0.3300D-01,  0.3300D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2,12, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3300D-01,   &
         0.3300D-01,  0.3300D-01,  0.3300D-01,  0.3200D-01,   &
         0.3200D-01,  0.3300D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2,13, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3500D-01,  0.3500D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3400D-01,  0.3300D-01,   &
         0.3300D-01,  0.3400D-01,  0.3500D-01,  0.3500D-01   &
         /
       data (OREF( 2,14, mtmp), mtmp=1,12)   &
         /   &
         0.3300D-01,  0.3300D-01,  0.3300D-01,  0.3300D-01,   &
         0.3200D-01,  0.3300D-01,  0.3300D-01,  0.3300D-01,   &
         0.3300D-01,  0.3400D-01,  0.3400D-01,  0.3400D-01   &
         /
       data (OREF( 2,15, mtmp), mtmp=1,12)   &
         /   &
         0.3100D-01,  0.3000D-01,  0.3000D-01,  0.3100D-01,   &
         0.3100D-01,  0.3200D-01,  0.3300D-01,  0.3300D-01,   &
         0.3300D-01,  0.3400D-01,  0.3300D-01,  0.3200D-01   &
         /
       data (OREF( 2,16, mtmp), mtmp=1,12)   &
         /   &
         0.3200D-01,  0.3000D-01,  0.2800D-01,  0.2900D-01,   &
         0.3000D-01,  0.3200D-01,  0.3300D-01,  0.3300D-01,   &
         0.3400D-01,  0.3300D-01,  0.3300D-01,  0.3300D-01   &
         /
       data (OREF( 2,17, mtmp), mtmp=1,12)   &
         /   &
         0.3200D-01,  0.2900D-01,  0.2700D-01,  0.2800D-01,   &
         0.3000D-01,  0.3100D-01,  0.3300D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3300D-01   &
         /
       data (OREF( 2,18, mtmp), mtmp=1,12)   &
         /   &
         0.3200D-01,  0.2900D-01,  0.2700D-01,  0.2800D-01,   &
         0.3000D-01,  0.3100D-01,  0.3300D-01,  0.3400D-01,   &
         0.3400D-01,  0.3400D-01,  0.3300D-01,  0.3300D-01   &
         /
       data (OREF( 3, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.3600D-01,  0.3700D-01,  0.3700D-01,   &
         0.4000D-01,  0.4000D-01,  0.4100D-01,  0.3800D-01,   &
         0.3700D-01,  0.3800D-01,  0.3900D-01,  0.4100D-01   &
         /
       data (OREF( 3, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.3600D-01,  0.3700D-01,  0.3700D-01,   &
         0.4000D-01,  0.4000D-01,  0.4100D-01,  0.3800D-01,   &
         0.3700D-01,  0.3800D-01,  0.3900D-01,  0.4100D-01   &
         /
       data (OREF( 3, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4000D-01,  0.3900D-01,  0.3900D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.4100D-01,  0.4100D-01,   &
         0.4000D-01,  0.4200D-01,  0.4200D-01,  0.4200D-01   &
         /
       data (OREF( 3, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4000D-01,  0.3900D-01,  0.3800D-01,  0.3900D-01,   &
         0.4100D-01,  0.4100D-01,  0.4200D-01,  0.4100D-01,   &
         0.4100D-01,  0.4200D-01,  0.4200D-01,  0.4100D-01   &
         /
       data (OREF( 3, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3900D-01,  0.4000D-01,  0.4000D-01,   &
         0.4000D-01,  0.4100D-01,  0.4000D-01,  0.3900D-01   &
         /
       data (OREF( 3, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.3900D-01   &
         /
       data (OREF( 3, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3900D-01,  0.3800D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3800D-01,  0.3900D-01,  0.4000D-01,   &
         0.4000D-01,  0.4100D-01,  0.3900D-01,  0.3900D-01   &
         /
       data (OREF( 3, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3900D-01,  0.3900D-01,  0.4000D-01,   &
         0.4100D-01,  0.4100D-01,  0.4000D-01,  0.3900D-01   &
         /
       data (OREF( 3, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.3700D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3800D-01,  0.3900D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.3800D-01   &
         /
       data (OREF( 3,10, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3800D-01,  0.3800D-01,  0.3900D-01,   &
         0.3900D-01,  0.3900D-01,  0.3800D-01,  0.3800D-01   &
         /
       data (OREF( 3,11, mtmp), mtmp=1,12)   &
         /   &
         0.3900D-01,  0.3900D-01,  0.4000D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.3900D-01   &
         /
       data (OREF( 3,12, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3800D-01,  0.3900D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.4100D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.3800D-01   &
         /
       data (OREF( 3,13, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.3700D-01,  0.3800D-01,  0.3800D-01,   &
         0.3800D-01,  0.3900D-01,  0.3900D-01,  0.4000D-01,   &
         0.3900D-01,  0.3900D-01,  0.3800D-01,  0.3700D-01   &
         /
       data (OREF( 3,14, mtmp), mtmp=1,12)   &
         /   &
         0.4000D-01,  0.4000D-01,  0.4000D-01,  0.4000D-01,   &
         0.4000D-01,  0.4000D-01,  0.3900D-01,  0.4000D-01,   &
         0.3900D-01,  0.3900D-01,  0.3800D-01,  0.3800D-01   &
         /
       data (OREF( 3,15, mtmp), mtmp=1,12)   &
         /   &
         0.4100D-01,  0.4300D-01,  0.4300D-01,  0.4200D-01,   &
         0.4200D-01,  0.4100D-01,  0.4000D-01,  0.4000D-01,   &
         0.3900D-01,  0.3900D-01,  0.4000D-01,  0.4000D-01   &
         /
       data (OREF( 3,16, mtmp), mtmp=1,12)   &
         /   &
         0.4100D-01,  0.4300D-01,  0.4600D-01,  0.4400D-01,   &
         0.4300D-01,  0.4100D-01,  0.4000D-01,  0.3900D-01,   &
         0.3900D-01,  0.4000D-01,  0.4000D-01,  0.4000D-01   &
         /
       data (OREF( 3,17, mtmp), mtmp=1,12)   &
         /   &
         0.4100D-01,  0.4400D-01,  0.4600D-01,  0.4500D-01,   &
         0.4300D-01,  0.4200D-01,  0.4000D-01,  0.3800D-01,   &
         0.3800D-01,  0.3900D-01,  0.4000D-01,  0.4000D-01   &
         /
       data (OREF( 3,18, mtmp), mtmp=1,12)   &
         /   &
         0.4100D-01,  0.4400D-01,  0.4600D-01,  0.4500D-01,   &
         0.4300D-01,  0.4200D-01,  0.4000D-01,  0.3800D-01,   &
         0.3800D-01,  0.3900D-01,  0.4000D-01,  0.4000D-01   &
         /
       data (OREF( 4, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2800D-01,  0.2300D-01,  0.2600D-01,  0.2400D-01,   &
         0.5000D-01,  0.4700D-01,  0.5000D-01,  0.3700D-01,   &
         0.2800D-01,  0.3200D-01,  0.3900D-01,  0.5100D-01   &
         /
       data (OREF( 4, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2800D-01,  0.2300D-01,  0.2600D-01,  0.2400D-01,   &
         0.5000D-01,  0.4700D-01,  0.5000D-01,  0.3700D-01,   &
         0.2800D-01,  0.3200D-01,  0.3900D-01,  0.5100D-01   &
         /
       data (OREF( 4, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4400D-01,  0.3900D-01,  0.4000D-01,  0.4800D-01,   &
         0.5000D-01,  0.4700D-01,  0.5000D-01,  0.5100D-01,   &
         0.4600D-01,  0.5800D-01,  0.6100D-01,  0.5900D-01   &
         /
       data (OREF( 4, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4500D-01,  0.3800D-01,  0.3500D-01,  0.4000D-01,   &
         0.5600D-01,  0.5600D-01,  0.5900D-01,  0.5300D-01,   &
         0.5400D-01,  0.6200D-01,  0.6200D-01,  0.5200D-01   &
         /
       data (OREF( 4, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3000D-01,  0.2900D-01,  0.3000D-01,   &
         0.3300D-01,  0.3600D-01,  0.4300D-01,  0.4700D-01,   &
         0.4900D-01,  0.5100D-01,  0.4400D-01,  0.3900D-01   &
         /
       data (OREF( 4, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3000D-01,  0.3000D-01,  0.2900D-01,   &
         0.3000D-01,  0.3100D-01,  0.3400D-01,  0.4400D-01,   &
         0.4500D-01,  0.4500D-01,  0.3800D-01,  0.3600D-01   &
         /
       data (OREF( 4, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3800D-01,  0.3400D-01,  0.3300D-01,  0.3200D-01,   &
         0.3300D-01,  0.3500D-01,  0.3600D-01,  0.4700D-01,   &
         0.4800D-01,  0.5000D-01,  0.4200D-01,  0.4100D-01   &
         /
       data (OREF( 4, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3500D-01,  0.3300D-01,  0.3100D-01,  0.3200D-01,   &
         0.3400D-01,  0.3700D-01,  0.3900D-01,  0.4800D-01,   &
         0.5100D-01,  0.5300D-01,  0.4300D-01,  0.3900D-01   &
         /
       data (OREF( 4, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2800D-01,  0.2700D-01,  0.3000D-01,  0.2900D-01,   &
         0.3100D-01,  0.3400D-01,  0.3700D-01,  0.4500D-01,   &
         0.4700D-01,  0.4600D-01,  0.3700D-01,  0.3200D-01   &
         /
       data (OREF( 4,10, mtmp), mtmp=1,12)   &
         /   &
         0.2900D-01,  0.2900D-01,  0.3300D-01,  0.3400D-01,   &
         0.3200D-01,  0.3200D-01,  0.3400D-01,  0.4100D-01,   &
         0.4200D-01,  0.3700D-01,  0.3200D-01,  0.3200D-01   &
         /
       data (OREF( 4,11, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.3700D-01,  0.4300D-01,  0.4900D-01,   &
         0.4700D-01,  0.4400D-01,  0.4200D-01,  0.4800D-01,   &
         0.4600D-01,  0.4300D-01,  0.3700D-01,  0.3700D-01   &
         /
       data (OREF( 4,12, mtmp), mtmp=1,12)   &
         /   &
         0.3300D-01,  0.3400D-01,  0.3900D-01,  0.4300D-01,   &
         0.4300D-01,  0.4300D-01,  0.4200D-01,  0.4900D-01,   &
         0.4600D-01,  0.4400D-01,  0.3600D-01,  0.3400D-01   &
         /
       data (OREF( 4,13, mtmp), mtmp=1,12)   &
         /   &
         0.2500D-01,  0.2600D-01,  0.2900D-01,  0.3400D-01,   &
         0.3500D-01,  0.3600D-01,  0.3700D-01,  0.4400D-01,   &
         0.4000D-01,  0.3700D-01,  0.2900D-01,  0.2700D-01   &
         /
       data (OREF( 4,14, mtmp), mtmp=1,12)   &
         /   &
         0.4400D-01,  0.4600D-01,  0.4600D-01,  0.4700D-01,   &
         0.4900D-01,  0.4300D-01,  0.4000D-01,  0.4400D-01,   &
         0.4200D-01,  0.3900D-01,  0.3200D-01,  0.3600D-01   &
         /
       data (OREF( 4,15, mtmp), mtmp=1,12)   &
         /   &
         0.5600D-01,  0.6900D-01,  0.6700D-01,  0.6100D-01,   &
         0.6000D-01,  0.5100D-01,  0.4500D-01,  0.4400D-01,   &
         0.4000D-01,  0.3900D-01,  0.4500D-01,  0.4800D-01   &
         /
       data (OREF( 4,16, mtmp), mtmp=1,12)   &
         /   &
         0.5200D-01,  0.7100D-01,  0.8800D-01,  0.7400D-01,   &
         0.6700D-01,  0.5500D-01,  0.4400D-01,  0.4000D-01,   &
         0.3600D-01,  0.4300D-01,  0.4500D-01,  0.4400D-01   &
         /
       data (OREF( 4,17, mtmp), mtmp=1,12)   &
         /   &
         0.5200D-01,  0.7400D-01,  0.9300D-01,  0.8300D-01,   &
         0.7200D-01,  0.6400D-01,  0.4400D-01,  0.3600D-01,   &
         0.3400D-01,  0.3800D-01,  0.4500D-01,  0.4400D-01   &
         /
       data (OREF( 4,18, mtmp), mtmp=1,12)   &
         /   &
         0.5200D-01,  0.7400D-01,  0.9300D-01,  0.8300D-01,   &
         0.7200D-01,  0.6400D-01,  0.4400D-01,  0.3600D-01,   &
         0.3400D-01,  0.3800D-01,  0.4500D-01,  0.4400D-01   &
         /
       data (OREF( 5, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4500D-01,  0.4000D-01,  0.4600D-01,  0.4000D-01,   &
         0.7800D-01,  0.7100D-01,  0.7700D-01,  0.5600D-01,   &
         0.3900D-01,  0.4100D-01,  0.5600D-01,  0.7800D-01   &
         /
       data (OREF( 5, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4500D-01,  0.4000D-01,  0.4600D-01,  0.4000D-01,   &
         0.7800D-01,  0.7100D-01,  0.7700D-01,  0.5600D-01,   &
         0.3900D-01,  0.4100D-01,  0.5600D-01,  0.7800D-01   &
         /
       data (OREF( 5, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6700D-01,  0.5900D-01,  0.6100D-01,  0.7600D-01,   &
         0.7800D-01,  0.7100D-01,  0.7700D-01,  0.8000D-01,   &
         0.7000D-01,  0.9200D-01,  0.9200D-01,  0.9000D-01   &
         /
       data (OREF( 5, 4, mtmp), mtmp=1,12)   &
         /   &
         0.6500D-01,  0.5300D-01,  0.4600D-01,  0.5500D-01,   &
         0.8600D-01,  0.8600D-01,  0.9200D-01,  0.8500D-01,   &
         0.8700D-01,  0.1010D+00,  0.9500D-01,  0.7900D-01   &
         /
       data (OREF( 5, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4300D-01,  0.3300D-01,  0.3100D-01,  0.3200D-01,   &
         0.3900D-01,  0.4800D-01,  0.6100D-01,  0.7200D-01,   &
         0.7800D-01,  0.8100D-01,  0.6400D-01,  0.5200D-01   &
         /
       data (OREF( 5, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3700D-01,  0.2800D-01,  0.2800D-01,  0.2700D-01,   &
         0.3000D-01,  0.3400D-01,  0.4100D-01,  0.6100D-01,   &
         0.6600D-01,  0.6500D-01,  0.5000D-01,  0.4400D-01   &
         /
       data (OREF( 5, 7, mtmp), mtmp=1,12)   &
         /   &
         0.4100D-01,  0.3200D-01,  0.3000D-01,  0.2900D-01,   &
         0.3200D-01,  0.3500D-01,  0.3900D-01,  0.5800D-01,   &
         0.6300D-01,  0.6500D-01,  0.5200D-01,  0.4700D-01   &
         /
       data (OREF( 5, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3300D-01,  0.2800D-01,  0.2600D-01,  0.2700D-01,   &
         0.3100D-01,  0.3500D-01,  0.4000D-01,  0.5600D-01,   &
         0.6200D-01,  0.6500D-01,  0.4800D-01,  0.4000D-01   &
         /
       data (OREF( 5, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2000D-01,  0.1900D-01,  0.2300D-01,  0.2200D-01,   &
         0.2500D-01,  0.3000D-01,  0.3500D-01,  0.5100D-01,   &
         0.5400D-01,  0.5000D-01,  0.3600D-01,  0.2800D-01   &
         /
       data (OREF( 5,10, mtmp), mtmp=1,12)   &
         /   &
         0.2100D-01,  0.2100D-01,  0.2800D-01,  0.3200D-01,   &
         0.2700D-01,  0.2800D-01,  0.3200D-01,  0.4300D-01,   &
         0.4500D-01,  0.3600D-01,  0.2800D-01,  0.2700D-01   &
         /
       data (OREF( 5,11, mtmp), mtmp=1,12)   &
         /   &
         0.3400D-01,  0.3400D-01,  0.4600D-01,  0.5800D-01,   &
         0.5700D-01,  0.5200D-01,  0.4900D-01,  0.5700D-01,   &
         0.5300D-01,  0.4700D-01,  0.3600D-01,  0.3500D-01   &
         /
       data (OREF( 5,12, mtmp), mtmp=1,12)   &
         /   &
         0.2900D-01,  0.3300D-01,  0.4400D-01,  0.5500D-01,   &
         0.5700D-01,  0.5500D-01,  0.5200D-01,  0.6200D-01,   &
         0.5600D-01,  0.5000D-01,  0.3500D-01,  0.3100D-01   &
         /
       data (OREF( 5,13, mtmp), mtmp=1,12)   &
         /   &
         0.2700D-01,  0.3200D-01,  0.4200D-01,  0.5000D-01,   &
         0.5100D-01,  0.4900D-01,  0.4500D-01,  0.5600D-01,   &
         0.4700D-01,  0.4100D-01,  0.2500D-01,  0.2500D-01   &
         /
       data (OREF( 5,14, mtmp), mtmp=1,12)   &
         /   &
         0.7100D-01,  0.8300D-01,  0.8500D-01,  0.8500D-01,   &
         0.8300D-01,  0.6600D-01,  0.5500D-01,  0.6200D-01,   &
         0.5500D-01,  0.4800D-01,  0.3500D-01,  0.4800D-01   &
         /
       data (OREF( 5,15, mtmp), mtmp=1,12)   &
         /   &
         0.1020D+00,  0.1360D+00,  0.1360D+00,  0.1230D+00,   &
         0.1130D+00,  0.8800D-01,  0.7100D-01,  0.6800D-01,   &
         0.5700D-01,  0.5400D-01,  0.6600D-01,  0.7600D-01   &
         /
       data (OREF( 5,16, mtmp), mtmp=1,12)   &
         /   &
         0.9400D-01,  0.1490D+00,  0.1880D+00,  0.1600D+00,   &
         0.1360D+00,  0.1020D+00,  0.7400D-01,  0.6400D-01,   &
         0.5300D-01,  0.6500D-01,  0.7300D-01,  0.6900D-01   &
         /
       data (OREF( 5,17, mtmp), mtmp=1,12)   &
         /   &
         0.9400D-01,  0.1560D+00,  0.2100D+00,  0.1930D+00,   &
         0.1640D+00,  0.1310D+00,  0.8100D-01,  0.5600D-01,   &
         0.4800D-01,  0.5600D-01,  0.7300D-01,  0.6900D-01   &
         /
       data (OREF( 5,18, mtmp), mtmp=1,12)   &
         /   &
         0.9400D-01,  0.1560D+00,  0.2100D+00,  0.1930D+00,   &
         0.1640D+00,  0.1310D+00,  0.8100D-01,  0.5600D-01,   &
         0.4800D-01,  0.5600D-01,  0.7300D-01,  0.6900D-01   &
         /
       data (OREF( 6, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1360D+00,  0.1420D+00,  0.1480D+00,  0.1350D+00,   &
         0.1460D+00,  0.1310D+00,  0.1410D+00,  0.1290D+00,   &
         0.1100D+00,  0.9600D-01,  0.1180D+00,  0.1400D+00   &
         /
       data (OREF( 6, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1360D+00,  0.1420D+00,  0.1480D+00,  0.1350D+00,   &
         0.1460D+00,  0.1310D+00,  0.1410D+00,  0.1290D+00,   &
         0.1100D+00,  0.9600D-01,  0.1180D+00,  0.1400D+00   &
         /
       data (OREF( 6, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1340D+00,  0.1280D+00,  0.1320D+00,  0.1490D+00,   &
         0.1460D+00,  0.1310D+00,  0.1410D+00,  0.1500D+00,   &
         0.1330D+00,  0.1570D+00,  0.1420D+00,  0.1460D+00   &
         /
       data (OREF( 6, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1230D+00,  0.1080D+00,  0.9800D-01,  0.1080D+00,   &
         0.1430D+00,  0.1450D+00,  0.1520D+00,  0.1560D+00,   &
         0.1640D+00,  0.1780D+00,  0.1510D+00,  0.1380D+00   &
         /
       data (OREF( 6, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8700D-01,  0.6900D-01,  0.6500D-01,  0.6700D-01,   &
         0.8000D-01,  0.9600D-01,  0.1160D+00,  0.1400D+00,   &
         0.1510D+00,  0.1530D+00,  0.1210D+00,  0.1010D+00   &
         /
       data (OREF( 6, 6, mtmp), mtmp=1,12)   &
         /   &
         0.6700D-01,  0.5200D-01,  0.5000D-01,  0.5100D-01,   &
         0.5900D-01,  0.7000D-01,  0.8600D-01,  0.1130D+00,   &
         0.1230D+00,  0.1200D+00,  0.1000D+00,  0.8000D-01   &
         /
       data (OREF( 6, 7, mtmp), mtmp=1,12)   &
         /   &
         0.5700D-01,  0.4500D-01,  0.4300D-01,  0.4300D-01,   &
         0.4600D-01,  0.5000D-01,  0.5700D-01,  0.8000D-01,   &
         0.9300D-01,  0.9400D-01,  0.8500D-01,  0.6900D-01   &
         /
       data (OREF( 6, 8, mtmp), mtmp=1,12)   &
         /   &
         0.4200D-01,  0.3600D-01,  0.3400D-01,  0.3400D-01,   &
         0.3700D-01,  0.4100D-01,  0.4500D-01,  0.6300D-01,   &
         0.7200D-01,  0.7300D-01,  0.6000D-01,  0.5000D-01   &
         /
       data (OREF( 6, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2700D-01,  0.2600D-01,  0.3000D-01,  0.3000D-01,   &
         0.3200D-01,  0.3700D-01,  0.4300D-01,  0.5600D-01,   &
         0.6000D-01,  0.5400D-01,  0.4300D-01,  0.3400D-01   &
         /
       data (OREF( 6,10, mtmp), mtmp=1,12)   &
         /   &
         0.2600D-01,  0.2700D-01,  0.3400D-01,  0.3900D-01,   &
         0.3600D-01,  0.3900D-01,  0.4500D-01,  0.5200D-01,   &
         0.5200D-01,  0.4200D-01,  0.3400D-01,  0.3200D-01   &
         /
       data (OREF( 6,11, mtmp), mtmp=1,12)   &
         /   &
         0.3600D-01,  0.3700D-01,  0.5000D-01,  0.6800D-01,   &
         0.7200D-01,  0.7100D-01,  0.7000D-01,  0.6900D-01,   &
         0.6400D-01,  0.5300D-01,  0.4100D-01,  0.3800D-01   &
         /
       data (OREF( 6,12, mtmp), mtmp=1,12)   &
         /   &
         0.3900D-01,  0.4600D-01,  0.6600D-01,  0.8800D-01,   &
         0.9600D-01,  0.9000D-01,  0.8000D-01,  0.8200D-01,   &
         0.7200D-01,  0.6000D-01,  0.4100D-01,  0.3800D-01   &
         /
       data (OREF( 6,13, mtmp), mtmp=1,12)   &
         /   &
         0.7500D-01,  0.9200D-01,  0.1120D+00,  0.1210D+00,   &
         0.1190D+00,  0.1010D+00,  0.8200D-01,  0.8800D-01,   &
         0.7500D-01,  0.6300D-01,  0.4300D-01,  0.5500D-01   &
         /
       data (OREF( 6,14, mtmp), mtmp=1,12)   &
         /   &
         0.1530D+00,  0.1900D+00,  0.1970D+00,  0.1910D+00,   &
         0.1750D+00,  0.1360D+00,  0.1040D+00,  0.1080D+00,   &
         0.9400D-01,  0.8400D-01,  0.6900D-01,  0.1000D+00   &
         /
       data (OREF( 6,15, mtmp), mtmp=1,12)   &
         /   &
         0.2120D+00,  0.2770D+00,  0.2920D+00,  0.2680D+00,   &
         0.2370D+00,  0.1840D+00,  0.1470D+00,  0.1380D+00,   &
         0.1150D+00,  0.1090D+00,  0.1250D+00,  0.1500D+00   &
         /
       data (OREF( 6,16, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+00,  0.3180D+00,  0.3890D+00,  0.3510D+00,   &
         0.2920D+00,  0.2180D+00,  0.1640D+00,  0.1430D+00,   &
         0.1180D+00,  0.1290D+00,  0.1500D+00,  0.1420D+00   &
         /
       data (OREF( 6,17, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+00,  0.3360D+00,  0.4500D+00,  0.4370D+00,   &
         0.3790D+00,  0.2850D+00,  0.1890D+00,  0.1340D+00,   &
         0.1150D+00,  0.1220D+00,  0.1500D+00,  0.1420D+00   &
         /
       data (OREF( 6,18, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+00,  0.3360D+00,  0.4500D+00,  0.4370D+00,   &
         0.3790D+00,  0.2850D+00,  0.1890D+00,  0.1340D+00,   &
         0.1150D+00,  0.1220D+00,  0.1500D+00,  0.1420D+00   &
         /
       data (OREF( 7, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3230D+00,  0.3390D+00,  0.3400D+00,  0.3110D+00,   &
         0.2810D+00,  0.2560D+00,  0.2740D+00,  0.2920D+00,   &
         0.2690D+00,  0.2430D+00,  0.2680D+00,  0.2970D+00   &
         /
       data (OREF( 7, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3230D+00,  0.3390D+00,  0.3400D+00,  0.3110D+00,   &
         0.2810D+00,  0.2560D+00,  0.2740D+00,  0.2920D+00,   &
         0.2690D+00,  0.2430D+00,  0.2680D+00,  0.2970D+00   &
         /
       data (OREF( 7, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2820D+00,  0.2730D+00,  0.2730D+00,  0.2900D+00,   &
         0.2810D+00,  0.2560D+00,  0.2740D+00,  0.2960D+00,   &
         0.2800D+00,  0.3150D+00,  0.2730D+00,  0.2850D+00   &
         /
       data (OREF( 7, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2520D+00,  0.2290D+00,  0.2140D+00,  0.2250D+00,   &
         0.2570D+00,  0.2660D+00,  0.2790D+00,  0.3060D+00,   &
         0.3270D+00,  0.3470D+00,  0.2850D+00,  0.2700D+00   &
         /
       data (OREF( 7, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1880D+00,  0.1610D+00,  0.1540D+00,  0.1590D+00,   &
         0.1820D+00,  0.2060D+00,  0.2370D+00,  0.2770D+00,   &
         0.2970D+00,  0.2980D+00,  0.2480D+00,  0.2130D+00   &
         /
       data (OREF( 7, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1370D+00,  0.1150D+00,  0.1120D+00,  0.1170D+00,   &
         0.1320D+00,  0.1570D+00,  0.1860D+00,  0.2110D+00,   &
         0.2320D+00,  0.2250D+00,  0.2020D+00,  0.1590D+00   &
         /
       data (OREF( 7, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9700D-01,  0.8200D-01,  0.7900D-01,  0.8200D-01,   &
         0.8600D-01,  0.8900D-01,  0.1020D+00,  0.1180D+00,   &
         0.1460D+00,  0.1440D+00,  0.1470D+00,  0.1160D+00   &
         /
       data (OREF( 7, 8, mtmp), mtmp=1,12)   &
         /   &
         0.6600D-01,  0.6000D-01,  0.5800D-01,  0.5800D-01,   &
         0.5800D-01,  0.5900D-01,  0.6200D-01,  0.7300D-01,   &
         0.8500D-01,  0.8400D-01,  0.8500D-01,  0.7300D-01   &
         /
       data (OREF( 7, 9, mtmp), mtmp=1,12)   &
         /   &
         0.5300D-01,  0.5200D-01,  0.5500D-01,  0.5500D-01,   &
         0.5600D-01,  0.5800D-01,  0.6300D-01,  0.6600D-01,   &
         0.7000D-01,  0.6200D-01,  0.6200D-01,  0.5700D-01   &
         /
       data (OREF( 7,10, mtmp), mtmp=1,12)   &
         /   &
         0.4700D-01,  0.4800D-01,  0.5500D-01,  0.6200D-01,   &
         0.6200D-01,  0.6700D-01,  0.7600D-01,  0.7100D-01,   &
         0.6900D-01,  0.5900D-01,  0.5600D-01,  0.5200D-01   &
         /
       data (OREF( 7,11, mtmp), mtmp=1,12)   &
         /   &
         0.4800D-01,  0.5100D-01,  0.6300D-01,  0.8600D-01,   &
         0.1000D+00,  0.1060D+00,  0.1090D+00,  0.9000D-01,   &
         0.8500D-01,  0.6500D-01,  0.5700D-01,  0.5100D-01   &
         /
       data (OREF( 7,12, mtmp), mtmp=1,12)   &
         /   &
         0.7500D-01,  0.8700D-01,  0.1190D+00,  0.1560D+00,   &
         0.1710D+00,  0.1590D+00,  0.1400D+00,  0.1200D+00,   &
         0.1050D+00,  0.8600D-01,  0.7000D-01,  0.6800D-01   &
         /
       data (OREF( 7,13, mtmp), mtmp=1,12)   &
         /   &
         0.1950D+00,  0.2320D+00,  0.2650D+00,  0.2710D+00,   &
         0.2610D+00,  0.2160D+00,  0.1700D+00,  0.1570D+00,   &
         0.1370D+00,  0.1170D+00,  0.1070D+00,  0.1430D+00   &
         /
       data (OREF( 7,14, mtmp), mtmp=1,12)   &
         /   &
         0.3310D+00,  0.4100D+00,  0.4240D+00,  0.4060D+00,   &
         0.3670D+00,  0.2950D+00,  0.2290D+00,  0.2100D+00,   &
         0.1840D+00,  0.1720D+00,  0.1740D+00,  0.2360D+00   &
         /
       data (OREF( 7,15, mtmp), mtmp=1,12)   &
         /   &
         0.4310D+00,  0.5260D+00,  0.5650D+00,  0.5350D+00,   &
         0.4730D+00,  0.3850D+00,  0.3200D+00,  0.2910D+00,   &
         0.2510D+00,  0.2410D+00,  0.2660D+00,  0.3200D+00   &
         /
       data (OREF( 7,16, mtmp), mtmp=1,12)   &
         /   &
         0.4160D+00,  0.6020D+00,  0.7010D+00,  0.6650D+00,   &
         0.5670D+00,  0.4530D+00,  0.3680D+00,  0.3250D+00,   &
         0.2800D+00,  0.2810D+00,  0.3260D+00,  0.3150D+00   &
         /
       data (OREF( 7,17, mtmp), mtmp=1,12)   &
         /   &
         0.4160D+00,  0.6370D+00,  0.8090D+00,  0.8050D+00,   &
         0.7190D+00,  0.5600D+00,  0.4210D+00,  0.3350D+00,   &
         0.2970D+00,  0.2900D+00,  0.3260D+00,  0.3150D+00   &
         /
       data (OREF( 7,18, mtmp), mtmp=1,12)   &
         /   &
         0.4160D+00,  0.6370D+00,  0.8090D+00,  0.8050D+00,   &
         0.7190D+00,  0.5600D+00,  0.4210D+00,  0.3350D+00,   &
         0.2970D+00,  0.2900D+00,  0.3260D+00,  0.3150D+00   &
         /
       data (OREF( 8, 1, mtmp), mtmp=1,12)   &
         /   &
         0.6090D+00,  0.5980D+00,  0.5850D+00,  0.5270D+00,   &
         0.5140D+00,  0.4890D+00,  0.5200D+00,  0.5840D+00,   &
         0.5380D+00,  0.5560D+00,  0.5690D+00,  0.6500D+00   &
         /
       data (OREF( 8, 2, mtmp), mtmp=1,12)   &
         /   &
         0.6090D+00,  0.5980D+00,  0.5850D+00,  0.5270D+00,   &
         0.5140D+00,  0.4890D+00,  0.5200D+00,  0.5840D+00,   &
         0.5380D+00,  0.5560D+00,  0.5690D+00,  0.6500D+00   &
         /
       data (OREF( 8, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5650D+00,  0.5240D+00,  0.5030D+00,  0.5190D+00,   &
         0.5140D+00,  0.4890D+00,  0.5200D+00,  0.5700D+00,   &
         0.5830D+00,  0.6800D+00,  0.6080D+00,  0.6170D+00   &
         /
       data (OREF( 8, 4, mtmp), mtmp=1,12)   &
         /   &
         0.5020D+00,  0.4490D+00,  0.4210D+00,  0.4360D+00,   &
         0.4720D+00,  0.5060D+00,  0.5440D+00,  0.5920D+00,   &
         0.6450D+00,  0.7050D+00,  0.5970D+00,  0.5480D+00   &
         /
       data (OREF( 8, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3760D+00,  0.3320D+00,  0.3240D+00,  0.3360D+00,   &
         0.3760D+00,  0.4110D+00,  0.4680D+00,  0.5130D+00,   &
         0.5520D+00,  0.5600D+00,  0.4870D+00,  0.4200D+00   &
         /
       data (OREF( 8, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2620D+00,  0.2310D+00,  0.2270D+00,  0.2390D+00,   &
         0.2670D+00,  0.3090D+00,  0.3540D+00,  0.3670D+00,   &
         0.4040D+00,  0.3940D+00,  0.3680D+00,  0.2970D+00   &
         /
       data (OREF( 8, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1730D+00,  0.1520D+00,  0.1470D+00,  0.1530D+00,   &
         0.1600D+00,  0.1640D+00,  0.1850D+00,  0.1850D+00,   &
         0.2290D+00,  0.2290D+00,  0.2440D+00,  0.2000D+00   &
         /
       data (OREF( 8, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1100D+00,  0.1030D+00,  0.1010D+00,  0.1000D+00,   &
         0.9800D-01,  0.9600D-01,  0.9900D-01,  0.9400D-01,   &
         0.1150D+00,  0.1150D+00,  0.1320D+00,  0.1180D+00   &
         /
       data (OREF( 8, 9, mtmp), mtmp=1,12)   &
         /   &
         0.9200D-01,  0.9200D-01,  0.9400D-01,  0.9600D-01,   &
         0.9500D-01,  0.9600D-01,  0.1010D+00,  0.8900D-01,   &
         0.9600D-01,  0.8600D-01,  0.1000D+00,  0.9500D-01   &
         /
       data (OREF( 8,10, mtmp), mtmp=1,12)   &
         /   &
         0.8200D-01,  0.8400D-01,  0.9200D-01,  0.1010D+00,   &
         0.1030D+00,  0.1110D+00,  0.1220D+00,  0.1040D+00,   &
         0.1010D+00,  0.8600D-01,  0.9300D-01,  0.8800D-01   &
         /
       data (OREF( 8,11, mtmp), mtmp=1,12)   &
         /   &
         0.8100D-01,  0.8600D-01,  0.1010D+00,  0.1290D+00,   &
         0.1500D+00,  0.1610D+00,  0.1670D+00,  0.1310D+00,   &
         0.1230D+00,  0.9300D-01,  0.9500D-01,  0.8500D-01   &
         /
       data (OREF( 8,12, mtmp), mtmp=1,12)   &
         /   &
         0.1590D+00,  0.1770D+00,  0.2210D+00,  0.2730D+00,   &
         0.2940D+00,  0.2750D+00,  0.2460D+00,  0.1980D+00,   &
         0.1750D+00,  0.1430D+00,  0.1450D+00,  0.1460D+00   &
         /
       data (OREF( 8,13, mtmp), mtmp=1,12)   &
         /   &
         0.4130D+00,  0.4720D+00,  0.5170D+00,  0.5140D+00,   &
         0.4950D+00,  0.4190D+00,  0.3440D+00,  0.2860D+00,   &
         0.2540D+00,  0.2220D+00,  0.2530D+00,  0.3200D+00   &
         /
       data (OREF( 8,14, mtmp), mtmp=1,12)   &
         /   &
         0.6630D+00,  0.7880D+00,  0.8130D+00,  0.7780D+00,   &
         0.7130D+00,  0.6050D+00,  0.4950D+00,  0.4040D+00,   &
         0.3630D+00,  0.3480D+00,  0.4130D+00,  0.5170D+00   &
         /
       data (OREF( 8,15, mtmp), mtmp=1,12)   &
         /   &
         0.8150D+00,  0.9110D+00,  0.9780D+00,  0.9530D+00,   &
         0.8700D+00,  0.7590D+00,  0.6630D+00,  0.5740D+00,   &
         0.5170D+00,  0.5030D+00,  0.5610D+00,  0.6640D+00   &
         /
       data (OREF( 8,16, mtmp), mtmp=1,12)   &
         /   &
         0.7960D+00,  0.1004D+01,  0.1104D+01,  0.1086D+01,   &
         0.9860D+00,  0.8690D+00,  0.7600D+00,  0.6750D+00,   &
         0.6140D+00,  0.5910D+00,  0.6700D+00,  0.6670D+00   &
         /
       data (OREF( 8,17, mtmp), mtmp=1,12)   &
         /   &
         0.7960D+00,  0.1065D+01,  0.1229D+01,  0.1230D+01,   &
         0.1138D+01,  0.9780D+00,  0.8410D+00,  0.7500D+00,   &
         0.6930D+00,  0.6430D+00,  0.6700D+00,  0.6670D+00   &
         /
       data (OREF( 8,18, mtmp), mtmp=1,12)   &
         /   &
         0.7960D+00,  0.1065D+01,  0.1229D+01,  0.1230D+01,   &
         0.1138D+01,  0.9780D+00,  0.8410D+00,  0.7500D+00,   &
         0.6930D+00,  0.6430D+00,  0.6700D+00,  0.6670D+00   &
         /
       data (OREF( 9, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1048D+01,  0.9660D+00,  0.9220D+00,  0.8200D+00,   &
         0.9000D+00,  0.8910D+00,  0.9430D+00,  0.1026D+01,   &
         0.9370D+00,  0.1067D+01,  0.1096D+01,  0.1278D+01   &
         /
       data (OREF( 9, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1048D+01,  0.9660D+00,  0.9220D+00,  0.8200D+00,   &
         0.9000D+00,  0.8910D+00,  0.9430D+00,  0.1026D+01,   &
         0.9370D+00,  0.1067D+01,  0.1096D+01,  0.1278D+01   &
         /
       data (OREF( 9, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1053D+01,  0.9440D+00,  0.8780D+00,  0.8900D+00,   &
         0.9000D+00,  0.8910D+00,  0.9430D+00,  0.1024D+01,   &
         0.1092D+01,  0.1315D+01,  0.1239D+01,  0.1225D+01   &
         /
       data (OREF( 9, 4, mtmp), mtmp=1,12)   &
         /   &
         0.9430D+00,  0.8330D+00,  0.7810D+00,  0.8050D+00,   &
         0.8510D+00,  0.9330D+00,  0.1020D+01,  0.1081D+01,   &
         0.1178D+01,  0.1319D+01,  0.1172D+01,  0.1048D+01   &
         /
       data (OREF( 9, 5, mtmp), mtmp=1,12)   &
         /   &
         0.7090D+00,  0.6390D+00,  0.6340D+00,  0.6600D+00,   &
         0.7270D+00,  0.7780D+00,  0.8800D+00,  0.9090D+00,   &
         0.9770D+00,  0.9970D+00,  0.9020D+00,  0.7850D+00   &
         /
       data (OREF( 9, 6, mtmp), mtmp=1,12)   &
         /   &
         0.4870D+00,  0.4420D+00,  0.4390D+00,  0.4620D+00,   &
         0.5110D+00,  0.5790D+00,  0.6460D+00,  0.6360D+00,   &
         0.6920D+00,  0.6770D+00,  0.6430D+00,  0.5370D+00   &
         /
       data (OREF( 9, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3200D+00,  0.2870D+00,  0.2800D+00,  0.2890D+00,   &
         0.3020D+00,  0.3140D+00,  0.3440D+00,  0.3250D+00,   &
         0.3870D+00,  0.3900D+00,  0.4100D+00,  0.3570D+00   &
         /
       data (OREF( 9, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1970D+00,  0.1850D+00,  0.1810D+00,  0.1800D+00,   &
         0.1800D+00,  0.1790D+00,  0.1860D+00,  0.1610D+00,   &
         0.1970D+00,  0.2040D+00,  0.2270D+00,  0.2100D+00   &
         /
       data (OREF( 9, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1630D+00,  0.1610D+00,  0.1670D+00,  0.1690D+00,   &
         0.1690D+00,  0.1720D+00,  0.1800D+00,  0.1600D+00,   &
         0.1730D+00,  0.1580D+00,  0.1790D+00,  0.1710D+00   &
         /
       data (OREF( 9,10, mtmp), mtmp=1,12)   &
         /   &
         0.1490D+00,  0.1510D+00,  0.1660D+00,  0.1790D+00,   &
         0.1810D+00,  0.1900D+00,  0.2040D+00,  0.1840D+00,   &
         0.1820D+00,  0.1520D+00,  0.1670D+00,  0.1590D+00   &
         /
       data (OREF( 9,11, mtmp), mtmp=1,12)   &
         /   &
         0.1590D+00,  0.1660D+00,  0.1900D+00,  0.2280D+00,   &
         0.2520D+00,  0.2610D+00,  0.2670D+00,  0.2290D+00,   &
         0.2130D+00,  0.1680D+00,  0.1800D+00,  0.1660D+00   &
         /
       data (OREF( 9,12, mtmp), mtmp=1,12)   &
         /   &
         0.3270D+00,  0.3500D+00,  0.4040D+00,  0.4690D+00,   &
         0.4910D+00,  0.4670D+00,  0.4290D+00,  0.3530D+00,   &
         0.3180D+00,  0.2700D+00,  0.3040D+00,  0.3080D+00   &
         /
       data (OREF( 9,13, mtmp), mtmp=1,12)   &
         /   &
         0.7630D+00,  0.8430D+00,  0.8940D+00,  0.8780D+00,   &
         0.8450D+00,  0.7410D+00,  0.6350D+00,  0.5140D+00,   &
         0.4650D+00,  0.4180D+00,  0.5230D+00,  0.6280D+00   &
         /
       data (OREF( 9,14, mtmp), mtmp=1,12)   &
         /   &
         0.1183D+01,  0.1354D+01,  0.1389D+01,  0.1331D+01,   &
         0.1239D+01,  0.1098D+01,  0.9390D+00,  0.7330D+00,   &
         0.6740D+00,  0.6580D+00,  0.8330D+00,  0.9820D+00   &
         /
       data (OREF( 9,15, mtmp), mtmp=1,12)   &
         /   &
         0.1387D+01,  0.1459D+01,  0.1557D+01,  0.1542D+01,   &
         0.1446D+01,  0.1329D+01,  0.1203D+01,  0.1021D+01,   &
         0.9510D+00,  0.9360D+00,  0.1044D+01,  0.1212D+01   &
         /
       data (OREF( 9,16, mtmp), mtmp=1,12)   &
         /   &
         0.1359D+01,  0.1538D+01,  0.1622D+01,  0.1634D+01,   &
         0.1566D+01,  0.1476D+01,  0.1353D+01,  0.1211D+01,   &
         0.1145D+01,  0.1090D+01,  0.1203D+01,  0.1219D+01   &
         /
       data (OREF( 9,17, mtmp), mtmp=1,12)   &
         /   &
         0.1359D+01,  0.1633D+01,  0.1724D+01,  0.1725D+01,   &
         0.1642D+01,  0.1540D+01,  0.1442D+01,  0.1383D+01,   &
         0.1312D+01,  0.1194D+01,  0.1203D+01,  0.1219D+01   &
         /
       data (OREF( 9,18, mtmp), mtmp=1,12)   &
         /   &
         0.1359D+01,  0.1633D+01,  0.1724D+01,  0.1725D+01,   &
         0.1642D+01,  0.1540D+01,  0.1442D+01,  0.1383D+01,   &
         0.1312D+01,  0.1194D+01,  0.1203D+01,  0.1219D+01   &
         /
       data (OREF(10, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1822D+01,  0.1689D+01,  0.1574D+01,  0.1435D+01,   &
         0.1564D+01,  0.1589D+01,  0.1657D+01,  0.1532D+01,   &
         0.1429D+01,  0.1652D+01,  0.1926D+01,  0.2177D+01   &
         /
       data (OREF(10, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1822D+01,  0.1689D+01,  0.1574D+01,  0.1435D+01,   &
         0.1564D+01,  0.1589D+01,  0.1657D+01,  0.1532D+01,   &
         0.1429D+01,  0.1652D+01,  0.1926D+01,  0.2177D+01   &
         /
       data (OREF(10, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1852D+01,  0.1698D+01,  0.1582D+01,  0.1556D+01,   &
         0.1564D+01,  0.1589D+01,  0.1657D+01,  0.1688D+01,   &
         0.1780D+01,  0.2110D+01,  0.2151D+01,  0.2110D+01   &
         /
       data (OREF(10, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1694D+01,  0.1534D+01,  0.1464D+01,  0.1493D+01,   &
         0.1523D+01,  0.1648D+01,  0.1781D+01,  0.1864D+01,   &
         0.1945D+01,  0.2143D+01,  0.2022D+01,  0.1845D+01   &
         /
       data (OREF(10, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1333D+01,  0.1229D+01,  0.1229D+01,  0.1281D+01,   &
         0.1396D+01,  0.1486D+01,  0.1627D+01,  0.1625D+01,   &
         0.1683D+01,  0.1702D+01,  0.1609D+01,  0.1446D+01   &
         /
       data (OREF(10, 6, mtmp), mtmp=1,12)   &
         /   &
         0.9370D+00,  0.8700D+00,  0.8720D+00,  0.9190D+00,   &
         0.1010D+01,  0.1124D+01,  0.1222D+01,  0.1224D+01,   &
         0.1278D+01,  0.1238D+01,  0.1170D+01,  0.1011D+01   &
         /
       data (OREF(10, 7, mtmp), mtmp=1,12)   &
         /   &
         0.6390D+00,  0.5830D+00,  0.5730D+00,  0.5960D+00,   &
         0.6300D+00,  0.6670D+00,  0.7190D+00,  0.7450D+00,   &
         0.8150D+00,  0.8000D+00,  0.7740D+00,  0.6990D+00   &
         /
       data (OREF(10, 8, mtmp), mtmp=1,12)   &
         /   &
         0.4180D+00,  0.3930D+00,  0.3860D+00,  0.3890D+00,   &
         0.3980D+00,  0.4110D+00,  0.4270D+00,  0.4490D+00,   &
         0.4960D+00,  0.5040D+00,  0.4790D+00,  0.4490D+00   &
         /
       data (OREF(10, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3460D+00,  0.3400D+00,  0.3530D+00,  0.3610D+00,   &
         0.3680D+00,  0.3830D+00,  0.3960D+00,  0.4360D+00,   &
         0.4490D+00,  0.4140D+00,  0.3940D+00,  0.3710D+00   &
         /
       data (OREF(10,10, mtmp), mtmp=1,12)   &
         /   &
         0.3270D+00,  0.3270D+00,  0.3560D+00,  0.3850D+00,   &
         0.3930D+00,  0.4100D+00,  0.4310D+00,  0.4710D+00,   &
         0.4610D+00,  0.3970D+00,  0.3690D+00,  0.3530D+00   &
         /
       data (OREF(10,11, mtmp), mtmp=1,12)   &
         /   &
         0.3680D+00,  0.3710D+00,  0.4120D+00,  0.4760D+00,   &
         0.5100D+00,  0.5200D+00,  0.5220D+00,  0.5400D+00,   &
         0.5100D+00,  0.4350D+00,  0.4030D+00,  0.3830D+00   &
         /
       data (OREF(10,12, mtmp), mtmp=1,12)   &
         /   &
         0.6500D+00,  0.6670D+00,  0.7280D+00,  0.8090D+00,   &
         0.8330D+00,  0.7990D+00,  0.7470D+00,  0.7070D+00,   &
         0.6560D+00,  0.5920D+00,  0.6040D+00,  0.6230D+00   &
         /
       data (OREF(10,13, mtmp), mtmp=1,12)   &
         /   &
         0.1247D+01,  0.1340D+01,  0.1386D+01,  0.1350D+01,   &
         0.1300D+01,  0.1168D+01,  0.1032D+01,  0.9250D+00,   &
         0.8600D+00,  0.8140D+00,  0.9270D+00,  0.1072D+01   &
         /
       data (OREF(10,14, mtmp), mtmp=1,12)   &
         /   &
         0.1795D+01,  0.2023D+01,  0.2046D+01,  0.1951D+01,   &
         0.1819D+01,  0.1637D+01,  0.1440D+01,  0.1220D+01,   &
         0.1153D+01,  0.1159D+01,  0.1350D+01,  0.1533D+01   &
         /
       data (OREF(10,15, mtmp), mtmp=1,12)   &
         /   &
         0.2030D+01,  0.2158D+01,  0.2301D+01,  0.2246D+01,   &
         0.2099D+01,  0.1937D+01,  0.1772D+01,  0.1569D+01,   &
         0.1499D+01,  0.1509D+01,  0.1583D+01,  0.1795D+01   &
         /
       data (OREF(10,16, mtmp), mtmp=1,12)   &
         /   &
         0.1972D+01,  0.2195D+01,  0.2368D+01,  0.2377D+01,   &
         0.2266D+01,  0.2113D+01,  0.1935D+01,  0.1772D+01,   &
         0.1714D+01,  0.1650D+01,  0.1753D+01,  0.1780D+01   &
         /
       data (OREF(10,17, mtmp), mtmp=1,12)   &
         /   &
         0.1972D+01,  0.2329D+01,  0.2432D+01,  0.2456D+01,   &
         0.2303D+01,  0.2145D+01,  0.1990D+01,  0.1963D+01,   &
         0.1875D+01,  0.1706D+01,  0.1753D+01,  0.1780D+01   &
         /
       data (OREF(10,18, mtmp), mtmp=1,12)   &
         /   &
         0.1972D+01,  0.2329D+01,  0.2432D+01,  0.2456D+01,   &
         0.2303D+01,  0.2145D+01,  0.1990D+01,  0.1963D+01,   &
         0.1875D+01,  0.1706D+01,  0.1753D+01,  0.1780D+01   &
         /
       data (OREF(11, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2954D+01,  0.2824D+01,  0.2609D+01,  0.2458D+01,   &
         0.2547D+01,  0.2620D+01,  0.2691D+01,  0.2055D+01,   &
         0.1986D+01,  0.2244D+01,  0.3059D+01,  0.3285D+01   &
         /
       data (OREF(11, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2954D+01,  0.2824D+01,  0.2609D+01,  0.2458D+01,   &
         0.2547D+01,  0.2620D+01,  0.2691D+01,  0.2055D+01,   &
         0.1986D+01,  0.2244D+01,  0.3059D+01,  0.3285D+01   &
         /
       data (OREF(11, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2970D+01,  0.2828D+01,  0.2679D+01,  0.2571D+01,   &
         0.2547D+01,  0.2620D+01,  0.2691D+01,  0.2556D+01,   &
         0.2612D+01,  0.3000D+01,  0.3300D+01,  0.3227D+01   &
         /
       data (OREF(11, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2795D+01,  0.2616D+01,  0.2546D+01,  0.2573D+01,   &
         0.2546D+01,  0.2688D+01,  0.2843D+01,  0.2955D+01,   &
         0.2937D+01,  0.3140D+01,  0.3133D+01,  0.2955D+01   &
         /
       data (OREF(11, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2335D+01,  0.2192D+01,  0.2197D+01,  0.2284D+01,   &
         0.2467D+01,  0.2628D+01,  0.2779D+01,  0.2734D+01,   &
         0.2723D+01,  0.2720D+01,  0.2661D+01,  0.2476D+01   &
         /
       data (OREF(11, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1715D+01,  0.1617D+01,  0.1629D+01,  0.1716D+01,   &
         0.1873D+01,  0.2056D+01,  0.2192D+01,  0.2267D+01,   &
         0.2281D+01,  0.2190D+01,  0.2052D+01,  0.1823D+01   &
         /
       data (OREF(11, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1236D+01,  0.1142D+01,  0.1132D+01,  0.1181D+01,   &
         0.1261D+01,  0.1349D+01,  0.1437D+01,  0.1624D+01,   &
         0.1678D+01,  0.1608D+01,  0.1454D+01,  0.1338D+01   &
         /
       data (OREF(11, 8, mtmp), mtmp=1,12)   &
         /   &
         0.8750D+00,  0.8230D+00,  0.8120D+00,  0.8270D+00,   &
         0.8590D+00,  0.9070D+00,  0.9420D+00,  0.1137D+01,   &
         0.1182D+01,  0.1171D+01,  0.1004D+01,  0.9460D+00   &
         /
       data (OREF(11, 9, mtmp), mtmp=1,12)   &
         /   &
         0.7360D+00,  0.7210D+00,  0.7480D+00,  0.7710D+00,   &
         0.7950D+00,  0.8370D+00,  0.8610D+00,  0.1079D+01,   &
         0.1080D+01,  0.1000D+01,  0.8500D+00,  0.7970D+00   &
         /
       data (OREF(11,10, mtmp), mtmp=1,12)   &
         /   &
         0.7080D+00,  0.7020D+00,  0.7580D+00,  0.8220D+00,   &
         0.8480D+00,  0.8850D+00,  0.9190D+00,  0.1130D+01,   &
         0.1095D+01,  0.9710D+00,  0.8030D+00,  0.7680D+00   &
         /
       data (OREF(11,11, mtmp), mtmp=1,12)   &
         /   &
         0.8080D+00,  0.7920D+00,  0.8610D+00,  0.9790D+00,   &
         0.1039D+01,  0.1057D+01,  0.1050D+01,  0.1224D+01,   &
         0.1170D+01,  0.1048D+01,  0.8680D+00,  0.8410D+00   &
         /
       data (OREF(11,12, mtmp), mtmp=1,12)   &
         /   &
         0.1210D+01,  0.1202D+01,  0.1260D+01,  0.1364D+01,   &
         0.1391D+01,  0.1343D+01,  0.1267D+01,  0.1381D+01,   &
         0.1309D+01,  0.1233D+01,  0.1120D+01,  0.1172D+01   &
         /
       data (OREF(11,13, mtmp), mtmp=1,12)   &
         /   &
         0.1882D+01,  0.1975D+01,  0.1998D+01,  0.1939D+01,   &
         0.1867D+01,  0.1710D+01,  0.1548D+01,  0.1600D+01,   &
         0.1528D+01,  0.1510D+01,  0.1496D+01,  0.1677D+01   &
         /
       data (OREF(11,14, mtmp), mtmp=1,12)   &
         /   &
         0.2460D+01,  0.2757D+01,  0.2738D+01,  0.2589D+01,   &
         0.2399D+01,  0.2167D+01,  0.1950D+01,  0.1896D+01,   &
         0.1838D+01,  0.1900D+01,  0.1936D+01,  0.2129D+01   &
         /
       data (OREF(11,15, mtmp), mtmp=1,12)   &
         /   &
         0.2690D+01,  0.2992D+01,  0.3192D+01,  0.3031D+01,   &
         0.2779D+01,  0.2515D+01,  0.2298D+01,  0.2191D+01,   &
         0.2138D+01,  0.2208D+01,  0.2121D+01,  0.2345D+01   &
         /
       data (OREF(11,16, mtmp), mtmp=1,12)   &
         /   &
         0.2572D+01,  0.2956D+01,  0.3367D+01,  0.3313D+01,   &
         0.3052D+01,  0.2703D+01,  0.2417D+01,  0.2284D+01,   &
         0.2247D+01,  0.2212D+01,  0.2249D+01,  0.2269D+01   &
         /
       data (OREF(11,17, mtmp), mtmp=1,12)   &
         /   &
         0.2572D+01,  0.3130D+01,  0.3381D+01,  0.3444D+01,   &
         0.3111D+01,  0.2736D+01,  0.2398D+01,  0.2383D+01,   &
         0.2274D+01,  0.2088D+01,  0.2249D+01,  0.2269D+01   &
         /
       data (OREF(11,18, mtmp), mtmp=1,12)   &
         /   &
         0.2572D+01,  0.3130D+01,  0.3381D+01,  0.3444D+01,   &
         0.3111D+01,  0.2736D+01,  0.2398D+01,  0.2383D+01,   &
         0.2274D+01,  0.2088D+01,  0.2249D+01,  0.2269D+01   &
         /
       data (OREF(12, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3837D+01,  0.3720D+01,  0.3521D+01,  0.3344D+01,   &
         0.3463D+01,  0.3567D+01,  0.3612D+01,  0.2564D+01,   &
         0.2527D+01,  0.2850D+01,  0.4050D+01,  0.4145D+01   &
         /
       data (OREF(12, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3837D+01,  0.3720D+01,  0.3521D+01,  0.3344D+01,   &
         0.3463D+01,  0.3567D+01,  0.3612D+01,  0.2564D+01,   &
         0.2527D+01,  0.2850D+01,  0.4050D+01,  0.4145D+01   &
         /
       data (OREF(12, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3890D+01,  0.3788D+01,  0.3663D+01,  0.3527D+01,   &
         0.3463D+01,  0.3567D+01,  0.3612D+01,  0.3361D+01,   &
         0.3383D+01,  0.3864D+01,  0.4293D+01,  0.4143D+01   &
         /
       data (OREF(12, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3810D+01,  0.3625D+01,  0.3561D+01,  0.3627D+01,   &
         0.3600D+01,  0.3702D+01,  0.3851D+01,  0.3964D+01,   &
         0.3896D+01,  0.4126D+01,  0.4155D+01,  0.3976D+01   &
         /
       data (OREF(12, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3366D+01,  0.3206D+01,  0.3209D+01,  0.3320D+01,   &
         0.3578D+01,  0.3807D+01,  0.3941D+01,  0.3869D+01,   &
         0.3818D+01,  0.3802D+01,  0.3715D+01,  0.3516D+01   &
         /
       data (OREF(12, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2737D+01,  0.2627D+01,  0.2648D+01,  0.2764D+01,   &
         0.2969D+01,  0.3198D+01,  0.3345D+01,  0.3476D+01,   &
         0.3458D+01,  0.3328D+01,  0.3124D+01,  0.2857D+01   &
         /
       data (OREF(12, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2240D+01,  0.2115D+01,  0.2108D+01,  0.2190D+01,   &
         0.2318D+01,  0.2456D+01,  0.2566D+01,  0.2838D+01,   &
         0.2870D+01,  0.2755D+01,  0.2523D+01,  0.2379D+01   &
         /
       data (OREF(12, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1844D+01,  0.1752D+01,  0.1737D+01,  0.1775D+01,   &
         0.1848D+01,  0.1948D+01,  0.2003D+01,  0.2282D+01,   &
         0.2321D+01,  0.2288D+01,  0.2054D+01,  0.1971D+01   &
         /
       data (OREF(12, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1632D+01,  0.1590D+01,  0.1635D+01,  0.1695D+01,   &
         0.1755D+01,  0.1840D+01,  0.1872D+01,  0.2187D+01,   &
         0.2175D+01,  0.2044D+01,  0.1837D+01,  0.1753D+01   &
         /
       data (OREF(12,10, mtmp), mtmp=1,12)   &
         /   &
         0.1592D+01,  0.1561D+01,  0.1656D+01,  0.1785D+01,   &
         0.1850D+01,  0.1920D+01,  0.1967D+01,  0.2265D+01,   &
         0.2203D+01,  0.2010D+01,  0.1763D+01,  0.1709D+01   &
         /
       data (OREF(12,11, mtmp), mtmp=1,12)   &
         /   &
         0.1763D+01,  0.1711D+01,  0.1816D+01,  0.2010D+01,   &
         0.2111D+01,  0.2147D+01,  0.2133D+01,  0.2374D+01,   &
         0.2299D+01,  0.2125D+01,  0.1862D+01,  0.1831D+01   &
         /
       data (OREF(12,12, mtmp), mtmp=1,12)   &
         /   &
         0.2247D+01,  0.2202D+01,  0.2256D+01,  0.2386D+01,   &
         0.2414D+01,  0.2358D+01,  0.2264D+01,  0.2462D+01,   &
         0.2373D+01,  0.2286D+01,  0.2111D+01,  0.2198D+01   &
         /
       data (OREF(12,13, mtmp), mtmp=1,12)   &
         /   &
         0.2912D+01,  0.2978D+01,  0.2965D+01,  0.2883D+01,   &
         0.2798D+01,  0.2633D+01,  0.2463D+01,  0.2623D+01,   &
         0.2550D+01,  0.2553D+01,  0.2470D+01,  0.2689D+01   &
         /
       data (OREF(12,14, mtmp), mtmp=1,12)   &
         /   &
         0.3415D+01,  0.3728D+01,  0.3638D+01,  0.3437D+01,   &
         0.3218D+01,  0.2967D+01,  0.2760D+01,  0.2837D+01,   &
         0.2790D+01,  0.2896D+01,  0.2858D+01,  0.3065D+01   &
         /
       data (OREF(12,15, mtmp), mtmp=1,12)   &
         /   &
         0.3524D+01,  0.3991D+01,  0.4184D+01,  0.3898D+01,   &
         0.3575D+01,  0.3252D+01,  0.3010D+01,  0.2970D+01,   &
         0.2937D+01,  0.3075D+01,  0.2929D+01,  0.3120D+01   &
         /
       data (OREF(12,16, mtmp), mtmp=1,12)   &
         /   &
         0.3301D+01,  0.3816D+01,  0.4424D+01,  0.4232D+01,   &
         0.3825D+01,  0.3329D+01,  0.2978D+01,  0.2859D+01,   &
         0.2852D+01,  0.2889D+01,  0.2894D+01,  0.2935D+01   &
         /
       data (OREF(12,17, mtmp), mtmp=1,12)   &
         /   &
         0.3301D+01,  0.3977D+01,  0.4339D+01,  0.4350D+01,   &
         0.3822D+01,  0.3290D+01,  0.2822D+01,  0.2789D+01,   &
         0.2684D+01,  0.2541D+01,  0.2894D+01,  0.2935D+01   &
         /
       data (OREF(12,18, mtmp), mtmp=1,12)   &
         /   &
         0.3301D+01,  0.3977D+01,  0.4339D+01,  0.4350D+01,   &
         0.3822D+01,  0.3290D+01,  0.2822D+01,  0.2789D+01,   &
         0.2684D+01,  0.2541D+01,  0.2894D+01,  0.2935D+01   &
         /
       data (OREF(13, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4110D+01,  0.3985D+01,  0.3962D+01,  0.3720D+01,   &
         0.4022D+01,  0.4120D+01,  0.4112D+01,  0.3033D+01,   &
         0.2985D+01,  0.3466D+01,  0.4597D+01,  0.4500D+01   &
         /
       data (OREF(13, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4110D+01,  0.3985D+01,  0.3962D+01,  0.3720D+01,   &
         0.4022D+01,  0.4120D+01,  0.4112D+01,  0.3033D+01,   &
         0.2985D+01,  0.3466D+01,  0.4597D+01,  0.4500D+01   &
         /
       data (OREF(13, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4282D+01,  0.4210D+01,  0.4167D+01,  0.4114D+01,   &
         0.4022D+01,  0.4120D+01,  0.4112D+01,  0.3907D+01,   &
         0.3942D+01,  0.4605D+01,  0.4868D+01,  0.4588D+01   &
         /
       data (OREF(13, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4407D+01,  0.4205D+01,  0.4144D+01,  0.4313D+01,   &
         0.4404D+01,  0.4408D+01,  0.4531D+01,  0.4603D+01,   &
         0.4619D+01,  0.4946D+01,  0.4831D+01,  0.4607D+01   &
         /
       data (OREF(13, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4114D+01,  0.3966D+01,  0.3960D+01,  0.4074D+01,   &
         0.4404D+01,  0.4674D+01,  0.4777D+01,  0.4709D+01,   &
         0.4714D+01,  0.4721D+01,  0.4477D+01,  0.4250D+01   &
         /
       data (OREF(13, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3874D+01,  0.3796D+01,  0.3816D+01,  0.3926D+01,   &
         0.4122D+01,  0.4333D+01,  0.4442D+01,  0.4540D+01,   &
         0.4543D+01,  0.4424D+01,  0.4193D+01,  0.3962D+01   &
         /
       data (OREF(13, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3741D+01,  0.3619D+01,  0.3618D+01,  0.3718D+01,   &
         0.3864D+01,  0.4007D+01,  0.4095D+01,  0.4181D+01,   &
         0.4209D+01,  0.4112D+01,  0.3995D+01,  0.3876D+01   &
         /
       data (OREF(13, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3597D+01,  0.3463D+01,  0.3442D+01,  0.3515D+01,   &
         0.3638D+01,  0.3782D+01,  0.3845D+01,  0.3858D+01,   &
         0.3902D+01,  0.3864D+01,  0.3849D+01,  0.3776D+01   &
         /
       data (OREF(13, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3352D+01,  0.3261D+01,  0.3320D+01,  0.3443D+01,   &
         0.3560D+01,  0.3687D+01,  0.3716D+01,  0.3787D+01,   &
         0.3783D+01,  0.3624D+01,  0.3635D+01,  0.3546D+01   &
         /
       data (OREF(13,10, mtmp), mtmp=1,12)   &
         /   &
         0.3296D+01,  0.3215D+01,  0.3350D+01,  0.3570D+01,   &
         0.3700D+01,  0.3804D+01,  0.3858D+01,  0.3913D+01,   &
         0.3842D+01,  0.3599D+01,  0.3543D+01,  0.3489D+01   &
         /
       data (OREF(13,11, mtmp), mtmp=1,12)   &
         /   &
         0.3508D+01,  0.3408D+01,  0.3550D+01,  0.3820D+01,   &
         0.3963D+01,  0.4030D+01,  0.4020D+01,  0.4013D+01,   &
         0.3935D+01,  0.3723D+01,  0.3657D+01,  0.3627D+01   &
         /
       data (OREF(13,12, mtmp), mtmp=1,12)   &
         /   &
         0.3953D+01,  0.3880D+01,  0.3941D+01,  0.4090D+01,   &
         0.4117D+01,  0.4073D+01,  0.3991D+01,  0.3979D+01,   &
         0.3888D+01,  0.3782D+01,  0.3804D+01,  0.3896D+01   &
         /
       data (OREF(13,13, mtmp), mtmp=1,12)   &
         /   &
         0.4507D+01,  0.4517D+01,  0.4467D+01,  0.4375D+01,   &
         0.4303D+01,  0.4167D+01,  0.4032D+01,  0.4029D+01,   &
         0.3959D+01,  0.3933D+01,  0.4040D+01,  0.4290D+01   &
         /
       data (OREF(13,14, mtmp), mtmp=1,12)   &
         /   &
         0.4813D+01,  0.5030D+01,  0.4852D+01,  0.4627D+01,   &
         0.4462D+01,  0.4272D+01,  0.4117D+01,  0.4078D+01,   &
         0.4028D+01,  0.4114D+01,  0.4312D+01,  0.4552D+01   &
         /
       data (OREF(13,15, mtmp), mtmp=1,12)   &
         /   &
         0.4619D+01,  0.5133D+01,  0.5205D+01,  0.4826D+01,   &
         0.4538D+01,  0.4281D+01,  0.4084D+01,  0.3954D+01,   &
         0.3932D+01,  0.4112D+01,  0.4202D+01,  0.4301D+01   &
         /
       data (OREF(13,16, mtmp), mtmp=1,12)   &
         /   &
         0.4242D+01,  0.4741D+01,  0.5360D+01,  0.4970D+01,   &
         0.4505D+01,  0.4039D+01,  0.3739D+01,  0.3575D+01,   &
         0.3598D+01,  0.3753D+01,  0.3834D+01,  0.3955D+01   &
         /
       data (OREF(13,17, mtmp), mtmp=1,12)   &
         /   &
         0.4242D+01,  0.4803D+01,  0.5119D+01,  0.4942D+01,   &
         0.4278D+01,  0.3788D+01,  0.3364D+01,  0.3276D+01,   &
         0.3221D+01,  0.3210D+01,  0.3834D+01,  0.3955D+01   &
         /
       data (OREF(13,18, mtmp), mtmp=1,12)   &
         /   &
         0.4242D+01,  0.4803D+01,  0.5119D+01,  0.4942D+01,   &
         0.4278D+01,  0.3788D+01,  0.3364D+01,  0.3276D+01,   &
         0.3221D+01,  0.3210D+01,  0.3834D+01,  0.3955D+01   &
         /
       data (OREF(14, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4052D+01,  0.3894D+01,  0.4082D+01,  0.3775D+01,   &
         0.4316D+01,  0.4387D+01,  0.4329D+01,  0.3511D+01,   &
         0.3421D+01,  0.4120D+01,  0.4856D+01,  0.4553D+01   &
         /
       data (OREF(14, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4052D+01,  0.3894D+01,  0.4082D+01,  0.3775D+01,   &
         0.4316D+01,  0.4387D+01,  0.4329D+01,  0.3511D+01,   &
         0.3421D+01,  0.4120D+01,  0.4856D+01,  0.4553D+01   &
         /
       data (OREF(14, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4388D+01,  0.4321D+01,  0.4347D+01,  0.4408D+01,   &
         0.4316D+01,  0.4387D+01,  0.4329D+01,  0.4254D+01,   &
         0.4340D+01,  0.5222D+01,  0.5177D+01,  0.4762D+01   &
         /
       data (OREF(14, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4784D+01,  0.4553D+01,  0.4458D+01,  0.4714D+01,   &
         0.4958D+01,  0.4846D+01,  0.4928D+01,  0.4932D+01,   &
         0.5131D+01,  0.5601D+01,  0.5290D+01,  0.5026D+01   &
         /
       data (OREF(14, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4755D+01,  0.4623D+01,  0.4568D+01,  0.4631D+01,   &
         0.4970D+01,  0.5237D+01,  0.5306D+01,  0.5275D+01,   &
         0.5408D+01,  0.5478D+01,  0.5082D+01,  0.4864D+01   &
         /
       data (OREF(14, 6, mtmp), mtmp=1,12)   &
         /   &
         0.5123D+01,  0.5089D+01,  0.5071D+01,  0.5106D+01,   &
         0.5201D+01,  0.5338D+01,  0.5382D+01,  0.5401D+01,   &
         0.5475D+01,  0.5429D+01,  0.5266D+01,  0.5153D+01   &
         /
       data (OREF(14, 7, mtmp), mtmp=1,12)   &
         /   &
         0.5566D+01,  0.5486D+01,  0.5481D+01,  0.5551D+01,   &
         0.5627D+01,  0.5691D+01,  0.5717D+01,  0.5480D+01,   &
         0.5546D+01,  0.5544D+01,  0.5704D+01,  0.5651D+01   &
         /
       data (OREF(14, 8, mtmp), mtmp=1,12)   &
         /   &
         0.5882D+01,  0.5742D+01,  0.5735D+01,  0.5817D+01,   &
         0.5929D+01,  0.6028D+01,  0.6071D+01,  0.5647D+01,   &
         0.5724D+01,  0.5707D+01,  0.6090D+01,  0.6053D+01   &
         /
       data (OREF(14, 9, mtmp), mtmp=1,12)   &
         /   &
         0.5687D+01,  0.5572D+01,  0.5663D+01,  0.5836D+01,   &
         0.5957D+01,  0.6052D+01,  0.6062D+01,  0.5700D+01,   &
         0.5735D+01,  0.5597D+01,  0.5977D+01,  0.5910D+01   &
         /
       data (OREF(14,10, mtmp), mtmp=1,12)   &
         /   &
         0.5587D+01,  0.5488D+01,  0.5679D+01,  0.5956D+01,   &
         0.6114D+01,  0.6208D+01,  0.6261D+01,  0.5894D+01,   &
         0.5850D+01,  0.5612D+01,  0.5893D+01,  0.5830D+01   &
         /
       data (OREF(14,11, mtmp), mtmp=1,12)   &
         /   &
         0.5700D+01,  0.5616D+01,  0.5799D+01,  0.6087D+01,   &
         0.6250D+01,  0.6338D+01,  0.6355D+01,  0.5944D+01,   &
         0.5889D+01,  0.5668D+01,  0.5941D+01,  0.5867D+01   &
         /
       data (OREF(14,12, mtmp), mtmp=1,12)   &
         /   &
         0.5909D+01,  0.5877D+01,  0.5981D+01,  0.6141D+01,   &
         0.6177D+01,  0.6162D+01,  0.6125D+01,  0.5739D+01,   &
         0.5663D+01,  0.5532D+01,  0.5848D+01,  0.5861D+01   &
         /
       data (OREF(14,13, mtmp), mtmp=1,12)   &
         /   &
         0.6206D+01,  0.6169D+01,  0.6143D+01,  0.6104D+01,   &
         0.6094D+01,  0.6022D+01,  0.5953D+01,  0.5622D+01,   &
         0.5551D+01,  0.5432D+01,  0.5805D+01,  0.6032D+01   &
         /
       data (OREF(14,14, mtmp), mtmp=1,12)   &
         /   &
         0.6233D+01,  0.6299D+01,  0.6085D+01,  0.5920D+01,   &
         0.5897D+01,  0.5824D+01,  0.5747D+01,  0.5428D+01,   &
         0.5344D+01,  0.5322D+01,  0.5846D+01,  0.6106D+01   &
         /
       data (OREF(14,15, mtmp), mtmp=1,12)   &
         /   &
         0.5709D+01,  0.6163D+01,  0.6065D+01,  0.5686D+01,   &
         0.5538D+01,  0.5428D+01,  0.5313D+01,  0.4994D+01,   &
         0.4947D+01,  0.5105D+01,  0.5549D+01,  0.5534D+01   &
         /
       data (OREF(14,16, mtmp), mtmp=1,12)   &
         /   &
         0.5211D+01,  0.5616D+01,  0.6063D+01,  0.5508D+01,   &
         0.5077D+01,  0.4751D+01,  0.4573D+01,  0.4325D+01,   &
         0.4349D+01,  0.4617D+01,  0.4839D+01,  0.5054D+01   &
         /
       data (OREF(14,17, mtmp), mtmp=1,12)   &
         /   &
         0.5211D+01,  0.5559D+01,  0.5719D+01,  0.5287D+01,   &
         0.4553D+01,  0.4218D+01,  0.3945D+01,  0.3763D+01,   &
         0.3773D+01,  0.3946D+01,  0.4839D+01,  0.5054D+01   &
         /
       data (OREF(14,18, mtmp), mtmp=1,12)   &
         /   &
         0.5211D+01,  0.5559D+01,  0.5719D+01,  0.5287D+01,   &
         0.4553D+01,  0.4218D+01,  0.3945D+01,  0.3763D+01,   &
         0.3773D+01,  0.3946D+01,  0.4839D+01,  0.5054D+01   &
         /
       data (OREF(15, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4175D+01,  0.3941D+01,  0.4215D+01,  0.3916D+01,   &
         0.4611D+01,  0.4665D+01,  0.4601D+01,  0.4134D+01,   &
         0.4009D+01,  0.4901D+01,  0.5197D+01,  0.4691D+01   &
         /
       data (OREF(15, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4175D+01,  0.3941D+01,  0.4215D+01,  0.3916D+01,   &
         0.4611D+01,  0.4665D+01,  0.4601D+01,  0.4134D+01,   &
         0.4009D+01,  0.4901D+01,  0.5197D+01,  0.4691D+01   &
         /
       data (OREF(15, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4725D+01,  0.4624D+01,  0.4582D+01,  0.4651D+01,   &
         0.4611D+01,  0.4665D+01,  0.4601D+01,  0.4584D+01,   &
         0.4743D+01,  0.5783D+01,  0.5580D+01,  0.5086D+01   &
         /
       data (OREF(15, 4, mtmp), mtmp=1,12)   &
         /   &
         0.5463D+01,  0.5199D+01,  0.4964D+01,  0.5117D+01,   &
         0.5386D+01,  0.5202D+01,  0.5222D+01,  0.5156D+01,   &
         0.5576D+01,  0.6177D+01,  0.5892D+01,  0.5695D+01   &
         /
       data (OREF(15, 5, mtmp), mtmp=1,12)   &
         /   &
         0.5842D+01,  0.5677D+01,  0.5456D+01,  0.5322D+01,   &
         0.5482D+01,  0.5659D+01,  0.5701D+01,  0.5738D+01,   &
         0.6021D+01,  0.6204D+01,  0.5961D+01,  0.5921D+01   &
         /
       data (OREF(15, 6, mtmp), mtmp=1,12)   &
         /   &
         0.6559D+01,  0.6505D+01,  0.6356D+01,  0.6204D+01,   &
         0.6064D+01,  0.6108D+01,  0.6104D+01,  0.6113D+01,   &
         0.6284D+01,  0.6391D+01,  0.6487D+01,  0.6564D+01   &
         /
       data (OREF(15, 7, mtmp), mtmp=1,12)   &
         /   &
         0.7222D+01,  0.7201D+01,  0.7155D+01,  0.7105D+01,   &
         0.6973D+01,  0.6858D+01,  0.6819D+01,  0.6527D+01,   &
         0.6688D+01,  0.6851D+01,  0.7248D+01,  0.7241D+01   &
         /
       data (OREF(15, 8, mtmp), mtmp=1,12)   &
         /   &
         0.7794D+01,  0.7746D+01,  0.7807D+01,  0.7814D+01,   &
         0.7750D+01,  0.7621D+01,  0.7606D+01,  0.7171D+01,   &
         0.7323D+01,  0.7356D+01,  0.7870D+01,  0.7849D+01   &
         /
       data (OREF(15, 9, mtmp), mtmp=1,12)   &
         /   &
         0.7735D+01,  0.7724D+01,  0.7923D+01,  0.8051D+01,   &
         0.7998D+01,  0.7889D+01,  0.7866D+01,  0.7463D+01,   &
         0.7569D+01,  0.7510D+01,  0.7929D+01,  0.7866D+01   &
         /
       data (OREF(15,10, mtmp), mtmp=1,12)   &
         /   &
         0.7529D+01,  0.7559D+01,  0.7863D+01,  0.8068D+01,   &
         0.8115D+01,  0.8089D+01,  0.8135D+01,  0.7737D+01,   &
         0.7762D+01,  0.7612D+01,  0.7895D+01,  0.7737D+01   &
         /
       data (OREF(15,11, mtmp), mtmp=1,12)   &
         /   &
         0.7299D+01,  0.7403D+01,  0.7650D+01,  0.7850D+01,   &
         0.7979D+01,  0.8044D+01,  0.8108D+01,  0.7681D+01,   &
         0.7674D+01,  0.7476D+01,  0.7724D+01,  0.7480D+01   &
         /
       data (OREF(15,12, mtmp), mtmp=1,12)   &
         /   &
         0.7111D+01,  0.7243D+01,  0.7462D+01,  0.7637D+01,   &
         0.7715D+01,  0.7725D+01,  0.7728D+01,  0.7276D+01,   &
         0.7228D+01,  0.7068D+01,  0.7289D+01,  0.7106D+01   &
         /
       data (OREF(15,13, mtmp), mtmp=1,12)   &
         /   &
         0.7060D+01,  0.7045D+01,  0.7177D+01,  0.7306D+01,   &
         0.7418D+01,  0.7406D+01,  0.7379D+01,  0.6960D+01,   &
         0.6868D+01,  0.6600D+01,  0.6834D+01,  0.6948D+01   &
         /
       data (OREF(15,14, mtmp), mtmp=1,12)   &
         /   &
         0.6879D+01,  0.6882D+01,  0.6765D+01,  0.6802D+01,   &
         0.6962D+01,  0.6964D+01,  0.6922D+01,  0.6483D+01,   &
         0.6317D+01,  0.6101D+01,  0.6525D+01,  0.6755D+01   &
         /
       data (OREF(15,15, mtmp), mtmp=1,12)   &
         /   &
         0.6305D+01,  0.6687D+01,  0.6486D+01,  0.6276D+01,   &
         0.6325D+01,  0.6306D+01,  0.6216D+01,  0.5788D+01,   &
         0.5642D+01,  0.5671D+01,  0.6164D+01,  0.6115D+01   &
         /
       data (OREF(15,16, mtmp), mtmp=1,12)   &
         /   &
         0.5851D+01,  0.6275D+01,  0.6426D+01,  0.5884D+01,   &
         0.5566D+01,  0.5324D+01,  0.5203D+01,  0.4896D+01,   &
         0.4834D+01,  0.5115D+01,  0.5422D+01,  0.5655D+01   &
         /
       data (OREF(15,17, mtmp), mtmp=1,12)   &
         /   &
         0.5851D+01,  0.6205D+01,  0.6205D+01,  0.5565D+01,   &
         0.4820D+01,  0.4592D+01,  0.4394D+01,  0.4099D+01,   &
         0.4113D+01,  0.4415D+01,  0.5422D+01,  0.5655D+01   &
         /
       data (OREF(15,18, mtmp), mtmp=1,12)   &
         /   &
         0.5851D+01,  0.6205D+01,  0.6205D+01,  0.5565D+01,   &
         0.4820D+01,  0.4592D+01,  0.4394D+01,  0.4099D+01,   &
         0.4113D+01,  0.4415D+01,  0.5422D+01,  0.5655D+01   &
         /
       data (OREF(16, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4487D+01,  0.4140D+01,  0.4381D+01,  0.4154D+01,   &
         0.4923D+01,  0.4971D+01,  0.4939D+01,  0.4856D+01,   &
         0.4709D+01,  0.5734D+01,  0.5610D+01,  0.4930D+01   &
         /
       data (OREF(16, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4487D+01,  0.4140D+01,  0.4381D+01,  0.4154D+01,   &
         0.4923D+01,  0.4971D+01,  0.4939D+01,  0.4856D+01,   &
         0.4709D+01,  0.5734D+01,  0.5610D+01,  0.4930D+01   &
         /
       data (OREF(16, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5283D+01,  0.5123D+01,  0.4893D+01,  0.4867D+01,   &
         0.4923D+01,  0.4971D+01,  0.4939D+01,  0.4905D+01,   &
         0.5159D+01,  0.6277D+01,  0.6065D+01,  0.5555D+01   &
         /
       data (OREF(16, 4, mtmp), mtmp=1,12)   &
         /   &
         0.6390D+01,  0.6110D+01,  0.5657D+01,  0.5538D+01,   &
         0.5705D+01,  0.5491D+01,  0.5440D+01,  0.5321D+01,   &
         0.5978D+01,  0.6677D+01,  0.6606D+01,  0.6561D+01   &
         /
       data (OREF(16, 5, mtmp), mtmp=1,12)   &
         /   &
         0.7263D+01,  0.7035D+01,  0.6570D+01,  0.6126D+01,   &
         0.5949D+01,  0.5969D+01,  0.5993D+01,  0.6127D+01,   &
         0.6564D+01,  0.6885D+01,  0.7053D+01,  0.7314D+01   &
         /
       data (OREF(16, 6, mtmp), mtmp=1,12)   &
         /   &
         0.8008D+01,  0.7878D+01,  0.7543D+01,  0.7137D+01,   &
         0.6687D+01,  0.6636D+01,  0.6609D+01,  0.6677D+01,   &
         0.6959D+01,  0.7269D+01,  0.7744D+01,  0.8029D+01   &
         /
       data (OREF(16, 7, mtmp), mtmp=1,12)   &
         /   &
         0.8506D+01,  0.8537D+01,  0.8424D+01,  0.8203D+01,   &
         0.7791D+01,  0.7453D+01,  0.7365D+01,  0.7272D+01,   &
         0.7570D+01,  0.7927D+01,  0.8456D+01,  0.8459D+01   &
         /
       data (OREF(16, 8, mtmp), mtmp=1,12)   &
         /   &
         0.9077D+01,  0.9181D+01,  0.9328D+01,  0.9193D+01,   &
         0.8855D+01,  0.8409D+01,  0.8327D+01,  0.8268D+01,   &
         0.8520D+01,  0.8619D+01,  0.8977D+01,  0.8945D+01   &
         /
       data (OREF(16, 9, mtmp), mtmp=1,12)   &
         /   &
         0.9183D+01,  0.9370D+01,  0.9696D+01,  0.9687D+01,   &
         0.9349D+01,  0.8953D+01,  0.8903D+01,  0.8838D+01,   &
         0.9026D+01,  0.9077D+01,  0.9206D+01,  0.9130D+01   &
         /
       data (OREF(16,10, mtmp), mtmp=1,12)   &
         /   &
         0.8836D+01,  0.9100D+01,  0.9524D+01,  0.9550D+01,   &
         0.9393D+01,  0.9195D+01,  0.9239D+01,  0.9181D+01,   &
         0.9297D+01,  0.9278D+01,  0.9232D+01,  0.8933D+01   &
         /
       data (OREF(16,11, mtmp), mtmp=1,12)   &
         /   &
         0.8141D+01,  0.8539D+01,  0.8852D+01,  0.8894D+01,   &
         0.8957D+01,  0.8968D+01,  0.9087D+01,  0.9001D+01,   &
         0.9050D+01,  0.8891D+01,  0.8775D+01,  0.8300D+01   &
         /
       data (OREF(16,12, mtmp), mtmp=1,12)   &
         /   &
         0.7534D+01,  0.7896D+01,  0.8260D+01,  0.8450D+01,   &
         0.8588D+01,  0.8613D+01,  0.8640D+01,  0.8421D+01,   &
         0.8407D+01,  0.8219D+01,  0.8009D+01,  0.7584D+01   &
         /
       data (OREF(16,13, mtmp), mtmp=1,12)   &
         /   &
         0.7151D+01,  0.7210D+01,  0.7577D+01,  0.7927D+01,   &
         0.8181D+01,  0.8207D+01,  0.8186D+01,  0.7923D+01,   &
         0.7797D+01,  0.7362D+01,  0.7137D+01,  0.7100D+01   &
         /
       data (OREF(16,14, mtmp), mtmp=1,12)   &
         /   &
         0.6863D+01,  0.6887D+01,  0.6955D+01,  0.7273D+01,   &
         0.7609D+01,  0.7628D+01,  0.7572D+01,  0.7190D+01,   &
         0.6916D+01,  0.6467D+01,  0.6465D+01,  0.6639D+01   &
         /
       data (OREF(16,15, mtmp), mtmp=1,12)   &
         /   &
         0.6457D+01,  0.6775D+01,  0.6554D+01,  0.6626D+01,   &
         0.6883D+01,  0.6881D+01,  0.6762D+01,  0.6322D+01,   &
         0.6029D+01,  0.5857D+01,  0.6142D+01,  0.6130D+01   &
         /
       data (OREF(16,16, mtmp), mtmp=1,12)   &
         /   &
         0.6168D+01,  0.6694D+01,  0.6514D+01,  0.6133D+01,   &
         0.5981D+01,  0.5755D+01,  0.5626D+01,  0.5293D+01,   &
         0.5080D+01,  0.5285D+01,  0.5612D+01,  0.5802D+01   &
         /
       data (OREF(16,17, mtmp), mtmp=1,12)   &
         /   &
         0.6168D+01,  0.6708D+01,  0.6573D+01,  0.5796D+01,   &
         0.5096D+01,  0.4922D+01,  0.4720D+01,  0.4306D+01,   &
         0.4269D+01,  0.4631D+01,  0.5612D+01,  0.5802D+01   &
         /
       data (OREF(16,18, mtmp), mtmp=1,12)   &
         /   &
         0.6168D+01,  0.6708D+01,  0.6573D+01,  0.5796D+01,   &
         0.5096D+01,  0.4922D+01,  0.4720D+01,  0.4306D+01,   &
         0.4269D+01,  0.4631D+01,  0.5612D+01,  0.5802D+01   &
         /
       data (OREF(17, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5011D+01,  0.4535D+01,  0.4643D+01,  0.4473D+01,   &
         0.5290D+01,  0.5348D+01,  0.5352D+01,  0.5458D+01,   &
         0.5286D+01,  0.6352D+01,  0.6067D+01,  0.5393D+01   &
         /
       data (OREF(17, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5011D+01,  0.4535D+01,  0.4643D+01,  0.4473D+01,   &
         0.5290D+01,  0.5348D+01,  0.5352D+01,  0.5458D+01,   &
         0.5286D+01,  0.6352D+01,  0.6067D+01,  0.5393D+01   &
         /
       data (OREF(17, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5965D+01,  0.5767D+01,  0.5346D+01,  0.5173D+01,   &
         0.5290D+01,  0.5348D+01,  0.5352D+01,  0.5279D+01,   &
         0.5679D+01,  0.6792D+01,  0.6618D+01,  0.6154D+01   &
         /
       data (OREF(17, 4, mtmp), mtmp=1,12)   &
         /   &
         0.7258D+01,  0.7004D+01,  0.6413D+01,  0.6038D+01,   &
         0.6024D+01,  0.5770D+01,  0.5708D+01,  0.5678D+01,   &
         0.6541D+01,  0.7257D+01,  0.7343D+01,  0.7374D+01   &
         /
       data (OREF(17, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8374D+01,  0.8138D+01,  0.7564D+01,  0.6911D+01,   &
         0.6460D+01,  0.6336D+01,  0.6363D+01,  0.6648D+01,   &
         0.7213D+01,  0.7634D+01,  0.8069D+01,  0.8429D+01   &
         /
       data (OREF(17, 6, mtmp), mtmp=1,12)   &
         /   &
         0.9065D+01,  0.8891D+01,  0.8465D+01,  0.7920D+01,   &
         0.7275D+01,  0.7149D+01,  0.7113D+01,  0.7291D+01,   &
         0.7693D+01,  0.8164D+01,  0.8811D+01,  0.9119D+01   &
         /
       data (OREF(17, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9433D+01,  0.9470D+01,  0.9293D+01,  0.8970D+01,   &
         0.8399D+01,  0.7916D+01,  0.7828D+01,  0.7962D+01,   &
         0.8395D+01,  0.8887D+01,  0.9372D+01,  0.9338D+01   &
         /
       data (OREF(17, 8, mtmp), mtmp=1,12)   &
         /   &
         0.9957D+01,  0.1014D+02,  0.1025D+02,  0.9972D+01,   &
         0.9471D+01,  0.8867D+01,  0.8792D+01,  0.9059D+01,   &
         0.9409D+01,  0.9573D+01,  0.9720D+01,  0.9673D+01   &
         /
       data (OREF(17, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1012D+02,  0.1046D+02,  0.1073D+02,  0.1052D+02,   &
         0.1002D+02,  0.9527D+01,  0.9520D+01,  0.9739D+01,   &
         0.9990D+01,  0.1009D+02,  0.9950D+01,  0.9870D+01   &
         /
       data (OREF(17,10, mtmp), mtmp=1,12)   &
         /   &
         0.9660D+01,  0.1011D+02,  0.1050D+02,  0.1032D+02,   &
         0.1004D+02,  0.9793D+01,  0.9875D+01,  0.1009D+02,   &
         0.1027D+02,  0.1028D+02,  0.9944D+01,  0.9592D+01   &
         /
       data (OREF(17,11, mtmp), mtmp=1,12)   &
         /   &
         0.8715D+01,  0.9324D+01,  0.9627D+01,  0.9546D+01,   &
         0.9564D+01,  0.9540D+01,  0.9690D+01,  0.9867D+01,   &
         0.9954D+01,  0.9800D+01,  0.9363D+01,  0.8788D+01   &
         /
       data (OREF(17,12, mtmp), mtmp=1,12)   &
         /   &
         0.7870D+01,  0.8413D+01,  0.8836D+01,  0.9016D+01,   &
         0.9186D+01,  0.9212D+01,  0.9248D+01,  0.9256D+01,   &
         0.9282D+01,  0.9063D+01,  0.8481D+01,  0.7920D+01   &
         /
       data (OREF(17,13, mtmp), mtmp=1,12)   &
         /   &
         0.7262D+01,  0.7432D+01,  0.7986D+01,  0.8466D+01,   &
         0.8776D+01,  0.8794D+01,  0.8758D+01,  0.8690D+01,   &
         0.8547D+01,  0.8009D+01,  0.7402D+01,  0.7249D+01   &
         /
       data (OREF(17,14, mtmp), mtmp=1,12)   &
         /   &
         0.6858D+01,  0.6948D+01,  0.7258D+01,  0.7803D+01,   &
         0.8197D+01,  0.8182D+01,  0.8098D+01,  0.7863D+01,   &
         0.7519D+01,  0.6880D+01,  0.6481D+01,  0.6590D+01   &
         /
       data (OREF(17,15, mtmp), mtmp=1,12)   &
         /   &
         0.6543D+01,  0.6824D+01,  0.6736D+01,  0.7094D+01,   &
         0.7475D+01,  0.7439D+01,  0.7287D+01,  0.6932D+01,   &
         0.6530D+01,  0.6141D+01,  0.6139D+01,  0.6143D+01   &
         /
       data (OREF(17,16, mtmp), mtmp=1,12)   &
         /   &
         0.6425D+01,  0.6946D+01,  0.6624D+01,  0.6507D+01,   &
         0.6506D+01,  0.6277D+01,  0.6119D+01,  0.5816D+01,   &
         0.5476D+01,  0.5529D+01,  0.5806D+01,  0.5956D+01   &
         /
       data (OREF(17,17, mtmp), mtmp=1,12)   &
         /   &
         0.6425D+01,  0.7089D+01,  0.6851D+01,  0.6084D+01,   &
         0.5509D+01,  0.5401D+01,  0.5167D+01,  0.4650D+01,   &
         0.4535D+01,  0.4880D+01,  0.5806D+01,  0.5956D+01   &
         /
       data (OREF(17,18, mtmp), mtmp=1,12)   &
         /   &
         0.6425D+01,  0.7089D+01,  0.6851D+01,  0.6084D+01,   &
         0.5509D+01,  0.5401D+01,  0.5167D+01,  0.4650D+01,   &
         0.4535D+01,  0.4880D+01,  0.5806D+01,  0.5956D+01   &
         /
       data (OREF(18, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5664D+01,  0.5090D+01,  0.4996D+01,  0.4851D+01,   &
         0.5704D+01,  0.5785D+01,  0.5813D+01,  0.5849D+01,   &
         0.5652D+01,  0.6670D+01,  0.6493D+01,  0.6012D+01   &
         /
       data (OREF(18, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5664D+01,  0.5090D+01,  0.4996D+01,  0.4851D+01,   &
         0.5704D+01,  0.5785D+01,  0.5813D+01,  0.5849D+01,   &
         0.5652D+01,  0.6670D+01,  0.6493D+01,  0.6012D+01   &
         /
       data (OREF(18, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6632D+01,  0.6453D+01,  0.5918D+01,  0.5580D+01,   &
         0.5704D+01,  0.5785D+01,  0.5813D+01,  0.5687D+01,   &
         0.6269D+01,  0.7278D+01,  0.7143D+01,  0.6765D+01   &
         /
       data (OREF(18, 4, mtmp), mtmp=1,12)   &
         /   &
         0.7865D+01,  0.7694D+01,  0.7121D+01,  0.6598D+01,   &
         0.6358D+01,  0.6049D+01,  0.6041D+01,  0.6254D+01,   &
         0.7247D+01,  0.7869D+01,  0.7966D+01,  0.7950D+01   &
         /
       data (OREF(18, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8903D+01,  0.8737D+01,  0.8250D+01,  0.7578D+01,   &
         0.7006D+01,  0.6783D+01,  0.6827D+01,  0.7305D+01,   &
         0.7938D+01,  0.8374D+01,  0.8797D+01,  0.8988D+01   &
         /
       data (OREF(18, 6, mtmp), mtmp=1,12)   &
         /   &
         0.9541D+01,  0.9386D+01,  0.9008D+01,  0.8493D+01,   &
         0.7833D+01,  0.7660D+01,  0.7623D+01,  0.7939D+01,   &
         0.8442D+01,  0.8972D+01,  0.9494D+01,  0.9625D+01   &
         /
       data (OREF(18, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9923D+01,  0.9925D+01,  0.9711D+01,  0.9387D+01,   &
         0.8824D+01,  0.8309D+01,  0.8268D+01,  0.8575D+01,   &
         0.9103D+01,  0.9623D+01,  0.9901D+01,  0.9799D+01   &
         /
       data (OREF(18, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1041D+02,  0.1058D+02,  0.1053D+02,  0.1015D+02,   &
         0.9645D+01,  0.9086D+01,  0.9090D+01,  0.9510D+01,   &
         0.9922D+01,  0.1013D+02,  0.1010D+02,  0.1005D+02   &
         /
       data (OREF(18, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1051D+02,  0.1090D+02,  0.1095D+02,  0.1053D+02,   &
         0.1005D+02,  0.9676D+01,  0.9771D+01,  0.1010D+02,   &
         0.1037D+02,  0.1043D+02,  0.1017D+02,  0.1011D+02   &
         /
       data (OREF(18,10, mtmp), mtmp=1,12)   &
         /   &
         0.1001D+02,  0.1053D+02,  0.1072D+02,  0.1038D+02,   &
         0.1010D+02,  0.9941D+01,  0.1009D+02,  0.1039D+02,   &
         0.1058D+02,  0.1051D+02,  0.1006D+02,  0.9765D+01   &
         /
       data (OREF(18,11, mtmp), mtmp=1,12)   &
         /   &
         0.9093D+01,  0.9766D+01,  0.9969D+01,  0.9830D+01,   &
         0.9836D+01,  0.9812D+01,  0.9970D+01,  0.1022D+02,   &
         0.1032D+02,  0.1013D+02,  0.9543D+01,  0.9028D+01   &
         /
       data (OREF(18,12, mtmp), mtmp=1,12)   &
         /   &
         0.8234D+01,  0.8865D+01,  0.9235D+01,  0.9372D+01,   &
         0.9535D+01,  0.9549D+01,  0.9592D+01,  0.9730D+01,   &
         0.9792D+01,  0.9551D+01,  0.8783D+01,  0.8219D+01   &
         /
       data (OREF(18,13, mtmp), mtmp=1,12)   &
         /   &
         0.7527D+01,  0.7833D+01,  0.8481D+01,  0.8950D+01,   &
         0.9207D+01,  0.9178D+01,  0.9123D+01,  0.9218D+01,   &
         0.9088D+01,  0.8547D+01,  0.7751D+01,  0.7532D+01   &
         /
       data (OREF(18,14, mtmp), mtmp=1,12)   &
         /   &
         0.6991D+01,  0.7176D+01,  0.7756D+01,  0.8404D+01,   &
         0.8706D+01,  0.8620D+01,  0.8514D+01,  0.8473D+01,   &
         0.8133D+01,  0.7403D+01,  0.6734D+01,  0.6767D+01   &
         /
       data (OREF(18,15, mtmp), mtmp=1,12)   &
         /   &
         0.6641D+01,  0.6909D+01,  0.7101D+01,  0.7687D+01,   &
         0.8056D+01,  0.7942D+01,  0.7776D+01,  0.7598D+01,   &
         0.7181D+01,  0.6605D+01,  0.6296D+01,  0.6270D+01   &
         /
       data (OREF(18,16, mtmp), mtmp=1,12)   &
         /   &
         0.6658D+01,  0.7048D+01,  0.6803D+01,  0.7008D+01,   &
         0.7094D+01,  0.6843D+01,  0.6660D+01,  0.6463D+01,   &
         0.6078D+01,  0.5924D+01,  0.6085D+01,  0.6203D+01   &
         /
       data (OREF(18,17, mtmp), mtmp=1,12)   &
         /   &
         0.6658D+01,  0.7327D+01,  0.7035D+01,  0.6416D+01,   &
         0.6027D+01,  0.5993D+01,  0.5723D+01,  0.5154D+01,   &
         0.4962D+01,  0.5220D+01,  0.6085D+01,  0.6203D+01   &
         /
       data (OREF(18,18, mtmp), mtmp=1,12)   &
         /   &
         0.6658D+01,  0.7327D+01,  0.7035D+01,  0.6416D+01,   &
         0.6027D+01,  0.5993D+01,  0.5723D+01,  0.5154D+01,   &
         0.4962D+01,  0.5220D+01,  0.6085D+01,  0.6203D+01   &
         /
       data (OREF(19, 1, mtmp), mtmp=1,12)   &
         /   &
         0.6171D+01,  0.5664D+01,  0.5400D+01,  0.5249D+01,   &
         0.6130D+01,  0.6217D+01,  0.6235D+01,  0.6021D+01,   &
         0.5889D+01,  0.6811D+01,  0.6770D+01,  0.6477D+01   &
         /
       data (OREF(19, 2, mtmp), mtmp=1,12)   &
         /   &
         0.6171D+01,  0.5664D+01,  0.5400D+01,  0.5249D+01,   &
         0.6130D+01,  0.6217D+01,  0.6235D+01,  0.6021D+01,   &
         0.5889D+01,  0.6811D+01,  0.6770D+01,  0.6477D+01   &
         /
       data (OREF(19, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6993D+01,  0.6967D+01,  0.6531D+01,  0.6060D+01,   &
         0.6130D+01,  0.6217D+01,  0.6235D+01,  0.6050D+01,   &
         0.6802D+01,  0.7610D+01,  0.7438D+01,  0.7084D+01   &
         /
       data (OREF(19, 4, mtmp), mtmp=1,12)   &
         /   &
         0.8000D+01,  0.8000D+01,  0.7675D+01,  0.7182D+01,   &
         0.6731D+01,  0.6338D+01,  0.6421D+01,  0.6919D+01,   &
         0.7890D+01,  0.8304D+01,  0.8247D+01,  0.8051D+01   &
         /
       data (OREF(19, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8808D+01,  0.8786D+01,  0.8571D+01,  0.8097D+01,   &
         0.7564D+01,  0.7283D+01,  0.7353D+01,  0.7982D+01,   &
         0.8554D+01,  0.8863D+01,  0.9013D+01,  0.8887D+01   &
         /
       data (OREF(19, 6, mtmp), mtmp=1,12)   &
         /   &
         0.9397D+01,  0.9332D+01,  0.9133D+01,  0.8810D+01,   &
         0.8312D+01,  0.8118D+01,  0.8068D+01,  0.8474D+01,   &
         0.8986D+01,  0.9402D+01,  0.9573D+01,  0.9456D+01   &
         /
       data (OREF(19, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9848D+01,  0.9828D+01,  0.9645D+01,  0.9413D+01,   &
         0.8998D+01,  0.8540D+01,  0.8547D+01,  0.8932D+01,   &
         0.9451D+01,  0.9846D+01,  0.9845D+01,  0.9695D+01   &
         /
       data (OREF(19, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1032D+02,  0.1039D+02,  0.1015D+02,  0.9775D+01,   &
         0.9397D+01,  0.9019D+01,  0.9118D+01,  0.9524D+01,   &
         0.9901D+01,  0.1008D+02,  0.9941D+01,  0.9930D+01   &
         /
       data (OREF(19, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1036D+02,  0.1063D+02,  0.1036D+02,  0.9885D+01,   &
         0.9574D+01,  0.9424D+01,  0.9613D+01,  0.9882D+01,   &
         0.1009D+02,  0.1010D+02,  0.9853D+01,  0.9877D+01   &
         /
       data (OREF(19,10, mtmp), mtmp=1,12)   &
         /   &
         0.9911D+01,  0.1030D+02,  0.1019D+02,  0.9820D+01,   &
         0.9649D+01,  0.9641D+01,  0.9845D+01,  0.1008D+02,   &
         0.1021D+02,  0.1006D+02,  0.9655D+01,  0.9524D+01   &
         /
       data (OREF(19,11, mtmp), mtmp=1,12)   &
         /   &
         0.9205D+01,  0.9740D+01,  0.9759D+01,  0.9615D+01,   &
         0.9630D+01,  0.9648D+01,  0.9819D+01,  0.1002D+02,   &
         0.1009D+02,  0.9885D+01,  0.9321D+01,  0.8988D+01   &
         /
       data (OREF(19,12, mtmp), mtmp=1,12)   &
         /   &
         0.8507D+01,  0.9082D+01,  0.9296D+01,  0.9353D+01,   &
         0.9452D+01,  0.9464D+01,  0.9547D+01,  0.9740D+01,   &
         0.9814D+01,  0.9588D+01,  0.8855D+01,  0.8382D+01   &
         /
       data (OREF(19,13, mtmp), mtmp=1,12)   &
         /   &
         0.7834D+01,  0.8254D+01,  0.8845D+01,  0.9137D+01,   &
         0.9233D+01,  0.9155D+01,  0.9129D+01,  0.9332D+01,   &
         0.9266D+01,  0.8852D+01,  0.8107D+01,  0.7843D+01   &
         /
       data (OREF(19,14, mtmp), mtmp=1,12)   &
         /   &
         0.7217D+01,  0.7504D+01,  0.8295D+01,  0.8804D+01,   &
         0.8855D+01,  0.8684D+01,  0.8601D+01,  0.8737D+01,   &
         0.8531D+01,  0.7902D+01,  0.7164D+01,  0.7110D+01   &
         /
       data (OREF(19,15, mtmp), mtmp=1,12)   &
         /   &
         0.6745D+01,  0.7036D+01,  0.7580D+01,  0.8205D+01,   &
         0.8337D+01,  0.8102D+01,  0.7959D+01,  0.8004D+01,   &
         0.7748D+01,  0.7126D+01,  0.6596D+01,  0.6478D+01   &
         /
       data (OREF(19,16, mtmp), mtmp=1,12)   &
         /   &
         0.6801D+01,  0.7037D+01,  0.7055D+01,  0.7524D+01,   &
         0.7495D+01,  0.7158D+01,  0.6977D+01,  0.6981D+01,   &
         0.6712D+01,  0.6384D+01,  0.6404D+01,  0.6463D+01   &
         /
       data (OREF(19,17, mtmp), mtmp=1,12)   &
         /   &
         0.6801D+01,  0.7385D+01,  0.7144D+01,  0.6751D+01,   &
         0.6493D+01,  0.6447D+01,  0.6165D+01,  0.5678D+01,   &
         0.5447D+01,  0.5594D+01,  0.6404D+01,  0.6463D+01   &
         /
       data (OREF(19,18, mtmp), mtmp=1,12)   &
         /   &
         0.6801D+01,  0.7385D+01,  0.7144D+01,  0.6751D+01,   &
         0.6493D+01,  0.6447D+01,  0.6165D+01,  0.5678D+01,   &
         0.5447D+01,  0.5594D+01,  0.6404D+01,  0.6463D+01   &
         /
       data (OREF(20, 1, mtmp), mtmp=1,12)   &
         /   &
         0.6287D+01,  0.6081D+01,  0.5792D+01,  0.5613D+01,   &
         0.6520D+01,  0.6570D+01,  0.6530D+01,  0.5988D+01,   &
         0.6056D+01,  0.6854D+01,  0.6788D+01,  0.6525D+01   &
         /
       data (OREF(20, 2, mtmp), mtmp=1,12)   &
         /   &
         0.6287D+01,  0.6081D+01,  0.5792D+01,  0.5613D+01,   &
         0.6520D+01,  0.6570D+01,  0.6530D+01,  0.5988D+01,   &
         0.6056D+01,  0.6854D+01,  0.6788D+01,  0.6525D+01   &
         /
       data (OREF(20, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6857D+01,  0.7114D+01,  0.7060D+01,  0.6558D+01,   &
         0.6520D+01,  0.6570D+01,  0.6530D+01,  0.6284D+01,   &
         0.7129D+01,  0.7664D+01,  0.7348D+01,  0.6911D+01   &
         /
       data (OREF(20, 4, mtmp), mtmp=1,12)   &
         /   &
         0.7587D+01,  0.7822D+01,  0.7956D+01,  0.7716D+01,   &
         0.7143D+01,  0.6642D+01,  0.6811D+01,  0.7490D+01,   &
         0.8246D+01,  0.8372D+01,  0.8039D+01,  0.7593D+01   &
         /
       data (OREF(20, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8177D+01,  0.8335D+01,  0.8498D+01,  0.8409D+01,   &
         0.8072D+01,  0.7780D+01,  0.7868D+01,  0.8517D+01,   &
         0.8861D+01,  0.8896D+01,  0.8627D+01,  0.8190D+01   &
         /
       data (OREF(20, 6, mtmp), mtmp=1,12)   &
         /   &
         0.8712D+01,  0.8786D+01,  0.8842D+01,  0.8821D+01,   &
         0.8624D+01,  0.8436D+01,  0.8347D+01,  0.8736D+01,   &
         0.9122D+01,  0.9252D+01,  0.8999D+01,  0.8685D+01   &
         /
       data (OREF(20, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9210D+01,  0.9209D+01,  0.9125D+01,  0.9041D+01,   &
         0.8860D+01,  0.8514D+01,  0.8539D+01,  0.8887D+01,   &
         0.9272D+01,  0.9414D+01,  0.9171D+01,  0.9018D+01   &
         /
       data (OREF(20, 8, mtmp), mtmp=1,12)   &
         /   &
         0.9668D+01,  0.9600D+01,  0.9227D+01,  0.8956D+01,   &
         0.8787D+01,  0.8646D+01,  0.8804D+01,  0.9079D+01,   &
         0.9316D+01,  0.9383D+01,  0.9222D+01,  0.9295D+01   &
         /
       data (OREF(20, 9, mtmp), mtmp=1,12)   &
         /   &
         0.9711D+01,  0.9719D+01,  0.9160D+01,  0.8804D+01,   &
         0.8747D+01,  0.8830D+01,  0.9059D+01,  0.9169D+01,   &
         0.9243D+01,  0.9208D+01,  0.9064D+01,  0.9231D+01   &
         /
       data (OREF(20,10, mtmp), mtmp=1,12)   &
         /   &
         0.9416D+01,  0.9503D+01,  0.9078D+01,  0.8808D+01,   &
         0.8809D+01,  0.8952D+01,  0.9171D+01,  0.9256D+01,   &
         0.9277D+01,  0.9122D+01,  0.8868D+01,  0.8958D+01   &
         /
       data (OREF(20,11, mtmp), mtmp=1,12)   &
         /   &
         0.8988D+01,  0.9214D+01,  0.9010D+01,  0.8895D+01,   &
         0.8929D+01,  0.9017D+01,  0.9217D+01,  0.9324D+01,   &
         0.9340D+01,  0.9148D+01,  0.8743D+01,  0.8647D+01   &
         /
       data (OREF(20,12, mtmp), mtmp=1,12)   &
         /   &
         0.8551D+01,  0.8923D+01,  0.8924D+01,  0.8879D+01,   &
         0.8875D+01,  0.8901D+01,  0.9066D+01,  0.9264D+01,   &
         0.9322D+01,  0.9156D+01,  0.8641D+01,  0.8308D+01   &
         /
       data (OREF(20,13, mtmp), mtmp=1,12)   &
         /   &
         0.8038D+01,  0.8503D+01,  0.8874D+01,  0.8862D+01,   &
         0.8740D+01,  0.8638D+01,  0.8702D+01,  0.8948D+01,   &
         0.8989D+01,  0.8816D+01,  0.8349D+01,  0.8046D+01   &
         /
       data (OREF(20,14, mtmp), mtmp=1,12)   &
         /   &
         0.7458D+01,  0.7821D+01,  0.8670D+01,  0.8769D+01,   &
         0.8482D+01,  0.8243D+01,  0.8236D+01,  0.8475D+01,   &
         0.8524D+01,  0.8214D+01,  0.7661D+01,  0.7518D+01   &
         /
       data (OREF(20,15, mtmp), mtmp=1,12)   &
         /   &
         0.6829D+01,  0.7180D+01,  0.8042D+01,  0.8425D+01,   &
         0.8123D+01,  0.7753D+01,  0.7669D+01,  0.7916D+01,   &
         0.7997D+01,  0.7550D+01,  0.6990D+01,  0.6715D+01   &
         /
       data (OREF(20,16, mtmp), mtmp=1,12)   &
         /   &
         0.6795D+01,  0.6936D+01,  0.7343D+01,  0.7892D+01,   &
         0.7499D+01,  0.7014D+01,  0.6871D+01,  0.7137D+01,   &
         0.7170D+01,  0.6798D+01,  0.6700D+01,  0.6645D+01   &
         /
       data (OREF(20,17, mtmp), mtmp=1,12)   &
         /   &
         0.6795D+01,  0.7241D+01,  0.7183D+01,  0.7019D+01,   &
         0.6733D+01,  0.6539D+01,  0.6285D+01,  0.6044D+01,   &
         0.5858D+01,  0.5928D+01,  0.6700D+01,  0.6645D+01   &
         /
       data (OREF(20,18, mtmp), mtmp=1,12)   &
         /   &
         0.6795D+01,  0.7241D+01,  0.7183D+01,  0.7019D+01,   &
         0.6733D+01,  0.6539D+01,  0.6285D+01,  0.6044D+01,   &
         0.5858D+01,  0.5928D+01,  0.6700D+01,  0.6645D+01   &
         /
       data (OREF(21, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5940D+01,  0.6155D+01,  0.6101D+01,  0.5930D+01,   &
         0.6850D+01,  0.6823D+01,  0.6678D+01,  0.5806D+01,   &
         0.6073D+01,  0.6638D+01,  0.6448D+01,  0.6111D+01   &
         /
       data (OREF(21, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5940D+01,  0.6155D+01,  0.6101D+01,  0.5930D+01,   &
         0.6850D+01,  0.6823D+01,  0.6678D+01,  0.5806D+01,   &
         0.6073D+01,  0.6638D+01,  0.6448D+01,  0.6111D+01   &
         /
       data (OREF(21, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6268D+01,  0.6792D+01,  0.7299D+01,  0.7005D+01,   &
         0.6850D+01,  0.6823D+01,  0.6678D+01,  0.6342D+01,   &
         0.7111D+01,  0.7319D+01,  0.6835D+01,  0.6299D+01   &
         /
       data (OREF(21, 4, mtmp), mtmp=1,12)   &
         /   &
         0.6756D+01,  0.7180D+01,  0.7794D+01,  0.8027D+01,   &
         0.7567D+01,  0.6978D+01,  0.7179D+01,  0.7784D+01,   &
         0.8148D+01,  0.7959D+01,  0.7357D+01,  0.6727D+01   &
         /
       data (OREF(21, 5, mtmp), mtmp=1,12)   &
         /   &
         0.7178D+01,  0.7478D+01,  0.7969D+01,  0.8341D+01,   &
         0.8398D+01,  0.8192D+01,  0.8234D+01,  0.8686D+01,   &
         0.8682D+01,  0.8375D+01,  0.7739D+01,  0.7122D+01   &
         /
       data (OREF(21, 6, mtmp), mtmp=1,12)   &
         /   &
         0.7651D+01,  0.7846D+01,  0.8117D+01,  0.8397D+01,   &
         0.8575D+01,  0.8436D+01,  0.8294D+01,  0.8573D+01,   &
         0.8728D+01,  0.8509D+01,  0.7944D+01,  0.7541D+01   &
         /
       data (OREF(21, 7, mtmp), mtmp=1,12)   &
         /   &
         0.8141D+01,  0.8176D+01,  0.8195D+01,  0.8254D+01,   &
         0.8311D+01,  0.8110D+01,  0.8132D+01,  0.8375D+01,   &
         0.8557D+01,  0.8431D+01,  0.8057D+01,  0.7936D+01   &
         /
       data (OREF(21, 8, mtmp), mtmp=1,12)   &
         /   &
         0.8556D+01,  0.8387D+01,  0.7969D+01,  0.7834D+01,   &
         0.7864D+01,  0.7934D+01,  0.8107D+01,  0.8213D+01,   &
         0.8283D+01,  0.8233D+01,  0.8102D+01,  0.8251D+01   &
         /
       data (OREF(21, 9, mtmp), mtmp=1,12)   &
         /   &
         0.8630D+01,  0.8392D+01,  0.7703D+01,  0.7516D+01,   &
         0.7676D+01,  0.7924D+01,  0.8139D+01,  0.8084D+01,   &
         0.8031D+01,  0.7975D+01,  0.7949D+01,  0.8235D+01   &
         /
       data (OREF(21,10, mtmp), mtmp=1,12)   &
         /   &
         0.8499D+01,  0.8289D+01,  0.7693D+01,  0.7559D+01,   &
         0.7709D+01,  0.7951D+01,  0.8146D+01,  0.8082D+01,   &
         0.8016D+01,  0.7886D+01,  0.7804D+01,  0.8073D+01   &
         /
       data (OREF(21,11, mtmp), mtmp=1,12)   &
         /   &
         0.8330D+01,  0.8243D+01,  0.7892D+01,  0.7822D+01,   &
         0.7874D+01,  0.8022D+01,  0.8237D+01,  0.8249D+01,   &
         0.8213D+01,  0.8059D+01,  0.7843D+01,  0.7953D+01   &
         /
       data (OREF(21,12, mtmp), mtmp=1,12)   &
         /   &
         0.8184D+01,  0.8298D+01,  0.8124D+01,  0.8002D+01,   &
         0.7909D+01,  0.7956D+01,  0.8191D+01,  0.8360D+01,   &
         0.8387D+01,  0.8292D+01,  0.8048D+01,  0.7869D+01   &
         /
       data (OREF(21,13, mtmp), mtmp=1,12)   &
         /   &
         0.7944D+01,  0.8350D+01,  0.8411D+01,  0.8116D+01,   &
         0.7824D+01,  0.7725D+01,  0.7883D+01,  0.8123D+01,   &
         0.8262D+01,  0.8341D+01,  0.8249D+01,  0.7939D+01   &
         /
       data (OREF(21,14, mtmp), mtmp=1,12)   &
         /   &
         0.7539D+01,  0.7918D+01,  0.8586D+01,  0.8194D+01,   &
         0.7650D+01,  0.7390D+01,  0.7465D+01,  0.7739D+01,   &
         0.8047D+01,  0.8161D+01,  0.8006D+01,  0.7796D+01   &
         /
       data (OREF(21,15, mtmp), mtmp=1,12)   &
         /   &
         0.6814D+01,  0.7225D+01,  0.8218D+01,  0.8133D+01,   &
         0.7424D+01,  0.6980D+01,  0.6958D+01,  0.7328D+01,   &
         0.7793D+01,  0.7730D+01,  0.7364D+01,  0.6904D+01   &
         /
       data (OREF(21,16, mtmp), mtmp=1,12)   &
         /   &
         0.6601D+01,  0.6721D+01,  0.7517D+01,  0.7867D+01,   &
         0.7033D+01,  0.6436D+01,  0.6345D+01,  0.6820D+01,   &
         0.7277D+01,  0.7073D+01,  0.6908D+01,  0.6684D+01   &
         /
       data (OREF(21,17, mtmp), mtmp=1,12)   &
         /   &
         0.6601D+01,  0.6886D+01,  0.7100D+01,  0.7076D+01,   &
         0.6586D+01,  0.6186D+01,  0.5991D+01,  0.6059D+01,   &
         0.6087D+01,  0.6169D+01,  0.6908D+01,  0.6684D+01   &
         /
       data (OREF(21,18, mtmp), mtmp=1,12)   &
         /   &
         0.6601D+01,  0.6886D+01,  0.7100D+01,  0.7076D+01,   &
         0.6586D+01,  0.6186D+01,  0.5991D+01,  0.6059D+01,   &
         0.6087D+01,  0.6169D+01,  0.6908D+01,  0.6684D+01   &
         /
       data (OREF(22, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5094D+01,  0.5688D+01,  0.6286D+01,  0.6260D+01,   &
         0.7170D+01,  0.7024D+01,  0.6735D+01,  0.5610D+01,   &
         0.5857D+01,  0.5967D+01,  0.5653D+01,  0.5220D+01   &
         /
       data (OREF(22, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5094D+01,  0.5688D+01,  0.6286D+01,  0.6260D+01,   &
         0.7170D+01,  0.7024D+01,  0.6735D+01,  0.5610D+01,   &
         0.5857D+01,  0.5967D+01,  0.5653D+01,  0.5220D+01   &
         /
       data (OREF(22, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5288D+01,  0.5925D+01,  0.7013D+01,  0.7386D+01,   &
         0.7170D+01,  0.7024D+01,  0.6735D+01,  0.6214D+01,   &
         0.6604D+01,  0.6451D+01,  0.5871D+01,  0.5320D+01   &
         /
       data (OREF(22, 4, mtmp), mtmp=1,12)   &
         /   &
         0.5632D+01,  0.6110D+01,  0.7023D+01,  0.7936D+01,   &
         0.8082D+01,  0.7532D+01,  0.7597D+01,  0.7599D+01,   &
         0.7435D+01,  0.6957D+01,  0.6232D+01,  0.5601D+01   &
         /
       data (OREF(22, 5, mtmp), mtmp=1,12)   &
         /   &
         0.5959D+01,  0.6303D+01,  0.6932D+01,  0.7717D+01,   &
         0.8426D+01,  0.8503D+01,  0.8328D+01,  0.8241D+01,   &
         0.7844D+01,  0.7220D+01,  0.6461D+01,  0.5876D+01   &
         /
       data (OREF(22, 6, mtmp), mtmp=1,12)   &
         /   &
         0.6357D+01,  0.6598D+01,  0.6948D+01,  0.7413D+01,   &
         0.7951D+01,  0.7930D+01,  0.7729D+01,  0.7832D+01,   &
         0.7698D+01,  0.7192D+01,  0.6574D+01,  0.6218D+01   &
         /
       data (OREF(22, 7, mtmp), mtmp=1,12)   &
         /   &
         0.6765D+01,  0.6828D+01,  0.6894D+01,  0.7035D+01,   &
         0.7257D+01,  0.7200D+01,  0.7210D+01,  0.7343D+01,   &
         0.7318D+01,  0.7013D+01,  0.6667D+01,  0.6593D+01   &
         /
       data (OREF(22, 8, mtmp), mtmp=1,12)   &
         /   &
         0.7082D+01,  0.6895D+01,  0.6548D+01,  0.6521D+01,   &
         0.6661D+01,  0.6840D+01,  0.6978D+01,  0.6959D+01,   &
         0.6913D+01,  0.6796D+01,  0.6723D+01,  0.6894D+01   &
         /
       data (OREF(22, 9, mtmp), mtmp=1,12)   &
         /   &
         0.7165D+01,  0.6834D+01,  0.6247D+01,  0.6191D+01,   &
         0.6439D+01,  0.6723D+01,  0.6877D+01,  0.6731D+01,   &
         0.6628D+01,  0.6572D+01,  0.6625D+01,  0.6935D+01   &
         /
       data (OREF(22,10, mtmp), mtmp=1,12)   &
         /   &
         0.7142D+01,  0.6804D+01,  0.6269D+01,  0.6238D+01,   &
         0.6446D+01,  0.6694D+01,  0.6834D+01,  0.6694D+01,   &
         0.6604D+01,  0.6515D+01,  0.6542D+01,  0.6868D+01   &
         /
       data (OREF(22,11, mtmp), mtmp=1,12)   &
         /   &
         0.7130D+01,  0.6887D+01,  0.6548D+01,  0.6522D+01,   &
         0.6587D+01,  0.6750D+01,  0.6939D+01,  0.6893D+01,   &
         0.6837D+01,  0.6730D+01,  0.6643D+01,  0.6848D+01   &
         /
       data (OREF(22,12, mtmp), mtmp=1,12)   &
         /   &
         0.7224D+01,  0.7131D+01,  0.6903D+01,  0.6767D+01,   &
         0.6647D+01,  0.6711D+01,  0.6957D+01,  0.7078D+01,   &
         0.7085D+01,  0.7043D+01,  0.6983D+01,  0.6937D+01   &
         /
       data (OREF(22,13, mtmp), mtmp=1,12)   &
         /   &
         0.7330D+01,  0.7545D+01,  0.7310D+01,  0.6899D+01,   &
         0.6573D+01,  0.6507D+01,  0.6708D+01,  0.6916D+01,   &
         0.7101D+01,  0.7342D+01,  0.7556D+01,  0.7296D+01   &
         /
       data (OREF(22,14, mtmp), mtmp=1,12)   &
         /   &
         0.7250D+01,  0.7540D+01,  0.7728D+01,  0.6999D+01,   &
         0.6434D+01,  0.6217D+01,  0.6335D+01,  0.6588D+01,   &
         0.7054D+01,  0.7560D+01,  0.7932D+01,  0.7712D+01   &
         /
       data (OREF(22,15, mtmp), mtmp=1,12)   &
         /   &
         0.6636D+01,  0.7051D+01,  0.7782D+01,  0.7124D+01,   &
         0.6270D+01,  0.5870D+01,  0.5886D+01,  0.6257D+01,   &
         0.7019D+01,  0.7520D+01,  0.7617D+01,  0.7008D+01   &
         /
       data (OREF(22,16, mtmp), mtmp=1,12)   &
         /   &
         0.6189D+01,  0.6399D+01,  0.7410D+01,  0.7183D+01,   &
         0.6046D+01,  0.5464D+01,  0.5418D+01,  0.5934D+01,   &
         0.6855D+01,  0.7150D+01,  0.6992D+01,  0.6532D+01   &
         /
       data (OREF(22,17, mtmp), mtmp=1,12)   &
         /   &
         0.6189D+01,  0.6305D+01,  0.6866D+01,  0.6770D+01,   &
         0.5888D+01,  0.5332D+01,  0.5206D+01,  0.5498D+01,   &
         0.6025D+01,  0.6287D+01,  0.6992D+01,  0.6532D+01   &
         /
       data (OREF(22,18, mtmp), mtmp=1,12)   &
         /   &
         0.6189D+01,  0.6305D+01,  0.6866D+01,  0.6770D+01,   &
         0.5888D+01,  0.5332D+01,  0.5206D+01,  0.5498D+01,   &
         0.6025D+01,  0.6287D+01,  0.6992D+01,  0.6532D+01   &
         /
       data (OREF(23, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4074D+01,  0.4874D+01,  0.6180D+01,  0.6443D+01,   &
         0.7296D+01,  0.7036D+01,  0.6564D+01,  0.5325D+01,   &
         0.5392D+01,  0.5047D+01,  0.4656D+01,  0.4174D+01   &
         /
       data (OREF(23, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4074D+01,  0.4874D+01,  0.6180D+01,  0.6443D+01,   &
         0.7296D+01,  0.7036D+01,  0.6564D+01,  0.5325D+01,   &
         0.5392D+01,  0.5047D+01,  0.4656D+01,  0.4174D+01   &
         /
       data (OREF(23, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4216D+01,  0.4832D+01,  0.6270D+01,  0.7427D+01,   &
         0.7296D+01,  0.7036D+01,  0.6564D+01,  0.5836D+01,   &
         0.5757D+01,  0.5343D+01,  0.4753D+01,  0.4257D+01   &
         /
       data (OREF(23, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4484D+01,  0.4920D+01,  0.5912D+01,  0.7364D+01,   &
         0.8326D+01,  0.7961D+01,  0.7730D+01,  0.6937D+01,   &
         0.6347D+01,  0.5706D+01,  0.4991D+01,  0.4466D+01   &
         /
       data (OREF(23, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4758D+01,  0.5078D+01,  0.5691D+01,  0.6698D+01,   &
         0.7987D+01,  0.8392D+01,  0.7953D+01,  0.7303D+01,   &
         0.6631D+01,  0.5832D+01,  0.5127D+01,  0.4677D+01   &
         /
       data (OREF(23, 6, mtmp), mtmp=1,12)   &
         /   &
         0.5078D+01,  0.5313D+01,  0.5640D+01,  0.6156D+01,   &
         0.6909D+01,  0.7006D+01,  0.6778D+01,  0.6727D+01,   &
         0.6371D+01,  0.5721D+01,  0.5201D+01,  0.4950D+01   &
         /
       data (OREF(23, 7, mtmp), mtmp=1,12)   &
         /   &
         0.5379D+01,  0.5456D+01,  0.5525D+01,  0.5691D+01,   &
         0.5984D+01,  0.6033D+01,  0.6034D+01,  0.6083D+01,   &
         0.5914D+01,  0.5538D+01,  0.5290D+01,  0.5259D+01   &
         /
       data (OREF(23, 8, mtmp), mtmp=1,12)   &
         /   &
         0.5586D+01,  0.5429D+01,  0.5197D+01,  0.5235D+01,   &
         0.5414D+01,  0.5618D+01,  0.5702D+01,  0.5619D+01,   &
         0.5516D+01,  0.5377D+01,  0.5356D+01,  0.5513D+01   &
         /
       data (OREF(23, 9, mtmp), mtmp=1,12)   &
         /   &
         0.5657D+01,  0.5342D+01,  0.4949D+01,  0.4976D+01,   &
         0.5226D+01,  0.5468D+01,  0.5550D+01,  0.5381D+01,   &
         0.5280D+01,  0.5235D+01,  0.5322D+01,  0.5595D+01   &
         /
       data (OREF(23,10, mtmp), mtmp=1,12)   &
         /   &
         0.5687D+01,  0.5347D+01,  0.4977D+01,  0.5010D+01,   &
         0.5214D+01,  0.5418D+01,  0.5497D+01,  0.5342D+01,   &
         0.5267D+01,  0.5216D+01,  0.5293D+01,  0.5590D+01   &
         /
       data (OREF(23,11, mtmp), mtmp=1,12)   &
         /   &
         0.5741D+01,  0.5472D+01,  0.5227D+01,  0.5236D+01,   &
         0.5305D+01,  0.5454D+01,  0.5597D+01,  0.5528D+01,   &
         0.5473D+01,  0.5407D+01,  0.5389D+01,  0.5602D+01   &
         /
       data (OREF(23,12, mtmp), mtmp=1,12)   &
         /   &
         0.5967D+01,  0.5768D+01,  0.5571D+01,  0.5460D+01,   &
         0.5354D+01,  0.5427D+01,  0.5644D+01,  0.5719D+01,   &
         0.5711D+01,  0.5697D+01,  0.5726D+01,  0.5766D+01   &
         /
       data (OREF(23,13, mtmp), mtmp=1,12)   &
         /   &
         0.6345D+01,  0.6353D+01,  0.5944D+01,  0.5550D+01,   &
         0.5276D+01,  0.5247D+01,  0.5450D+01,  0.5616D+01,   &
         0.5795D+01,  0.6092D+01,  0.6464D+01,  0.6282D+01   &
         /
       data (OREF(23,14, mtmp), mtmp=1,12)   &
         /   &
         0.6581D+01,  0.6735D+01,  0.6430D+01,  0.5593D+01,   &
         0.5145D+01,  0.4997D+01,  0.5123D+01,  0.5330D+01,   &
         0.5833D+01,  0.6565D+01,  0.7342D+01,  0.7152D+01   &
         /
       data (OREF(23,15, mtmp), mtmp=1,12)   &
         /   &
         0.6203D+01,  0.6570D+01,  0.6841D+01,  0.5789D+01,   &
         0.5003D+01,  0.4702D+01,  0.4734D+01,  0.5039D+01,   &
         0.5923D+01,  0.6893D+01,  0.7478D+01,  0.6811D+01   &
         /
       data (OREF(23,16, mtmp), mtmp=1,12)   &
         /   &
         0.5588D+01,  0.5923D+01,  0.6909D+01,  0.6082D+01,   &
         0.4874D+01,  0.4387D+01,  0.4372D+01,  0.4822D+01,   &
         0.6030D+01,  0.6871D+01,  0.6804D+01,  0.6121D+01   &
         /
       data (OREF(23,17, mtmp), mtmp=1,12)   &
         /   &
         0.5588D+01,  0.5581D+01,  0.6416D+01,  0.6106D+01,   &
         0.4903D+01,  0.4292D+01,  0.4225D+01,  0.4621D+01,   &
         0.5631D+01,  0.6167D+01,  0.6804D+01,  0.6121D+01   &
         /
       data (OREF(23,18, mtmp), mtmp=1,12)   &
         /   &
         0.5588D+01,  0.5581D+01,  0.6416D+01,  0.6106D+01,   &
         0.4903D+01,  0.4292D+01,  0.4225D+01,  0.4621D+01,   &
         0.5631D+01,  0.6167D+01,  0.6804D+01,  0.6121D+01   &
         /
       data (OREF(24, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3169D+01,  0.3893D+01,  0.5441D+01,  0.6177D+01,   &
         0.6888D+01,  0.6636D+01,  0.5880D+01,  0.4759D+01,   &
         0.4609D+01,  0.4093D+01,  0.3680D+01,  0.3257D+01   &
         /
       data (OREF(24, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3169D+01,  0.3893D+01,  0.5441D+01,  0.6177D+01,   &
         0.6888D+01,  0.6636D+01,  0.5880D+01,  0.4759D+01,   &
         0.4609D+01,  0.4093D+01,  0.3680D+01,  0.3257D+01   &
         /
       data (OREF(24, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3311D+01,  0.3801D+01,  0.5095D+01,  0.6573D+01,   &
         0.6888D+01,  0.6636D+01,  0.5880D+01,  0.5034D+01,   &
         0.4692D+01,  0.4272D+01,  0.3743D+01,  0.3359D+01   &
         /
       data (OREF(24, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3535D+01,  0.3878D+01,  0.4697D+01,  0.6106D+01,   &
         0.7509D+01,  0.7473D+01,  0.6872D+01,  0.5742D+01,   &
         0.5105D+01,  0.4527D+01,  0.3913D+01,  0.3532D+01   &
         /
       data (OREF(24, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3771D+01,  0.4031D+01,  0.4507D+01,  0.5393D+01,   &
         0.6705D+01,  0.7206D+01,  0.6700D+01,  0.5973D+01,   &
         0.5316D+01,  0.4582D+01,  0.4011D+01,  0.3710D+01   &
         /
       data (OREF(24, 6, mtmp), mtmp=1,12)   &
         /   &
         0.4021D+01,  0.4216D+01,  0.4453D+01,  0.4872D+01,   &
         0.5548D+01,  0.5679D+01,  0.5514D+01,  0.5453D+01,   &
         0.5061D+01,  0.4462D+01,  0.4077D+01,  0.3923D+01   &
         /
       data (OREF(24, 7, mtmp), mtmp=1,12)   &
         /   &
         0.4223D+01,  0.4297D+01,  0.4338D+01,  0.4476D+01,   &
         0.4739D+01,  0.4821D+01,  0.4828D+01,  0.4861D+01,   &
         0.4660D+01,  0.4325D+01,  0.4159D+01,  0.4155D+01   &
         /
       data (OREF(24, 8, mtmp), mtmp=1,12)   &
         /   &
         0.4334D+01,  0.4224D+01,  0.4094D+01,  0.4158D+01,   &
         0.4320D+01,  0.4485D+01,  0.4525D+01,  0.4466D+01,   &
         0.4359D+01,  0.4236D+01,  0.4224D+01,  0.4345D+01   &
         /
       data (OREF(24, 9, mtmp), mtmp=1,12)   &
         /   &
         0.4375D+01,  0.4134D+01,  0.3928D+01,  0.3993D+01,   &
         0.4195D+01,  0.4364D+01,  0.4390D+01,  0.4277D+01,   &
         0.4203D+01,  0.4168D+01,  0.4233D+01,  0.4433D+01   &
         /
       data (OREF(24,10, mtmp), mtmp=1,12)   &
         /   &
         0.4406D+01,  0.4149D+01,  0.3950D+01,  0.4012D+01,   &
         0.4180D+01,  0.4321D+01,  0.4354D+01,  0.4251D+01,   &
         0.4201D+01,  0.4172D+01,  0.4231D+01,  0.4447D+01   &
         /
       data (OREF(24,11, mtmp), mtmp=1,12)   &
         /   &
         0.4452D+01,  0.4261D+01,  0.4133D+01,  0.4162D+01,   &
         0.4230D+01,  0.4349D+01,  0.4441D+01,  0.4393D+01,   &
         0.4342D+01,  0.4298D+01,  0.4282D+01,  0.4440D+01   &
         /
       data (OREF(24,12, mtmp), mtmp=1,12)   &
         /   &
         0.4668D+01,  0.4499D+01,  0.4389D+01,  0.4324D+01,   &
         0.4255D+01,  0.4328D+01,  0.4493D+01,  0.4547D+01,   &
         0.4515D+01,  0.4490D+01,  0.4512D+01,  0.4574D+01   &
         /
       data (OREF(24,13, mtmp), mtmp=1,12)   &
         /   &
         0.5090D+01,  0.5006D+01,  0.4634D+01,  0.4357D+01,   &
         0.4171D+01,  0.4173D+01,  0.4345D+01,  0.4489D+01,   &
         0.4598D+01,  0.4818D+01,  0.5128D+01,  0.5025D+01   &
         /
       data (OREF(24,14, mtmp), mtmp=1,12)   &
         /   &
         0.5431D+01,  0.5483D+01,  0.4998D+01,  0.4326D+01,   &
         0.4042D+01,  0.3958D+01,  0.4068D+01,  0.4246D+01,   &
         0.4638D+01,  0.5295D+01,  0.6021D+01,  0.5879D+01   &
         /
       data (OREF(24,15, mtmp), mtmp=1,12)   &
         /   &
         0.5293D+01,  0.5550D+01,  0.5459D+01,  0.4477D+01,   &
         0.3905D+01,  0.3710D+01,  0.3741D+01,  0.3987D+01,   &
         0.4736D+01,  0.5741D+01,  0.6424D+01,  0.5880D+01   &
         /
       data (OREF(24,16, mtmp), mtmp=1,12)   &
         /   &
         0.4807D+01,  0.5164D+01,  0.5762D+01,  0.4787D+01,   &
         0.3810D+01,  0.3460D+01,  0.3455D+01,  0.3817D+01,   &
         0.4915D+01,  0.5917D+01,  0.6070D+01,  0.5298D+01   &
         /
       data (OREF(24,17, mtmp), mtmp=1,12)   &
         /   &
         0.4807D+01,  0.4842D+01,  0.5592D+01,  0.5009D+01,   &
         0.3868D+01,  0.3351D+01,  0.3310D+01,  0.3714D+01,   &
         0.4793D+01,  0.5611D+01,  0.6070D+01,  0.5298D+01   &
         /
       data (OREF(24,18, mtmp), mtmp=1,12)   &
         /   &
         0.4807D+01,  0.4842D+01,  0.5592D+01,  0.5009D+01,   &
         0.3868D+01,  0.3351D+01,  0.3310D+01,  0.3714D+01,   &
         0.4793D+01,  0.5611D+01,  0.6070D+01,  0.5298D+01   &
         /
       data (OREF(25, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2449D+01,  0.2952D+01,  0.4313D+01,  0.5453D+01,   &
         0.5977D+01,  0.5827D+01,  0.4831D+01,  0.3985D+01,   &
         0.3676D+01,  0.3229D+01,  0.2839D+01,  0.2533D+01   &
         /
       data (OREF(25, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2449D+01,  0.2952D+01,  0.4313D+01,  0.5453D+01,   &
         0.5977D+01,  0.5827D+01,  0.4831D+01,  0.3985D+01,   &
         0.3676D+01,  0.3229D+01,  0.2839D+01,  0.2533D+01   &
         /
       data (OREF(25, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2612D+01,  0.2941D+01,  0.3822D+01,  0.5155D+01,   &
         0.5977D+01,  0.5827D+01,  0.4831D+01,  0.4005D+01,   &
         0.3624D+01,  0.3351D+01,  0.2918D+01,  0.2661D+01   &
         /
       data (OREF(25, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2805D+01,  0.3045D+01,  0.3582D+01,  0.4584D+01,   &
         0.5951D+01,  0.6195D+01,  0.5367D+01,  0.4367D+01,   &
         0.3929D+01,  0.3536D+01,  0.3058D+01,  0.2816D+01   &
         /
       data (OREF(25, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3010D+01,  0.3200D+01,  0.3497D+01,  0.4084D+01,   &
         0.5046D+01,  0.5442D+01,  0.5041D+01,  0.4572D+01,   &
         0.4106D+01,  0.3568D+01,  0.3147D+01,  0.2973D+01   &
         /
       data (OREF(25, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3201D+01,  0.3344D+01,  0.3473D+01,  0.3731D+01,   &
         0.4176D+01,  0.4279D+01,  0.4212D+01,  0.4226D+01,   &
         0.3921D+01,  0.3478D+01,  0.3216D+01,  0.3138D+01   &
         /
       data (OREF(25, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3323D+01,  0.3385D+01,  0.3387D+01,  0.3476D+01,   &
         0.3658D+01,  0.3726D+01,  0.3746D+01,  0.3800D+01,   &
         0.3638D+01,  0.3402D+01,  0.3289D+01,  0.3297D+01   &
         /
       data (OREF(25, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3361D+01,  0.3295D+01,  0.3242D+01,  0.3306D+01,   &
         0.3427D+01,  0.3528D+01,  0.3537D+01,  0.3545D+01,   &
         0.3464D+01,  0.3375D+01,  0.3345D+01,  0.3424D+01   &
         /
       data (OREF(25, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3365D+01,  0.3214D+01,  0.3155D+01,  0.3228D+01,   &
         0.3369D+01,  0.3461D+01,  0.3452D+01,  0.3429D+01,   &
         0.3390D+01,  0.3362D+01,  0.3375D+01,  0.3496D+01   &
         /
       data (OREF(25,10, mtmp), mtmp=1,12)   &
         /   &
         0.3375D+01,  0.3224D+01,  0.3168D+01,  0.3235D+01,   &
         0.3358D+01,  0.3440D+01,  0.3442D+01,  0.3418D+01,   &
         0.3394D+01,  0.3373D+01,  0.3381D+01,  0.3504D+01   &
         /
       data (OREF(25,11, mtmp), mtmp=1,12)   &
         /   &
         0.3381D+01,  0.3304D+01,  0.3279D+01,  0.3319D+01,   &
         0.3383D+01,  0.3468D+01,  0.3516D+01,  0.3507D+01,   &
         0.3460D+01,  0.3424D+01,  0.3377D+01,  0.3459D+01   &
         /
       data (OREF(25,12, mtmp), mtmp=1,12)   &
         /   &
         0.3517D+01,  0.3442D+01,  0.3429D+01,  0.3411D+01,   &
         0.3383D+01,  0.3451D+01,  0.3561D+01,  0.3609D+01,   &
         0.3551D+01,  0.3495D+01,  0.3469D+01,  0.3514D+01   &
         /
       data (OREF(25,13, mtmp), mtmp=1,12)   &
         /   &
         0.3838D+01,  0.3754D+01,  0.3527D+01,  0.3395D+01,   &
         0.3298D+01,  0.3319D+01,  0.3450D+01,  0.3583D+01,   &
         0.3596D+01,  0.3684D+01,  0.3831D+01,  0.3789D+01   &
         /
       data (OREF(25,14, mtmp), mtmp=1,12)   &
         /   &
         0.4122D+01,  0.4123D+01,  0.3702D+01,  0.3303D+01,   &
         0.3172D+01,  0.3136D+01,  0.3221D+01,  0.3383D+01,   &
         0.3600D+01,  0.4021D+01,  0.4444D+01,  0.4344D+01   &
         /
       data (OREF(25,15, mtmp), mtmp=1,12)   &
         /   &
         0.4141D+01,  0.4282D+01,  0.4023D+01,  0.3362D+01,   &
         0.3037D+01,  0.2932D+01,  0.2954D+01,  0.3155D+01,   &
         0.3642D+01,  0.4391D+01,  0.4881D+01,  0.4538D+01   &
         /
       data (OREF(25,16, mtmp), mtmp=1,12)   &
         /   &
         0.3949D+01,  0.4237D+01,  0.4345D+01,  0.3564D+01,   &
         0.2944D+01,  0.2729D+01,  0.2724D+01,  0.3004D+01,   &
         0.3763D+01,  0.4600D+01,  0.4961D+01,  0.4247D+01   &
         /
       data (OREF(25,17, mtmp), mtmp=1,12)   &
         /   &
         0.3949D+01,  0.4127D+01,  0.4548D+01,  0.3781D+01,   &
         0.2944D+01,  0.2591D+01,  0.2555D+01,  0.2911D+01,   &
         0.3750D+01,  0.4721D+01,  0.4961D+01,  0.4247D+01   &
         /
       data (OREF(25,18, mtmp), mtmp=1,12)   &
         /   &
         0.3949D+01,  0.4127D+01,  0.4548D+01,  0.3781D+01,   &
         0.2944D+01,  0.2591D+01,  0.2555D+01,  0.2911D+01,   &
         0.3750D+01,  0.4721D+01,  0.4961D+01,  0.4247D+01   &
         /
       data (OREF(26, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1907D+01,  0.2218D+01,  0.3250D+01,  0.4424D+01,   &
         0.4781D+01,  0.4713D+01,  0.3741D+01,  0.3195D+01,   &
         0.2834D+01,  0.2534D+01,  0.2189D+01,  0.1984D+01   &
         /
       data (OREF(26, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1907D+01,  0.2218D+01,  0.3250D+01,  0.4424D+01,   &
         0.4781D+01,  0.4713D+01,  0.3741D+01,  0.3195D+01,   &
         0.2834D+01,  0.2534D+01,  0.2189D+01,  0.1984D+01   &
         /
       data (OREF(26, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2079D+01,  0.2283D+01,  0.2809D+01,  0.3822D+01,   &
         0.4781D+01,  0.4713D+01,  0.3741D+01,  0.3070D+01,   &
         0.2755D+01,  0.2624D+01,  0.2285D+01,  0.2127D+01   &
         /
       data (OREF(26, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2244D+01,  0.2405D+01,  0.2716D+01,  0.3340D+01,   &
         0.4420D+01,  0.4721D+01,  0.3936D+01,  0.3223D+01,   &
         0.2987D+01,  0.2755D+01,  0.2405D+01,  0.2264D+01   &
         /
       data (OREF(26, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2419D+01,  0.2555D+01,  0.2714D+01,  0.3051D+01,   &
         0.3665D+01,  0.3921D+01,  0.3652D+01,  0.3414D+01,   &
         0.3134D+01,  0.2777D+01,  0.2488D+01,  0.2400D+01   &
         /
       data (OREF(26, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2565D+01,  0.2668D+01,  0.2717D+01,  0.2847D+01,   &
         0.3098D+01,  0.3164D+01,  0.3169D+01,  0.3220D+01,   &
         0.3015D+01,  0.2721D+01,  0.2557D+01,  0.2528D+01   &
         /
       data (OREF(26, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2633D+01,  0.2682D+01,  0.2657D+01,  0.2707D+01,   &
         0.2820D+01,  0.2867D+01,  0.2897D+01,  0.2950D+01,   &
         0.2838D+01,  0.2691D+01,  0.2619D+01,  0.2634D+01   &
         /
       data (OREF(26, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2622D+01,  0.2588D+01,  0.2583D+01,  0.2642D+01,   &
         0.2727D+01,  0.2778D+01,  0.2769D+01,  0.2815D+01,   &
         0.2763D+01,  0.2705D+01,  0.2665D+01,  0.2714D+01   &
         /
       data (OREF(26, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2602D+01,  0.2516D+01,  0.2550D+01,  0.2623D+01,   &
         0.2716D+01,  0.2754D+01,  0.2726D+01,  0.2761D+01,   &
         0.2749D+01,  0.2727D+01,  0.2706D+01,  0.2769D+01   &
         /
       data (OREF(26,10, mtmp), mtmp=1,12)   &
         /   &
         0.2595D+01,  0.2522D+01,  0.2556D+01,  0.2623D+01,   &
         0.2710D+01,  0.2750D+01,  0.2734D+01,  0.2762D+01,   &
         0.2756D+01,  0.2739D+01,  0.2713D+01,  0.2768D+01   &
         /
       data (OREF(26,11, mtmp), mtmp=1,12)   &
         /   &
         0.2574D+01,  0.2575D+01,  0.2618D+01,  0.2662D+01,   &
         0.2721D+01,  0.2780D+01,  0.2797D+01,  0.2808D+01,   &
         0.2766D+01,  0.2734D+01,  0.2672D+01,  0.2697D+01   &
         /
       data (OREF(26,12, mtmp), mtmp=1,12)   &
         /   &
         0.2641D+01,  0.2639D+01,  0.2690D+01,  0.2706D+01,   &
         0.2707D+01,  0.2767D+01,  0.2836D+01,  0.2867D+01,   &
         0.2793D+01,  0.2719D+01,  0.2665D+01,  0.2691D+01   &
         /
       data (OREF(26,13, mtmp), mtmp=1,12)   &
         /   &
         0.2857D+01,  0.2796D+01,  0.2689D+01,  0.2659D+01,   &
         0.2625D+01,  0.2657D+01,  0.2754D+01,  0.2859D+01,   &
         0.2804D+01,  0.2794D+01,  0.2831D+01,  0.2822D+01   &
         /
       data (OREF(26,14, mtmp), mtmp=1,12)   &
         /   &
         0.3055D+01,  0.3041D+01,  0.2728D+01,  0.2534D+01,   &
         0.2508D+01,  0.2503D+01,  0.2566D+01,  0.2700D+01,   &
         0.2777D+01,  0.2994D+01,  0.3185D+01,  0.3111D+01   &
         /
       data (OREF(26,15, mtmp), mtmp=1,12)   &
         /   &
         0.3125D+01,  0.3204D+01,  0.2913D+01,  0.2526D+01,   &
         0.2379D+01,  0.2335D+01,  0.2350D+01,  0.2505D+01,   &
         0.2769D+01,  0.3250D+01,  0.3535D+01,  0.3329D+01   &
         /
       data (OREF(26,16, mtmp), mtmp=1,12)   &
         /   &
         0.3136D+01,  0.3346D+01,  0.3172D+01,  0.2630D+01,   &
         0.2286D+01,  0.2171D+01,  0.2164D+01,  0.2368D+01,   &
         0.2819D+01,  0.3412D+01,  0.3811D+01,  0.3251D+01   &
         /
       data (OREF(26,17, mtmp), mtmp=1,12)   &
         /   &
         0.3136D+01,  0.3405D+01,  0.3539D+01,  0.2783D+01,   &
         0.2234D+01,  0.2014D+01,  0.1980D+01,  0.2267D+01,   &
         0.2825D+01,  0.3723D+01,  0.3811D+01,  0.3251D+01   &
         /
       data (OREF(26,18, mtmp), mtmp=1,12)   &
         /   &
         0.3136D+01,  0.3405D+01,  0.3539D+01,  0.2783D+01,   &
         0.2234D+01,  0.2014D+01,  0.1980D+01,  0.2267D+01,   &
         0.2825D+01,  0.3723D+01,  0.3811D+01,  0.3251D+01   &
         /
       data (OREF(27, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1524D+01,  0.1746D+01,  0.2456D+01,  0.3283D+01,   &
         0.3528D+01,  0.3472D+01,  0.2794D+01,  0.2505D+01,   &
         0.2193D+01,  0.2034D+01,  0.1740D+01,  0.1590D+01   &
         /
       data (OREF(27, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1524D+01,  0.1746D+01,  0.2456D+01,  0.3283D+01,   &
         0.3528D+01,  0.3472D+01,  0.2794D+01,  0.2505D+01,   &
         0.2193D+01,  0.2034D+01,  0.1740D+01,  0.1590D+01   &
         /
       data (OREF(27, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1684D+01,  0.1826D+01,  0.2177D+01,  0.2853D+01,   &
         0.3528D+01,  0.3472D+01,  0.2794D+01,  0.2374D+01,   &
         0.2160D+01,  0.2094D+01,  0.1834D+01,  0.1728D+01   &
         /
       data (OREF(27, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1816D+01,  0.1936D+01,  0.2143D+01,  0.2560D+01,   &
         0.3262D+01,  0.3413D+01,  0.2885D+01,  0.2453D+01,   &
         0.2335D+01,  0.2177D+01,  0.1930D+01,  0.1838D+01   &
         /
       data (OREF(27, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1960D+01,  0.2066D+01,  0.2165D+01,  0.2387D+01,   &
         0.2797D+01,  0.2938D+01,  0.2775D+01,  0.2608D+01,   &
         0.2437D+01,  0.2185D+01,  0.1995D+01,  0.1947D+01   &
         /
       data (OREF(27, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2073D+01,  0.2156D+01,  0.2174D+01,  0.2250D+01,   &
         0.2413D+01,  0.2456D+01,  0.2493D+01,  0.2490D+01,   &
         0.2350D+01,  0.2146D+01,  0.2052D+01,  0.2046D+01   &
         /
       data (OREF(27, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2112D+01,  0.2156D+01,  0.2124D+01,  0.2156D+01,   &
         0.2240D+01,  0.2282D+01,  0.2314D+01,  0.2313D+01,   &
         0.2233D+01,  0.2139D+01,  0.2105D+01,  0.2126D+01   &
         /
       data (OREF(27, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2079D+01,  0.2057D+01,  0.2073D+01,  0.2132D+01,   &
         0.2202D+01,  0.2237D+01,  0.2220D+01,  0.2239D+01,   &
         0.2205D+01,  0.2169D+01,  0.2145D+01,  0.2181D+01   &
         /
       data (OREF(27, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2051D+01,  0.1990D+01,  0.2060D+01,  0.2136D+01,   &
         0.2210D+01,  0.2227D+01,  0.2189D+01,  0.2221D+01,   &
         0.2220D+01,  0.2203D+01,  0.2189D+01,  0.2229D+01   &
         /
       data (OREF(27,10, mtmp), mtmp=1,12)   &
         /   &
         0.2044D+01,  0.1997D+01,  0.2066D+01,  0.2134D+01,   &
         0.2206D+01,  0.2227D+01,  0.2201D+01,  0.2227D+01,   &
         0.2229D+01,  0.2217D+01,  0.2200D+01,  0.2229D+01   &
         /
       data (OREF(27,11, mtmp), mtmp=1,12)   &
         /   &
         0.2022D+01,  0.2044D+01,  0.2111D+01,  0.2157D+01,   &
         0.2210D+01,  0.2256D+01,  0.2259D+01,  0.2250D+01,   &
         0.2216D+01,  0.2192D+01,  0.2150D+01,  0.2158D+01   &
         /
       data (OREF(27,12, mtmp), mtmp=1,12)   &
         /   &
         0.2067D+01,  0.2085D+01,  0.2157D+01,  0.2184D+01,   &
         0.2195D+01,  0.2250D+01,  0.2299D+01,  0.2285D+01,   &
         0.2213D+01,  0.2144D+01,  0.2111D+01,  0.2135D+01   &
         /
       data (OREF(27,13, mtmp), mtmp=1,12)   &
         /   &
         0.2236D+01,  0.2186D+01,  0.2124D+01,  0.2132D+01,   &
         0.2122D+01,  0.2158D+01,  0.2239D+01,  0.2286D+01,   &
         0.2210D+01,  0.2169D+01,  0.2199D+01,  0.2204D+01   &
         /
       data (OREF(27,14, mtmp), mtmp=1,12)   &
         /   &
         0.2377D+01,  0.2372D+01,  0.2116D+01,  0.2004D+01,   &
         0.2019D+01,  0.2029D+01,  0.2083D+01,  0.2161D+01,   &
         0.2177D+01,  0.2292D+01,  0.2425D+01,  0.2352D+01   &
         /
       data (OREF(27,15, mtmp), mtmp=1,12)   &
         /   &
         0.2402D+01,  0.2492D+01,  0.2238D+01,  0.1977D+01,   &
         0.1904D+01,  0.1890D+01,  0.1904D+01,  0.2002D+01,   &
         0.2150D+01,  0.2463D+01,  0.2637D+01,  0.2468D+01   &
         /
       data (OREF(27,16, mtmp), mtmp=1,12)   &
         /   &
         0.2435D+01,  0.2598D+01,  0.2422D+01,  0.2039D+01,   &
         0.1825D+01,  0.1760D+01,  0.1755D+01,  0.1887D+01,   &
         0.2163D+01,  0.2551D+01,  0.2814D+01,  0.2447D+01   &
         /
       data (OREF(27,17, mtmp), mtmp=1,12)   &
         /   &
         0.2435D+01,  0.2675D+01,  0.2697D+01,  0.2139D+01,   &
         0.1763D+01,  0.1609D+01,  0.1581D+01,  0.1792D+01,   &
         0.2150D+01,  0.2779D+01,  0.2814D+01,  0.2447D+01   &
         /
       data (OREF(27,18, mtmp), mtmp=1,12)   &
         /   &
         0.2435D+01,  0.2675D+01,  0.2697D+01,  0.2139D+01,   &
         0.1763D+01,  0.1609D+01,  0.1581D+01,  0.1792D+01,   &
         0.2150D+01,  0.2779D+01,  0.2814D+01,  0.2447D+01   &
         /
       data (OREF(28, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1241D+01,  0.1423D+01,  0.1869D+01,  0.2320D+01,   &
         0.2491D+01,  0.2430D+01,  0.2050D+01,  0.1935D+01,   &
         0.1704D+01,  0.1656D+01,  0.1413D+01,  0.1295D+01   &
         /
       data (OREF(28, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1241D+01,  0.1423D+01,  0.1869D+01,  0.2320D+01,   &
         0.2491D+01,  0.2430D+01,  0.2050D+01,  0.1935D+01,   &
         0.1704D+01,  0.1656D+01,  0.1413D+01,  0.1295D+01   &
         /
       data (OREF(28, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1379D+01,  0.1492D+01,  0.1757D+01,  0.2152D+01,   &
         0.2491D+01,  0.2430D+01,  0.2050D+01,  0.1851D+01,   &
         0.1731D+01,  0.1692D+01,  0.1497D+01,  0.1419D+01   &
         /
       data (OREF(28, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1481D+01,  0.1579D+01,  0.1742D+01,  0.2041D+01,   &
         0.2416D+01,  0.2407D+01,  0.2128D+01,  0.1915D+01,   &
         0.1861D+01,  0.1739D+01,  0.1569D+01,  0.1502D+01   &
         /
       data (OREF(28, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1595D+01,  0.1686D+01,  0.1762D+01,  0.1933D+01,   &
         0.2220D+01,  0.2274D+01,  0.2189D+01,  0.2030D+01,   &
         0.1924D+01,  0.1733D+01,  0.1615D+01,  0.1584D+01   &
         /
       data (OREF(28, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1686D+01,  0.1759D+01,  0.1768D+01,  0.1825D+01,   &
         0.1948D+01,  0.1978D+01,  0.2028D+01,  0.1952D+01,   &
         0.1853D+01,  0.1705D+01,  0.1658D+01,  0.1662D+01   &
         /
       data (OREF(28, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1709D+01,  0.1749D+01,  0.1719D+01,  0.1746D+01,   &
         0.1818D+01,  0.1861D+01,  0.1893D+01,  0.1830D+01,   &
         0.1770D+01,  0.1707D+01,  0.1702D+01,  0.1727D+01   &
         /
       data (OREF(28, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1667D+01,  0.1649D+01,  0.1672D+01,  0.1732D+01,   &
         0.1798D+01,  0.1830D+01,  0.1810D+01,  0.1785D+01,   &
         0.1763D+01,  0.1739D+01,  0.1738D+01,  0.1770D+01   &
         /
       data (OREF(28, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1639D+01,  0.1584D+01,  0.1663D+01,  0.1742D+01,   &
         0.1810D+01,  0.1820D+01,  0.1780D+01,  0.1784D+01,   &
         0.1787D+01,  0.1774D+01,  0.1783D+01,  0.1814D+01   &
         /
       data (OREF(28,10, mtmp), mtmp=1,12)   &
         /   &
         0.1638D+01,  0.1596D+01,  0.1670D+01,  0.1740D+01,   &
         0.1805D+01,  0.1819D+01,  0.1789D+01,  0.1792D+01,   &
         0.1796D+01,  0.1788D+01,  0.1797D+01,  0.1820D+01   &
         /
       data (OREF(28,11, mtmp), mtmp=1,12)   &
         /   &
         0.1625D+01,  0.1644D+01,  0.1713D+01,  0.1759D+01,   &
         0.1806D+01,  0.1846D+01,  0.1842D+01,  0.1805D+01,   &
         0.1777D+01,  0.1762D+01,  0.1750D+01,  0.1758D+01   &
         /
       data (OREF(28,12, mtmp), mtmp=1,12)   &
         /   &
         0.1668D+01,  0.1683D+01,  0.1756D+01,  0.1786D+01,   &
         0.1796D+01,  0.1846D+01,  0.1887D+01,  0.1826D+01,   &
         0.1763D+01,  0.1708D+01,  0.1710D+01,  0.1738D+01   &
         /
       data (OREF(28,13, mtmp), mtmp=1,12)   &
         /   &
         0.1817D+01,  0.1771D+01,  0.1721D+01,  0.1737D+01,   &
         0.1734D+01,  0.1771D+01,  0.1843D+01,  0.1830D+01,   &
         0.1758D+01,  0.1713D+01,  0.1774D+01,  0.1783D+01   &
         /
       data (OREF(28,14, mtmp), mtmp=1,12)   &
         /   &
         0.1921D+01,  0.1930D+01,  0.1704D+01,  0.1619D+01,   &
         0.1646D+01,  0.1664D+01,  0.1713D+01,  0.1732D+01,   &
         0.1728D+01,  0.1794D+01,  0.1933D+01,  0.1855D+01   &
         /
       data (OREF(28,15, mtmp), mtmp=1,12)   &
         /   &
         0.1877D+01,  0.1999D+01,  0.1798D+01,  0.1592D+01,   &
         0.1548D+01,  0.1548D+01,  0.1562D+01,  0.1606D+01,   &
         0.1697D+01,  0.1904D+01,  0.2019D+01,  0.1852D+01   &
         /
       data (OREF(28,16, mtmp), mtmp=1,12)   &
         /   &
         0.1866D+01,  0.2002D+01,  0.1916D+01,  0.1641D+01,   &
         0.1486D+01,  0.1446D+01,  0.1445D+01,  0.1515D+01,   &
         0.1693D+01,  0.1928D+01,  0.2037D+01,  0.1828D+01   &
         /
       data (OREF(28,17, mtmp), mtmp=1,12)   &
         /   &
         0.1866D+01,  0.2037D+01,  0.2036D+01,  0.1698D+01,   &
         0.1433D+01,  0.1311D+01,  0.1291D+01,  0.1433D+01,   &
         0.1655D+01,  0.2013D+01,  0.2037D+01,  0.1828D+01   &
         /
       data (OREF(28,18, mtmp), mtmp=1,12)   &
         /   &
         0.1866D+01,  0.2037D+01,  0.2036D+01,  0.1698D+01,   &
         0.1433D+01,  0.1311D+01,  0.1291D+01,  0.1433D+01,   &
         0.1655D+01,  0.2013D+01,  0.2037D+01,  0.1828D+01   &
         /
       data (OREF(29, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1007D+01,  0.1157D+01,  0.1442D+01,  0.1685D+01,   &
         0.1805D+01,  0.1743D+01,  0.1531D+01,  0.1488D+01,   &
         0.1328D+01,  0.1332D+01,  0.1145D+01,  0.1052D+01   &
         /
       data (OREF(29, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1007D+01,  0.1157D+01,  0.1442D+01,  0.1685D+01,   &
         0.1805D+01,  0.1743D+01,  0.1531D+01,  0.1488D+01,   &
         0.1328D+01,  0.1332D+01,  0.1145D+01,  0.1052D+01   &
         /
       data (OREF(29, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1127D+01,  0.1217D+01,  0.1415D+01,  0.1647D+01,   &
         0.1805D+01,  0.1743D+01,  0.1531D+01,  0.1444D+01,   &
         0.1379D+01,  0.1359D+01,  0.1219D+01,  0.1163D+01   &
         /
       data (OREF(29, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1206D+01,  0.1286D+01,  0.1413D+01,  0.1628D+01,   &
         0.1826D+01,  0.1756D+01,  0.1601D+01,  0.1502D+01,   &
         0.1480D+01,  0.1389D+01,  0.1274D+01,  0.1225D+01   &
         /
       data (OREF(29, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1297D+01,  0.1374D+01,  0.1431D+01,  0.1563D+01,   &
         0.1766D+01,  0.1774D+01,  0.1734D+01,  0.1593D+01,   &
         0.1523D+01,  0.1381D+01,  0.1305D+01,  0.1288D+01   &
         /
       data (OREF(29, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1369D+01,  0.1433D+01,  0.1435D+01,  0.1477D+01,   &
         0.1570D+01,  0.1592D+01,  0.1649D+01,  0.1541D+01,   &
         0.1470D+01,  0.1359D+01,  0.1338D+01,  0.1349D+01   &
         /
       data (OREF(29, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1381D+01,  0.1416D+01,  0.1389D+01,  0.1410D+01,   &
         0.1472D+01,  0.1515D+01,  0.1546D+01,  0.1455D+01,   &
         0.1410D+01,  0.1365D+01,  0.1374D+01,  0.1401D+01   &
         /
       data (OREF(29, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1333D+01,  0.1319D+01,  0.1348D+01,  0.1405D+01,   &
         0.1466D+01,  0.1494D+01,  0.1473D+01,  0.1426D+01,   &
         0.1412D+01,  0.1396D+01,  0.1406D+01,  0.1433D+01   &
         /
       data (OREF(29, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1307D+01,  0.1259D+01,  0.1342D+01,  0.1419D+01,   &
         0.1480D+01,  0.1486D+01,  0.1444D+01,  0.1431D+01,   &
         0.1436D+01,  0.1427D+01,  0.1450D+01,  0.1474D+01   &
         /
       data (OREF(29,10, mtmp), mtmp=1,12)   &
         /   &
         0.1309D+01,  0.1272D+01,  0.1349D+01,  0.1418D+01,   &
         0.1475D+01,  0.1484D+01,  0.1453D+01,  0.1438D+01,   &
         0.1443D+01,  0.1439D+01,  0.1465D+01,  0.1483D+01   &
         /
       data (OREF(29,11, mtmp), mtmp=1,12)   &
         /   &
         0.1302D+01,  0.1319D+01,  0.1389D+01,  0.1433D+01,   &
         0.1475D+01,  0.1508D+01,  0.1501D+01,  0.1448D+01,   &
         0.1425D+01,  0.1416D+01,  0.1423D+01,  0.1430D+01   &
         /
       data (OREF(29,12, mtmp), mtmp=1,12)   &
         /   &
         0.1343D+01,  0.1355D+01,  0.1427D+01,  0.1457D+01,   &
         0.1467D+01,  0.1513D+01,  0.1545D+01,  0.1462D+01,   &
         0.1408D+01,  0.1363D+01,  0.1383D+01,  0.1411D+01   &
         /
       data (OREF(29,13, mtmp), mtmp=1,12)   &
         /   &
         0.1474D+01,  0.1431D+01,  0.1390D+01,  0.1411D+01,   &
         0.1414D+01,  0.1450D+01,  0.1514D+01,  0.1467D+01,   &
         0.1400D+01,  0.1358D+01,  0.1428D+01,  0.1440D+01   &
         /
       data (OREF(29,14, mtmp), mtmp=1,12)   &
         /   &
         0.1553D+01,  0.1568D+01,  0.1366D+01,  0.1303D+01,   &
         0.1339D+01,  0.1361D+01,  0.1406D+01,  0.1389D+01,   &
         0.1373D+01,  0.1411D+01,  0.1540D+01,  0.1463D+01   &
         /
       data (OREF(29,15, mtmp), mtmp=1,12)   &
         /   &
         0.1478D+01,  0.1610D+01,  0.1441D+01,  0.1278D+01,   &
         0.1254D+01,  0.1265D+01,  0.1279D+01,  0.1287D+01,   &
         0.1342D+01,  0.1481D+01,  0.1560D+01,  0.1407D+01   &
         /
       data (OREF(29,16, mtmp), mtmp=1,12)   &
         /   &
         0.1441D+01,  0.1562D+01,  0.1521D+01,  0.1316D+01,   &
         0.1207D+01,  0.1185D+01,  0.1187D+01,  0.1214D+01,   &
         0.1329D+01,  0.1473D+01,  0.1501D+01,  0.1382D+01   &
         /
       data (OREF(29,17, mtmp), mtmp=1,12)   &
         /   &
         0.1441D+01,  0.1558D+01,  0.1556D+01,  0.1350D+01,   &
         0.1161D+01,  0.1065D+01,  0.1051D+01,  0.1145D+01,   &
         0.1285D+01,  0.1484D+01,  0.1501D+01,  0.1382D+01   &
         /
       data (OREF(29,18, mtmp), mtmp=1,12)   &
         /   &
         0.1441D+01,  0.1558D+01,  0.1556D+01,  0.1350D+01,   &
         0.1161D+01,  0.1065D+01,  0.1051D+01,  0.1145D+01,   &
         0.1285D+01,  0.1484D+01,  0.1501D+01,  0.1382D+01   &
         /
       data (OREF(30, 1, mtmp), mtmp=1,12)   &
         /   &
         0.8120D+00,  0.9310D+00,  0.1127D+01,  0.1271D+01,   &
         0.1355D+01,  0.1295D+01,  0.1169D+01,  0.1144D+01,   &
         0.1037D+01,  0.1057D+01,  0.9210D+00,  0.8500D+00   &
         /
       data (OREF(30, 2, mtmp), mtmp=1,12)   &
         /   &
         0.8120D+00,  0.9310D+00,  0.1127D+01,  0.1271D+01,   &
         0.1355D+01,  0.1295D+01,  0.1169D+01,  0.1144D+01,   &
         0.1037D+01,  0.1057D+01,  0.9210D+00,  0.8500D+00   &
         /
       data (OREF(30, 3, mtmp), mtmp=1,12)   &
         /   &
         0.9170D+00,  0.9850D+00,  0.1128D+01,  0.1275D+01,   &
         0.1355D+01,  0.1295D+01,  0.1169D+01,  0.1126D+01,   &
         0.1088D+01,  0.1081D+01,  0.9870D+00,  0.9490D+00   &
         /
       data (OREF(30, 4, mtmp), mtmp=1,12)   &
         /   &
         0.9790D+00,  0.1042D+01,  0.1135D+01,  0.1289D+01,   &
         0.1409D+01,  0.1332D+01,  0.1227D+01,  0.1177D+01,   &
         0.1168D+01,  0.1107D+01,  0.1029D+01,  0.9970D+00   &
         /
       data (OREF(30, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1053D+01,  0.1116D+01,  0.1155D+01,  0.1252D+01,   &
         0.1396D+01,  0.1384D+01,  0.1367D+01,  0.1254D+01,   &
         0.1206D+01,  0.1102D+01,  0.1051D+01,  0.1045D+01   &
         /
       data (OREF(30, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1109D+01,  0.1163D+01,  0.1159D+01,  0.1185D+01,   &
         0.1253D+01,  0.1269D+01,  0.1329D+01,  0.1223D+01,   &
         0.1169D+01,  0.1086D+01,  0.1077D+01,  0.1093D+01   &
         /
       data (OREF(30, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1112D+01,  0.1143D+01,  0.1117D+01,  0.1133D+01,   &
         0.1184D+01,  0.1225D+01,  0.1253D+01,  0.1160D+01,   &
         0.1127D+01,  0.1094D+01,  0.1107D+01,  0.1133D+01   &
         /
       data (OREF(30, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1062D+01,  0.1051D+01,  0.1083D+01,  0.1137D+01,   &
         0.1191D+01,  0.1214D+01,  0.1192D+01,  0.1141D+01,   &
         0.1133D+01,  0.1121D+01,  0.1135D+01,  0.1157D+01   &
         /
       data (OREF(30, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1037D+01,  0.9970D+00,  0.1082D+01,  0.1155D+01,   &
         0.1208D+01,  0.1209D+01,  0.1167D+01,  0.1147D+01,   &
         0.1153D+01,  0.1147D+01,  0.1176D+01,  0.1193D+01   &
         /
       data (OREF(30,10, mtmp), mtmp=1,12)   &
         /   &
         0.1040D+01,  0.1011D+01,  0.1089D+01,  0.1154D+01,   &
         0.1204D+01,  0.1207D+01,  0.1175D+01,  0.1153D+01,   &
         0.1158D+01,  0.1157D+01,  0.1192D+01,  0.1203D+01   &
         /
       data (OREF(30,11, mtmp), mtmp=1,12)   &
         /   &
         0.1035D+01,  0.1053D+01,  0.1122D+01,  0.1165D+01,   &
         0.1201D+01,  0.1229D+01,  0.1218D+01,  0.1162D+01,   &
         0.1142D+01,  0.1137D+01,  0.1153D+01,  0.1156D+01   &
         /
       data (OREF(30,12, mtmp), mtmp=1,12)   &
         /   &
         0.1071D+01,  0.1083D+01,  0.1153D+01,  0.1184D+01,   &
         0.1195D+01,  0.1235D+01,  0.1260D+01,  0.1173D+01,   &
         0.1125D+01,  0.1087D+01,  0.1110D+01,  0.1137D+01   &
         /
       data (OREF(30,13, mtmp), mtmp=1,12)   &
         /   &
         0.1184D+01,  0.1144D+01,  0.1114D+01,  0.1140D+01,   &
         0.1148D+01,  0.1183D+01,  0.1238D+01,  0.1176D+01,   &
         0.1115D+01,  0.1075D+01,  0.1137D+01,  0.1151D+01   &
         /
       data (OREF(30,14, mtmp), mtmp=1,12)   &
         /   &
         0.1245D+01,  0.1261D+01,  0.1083D+01,  0.1041D+01,   &
         0.1083D+01,  0.1108D+01,  0.1148D+01,  0.1112D+01,   &
         0.1090D+01,  0.1109D+01,  0.1214D+01,  0.1145D+01   &
         /
       data (OREF(30,15, mtmp), mtmp=1,12)   &
         /   &
         0.1169D+01,  0.1292D+01,  0.1141D+01,  0.1015D+01,   &
         0.1011D+01,  0.1029D+01,  0.1042D+01,  0.1028D+01,   &
         0.1059D+01,  0.1154D+01,  0.1210D+01,  0.1080D+01   &
         /
       data (OREF(30,16, mtmp), mtmp=1,12)   &
         /   &
         0.1124D+01,  0.1234D+01,  0.1202D+01,  0.1044D+01,   &
         0.9730D+00,  0.9670D+00,  0.9700D+00,  0.9690D+00,   &
         0.1043D+01,  0.1136D+01,  0.1131D+01,  0.1058D+01   &
         /
       data (OREF(30,17, mtmp), mtmp=1,12)   &
         /   &
         0.1124D+01,  0.1205D+01,  0.1206D+01,  0.1066D+01,   &
         0.9330D+00,  0.8590D+00,  0.8500D+00,  0.9110D+00,   &
         0.1004D+01,  0.1121D+01,  0.1131D+01,  0.1058D+01   &
         /
       data (OREF(30,18, mtmp), mtmp=1,12)   &
         /   &
         0.1124D+01,  0.1205D+01,  0.1206D+01,  0.1066D+01,   &
         0.9330D+00,  0.8590D+00,  0.8500D+00,  0.9110D+00,   &
         0.1004D+01,  0.1121D+01,  0.1131D+01,  0.1058D+01   &
         /
       data (OREF(31, 1, mtmp), mtmp=1,12)   &
         /   &
         0.6540D+00,  0.7480D+00,  0.8830D+00,  0.9680D+00,   &
         0.1026D+01,  0.9720D+00,  0.8980D+00,  0.8780D+00,   &
         0.8100D+00,  0.8350D+00,  0.7390D+00,  0.6860D+00   &
         /
       data (OREF(31, 2, mtmp), mtmp=1,12)   &
         /   &
         0.6540D+00,  0.7480D+00,  0.8830D+00,  0.9680D+00,   &
         0.1026D+01,  0.9720D+00,  0.8980D+00,  0.8780D+00,   &
         0.8100D+00,  0.8350D+00,  0.7390D+00,  0.6860D+00   &
         /
       data (OREF(31, 3, mtmp), mtmp=1,12)   &
         /   &
         0.7460D+00,  0.7950D+00,  0.8970D+00,  0.9910D+00,   &
         0.1026D+01,  0.9720D+00,  0.8980D+00,  0.8780D+00,   &
         0.8560D+00,  0.8580D+00,  0.7980D+00,  0.7740D+00   &
         /
       data (OREF(31, 4, mtmp), mtmp=1,12)   &
         /   &
         0.7940D+00,  0.8430D+00,  0.9100D+00,  0.1018D+01,   &
         0.1092D+01,  0.1022D+01,  0.9440D+00,  0.9220D+00,   &
         0.9200D+00,  0.8820D+00,  0.8300D+00,  0.8110D+00   &
         /
       data (OREF(31, 5, mtmp), mtmp=1,12)   &
         /   &
         0.8540D+00,  0.9060D+00,  0.9310D+00,  0.1000D+01,   &
         0.1102D+01,  0.1080D+01,  0.1077D+01,  0.9890D+00,   &
         0.9540D+00,  0.8800D+00,  0.8450D+00,  0.8480D+00   &
         /
       data (OREF(31, 6, mtmp), mtmp=1,12)   &
         /   &
         0.8980D+00,  0.9430D+00,  0.9340D+00,  0.9500D+00,   &
         0.9970D+00,  0.1009D+01,  0.1070D+01,  0.9710D+00,   &
         0.9300D+00,  0.8690D+00,  0.8660D+00,  0.8850D+00   &
         /
       data (OREF(31, 7, mtmp), mtmp=1,12)   &
         /   &
         0.8950D+00,  0.9210D+00,  0.8970D+00,  0.9090D+00,   &
         0.9510D+00,  0.9880D+00,  0.1014D+01,  0.9260D+00,   &
         0.9020D+00,  0.8770D+00,  0.8910D+00,  0.9160D+00   &
         /
       data (OREF(31, 8, mtmp), mtmp=1,12)   &
         /   &
         0.8450D+00,  0.8370D+00,  0.8700D+00,  0.9190D+00,   &
         0.9660D+00,  0.9850D+00,  0.9640D+00,  0.9140D+00,   &
         0.9090D+00,  0.9010D+00,  0.9150D+00,  0.9320D+00   &
         /
       data (OREF(31, 9, mtmp), mtmp=1,12)   &
         /   &
         0.8210D+00,  0.7900D+00,  0.8720D+00,  0.9400D+00,   &
         0.9850D+00,  0.9820D+00,  0.9420D+00,  0.9190D+00,   &
         0.9250D+00,  0.9220D+00,  0.9530D+00,  0.9640D+00   &
         /
       data (OREF(31,10, mtmp), mtmp=1,12)   &
         /   &
         0.8250D+00,  0.8020D+00,  0.8790D+00,  0.9390D+00,   &
         0.9810D+00,  0.9810D+00,  0.9500D+00,  0.9240D+00,   &
         0.9290D+00,  0.9300D+00,  0.9690D+00,  0.9750D+00   &
         /
       data (OREF(31,11, mtmp), mtmp=1,12)   &
         /   &
         0.8220D+00,  0.8400D+00,  0.9060D+00,  0.9460D+00,   &
         0.9780D+00,  0.1000D+01,  0.9870D+00,  0.9320D+00,   &
         0.9160D+00,  0.9130D+00,  0.9320D+00,  0.9330D+00   &
         /
       data (OREF(31,12, mtmp), mtmp=1,12)   &
         /   &
         0.8520D+00,  0.8640D+00,  0.9310D+00,  0.9600D+00,   &
         0.9720D+00,  0.1007D+01,  0.1027D+01,  0.9410D+00,   &
         0.8990D+00,  0.8670D+00,  0.8900D+00,  0.9140D+00   &
         /
       data (OREF(31,13, mtmp), mtmp=1,12)   &
         /   &
         0.9480D+00,  0.9120D+00,  0.8900D+00,  0.9200D+00,   &
         0.9310D+00,  0.9630D+00,  0.1011D+01,  0.9440D+00,   &
         0.8880D+00,  0.8510D+00,  0.9030D+00,  0.9180D+00   &
         /
       data (OREF(31,14, mtmp), mtmp=1,12)   &
         /   &
         0.9960D+00,  0.1011D+01,  0.8560D+00,  0.8300D+00,   &
         0.8750D+00,  0.9010D+00,  0.9360D+00,  0.8910D+00,   &
         0.8660D+00,  0.8720D+00,  0.9550D+00,  0.8940D+00   &
         /
       data (OREF(31,15, mtmp), mtmp=1,12)   &
         /   &
         0.9260D+00,  0.1036D+01,  0.9010D+00,  0.8050D+00,   &
         0.8130D+00,  0.8360D+00,  0.8480D+00,  0.8210D+00,   &
         0.8360D+00,  0.8990D+00,  0.9390D+00,  0.8300D+00   &
         /
       data (OREF(31,16, mtmp), mtmp=1,12)   &
         /   &
         0.8790D+00,  0.9790D+00,  0.9490D+00,  0.8250D+00,   &
         0.7830D+00,  0.7870D+00,  0.7910D+00,  0.7730D+00,   &
         0.8180D+00,  0.8780D+00,  0.8570D+00,  0.8130D+00   &
         /
       data (OREF(31,17, mtmp), mtmp=1,12)   &
         /   &
         0.8790D+00,  0.9350D+00,  0.9390D+00,  0.8400D+00,   &
         0.7480D+00,  0.6920D+00,  0.6860D+00,  0.7250D+00,   &
         0.7860D+00,  0.8530D+00,  0.8570D+00,  0.8130D+00   &
         /
       data (OREF(31,18, mtmp), mtmp=1,12)   &
         /   &
         0.8790D+00,  0.9350D+00,  0.9390D+00,  0.8400D+00,   &
         0.7480D+00,  0.6920D+00,  0.6860D+00,  0.7250D+00,   &
         0.7860D+00,  0.8530D+00,  0.8570D+00,  0.8130D+00   &
         /
       data (OREF(32, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4384D+00,  0.5014D+00,  0.5919D+00,  0.6489D+00,   &
         0.6877D+00,  0.6516D+00,  0.6019D+00,  0.5885D+00,   &
         0.5430D+00,  0.5597D+00,  0.4954D+00,  0.4598D+00   &
         /
       data (OREF(32, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4384D+00,  0.5014D+00,  0.5919D+00,  0.6489D+00,   &
         0.6877D+00,  0.6516D+00,  0.6019D+00,  0.5885D+00,   &
         0.5430D+00,  0.5597D+00,  0.4954D+00,  0.4598D+00   &
         /
       data (OREF(32, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5001D+00,  0.5329D+00,  0.6013D+00,  0.6643D+00,   &
         0.6877D+00,  0.6516D+00,  0.6019D+00,  0.5885D+00,   &
         0.5738D+00,  0.5751D+00,  0.5349D+00,  0.5188D+00   &
         /
       data (OREF(32, 4, mtmp), mtmp=1,12)   &
         /   &
         0.5322D+00,  0.5651D+00,  0.6100D+00,  0.6824D+00,   &
         0.7320D+00,  0.6851D+00,  0.6328D+00,  0.6180D+00,   &
         0.6167D+00,  0.5912D+00,  0.5564D+00,  0.5436D+00   &
         /
       data (OREF(32, 5, mtmp), mtmp=1,12)   &
         /   &
         0.5725D+00,  0.6073D+00,  0.6241D+00,  0.6703D+00,   &
         0.7387D+00,  0.7239D+00,  0.7219D+00,  0.6629D+00,   &
         0.6395D+00,  0.5899D+00,  0.5664D+00,  0.5684D+00   &
         /
       data (OREF(32, 6, mtmp), mtmp=1,12)   &
         /   &
         0.6019D+00,  0.6321D+00,  0.6261D+00,  0.6368D+00,   &
         0.6683D+00,  0.6764D+00,  0.7172D+00,  0.6509D+00,   &
         0.6234D+00,  0.5825D+00,  0.5805D+00,  0.5932D+00   &
         /
       data (OREF(32, 7, mtmp), mtmp=1,12)   &
         /   &
         0.5999D+00,  0.6174D+00,  0.6013D+00,  0.6093D+00,   &
         0.6375D+00,  0.6623D+00,  0.6797D+00,  0.6207D+00,   &
         0.6046D+00,  0.5879D+00,  0.5973D+00,  0.6140D+00   &
         /
       data (OREF(32, 8, mtmp), mtmp=1,12)   &
         /   &
         0.5664D+00,  0.5611D+00,  0.5832D+00,  0.6160D+00,   &
         0.6475D+00,  0.6603D+00,  0.6462D+00,  0.6127D+00,   &
         0.6093D+00,  0.6040D+00,  0.6133D+00,  0.6247D+00   &
         /
       data (OREF(32, 9, mtmp), mtmp=1,12)   &
         /   &
         0.5503D+00,  0.5296D+00,  0.5845D+00,  0.6301D+00,   &
         0.6603D+00,  0.6583D+00,  0.6314D+00,  0.6160D+00,   &
         0.6200D+00,  0.6180D+00,  0.6388D+00,  0.6462D+00   &
         /
       data (OREF(32,10, mtmp), mtmp=1,12)   &
         /   &
         0.5530D+00,  0.5376D+00,  0.5892D+00,  0.6294D+00,   &
         0.6576D+00,  0.6576D+00,  0.6368D+00,  0.6194D+00,   &
         0.6227D+00,  0.6234D+00,  0.6495D+00,  0.6536D+00   &
         /
       data (OREF(32,11, mtmp), mtmp=1,12)   &
         /   &
         0.5510D+00,  0.5631D+00,  0.6073D+00,  0.6341D+00,   &
         0.6556D+00,  0.6703D+00,  0.6616D+00,  0.6247D+00,   &
         0.6140D+00,  0.6120D+00,  0.6247D+00,  0.6254D+00   &
         /
       data (OREF(32,12, mtmp), mtmp=1,12)   &
         /   &
         0.5711D+00,  0.5792D+00,  0.6241D+00,  0.6435D+00,   &
         0.6516D+00,  0.6750D+00,  0.6884D+00,  0.6308D+00,   &
         0.6026D+00,  0.5812D+00,  0.5966D+00,  0.6127D+00   &
         /
       data (OREF(32,13, mtmp), mtmp=1,12)   &
         /   &
         0.6355D+00,  0.6113D+00,  0.5966D+00,  0.6167D+00,   &
         0.6241D+00,  0.6455D+00,  0.6777D+00,  0.6328D+00,   &
         0.5952D+00,  0.5704D+00,  0.6053D+00,  0.6154D+00   &
         /
       data (OREF(32,14, mtmp), mtmp=1,12)   &
         /   &
         0.6676D+00,  0.6777D+00,  0.5738D+00,  0.5564D+00,   &
         0.5865D+00,  0.6040D+00,  0.6274D+00,  0.5973D+00,   &
         0.5805D+00,  0.5845D+00,  0.6402D+00,  0.5993D+00   &
         /
       data (OREF(32,15, mtmp), mtmp=1,12)   &
         /   &
         0.6207D+00,  0.6945D+00,  0.6040D+00,  0.5396D+00,   &
         0.5450D+00,  0.5604D+00,  0.5684D+00,  0.5503D+00,   &
         0.5604D+00,  0.6026D+00,  0.6294D+00,  0.5564D+00   &
         /
       data (OREF(32,16, mtmp), mtmp=1,12)   &
         /   &
         0.5892D+00,  0.6562D+00,  0.6361D+00,  0.5530D+00,   &
         0.5249D+00,  0.5275D+00,  0.5302D+00,  0.5182D+00,   &
         0.5483D+00,  0.5885D+00,  0.5745D+00,  0.5450D+00   &
         /
       data (OREF(32,17, mtmp), mtmp=1,12)   &
         /   &
         0.5892D+00,  0.6267D+00,  0.6294D+00,  0.5631D+00,   &
         0.5014D+00,  0.4639D+00,  0.4598D+00,  0.4860D+00,   &
         0.5269D+00,  0.5718D+00,  0.5745D+00,  0.5450D+00   &
         /
       data (OREF(32,18, mtmp), mtmp=1,12)   &
         /   &
         0.5892D+00,  0.6267D+00,  0.6294D+00,  0.5631D+00,   &
         0.5014D+00,  0.4639D+00,  0.4598D+00,  0.4860D+00,   &
         0.5269D+00,  0.5718D+00,  0.5745D+00,  0.5450D+00   &
         /
       data (OREF(33, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2939D+00,  0.3361D+00,  0.3968D+00,  0.4350D+00,   &
         0.4610D+00,  0.4367D+00,  0.4035D+00,  0.3945D+00,   &
         0.3640D+00,  0.3752D+00,  0.3321D+00,  0.3082D+00   &
         /
       data (OREF(33, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2939D+00,  0.3361D+00,  0.3968D+00,  0.4350D+00,   &
         0.4610D+00,  0.4367D+00,  0.4035D+00,  0.3945D+00,   &
         0.3640D+00,  0.3752D+00,  0.3321D+00,  0.3082D+00   &
         /
       data (OREF(33, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3352D+00,  0.3572D+00,  0.4030D+00,  0.4453D+00,   &
         0.4610D+00,  0.4367D+00,  0.4035D+00,  0.3945D+00,   &
         0.3846D+00,  0.3855D+00,  0.3586D+00,  0.3478D+00   &
         /
       data (OREF(33, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3568D+00,  0.3788D+00,  0.4089D+00,  0.4574D+00,   &
         0.4907D+00,  0.4592D+00,  0.4242D+00,  0.4143D+00,   &
         0.4134D+00,  0.3963D+00,  0.3729D+00,  0.3644D+00   &
         /
       data (OREF(33, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3837D+00,  0.4071D+00,  0.4183D+00,  0.4493D+00,   &
         0.4952D+00,  0.4853D+00,  0.4839D+00,  0.4444D+00,   &
         0.4287D+00,  0.3954D+00,  0.3797D+00,  0.3810D+00   &
         /
       data (OREF(33, 6, mtmp), mtmp=1,12)   &
         /   &
         0.4035D+00,  0.4237D+00,  0.4197D+00,  0.4269D+00,   &
         0.4480D+00,  0.4534D+00,  0.4808D+00,  0.4363D+00,   &
         0.4179D+00,  0.3905D+00,  0.3891D+00,  0.3977D+00   &
         /
       data (OREF(33, 7, mtmp), mtmp=1,12)   &
         /   &
         0.4021D+00,  0.4138D+00,  0.4030D+00,  0.4084D+00,   &
         0.4273D+00,  0.4439D+00,  0.4556D+00,  0.4161D+00,   &
         0.4053D+00,  0.3941D+00,  0.4004D+00,  0.4116D+00   &
         /
       data (OREF(33, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3797D+00,  0.3761D+00,  0.3909D+00,  0.4129D+00,   &
         0.4341D+00,  0.4426D+00,  0.4332D+00,  0.4107D+00,   &
         0.4084D+00,  0.4048D+00,  0.4111D+00,  0.4188D+00   &
         /
       data (OREF(33, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3689D+00,  0.3550D+00,  0.3918D+00,  0.4224D+00,   &
         0.4426D+00,  0.4412D+00,  0.4233D+00,  0.4129D+00,   &
         0.4156D+00,  0.4143D+00,  0.4282D+00,  0.4332D+00   &
         /
       data (OREF(33,10, mtmp), mtmp=1,12)   &
         /   &
         0.3707D+00,  0.3604D+00,  0.3950D+00,  0.4219D+00,   &
         0.4408D+00,  0.4408D+00,  0.4269D+00,  0.4152D+00,   &
         0.4174D+00,  0.4179D+00,  0.4354D+00,  0.4381D+00   &
         /
       data (OREF(33,11, mtmp), mtmp=1,12)   &
         /   &
         0.3693D+00,  0.3774D+00,  0.4071D+00,  0.4251D+00,   &
         0.4394D+00,  0.4493D+00,  0.4435D+00,  0.4188D+00,   &
         0.4116D+00,  0.4102D+00,  0.4188D+00,  0.4192D+00   &
         /
       data (OREF(33,12, mtmp), mtmp=1,12)   &
         /   &
         0.3828D+00,  0.3882D+00,  0.4183D+00,  0.4314D+00,   &
         0.4367D+00,  0.4525D+00,  0.4615D+00,  0.4228D+00,   &
         0.4039D+00,  0.3896D+00,  0.3999D+00,  0.4107D+00   &
         /
       data (OREF(33,13, mtmp), mtmp=1,12)   &
         /   &
         0.4260D+00,  0.4098D+00,  0.3999D+00,  0.4134D+00,   &
         0.4183D+00,  0.4327D+00,  0.4543D+00,  0.4242D+00,   &
         0.3990D+00,  0.3824D+00,  0.4057D+00,  0.4125D+00   &
         /
       data (OREF(33,14, mtmp), mtmp=1,12)   &
         /   &
         0.4475D+00,  0.4543D+00,  0.3846D+00,  0.3729D+00,   &
         0.3932D+00,  0.4048D+00,  0.4206D+00,  0.4004D+00,   &
         0.3891D+00,  0.3918D+00,  0.4291D+00,  0.4017D+00   &
         /
       data (OREF(33,15, mtmp), mtmp=1,12)   &
         /   &
         0.4161D+00,  0.4655D+00,  0.4048D+00,  0.3617D+00,   &
         0.3653D+00,  0.3756D+00,  0.3810D+00,  0.3689D+00,   &
         0.3756D+00,  0.4039D+00,  0.4219D+00,  0.3729D+00   &
         /
       data (OREF(33,16, mtmp), mtmp=1,12)   &
         /   &
         0.3950D+00,  0.4399D+00,  0.4264D+00,  0.3707D+00,   &
         0.3518D+00,  0.3536D+00,  0.3554D+00,  0.3473D+00,   &
         0.3676D+00,  0.3945D+00,  0.3851D+00,  0.3653D+00   &
         /
       data (OREF(33,17, mtmp), mtmp=1,12)   &
         /   &
         0.3950D+00,  0.4201D+00,  0.4219D+00,  0.3774D+00,   &
         0.3361D+00,  0.3109D+00,  0.3082D+00,  0.3258D+00,   &
         0.3532D+00,  0.3833D+00,  0.3851D+00,  0.3653D+00   &
         /
       data (OREF(33,18, mtmp), mtmp=1,12)   &
         /   &
         0.3950D+00,  0.4201D+00,  0.4219D+00,  0.3774D+00,   &
         0.3361D+00,  0.3109D+00,  0.3082D+00,  0.3258D+00,   &
         0.3532D+00,  0.3833D+00,  0.3851D+00,  0.3653D+00   &
         /
       data (OREF(34, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1970D+00,  0.2253D+00,  0.2660D+00,  0.2916D+00,   &
         0.3090D+00,  0.2928D+00,  0.2705D+00,  0.2644D+00,   &
         0.2440D+00,  0.2515D+00,  0.2226D+00,  0.2066D+00   &
         /
       data (OREF(34, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1970D+00,  0.2253D+00,  0.2660D+00,  0.2916D+00,   &
         0.3090D+00,  0.2928D+00,  0.2705D+00,  0.2644D+00,   &
         0.2440D+00,  0.2515D+00,  0.2226D+00,  0.2066D+00   &
         /
       data (OREF(34, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2247D+00,  0.2394D+00,  0.2702D+00,  0.2985D+00,   &
         0.3090D+00,  0.2928D+00,  0.2705D+00,  0.2644D+00,   &
         0.2578D+00,  0.2584D+00,  0.2404D+00,  0.2331D+00   &
         /
       data (OREF(34, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2391D+00,  0.2539D+00,  0.2741D+00,  0.3066D+00,   &
         0.3289D+00,  0.3078D+00,  0.2843D+00,  0.2777D+00,   &
         0.2771D+00,  0.2657D+00,  0.2500D+00,  0.2443D+00   &
         /
       data (OREF(34, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2572D+00,  0.2729D+00,  0.2804D+00,  0.3012D+00,   &
         0.3319D+00,  0.3253D+00,  0.3244D+00,  0.2979D+00,   &
         0.2873D+00,  0.2651D+00,  0.2545D+00,  0.2554D+00   &
         /
       data (OREF(34, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2705D+00,  0.2840D+00,  0.2813D+00,  0.2861D+00,   &
         0.3003D+00,  0.3039D+00,  0.3223D+00,  0.2925D+00,   &
         0.2801D+00,  0.2617D+00,  0.2608D+00,  0.2666D+00   &
         /
       data (OREF(34, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2696D+00,  0.2774D+00,  0.2702D+00,  0.2738D+00,   &
         0.2864D+00,  0.2976D+00,  0.3054D+00,  0.2789D+00,   &
         0.2717D+00,  0.2641D+00,  0.2684D+00,  0.2759D+00   &
         /
       data (OREF(34, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2545D+00,  0.2521D+00,  0.2620D+00,  0.2768D+00,   &
         0.2910D+00,  0.2967D+00,  0.2904D+00,  0.2753D+00,   &
         0.2738D+00,  0.2714D+00,  0.2756D+00,  0.2807D+00   &
         /
       data (OREF(34, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2473D+00,  0.2379D+00,  0.2626D+00,  0.2831D+00,   &
         0.2967D+00,  0.2958D+00,  0.2837D+00,  0.2768D+00,   &
         0.2786D+00,  0.2777D+00,  0.2870D+00,  0.2904D+00   &
         /
       data (OREF(34,10, mtmp), mtmp=1,12)   &
         /   &
         0.2485D+00,  0.2416D+00,  0.2647D+00,  0.2828D+00,   &
         0.2955D+00,  0.2955D+00,  0.2861D+00,  0.2783D+00,   &
         0.2798D+00,  0.2801D+00,  0.2919D+00,  0.2937D+00   &
         /
       data (OREF(34,11, mtmp), mtmp=1,12)   &
         /   &
         0.2476D+00,  0.2530D+00,  0.2729D+00,  0.2849D+00,   &
         0.2946D+00,  0.3012D+00,  0.2973D+00,  0.2807D+00,   &
         0.2759D+00,  0.2750D+00,  0.2807D+00,  0.2810D+00   &
         /
       data (OREF(34,12, mtmp), mtmp=1,12)   &
         /   &
         0.2566D+00,  0.2602D+00,  0.2804D+00,  0.2891D+00,   &
         0.2928D+00,  0.3033D+00,  0.3093D+00,  0.2834D+00,   &
         0.2708D+00,  0.2611D+00,  0.2681D+00,  0.2753D+00   &
         /
       data (OREF(34,13, mtmp), mtmp=1,12)   &
         /   &
         0.2855D+00,  0.2747D+00,  0.2681D+00,  0.2771D+00,   &
         0.2804D+00,  0.2901D+00,  0.3045D+00,  0.2843D+00,   &
         0.2675D+00,  0.2563D+00,  0.2720D+00,  0.2765D+00   &
         /
       data (OREF(34,14, mtmp), mtmp=1,12)   &
         /   &
         0.3000D+00,  0.3045D+00,  0.2578D+00,  0.2500D+00,   &
         0.2635D+00,  0.2714D+00,  0.2819D+00,  0.2684D+00,   &
         0.2608D+00,  0.2626D+00,  0.2876D+00,  0.2693D+00   &
         /
       data (OREF(34,15, mtmp), mtmp=1,12)   &
         /   &
         0.2789D+00,  0.3120D+00,  0.2714D+00,  0.2425D+00,   &
         0.2449D+00,  0.2518D+00,  0.2554D+00,  0.2473D+00,   &
         0.2518D+00,  0.2708D+00,  0.2828D+00,  0.2500D+00   &
         /
       data (OREF(34,16, mtmp), mtmp=1,12)   &
         /   &
         0.2647D+00,  0.2949D+00,  0.2858D+00,  0.2485D+00,   &
         0.2358D+00,  0.2370D+00,  0.2382D+00,  0.2328D+00,   &
         0.2464D+00,  0.2644D+00,  0.2581D+00,  0.2449D+00   &
         /
       data (OREF(34,17, mtmp), mtmp=1,12)   &
         /   &
         0.2647D+00,  0.2816D+00,  0.2828D+00,  0.2530D+00,   &
         0.2253D+00,  0.2084D+00,  0.2066D+00,  0.2184D+00,   &
         0.2367D+00,  0.2569D+00,  0.2581D+00,  0.2449D+00   &
         /
       data (OREF(34,18, mtmp), mtmp=1,12)   &
         /   &
         0.2647D+00,  0.2816D+00,  0.2828D+00,  0.2530D+00,   &
         0.2253D+00,  0.2084D+00,  0.2066D+00,  0.2184D+00,   &
         0.2367D+00,  0.2569D+00,  0.2581D+00,  0.2449D+00   &
         /
       data (OREF(35, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1320D+00,  0.1510D+00,  0.1783D+00,  0.1954D+00,   &
         0.2071D+00,  0.1962D+00,  0.1813D+00,  0.1773D+00,   &
         0.1635D+00,  0.1686D+00,  0.1492D+00,  0.1385D+00   &
         /
       data (OREF(35, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1320D+00,  0.1510D+00,  0.1783D+00,  0.1954D+00,   &
         0.2071D+00,  0.1962D+00,  0.1813D+00,  0.1773D+00,   &
         0.1635D+00,  0.1686D+00,  0.1492D+00,  0.1385D+00   &
         /
       data (OREF(35, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1506D+00,  0.1605D+00,  0.1811D+00,  0.2001D+00,   &
         0.2071D+00,  0.1962D+00,  0.1813D+00,  0.1773D+00,   &
         0.1728D+00,  0.1732D+00,  0.1611D+00,  0.1563D+00   &
         /
       data (OREF(35, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1603D+00,  0.1702D+00,  0.1837D+00,  0.2055D+00,   &
         0.2205D+00,  0.2063D+00,  0.1906D+00,  0.1861D+00,   &
         0.1857D+00,  0.1781D+00,  0.1676D+00,  0.1637D+00   &
         /
       data (OREF(35, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1724D+00,  0.1829D+00,  0.1880D+00,  0.2019D+00,   &
         0.2225D+00,  0.2180D+00,  0.2174D+00,  0.1997D+00,   &
         0.1926D+00,  0.1777D+00,  0.1706D+00,  0.1712D+00   &
         /
       data (OREF(35, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1813D+00,  0.1904D+00,  0.1886D+00,  0.1918D+00,   &
         0.2013D+00,  0.2037D+00,  0.2160D+00,  0.1960D+00,   &
         0.1878D+00,  0.1754D+00,  0.1748D+00,  0.1787D+00   &
         /
       data (OREF(35, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1807D+00,  0.1859D+00,  0.1811D+00,  0.1835D+00,   &
         0.1920D+00,  0.1995D+00,  0.2047D+00,  0.1870D+00,   &
         0.1821D+00,  0.1771D+00,  0.1799D+00,  0.1849D+00   &
         /
       data (OREF(35, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1706D+00,  0.1690D+00,  0.1756D+00,  0.1855D+00,   &
         0.1950D+00,  0.1989D+00,  0.1946D+00,  0.1845D+00,   &
         0.1835D+00,  0.1819D+00,  0.1847D+00,  0.1882D+00   &
         /
       data (OREF(35, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1658D+00,  0.1595D+00,  0.1761D+00,  0.1898D+00,   &
         0.1989D+00,  0.1983D+00,  0.1902D+00,  0.1855D+00,   &
         0.1868D+00,  0.1861D+00,  0.1924D+00,  0.1946D+00   &
         /
       data (OREF(35,10, mtmp), mtmp=1,12)   &
         /   &
         0.1666D+00,  0.1619D+00,  0.1775D+00,  0.1896D+00,   &
         0.1981D+00,  0.1981D+00,  0.1918D+00,  0.1866D+00,   &
         0.1876D+00,  0.1878D+00,  0.1956D+00,  0.1968D+00   &
         /
       data (OREF(35,11, mtmp), mtmp=1,12)   &
         /   &
         0.1660D+00,  0.1696D+00,  0.1829D+00,  0.1910D+00,   &
         0.1975D+00,  0.2019D+00,  0.1993D+00,  0.1882D+00,   &
         0.1849D+00,  0.1843D+00,  0.1882D+00,  0.1884D+00   &
         /
       data (OREF(35,12, mtmp), mtmp=1,12)   &
         /   &
         0.1720D+00,  0.1744D+00,  0.1880D+00,  0.1938D+00,   &
         0.1962D+00,  0.2033D+00,  0.2073D+00,  0.1900D+00,   &
         0.1815D+00,  0.1750D+00,  0.1797D+00,  0.1845D+00   &
         /
       data (OREF(35,13, mtmp), mtmp=1,12)   &
         /   &
         0.1914D+00,  0.1841D+00,  0.1797D+00,  0.1857D+00,   &
         0.1880D+00,  0.1944D+00,  0.2041D+00,  0.1906D+00,   &
         0.1793D+00,  0.1718D+00,  0.1823D+00,  0.1853D+00   &
         /
       data (OREF(35,14, mtmp), mtmp=1,12)   &
         /   &
         0.2011D+00,  0.2041D+00,  0.1728D+00,  0.1676D+00,   &
         0.1767D+00,  0.1819D+00,  0.1890D+00,  0.1799D+00,   &
         0.1748D+00,  0.1761D+00,  0.1928D+00,  0.1805D+00   &
         /
       data (OREF(35,15, mtmp), mtmp=1,12)   &
         /   &
         0.1870D+00,  0.2092D+00,  0.1819D+00,  0.1625D+00,   &
         0.1641D+00,  0.1688D+00,  0.1712D+00,  0.1658D+00,   &
         0.1688D+00,  0.1815D+00,  0.1896D+00,  0.1676D+00   &
         /
       data (OREF(35,16, mtmp), mtmp=1,12)   &
         /   &
         0.1775D+00,  0.1977D+00,  0.1916D+00,  0.1666D+00,   &
         0.1581D+00,  0.1589D+00,  0.1597D+00,  0.1561D+00,   &
         0.1652D+00,  0.1773D+00,  0.1730D+00,  0.1641D+00   &
         /
       data (OREF(35,17, mtmp), mtmp=1,12)   &
         /   &
         0.1775D+00,  0.1888D+00,  0.1896D+00,  0.1696D+00,   &
         0.1510D+00,  0.1397D+00,  0.1385D+00,  0.1464D+00,   &
         0.1587D+00,  0.1722D+00,  0.1730D+00,  0.1641D+00   &
         /
       data (OREF(35,18, mtmp), mtmp=1,12)   &
         /   &
         0.1775D+00,  0.1888D+00,  0.1896D+00,  0.1696D+00,   &
         0.1510D+00,  0.1397D+00,  0.1385D+00,  0.1464D+00,   &
         0.1587D+00,  0.1722D+00,  0.1730D+00,  0.1641D+00   &
         /
       data (OREF(36, 1, mtmp), mtmp=1,12)   &
         /   &
         0.8851D-01,  0.1012D+00,  0.1195D+00,  0.1310D+00,   &
         0.1389D+00,  0.1315D+00,  0.1215D+00,  0.1188D+00,   &
         0.1096D+00,  0.1130D+00,  0.1000D+00,  0.9284D-01   &
         /
       data (OREF(36, 2, mtmp), mtmp=1,12)   &
         /   &
         0.8851D-01,  0.1012D+00,  0.1195D+00,  0.1310D+00,   &
         0.1389D+00,  0.1315D+00,  0.1215D+00,  0.1188D+00,   &
         0.1096D+00,  0.1130D+00,  0.1000D+00,  0.9284D-01   &
         /
       data (OREF(36, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1010D+00,  0.1076D+00,  0.1214D+00,  0.1341D+00,   &
         0.1389D+00,  0.1315D+00,  0.1215D+00,  0.1188D+00,   &
         0.1158D+00,  0.1161D+00,  0.1080D+00,  0.1047D+00   &
         /
       data (OREF(36, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1075D+00,  0.1141D+00,  0.1232D+00,  0.1378D+00,   &
         0.1478D+00,  0.1383D+00,  0.1278D+00,  0.1248D+00,   &
         0.1245D+00,  0.1194D+00,  0.1123D+00,  0.1098D+00   &
         /
       data (OREF(36, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1156D+00,  0.1226D+00,  0.1260D+00,  0.1353D+00,   &
         0.1491D+00,  0.1462D+00,  0.1458D+00,  0.1338D+00,   &
         0.1291D+00,  0.1191D+00,  0.1144D+00,  0.1148D+00   &
         /
       data (OREF(36, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1215D+00,  0.1276D+00,  0.1264D+00,  0.1286D+00,   &
         0.1349D+00,  0.1366D+00,  0.1448D+00,  0.1314D+00,   &
         0.1259D+00,  0.1176D+00,  0.1172D+00,  0.1198D+00   &
         /
       data (OREF(36, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1211D+00,  0.1246D+00,  0.1214D+00,  0.1230D+00,   &
         0.1287D+00,  0.1337D+00,  0.1372D+00,  0.1253D+00,   &
         0.1221D+00,  0.1187D+00,  0.1206D+00,  0.1240D+00   &
         /
       data (OREF(36, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1144D+00,  0.1133D+00,  0.1177D+00,  0.1244D+00,   &
         0.1307D+00,  0.1333D+00,  0.1305D+00,  0.1237D+00,   &
         0.1230D+00,  0.1219D+00,  0.1238D+00,  0.1261D+00   &
         /
       data (OREF(36, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1111D+00,  0.1069D+00,  0.1180D+00,  0.1272D+00,   &
         0.1333D+00,  0.1329D+00,  0.1275D+00,  0.1244D+00,   &
         0.1252D+00,  0.1248D+00,  0.1290D+00,  0.1305D+00   &
         /
       data (OREF(36,10, mtmp), mtmp=1,12)   &
         /   &
         0.1117D+00,  0.1085D+00,  0.1190D+00,  0.1271D+00,   &
         0.1328D+00,  0.1328D+00,  0.1286D+00,  0.1250D+00,   &
         0.1257D+00,  0.1259D+00,  0.1311D+00,  0.1320D+00   &
         /
       data (OREF(36,11, mtmp), mtmp=1,12)   &
         /   &
         0.1112D+00,  0.1137D+00,  0.1226D+00,  0.1280D+00,   &
         0.1324D+00,  0.1353D+00,  0.1336D+00,  0.1261D+00,   &
         0.1240D+00,  0.1236D+00,  0.1261D+00,  0.1263D+00   &
         /
       data (OREF(36,12, mtmp), mtmp=1,12)   &
         /   &
         0.1153D+00,  0.1169D+00,  0.1260D+00,  0.1299D+00,   &
         0.1315D+00,  0.1363D+00,  0.1390D+00,  0.1274D+00,   &
         0.1217D+00,  0.1173D+00,  0.1204D+00,  0.1237D+00   &
         /
       data (OREF(36,13, mtmp), mtmp=1,12)   &
         /   &
         0.1283D+00,  0.1234D+00,  0.1204D+00,  0.1245D+00,   &
         0.1260D+00,  0.1303D+00,  0.1368D+00,  0.1278D+00,   &
         0.1202D+00,  0.1152D+00,  0.1222D+00,  0.1242D+00   &
         /
       data (OREF(36,14, mtmp), mtmp=1,12)   &
         /   &
         0.1348D+00,  0.1368D+00,  0.1158D+00,  0.1123D+00,   &
         0.1184D+00,  0.1219D+00,  0.1267D+00,  0.1206D+00,   &
         0.1172D+00,  0.1180D+00,  0.1292D+00,  0.1210D+00   &
         /
       data (OREF(36,15, mtmp), mtmp=1,12)   &
         /   &
         0.1253D+00,  0.1402D+00,  0.1219D+00,  0.1089D+00,   &
         0.1100D+00,  0.1131D+00,  0.1148D+00,  0.1111D+00,   &
         0.1131D+00,  0.1217D+00,  0.1271D+00,  0.1123D+00   &
         /
       data (OREF(36,16, mtmp), mtmp=1,12)   &
         /   &
         0.1190D+00,  0.1325D+00,  0.1284D+00,  0.1117D+00,   &
         0.1060D+00,  0.1065D+00,  0.1071D+00,  0.1046D+00,   &
         0.1107D+00,  0.1188D+00,  0.1160D+00,  0.1100D+00   &
         /
       data (OREF(36,17, mtmp), mtmp=1,12)   &
         /   &
         0.1190D+00,  0.1265D+00,  0.1271D+00,  0.1137D+00,   &
         0.1012D+00,  0.9365D-01,  0.9284D-01,  0.9812D-01,   &
         0.1064D+00,  0.1154D+00,  0.1160D+00,  0.1100D+00   &
         /
       data (OREF(36,18, mtmp), mtmp=1,12)   &
         /   &
         0.1190D+00,  0.1265D+00,  0.1271D+00,  0.1137D+00,   &
         0.1012D+00,  0.9365D-01,  0.9284D-01,  0.9812D-01,   &
         0.1064D+00,  0.1154D+00,  0.1160D+00,  0.1100D+00   &
         /
       data (OREF(37, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5933D-01,  0.6786D-01,  0.8010D-01,  0.8781D-01,   &
         0.9308D-01,  0.8818D-01,  0.8146D-01,  0.7965D-01,   &
         0.7348D-01,  0.7575D-01,  0.6704D-01,  0.6223D-01   &
         /
       data (OREF(37, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5933D-01,  0.6786D-01,  0.8010D-01,  0.8781D-01,   &
         0.9308D-01,  0.8818D-01,  0.8146D-01,  0.7965D-01,   &
         0.7348D-01,  0.7575D-01,  0.6704D-01,  0.6223D-01   &
         /
       data (OREF(37, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6768D-01,  0.7212D-01,  0.8137D-01,  0.8990D-01,   &
         0.9308D-01,  0.8818D-01,  0.8146D-01,  0.7965D-01,   &
         0.7765D-01,  0.7784D-01,  0.7239D-01,  0.7022D-01   &
         /
       data (OREF(37, 4, mtmp), mtmp=1,12)   &
         /   &
         0.7203D-01,  0.7648D-01,  0.8255D-01,  0.9235D-01,   &
         0.9906D-01,  0.9271D-01,  0.8564D-01,  0.8364D-01,   &
         0.8346D-01,  0.8001D-01,  0.7530D-01,  0.7357D-01   &
         /
       data (OREF(37, 5, mtmp), mtmp=1,12)   &
         /   &
         0.7747D-01,  0.8219D-01,  0.8446D-01,  0.9072D-01,   &
         0.9997D-01,  0.9798D-01,  0.9770D-01,  0.8972D-01,   &
         0.8654D-01,  0.7983D-01,  0.7666D-01,  0.7693D-01   &
         /
       data (OREF(37, 6, mtmp), mtmp=1,12)   &
         /   &
         0.8146D-01,  0.8555D-01,  0.8473D-01,  0.8618D-01,   &
         0.9045D-01,  0.9153D-01,  0.9707D-01,  0.8809D-01,   &
         0.8437D-01,  0.7883D-01,  0.7856D-01,  0.8029D-01   &
         /
       data (OREF(37, 7, mtmp), mtmp=1,12)   &
         /   &
         0.8119D-01,  0.8355D-01,  0.8137D-01,  0.8246D-01,   &
         0.8627D-01,  0.8963D-01,  0.9199D-01,  0.8400D-01,   &
         0.8183D-01,  0.7956D-01,  0.8083D-01,  0.8310D-01   &
         /
       data (OREF(37, 8, mtmp), mtmp=1,12)   &
         /   &
         0.7666D-01,  0.7593D-01,  0.7892D-01,  0.8337D-01,   &
         0.8763D-01,  0.8936D-01,  0.8745D-01,  0.8292D-01,   &
         0.8246D-01,  0.8174D-01,  0.8301D-01,  0.8455D-01   &
         /
       data (OREF(37, 9, mtmp), mtmp=1,12)   &
         /   &
         0.7448D-01,  0.7167D-01,  0.7911D-01,  0.8527D-01,   &
         0.8936D-01,  0.8909D-01,  0.8546D-01,  0.8337D-01,   &
         0.8391D-01,  0.8364D-01,  0.8645D-01,  0.8745D-01   &
         /
       data (OREF(37,10, mtmp), mtmp=1,12)   &
         /   &
         0.7484D-01,  0.7276D-01,  0.7974D-01,  0.8518D-01,   &
         0.8899D-01,  0.8899D-01,  0.8618D-01,  0.8382D-01,   &
         0.8428D-01,  0.8437D-01,  0.8791D-01,  0.8845D-01   &
         /
       data (OREF(37,11, mtmp), mtmp=1,12)   &
         /   &
         0.7457D-01,  0.7620D-01,  0.8219D-01,  0.8582D-01,   &
         0.8872D-01,  0.9072D-01,  0.8954D-01,  0.8455D-01,   &
         0.8310D-01,  0.8283D-01,  0.8455D-01,  0.8464D-01   &
         /
       data (OREF(37,12, mtmp), mtmp=1,12)   &
         /   &
         0.7729D-01,  0.7838D-01,  0.8446D-01,  0.8709D-01,   &
         0.8818D-01,  0.9135D-01,  0.9317D-01,  0.8537D-01,   &
         0.8156D-01,  0.7865D-01,  0.8074D-01,  0.8292D-01   &
         /
       data (OREF(37,13, mtmp), mtmp=1,12)   &
         /   &
         0.8600D-01,  0.8273D-01,  0.8074D-01,  0.8346D-01,   &
         0.8446D-01,  0.8736D-01,  0.9172D-01,  0.8564D-01,   &
         0.8056D-01,  0.7720D-01,  0.8192D-01,  0.8328D-01   &
         /
       data (OREF(37,14, mtmp), mtmp=1,12)   &
         /   &
         0.9036D-01,  0.9172D-01,  0.7765D-01,  0.7530D-01,   &
         0.7938D-01,  0.8174D-01,  0.8491D-01,  0.8083D-01,   &
         0.7856D-01,  0.7911D-01,  0.8664D-01,  0.8110D-01   &
         /
       data (OREF(37,15, mtmp), mtmp=1,12)   &
         /   &
         0.8400D-01,  0.9398D-01,  0.8174D-01,  0.7303D-01,   &
         0.7375D-01,  0.7584D-01,  0.7693D-01,  0.7448D-01,   &
         0.7584D-01,  0.8156D-01,  0.8518D-01,  0.7530D-01   &
         /
       data (OREF(37,16, mtmp), mtmp=1,12)   &
         /   &
         0.7974D-01,  0.8881D-01,  0.8609D-01,  0.7484D-01,   &
         0.7103D-01,  0.7140D-01,  0.7176D-01,  0.7012D-01,   &
         0.7421D-01,  0.7965D-01,  0.7775D-01,  0.7375D-01   &
         /
       data (OREF(37,17, mtmp), mtmp=1,12)   &
         /   &
         0.7974D-01,  0.8482D-01,  0.8518D-01,  0.7620D-01,   &
         0.6786D-01,  0.6278D-01,  0.6223D-01,  0.6577D-01,   &
         0.7130D-01,  0.7738D-01,  0.7775D-01,  0.7375D-01   &
         /
       data (OREF(37,18, mtmp), mtmp=1,12)   &
         /   &
         0.7974D-01,  0.8482D-01,  0.8518D-01,  0.7620D-01,   &
         0.6786D-01,  0.6278D-01,  0.6223D-01,  0.6577D-01,   &
         0.7130D-01,  0.7738D-01,  0.7775D-01,  0.7375D-01   &
         /
       data (OREF(38, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3977D-01,  0.4549D-01,  0.5370D-01,  0.5886D-01,   &
         0.6239D-01,  0.5911D-01,  0.5461D-01,  0.5339D-01,   &
         0.4926D-01,  0.5078D-01,  0.4494D-01,  0.4172D-01   &
         /
       data (OREF(38, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3977D-01,  0.4549D-01,  0.5370D-01,  0.5886D-01,   &
         0.6239D-01,  0.5911D-01,  0.5461D-01,  0.5339D-01,   &
         0.4926D-01,  0.5078D-01,  0.4494D-01,  0.4172D-01   &
         /
       data (OREF(38, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4536D-01,  0.4834D-01,  0.5455D-01,  0.6026D-01,   &
         0.6239D-01,  0.5911D-01,  0.5461D-01,  0.5339D-01,   &
         0.5205D-01,  0.5218D-01,  0.4853D-01,  0.4707D-01   &
         /
       data (OREF(38, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4828D-01,  0.5126D-01,  0.5534D-01,  0.6190D-01,   &
         0.6640D-01,  0.6215D-01,  0.5740D-01,  0.5607D-01,   &
         0.5595D-01,  0.5363D-01,  0.5047D-01,  0.4932D-01   &
         /
       data (OREF(38, 5, mtmp), mtmp=1,12)   &
         /   &
         0.5193D-01,  0.5509D-01,  0.5661D-01,  0.6081D-01,   &
         0.6701D-01,  0.6567D-01,  0.6549D-01,  0.6014D-01,   &
         0.5801D-01,  0.5351D-01,  0.5138D-01,  0.5157D-01   &
         /
       data (OREF(38, 6, mtmp), mtmp=1,12)   &
         /   &
         0.5461D-01,  0.5734D-01,  0.5680D-01,  0.5777D-01,   &
         0.6063D-01,  0.6136D-01,  0.6507D-01,  0.5905D-01,   &
         0.5655D-01,  0.5284D-01,  0.5266D-01,  0.5382D-01   &
         /
       data (OREF(38, 7, mtmp), mtmp=1,12)   &
         /   &
         0.5443D-01,  0.5601D-01,  0.5455D-01,  0.5528D-01,   &
         0.5783D-01,  0.6008D-01,  0.6166D-01,  0.5631D-01,   &
         0.5485D-01,  0.5333D-01,  0.5418D-01,  0.5570D-01   &
         /
       data (OREF(38, 8, mtmp), mtmp=1,12)   &
         /   &
         0.5138D-01,  0.5090D-01,  0.5290D-01,  0.5588D-01,   &
         0.5874D-01,  0.5990D-01,  0.5862D-01,  0.5558D-01,   &
         0.5528D-01,  0.5479D-01,  0.5564D-01,  0.5667D-01   &
         /
       data (OREF(38, 9, mtmp), mtmp=1,12)   &
         /   &
         0.4993D-01,  0.4804D-01,  0.5303D-01,  0.5716D-01,   &
         0.5990D-01,  0.5972D-01,  0.5728D-01,  0.5588D-01,   &
         0.5625D-01,  0.5607D-01,  0.5795D-01,  0.5862D-01   &
         /
       data (OREF(38,10, mtmp), mtmp=1,12)   &
         /   &
         0.5017D-01,  0.4877D-01,  0.5345D-01,  0.5710D-01,   &
         0.5965D-01,  0.5965D-01,  0.5777D-01,  0.5619D-01,   &
         0.5649D-01,  0.5655D-01,  0.5892D-01,  0.5929D-01   &
         /
       data (OREF(38,11, mtmp), mtmp=1,12)   &
         /   &
         0.4999D-01,  0.5108D-01,  0.5509D-01,  0.5753D-01,   &
         0.5947D-01,  0.6081D-01,  0.6002D-01,  0.5667D-01,   &
         0.5570D-01,  0.5552D-01,  0.5667D-01,  0.5674D-01   &
         /
       data (OREF(38,12, mtmp), mtmp=1,12)   &
         /   &
         0.5181D-01,  0.5254D-01,  0.5661D-01,  0.5838D-01,   &
         0.5911D-01,  0.6124D-01,  0.6245D-01,  0.5722D-01,   &
         0.5467D-01,  0.5272D-01,  0.5412D-01,  0.5558D-01   &
         /
       data (OREF(38,13, mtmp), mtmp=1,12)   &
         /   &
         0.5765D-01,  0.5546D-01,  0.5412D-01,  0.5595D-01,   &
         0.5661D-01,  0.5856D-01,  0.6148D-01,  0.5740D-01,   &
         0.5400D-01,  0.5175D-01,  0.5491D-01,  0.5582D-01   &
         /
       data (OREF(38,14, mtmp), mtmp=1,12)   &
         /   &
         0.6057D-01,  0.6148D-01,  0.5205D-01,  0.5047D-01,   &
         0.5321D-01,  0.5479D-01,  0.5692D-01,  0.5418D-01,   &
         0.5266D-01,  0.5303D-01,  0.5807D-01,  0.5436D-01   &
         /
       data (OREF(38,15, mtmp), mtmp=1,12)   &
         /   &
         0.5631D-01,  0.6300D-01,  0.5479D-01,  0.4895D-01,   &
         0.4944D-01,  0.5084D-01,  0.5157D-01,  0.4993D-01,   &
         0.5084D-01,  0.5467D-01,  0.5710D-01,  0.5047D-01   &
         /
       data (OREF(38,16, mtmp), mtmp=1,12)   &
         /   &
         0.5345D-01,  0.5953D-01,  0.5771D-01,  0.5017D-01,   &
         0.4761D-01,  0.4786D-01,  0.4810D-01,  0.4701D-01,   &
         0.4974D-01,  0.5339D-01,  0.5211D-01,  0.4944D-01   &
         /
       data (OREF(38,17, mtmp), mtmp=1,12)   &
         /   &
         0.5345D-01,  0.5686D-01,  0.5710D-01,  0.5108D-01,   &
         0.4549D-01,  0.4208D-01,  0.4172D-01,  0.4409D-01,   &
         0.4780D-01,  0.5187D-01,  0.5211D-01,  0.4944D-01   &
         /
       data (OREF(38,18, mtmp), mtmp=1,12)   &
         /   &
         0.5345D-01,  0.5686D-01,  0.5710D-01,  0.5108D-01,   &
         0.4549D-01,  0.4208D-01,  0.4172D-01,  0.4409D-01,   &
         0.4780D-01,  0.5187D-01,  0.5211D-01,  0.4944D-01   &
         /
       data (OREF(39, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2666D-01,  0.3049D-01,  0.3599D-01,  0.3946D-01,   &
         0.4182D-01,  0.3962D-01,  0.3660D-01,  0.3579D-01,   &
         0.3302D-01,  0.3404D-01,  0.3012D-01,  0.2796D-01   &
         /
       data (OREF(39, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2666D-01,  0.3049D-01,  0.3599D-01,  0.3946D-01,   &
         0.4182D-01,  0.3962D-01,  0.3660D-01,  0.3579D-01,   &
         0.3302D-01,  0.3404D-01,  0.3012D-01,  0.2796D-01   &
         /
       data (OREF(39, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3041D-01,  0.3241D-01,  0.3656D-01,  0.4040D-01,   &
         0.4182D-01,  0.3962D-01,  0.3660D-01,  0.3579D-01,   &
         0.3489D-01,  0.3497D-01,  0.3253D-01,  0.3155D-01   &
         /
       data (OREF(39, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3237D-01,  0.3436D-01,  0.3709D-01,  0.4150D-01,   &
         0.4451D-01,  0.4166D-01,  0.3848D-01,  0.3758D-01,   &
         0.3750D-01,  0.3595D-01,  0.3383D-01,  0.3306D-01   &
         /
       data (OREF(39, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3481D-01,  0.3693D-01,  0.3795D-01,  0.4076D-01,   &
         0.4492D-01,  0.4402D-01,  0.4390D-01,  0.4031D-01,   &
         0.3889D-01,  0.3587D-01,  0.3444D-01,  0.3457D-01   &
         /
       data (OREF(39, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3660D-01,  0.3844D-01,  0.3807D-01,  0.3872D-01,   &
         0.4064D-01,  0.4113D-01,  0.4362D-01,  0.3958D-01,   &
         0.3791D-01,  0.3542D-01,  0.3530D-01,  0.3607D-01   &
         /
       data (OREF(39, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3648D-01,  0.3754D-01,  0.3656D-01,  0.3705D-01,   &
         0.3876D-01,  0.4027D-01,  0.4133D-01,  0.3775D-01,   &
         0.3677D-01,  0.3575D-01,  0.3632D-01,  0.3734D-01   &
         /
       data (OREF(39, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3444D-01,  0.3412D-01,  0.3546D-01,  0.3746D-01,   &
         0.3938D-01,  0.4015D-01,  0.3929D-01,  0.3726D-01,   &
         0.3705D-01,  0.3673D-01,  0.3730D-01,  0.3799D-01   &
         /
       data (OREF(39, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3347D-01,  0.3220D-01,  0.3554D-01,  0.3832D-01,   &
         0.4015D-01,  0.4003D-01,  0.3840D-01,  0.3746D-01,   &
         0.3771D-01,  0.3758D-01,  0.3885D-01,  0.3929D-01   &
         /
       data (OREF(39,10, mtmp), mtmp=1,12)   &
         /   &
         0.3363D-01,  0.3269D-01,  0.3583D-01,  0.3828D-01,   &
         0.3999D-01,  0.3999D-01,  0.3872D-01,  0.3766D-01,   &
         0.3787D-01,  0.3791D-01,  0.3950D-01,  0.3974D-01   &
         /
       data (OREF(39,11, mtmp), mtmp=1,12)   &
         /   &
         0.3351D-01,  0.3424D-01,  0.3693D-01,  0.3856D-01,   &
         0.3987D-01,  0.4076D-01,  0.4023D-01,  0.3799D-01,   &
         0.3734D-01,  0.3722D-01,  0.3799D-01,  0.3803D-01   &
         /
       data (OREF(39,12, mtmp), mtmp=1,12)   &
         /   &
         0.3473D-01,  0.3522D-01,  0.3795D-01,  0.3913D-01,   &
         0.3962D-01,  0.4105D-01,  0.4186D-01,  0.3836D-01,   &
         0.3665D-01,  0.3534D-01,  0.3628D-01,  0.3726D-01   &
         /
       data (OREF(39,13, mtmp), mtmp=1,12)   &
         /   &
         0.3864D-01,  0.3718D-01,  0.3628D-01,  0.3750D-01,   &
         0.3795D-01,  0.3925D-01,  0.4121D-01,  0.3848D-01,   &
         0.3620D-01,  0.3469D-01,  0.3681D-01,  0.3742D-01   &
         /
       data (OREF(39,14, mtmp), mtmp=1,12)   &
         /   &
         0.4060D-01,  0.4121D-01,  0.3489D-01,  0.3383D-01,   &
         0.3567D-01,  0.3673D-01,  0.3815D-01,  0.3632D-01,   &
         0.3530D-01,  0.3554D-01,  0.3893D-01,  0.3644D-01   &
         /
       data (OREF(39,15, mtmp), mtmp=1,12)   &
         /   &
         0.3775D-01,  0.4223D-01,  0.3673D-01,  0.3281D-01,   &
         0.3314D-01,  0.3408D-01,  0.3457D-01,  0.3347D-01,   &
         0.3408D-01,  0.3665D-01,  0.3828D-01,  0.3383D-01   &
         /
       data (OREF(39,16, mtmp), mtmp=1,12)   &
         /   &
         0.3583D-01,  0.3991D-01,  0.3868D-01,  0.3363D-01,   &
         0.3192D-01,  0.3208D-01,  0.3224D-01,  0.3151D-01,   &
         0.3334D-01,  0.3579D-01,  0.3493D-01,  0.3314D-01   &
         /
       data (OREF(39,17, mtmp), mtmp=1,12)   &
         /   &
         0.3583D-01,  0.3811D-01,  0.3828D-01,  0.3424D-01,   &
         0.3049D-01,  0.2821D-01,  0.2796D-01,  0.2955D-01,   &
         0.3204D-01,  0.3477D-01,  0.3493D-01,  0.3314D-01   &
         /
       data (OREF(39,18, mtmp), mtmp=1,12)   &
         /   &
         0.3583D-01,  0.3811D-01,  0.3828D-01,  0.3424D-01,   &
         0.3049D-01,  0.2821D-01,  0.2796D-01,  0.2955D-01,   &
         0.3204D-01,  0.3477D-01,  0.3493D-01,  0.3314D-01   &
         /
       data (OREF(40, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1787D-01,  0.2044D-01,  0.2413D-01,  0.2645D-01,   &
         0.2803D-01,  0.2656D-01,  0.2454D-01,  0.2399D-01,   &
         0.2213D-01,  0.2282D-01,  0.2019D-01,  0.1874D-01   &
         /
       data (OREF(40, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1787D-01,  0.2044D-01,  0.2413D-01,  0.2645D-01,   &
         0.2803D-01,  0.2656D-01,  0.2454D-01,  0.2399D-01,   &
         0.2213D-01,  0.2282D-01,  0.2019D-01,  0.1874D-01   &
         /
       data (OREF(40, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2038D-01,  0.2172D-01,  0.2451D-01,  0.2708D-01,   &
         0.2803D-01,  0.2656D-01,  0.2454D-01,  0.2399D-01,   &
         0.2339D-01,  0.2344D-01,  0.2180D-01,  0.2115D-01   &
         /
       data (OREF(40, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2170D-01,  0.2303D-01,  0.2486D-01,  0.2782D-01,   &
         0.2984D-01,  0.2792D-01,  0.2579D-01,  0.2519D-01,   &
         0.2514D-01,  0.2410D-01,  0.2268D-01,  0.2216D-01   &
         /
       data (OREF(40, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2333D-01,  0.2476D-01,  0.2544D-01,  0.2732D-01,   &
         0.3011D-01,  0.2951D-01,  0.2943D-01,  0.2702D-01,   &
         0.2607D-01,  0.2404D-01,  0.2309D-01,  0.2317D-01   &
         /
       data (OREF(40, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2454D-01,  0.2577D-01,  0.2552D-01,  0.2596D-01,   &
         0.2724D-01,  0.2757D-01,  0.2924D-01,  0.2653D-01,   &
         0.2541D-01,  0.2374D-01,  0.2366D-01,  0.2418D-01   &
         /
       data (OREF(40, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2445D-01,  0.2517D-01,  0.2451D-01,  0.2484D-01,   &
         0.2598D-01,  0.2700D-01,  0.2771D-01,  0.2530D-01,   &
         0.2465D-01,  0.2396D-01,  0.2435D-01,  0.2503D-01   &
         /
       data (OREF(40, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2309D-01,  0.2287D-01,  0.2377D-01,  0.2511D-01,   &
         0.2639D-01,  0.2691D-01,  0.2634D-01,  0.2497D-01,   &
         0.2484D-01,  0.2462D-01,  0.2500D-01,  0.2547D-01   &
         /
       data (OREF(40, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2243D-01,  0.2159D-01,  0.2383D-01,  0.2568D-01,   &
         0.2691D-01,  0.2683D-01,  0.2574D-01,  0.2511D-01,   &
         0.2527D-01,  0.2519D-01,  0.2604D-01,  0.2634D-01   &
         /
       data (OREF(40,10, mtmp), mtmp=1,12)   &
         /   &
         0.2254D-01,  0.2191D-01,  0.2402D-01,  0.2566D-01,   &
         0.2680D-01,  0.2680D-01,  0.2596D-01,  0.2525D-01,   &
         0.2538D-01,  0.2541D-01,  0.2648D-01,  0.2664D-01   &
         /
       data (OREF(40,11, mtmp), mtmp=1,12)   &
         /   &
         0.2246D-01,  0.2295D-01,  0.2476D-01,  0.2585D-01,   &
         0.2672D-01,  0.2732D-01,  0.2697D-01,  0.2547D-01,   &
         0.2503D-01,  0.2495D-01,  0.2547D-01,  0.2549D-01   &
         /
       data (OREF(40,12, mtmp), mtmp=1,12)   &
         /   &
         0.2328D-01,  0.2361D-01,  0.2544D-01,  0.2623D-01,   &
         0.2656D-01,  0.2751D-01,  0.2806D-01,  0.2571D-01,   &
         0.2456D-01,  0.2369D-01,  0.2432D-01,  0.2497D-01   &
         /
       data (OREF(40,13, mtmp), mtmp=1,12)   &
         /   &
         0.2590D-01,  0.2492D-01,  0.2432D-01,  0.2514D-01,   &
         0.2544D-01,  0.2631D-01,  0.2762D-01,  0.2579D-01,   &
         0.2426D-01,  0.2325D-01,  0.2467D-01,  0.2508D-01   &
         /
       data (OREF(40,14, mtmp), mtmp=1,12)   &
         /   &
         0.2721D-01,  0.2762D-01,  0.2339D-01,  0.2268D-01,   &
         0.2391D-01,  0.2462D-01,  0.2558D-01,  0.2435D-01,   &
         0.2366D-01,  0.2383D-01,  0.2609D-01,  0.2443D-01   &
         /
       data (OREF(40,15, mtmp), mtmp=1,12)   &
         /   &
         0.2530D-01,  0.2831D-01,  0.2462D-01,  0.2200D-01,   &
         0.2221D-01,  0.2284D-01,  0.2317D-01,  0.2243D-01,   &
         0.2284D-01,  0.2456D-01,  0.2566D-01,  0.2268D-01   &
         /
       data (OREF(40,16, mtmp), mtmp=1,12)   &
         /   &
         0.2402D-01,  0.2675D-01,  0.2593D-01,  0.2254D-01,   &
         0.2139D-01,  0.2150D-01,  0.2161D-01,  0.2112D-01,   &
         0.2235D-01,  0.2399D-01,  0.2342D-01,  0.2221D-01   &
         /
       data (OREF(40,17, mtmp), mtmp=1,12)   &
         /   &
         0.2402D-01,  0.2555D-01,  0.2566D-01,  0.2295D-01,   &
         0.2044D-01,  0.1891D-01,  0.1874D-01,  0.1981D-01,   &
         0.2148D-01,  0.2331D-01,  0.2342D-01,  0.2221D-01   &
         /
       data (OREF(40,18, mtmp), mtmp=1,12)   &
         /   &
         0.2402D-01,  0.2555D-01,  0.2566D-01,  0.2295D-01,   &
         0.2044D-01,  0.1891D-01,  0.1874D-01,  0.1981D-01,   &
         0.2148D-01,  0.2331D-01,  0.2342D-01,  0.2221D-01   &
         /
       data (OREF(41, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1198D-01,  0.1370D-01,  0.1617D-01,  0.1773D-01,   &
         0.1879D-01,  0.1780D-01,  0.1645D-01,  0.1608D-01,   &
         0.1484D-01,  0.1529D-01,  0.1354D-01,  0.1256D-01   &
         /
       data (OREF(41, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1198D-01,  0.1370D-01,  0.1617D-01,  0.1773D-01,   &
         0.1879D-01,  0.1780D-01,  0.1645D-01,  0.1608D-01,   &
         0.1484D-01,  0.1529D-01,  0.1354D-01,  0.1256D-01   &
         /
       data (OREF(41, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1366D-01,  0.1456D-01,  0.1643D-01,  0.1815D-01,   &
         0.1879D-01,  0.1780D-01,  0.1645D-01,  0.1608D-01,   &
         0.1568D-01,  0.1571D-01,  0.1462D-01,  0.1418D-01   &
         /
       data (OREF(41, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1454D-01,  0.1544D-01,  0.1667D-01,  0.1865D-01,   &
         0.2000D-01,  0.1872D-01,  0.1729D-01,  0.1689D-01,   &
         0.1685D-01,  0.1615D-01,  0.1520D-01,  0.1485D-01   &
         /
       data (OREF(41, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1564D-01,  0.1659D-01,  0.1705D-01,  0.1832D-01,   &
         0.2018D-01,  0.1978D-01,  0.1973D-01,  0.1811D-01,   &
         0.1747D-01,  0.1612D-01,  0.1548D-01,  0.1553D-01   &
         /
       data (OREF(41, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1645D-01,  0.1727D-01,  0.1711D-01,  0.1740D-01,   &
         0.1826D-01,  0.1848D-01,  0.1960D-01,  0.1778D-01,   &
         0.1703D-01,  0.1592D-01,  0.1586D-01,  0.1621D-01   &
         /
       data (OREF(41, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1639D-01,  0.1687D-01,  0.1643D-01,  0.1665D-01,   &
         0.1742D-01,  0.1810D-01,  0.1857D-01,  0.1696D-01,   &
         0.1652D-01,  0.1606D-01,  0.1632D-01,  0.1678D-01   &
         /
       data (OREF(41, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1548D-01,  0.1533D-01,  0.1593D-01,  0.1683D-01,   &
         0.1769D-01,  0.1804D-01,  0.1766D-01,  0.1674D-01,   &
         0.1665D-01,  0.1650D-01,  0.1676D-01,  0.1707D-01   &
         /
       data (OREF(41, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1504D-01,  0.1447D-01,  0.1597D-01,  0.1722D-01,   &
         0.1804D-01,  0.1799D-01,  0.1725D-01,  0.1683D-01,   &
         0.1694D-01,  0.1689D-01,  0.1745D-01,  0.1766D-01   &
         /
       data (OREF(41,10, mtmp), mtmp=1,12)   &
         /   &
         0.1511D-01,  0.1469D-01,  0.1610D-01,  0.1720D-01,   &
         0.1797D-01,  0.1797D-01,  0.1740D-01,  0.1692D-01,   &
         0.1702D-01,  0.1703D-01,  0.1775D-01,  0.1786D-01   &
         /
       data (OREF(41,11, mtmp), mtmp=1,12)   &
         /   &
         0.1506D-01,  0.1539D-01,  0.1659D-01,  0.1733D-01,   &
         0.1791D-01,  0.1832D-01,  0.1808D-01,  0.1707D-01,   &
         0.1678D-01,  0.1672D-01,  0.1707D-01,  0.1709D-01   &
         /
       data (OREF(41,12, mtmp), mtmp=1,12)   &
         /   &
         0.1560D-01,  0.1582D-01,  0.1705D-01,  0.1758D-01,   &
         0.1780D-01,  0.1844D-01,  0.1881D-01,  0.1724D-01,   &
         0.1647D-01,  0.1588D-01,  0.1630D-01,  0.1674D-01   &
         /
       data (OREF(41,13, mtmp), mtmp=1,12)   &
         /   &
         0.1736D-01,  0.1670D-01,  0.1630D-01,  0.1685D-01,   &
         0.1705D-01,  0.1764D-01,  0.1852D-01,  0.1729D-01,   &
         0.1626D-01,  0.1559D-01,  0.1654D-01,  0.1681D-01   &
         /
       data (OREF(41,14, mtmp), mtmp=1,12)   &
         /   &
         0.1824D-01,  0.1852D-01,  0.1568D-01,  0.1520D-01,   &
         0.1603D-01,  0.1650D-01,  0.1714D-01,  0.1632D-01,   &
         0.1586D-01,  0.1597D-01,  0.1749D-01,  0.1637D-01   &
         /
       data (OREF(41,15, mtmp), mtmp=1,12)   &
         /   &
         0.1696D-01,  0.1898D-01,  0.1650D-01,  0.1474D-01,   &
         0.1489D-01,  0.1531D-01,  0.1553D-01,  0.1504D-01,   &
         0.1531D-01,  0.1647D-01,  0.1720D-01,  0.1520D-01   &
         /
       data (OREF(41,16, mtmp), mtmp=1,12)   &
         /   &
         0.1610D-01,  0.1793D-01,  0.1738D-01,  0.1511D-01,   &
         0.1434D-01,  0.1441D-01,  0.1449D-01,  0.1416D-01,   &
         0.1498D-01,  0.1608D-01,  0.1570D-01,  0.1489D-01   &
         /
       data (OREF(41,17, mtmp), mtmp=1,12)   &
         /   &
         0.1610D-01,  0.1713D-01,  0.1720D-01,  0.1539D-01,   &
         0.1370D-01,  0.1267D-01,  0.1256D-01,  0.1328D-01,   &
         0.1440D-01,  0.1562D-01,  0.1570D-01,  0.1489D-01   &
         /
       data (OREF(41,18, mtmp), mtmp=1,12)   &
         /   &
         0.1610D-01,  0.1713D-01,  0.1720D-01,  0.1539D-01,   &
         0.1370D-01,  0.1267D-01,  0.1256D-01,  0.1328D-01,   &
         0.1440D-01,  0.1562D-01,  0.1570D-01,  0.1489D-01   &
         /
       data (OREF(42, 1, mtmp), mtmp=1,12)   &
         /   &
         0.8029D-02,  0.9183D-02,  0.1084D-01,  0.1188D-01,   &
         0.1260D-01,  0.1193D-01,  0.1103D-01,  0.1078D-01,   &
         0.9945D-02,  0.1025D-01,  0.9073D-02,  0.8422D-02   &
         /
       data (OREF(42, 2, mtmp), mtmp=1,12)   &
         /   &
         0.8029D-02,  0.9183D-02,  0.1084D-01,  0.1188D-01,   &
         0.1260D-01,  0.1193D-01,  0.1103D-01,  0.1078D-01,   &
         0.9945D-02,  0.1025D-01,  0.9073D-02,  0.8422D-02   &
         /
       data (OREF(42, 3, mtmp), mtmp=1,12)   &
         /   &
         0.9159D-02,  0.9760D-02,  0.1101D-01,  0.1217D-01,   &
         0.1260D-01,  0.1193D-01,  0.1103D-01,  0.1078D-01,   &
         0.1051D-01,  0.1053D-01,  0.9797D-02,  0.9503D-02   &
         /
       data (OREF(42, 4, mtmp), mtmp=1,12)   &
         /   &
         0.9748D-02,  0.1035D-01,  0.1117D-01,  0.1250D-01,   &
         0.1341D-01,  0.1255D-01,  0.1159D-01,  0.1132D-01,   &
         0.1130D-01,  0.1083D-01,  0.1019D-01,  0.9957D-02   &
         /
       data (OREF(42, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1048D-01,  0.1112D-01,  0.1143D-01,  0.1228D-01,   &
         0.1353D-01,  0.1326D-01,  0.1322D-01,  0.1214D-01,   &
         0.1171D-01,  0.1080D-01,  0.1037D-01,  0.1041D-01   &
         /
       data (OREF(42, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1103D-01,  0.1158D-01,  0.1147D-01,  0.1166D-01,   &
         0.1224D-01,  0.1239D-01,  0.1314D-01,  0.1192D-01,   &
         0.1142D-01,  0.1067D-01,  0.1063D-01,  0.1087D-01   &
         /
       data (OREF(42, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1099D-01,  0.1131D-01,  0.1101D-01,  0.1116D-01,   &
         0.1168D-01,  0.1213D-01,  0.1245D-01,  0.1137D-01,   &
         0.1107D-01,  0.1077D-01,  0.1094D-01,  0.1125D-01   &
         /
       data (OREF(42, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1037D-01,  0.1028D-01,  0.1068D-01,  0.1128D-01,   &
         0.1186D-01,  0.1209D-01,  0.1184D-01,  0.1122D-01,   &
         0.1116D-01,  0.1106D-01,  0.1123D-01,  0.1144D-01   &
         /
       data (OREF(42, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1008D-01,  0.9699D-02,  0.1071D-01,  0.1154D-01,   &
         0.1209D-01,  0.1206D-01,  0.1157D-01,  0.1128D-01,   &
         0.1136D-01,  0.1132D-01,  0.1170D-01,  0.1184D-01   &
         /
       data (OREF(42,10, mtmp), mtmp=1,12)   &
         /   &
         0.1013D-01,  0.9846D-02,  0.1079D-01,  0.1153D-01,   &
         0.1204D-01,  0.1204D-01,  0.1166D-01,  0.1134D-01,   &
         0.1141D-01,  0.1142D-01,  0.1190D-01,  0.1197D-01   &
         /
       data (OREF(42,11, mtmp), mtmp=1,12)   &
         /   &
         0.1009D-01,  0.1031D-01,  0.1112D-01,  0.1161D-01,   &
         0.1201D-01,  0.1228D-01,  0.1212D-01,  0.1144D-01,   &
         0.1125D-01,  0.1121D-01,  0.1144D-01,  0.1145D-01   &
         /
       data (OREF(42,12, mtmp), mtmp=1,12)   &
         /   &
         0.1046D-01,  0.1061D-01,  0.1143D-01,  0.1179D-01,   &
         0.1193D-01,  0.1236D-01,  0.1261D-01,  0.1155D-01,   &
         0.1104D-01,  0.1064D-01,  0.1093D-01,  0.1122D-01   &
         /
       data (OREF(42,13, mtmp), mtmp=1,12)   &
         /   &
         0.1164D-01,  0.1120D-01,  0.1093D-01,  0.1130D-01,   &
         0.1143D-01,  0.1182D-01,  0.1241D-01,  0.1159D-01,   &
         0.1090D-01,  0.1045D-01,  0.1109D-01,  0.1127D-01   &
         /
       data (OREF(42,14, mtmp), mtmp=1,12)   &
         /   &
         0.1223D-01,  0.1241D-01,  0.1051D-01,  0.1019D-01,   &
         0.1074D-01,  0.1106D-01,  0.1149D-01,  0.1094D-01,   &
         0.1063D-01,  0.1071D-01,  0.1172D-01,  0.1098D-01   &
         /
       data (OREF(42,15, mtmp), mtmp=1,12)   &
         /   &
         0.1137D-01,  0.1272D-01,  0.1106D-01,  0.9883D-02,   &
         0.9981D-02,  0.1026D-01,  0.1041D-01,  0.1008D-01,   &
         0.1026D-01,  0.1104D-01,  0.1153D-01,  0.1019D-01   &
         /
       data (OREF(42,16, mtmp), mtmp=1,12)   &
         /   &
         0.1079D-01,  0.1202D-01,  0.1165D-01,  0.1013D-01,   &
         0.9613D-02,  0.9662D-02,  0.9711D-02,  0.9490D-02,   &
         0.1004D-01,  0.1078D-01,  0.1052D-01,  0.9981D-02   &
         /
       data (OREF(42,17, mtmp), mtmp=1,12)   &
         /   &
         0.1079D-01,  0.1148D-01,  0.1153D-01,  0.1031D-01,   &
         0.9183D-02,  0.8496D-02,  0.8422D-02,  0.8901D-02,   &
         0.9650D-02,  0.1047D-01,  0.1052D-01,  0.9981D-02   &
         /
       data (OREF(42,18, mtmp), mtmp=1,12)   &
         /   &
         0.1079D-01,  0.1148D-01,  0.1153D-01,  0.1031D-01,   &
         0.9183D-02,  0.8496D-02,  0.8422D-02,  0.8901D-02,   &
         0.9650D-02,  0.1047D-01,  0.1052D-01,  0.9981D-02   &
         /
       data (OREF(43, 1, mtmp), mtmp=1,12)   &
         /   &
         0.5382D-02,  0.6156D-02,  0.7267D-02,  0.7966D-02,   &
         0.8444D-02,  0.7999D-02,  0.7390D-02,  0.7226D-02,   &
         0.6666D-02,  0.6872D-02,  0.6082D-02,  0.5646D-02   &
         /
       data (OREF(43, 2, mtmp), mtmp=1,12)   &
         /   &
         0.5382D-02,  0.6156D-02,  0.7267D-02,  0.7966D-02,   &
         0.8444D-02,  0.7999D-02,  0.7390D-02,  0.7226D-02,   &
         0.6666D-02,  0.6872D-02,  0.6082D-02,  0.5646D-02   &
         /
       data (OREF(43, 3, mtmp), mtmp=1,12)   &
         /   &
         0.6139D-02,  0.6543D-02,  0.7382D-02,  0.8156D-02,   &
         0.8444D-02,  0.7999D-02,  0.7390D-02,  0.7226D-02,   &
         0.7045D-02,  0.7061D-02,  0.6567D-02,  0.6370D-02   &
         /
       data (OREF(43, 4, mtmp), mtmp=1,12)   &
         /   &
         0.6534D-02,  0.6938D-02,  0.7489D-02,  0.8378D-02,   &
         0.8987D-02,  0.8411D-02,  0.7769D-02,  0.7588D-02,   &
         0.7571D-02,  0.7259D-02,  0.6831D-02,  0.6674D-02   &
         /
       data (OREF(43, 5, mtmp), mtmp=1,12)   &
         /   &
         0.7028D-02,  0.7456D-02,  0.7662D-02,  0.8230D-02,   &
         0.9069D-02,  0.8888D-02,  0.8863D-02,  0.8139D-02,   &
         0.7851D-02,  0.7242D-02,  0.6954D-02,  0.6979D-02   &
         /
       data (OREF(43, 6, mtmp), mtmp=1,12)   &
         /   &
         0.7390D-02,  0.7761D-02,  0.7687D-02,  0.7818D-02,   &
         0.8205D-02,  0.8304D-02,  0.8806D-02,  0.7991D-02,   &
         0.7654D-02,  0.7152D-02,  0.7127D-02,  0.7283D-02   &
         /
       data (OREF(43, 7, mtmp), mtmp=1,12)   &
         /   &
         0.7366D-02,  0.7580D-02,  0.7382D-02,  0.7481D-02,   &
         0.7826D-02,  0.8131D-02,  0.8345D-02,  0.7621D-02,   &
         0.7423D-02,  0.7217D-02,  0.7333D-02,  0.7538D-02   &
         /
       data (OREF(43, 8, mtmp), mtmp=1,12)   &
         /   &
         0.6954D-02,  0.6888D-02,  0.7160D-02,  0.7563D-02,   &
         0.7950D-02,  0.8106D-02,  0.7933D-02,  0.7522D-02,   &
         0.7481D-02,  0.7415D-02,  0.7530D-02,  0.7670D-02   &
         /
       data (OREF(43, 9, mtmp), mtmp=1,12)   &
         /   &
         0.6757D-02,  0.6502D-02,  0.7176D-02,  0.7736D-02,   &
         0.8106D-02,  0.8082D-02,  0.7752D-02,  0.7563D-02,   &
         0.7613D-02,  0.7588D-02,  0.7843D-02,  0.7933D-02   &
         /
       data (OREF(43,10, mtmp), mtmp=1,12)   &
         /   &
         0.6790D-02,  0.6600D-02,  0.7234D-02,  0.7728D-02,   &
         0.8073D-02,  0.8073D-02,  0.7818D-02,  0.7604D-02,   &
         0.7645D-02,  0.7654D-02,  0.7975D-02,  0.8024D-02   &
         /
       data (OREF(43,11, mtmp), mtmp=1,12)   &
         /   &
         0.6765D-02,  0.6913D-02,  0.7456D-02,  0.7785D-02,   &
         0.8049D-02,  0.8230D-02,  0.8123D-02,  0.7670D-02,   &
         0.7538D-02,  0.7514D-02,  0.7670D-02,  0.7678D-02   &
         /
       data (OREF(43,12, mtmp), mtmp=1,12)   &
         /   &
         0.7012D-02,  0.7111D-02,  0.7662D-02,  0.7901D-02,   &
         0.7999D-02,  0.8287D-02,  0.8452D-02,  0.7744D-02,   &
         0.7399D-02,  0.7135D-02,  0.7324D-02,  0.7522D-02   &
         /
       data (OREF(43,13, mtmp), mtmp=1,12)   &
         /   &
         0.7802D-02,  0.7506D-02,  0.7324D-02,  0.7571D-02,   &
         0.7662D-02,  0.7925D-02,  0.8320D-02,  0.7769D-02,   &
         0.7308D-02,  0.7004D-02,  0.7431D-02,  0.7555D-02   &
         /
       data (OREF(43,14, mtmp), mtmp=1,12)   &
         /   &
         0.8197D-02,  0.8320D-02,  0.7045D-02,  0.6831D-02,   &
         0.7201D-02,  0.7415D-02,  0.7703D-02,  0.7333D-02,   &
         0.7127D-02,  0.7176D-02,  0.7859D-02,  0.7357D-02   &
         /
       data (OREF(43,15, mtmp), mtmp=1,12)   &
         /   &
         0.7621D-02,  0.8526D-02,  0.7415D-02,  0.6625D-02,   &
         0.6691D-02,  0.6880D-02,  0.6979D-02,  0.6757D-02,   &
         0.6880D-02,  0.7399D-02,  0.7728D-02,  0.6831D-02   &
         /
       data (OREF(43,16, mtmp), mtmp=1,12)   &
         /   &
         0.7234D-02,  0.8057D-02,  0.7810D-02,  0.6790D-02,   &
         0.6444D-02,  0.6477D-02,  0.6510D-02,  0.6362D-02,   &
         0.6732D-02,  0.7226D-02,  0.7053D-02,  0.6691D-02   &
         /
       data (OREF(43,17, mtmp), mtmp=1,12)   &
         /   &
         0.7234D-02,  0.7695D-02,  0.7728D-02,  0.6913D-02,   &
         0.6156D-02,  0.5695D-02,  0.5646D-02,  0.5967D-02,   &
         0.6469D-02,  0.7020D-02,  0.7053D-02,  0.6691D-02   &
         /
       data (OREF(43,18, mtmp), mtmp=1,12)   &
         /   &
         0.7234D-02,  0.7695D-02,  0.7728D-02,  0.6913D-02,   &
         0.6156D-02,  0.5695D-02,  0.5646D-02,  0.5967D-02,   &
         0.6469D-02,  0.7020D-02,  0.7053D-02,  0.6691D-02   &
         /
       data (OREF(44, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3608D-02,  0.4126D-02,  0.4871D-02,  0.5340D-02,   &
         0.5660D-02,  0.5362D-02,  0.4954D-02,  0.4844D-02,   &
         0.4468D-02,  0.4606D-02,  0.4077D-02,  0.3784D-02   &
         /
       data (OREF(44, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3608D-02,  0.4126D-02,  0.4871D-02,  0.5340D-02,   &
         0.5660D-02,  0.5362D-02,  0.4954D-02,  0.4844D-02,   &
         0.4468D-02,  0.4606D-02,  0.4077D-02,  0.3784D-02   &
         /
       data (OREF(44, 3, mtmp), mtmp=1,12)   &
         /   &
         0.4115D-02,  0.4386D-02,  0.4948D-02,  0.5467D-02,   &
         0.5660D-02,  0.5362D-02,  0.4954D-02,  0.4844D-02,   &
         0.4722D-02,  0.4733D-02,  0.4402D-02,  0.4270D-02   &
         /
       data (OREF(44, 4, mtmp), mtmp=1,12)   &
         /   &
         0.4380D-02,  0.4650D-02,  0.5020D-02,  0.5616D-02,   &
         0.6024D-02,  0.5638D-02,  0.5208D-02,  0.5086D-02,   &
         0.5075D-02,  0.4866D-02,  0.4579D-02,  0.4474D-02   &
         /
       data (OREF(44, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4711D-02,  0.4998D-02,  0.5136D-02,  0.5517D-02,   &
         0.6079D-02,  0.5958D-02,  0.5941D-02,  0.5456D-02,   &
         0.5263D-02,  0.4855D-02,  0.4661D-02,  0.4678D-02   &
         /
       data (OREF(44, 6, mtmp), mtmp=1,12)   &
         /   &
         0.4954D-02,  0.5202D-02,  0.5152D-02,  0.5241D-02,   &
         0.5500D-02,  0.5566D-02,  0.5903D-02,  0.5357D-02,   &
         0.5130D-02,  0.4794D-02,  0.4777D-02,  0.4882D-02   &
         /
       data (OREF(44, 7, mtmp), mtmp=1,12)   &
         /   &
         0.4937D-02,  0.5081D-02,  0.4948D-02,  0.5015D-02,   &
         0.5246D-02,  0.5450D-02,  0.5594D-02,  0.5108D-02,   &
         0.4976D-02,  0.4838D-02,  0.4915D-02,  0.5053D-02   &
         /
       data (OREF(44, 8, mtmp), mtmp=1,12)   &
         /   &
         0.4661D-02,  0.4617D-02,  0.4799D-02,  0.5070D-02,   &
         0.5329D-02,  0.5434D-02,  0.5318D-02,  0.5042D-02,   &
         0.5015D-02,  0.4970D-02,  0.5048D-02,  0.5141D-02   &
         /
       data (OREF(44, 9, mtmp), mtmp=1,12)   &
         /   &
         0.4529D-02,  0.4358D-02,  0.4810D-02,  0.5186D-02,   &
         0.5434D-02,  0.5417D-02,  0.5197D-02,  0.5070D-02,   &
         0.5103D-02,  0.5086D-02,  0.5257D-02,  0.5318D-02   &
         /
       data (OREF(44,10, mtmp), mtmp=1,12)   &
         /   &
         0.4551D-02,  0.4424D-02,  0.4849D-02,  0.5180D-02,   &
         0.5412D-02,  0.5412D-02,  0.5241D-02,  0.5097D-02,   &
         0.5125D-02,  0.5130D-02,  0.5346D-02,  0.5379D-02   &
         /
       data (OREF(44,11, mtmp), mtmp=1,12)   &
         /   &
         0.4535D-02,  0.4634D-02,  0.4998D-02,  0.5219D-02,   &
         0.5395D-02,  0.5517D-02,  0.5445D-02,  0.5141D-02,   &
         0.5053D-02,  0.5037D-02,  0.5141D-02,  0.5147D-02   &
         /
       data (OREF(44,12, mtmp), mtmp=1,12)   &
         /   &
         0.4700D-02,  0.4766D-02,  0.5136D-02,  0.5296D-02,   &
         0.5362D-02,  0.5555D-02,  0.5666D-02,  0.5191D-02,   &
         0.4959D-02,  0.4783D-02,  0.4910D-02,  0.5042D-02   &
         /
       data (OREF(44,13, mtmp), mtmp=1,12)   &
         /   &
         0.5230D-02,  0.5031D-02,  0.4910D-02,  0.5075D-02,   &
         0.5136D-02,  0.5312D-02,  0.5577D-02,  0.5208D-02,   &
         0.4899D-02,  0.4695D-02,  0.4981D-02,  0.5064D-02   &
         /
       data (OREF(44,14, mtmp), mtmp=1,12)   &
         /   &
         0.5494D-02,  0.5577D-02,  0.4722D-02,  0.4579D-02,   &
         0.4827D-02,  0.4970D-02,  0.5164D-02,  0.4915D-02,   &
         0.4777D-02,  0.4810D-02,  0.5268D-02,  0.4932D-02   &
         /
       data (OREF(44,15, mtmp), mtmp=1,12)   &
         /   &
         0.5108D-02,  0.5715D-02,  0.4970D-02,  0.4441D-02,   &
         0.4485D-02,  0.4612D-02,  0.4678D-02,  0.4529D-02,   &
         0.4612D-02,  0.4959D-02,  0.5180D-02,  0.4579D-02   &
         /
       data (OREF(44,16, mtmp), mtmp=1,12)   &
         /   &
         0.4849D-02,  0.5401D-02,  0.5235D-02,  0.4551D-02,   &
         0.4319D-02,  0.4342D-02,  0.4364D-02,  0.4264D-02,   &
         0.4513D-02,  0.4844D-02,  0.4728D-02,  0.4485D-02   &
         /
       data (OREF(44,17, mtmp), mtmp=1,12)   &
         /   &
         0.4849D-02,  0.5158D-02,  0.5180D-02,  0.4634D-02,   &
         0.4126D-02,  0.3817D-02,  0.3784D-02,  0.4000D-02,   &
         0.4336D-02,  0.4706D-02,  0.4728D-02,  0.4485D-02   &
         /
       data (OREF(44,18, mtmp), mtmp=1,12)   &
         /   &
         0.4849D-02,  0.5158D-02,  0.5180D-02,  0.4634D-02,   &
         0.4126D-02,  0.3817D-02,  0.3784D-02,  0.4000D-02,   &
         0.4336D-02,  0.4706D-02,  0.4728D-02,  0.4485D-02   &
         /
       data (OREF(45, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2418D-02,  0.2766D-02,  0.3265D-02,  0.3580D-02,   &
         0.3794D-02,  0.3594D-02,  0.3321D-02,  0.3247D-02,   &
         0.2995D-02,  0.3088D-02,  0.2733D-02,  0.2537D-02   &
         /
       data (OREF(45, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2418D-02,  0.2766D-02,  0.3265D-02,  0.3580D-02,   &
         0.3794D-02,  0.3594D-02,  0.3321D-02,  0.3247D-02,   &
         0.2995D-02,  0.3088D-02,  0.2733D-02,  0.2537D-02   &
         /
       data (OREF(45, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2759D-02,  0.2940D-02,  0.3317D-02,  0.3665D-02,   &
         0.3794D-02,  0.3594D-02,  0.3321D-02,  0.3247D-02,   &
         0.3165D-02,  0.3173D-02,  0.2951D-02,  0.2862D-02   &
         /
       data (OREF(45, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2936D-02,  0.3117D-02,  0.3365D-02,  0.3764D-02,   &
         0.4038D-02,  0.3779D-02,  0.3491D-02,  0.3409D-02,   &
         0.3402D-02,  0.3262D-02,  0.3069D-02,  0.2999D-02   &
         /
       data (OREF(45, 5, mtmp), mtmp=1,12)   &
         /   &
         0.3158D-02,  0.3350D-02,  0.3443D-02,  0.3698D-02,   &
         0.4075D-02,  0.3994D-02,  0.3983D-02,  0.3657D-02,   &
         0.3528D-02,  0.3254D-02,  0.3125D-02,  0.3136D-02   &
         /
       data (OREF(45, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3321D-02,  0.3487D-02,  0.3454D-02,  0.3513D-02,   &
         0.3687D-02,  0.3731D-02,  0.3957D-02,  0.3591D-02,   &
         0.3439D-02,  0.3213D-02,  0.3202D-02,  0.3273D-02   &
         /
       data (OREF(45, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3310D-02,  0.3406D-02,  0.3317D-02,  0.3361D-02,   &
         0.3517D-02,  0.3653D-02,  0.3750D-02,  0.3424D-02,   &
         0.3335D-02,  0.3243D-02,  0.3295D-02,  0.3387D-02   &
         /
       data (OREF(45, 8, mtmp), mtmp=1,12)   &
         /   &
         0.3125D-02,  0.3095D-02,  0.3217D-02,  0.3398D-02,   &
         0.3572D-02,  0.3642D-02,  0.3565D-02,  0.3380D-02,   &
         0.3361D-02,  0.3332D-02,  0.3384D-02,  0.3446D-02   &
         /
       data (OREF(45, 9, mtmp), mtmp=1,12)   &
         /   &
         0.3036D-02,  0.2921D-02,  0.3225D-02,  0.3476D-02,   &
         0.3642D-02,  0.3631D-02,  0.3483D-02,  0.3398D-02,   &
         0.3421D-02,  0.3409D-02,  0.3524D-02,  0.3565D-02   &
         /
       data (OREF(45,10, mtmp), mtmp=1,12)   &
         /   &
         0.3051D-02,  0.2966D-02,  0.3250D-02,  0.3472D-02,   &
         0.3628D-02,  0.3628D-02,  0.3513D-02,  0.3417D-02,   &
         0.3435D-02,  0.3439D-02,  0.3583D-02,  0.3605D-02   &
         /
       data (OREF(45,11, mtmp), mtmp=1,12)   &
         /   &
         0.3040D-02,  0.3106D-02,  0.3350D-02,  0.3498D-02,   &
         0.3617D-02,  0.3698D-02,  0.3650D-02,  0.3446D-02,   &
         0.3387D-02,  0.3376D-02,  0.3446D-02,  0.3450D-02   &
         /
       data (OREF(45,12, mtmp), mtmp=1,12)   &
         /   &
         0.3151D-02,  0.3195D-02,  0.3443D-02,  0.3550D-02,   &
         0.3594D-02,  0.3724D-02,  0.3798D-02,  0.3480D-02,   &
         0.3324D-02,  0.3206D-02,  0.3291D-02,  0.3380D-02   &
         /
       data (OREF(45,13, mtmp), mtmp=1,12)   &
         /   &
         0.3506D-02,  0.3372D-02,  0.3291D-02,  0.3402D-02,   &
         0.3443D-02,  0.3561D-02,  0.3739D-02,  0.3491D-02,   &
         0.3284D-02,  0.3147D-02,  0.3339D-02,  0.3395D-02   &
         /
       data (OREF(45,14, mtmp), mtmp=1,12)   &
         /   &
         0.3683D-02,  0.3739D-02,  0.3165D-02,  0.3069D-02,   &
         0.3236D-02,  0.3332D-02,  0.3461D-02,  0.3295D-02,   &
         0.3202D-02,  0.3225D-02,  0.3531D-02,  0.3306D-02   &
         /
       data (OREF(45,15, mtmp), mtmp=1,12)   &
         /   &
         0.3424D-02,  0.3831D-02,  0.3332D-02,  0.2977D-02,   &
         0.3006D-02,  0.3091D-02,  0.3136D-02,  0.3036D-02,   &
         0.3091D-02,  0.3324D-02,  0.3472D-02,  0.3069D-02   &
         /
       data (OREF(45,16, mtmp), mtmp=1,12)   &
         /   &
         0.3250D-02,  0.3620D-02,  0.3509D-02,  0.3051D-02,   &
         0.2895D-02,  0.2910D-02,  0.2925D-02,  0.2858D-02,   &
         0.3025D-02,  0.3247D-02,  0.3169D-02,  0.3006D-02   &
         /
       data (OREF(45,17, mtmp), mtmp=1,12)   &
         /   &
         0.3250D-02,  0.3458D-02,  0.3472D-02,  0.3106D-02,   &
         0.2766D-02,  0.2559D-02,  0.2537D-02,  0.2681D-02,   &
         0.2907D-02,  0.3154D-02,  0.3169D-02,  0.3006D-02   &
         /
       data (OREF(45,18, mtmp), mtmp=1,12)   &
         /   &
         0.3250D-02,  0.3458D-02,  0.3472D-02,  0.3106D-02,   &
         0.2766D-02,  0.2559D-02,  0.2537D-02,  0.2681D-02,   &
         0.2907D-02,  0.3154D-02,  0.3169D-02,  0.3006D-02   &
         /
       data (OREF(46, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1621D-02,  0.1854D-02,  0.2189D-02,  0.2399D-02,   &
         0.2543D-02,  0.2409D-02,  0.2226D-02,  0.2176D-02,   &
         0.2008D-02,  0.2070D-02,  0.1832D-02,  0.1700D-02   &
         /
       data (OREF(46, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1621D-02,  0.1854D-02,  0.2189D-02,  0.2399D-02,   &
         0.2543D-02,  0.2409D-02,  0.2226D-02,  0.2176D-02,   &
         0.2008D-02,  0.2070D-02,  0.1832D-02,  0.1700D-02   &
         /
       data (OREF(46, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1849D-02,  0.1971D-02,  0.2223D-02,  0.2456D-02,   &
         0.2543D-02,  0.2409D-02,  0.2226D-02,  0.2176D-02,   &
         0.2122D-02,  0.2127D-02,  0.1978D-02,  0.1919D-02   &
         /
       data (OREF(46, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1968D-02,  0.2090D-02,  0.2256D-02,  0.2523D-02,   &
         0.2707D-02,  0.2533D-02,  0.2340D-02,  0.2285D-02,   &
         0.2280D-02,  0.2186D-02,  0.2057D-02,  0.2010D-02   &
         /
       data (OREF(46, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2117D-02,  0.2246D-02,  0.2308D-02,  0.2479D-02,   &
         0.2732D-02,  0.2677D-02,  0.2670D-02,  0.2451D-02,   &
         0.2365D-02,  0.2181D-02,  0.2095D-02,  0.2102D-02   &
         /
       data (OREF(46, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2226D-02,  0.2337D-02,  0.2315D-02,  0.2355D-02,   &
         0.2471D-02,  0.2501D-02,  0.2652D-02,  0.2407D-02,   &
         0.2305D-02,  0.2154D-02,  0.2147D-02,  0.2194D-02   &
         /
       data (OREF(46, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2218D-02,  0.2283D-02,  0.2223D-02,  0.2253D-02,   &
         0.2357D-02,  0.2449D-02,  0.2513D-02,  0.2295D-02,   &
         0.2236D-02,  0.2174D-02,  0.2209D-02,  0.2271D-02   &
         /
       data (OREF(46, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2095D-02,  0.2075D-02,  0.2157D-02,  0.2278D-02,   &
         0.2394D-02,  0.2442D-02,  0.2390D-02,  0.2266D-02,   &
         0.2253D-02,  0.2233D-02,  0.2268D-02,  0.2310D-02   &
         /
       data (OREF(46, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2035D-02,  0.1958D-02,  0.2161D-02,  0.2330D-02,   &
         0.2442D-02,  0.2434D-02,  0.2335D-02,  0.2278D-02,   &
         0.2293D-02,  0.2285D-02,  0.2362D-02,  0.2390D-02   &
         /
       data (OREF(46,10, mtmp), mtmp=1,12)   &
         /   &
         0.2045D-02,  0.1988D-02,  0.2179D-02,  0.2328D-02,   &
         0.2432D-02,  0.2432D-02,  0.2355D-02,  0.2290D-02,   &
         0.2303D-02,  0.2305D-02,  0.2402D-02,  0.2417D-02   &
         /
       data (OREF(46,11, mtmp), mtmp=1,12)   &
         /   &
         0.2038D-02,  0.2082D-02,  0.2246D-02,  0.2345D-02,   &
         0.2424D-02,  0.2479D-02,  0.2447D-02,  0.2310D-02,   &
         0.2271D-02,  0.2263D-02,  0.2310D-02,  0.2313D-02   &
         /
       data (OREF(46,12, mtmp), mtmp=1,12)   &
         /   &
         0.2112D-02,  0.2142D-02,  0.2308D-02,  0.2380D-02,   &
         0.2409D-02,  0.2496D-02,  0.2546D-02,  0.2333D-02,   &
         0.2228D-02,  0.2149D-02,  0.2206D-02,  0.2266D-02   &
         /
       data (OREF(46,13, mtmp), mtmp=1,12)   &
         /   &
         0.2350D-02,  0.2261D-02,  0.2206D-02,  0.2280D-02,   &
         0.2308D-02,  0.2387D-02,  0.2506D-02,  0.2340D-02,   &
         0.2201D-02,  0.2109D-02,  0.2238D-02,  0.2275D-02   &
         /
       data (OREF(46,14, mtmp), mtmp=1,12)   &
         /   &
         0.2469D-02,  0.2506D-02,  0.2122D-02,  0.2057D-02,   &
         0.2169D-02,  0.2233D-02,  0.2320D-02,  0.2209D-02,   &
         0.2147D-02,  0.2161D-02,  0.2367D-02,  0.2216D-02   &
         /
       data (OREF(46,15, mtmp), mtmp=1,12)   &
         /   &
         0.2295D-02,  0.2568D-02,  0.2233D-02,  0.1995D-02,   &
         0.2015D-02,  0.2072D-02,  0.2102D-02,  0.2035D-02,   &
         0.2072D-02,  0.2228D-02,  0.2328D-02,  0.2057D-02   &
         /
       data (OREF(46,16, mtmp), mtmp=1,12)   &
         /   &
         0.2179D-02,  0.2427D-02,  0.2352D-02,  0.2045D-02,   &
         0.1941D-02,  0.1951D-02,  0.1961D-02,  0.1916D-02,   &
         0.2028D-02,  0.2176D-02,  0.2124D-02,  0.2015D-02   &
         /
       data (OREF(46,17, mtmp), mtmp=1,12)   &
         /   &
         0.2179D-02,  0.2318D-02,  0.2328D-02,  0.2082D-02,   &
         0.1854D-02,  0.1715D-02,  0.1700D-02,  0.1797D-02,   &
         0.1948D-02,  0.2114D-02,  0.2124D-02,  0.2015D-02   &
         /
       data (OREF(46,18, mtmp), mtmp=1,12)   &
         /   &
         0.2179D-02,  0.2318D-02,  0.2328D-02,  0.2082D-02,   &
         0.1854D-02,  0.1715D-02,  0.1700D-02,  0.1797D-02,   &
         0.1948D-02,  0.2114D-02,  0.2124D-02,  0.2015D-02   &
         /
       data (OREF(47, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1087D-02,  0.1243D-02,  0.1467D-02,  0.1608D-02,   &
         0.1705D-02,  0.1615D-02,  0.1492D-02,  0.1459D-02,   &
         0.1346D-02,  0.1387D-02,  0.1228D-02,  0.1140D-02   &
         /
       data (OREF(47, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1087D-02,  0.1243D-02,  0.1467D-02,  0.1608D-02,   &
         0.1705D-02,  0.1615D-02,  0.1492D-02,  0.1459D-02,   &
         0.1346D-02,  0.1387D-02,  0.1228D-02,  0.1140D-02   &
         /
       data (OREF(47, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1240D-02,  0.1321D-02,  0.1490D-02,  0.1647D-02,   &
         0.1705D-02,  0.1615D-02,  0.1492D-02,  0.1459D-02,   &
         0.1422D-02,  0.1426D-02,  0.1326D-02,  0.1286D-02   &
         /
       data (OREF(47, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1319D-02,  0.1401D-02,  0.1512D-02,  0.1691D-02,   &
         0.1814D-02,  0.1698D-02,  0.1569D-02,  0.1532D-02,   &
         0.1529D-02,  0.1465D-02,  0.1379D-02,  0.1348D-02   &
         /
       data (OREF(47, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1419D-02,  0.1505D-02,  0.1547D-02,  0.1662D-02,   &
         0.1831D-02,  0.1794D-02,  0.1789D-02,  0.1643D-02,   &
         0.1585D-02,  0.1462D-02,  0.1404D-02,  0.1409D-02   &
         /
       data (OREF(47, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1492D-02,  0.1567D-02,  0.1552D-02,  0.1578D-02,   &
         0.1657D-02,  0.1677D-02,  0.1778D-02,  0.1613D-02,   &
         0.1545D-02,  0.1444D-02,  0.1439D-02,  0.1470D-02   &
         /
       data (OREF(47, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1487D-02,  0.1530D-02,  0.1490D-02,  0.1510D-02,   &
         0.1580D-02,  0.1642D-02,  0.1685D-02,  0.1539D-02,   &
         0.1499D-02,  0.1457D-02,  0.1480D-02,  0.1522D-02   &
         /
       data (OREF(47, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1404D-02,  0.1391D-02,  0.1446D-02,  0.1527D-02,   &
         0.1605D-02,  0.1637D-02,  0.1602D-02,  0.1519D-02,   &
         0.1510D-02,  0.1497D-02,  0.1520D-02,  0.1549D-02   &
         /
       data (OREF(47, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1364D-02,  0.1313D-02,  0.1449D-02,  0.1562D-02,   &
         0.1637D-02,  0.1632D-02,  0.1565D-02,  0.1527D-02,   &
         0.1537D-02,  0.1532D-02,  0.1583D-02,  0.1602D-02   &
         /
       data (OREF(47,10, mtmp), mtmp=1,12)   &
         /   &
         0.1371D-02,  0.1333D-02,  0.1461D-02,  0.1560D-02,   &
         0.1630D-02,  0.1630D-02,  0.1578D-02,  0.1535D-02,   &
         0.1544D-02,  0.1545D-02,  0.1610D-02,  0.1620D-02   &
         /
       data (OREF(47,11, mtmp), mtmp=1,12)   &
         /   &
         0.1366D-02,  0.1396D-02,  0.1505D-02,  0.1572D-02,   &
         0.1625D-02,  0.1662D-02,  0.1640D-02,  0.1549D-02,   &
         0.1522D-02,  0.1517D-02,  0.1549D-02,  0.1550D-02   &
         /
       data (OREF(47,12, mtmp), mtmp=1,12)   &
         /   &
         0.1416D-02,  0.1436D-02,  0.1547D-02,  0.1595D-02,   &
         0.1615D-02,  0.1673D-02,  0.1706D-02,  0.1564D-02,   &
         0.1494D-02,  0.1441D-02,  0.1479D-02,  0.1519D-02   &
         /
       data (OREF(47,13, mtmp), mtmp=1,12)   &
         /   &
         0.1575D-02,  0.1515D-02,  0.1479D-02,  0.1529D-02,   &
         0.1547D-02,  0.1600D-02,  0.1680D-02,  0.1569D-02,   &
         0.1475D-02,  0.1414D-02,  0.1500D-02,  0.1525D-02   &
         /
       data (OREF(47,14, mtmp), mtmp=1,12)   &
         /   &
         0.1655D-02,  0.1680D-02,  0.1422D-02,  0.1379D-02,   &
         0.1454D-02,  0.1497D-02,  0.1555D-02,  0.1480D-02,   &
         0.1439D-02,  0.1449D-02,  0.1587D-02,  0.1485D-02   &
         /
       data (OREF(47,15, mtmp), mtmp=1,12)   &
         /   &
         0.1539D-02,  0.1721D-02,  0.1497D-02,  0.1338D-02,   &
         0.1351D-02,  0.1389D-02,  0.1409D-02,  0.1364D-02,   &
         0.1389D-02,  0.1494D-02,  0.1560D-02,  0.1379D-02   &
         /
       data (OREF(47,16, mtmp), mtmp=1,12)   &
         /   &
         0.1461D-02,  0.1627D-02,  0.1577D-02,  0.1371D-02,   &
         0.1301D-02,  0.1308D-02,  0.1314D-02,  0.1284D-02,   &
         0.1359D-02,  0.1459D-02,  0.1424D-02,  0.1351D-02   &
         /
       data (OREF(47,17, mtmp), mtmp=1,12)   &
         /   &
         0.1461D-02,  0.1554D-02,  0.1560D-02,  0.1396D-02,   &
         0.1243D-02,  0.1150D-02,  0.1140D-02,  0.1205D-02,   &
         0.1306D-02,  0.1417D-02,  0.1424D-02,  0.1351D-02   &
         /
       data (OREF(47,18, mtmp), mtmp=1,12)   &
         /   &
         0.1461D-02,  0.1554D-02,  0.1560D-02,  0.1396D-02,   &
         0.1243D-02,  0.1150D-02,  0.1140D-02,  0.1205D-02,   &
         0.1306D-02,  0.1417D-02,  0.1424D-02,  0.1351D-02   &
         /
       data (OREF(48, 1, mtmp), mtmp=1,12)   &
         /   &
         0.7284D-03,  0.8331D-03,  0.9835D-03,  0.1078D-02,   &
         0.1143D-02,  0.1083D-02,  0.1000D-02,  0.9779D-03,   &
         0.9022D-03,  0.9300D-03,  0.8231D-03,  0.7640D-03   &
         /
       data (OREF(48, 2, mtmp), mtmp=1,12)   &
         /   &
         0.7284D-03,  0.8331D-03,  0.9835D-03,  0.1078D-02,   &
         0.1143D-02,  0.1083D-02,  0.1000D-02,  0.9779D-03,   &
         0.9022D-03,  0.9300D-03,  0.8231D-03,  0.7640D-03   &
         /
       data (OREF(48, 3, mtmp), mtmp=1,12)   &
         /   &
         0.8309D-03,  0.8855D-03,  0.9991D-03,  0.1104D-02,   &
         0.1143D-02,  0.1083D-02,  0.1000D-02,  0.9779D-03,   &
         0.9534D-03,  0.9556D-03,  0.8888D-03,  0.8621D-03   &
         /
       data (OREF(48, 4, mtmp), mtmp=1,12)   &
         /   &
         0.8843D-03,  0.9389D-03,  0.1014D-02,  0.1134D-02,   &
         0.1216D-02,  0.1138D-02,  0.1051D-02,  0.1027D-02,   &
         0.1025D-02,  0.9823D-03,  0.9244D-03,  0.9033D-03   &
         /
       data (OREF(48, 5, mtmp), mtmp=1,12)   &
         /   &
         0.9512D-03,  0.1009D-02,  0.1037D-02,  0.1114D-02,   &
         0.1227D-02,  0.1203D-02,  0.1200D-02,  0.1102D-02,   &
         0.1063D-02,  0.9801D-03,  0.9411D-03,  0.9445D-03   &
         /
       data (OREF(48, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1000D-02,  0.1050D-02,  0.1040D-02,  0.1058D-02,   &
         0.1110D-02,  0.1124D-02,  0.1192D-02,  0.1081D-02,   &
         0.1036D-02,  0.9679D-03,  0.9645D-03,  0.9857D-03   &
         /
       data (OREF(48, 7, mtmp), mtmp=1,12)   &
         /   &
         0.9968D-03,  0.1026D-02,  0.9991D-03,  0.1012D-02,   &
         0.1059D-02,  0.1100D-02,  0.1129D-02,  0.1031D-02,   &
         0.1005D-02,  0.9768D-03,  0.9924D-03,  0.1020D-02   &
         /
       data (OREF(48, 8, mtmp), mtmp=1,12)   &
         /   &
         0.9411D-03,  0.9322D-03,  0.9690D-03,  0.1024D-02,   &
         0.1076D-02,  0.1097D-02,  0.1074D-02,  0.1018D-02,   &
         0.1012D-02,  0.1004D-02,  0.1019D-02,  0.1038D-02   &
         /
       data (OREF(48, 9, mtmp), mtmp=1,12)   &
         /   &
         0.9144D-03,  0.8799D-03,  0.9712D-03,  0.1047D-02,   &
         0.1097D-02,  0.1094D-02,  0.1049D-02,  0.1024D-02,   &
         0.1030D-02,  0.1027D-02,  0.1061D-02,  0.1074D-02   &
         /
       data (OREF(48,10, mtmp), mtmp=1,12)   &
         /   &
         0.9189D-03,  0.8932D-03,  0.9790D-03,  0.1046D-02,   &
         0.1093D-02,  0.1093D-02,  0.1058D-02,  0.1029D-02,   &
         0.1035D-02,  0.1036D-02,  0.1079D-02,  0.1086D-02   &
         /
       data (OREF(48,11, mtmp), mtmp=1,12)   &
         /   &
         0.9155D-03,  0.9356D-03,  0.1009D-02,  0.1054D-02,   &
         0.1089D-02,  0.1114D-02,  0.1099D-02,  0.1038D-02,   &
         0.1020D-02,  0.1017D-02,  0.1038D-02,  0.1039D-02   &
         /
       data (OREF(48,12, mtmp), mtmp=1,12)   &
         /   &
         0.9489D-03,  0.9623D-03,  0.1037D-02,  0.1069D-02,   &
         0.1083D-02,  0.1122D-02,  0.1144D-02,  0.1048D-02,   &
         0.1001D-02,  0.9656D-03,  0.9913D-03,  0.1018D-02   &
         /
       data (OREF(48,13, mtmp), mtmp=1,12)   &
         /   &
         0.1056D-02,  0.1016D-02,  0.9913D-03,  0.1025D-02,   &
         0.1037D-02,  0.1073D-02,  0.1126D-02,  0.1051D-02,   &
         0.9890D-03,  0.9478D-03,  0.1006D-02,  0.1022D-02   &
         /
       data (OREF(48,14, mtmp), mtmp=1,12)   &
         /   &
         0.1109D-02,  0.1126D-02,  0.9534D-03,  0.9244D-03,   &
         0.9746D-03,  0.1004D-02,  0.1042D-02,  0.9924D-03,   &
         0.9645D-03,  0.9712D-03,  0.1064D-02,  0.9957D-03   &
         /
       data (OREF(48,15, mtmp), mtmp=1,12)   &
         /   &
         0.1031D-02,  0.1154D-02,  0.1004D-02,  0.8966D-03,   &
         0.9055D-03,  0.9311D-03,  0.9445D-03,  0.9144D-03,   &
         0.9311D-03,  0.1001D-02,  0.1046D-02,  0.9244D-03   &
         /
       data (OREF(48,16, mtmp), mtmp=1,12)   &
         /   &
         0.9790D-03,  0.1090D-02,  0.1057D-02,  0.9189D-03,   &
         0.8721D-03,  0.8765D-03,  0.8810D-03,  0.8609D-03,   &
         0.9111D-03,  0.9779D-03,  0.9545D-03,  0.9055D-03   &
         /
       data (OREF(48,17, mtmp), mtmp=1,12)   &
         /   &
         0.9790D-03,  0.1041D-02,  0.1046D-02,  0.9356D-03,   &
         0.8331D-03,  0.7707D-03,  0.7640D-03,  0.8075D-03,   &
         0.8754D-03,  0.9501D-03,  0.9545D-03,  0.9055D-03   &
         /
       data (OREF(48,18, mtmp), mtmp=1,12)   &
         /   &
         0.9790D-03,  0.1041D-02,  0.1046D-02,  0.9356D-03,   &
         0.8331D-03,  0.7707D-03,  0.7640D-03,  0.8075D-03,   &
         0.8754D-03,  0.9501D-03,  0.9545D-03,  0.9055D-03   &
         /
       data (OREF(49, 1, mtmp), mtmp=1,12)   &
         /   &
         0.4883D-03,  0.5584D-03,  0.6592D-03,  0.7227D-03,   &
         0.7660D-03,  0.7257D-03,  0.6704D-03,  0.6555D-03,   &
         0.6047D-03,  0.6234D-03,  0.5517D-03,  0.5122D-03   &
         /
       data (OREF(49, 2, mtmp), mtmp=1,12)   &
         /   &
         0.4883D-03,  0.5584D-03,  0.6592D-03,  0.7227D-03,   &
         0.7660D-03,  0.7257D-03,  0.6704D-03,  0.6555D-03,   &
         0.6047D-03,  0.6234D-03,  0.5517D-03,  0.5122D-03   &
         /
       data (OREF(49, 3, mtmp), mtmp=1,12)   &
         /   &
         0.5570D-03,  0.5935D-03,  0.6697D-03,  0.7399D-03,   &
         0.7660D-03,  0.7257D-03,  0.6704D-03,  0.6555D-03,   &
         0.6391D-03,  0.6406D-03,  0.5958D-03,  0.5779D-03   &
         /
       data (OREF(49, 4, mtmp), mtmp=1,12)   &
         /   &
         0.5928D-03,  0.6294D-03,  0.6794D-03,  0.7600D-03,   &
         0.8153D-03,  0.7630D-03,  0.7048D-03,  0.6884D-03,   &
         0.6869D-03,  0.6585D-03,  0.6197D-03,  0.6055D-03   &
         /
       data (OREF(49, 5, mtmp), mtmp=1,12)   &
         /   &
         0.6376D-03,  0.6764D-03,  0.6951D-03,  0.7466D-03,   &
         0.8227D-03,  0.8063D-03,  0.8041D-03,  0.7384D-03,   &
         0.7122D-03,  0.6570D-03,  0.6309D-03,  0.6331D-03   &
         /
       data (OREF(49, 6, mtmp), mtmp=1,12)   &
         /   &
         0.6704D-03,  0.7040D-03,  0.6973D-03,  0.7093D-03,   &
         0.7443D-03,  0.7533D-03,  0.7988D-03,  0.7249D-03,   &
         0.6943D-03,  0.6488D-03,  0.6465D-03,  0.6607D-03   &
         /
       data (OREF(49, 7, mtmp), mtmp=1,12)   &
         /   &
         0.6682D-03,  0.6876D-03,  0.6697D-03,  0.6786D-03,   &
         0.7100D-03,  0.7376D-03,  0.7570D-03,  0.6913D-03,   &
         0.6734D-03,  0.6548D-03,  0.6652D-03,  0.6839D-03   &
         /
       data (OREF(49, 8, mtmp), mtmp=1,12)   &
         /   &
         0.6309D-03,  0.6249D-03,  0.6495D-03,  0.6861D-03,   &
         0.7212D-03,  0.7354D-03,  0.7197D-03,  0.6824D-03,   &
         0.6786D-03,  0.6727D-03,  0.6831D-03,  0.6958D-03   &
         /
       data (OREF(49, 9, mtmp), mtmp=1,12)   &
         /   &
         0.6129D-03,  0.5898D-03,  0.6510D-03,  0.7018D-03,   &
         0.7354D-03,  0.7331D-03,  0.7033D-03,  0.6861D-03,   &
         0.6906D-03,  0.6884D-03,  0.7115D-03,  0.7197D-03   &
         /
       data (OREF(49,10, mtmp), mtmp=1,12)   &
         /   &
         0.6159D-03,  0.5988D-03,  0.6562D-03,  0.7010D-03,   &
         0.7324D-03,  0.7324D-03,  0.7093D-03,  0.6898D-03,   &
         0.6936D-03,  0.6943D-03,  0.7234D-03,  0.7279D-03   &
         /
       data (OREF(49,11, mtmp), mtmp=1,12)   &
         /   &
         0.6137D-03,  0.6271D-03,  0.6764D-03,  0.7063D-03,   &
         0.7302D-03,  0.7466D-03,  0.7369D-03,  0.6958D-03,   &
         0.6839D-03,  0.6816D-03,  0.6958D-03,  0.6966D-03   &
         /
       data (OREF(49,12, mtmp), mtmp=1,12)   &
         /   &
         0.6361D-03,  0.6451D-03,  0.6951D-03,  0.7167D-03,   &
         0.7257D-03,  0.7518D-03,  0.7667D-03,  0.7025D-03,   &
         0.6712D-03,  0.6473D-03,  0.6645D-03,  0.6824D-03   &
         /
       data (OREF(49,13, mtmp), mtmp=1,12)   &
         /   &
         0.7078D-03,  0.6809D-03,  0.6645D-03,  0.6869D-03,   &
         0.6951D-03,  0.7190D-03,  0.7548D-03,  0.7048D-03,   &
         0.6630D-03,  0.6353D-03,  0.6742D-03,  0.6854D-03   &
         /
       data (OREF(49,14, mtmp), mtmp=1,12)   &
         /   &
         0.7436D-03,  0.7548D-03,  0.6391D-03,  0.6197D-03,   &
         0.6533D-03,  0.6727D-03,  0.6988D-03,  0.6652D-03,   &
         0.6465D-03,  0.6510D-03,  0.7130D-03,  0.6674D-03   &
         /
       data (OREF(49,15, mtmp), mtmp=1,12)   &
         /   &
         0.6913D-03,  0.7735D-03,  0.6727D-03,  0.6010D-03,   &
         0.6070D-03,  0.6241D-03,  0.6331D-03,  0.6129D-03,   &
         0.6241D-03,  0.6712D-03,  0.7010D-03,  0.6197D-03   &
         /
       data (OREF(49,16, mtmp), mtmp=1,12)   &
         /   &
         0.6562D-03,  0.7309D-03,  0.7085D-03,  0.6159D-03,   &
         0.5846D-03,  0.5876D-03,  0.5905D-03,  0.5771D-03,   &
         0.6107D-03,  0.6555D-03,  0.6398D-03,  0.6070D-03   &
         /
       data (OREF(49,17, mtmp), mtmp=1,12)   &
         /   &
         0.6562D-03,  0.6981D-03,  0.7010D-03,  0.6271D-03,   &
         0.5584D-03,  0.5166D-03,  0.5122D-03,  0.5413D-03,   &
         0.5868D-03,  0.6368D-03,  0.6398D-03,  0.6070D-03   &
         /
       data (OREF(49,18, mtmp), mtmp=1,12)   &
         /   &
         0.6562D-03,  0.6981D-03,  0.7010D-03,  0.6271D-03,   &
         0.5584D-03,  0.5166D-03,  0.5122D-03,  0.5413D-03,   &
         0.5868D-03,  0.6368D-03,  0.6398D-03,  0.6070D-03   &
         /
       data (OREF(50, 1, mtmp), mtmp=1,12)   &
         /   &
         0.3273D-03,  0.3743D-03,  0.4419D-03,  0.4844D-03,   &
         0.5135D-03,  0.4864D-03,  0.4494D-03,  0.4394D-03,   &
         0.4054D-03,  0.4179D-03,  0.3698D-03,  0.3433D-03   &
         /
       data (OREF(50, 2, mtmp), mtmp=1,12)   &
         /   &
         0.3273D-03,  0.3743D-03,  0.4419D-03,  0.4844D-03,   &
         0.5135D-03,  0.4864D-03,  0.4494D-03,  0.4394D-03,   &
         0.4054D-03,  0.4179D-03,  0.3698D-03,  0.3433D-03   &
         /
       data (OREF(50, 3, mtmp), mtmp=1,12)   &
         /   &
         0.3733D-03,  0.3979D-03,  0.4489D-03,  0.4959D-03,   &
         0.5135D-03,  0.4864D-03,  0.4494D-03,  0.4394D-03,   &
         0.4284D-03,  0.4294D-03,  0.3994D-03,  0.3873D-03   &
         /
       data (OREF(50, 4, mtmp), mtmp=1,12)   &
         /   &
         0.3974D-03,  0.4219D-03,  0.4554D-03,  0.5095D-03,   &
         0.5465D-03,  0.5115D-03,  0.4724D-03,  0.4614D-03,   &
         0.4604D-03,  0.4414D-03,  0.4154D-03,  0.4059D-03   &
         /
       data (OREF(50, 5, mtmp), mtmp=1,12)   &
         /   &
         0.4274D-03,  0.4534D-03,  0.4659D-03,  0.5005D-03,   &
         0.5515D-03,  0.5405D-03,  0.5390D-03,  0.4949D-03,   &
         0.4774D-03,  0.4404D-03,  0.4229D-03,  0.4244D-03   &
         /
       data (OREF(50, 6, mtmp), mtmp=1,12)   &
         /   &
         0.4494D-03,  0.4719D-03,  0.4674D-03,  0.4754D-03,   &
         0.4990D-03,  0.5050D-03,  0.5355D-03,  0.4859D-03,   &
         0.4654D-03,  0.4349D-03,  0.4334D-03,  0.4429D-03   &
         /
       data (OREF(50, 7, mtmp), mtmp=1,12)   &
         /   &
         0.4479D-03,  0.4609D-03,  0.4489D-03,  0.4549D-03,   &
         0.4759D-03,  0.4944D-03,  0.5075D-03,  0.4634D-03,   &
         0.4514D-03,  0.4389D-03,  0.4459D-03,  0.4584D-03   &
         /
       data (OREF(50, 8, mtmp), mtmp=1,12)   &
         /   &
         0.4229D-03,  0.4189D-03,  0.4354D-03,  0.4599D-03,   &
         0.4834D-03,  0.4929D-03,  0.4824D-03,  0.4574D-03,   &
         0.4549D-03,  0.4509D-03,  0.4579D-03,  0.4664D-03   &
         /
       data (OREF(50, 9, mtmp), mtmp=1,12)   &
         /   &
         0.4109D-03,  0.3954D-03,  0.4364D-03,  0.4704D-03,   &
         0.4929D-03,  0.4914D-03,  0.4714D-03,  0.4599D-03,   &
         0.4629D-03,  0.4614D-03,  0.4769D-03,  0.4824D-03   &
         /
       data (OREF(50,10, mtmp), mtmp=1,12)   &
         /   &
         0.4129D-03,  0.4014D-03,  0.4399D-03,  0.4699D-03,   &
         0.4909D-03,  0.4909D-03,  0.4754D-03,  0.4624D-03,   &
         0.4649D-03,  0.4654D-03,  0.4849D-03,  0.4879D-03   &
         /
       data (OREF(50,11, mtmp), mtmp=1,12)   &
         /   &
         0.4114D-03,  0.4204D-03,  0.4534D-03,  0.4734D-03,   &
         0.4894D-03,  0.5005D-03,  0.4939D-03,  0.4664D-03,   &
         0.4584D-03,  0.4569D-03,  0.4664D-03,  0.4669D-03   &
         /
       data (OREF(50,12, mtmp), mtmp=1,12)   &
         /   &
         0.4264D-03,  0.4324D-03,  0.4659D-03,  0.4804D-03,   &
         0.4864D-03,  0.5040D-03,  0.5140D-03,  0.4709D-03,   &
         0.4499D-03,  0.4339D-03,  0.4454D-03,  0.4574D-03   &
         /
       data (OREF(50,13, mtmp), mtmp=1,12)   &
         /   &
         0.4744D-03,  0.4564D-03,  0.4454D-03,  0.4604D-03,   &
         0.4659D-03,  0.4819D-03,  0.5060D-03,  0.4724D-03,   &
         0.4444D-03,  0.4259D-03,  0.4519D-03,  0.4594D-03   &
         /
       data (OREF(50,14, mtmp), mtmp=1,12)   &
         /   &
         0.4984D-03,  0.5060D-03,  0.4284D-03,  0.4154D-03,   &
         0.4379D-03,  0.4509D-03,  0.4684D-03,  0.4459D-03,   &
         0.4334D-03,  0.4364D-03,  0.4779D-03,  0.4474D-03   &
         /
       data (OREF(50,15, mtmp), mtmp=1,12)   &
         /   &
         0.4634D-03,  0.5185D-03,  0.4509D-03,  0.4029D-03,   &
         0.4069D-03,  0.4184D-03,  0.4244D-03,  0.4109D-03,   &
         0.4184D-03,  0.4499D-03,  0.4699D-03,  0.4154D-03   &
         /
       data (OREF(50,16, mtmp), mtmp=1,12)   &
         /   &
         0.4399D-03,  0.4899D-03,  0.4749D-03,  0.4129D-03,   &
         0.3919D-03,  0.3939D-03,  0.3959D-03,  0.3868D-03,   &
         0.4094D-03,  0.4394D-03,  0.4289D-03,  0.4069D-03   &
         /
       data (OREF(50,17, mtmp), mtmp=1,12)   &
         /   &
         0.4399D-03,  0.4679D-03,  0.4699D-03,  0.4204D-03,   &
         0.3743D-03,  0.3463D-03,  0.3433D-03,  0.3628D-03,   &
         0.3934D-03,  0.4269D-03,  0.4289D-03,  0.4069D-03   &
         /
       data (OREF(50,18, mtmp), mtmp=1,12)   &
         /   &
         0.4399D-03,  0.4679D-03,  0.4699D-03,  0.4204D-03,   &
         0.3743D-03,  0.3463D-03,  0.3433D-03,  0.3628D-03,   &
         0.3934D-03,  0.4269D-03,  0.4289D-03,  0.4069D-03   &
         /
       data (OREF(51, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2194D-03,  0.2509D-03,  0.2962D-03,  0.3247D-03,   &
         0.3442D-03,  0.3261D-03,  0.3012D-03,  0.2945D-03,   &
         0.2717D-03,  0.2801D-03,  0.2479D-03,  0.2301D-03   &
         /
       data (OREF(51, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2194D-03,  0.2509D-03,  0.2962D-03,  0.3247D-03,   &
         0.3442D-03,  0.3261D-03,  0.3012D-03,  0.2945D-03,   &
         0.2717D-03,  0.2801D-03,  0.2479D-03,  0.2301D-03   &
         /
       data (OREF(51, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2503D-03,  0.2667D-03,  0.3009D-03,  0.3324D-03,   &
         0.3442D-03,  0.3261D-03,  0.3012D-03,  0.2945D-03,   &
         0.2872D-03,  0.2878D-03,  0.2677D-03,  0.2596D-03   &
         /
       data (OREF(51, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2664D-03,  0.2828D-03,  0.3053D-03,  0.3415D-03,   &
         0.3663D-03,  0.3428D-03,  0.3167D-03,  0.3093D-03,   &
         0.3086D-03,  0.2959D-03,  0.2784D-03,  0.2721D-03   &
         /
       data (OREF(51, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2865D-03,  0.3039D-03,  0.3123D-03,  0.3355D-03,   &
         0.3697D-03,  0.3623D-03,  0.3613D-03,  0.3318D-03,   &
         0.3200D-03,  0.2952D-03,  0.2835D-03,  0.2845D-03   &
         /
       data (OREF(51, 6, mtmp), mtmp=1,12)   &
         /   &
         0.3012D-03,  0.3163D-03,  0.3133D-03,  0.3187D-03,   &
         0.3345D-03,  0.3385D-03,  0.3589D-03,  0.3257D-03,   &
         0.3120D-03,  0.2915D-03,  0.2905D-03,  0.2969D-03   &
         /
       data (OREF(51, 7, mtmp), mtmp=1,12)   &
         /   &
         0.3002D-03,  0.3090D-03,  0.3009D-03,  0.3049D-03,   &
         0.3190D-03,  0.3314D-03,  0.3402D-03,  0.3106D-03,   &
         0.3026D-03,  0.2942D-03,  0.2989D-03,  0.3073D-03   &
         /
       data (OREF(51, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2835D-03,  0.2808D-03,  0.2919D-03,  0.3083D-03,   &
         0.3241D-03,  0.3304D-03,  0.3234D-03,  0.3066D-03,   &
         0.3049D-03,  0.3023D-03,  0.3069D-03,  0.3127D-03   &
         /
       data (OREF(51, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2754D-03,  0.2650D-03,  0.2925D-03,  0.3153D-03,   &
         0.3304D-03,  0.3294D-03,  0.3160D-03,  0.3083D-03,   &
         0.3103D-03,  0.3093D-03,  0.3197D-03,  0.3234D-03   &
         /
       data (OREF(51,10, mtmp), mtmp=1,12)   &
         /   &
         0.2768D-03,  0.2690D-03,  0.2949D-03,  0.3150D-03,   &
         0.3291D-03,  0.3291D-03,  0.3187D-03,  0.3100D-03,   &
         0.3116D-03,  0.3120D-03,  0.3251D-03,  0.3271D-03   &
         /
       data (OREF(51,11, mtmp), mtmp=1,12)   &
         /   &
         0.2758D-03,  0.2818D-03,  0.3039D-03,  0.3173D-03,   &
         0.3281D-03,  0.3355D-03,  0.3311D-03,  0.3127D-03,   &
         0.3073D-03,  0.3063D-03,  0.3127D-03,  0.3130D-03   &
         /
       data (OREF(51,12, mtmp), mtmp=1,12)   &
         /   &
         0.2858D-03,  0.2898D-03,  0.3123D-03,  0.3220D-03,   &
         0.3261D-03,  0.3378D-03,  0.3445D-03,  0.3157D-03,   &
         0.3016D-03,  0.2908D-03,  0.2986D-03,  0.3066D-03   &
         /
       data (OREF(51,13, mtmp), mtmp=1,12)   &
         /   &
         0.3180D-03,  0.3059D-03,  0.2986D-03,  0.3086D-03,   &
         0.3123D-03,  0.3231D-03,  0.3392D-03,  0.3167D-03,   &
         0.2979D-03,  0.2855D-03,  0.3029D-03,  0.3080D-03   &
         /
       data (OREF(51,14, mtmp), mtmp=1,12)   &
         /   &
         0.3341D-03,  0.3392D-03,  0.2872D-03,  0.2784D-03,   &
         0.2935D-03,  0.3023D-03,  0.3140D-03,  0.2989D-03,   &
         0.2905D-03,  0.2925D-03,  0.3204D-03,  0.2999D-03   &
         /
       data (OREF(51,15, mtmp), mtmp=1,12)   &
         /   &
         0.3106D-03,  0.3475D-03,  0.3023D-03,  0.2700D-03,   &
         0.2727D-03,  0.2804D-03,  0.2845D-03,  0.2754D-03,   &
         0.2804D-03,  0.3016D-03,  0.3150D-03,  0.2784D-03   &
         /
       data (OREF(51,16, mtmp), mtmp=1,12)   &
         /   &
         0.2949D-03,  0.3284D-03,  0.3184D-03,  0.2768D-03,   &
         0.2627D-03,  0.2640D-03,  0.2654D-03,  0.2593D-03,   &
         0.2744D-03,  0.2945D-03,  0.2875D-03,  0.2727D-03   &
         /
       data (OREF(51,17, mtmp), mtmp=1,12)   &
         /   &
         0.2949D-03,  0.3137D-03,  0.3150D-03,  0.2818D-03,   &
         0.2509D-03,  0.2321D-03,  0.2301D-03,  0.2432D-03,   &
         0.2637D-03,  0.2861D-03,  0.2875D-03,  0.2727D-03   &
         /
       data (OREF(51,18, mtmp), mtmp=1,12)   &
         /   &
         0.2949D-03,  0.3137D-03,  0.3150D-03,  0.2818D-03,   &
         0.2509D-03,  0.2321D-03,  0.2301D-03,  0.2432D-03,   &
         0.2637D-03,  0.2861D-03,  0.2875D-03,  0.2727D-03   &
         /
       data (TREF( 1, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2564D+03,  0.2533D+03,  0.2525D+03,  0.2487D+03,   &
         0.2473D+03,  0.2451D+03,  0.2462D+03,  0.2445D+03,   &
         0.2449D+03,  0.2460D+03,  0.2515D+03,  0.2527D+03   &
         /
       data (TREF( 1, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2621D+03,  0.2596D+03,  0.2569D+03,  0.2539D+03,   &
         0.2522D+03,  0.2504D+03,  0.2502D+03,  0.2494D+03,   &
         0.2501D+03,  0.2520D+03,  0.2566D+03,  0.2594D+03   &
         /
       data (TREF( 1, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2685D+03,  0.2675D+03,  0.2654D+03,  0.2633D+03,   &
         0.2615D+03,  0.2602D+03,  0.2593D+03,  0.2588D+03,   &
         0.2600D+03,  0.2616D+03,  0.2647D+03,  0.2668D+03   &
         /
       data (TREF( 1, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2736D+03,  0.2739D+03,  0.2728D+03,  0.2713D+03,   &
         0.2697D+03,  0.2687D+03,  0.2679D+03,  0.2677D+03,   &
         0.2686D+03,  0.2699D+03,  0.2713D+03,  0.2723D+03   &
         /
       data (TREF( 1, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2802D+03,  0.2807D+03,  0.2798D+03,  0.2781D+03,   &
         0.2763D+03,  0.2752D+03,  0.2746D+03,  0.2744D+03,   &
         0.2750D+03,  0.2762D+03,  0.2776D+03,  0.2788D+03   &
         /
       data (TREF( 1, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2872D+03,  0.2877D+03,  0.2869D+03,  0.2849D+03,   &
         0.2831D+03,  0.2815D+03,  0.2807D+03,  0.2806D+03,   &
         0.2810D+03,  0.2823D+03,  0.2839D+03,  0.2858D+03   &
         /
       data (TREF( 1, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2917D+03,  0.2922D+03,  0.2918D+03,  0.2903D+03,   &
         0.2888D+03,  0.2872D+03,  0.2864D+03,  0.2865D+03,   &
         0.2871D+03,  0.2881D+03,  0.2894D+03,  0.2910D+03   &
         /
       data (TREF( 1, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2934D+03,  0.2936D+03,  0.2938D+03,  0.2934D+03,   &
         0.2925D+03,  0.2914D+03,  0.2906D+03,  0.2907D+03,   &
         0.2913D+03,  0.2920D+03,  0.2926D+03,  0.2934D+03   &
         /
       data (TREF( 1, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2932D+03,  0.2934D+03,  0.2939D+03,  0.2941D+03,   &
         0.2938D+03,  0.2929D+03,  0.2920D+03,  0.2919D+03,   &
         0.2924D+03,  0.2927D+03,  0.2930D+03,  0.2933D+03   &
         /
       data (TREF( 1,10, mtmp), mtmp=1,12)   &
         /   &
         0.2928D+03,  0.2931D+03,  0.2937D+03,  0.2943D+03,   &
         0.2943D+03,  0.2938D+03,  0.2931D+03,  0.2931D+03,   &
         0.2933D+03,  0.2934D+03,  0.2934D+03,  0.2931D+03   &
         /
       data (TREF( 1,11, mtmp), mtmp=1,12)   &
         /   &
         0.2912D+03,  0.2916D+03,  0.2926D+03,  0.2940D+03,   &
         0.2949D+03,  0.2953D+03,  0.2951D+03,  0.2953D+03,   &
         0.2952D+03,  0.2945D+03,  0.2935D+03,  0.2921D+03   &
         /
       data (TREF( 1,12, mtmp), mtmp=1,12)   &
         /   &
         0.2862D+03,  0.2867D+03,  0.2882D+03,  0.2906D+03,   &
         0.2928D+03,  0.2950D+03,  0.2957D+03,  0.2958D+03,   &
         0.2950D+03,  0.2930D+03,  0.2902D+03,  0.2875D+03   &
         /
       data (TREF( 1,13, mtmp), mtmp=1,12)   &
         /   &
         0.2790D+03,  0.2792D+03,  0.2813D+03,  0.2848D+03,   &
         0.2884D+03,  0.2921D+03,  0.2942D+03,  0.2943D+03,   &
         0.2922D+03,  0.2884D+03,  0.2841D+03,  0.2804D+03   &
         /
       data (TREF( 1,14, mtmp), mtmp=1,12)   &
         /   &
         0.2699D+03,  0.2702D+03,  0.2730D+03,  0.2777D+03,   &
         0.2824D+03,  0.2866D+03,  0.2897D+03,  0.2896D+03,   &
         0.2859D+03,  0.2808D+03,  0.2753D+03,  0.2716D+03   &
         /
       data (TREF( 1,15, mtmp), mtmp=1,12)   &
         /   &
         0.2620D+03,  0.2623D+03,  0.2653D+03,  0.2704D+03,   &
         0.2761D+03,  0.2812D+03,  0.2844D+03,  0.2835D+03,   &
         0.2787D+03,  0.2728D+03,  0.2670D+03,  0.2635D+03   &
         /
       data (TREF( 1,16, mtmp), mtmp=1,12)   &
         /   &
         0.2566D+03,  0.2565D+03,  0.2586D+03,  0.2631D+03,   &
         0.2698D+03,  0.2764D+03,  0.2799D+03,  0.2782D+03,   &
         0.2731D+03,  0.2664D+03,  0.2607D+03,  0.2575D+03   &
         /
       data (TREF( 1,17, mtmp), mtmp=1,12)   &
         /   &
         0.2523D+03,  0.2515D+03,  0.2530D+03,  0.2562D+03,   &
         0.2637D+03,  0.2709D+03,  0.2747D+03,  0.2728D+03,   &
         0.2675D+03,  0.2607D+03,  0.2554D+03,  0.2530D+03   &
         /
       data (TREF( 1,18, mtmp), mtmp=1,12)   &
         /   &
         0.2498D+03,  0.2490D+03,  0.2509D+03,  0.2528D+03,   &
         0.2608D+03,  0.2672D+03,  0.2708D+03,  0.2693D+03,   &
         0.2640D+03,  0.2568D+03,  0.2525D+03,  0.2512D+03   &
         /
       data (TREF( 2, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2511D+03,  0.2483D+03,  0.2476D+03,  0.2446D+03,   &
         0.2434D+03,  0.2413D+03,  0.2422D+03,  0.2407D+03,   &
         0.2408D+03,  0.2419D+03,  0.2469D+03,  0.2487D+03   &
         /
       data (TREF( 2, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2564D+03,  0.2542D+03,  0.2519D+03,  0.2493D+03,   &
         0.2481D+03,  0.2463D+03,  0.2461D+03,  0.2454D+03,   &
         0.2459D+03,  0.2474D+03,  0.2515D+03,  0.2544D+03   &
         /
       data (TREF( 2, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2621D+03,  0.2613D+03,  0.2596D+03,  0.2575D+03,   &
         0.2561D+03,  0.2547D+03,  0.2538D+03,  0.2533D+03,   &
         0.2543D+03,  0.2557D+03,  0.2585D+03,  0.2607D+03   &
         /
       data (TREF( 2, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2670D+03,  0.2673D+03,  0.2664D+03,  0.2646D+03,   &
         0.2630D+03,  0.2618D+03,  0.2611D+03,  0.2607D+03,   &
         0.2616D+03,  0.2629D+03,  0.2645D+03,  0.2657D+03   &
         /
       data (TREF( 2, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2735D+03,  0.2742D+03,  0.2733D+03,  0.2713D+03,   &
         0.2692D+03,  0.2678D+03,  0.2672D+03,  0.2670D+03,   &
         0.2676D+03,  0.2690D+03,  0.2707D+03,  0.2720D+03   &
         /
       data (TREF( 2, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2803D+03,  0.2809D+03,  0.2800D+03,  0.2779D+03,   &
         0.2758D+03,  0.2741D+03,  0.2733D+03,  0.2733D+03,   &
         0.2738D+03,  0.2753D+03,  0.2770D+03,  0.2789D+03   &
         /
       data (TREF( 2, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2847D+03,  0.2851D+03,  0.2847D+03,  0.2832D+03,   &
         0.2817D+03,  0.2803D+03,  0.2796D+03,  0.2797D+03,   &
         0.2802D+03,  0.2813D+03,  0.2825D+03,  0.2839D+03   &
         /
       data (TREF( 2, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2864D+03,  0.2866D+03,  0.2867D+03,  0.2863D+03,   &
         0.2856D+03,  0.2847D+03,  0.2841D+03,  0.2842D+03,   &
         0.2846D+03,  0.2852D+03,  0.2857D+03,  0.2863D+03   &
         /
       data (TREF( 2, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2864D+03,  0.2866D+03,  0.2870D+03,  0.2872D+03,   &
         0.2869D+03,  0.2862D+03,  0.2854D+03,  0.2855D+03,   &
         0.2858D+03,  0.2861D+03,  0.2863D+03,  0.2865D+03   &
         /
       data (TREF( 2,10, mtmp), mtmp=1,12)   &
         /   &
         0.2861D+03,  0.2863D+03,  0.2868D+03,  0.2873D+03,   &
         0.2874D+03,  0.2869D+03,  0.2861D+03,  0.2863D+03,   &
         0.2864D+03,  0.2866D+03,  0.2865D+03,  0.2864D+03   &
         /
       data (TREF( 2,11, mtmp), mtmp=1,12)   &
         /   &
         0.2845D+03,  0.2848D+03,  0.2856D+03,  0.2866D+03,   &
         0.2874D+03,  0.2878D+03,  0.2874D+03,  0.2877D+03,   &
         0.2875D+03,  0.2870D+03,  0.2862D+03,  0.2853D+03   &
         /
       data (TREF( 2,12, mtmp), mtmp=1,12)   &
         /   &
         0.2795D+03,  0.2798D+03,  0.2810D+03,  0.2832D+03,   &
         0.2853D+03,  0.2873D+03,  0.2878D+03,  0.2880D+03,   &
         0.2871D+03,  0.2853D+03,  0.2830D+03,  0.2808D+03   &
         /
       data (TREF( 2,13, mtmp), mtmp=1,12)   &
         /   &
         0.2719D+03,  0.2720D+03,  0.2739D+03,  0.2773D+03,   &
         0.2808D+03,  0.2843D+03,  0.2863D+03,  0.2864D+03,   &
         0.2843D+03,  0.2808D+03,  0.2769D+03,  0.2736D+03   &
         /
       data (TREF( 2,14, mtmp), mtmp=1,12)   &
         /   &
         0.2636D+03,  0.2637D+03,  0.2660D+03,  0.2704D+03,   &
         0.2748D+03,  0.2790D+03,  0.2820D+03,  0.2819D+03,   &
         0.2784D+03,  0.2736D+03,  0.2687D+03,  0.2654D+03   &
         /
       data (TREF( 2,15, mtmp), mtmp=1,12)   &
         /   &
         0.2569D+03,  0.2571D+03,  0.2592D+03,  0.2638D+03,   &
         0.2689D+03,  0.2739D+03,  0.2770D+03,  0.2763D+03,   &
         0.2717D+03,  0.2664D+03,  0.2613D+03,  0.2583D+03   &
         /
       data (TREF( 2,16, mtmp), mtmp=1,12)   &
         /   &
         0.2522D+03,  0.2522D+03,  0.2536D+03,  0.2575D+03,   &
         0.2636D+03,  0.2698D+03,  0.2731D+03,  0.2716D+03,   &
         0.2666D+03,  0.2607D+03,  0.2557D+03,  0.2530D+03   &
         /
       data (TREF( 2,17, mtmp), mtmp=1,12)   &
         /   &
         0.2483D+03,  0.2477D+03,  0.2488D+03,  0.2516D+03,   &
         0.2585D+03,  0.2653D+03,  0.2690D+03,  0.2670D+03,   &
         0.2618D+03,  0.2557D+03,  0.2510D+03,  0.2490D+03   &
         /
       data (TREF( 2,18, mtmp), mtmp=1,12)   &
         /   &
         0.2458D+03,  0.2451D+03,  0.2468D+03,  0.2488D+03,   &
         0.2560D+03,  0.2621D+03,  0.2657D+03,  0.2638D+03,   &
         0.2586D+03,  0.2522D+03,  0.2481D+03,  0.2472D+03   &
         /
       data (TREF( 3, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2419D+03,  0.2397D+03,  0.2391D+03,  0.2368D+03,   &
         0.2358D+03,  0.2336D+03,  0.2340D+03,  0.2327D+03,   &
         0.2328D+03,  0.2338D+03,  0.2381D+03,  0.2404D+03   &
         /
       data (TREF( 3, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2458D+03,  0.2443D+03,  0.2425D+03,  0.2403D+03,   &
         0.2394D+03,  0.2374D+03,  0.2371D+03,  0.2364D+03,   &
         0.2368D+03,  0.2380D+03,  0.2416D+03,  0.2444D+03   &
         /
       data (TREF( 3, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2502D+03,  0.2497D+03,  0.2483D+03,  0.2462D+03,   &
         0.2450D+03,  0.2434D+03,  0.2425D+03,  0.2421D+03,   &
         0.2429D+03,  0.2441D+03,  0.2467D+03,  0.2489D+03   &
         /
       data (TREF( 3, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2546D+03,  0.2550D+03,  0.2543D+03,  0.2521D+03,   &
         0.2502D+03,  0.2487D+03,  0.2480D+03,  0.2476D+03,   &
         0.2484D+03,  0.2499D+03,  0.2518D+03,  0.2532D+03   &
         /
       data (TREF( 3, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2608D+03,  0.2616D+03,  0.2608D+03,  0.2584D+03,   &
         0.2558D+03,  0.2541D+03,  0.2535D+03,  0.2533D+03,   &
         0.2540D+03,  0.2557D+03,  0.2577D+03,  0.2593D+03   &
         /
       data (TREF( 3, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2672D+03,  0.2678D+03,  0.2669D+03,  0.2645D+03,   &
         0.2622D+03,  0.2605D+03,  0.2597D+03,  0.2597D+03,   &
         0.2603D+03,  0.2619D+03,  0.2638D+03,  0.2657D+03   &
         /
       data (TREF( 3, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2714D+03,  0.2718D+03,  0.2713D+03,  0.2698D+03,   &
         0.2684D+03,  0.2672D+03,  0.2667D+03,  0.2667D+03,   &
         0.2671D+03,  0.2681D+03,  0.2692D+03,  0.2705D+03   &
         /
       data (TREF( 3, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2732D+03,  0.2734D+03,  0.2734D+03,  0.2731D+03,   &
         0.2726D+03,  0.2720D+03,  0.2715D+03,  0.2717D+03,   &
         0.2718D+03,  0.2722D+03,  0.2726D+03,  0.2731D+03   &
         /
       data (TREF( 3, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2735D+03,  0.2736D+03,  0.2738D+03,  0.2740D+03,   &
         0.2740D+03,  0.2734D+03,  0.2728D+03,  0.2730D+03,   &
         0.2731D+03,  0.2734D+03,  0.2735D+03,  0.2737D+03   &
         /
       data (TREF( 3,10, mtmp), mtmp=1,12)   &
         /   &
         0.2733D+03,  0.2734D+03,  0.2737D+03,  0.2740D+03,   &
         0.2742D+03,  0.2738D+03,  0.2731D+03,  0.2734D+03,   &
         0.2734D+03,  0.2736D+03,  0.2736D+03,  0.2736D+03   &
         /
       data (TREF( 3,11, mtmp), mtmp=1,12)   &
         /   &
         0.2718D+03,  0.2718D+03,  0.2722D+03,  0.2729D+03,   &
         0.2736D+03,  0.2739D+03,  0.2736D+03,  0.2740D+03,   &
         0.2737D+03,  0.2733D+03,  0.2728D+03,  0.2723D+03   &
         /
       data (TREF( 3,12, mtmp), mtmp=1,12)   &
         /   &
         0.2667D+03,  0.2667D+03,  0.2675D+03,  0.2692D+03,   &
         0.2711D+03,  0.2730D+03,  0.2734D+03,  0.2738D+03,   &
         0.2729D+03,  0.2713D+03,  0.2695D+03,  0.2679D+03   &
         /
       data (TREF( 3,13, mtmp), mtmp=1,12)   &
         /   &
         0.2587D+03,  0.2586D+03,  0.2602D+03,  0.2633D+03,   &
         0.2665D+03,  0.2699D+03,  0.2718D+03,  0.2720D+03,   &
         0.2700D+03,  0.2668D+03,  0.2633D+03,  0.2606D+03   &
         /
       data (TREF( 3,14, mtmp), mtmp=1,12)   &
         /   &
         0.2513D+03,  0.2511D+03,  0.2530D+03,  0.2568D+03,   &
         0.2608D+03,  0.2648D+03,  0.2678D+03,  0.2679D+03,   &
         0.2645D+03,  0.2604D+03,  0.2559D+03,  0.2531D+03   &
         /
       data (TREF( 3,15, mtmp), mtmp=1,12)   &
         /   &
         0.2460D+03,  0.2461D+03,  0.2474D+03,  0.2512D+03,   &
         0.2556D+03,  0.2603D+03,  0.2635D+03,  0.2629D+03,   &
         0.2587D+03,  0.2541D+03,  0.2497D+03,  0.2473D+03   &
         /
       data (TREF( 3,16, mtmp), mtmp=1,12)   &
         /   &
         0.2421D+03,  0.2422D+03,  0.2430D+03,  0.2462D+03,   &
         0.2514D+03,  0.2571D+03,  0.2602D+03,  0.2588D+03,   &
         0.2541D+03,  0.2492D+03,  0.2451D+03,  0.2428D+03   &
         /
       data (TREF( 3,17, mtmp), mtmp=1,12)   &
         /   &
         0.2388D+03,  0.2385D+03,  0.2394D+03,  0.2418D+03,   &
         0.2477D+03,  0.2539D+03,  0.2572D+03,  0.2552D+03,   &
         0.2504D+03,  0.2453D+03,  0.2413D+03,  0.2396D+03   &
         /
       data (TREF( 3,18, mtmp), mtmp=1,12)   &
         /   &
         0.2364D+03,  0.2359D+03,  0.2375D+03,  0.2397D+03,   &
         0.2456D+03,  0.2513D+03,  0.2547D+03,  0.2525D+03,   &
         0.2477D+03,  0.2426D+03,  0.2386D+03,  0.2378D+03   &
         /
       data (TREF( 4, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2332D+03,  0.2318D+03,  0.2307D+03,  0.2284D+03,   &
         0.2268D+03,  0.2243D+03,  0.2241D+03,  0.2230D+03,   &
         0.2234D+03,  0.2242D+03,  0.2283D+03,  0.2315D+03   &
         /
       data (TREF( 4, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2356D+03,  0.2346D+03,  0.2328D+03,  0.2304D+03,   &
         0.2291D+03,  0.2268D+03,  0.2261D+03,  0.2254D+03,   &
         0.2260D+03,  0.2271D+03,  0.2308D+03,  0.2341D+03   &
         /
       data (TREF( 4, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2385D+03,  0.2383D+03,  0.2370D+03,  0.2346D+03,   &
         0.2330D+03,  0.2311D+03,  0.2301D+03,  0.2295D+03,   &
         0.2303D+03,  0.2318D+03,  0.2347D+03,  0.2371D+03   &
         /
       data (TREF( 4, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2420D+03,  0.2426D+03,  0.2418D+03,  0.2394D+03,   &
         0.2373D+03,  0.2355D+03,  0.2347D+03,  0.2343D+03,   &
         0.2352D+03,  0.2370D+03,  0.2392D+03,  0.2406D+03   &
         /
       data (TREF( 4, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2473D+03,  0.2481D+03,  0.2473D+03,  0.2447D+03,   &
         0.2421D+03,  0.2403D+03,  0.2397D+03,  0.2396D+03,   &
         0.2404D+03,  0.2423D+03,  0.2443D+03,  0.2458D+03   &
         /
       data (TREF( 4, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2529D+03,  0.2536D+03,  0.2526D+03,  0.2502D+03,   &
         0.2479D+03,  0.2463D+03,  0.2457D+03,  0.2458D+03,   &
         0.2464D+03,  0.2479D+03,  0.2497D+03,  0.2514D+03   &
         /
       data (TREF( 4, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2570D+03,  0.2575D+03,  0.2569D+03,  0.2554D+03,   &
         0.2541D+03,  0.2533D+03,  0.2528D+03,  0.2530D+03,   &
         0.2531D+03,  0.2538D+03,  0.2549D+03,  0.2561D+03   &
         /
       data (TREF( 4, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2590D+03,  0.2592D+03,  0.2592D+03,  0.2588D+03,   &
         0.2584D+03,  0.2581D+03,  0.2576D+03,  0.2578D+03,   &
         0.2578D+03,  0.2580D+03,  0.2583D+03,  0.2588D+03   &
         /
       data (TREF( 4, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2594D+03,  0.2595D+03,  0.2597D+03,  0.2599D+03,   &
         0.2599D+03,  0.2595D+03,  0.2588D+03,  0.2590D+03,   &
         0.2591D+03,  0.2594D+03,  0.2595D+03,  0.2596D+03   &
         /
       data (TREF( 4,10, mtmp), mtmp=1,12)   &
         /   &
         0.2593D+03,  0.2593D+03,  0.2595D+03,  0.2599D+03,   &
         0.2600D+03,  0.2597D+03,  0.2590D+03,  0.2593D+03,   &
         0.2593D+03,  0.2595D+03,  0.2595D+03,  0.2595D+03   &
         /
       data (TREF( 4,11, mtmp), mtmp=1,12)   &
         /   &
         0.2577D+03,  0.2578D+03,  0.2580D+03,  0.2584D+03,   &
         0.2591D+03,  0.2595D+03,  0.2593D+03,  0.2597D+03,   &
         0.2594D+03,  0.2590D+03,  0.2585D+03,  0.2581D+03   &
         /
       data (TREF( 4,12, mtmp), mtmp=1,12)   &
         /   &
         0.2528D+03,  0.2527D+03,  0.2531D+03,  0.2543D+03,   &
         0.2562D+03,  0.2583D+03,  0.2590D+03,  0.2593D+03,   &
         0.2584D+03,  0.2567D+03,  0.2551D+03,  0.2537D+03   &
         /
       data (TREF( 4,13, mtmp), mtmp=1,12)   &
         /   &
         0.2451D+03,  0.2449D+03,  0.2460D+03,  0.2485D+03,   &
         0.2516D+03,  0.2551D+03,  0.2573D+03,  0.2574D+03,   &
         0.2554D+03,  0.2522D+03,  0.2491D+03,  0.2468D+03   &
         /
       data (TREF( 4,14, mtmp), mtmp=1,12)   &
         /   &
         0.2383D+03,  0.2380D+03,  0.2395D+03,  0.2428D+03,   &
         0.2463D+03,  0.2502D+03,  0.2533D+03,  0.2534D+03,   &
         0.2502D+03,  0.2464D+03,  0.2424D+03,  0.2400D+03   &
         /
       data (TREF( 4,15, mtmp), mtmp=1,12)   &
         /   &
         0.2337D+03,  0.2338D+03,  0.2349D+03,  0.2382D+03,   &
         0.2419D+03,  0.2461D+03,  0.2492D+03,  0.2487D+03,   &
         0.2448D+03,  0.2409D+03,  0.2370D+03,  0.2349D+03   &
         /
       data (TREF( 4,16, mtmp), mtmp=1,12)   &
         /   &
         0.2303D+03,  0.2306D+03,  0.2315D+03,  0.2346D+03,   &
         0.2387D+03,  0.2435D+03,  0.2463D+03,  0.2450D+03,   &
         0.2408D+03,  0.2367D+03,  0.2331D+03,  0.2311D+03   &
         /
       data (TREF( 4,17, mtmp), mtmp=1,12)   &
         /   &
         0.2276D+03,  0.2277D+03,  0.2289D+03,  0.2316D+03,   &
         0.2363D+03,  0.2414D+03,  0.2442D+03,  0.2423D+03,   &
         0.2380D+03,  0.2338D+03,  0.2301D+03,  0.2284D+03   &
         /
       data (TREF( 4,18, mtmp), mtmp=1,12)   &
         /   &
         0.2256D+03,  0.2254D+03,  0.2273D+03,  0.2301D+03,   &
         0.2349D+03,  0.2399D+03,  0.2427D+03,  0.2405D+03,   &
         0.2361D+03,  0.2321D+03,  0.2280D+03,  0.2269D+03   &
         /
       data (TREF( 5, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2280D+03,  0.2273D+03,  0.2246D+03,  0.2217D+03,   &
         0.2186D+03,  0.2155D+03,  0.2142D+03,  0.2132D+03,   &
         0.2137D+03,  0.2148D+03,  0.2197D+03,  0.2255D+03   &
         /
       data (TREF( 5, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2286D+03,  0.2282D+03,  0.2259D+03,  0.2228D+03,   &
         0.2200D+03,  0.2171D+03,  0.2154D+03,  0.2145D+03,   &
         0.2152D+03,  0.2167D+03,  0.2215D+03,  0.2265D+03   &
         /
       data (TREF( 5, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2301D+03,  0.2301D+03,  0.2287D+03,  0.2258D+03,   &
         0.2232D+03,  0.2207D+03,  0.2190D+03,  0.2181D+03,   &
         0.2190D+03,  0.2213D+03,  0.2252D+03,  0.2284D+03   &
         /
       data (TREF( 5, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2319D+03,  0.2323D+03,  0.2314D+03,  0.2289D+03,   &
         0.2265D+03,  0.2245D+03,  0.2234D+03,  0.2229D+03,   &
         0.2240D+03,  0.2264D+03,  0.2290D+03,  0.2305D+03   &
         /
       data (TREF( 5, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2347D+03,  0.2354D+03,  0.2345D+03,  0.2321D+03,   &
         0.2299D+03,  0.2283D+03,  0.2278D+03,  0.2279D+03,   &
         0.2289D+03,  0.2307D+03,  0.2324D+03,  0.2334D+03   &
         /
       data (TREF( 5, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2388D+03,  0.2395D+03,  0.2386D+03,  0.2363D+03,   &
         0.2345D+03,  0.2335D+03,  0.2332D+03,  0.2335D+03,   &
         0.2340D+03,  0.2351D+03,  0.2363D+03,  0.2375D+03   &
         /
       data (TREF( 5, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2426D+03,  0.2431D+03,  0.2425D+03,  0.2410D+03,   &
         0.2401D+03,  0.2396D+03,  0.2393D+03,  0.2396D+03,   &
         0.2396D+03,  0.2400D+03,  0.2407D+03,  0.2416D+03   &
         /
       data (TREF( 5, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2444D+03,  0.2446D+03,  0.2446D+03,  0.2443D+03,   &
         0.2440D+03,  0.2438D+03,  0.2432D+03,  0.2435D+03,   &
         0.2434D+03,  0.2436D+03,  0.2438D+03,  0.2441D+03   &
         /
       data (TREF( 5, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2447D+03,  0.2448D+03,  0.2451D+03,  0.2453D+03,   &
         0.2454D+03,  0.2450D+03,  0.2442D+03,  0.2445D+03,   &
         0.2445D+03,  0.2448D+03,  0.2448D+03,  0.2449D+03   &
         /
       data (TREF( 5,10, mtmp), mtmp=1,12)   &
         /   &
         0.2446D+03,  0.2447D+03,  0.2449D+03,  0.2453D+03,   &
         0.2454D+03,  0.2452D+03,  0.2445D+03,  0.2447D+03,   &
         0.2447D+03,  0.2449D+03,  0.2448D+03,  0.2448D+03   &
         /
       data (TREF( 5,11, mtmp), mtmp=1,12)   &
         /   &
         0.2433D+03,  0.2434D+03,  0.2435D+03,  0.2437D+03,   &
         0.2444D+03,  0.2450D+03,  0.2448D+03,  0.2451D+03,   &
         0.2447D+03,  0.2442D+03,  0.2437D+03,  0.2433D+03   &
         /
       data (TREF( 5,12, mtmp), mtmp=1,12)   &
         /   &
         0.2392D+03,  0.2392D+03,  0.2392D+03,  0.2398D+03,   &
         0.2415D+03,  0.2438D+03,  0.2447D+03,  0.2449D+03,   &
         0.2438D+03,  0.2421D+03,  0.2407D+03,  0.2397D+03   &
         /
       data (TREF( 5,13, mtmp), mtmp=1,12)   &
         /   &
         0.2328D+03,  0.2325D+03,  0.2329D+03,  0.2346D+03,   &
         0.2372D+03,  0.2407D+03,  0.2432D+03,  0.2431D+03,   &
         0.2410D+03,  0.2381D+03,  0.2355D+03,  0.2339D+03   &
         /
       data (TREF( 5,14, mtmp), mtmp=1,12)   &
         /   &
         0.2271D+03,  0.2269D+03,  0.2277D+03,  0.2301D+03,   &
         0.2330D+03,  0.2364D+03,  0.2395D+03,  0.2393D+03,   &
         0.2365D+03,  0.2333D+03,  0.2301D+03,  0.2284D+03   &
         /
       data (TREF( 5,15, mtmp), mtmp=1,12)   &
         /   &
         0.2234D+03,  0.2235D+03,  0.2247D+03,  0.2273D+03,   &
         0.2301D+03,  0.2333D+03,  0.2358D+03,  0.2352D+03,   &
         0.2321D+03,  0.2293D+03,  0.2261D+03,  0.2245D+03   &
         /
       data (TREF( 5,16, mtmp), mtmp=1,12)   &
         /   &
         0.2204D+03,  0.2210D+03,  0.2227D+03,  0.2257D+03,   &
         0.2287D+03,  0.2320D+03,  0.2339D+03,  0.2326D+03,   &
         0.2293D+03,  0.2263D+03,  0.2233D+03,  0.2214D+03   &
         /
       data (TREF( 5,17, mtmp), mtmp=1,12)   &
         /   &
         0.2183D+03,  0.2189D+03,  0.2213D+03,  0.2250D+03,   &
         0.2285D+03,  0.2320D+03,  0.2335D+03,  0.2317D+03,   &
         0.2281D+03,  0.2246D+03,  0.2213D+03,  0.2193D+03   &
         /
       data (TREF( 5,18, mtmp), mtmp=1,12)   &
         /   &
         0.2167D+03,  0.2169D+03,  0.2199D+03,  0.2242D+03,   &
         0.2282D+03,  0.2322D+03,  0.2338D+03,  0.2315D+03,   &
         0.2277D+03,  0.2241D+03,  0.2198D+03,  0.2180D+03   &
         /
       data (TREF( 6, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2278D+03,  0.2276D+03,  0.2232D+03,  0.2187D+03,   &
         0.2137D+03,  0.2095D+03,  0.2065D+03,  0.2052D+03,   &
         0.2058D+03,  0.2077D+03,  0.2147D+03,  0.2248D+03   &
         /
       data (TREF( 6, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2268D+03,  0.2267D+03,  0.2238D+03,  0.2194D+03,   &
         0.2147D+03,  0.2106D+03,  0.2074D+03,  0.2061D+03,   &
         0.2067D+03,  0.2095D+03,  0.2162D+03,  0.2242D+03   &
         /
       data (TREF( 6, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2270D+03,  0.2270D+03,  0.2251D+03,  0.2216D+03,   &
         0.2177D+03,  0.2142D+03,  0.2115D+03,  0.2101D+03,   &
         0.2112D+03,  0.2149D+03,  0.2203D+03,  0.2250D+03   &
         /
       data (TREF( 6, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2262D+03,  0.2263D+03,  0.2250D+03,  0.2225D+03,   &
         0.2200D+03,  0.2177D+03,  0.2162D+03,  0.2156D+03,   &
         0.2170D+03,  0.2202D+03,  0.2232D+03,  0.2249D+03   &
         /
       data (TREF( 6, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2253D+03,  0.2257D+03,  0.2249D+03,  0.2229D+03,   &
         0.2215D+03,  0.2204D+03,  0.2201D+03,  0.2204D+03,   &
         0.2214D+03,  0.2232D+03,  0.2241D+03,  0.2246D+03   &
         /
       data (TREF( 6, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2267D+03,  0.2272D+03,  0.2265D+03,  0.2249D+03,   &
         0.2239D+03,  0.2236D+03,  0.2238D+03,  0.2244D+03,   &
         0.2247D+03,  0.2252D+03,  0.2255D+03,  0.2259D+03   &
         /
       data (TREF( 6, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2289D+03,  0.2293D+03,  0.2289D+03,  0.2280D+03,   &
         0.2274D+03,  0.2274D+03,  0.2273D+03,  0.2278D+03,   &
         0.2276D+03,  0.2277D+03,  0.2278D+03,  0.2282D+03   &
         /
       data (TREF( 6, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2301D+03,  0.2302D+03,  0.2303D+03,  0.2302D+03,   &
         0.2301D+03,  0.2300D+03,  0.2295D+03,  0.2298D+03,   &
         0.2296D+03,  0.2296D+03,  0.2296D+03,  0.2299D+03   &
         /
       data (TREF( 6, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2302D+03,  0.2303D+03,  0.2306D+03,  0.2309D+03,   &
         0.2310D+03,  0.2308D+03,  0.2301D+03,  0.2303D+03,   &
         0.2302D+03,  0.2303D+03,  0.2303D+03,  0.2303D+03   &
         /
       data (TREF( 6,10, mtmp), mtmp=1,12)   &
         /   &
         0.2301D+03,  0.2302D+03,  0.2304D+03,  0.2307D+03,   &
         0.2309D+03,  0.2309D+03,  0.2302D+03,  0.2304D+03,   &
         0.2303D+03,  0.2303D+03,  0.2302D+03,  0.2301D+03   &
         /
       data (TREF( 6,11, mtmp), mtmp=1,12)   &
         /   &
         0.2292D+03,  0.2294D+03,  0.2295D+03,  0.2296D+03,   &
         0.2301D+03,  0.2306D+03,  0.2305D+03,  0.2307D+03,   &
         0.2301D+03,  0.2297D+03,  0.2292D+03,  0.2290D+03   &
         /
       data (TREF( 6,12, mtmp), mtmp=1,12)   &
         /   &
         0.2270D+03,  0.2271D+03,  0.2269D+03,  0.2269D+03,   &
         0.2280D+03,  0.2299D+03,  0.2308D+03,  0.2309D+03,   &
         0.2297D+03,  0.2283D+03,  0.2273D+03,  0.2269D+03   &
         /
       data (TREF( 6,13, mtmp), mtmp=1,12)   &
         /   &
         0.2234D+03,  0.2234D+03,  0.2230D+03,  0.2235D+03,   &
         0.2252D+03,  0.2281D+03,  0.2303D+03,  0.2301D+03,   &
         0.2282D+03,  0.2260D+03,  0.2243D+03,  0.2236D+03   &
         /
       data (TREF( 6,14, mtmp), mtmp=1,12)   &
         /   &
         0.2202D+03,  0.2203D+03,  0.2204D+03,  0.2214D+03,   &
         0.2234D+03,  0.2259D+03,  0.2283D+03,  0.2279D+03,   &
         0.2257D+03,  0.2235D+03,  0.2215D+03,  0.2207D+03   &
         /
       data (TREF( 6,15, mtmp), mtmp=1,12)   &
         /   &
         0.2175D+03,  0.2180D+03,  0.2193D+03,  0.2210D+03,   &
         0.2231D+03,  0.2250D+03,  0.2266D+03,  0.2259D+03,   &
         0.2237D+03,  0.2218D+03,  0.2196D+03,  0.2184D+03   &
         /
       data (TREF( 6,16, mtmp), mtmp=1,12)   &
         /   &
         0.2149D+03,  0.2159D+03,  0.2187D+03,  0.2218D+03,   &
         0.2241D+03,  0.2258D+03,  0.2267D+03,  0.2254D+03,   &
         0.2230D+03,  0.2208D+03,  0.2180D+03,  0.2161D+03   &
         /
       data (TREF( 6,17, mtmp), mtmp=1,12)   &
         /   &
         0.2130D+03,  0.2143D+03,  0.2183D+03,  0.2231D+03,   &
         0.2260D+03,  0.2280D+03,  0.2284D+03,  0.2266D+03,   &
         0.2236D+03,  0.2203D+03,  0.2170D+03,  0.2143D+03   &
         /
       data (TREF( 6,18, mtmp), mtmp=1,12)   &
         /   &
         0.2115D+03,  0.2124D+03,  0.2170D+03,  0.2227D+03,   &
         0.2265D+03,  0.2295D+03,  0.2301D+03,  0.2279D+03,   &
         0.2244D+03,  0.2204D+03,  0.2160D+03,  0.2129D+03   &
         /
       data (TREF( 7, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2303D+03,  0.2299D+03,  0.2246D+03,  0.2184D+03,   &
         0.2117D+03,  0.2062D+03,  0.2016D+03,  0.1997D+03,   &
         0.2003D+03,  0.2040D+03,  0.2138D+03,  0.2273D+03   &
         /
       data (TREF( 7, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2286D+03,  0.2282D+03,  0.2247D+03,  0.2192D+03,   &
         0.2128D+03,  0.2074D+03,  0.2028D+03,  0.2009D+03,   &
         0.2017D+03,  0.2065D+03,  0.2157D+03,  0.2261D+03   &
         /
       data (TREF( 7, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2276D+03,  0.2273D+03,  0.2249D+03,  0.2209D+03,   &
         0.2161D+03,  0.2115D+03,  0.2079D+03,  0.2061D+03,   &
         0.2076D+03,  0.2131D+03,  0.2200D+03,  0.2259D+03   &
         /
       data (TREF( 7, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2248D+03,  0.2244D+03,  0.2228D+03,  0.2204D+03,   &
         0.2181D+03,  0.2153D+03,  0.2135D+03,  0.2129D+03,   &
         0.2147D+03,  0.2187D+03,  0.2218D+03,  0.2238D+03   &
         /
       data (TREF( 7, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2204D+03,  0.2202D+03,  0.2195D+03,  0.2184D+03,   &
         0.2178D+03,  0.2171D+03,  0.2169D+03,  0.2175D+03,   &
         0.2186D+03,  0.2201D+03,  0.2203D+03,  0.2202D+03   &
         /
       data (TREF( 7, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2178D+03,  0.2179D+03,  0.2177D+03,  0.2172D+03,   &
         0.2171D+03,  0.2175D+03,  0.2180D+03,  0.2187D+03,   &
         0.2190D+03,  0.2189D+03,  0.2183D+03,  0.2178D+03   &
         /
       data (TREF( 7, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2170D+03,  0.2171D+03,  0.2171D+03,  0.2170D+03,   &
         0.2170D+03,  0.2174D+03,  0.2176D+03,  0.2181D+03,   &
         0.2179D+03,  0.2176D+03,  0.2170D+03,  0.2169D+03   &
         /
       data (TREF( 7, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2165D+03,  0.2166D+03,  0.2168D+03,  0.2169D+03,   &
         0.2171D+03,  0.2172D+03,  0.2170D+03,  0.2173D+03,   &
         0.2171D+03,  0.2168D+03,  0.2165D+03,  0.2165D+03   &
         /
       data (TREF( 7, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2163D+03,  0.2164D+03,  0.2166D+03,  0.2168D+03,   &
         0.2171D+03,  0.2173D+03,  0.2170D+03,  0.2172D+03,   &
         0.2170D+03,  0.2167D+03,  0.2163D+03,  0.2163D+03   &
         /
       data (TREF( 7,10, mtmp), mtmp=1,12)   &
         /   &
         0.2162D+03,  0.2163D+03,  0.2165D+03,  0.2167D+03,   &
         0.2170D+03,  0.2172D+03,  0.2169D+03,  0.2171D+03,   &
         0.2168D+03,  0.2165D+03,  0.2162D+03,  0.2161D+03   &
         /
       data (TREF( 7,11, mtmp), mtmp=1,12)   &
         /   &
         0.2161D+03,  0.2163D+03,  0.2163D+03,  0.2164D+03,   &
         0.2167D+03,  0.2171D+03,  0.2172D+03,  0.2173D+03,   &
         0.2168D+03,  0.2162D+03,  0.2158D+03,  0.2158D+03   &
         /
       data (TREF( 7,12, mtmp), mtmp=1,12)   &
         /   &
         0.2166D+03,  0.2168D+03,  0.2165D+03,  0.2163D+03,   &
         0.2166D+03,  0.2176D+03,  0.2182D+03,  0.2182D+03,   &
         0.2172D+03,  0.2164D+03,  0.2158D+03,  0.2160D+03   &
         /
       data (TREF( 7,13, mtmp), mtmp=1,12)   &
         /   &
         0.2175D+03,  0.2178D+03,  0.2171D+03,  0.2167D+03,   &
         0.2172D+03,  0.2187D+03,  0.2198D+03,  0.2195D+03,   &
         0.2182D+03,  0.2170D+03,  0.2165D+03,  0.2169D+03   &
         /
       data (TREF( 7,14, mtmp), mtmp=1,12)   &
         /   &
         0.2178D+03,  0.2183D+03,  0.2180D+03,  0.2179D+03,   &
         0.2190D+03,  0.2204D+03,  0.2215D+03,  0.2209D+03,   &
         0.2194D+03,  0.2181D+03,  0.2173D+03,  0.2175D+03   &
         /
       data (TREF( 7,15, mtmp), mtmp=1,12)   &
         /   &
         0.2162D+03,  0.2172D+03,  0.2186D+03,  0.2196D+03,   &
         0.2212D+03,  0.2225D+03,  0.2232D+03,  0.2223D+03,   &
         0.2207D+03,  0.2192D+03,  0.2176D+03,  0.2168D+03   &
         /
       data (TREF( 7,16, mtmp), mtmp=1,12)   &
         /   &
         0.2135D+03,  0.2150D+03,  0.2187D+03,  0.2218D+03,   &
         0.2239D+03,  0.2250D+03,  0.2254D+03,  0.2241D+03,   &
         0.2220D+03,  0.2198D+03,  0.2170D+03,  0.2148D+03   &
         /
       data (TREF( 7,17, mtmp), mtmp=1,12)   &
         /   &
         0.2112D+03,  0.2133D+03,  0.2185D+03,  0.2239D+03,   &
         0.2267D+03,  0.2282D+03,  0.2283D+03,  0.2266D+03,   &
         0.2236D+03,  0.2201D+03,  0.2163D+03,  0.2128D+03   &
         /
       data (TREF( 7,18, mtmp), mtmp=1,12)   &
         /   &
         0.2096D+03,  0.2112D+03,  0.2174D+03,  0.2238D+03,   &
         0.2275D+03,  0.2300D+03,  0.2302D+03,  0.2282D+03,   &
         0.2246D+03,  0.2201D+03,  0.2153D+03,  0.2110D+03   &
         /
       data (TREF( 8, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2323D+03,  0.2313D+03,  0.2257D+03,  0.2180D+03,   &
         0.2102D+03,  0.2037D+03,  0.1981D+03,  0.1960D+03,   &
         0.1969D+03,  0.2025D+03,  0.2154D+03,  0.2304D+03   &
         /
       data (TREF( 8, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2306D+03,  0.2296D+03,  0.2256D+03,  0.2192D+03,   &
         0.2117D+03,  0.2053D+03,  0.2000D+03,  0.1978D+03,   &
         0.1991D+03,  0.2059D+03,  0.2177D+03,  0.2290D+03   &
         /
       data (TREF( 8, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2290D+03,  0.2281D+03,  0.2252D+03,  0.2209D+03,   &
         0.2154D+03,  0.2101D+03,  0.2058D+03,  0.2040D+03,   &
         0.2062D+03,  0.2134D+03,  0.2217D+03,  0.2279D+03   &
         /
       data (TREF( 8, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2249D+03,  0.2241D+03,  0.2222D+03,  0.2200D+03,   &
         0.2177D+03,  0.2147D+03,  0.2126D+03,  0.2122D+03,   &
         0.2143D+03,  0.2191D+03,  0.2223D+03,  0.2244D+03   &
         /
       data (TREF( 8, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2183D+03,  0.2177D+03,  0.2171D+03,  0.2166D+03,   &
         0.2167D+03,  0.2161D+03,  0.2160D+03,  0.2167D+03,   &
         0.2179D+03,  0.2193D+03,  0.2189D+03,  0.2186D+03   &
         /
       data (TREF( 8, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2121D+03,  0.2118D+03,  0.2120D+03,  0.2126D+03,   &
         0.2134D+03,  0.2140D+03,  0.2146D+03,  0.2154D+03,   &
         0.2158D+03,  0.2154D+03,  0.2140D+03,  0.2129D+03   &
         /
       data (TREF( 8, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2076D+03,  0.2074D+03,  0.2078D+03,  0.2086D+03,   &
         0.2091D+03,  0.2098D+03,  0.2104D+03,  0.2109D+03,   &
         0.2108D+03,  0.2101D+03,  0.2090D+03,  0.2082D+03   &
         /
       data (TREF( 8, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2049D+03,  0.2049D+03,  0.2051D+03,  0.2055D+03,   &
         0.2059D+03,  0.2065D+03,  0.2068D+03,  0.2072D+03,   &
         0.2070D+03,  0.2063D+03,  0.2054D+03,  0.2050D+03   &
         /
       data (TREF( 8, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2040D+03,  0.2041D+03,  0.2042D+03,  0.2044D+03,   &
         0.2048D+03,  0.2056D+03,  0.2059D+03,  0.2062D+03,   &
         0.2060D+03,  0.2051D+03,  0.2043D+03,  0.2039D+03   &
         /
       data (TREF( 8,10, mtmp), mtmp=1,12)   &
         /   &
         0.2040D+03,  0.2041D+03,  0.2042D+03,  0.2043D+03,   &
         0.2047D+03,  0.2055D+03,  0.2059D+03,  0.2061D+03,   &
         0.2058D+03,  0.2050D+03,  0.2042D+03,  0.2039D+03   &
         /
       data (TREF( 8,11, mtmp), mtmp=1,12)   &
         /   &
         0.2049D+03,  0.2050D+03,  0.2050D+03,  0.2052D+03,   &
         0.2054D+03,  0.2059D+03,  0.2064D+03,  0.2064D+03,   &
         0.2061D+03,  0.2053D+03,  0.2047D+03,  0.2046D+03   &
         /
       data (TREF( 8,12, mtmp), mtmp=1,12)   &
         /   &
         0.2084D+03,  0.2085D+03,  0.2083D+03,  0.2083D+03,   &
         0.2081D+03,  0.2081D+03,  0.2084D+03,  0.2085D+03,   &
         0.2079D+03,  0.2074D+03,  0.2071D+03,  0.2077D+03   &
         /
       data (TREF( 8,13, mtmp), mtmp=1,12)   &
         /   &
         0.2139D+03,  0.2143D+03,  0.2136D+03,  0.2129D+03,   &
         0.2128D+03,  0.2126D+03,  0.2125D+03,  0.2123D+03,   &
         0.2117D+03,  0.2115D+03,  0.2116D+03,  0.2127D+03   &
         /
       data (TREF( 8,14, mtmp), mtmp=1,12)   &
         /   &
         0.2172D+03,  0.2180D+03,  0.2176D+03,  0.2170D+03,   &
         0.2176D+03,  0.2181D+03,  0.2179D+03,  0.2172D+03,   &
         0.2164D+03,  0.2157D+03,  0.2157D+03,  0.2163D+03   &
         /
       data (TREF( 8,15, mtmp), mtmp=1,12)   &
         /   &
         0.2163D+03,  0.2176D+03,  0.2191D+03,  0.2198D+03,   &
         0.2212D+03,  0.2222D+03,  0.2225D+03,  0.2215D+03,   &
         0.2201D+03,  0.2185D+03,  0.2172D+03,  0.2165D+03   &
         /
       data (TREF( 8,16, mtmp), mtmp=1,12)   &
         /   &
         0.2131D+03,  0.2153D+03,  0.2194D+03,  0.2224D+03,   &
         0.2243D+03,  0.2254D+03,  0.2259D+03,  0.2247D+03,   &
         0.2224D+03,  0.2198D+03,  0.2168D+03,  0.2144D+03   &
         /
       data (TREF( 8,17, mtmp), mtmp=1,12)   &
         /   &
         0.2102D+03,  0.2129D+03,  0.2192D+03,  0.2247D+03,   &
         0.2272D+03,  0.2288D+03,  0.2292D+03,  0.2276D+03,   &
         0.2243D+03,  0.2202D+03,  0.2159D+03,  0.2117D+03   &
         /
       data (TREF( 8,18, mtmp), mtmp=1,12)   &
         /   &
         0.2082D+03,  0.2108D+03,  0.2183D+03,  0.2250D+03,   &
         0.2283D+03,  0.2307D+03,  0.2310D+03,  0.2292D+03,   &
         0.2251D+03,  0.2200D+03,  0.2148D+03,  0.2096D+03   &
         /
       data (TREF( 9, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2334D+03,  0.2315D+03,  0.2254D+03,  0.2165D+03,   &
         0.2072D+03,  0.2002D+03,  0.1943D+03,  0.1924D+03,   &
         0.1941D+03,  0.2020D+03,  0.2184D+03,  0.2332D+03   &
         /
       data (TREF( 9, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2319D+03,  0.2301D+03,  0.2254D+03,  0.2180D+03,   &
         0.2093D+03,  0.2024D+03,  0.1967D+03,  0.1946D+03,   &
         0.1969D+03,  0.2059D+03,  0.2204D+03,  0.2314D+03   &
         /
       data (TREF( 9, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2298D+03,  0.2282D+03,  0.2248D+03,  0.2199D+03,   &
         0.2138D+03,  0.2080D+03,  0.2035D+03,  0.2019D+03,   &
         0.2050D+03,  0.2138D+03,  0.2234D+03,  0.2293D+03   &
         /
       data (TREF( 9, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2252D+03,  0.2239D+03,  0.2217D+03,  0.2194D+03,   &
         0.2171D+03,  0.2138D+03,  0.2115D+03,  0.2114D+03,   &
         0.2142D+03,  0.2196D+03,  0.2230D+03,  0.2249D+03   &
         /
       data (TREF( 9, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2177D+03,  0.2167D+03,  0.2161D+03,  0.2159D+03,   &
         0.2163D+03,  0.2156D+03,  0.2153D+03,  0.2163D+03,   &
         0.2177D+03,  0.2192D+03,  0.2186D+03,  0.2181D+03   &
         /
       data (TREF( 9, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2095D+03,  0.2090D+03,  0.2094D+03,  0.2105D+03,   &
         0.2117D+03,  0.2124D+03,  0.2130D+03,  0.2139D+03,   &
         0.2144D+03,  0.2139D+03,  0.2121D+03,  0.2106D+03   &
         /
       data (TREF( 9, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2027D+03,  0.2024D+03,  0.2031D+03,  0.2042D+03,   &
         0.2052D+03,  0.2061D+03,  0.2070D+03,  0.2076D+03,   &
         0.2076D+03,  0.2067D+03,  0.2051D+03,  0.2038D+03   &
         /
       data (TREF( 9, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1985D+03,  0.1985D+03,  0.1988D+03,  0.1993D+03,   &
         0.2001D+03,  0.2011D+03,  0.2021D+03,  0.2026D+03,   &
         0.2024D+03,  0.2013D+03,  0.1999D+03,  0.1990D+03   &
         /
       data (TREF( 9, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1971D+03,  0.1972D+03,  0.1973D+03,  0.1975D+03,   &
         0.1982D+03,  0.1995D+03,  0.2006D+03,  0.2011D+03,   &
         0.2008D+03,  0.1995D+03,  0.1981D+03,  0.1972D+03   &
         /
       data (TREF( 9,10, mtmp), mtmp=1,12)   &
         /   &
         0.1971D+03,  0.1972D+03,  0.1973D+03,  0.1975D+03,   &
         0.1982D+03,  0.1994D+03,  0.2006D+03,  0.2010D+03,   &
         0.2007D+03,  0.1994D+03,  0.1981D+03,  0.1972D+03   &
         /
       data (TREF( 9,11, mtmp), mtmp=1,12)   &
         /   &
         0.1984D+03,  0.1984D+03,  0.1985D+03,  0.1989D+03,   &
         0.1994D+03,  0.2003D+03,  0.2013D+03,  0.2015D+03,   &
         0.2012D+03,  0.2001D+03,  0.1990D+03,  0.1985D+03   &
         /
       data (TREF( 9,12, mtmp), mtmp=1,12)   &
         /   &
         0.2035D+03,  0.2035D+03,  0.2034D+03,  0.2037D+03,   &
         0.2037D+03,  0.2034D+03,  0.2039D+03,  0.2041D+03,   &
         0.2038D+03,  0.2033D+03,  0.2027D+03,  0.2030D+03   &
         /
       data (TREF( 9,13, mtmp), mtmp=1,12)   &
         /   &
         0.2114D+03,  0.2117D+03,  0.2112D+03,  0.2107D+03,   &
         0.2105D+03,  0.2096D+03,  0.2091D+03,  0.2091D+03,   &
         0.2089D+03,  0.2089D+03,  0.2091D+03,  0.2101D+03   &
         /
       data (TREF( 9,14, mtmp), mtmp=1,12)   &
         /   &
         0.2164D+03,  0.2172D+03,  0.2169D+03,  0.2162D+03,   &
         0.2167D+03,  0.2167D+03,  0.2160D+03,  0.2155D+03,   &
         0.2150D+03,  0.2144D+03,  0.2145D+03,  0.2151D+03   &
         /
       data (TREF( 9,15, mtmp), mtmp=1,12)   &
         /   &
         0.2158D+03,  0.2175D+03,  0.2190D+03,  0.2194D+03,   &
         0.2208D+03,  0.2218D+03,  0.2219D+03,  0.2210D+03,   &
         0.2196D+03,  0.2178D+03,  0.2164D+03,  0.2156D+03   &
         /
       data (TREF( 9,16, mtmp), mtmp=1,12)   &
         /   &
         0.2120D+03,  0.2149D+03,  0.2194D+03,  0.2221D+03,   &
         0.2240D+03,  0.2253D+03,  0.2259D+03,  0.2247D+03,   &
         0.2222D+03,  0.2190D+03,  0.2157D+03,  0.2129D+03   &
         /
       data (TREF( 9,17, mtmp), mtmp=1,12)   &
         /   &
         0.2083D+03,  0.2120D+03,  0.2192D+03,  0.2246D+03,   &
         0.2270D+03,  0.2288D+03,  0.2293D+03,  0.2278D+03,   &
         0.2240D+03,  0.2191D+03,  0.2143D+03,  0.2096D+03   &
         /
       data (TREF( 9,18, mtmp), mtmp=1,12)   &
         /   &
         0.2059D+03,  0.2095D+03,  0.2183D+03,  0.2252D+03,   &
         0.2281D+03,  0.2306D+03,  0.2310D+03,  0.2292D+03,   &
         0.2245D+03,  0.2185D+03,  0.2128D+03,  0.2070D+03   &
         /
       data (TREF(10, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2340D+03,  0.2311D+03,  0.2242D+03,  0.2141D+03,   &
         0.2030D+03,  0.1959D+03,  0.1901D+03,  0.1885D+03,   &
         0.1917D+03,  0.2022D+03,  0.2223D+03,  0.2353D+03   &
         /
       data (TREF(10, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2326D+03,  0.2299D+03,  0.2243D+03,  0.2160D+03,   &
         0.2058D+03,  0.1986D+03,  0.1930D+03,  0.1912D+03,   &
         0.1949D+03,  0.2064D+03,  0.2234D+03,  0.2332D+03   &
         /
       data (TREF(10, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2302D+03,  0.2280D+03,  0.2239D+03,  0.2185D+03,   &
         0.2116D+03,  0.2054D+03,  0.2007D+03,  0.1996D+03,   &
         0.2039D+03,  0.2145D+03,  0.2251D+03,  0.2303D+03   &
         /
       data (TREF(10, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2256D+03,  0.2240D+03,  0.2215D+03,  0.2189D+03,   &
         0.2162D+03,  0.2125D+03,  0.2101D+03,  0.2104D+03,   &
         0.2141D+03,  0.2202D+03,  0.2238D+03,  0.2255D+03   &
         /
       data (TREF(10, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2183D+03,  0.2173D+03,  0.2165D+03,  0.2161D+03,   &
         0.2162D+03,  0.2153D+03,  0.2148D+03,  0.2161D+03,   &
         0.2180D+03,  0.2197D+03,  0.2190D+03,  0.2187D+03   &
         /
       data (TREF(10, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2101D+03,  0.2095D+03,  0.2100D+03,  0.2109D+03,   &
         0.2121D+03,  0.2126D+03,  0.2131D+03,  0.2142D+03,   &
         0.2149D+03,  0.2145D+03,  0.2125D+03,  0.2111D+03   &
         /
       data (TREF(10, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2033D+03,  0.2030D+03,  0.2036D+03,  0.2047D+03,   &
         0.2060D+03,  0.2069D+03,  0.2079D+03,  0.2086D+03,   &
         0.2087D+03,  0.2077D+03,  0.2060D+03,  0.2045D+03   &
         /
       data (TREF(10, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1992D+03,  0.1990D+03,  0.1994D+03,  0.2000D+03,   &
         0.2011D+03,  0.2024D+03,  0.2038D+03,  0.2043D+03,   &
         0.2041D+03,  0.2028D+03,  0.2013D+03,  0.2000D+03   &
         /
       data (TREF(10, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1978D+03,  0.1981D+03,  0.1984D+03,   &
         0.1993D+03,  0.2009D+03,  0.2025D+03,  0.2030D+03,   &
         0.2027D+03,  0.2011D+03,  0.1997D+03,  0.1983D+03   &
         /
       data (TREF(10,10, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1979D+03,  0.1981D+03,  0.1985D+03,   &
         0.1994D+03,  0.2010D+03,  0.2026D+03,  0.2030D+03,   &
         0.2027D+03,  0.2012D+03,  0.1997D+03,  0.1983D+03   &
         /
       data (TREF(10,11, mtmp), mtmp=1,12)   &
         /   &
         0.1991D+03,  0.1988D+03,  0.1990D+03,  0.1997D+03,   &
         0.2007D+03,  0.2019D+03,  0.2032D+03,  0.2036D+03,   &
         0.2032D+03,  0.2019D+03,  0.2005D+03,  0.1994D+03   &
         /
       data (TREF(10,12, mtmp), mtmp=1,12)   &
         /   &
         0.2034D+03,  0.2032D+03,  0.2032D+03,  0.2038D+03,   &
         0.2045D+03,  0.2046D+03,  0.2052D+03,  0.2056D+03,   &
         0.2053D+03,  0.2045D+03,  0.2036D+03,  0.2032D+03   &
         /
       data (TREF(10,13, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2109D+03,  0.2104D+03,  0.2102D+03,   &
         0.2105D+03,  0.2099D+03,  0.2097D+03,  0.2098D+03,   &
         0.2096D+03,  0.2092D+03,  0.2090D+03,  0.2094D+03   &
         /
       data (TREF(10,14, mtmp), mtmp=1,12)   &
         /   &
         0.2157D+03,  0.2164D+03,  0.2161D+03,  0.2155D+03,   &
         0.2161D+03,  0.2164D+03,  0.2160D+03,  0.2156D+03,   &
         0.2149D+03,  0.2139D+03,  0.2137D+03,  0.2140D+03   &
         /
       data (TREF(10,15, mtmp), mtmp=1,12)   &
         /   &
         0.2150D+03,  0.2169D+03,  0.2185D+03,  0.2188D+03,   &
         0.2202D+03,  0.2214D+03,  0.2216D+03,  0.2208D+03,   &
         0.2191D+03,  0.2169D+03,  0.2152D+03,  0.2142D+03   &
         /
       data (TREF(10,16, mtmp), mtmp=1,12)   &
         /   &
         0.2107D+03,  0.2143D+03,  0.2191D+03,  0.2216D+03,   &
         0.2236D+03,  0.2253D+03,  0.2259D+03,  0.2246D+03,   &
         0.2216D+03,  0.2178D+03,  0.2141D+03,  0.2109D+03   &
         /
       data (TREF(10,17, mtmp), mtmp=1,12)   &
         /   &
         0.2063D+03,  0.2110D+03,  0.2189D+03,  0.2242D+03,   &
         0.2266D+03,  0.2288D+03,  0.2294D+03,  0.2276D+03,   &
         0.2231D+03,  0.2175D+03,  0.2121D+03,  0.2070D+03   &
         /
       data (TREF(10,18, mtmp), mtmp=1,12)   &
         /   &
         0.2033D+03,  0.2080D+03,  0.2178D+03,  0.2249D+03,   &
         0.2276D+03,  0.2303D+03,  0.2306D+03,  0.2286D+03,   &
         0.2231D+03,  0.2162D+03,  0.2098D+03,  0.2037D+03   &
         /
       data (TREF(11, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2344D+03,  0.2308D+03,  0.2230D+03,  0.2119D+03,   &
         0.1997D+03,  0.1926D+03,  0.1871D+03,  0.1861D+03,   &
         0.1907D+03,  0.2041D+03,  0.2265D+03,  0.2366D+03   &
         /
       data (TREF(11, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2332D+03,  0.2299D+03,  0.2233D+03,  0.2140D+03,   &
         0.2029D+03,  0.1956D+03,  0.1901D+03,  0.1891D+03,   &
         0.1942D+03,  0.2082D+03,  0.2267D+03,  0.2345D+03   &
         /
       data (TREF(11, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2307D+03,  0.2281D+03,  0.2233D+03,  0.2172D+03,   &
         0.2095D+03,  0.2030D+03,  0.1984D+03,  0.1981D+03,   &
         0.2038D+03,  0.2158D+03,  0.2270D+03,  0.2313D+03   &
         /
       data (TREF(11, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2265D+03,  0.2246D+03,  0.2218D+03,  0.2186D+03,   &
         0.2152D+03,  0.2110D+03,  0.2087D+03,  0.2097D+03,   &
         0.2144D+03,  0.2211D+03,  0.2248D+03,  0.2266D+03   &
         /
       data (TREF(11, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2201D+03,  0.2190D+03,  0.2180D+03,  0.2170D+03,   &
         0.2164D+03,  0.2151D+03,  0.2146D+03,  0.2162D+03,   &
         0.2187D+03,  0.2206D+03,  0.2201D+03,  0.2203D+03   &
         /
       data (TREF(11, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2129D+03,  0.2124D+03,  0.2127D+03,  0.2131D+03,   &
         0.2138D+03,  0.2141D+03,  0.2145D+03,  0.2156D+03,   &
         0.2165D+03,  0.2162D+03,  0.2145D+03,  0.2136D+03   &
         /
       data (TREF(11, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2073D+03,  0.2069D+03,  0.2075D+03,  0.2083D+03,   &
         0.2094D+03,  0.2103D+03,  0.2111D+03,  0.2117D+03,   &
         0.2119D+03,  0.2109D+03,  0.2094D+03,  0.2082D+03   &
         /
       data (TREF(11, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2039D+03,  0.2035D+03,  0.2040D+03,  0.2047D+03,   &
         0.2058D+03,  0.2071D+03,  0.2083D+03,  0.2087D+03,   &
         0.2085D+03,  0.2073D+03,  0.2060D+03,  0.2047D+03   &
         /
       data (TREF(11, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2030D+03,  0.2026D+03,  0.2030D+03,  0.2036D+03,   &
         0.2047D+03,  0.2061D+03,  0.2075D+03,  0.2079D+03,   &
         0.2075D+03,  0.2062D+03,  0.2050D+03,  0.2036D+03   &
         /
       data (TREF(11,10, mtmp), mtmp=1,12)   &
         /   &
         0.2035D+03,  0.2031D+03,  0.2034D+03,  0.2041D+03,   &
         0.2052D+03,  0.2067D+03,  0.2079D+03,  0.2083D+03,   &
         0.2079D+03,  0.2066D+03,  0.2054D+03,  0.2039D+03   &
         /
       data (TREF(11,11, mtmp), mtmp=1,12)   &
         /   &
         0.2042D+03,  0.2038D+03,  0.2041D+03,  0.2051D+03,   &
         0.2063D+03,  0.2075D+03,  0.2086D+03,  0.2089D+03,   &
         0.2085D+03,  0.2073D+03,  0.2061D+03,  0.2046D+03   &
         /
       data (TREF(11,12, mtmp), mtmp=1,12)   &
         /   &
         0.2069D+03,  0.2065D+03,  0.2067D+03,  0.2076D+03,   &
         0.2087D+03,  0.2092D+03,  0.2098D+03,  0.2101D+03,   &
         0.2097D+03,  0.2088D+03,  0.2077D+03,  0.2068D+03   &
         /
       data (TREF(11,13, mtmp), mtmp=1,12)   &
         /   &
         0.2119D+03,  0.2119D+03,  0.2115D+03,  0.2117D+03,   &
         0.2126D+03,  0.2127D+03,  0.2128D+03,  0.2129D+03,   &
         0.2125D+03,  0.2115D+03,  0.2108D+03,  0.2106D+03   &
         /
       data (TREF(11,14, mtmp), mtmp=1,12)   &
         /   &
         0.2155D+03,  0.2162D+03,  0.2159D+03,  0.2156D+03,   &
         0.2166D+03,  0.2174D+03,  0.2174D+03,  0.2171D+03,   &
         0.2160D+03,  0.2144D+03,  0.2136D+03,  0.2136D+03   &
         /
       data (TREF(11,15, mtmp), mtmp=1,12)   &
         /   &
         0.2144D+03,  0.2166D+03,  0.2181D+03,  0.2185D+03,   &
         0.2201D+03,  0.2217D+03,  0.2221D+03,  0.2212D+03,   &
         0.2190D+03,  0.2163D+03,  0.2142D+03,  0.2130D+03   &
         /
       data (TREF(11,16, mtmp), mtmp=1,12)   &
         /   &
         0.2097D+03,  0.2140D+03,  0.2190D+03,  0.2213D+03,   &
         0.2234D+03,  0.2256D+03,  0.2262D+03,  0.2247D+03,   &
         0.2210D+03,  0.2166D+03,  0.2125D+03,  0.2092D+03   &
         /
       data (TREF(11,17, mtmp), mtmp=1,12)   &
         /   &
         0.2048D+03,  0.2107D+03,  0.2190D+03,  0.2240D+03,   &
         0.2266D+03,  0.2292D+03,  0.2297D+03,  0.2276D+03,   &
         0.2223D+03,  0.2157D+03,  0.2100D+03,  0.2047D+03   &
         /
       data (TREF(11,18, mtmp), mtmp=1,12)   &
         /   &
         0.2016D+03,  0.2076D+03,  0.2180D+03,  0.2248D+03,   &
         0.2275D+03,  0.2306D+03,  0.2308D+03,  0.2284D+03,   &
         0.2221D+03,  0.2141D+03,  0.2073D+03,  0.2012D+03   &
         /
       data (TREF(12, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2350D+03,  0.2309D+03,  0.2225D+03,  0.2105D+03,   &
         0.1980D+03,  0.1911D+03,  0.1860D+03,  0.1859D+03,   &
         0.1917D+03,  0.2078D+03,  0.2308D+03,  0.2377D+03   &
         /
       data (TREF(12, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2340D+03,  0.2302D+03,  0.2229D+03,  0.2128D+03,   &
         0.2012D+03,  0.1940D+03,  0.1889D+03,  0.1889D+03,   &
         0.1952D+03,  0.2115D+03,  0.2304D+03,  0.2358D+03   &
         /
       data (TREF(12, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2316D+03,  0.2287D+03,  0.2232D+03,  0.2163D+03,   &
         0.2080D+03,  0.2014D+03,  0.1970D+03,  0.1978D+03,   &
         0.2048D+03,  0.2181D+03,  0.2291D+03,  0.2326D+03   &
         /
       data (TREF(12, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2279D+03,  0.2259D+03,  0.2225D+03,  0.2185D+03,   &
         0.2143D+03,  0.2098D+03,  0.2075D+03,  0.2095D+03,   &
         0.2153D+03,  0.2224D+03,  0.2261D+03,  0.2281D+03   &
         /
       data (TREF(12, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2225D+03,  0.2214D+03,  0.2199D+03,  0.2182D+03,   &
         0.2167D+03,  0.2150D+03,  0.2146D+03,  0.2167D+03,   &
         0.2198D+03,  0.2218D+03,  0.2216D+03,  0.2224D+03   &
         /
       data (TREF(12, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2166D+03,  0.2162D+03,  0.2161D+03,  0.2159D+03,   &
         0.2160D+03,  0.2159D+03,  0.2162D+03,  0.2175D+03,   &
         0.2185D+03,  0.2183D+03,  0.2170D+03,  0.2168D+03   &
         /
       data (TREF(12, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2120D+03,  0.2118D+03,  0.2122D+03,  0.2128D+03,   &
         0.2136D+03,  0.2141D+03,  0.2146D+03,  0.2151D+03,   &
         0.2153D+03,  0.2145D+03,  0.2135D+03,  0.2127D+03   &
         /
       data (TREF(12, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2092D+03,  0.2088D+03,  0.2094D+03,  0.2103D+03,   &
         0.2113D+03,  0.2121D+03,  0.2128D+03,  0.2130D+03,   &
         0.2128D+03,  0.2120D+03,  0.2112D+03,  0.2101D+03   &
         /
       data (TREF(12, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2086D+03,  0.2081D+03,  0.2087D+03,  0.2095D+03,   &
         0.2106D+03,  0.2116D+03,  0.2124D+03,  0.2125D+03,   &
         0.2123D+03,  0.2113D+03,  0.2106D+03,  0.2093D+03   &
         /
       data (TREF(12,10, mtmp), mtmp=1,12)   &
         /   &
         0.2093D+03,  0.2088D+03,  0.2093D+03,  0.2104D+03,   &
         0.2115D+03,  0.2125D+03,  0.2132D+03,  0.2133D+03,   &
         0.2130D+03,  0.2121D+03,  0.2113D+03,  0.2098D+03   &
         /
       data (TREF(12,11, mtmp), mtmp=1,12)   &
         /   &
         0.2099D+03,  0.2095D+03,  0.2100D+03,  0.2113D+03,   &
         0.2125D+03,  0.2133D+03,  0.2139D+03,  0.2139D+03,   &
         0.2136D+03,  0.2127D+03,  0.2118D+03,  0.2104D+03   &
         /
       data (TREF(12,12, mtmp), mtmp=1,12)   &
         /   &
         0.2111D+03,  0.2108D+03,  0.2112D+03,  0.2124D+03,   &
         0.2138D+03,  0.2143D+03,  0.2146D+03,  0.2147D+03,   &
         0.2143D+03,  0.2134D+03,  0.2123D+03,  0.2112D+03   &
         /
       data (TREF(12,13, mtmp), mtmp=1,12)   &
         /   &
         0.2140D+03,  0.2139D+03,  0.2137D+03,  0.2144D+03,   &
         0.2157D+03,  0.2164D+03,  0.2166D+03,  0.2166D+03,   &
         0.2159D+03,  0.2144D+03,  0.2134D+03,  0.2129D+03   &
         /
       data (TREF(12,14, mtmp), mtmp=1,12)   &
         /   &
         0.2159D+03,  0.2166D+03,  0.2164D+03,  0.2164D+03,   &
         0.2180D+03,  0.2194D+03,  0.2198D+03,  0.2193D+03,   &
         0.2178D+03,  0.2155D+03,  0.2142D+03,  0.2139D+03   &
         /
       data (TREF(12,15, mtmp), mtmp=1,12)   &
         /   &
         0.2141D+03,  0.2166D+03,  0.2181D+03,  0.2185D+03,   &
         0.2205D+03,  0.2227D+03,  0.2233D+03,  0.2221D+03,   &
         0.2194D+03,  0.2161D+03,  0.2135D+03,  0.2122D+03   &
         /
       data (TREF(12,16, mtmp), mtmp=1,12)   &
         /   &
         0.2092D+03,  0.2142D+03,  0.2191D+03,  0.2211D+03,   &
         0.2236D+03,  0.2263D+03,  0.2269D+03,  0.2250D+03,   &
         0.2207D+03,  0.2156D+03,  0.2111D+03,  0.2078D+03   &
         /
       data (TREF(12,17, mtmp), mtmp=1,12)   &
         /   &
         0.2043D+03,  0.2112D+03,  0.2195D+03,  0.2239D+03,   &
         0.2268D+03,  0.2299D+03,  0.2303D+03,  0.2278D+03,   &
         0.2217D+03,  0.2142D+03,  0.2082D+03,  0.2032D+03   &
         /
       data (TREF(12,18, mtmp), mtmp=1,12)   &
         /   &
         0.2011D+03,  0.2084D+03,  0.2189D+03,  0.2250D+03,   &
         0.2280D+03,  0.2314D+03,  0.2316D+03,  0.2287D+03,   &
         0.2217D+03,  0.2125D+03,  0.2056D+03,  0.1997D+03   &
         /
       data (TREF(13, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2363D+03,  0.2318D+03,  0.2226D+03,  0.2100D+03,   &
         0.1978D+03,  0.1913D+03,  0.1868D+03,  0.1877D+03,   &
         0.1946D+03,  0.2131D+03,  0.2352D+03,  0.2392D+03   &
         /
       data (TREF(13, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2354D+03,  0.2312D+03,  0.2232D+03,  0.2122D+03,   &
         0.2007D+03,  0.1938D+03,  0.1893D+03,  0.1905D+03,   &
         0.1982D+03,  0.2160D+03,  0.2342D+03,  0.2376D+03   &
         /
       data (TREF(13, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2332D+03,  0.2299D+03,  0.2238D+03,  0.2159D+03,   &
         0.2070D+03,  0.2006D+03,  0.1967D+03,  0.1988D+03,   &
         0.2071D+03,  0.2211D+03,  0.2317D+03,  0.2344D+03   &
         /
       data (TREF(13, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2298D+03,  0.2277D+03,  0.2236D+03,  0.2187D+03,   &
         0.2135D+03,  0.2088D+03,  0.2068D+03,  0.2098D+03,   &
         0.2167D+03,  0.2241D+03,  0.2278D+03,  0.2301D+03   &
         /
       data (TREF(13, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2253D+03,  0.2242D+03,  0.2221D+03,  0.2195D+03,   &
         0.2171D+03,  0.2150D+03,  0.2148D+03,  0.2175D+03,   &
         0.2211D+03,  0.2233D+03,  0.2236D+03,  0.2251D+03   &
         /
       data (TREF(13, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2204D+03,  0.2200D+03,  0.2196D+03,  0.2187D+03,   &
         0.2181D+03,  0.2177D+03,  0.2181D+03,  0.2195D+03,   &
         0.2206D+03,  0.2205D+03,  0.2199D+03,  0.2203D+03   &
         /
       data (TREF(13, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2165D+03,  0.2164D+03,  0.2168D+03,  0.2171D+03,   &
         0.2175D+03,  0.2176D+03,  0.2179D+03,  0.2183D+03,   &
         0.2184D+03,  0.2180D+03,  0.2174D+03,  0.2170D+03   &
         /
       data (TREF(13, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2140D+03,  0.2137D+03,  0.2145D+03,  0.2155D+03,   &
         0.2163D+03,  0.2166D+03,  0.2168D+03,  0.2168D+03,   &
         0.2167D+03,  0.2163D+03,  0.2159D+03,  0.2149D+03   &
         /
       data (TREF(13, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2134D+03,  0.2129D+03,  0.2138D+03,  0.2150D+03,   &
         0.2160D+03,  0.2164D+03,  0.2166D+03,  0.2165D+03,   &
         0.2164D+03,  0.2159D+03,  0.2155D+03,  0.2142D+03   &
         /
       data (TREF(13,10, mtmp), mtmp=1,12)   &
         /   &
         0.2141D+03,  0.2136D+03,  0.2145D+03,  0.2159D+03,   &
         0.2168D+03,  0.2173D+03,  0.2175D+03,  0.2173D+03,   &
         0.2171D+03,  0.2166D+03,  0.2162D+03,  0.2148D+03   &
         /
       data (TREF(13,11, mtmp), mtmp=1,12)   &
         /   &
         0.2145D+03,  0.2142D+03,  0.2151D+03,  0.2166D+03,   &
         0.2177D+03,  0.2181D+03,  0.2182D+03,  0.2179D+03,   &
         0.2177D+03,  0.2171D+03,  0.2165D+03,  0.2151D+03   &
         /
       data (TREF(13,12, mtmp), mtmp=1,12)   &
         /   &
         0.2149D+03,  0.2147D+03,  0.2154D+03,  0.2170D+03,   &
         0.2184D+03,  0.2188D+03,  0.2188D+03,  0.2185D+03,   &
         0.2182D+03,  0.2173D+03,  0.2164D+03,  0.2151D+03   &
         /
       data (TREF(13,13, mtmp), mtmp=1,12)   &
         /   &
         0.2163D+03,  0.2162D+03,  0.2162D+03,  0.2174D+03,   &
         0.2192D+03,  0.2201D+03,  0.2203D+03,  0.2200D+03,   &
         0.2191D+03,  0.2173D+03,  0.2161D+03,  0.2153D+03   &
         /
       data (TREF(13,14, mtmp), mtmp=1,12)   &
         /   &
         0.2169D+03,  0.2176D+03,  0.2174D+03,  0.2179D+03,   &
         0.2200D+03,  0.2219D+03,  0.2225D+03,  0.2218D+03,   &
         0.2198D+03,  0.2170D+03,  0.2152D+03,  0.2147D+03   &
         /
       data (TREF(13,15, mtmp), mtmp=1,12)   &
         /   &
         0.2145D+03,  0.2171D+03,  0.2185D+03,  0.2191D+03,   &
         0.2217D+03,  0.2243D+03,  0.2251D+03,  0.2237D+03,   &
         0.2204D+03,  0.2164D+03,  0.2132D+03,  0.2119D+03   &
         /
       data (TREF(13,16, mtmp), mtmp=1,12)   &
         /   &
         0.2096D+03,  0.2149D+03,  0.2195D+03,  0.2214D+03,   &
         0.2244D+03,  0.2276D+03,  0.2283D+03,  0.2260D+03,   &
         0.2209D+03,  0.2151D+03,  0.2101D+03,  0.2071D+03   &
         /
       data (TREF(13,17, mtmp), mtmp=1,12)   &
         /   &
         0.2047D+03,  0.2123D+03,  0.2203D+03,  0.2241D+03,   &
         0.2275D+03,  0.2310D+03,  0.2314D+03,  0.2285D+03,   &
         0.2216D+03,  0.2132D+03,  0.2070D+03,  0.2024D+03   &
         /
       data (TREF(13,18, mtmp), mtmp=1,12)   &
         /   &
         0.2016D+03,  0.2098D+03,  0.2201D+03,  0.2254D+03,   &
         0.2289D+03,  0.2326D+03,  0.2328D+03,  0.2295D+03,   &
         0.2216D+03,  0.2113D+03,  0.2046D+03,  0.1992D+03   &
         /
       data (TREF(14, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2387D+03,  0.2335D+03,  0.2236D+03,  0.2102D+03,   &
         0.1986D+03,  0.1927D+03,  0.1893D+03,  0.1912D+03,   &
         0.1995D+03,  0.2197D+03,  0.2399D+03,  0.2416D+03   &
         /
       data (TREF(14, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2377D+03,  0.2330D+03,  0.2241D+03,  0.2123D+03,   &
         0.2010D+03,  0.1948D+03,  0.1913D+03,  0.1939D+03,   &
         0.2030D+03,  0.2218D+03,  0.2383D+03,  0.2401D+03   &
         /
       data (TREF(14, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2355D+03,  0.2318D+03,  0.2249D+03,  0.2160D+03,   &
         0.2066D+03,  0.2005D+03,  0.1975D+03,  0.2011D+03,   &
         0.2107D+03,  0.2250D+03,  0.2347D+03,  0.2369D+03   &
         /
       data (TREF(14, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2324D+03,  0.2299D+03,  0.2252D+03,  0.2192D+03,   &
         0.2130D+03,  0.2081D+03,  0.2067D+03,  0.2109D+03,   &
         0.2187D+03,  0.2262D+03,  0.2301D+03,  0.2327D+03   &
         /
       data (TREF(14, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2284D+03,  0.2272D+03,  0.2245D+03,  0.2210D+03,   &
         0.2176D+03,  0.2150D+03,  0.2152D+03,  0.2185D+03,   &
         0.2226D+03,  0.2249D+03,  0.2260D+03,  0.2281D+03   &
         /
       data (TREF(14, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2241D+03,  0.2238D+03,  0.2229D+03,  0.2214D+03,   &
         0.2201D+03,  0.2193D+03,  0.2198D+03,  0.2214D+03,   &
         0.2227D+03,  0.2229D+03,  0.2229D+03,  0.2240D+03   &
         /
       data (TREF(14, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2206D+03,  0.2205D+03,  0.2209D+03,  0.2210D+03,   &
         0.2209D+03,  0.2208D+03,  0.2209D+03,  0.2212D+03,   &
         0.2214D+03,  0.2213D+03,  0.2212D+03,  0.2211D+03   &
         /
       data (TREF(14, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2181D+03,  0.2180D+03,  0.2191D+03,  0.2201D+03,   &
         0.2206D+03,  0.2206D+03,  0.2204D+03,  0.2203D+03,   &
         0.2203D+03,  0.2203D+03,  0.2202D+03,  0.2192D+03   &
         /
       data (TREF(14, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2173D+03,  0.2170D+03,  0.2184D+03,  0.2199D+03,   &
         0.2206D+03,  0.2205D+03,  0.2203D+03,  0.2200D+03,   &
         0.2201D+03,  0.2201D+03,  0.2199D+03,  0.2185D+03   &
         /
       data (TREF(14,10, mtmp), mtmp=1,12)   &
         /   &
         0.2178D+03,  0.2176D+03,  0.2189D+03,  0.2205D+03,   &
         0.2213D+03,  0.2213D+03,  0.2210D+03,  0.2207D+03,   &
         0.2207D+03,  0.2206D+03,  0.2204D+03,  0.2187D+03   &
         /
       data (TREF(14,11, mtmp), mtmp=1,12)   &
         /   &
         0.2181D+03,  0.2180D+03,  0.2193D+03,  0.2212D+03,   &
         0.2220D+03,  0.2220D+03,  0.2217D+03,  0.2213D+03,   &
         0.2212D+03,  0.2209D+03,  0.2205D+03,  0.2188D+03   &
         /
       data (TREF(14,12, mtmp), mtmp=1,12)   &
         /   &
         0.2182D+03,  0.2182D+03,  0.2192D+03,  0.2212D+03,   &
         0.2224D+03,  0.2226D+03,  0.2224D+03,  0.2219D+03,   &
         0.2215D+03,  0.2206D+03,  0.2198D+03,  0.2184D+03   &
         /
       data (TREF(14,13, mtmp), mtmp=1,12)   &
         /   &
         0.2187D+03,  0.2188D+03,  0.2190D+03,  0.2207D+03,   &
         0.2226D+03,  0.2237D+03,  0.2237D+03,  0.2231D+03,   &
         0.2220D+03,  0.2200D+03,  0.2186D+03,  0.2177D+03   &
         /
       data (TREF(14,14, mtmp), mtmp=1,12)   &
         /   &
         0.2183D+03,  0.2192D+03,  0.2191D+03,  0.2200D+03,   &
         0.2228D+03,  0.2250D+03,  0.2255D+03,  0.2245D+03,   &
         0.2221D+03,  0.2189D+03,  0.2165D+03,  0.2159D+03   &
         /
       data (TREF(14,15, mtmp), mtmp=1,12)   &
         /   &
         0.2155D+03,  0.2183D+03,  0.2195D+03,  0.2204D+03,   &
         0.2238D+03,  0.2269D+03,  0.2277D+03,  0.2259D+03,   &
         0.2220D+03,  0.2173D+03,  0.2134D+03,  0.2122D+03   &
         /
       data (TREF(14,16, mtmp), mtmp=1,12)   &
         /   &
         0.2107D+03,  0.2163D+03,  0.2205D+03,  0.2223D+03,   &
         0.2261D+03,  0.2298D+03,  0.2306D+03,  0.2278D+03,   &
         0.2220D+03,  0.2152D+03,  0.2098D+03,  0.2072D+03   &
         /
       data (TREF(14,17, mtmp), mtmp=1,12)   &
         /   &
         0.2060D+03,  0.2140D+03,  0.2214D+03,  0.2248D+03,   &
         0.2288D+03,  0.2329D+03,  0.2333D+03,  0.2299D+03,   &
         0.2221D+03,  0.2126D+03,  0.2063D+03,  0.2025D+03   &
         /
       data (TREF(14,18, mtmp), mtmp=1,12)   &
         /   &
         0.2028D+03,  0.2117D+03,  0.2213D+03,  0.2259D+03,   &
         0.2300D+03,  0.2343D+03,  0.2345D+03,  0.2308D+03,   &
         0.2219D+03,  0.2105D+03,  0.2039D+03,  0.1993D+03   &
         /
       data (TREF(15, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2420D+03,  0.2360D+03,  0.2250D+03,  0.2110D+03,   &
         0.2001D+03,  0.1949D+03,  0.1927D+03,  0.1959D+03,   &
         0.2057D+03,  0.2272D+03,  0.2448D+03,  0.2448D+03   &
         /
       data (TREF(15, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2408D+03,  0.2354D+03,  0.2256D+03,  0.2129D+03,   &
         0.2018D+03,  0.1964D+03,  0.1942D+03,  0.1984D+03,   &
         0.2090D+03,  0.2283D+03,  0.2426D+03,  0.2431D+03   &
         /
       data (TREF(15, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2384D+03,  0.2342D+03,  0.2264D+03,  0.2164D+03,   &
         0.2066D+03,  0.2009D+03,  0.1990D+03,  0.2043D+03,   &
         0.2152D+03,  0.2293D+03,  0.2379D+03,  0.2398D+03   &
         /
       data (TREF(15, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2353D+03,  0.2325D+03,  0.2269D+03,  0.2199D+03,   &
         0.2127D+03,  0.2077D+03,  0.2069D+03,  0.2125D+03,   &
         0.2211D+03,  0.2285D+03,  0.2327D+03,  0.2356D+03   &
         /
       data (TREF(15, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2316D+03,  0.2303D+03,  0.2270D+03,  0.2226D+03,   &
         0.2181D+03,  0.2151D+03,  0.2157D+03,  0.2197D+03,   &
         0.2242D+03,  0.2267D+03,  0.2287D+03,  0.2314D+03   &
         /
       data (TREF(15, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2277D+03,  0.2273D+03,  0.2261D+03,  0.2240D+03,   &
         0.2219D+03,  0.2208D+03,  0.2215D+03,  0.2234D+03,   &
         0.2247D+03,  0.2253D+03,  0.2262D+03,  0.2277D+03   &
         /
       data (TREF(15, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2243D+03,  0.2244D+03,  0.2247D+03,  0.2245D+03,   &
         0.2239D+03,  0.2235D+03,  0.2236D+03,  0.2240D+03,   &
         0.2242D+03,  0.2245D+03,  0.2249D+03,  0.2249D+03   &
         /
       data (TREF(15, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2218D+03,  0.2219D+03,  0.2232D+03,  0.2243D+03,   &
         0.2245D+03,  0.2242D+03,  0.2237D+03,  0.2235D+03,   &
         0.2237D+03,  0.2241D+03,  0.2243D+03,  0.2231D+03   &
         /
       data (TREF(15, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2208D+03,  0.2208D+03,  0.2226D+03,  0.2243D+03,   &
         0.2247D+03,  0.2243D+03,  0.2237D+03,  0.2233D+03,   &
         0.2236D+03,  0.2240D+03,  0.2240D+03,  0.2222D+03   &
         /
       data (TREF(15,10, mtmp), mtmp=1,12)   &
         /   &
         0.2210D+03,  0.2210D+03,  0.2228D+03,  0.2247D+03,   &
         0.2252D+03,  0.2248D+03,  0.2243D+03,  0.2238D+03,   &
         0.2240D+03,  0.2243D+03,  0.2241D+03,  0.2222D+03   &
         /
       data (TREF(15,11, mtmp), mtmp=1,12)   &
         /   &
         0.2212D+03,  0.2214D+03,  0.2232D+03,  0.2252D+03,   &
         0.2258D+03,  0.2254D+03,  0.2249D+03,  0.2243D+03,   &
         0.2243D+03,  0.2243D+03,  0.2240D+03,  0.2221D+03   &
         /
       data (TREF(15,12, mtmp), mtmp=1,12)   &
         /   &
         0.2212D+03,  0.2214D+03,  0.2229D+03,  0.2251D+03,   &
         0.2261D+03,  0.2261D+03,  0.2256D+03,  0.2249D+03,   &
         0.2245D+03,  0.2237D+03,  0.2229D+03,  0.2214D+03   &
         /
       data (TREF(15,13, mtmp), mtmp=1,12)   &
         /   &
         0.2212D+03,  0.2213D+03,  0.2220D+03,  0.2240D+03,   &
         0.2261D+03,  0.2271D+03,  0.2269D+03,  0.2260D+03,   &
         0.2246D+03,  0.2225D+03,  0.2210D+03,  0.2200D+03   &
         /
       data (TREF(15,14, mtmp), mtmp=1,12)   &
         /   &
         0.2201D+03,  0.2212D+03,  0.2211D+03,  0.2226D+03,   &
         0.2259D+03,  0.2283D+03,  0.2287D+03,  0.2273D+03,   &
         0.2246D+03,  0.2209D+03,  0.2180D+03,  0.2172D+03   &
         /
       data (TREF(15,15, mtmp), mtmp=1,12)   &
         /   &
         0.2170D+03,  0.2201D+03,  0.2210D+03,  0.2223D+03,   &
         0.2265D+03,  0.2300D+03,  0.2308D+03,  0.2286D+03,   &
         0.2241D+03,  0.2187D+03,  0.2140D+03,  0.2129D+03   &
         /
       data (TREF(15,16, mtmp), mtmp=1,12)   &
         /   &
         0.2124D+03,  0.2182D+03,  0.2218D+03,  0.2238D+03,   &
         0.2284D+03,  0.2326D+03,  0.2334D+03,  0.2302D+03,   &
         0.2235D+03,  0.2158D+03,  0.2098D+03,  0.2078D+03   &
         /
       data (TREF(15,17, mtmp), mtmp=1,12)   &
         /   &
         0.2078D+03,  0.2160D+03,  0.2225D+03,  0.2257D+03,   &
         0.2306D+03,  0.2353D+03,  0.2358D+03,  0.2318D+03,   &
         0.2229D+03,  0.2125D+03,  0.2060D+03,  0.2031D+03   &
         /
       data (TREF(15,18, mtmp), mtmp=1,12)   &
         /   &
         0.2046D+03,  0.2139D+03,  0.2223D+03,  0.2265D+03,   &
         0.2314D+03,  0.2363D+03,  0.2367D+03,  0.2323D+03,   &
         0.2223D+03,  0.2099D+03,  0.2035D+03,  0.1998D+03   &
         /
       data (TREF(16, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2454D+03,  0.2385D+03,  0.2265D+03,  0.2118D+03,   &
         0.2016D+03,  0.1971D+03,  0.1962D+03,  0.2008D+03,   &
         0.2121D+03,  0.2347D+03,  0.2497D+03,  0.2482D+03   &
         /
       data (TREF(16, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2441D+03,  0.2379D+03,  0.2270D+03,  0.2135D+03,   &
         0.2028D+03,  0.1982D+03,  0.1973D+03,  0.2032D+03,   &
         0.2153D+03,  0.2350D+03,  0.2469D+03,  0.2463D+03   &
         /
       data (TREF(16, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2416D+03,  0.2367D+03,  0.2280D+03,  0.2169D+03,   &
         0.2067D+03,  0.2016D+03,  0.2008D+03,  0.2079D+03,   &
         0.2199D+03,  0.2337D+03,  0.2413D+03,  0.2429D+03   &
         /
       data (TREF(16, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2385D+03,  0.2353D+03,  0.2289D+03,  0.2208D+03,   &
         0.2126D+03,  0.2075D+03,  0.2075D+03,  0.2144D+03,   &
         0.2238D+03,  0.2310D+03,  0.2356D+03,  0.2388D+03   &
         /
       data (TREF(16, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2351D+03,  0.2335D+03,  0.2295D+03,  0.2243D+03,   &
         0.2188D+03,  0.2154D+03,  0.2164D+03,  0.2212D+03,   &
         0.2260D+03,  0.2287D+03,  0.2316D+03,  0.2348D+03   &
         /
       data (TREF(16, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2315D+03,  0.2310D+03,  0.2294D+03,  0.2266D+03,   &
         0.2238D+03,  0.2224D+03,  0.2233D+03,  0.2255D+03,   &
         0.2269D+03,  0.2279D+03,  0.2296D+03,  0.2315D+03   &
         /
       data (TREF(16, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2281D+03,  0.2283D+03,  0.2285D+03,  0.2279D+03,   &
         0.2269D+03,  0.2264D+03,  0.2264D+03,  0.2269D+03,   &
         0.2272D+03,  0.2279D+03,  0.2288D+03,  0.2289D+03   &
         /
       data (TREF(16, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2255D+03,  0.2259D+03,  0.2275D+03,  0.2286D+03,   &
         0.2284D+03,  0.2278D+03,  0.2270D+03,  0.2268D+03,   &
         0.2272D+03,  0.2280D+03,  0.2284D+03,  0.2270D+03   &
         /
       data (TREF(16, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2243D+03,  0.2246D+03,  0.2269D+03,  0.2288D+03,   &
         0.2290D+03,  0.2282D+03,  0.2272D+03,  0.2268D+03,   &
         0.2272D+03,  0.2281D+03,  0.2282D+03,  0.2261D+03   &
         /
       data (TREF(16,10, mtmp), mtmp=1,12)   &
         /   &
         0.2242D+03,  0.2245D+03,  0.2268D+03,  0.2290D+03,   &
         0.2292D+03,  0.2285D+03,  0.2276D+03,  0.2271D+03,   &
         0.2274D+03,  0.2282D+03,  0.2281D+03,  0.2257D+03   &
         /
       data (TREF(16,11, mtmp), mtmp=1,12)   &
         /   &
         0.2243D+03,  0.2248D+03,  0.2271D+03,  0.2293D+03,   &
         0.2296D+03,  0.2289D+03,  0.2281D+03,  0.2275D+03,   &
         0.2276D+03,  0.2278D+03,  0.2275D+03,  0.2254D+03   &
         /
       data (TREF(16,12, mtmp), mtmp=1,12)   &
         /   &
         0.2243D+03,  0.2247D+03,  0.2266D+03,  0.2290D+03,   &
         0.2299D+03,  0.2297D+03,  0.2290D+03,  0.2281D+03,   &
         0.2275D+03,  0.2268D+03,  0.2261D+03,  0.2246D+03   &
         /
       data (TREF(16,13, mtmp), mtmp=1,12)   &
         /   &
         0.2238D+03,  0.2241D+03,  0.2251D+03,  0.2275D+03,   &
         0.2297D+03,  0.2306D+03,  0.2303D+03,  0.2290D+03,   &
         0.2274D+03,  0.2252D+03,  0.2234D+03,  0.2224D+03   &
         /
       data (TREF(16,14, mtmp), mtmp=1,12)   &
         /   &
         0.2222D+03,  0.2234D+03,  0.2234D+03,  0.2254D+03,   &
         0.2294D+03,  0.2319D+03,  0.2321D+03,  0.2303D+03,   &
         0.2272D+03,  0.2231D+03,  0.2196D+03,  0.2188D+03   &
         /
       data (TREF(16,15, mtmp), mtmp=1,12)   &
         /   &
         0.2188D+03,  0.2220D+03,  0.2228D+03,  0.2246D+03,   &
         0.2297D+03,  0.2335D+03,  0.2342D+03,  0.2316D+03,   &
         0.2264D+03,  0.2202D+03,  0.2148D+03,  0.2139D+03   &
         /
       data (TREF(16,16, mtmp), mtmp=1,12)   &
         /   &
         0.2144D+03,  0.2202D+03,  0.2233D+03,  0.2255D+03,   &
         0.2311D+03,  0.2358D+03,  0.2366D+03,  0.2329D+03,   &
         0.2253D+03,  0.2166D+03,  0.2100D+03,  0.2087D+03   &
         /
       data (TREF(16,17, mtmp), mtmp=1,12)   &
         /   &
         0.2100D+03,  0.2183D+03,  0.2238D+03,  0.2269D+03,   &
         0.2326D+03,  0.2380D+03,  0.2385D+03,  0.2339D+03,   &
         0.2240D+03,  0.2126D+03,  0.2060D+03,  0.2041D+03   &
         /
       data (TREF(16,18, mtmp), mtmp=1,12)   &
         /   &
         0.2066D+03,  0.2161D+03,  0.2234D+03,  0.2272D+03,   &
         0.2329D+03,  0.2386D+03,  0.2391D+03,  0.2340D+03,   &
         0.2228D+03,  0.2095D+03,  0.2033D+03,  0.2007D+03   &
         /
       data (TREF(17, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2489D+03,  0.2410D+03,  0.2275D+03,  0.2124D+03,   &
         0.2028D+03,  0.1990D+03,  0.1993D+03,  0.2054D+03,   &
         0.2181D+03,  0.2414D+03,  0.2536D+03,  0.2512D+03   &
         /
       data (TREF(17, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2475D+03,  0.2404D+03,  0.2282D+03,  0.2141D+03,   &
         0.2038D+03,  0.1999D+03,  0.2004D+03,  0.2080D+03,   &
         0.2213D+03,  0.2409D+03,  0.2506D+03,  0.2495D+03   &
         /
       data (TREF(17, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2452D+03,  0.2396D+03,  0.2296D+03,  0.2178D+03,   &
         0.2072D+03,  0.2026D+03,  0.2031D+03,  0.2120D+03,   &
         0.2248D+03,  0.2380D+03,  0.2447D+03,  0.2463D+03   &
         /
       data (TREF(17, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2422D+03,  0.2385D+03,  0.2311D+03,  0.2222D+03,   &
         0.2131D+03,  0.2079D+03,  0.2089D+03,  0.2171D+03,   &
         0.2269D+03,  0.2339D+03,  0.2389D+03,  0.2425D+03   &
         /
       data (TREF(17, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2391D+03,  0.2372D+03,  0.2324D+03,  0.2265D+03,   &
         0.2201D+03,  0.2162D+03,  0.2179D+03,  0.2233D+03,   &
         0.2284D+03,  0.2314D+03,  0.2352D+03,  0.2389D+03   &
         /
       data (TREF(17, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2357D+03,  0.2351D+03,  0.2328D+03,  0.2297D+03,   &
         0.2261D+03,  0.2244D+03,  0.2257D+03,  0.2281D+03,   &
         0.2297D+03,  0.2310D+03,  0.2336D+03,  0.2359D+03   &
         /
       data (TREF(17, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2323D+03,  0.2326D+03,  0.2325D+03,  0.2317D+03,   &
         0.2303D+03,  0.2296D+03,  0.2296D+03,  0.2302D+03,   &
         0.2307D+03,  0.2318D+03,  0.2332D+03,  0.2333D+03   &
         /
       data (TREF(17, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2298D+03,  0.2303D+03,  0.2320D+03,  0.2332D+03,   &
         0.2327D+03,  0.2318D+03,  0.2308D+03,  0.2307D+03,   &
         0.2313D+03,  0.2325D+03,  0.2331D+03,  0.2314D+03   &
         /
       data (TREF(17, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2285D+03,  0.2291D+03,  0.2317D+03,  0.2338D+03,   &
         0.2337D+03,  0.2325D+03,  0.2312D+03,  0.2309D+03,   &
         0.2316D+03,  0.2329D+03,  0.2330D+03,  0.2306D+03   &
         /
       data (TREF(17,10, mtmp), mtmp=1,12)   &
         /   &
         0.2282D+03,  0.2288D+03,  0.2316D+03,  0.2339D+03,   &
         0.2338D+03,  0.2327D+03,  0.2315D+03,  0.2311D+03,   &
         0.2317D+03,  0.2327D+03,  0.2326D+03,  0.2300D+03   &
         /
       data (TREF(17,11, mtmp), mtmp=1,12)   &
         /   &
         0.2282D+03,  0.2289D+03,  0.2316D+03,  0.2339D+03,   &
         0.2340D+03,  0.2330D+03,  0.2320D+03,  0.2314D+03,   &
         0.2315D+03,  0.2320D+03,  0.2317D+03,  0.2294D+03   &
         /
       data (TREF(17,12, mtmp), mtmp=1,12)   &
         /   &
         0.2279D+03,  0.2286D+03,  0.2309D+03,  0.2335D+03,   &
         0.2341D+03,  0.2338D+03,  0.2328D+03,  0.2318D+03,   &
         0.2312D+03,  0.2304D+03,  0.2298D+03,  0.2283D+03   &
         /
       data (TREF(17,13, mtmp), mtmp=1,12)   &
         /   &
         0.2269D+03,  0.2275D+03,  0.2288D+03,  0.2316D+03,   &
         0.2339D+03,  0.2348D+03,  0.2342D+03,  0.2326D+03,   &
         0.2307D+03,  0.2283D+03,  0.2264D+03,  0.2255D+03   &
         /
       data (TREF(17,14, mtmp), mtmp=1,12)   &
         /   &
         0.2247D+03,  0.2261D+03,  0.2264D+03,  0.2291D+03,   &
         0.2336D+03,  0.2361D+03,  0.2361D+03,  0.2338D+03,   &
         0.2303D+03,  0.2258D+03,  0.2217D+03,  0.2211D+03   &
         /
       data (TREF(17,15, mtmp), mtmp=1,12)   &
         /   &
         0.2212D+03,  0.2244D+03,  0.2252D+03,  0.2278D+03,   &
         0.2337D+03,  0.2378D+03,  0.2382D+03,  0.2351D+03,   &
         0.2293D+03,  0.2223D+03,  0.2163D+03,  0.2157D+03   &
         /
       data (TREF(17,16, mtmp), mtmp=1,12)   &
         /   &
         0.2170D+03,  0.2227D+03,  0.2253D+03,  0.2280D+03,   &
         0.2346D+03,  0.2398D+03,  0.2405D+03,  0.2362D+03,   &
         0.2277D+03,  0.2180D+03,  0.2110D+03,  0.2105D+03   &
         /
       data (TREF(17,17, mtmp), mtmp=1,12)   &
         /   &
         0.2128D+03,  0.2210D+03,  0.2254D+03,  0.2286D+03,   &
         0.2355D+03,  0.2414D+03,  0.2420D+03,  0.2367D+03,   &
         0.2256D+03,  0.2132D+03,  0.2066D+03,  0.2059D+03   &
         /
       data (TREF(17,18, mtmp), mtmp=1,12)   &
         /   &
         0.2095D+03,  0.2189D+03,  0.2246D+03,  0.2284D+03,   &
         0.2353D+03,  0.2417D+03,  0.2422D+03,  0.2364D+03,   &
         0.2238D+03,  0.2097D+03,  0.2037D+03,  0.2024D+03   &
         /
       data (TREF(18, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2524D+03,  0.2434D+03,  0.2277D+03,  0.2126D+03,   &
         0.2036D+03,  0.2002D+03,  0.2017D+03,  0.2095D+03,   &
         0.2236D+03,  0.2468D+03,  0.2563D+03,  0.2539D+03   &
         /
       data (TREF(18, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2512D+03,  0.2431D+03,  0.2290D+03,  0.2148D+03,   &
         0.2048D+03,  0.2016D+03,  0.2035D+03,  0.2129D+03,   &
         0.2272D+03,  0.2460D+03,  0.2536D+03,  0.2526D+03   &
         /
       data (TREF(18, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2494D+03,  0.2431D+03,  0.2315D+03,  0.2192D+03,   &
         0.2085D+03,  0.2043D+03,  0.2064D+03,  0.2169D+03,   &
         0.2301D+03,  0.2423D+03,  0.2483D+03,  0.2503D+03   &
         /
       data (TREF(18, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2470D+03,  0.2427D+03,  0.2341D+03,  0.2246D+03,   &
         0.2146D+03,  0.2095D+03,  0.2118D+03,  0.2212D+03,   &
         0.2309D+03,  0.2376D+03,  0.2432D+03,  0.2472D+03   &
         /
       data (TREF(18, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2441D+03,  0.2417D+03,  0.2360D+03,  0.2296D+03,   &
         0.2223D+03,  0.2182D+03,  0.2206D+03,  0.2266D+03,   &
         0.2317D+03,  0.2351D+03,  0.2400D+03,  0.2441D+03   &
         /
       data (TREF(18, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2408D+03,  0.2398D+03,  0.2368D+03,  0.2334D+03,   &
         0.2291D+03,  0.2273D+03,  0.2289D+03,  0.2315D+03,   &
         0.2333D+03,  0.2353D+03,  0.2387D+03,  0.2412D+03   &
         /
       data (TREF(18, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2374D+03,  0.2376D+03,  0.2369D+03,  0.2361D+03,   &
         0.2342D+03,  0.2335D+03,  0.2336D+03,  0.2343D+03,   &
         0.2350D+03,  0.2366D+03,  0.2385D+03,  0.2386D+03   &
         /
       data (TREF(18, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2348D+03,  0.2357D+03,  0.2372D+03,  0.2385D+03,   &
         0.2376D+03,  0.2366D+03,  0.2355D+03,  0.2355D+03,   &
         0.2363D+03,  0.2379D+03,  0.2386D+03,  0.2368D+03   &
         /
       data (TREF(18, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2337D+03,  0.2348D+03,  0.2376D+03,  0.2399D+03,   &
         0.2394D+03,  0.2379D+03,  0.2364D+03,  0.2362D+03,   &
         0.2372D+03,  0.2387D+03,  0.2388D+03,  0.2362D+03   &
         /
       data (TREF(18,10, mtmp), mtmp=1,12)   &
         /   &
         0.2334D+03,  0.2345D+03,  0.2376D+03,  0.2400D+03,   &
         0.2396D+03,  0.2382D+03,  0.2366D+03,  0.2364D+03,   &
         0.2373D+03,  0.2386D+03,  0.2384D+03,  0.2356D+03   &
         /
       data (TREF(18,11, mtmp), mtmp=1,12)   &
         /   &
         0.2331D+03,  0.2344D+03,  0.2373D+03,  0.2396D+03,   &
         0.2394D+03,  0.2382D+03,  0.2368D+03,  0.2363D+03,   &
         0.2367D+03,  0.2373D+03,  0.2370D+03,  0.2347D+03   &
         /
       data (TREF(18,12, mtmp), mtmp=1,12)   &
         /   &
         0.2326D+03,  0.2337D+03,  0.2361D+03,  0.2387D+03,   &
         0.2393D+03,  0.2389D+03,  0.2376D+03,  0.2364D+03,   &
         0.2358D+03,  0.2351D+03,  0.2343D+03,  0.2331D+03   &
         /
       data (TREF(18,13, mtmp), mtmp=1,12)   &
         /   &
         0.2310D+03,  0.2319D+03,  0.2336D+03,  0.2368D+03,   &
         0.2392D+03,  0.2401D+03,  0.2390D+03,  0.2370D+03,   &
         0.2350D+03,  0.2324D+03,  0.2301D+03,  0.2296D+03   &
         /
       data (TREF(18,14, mtmp), mtmp=1,12)   &
         /   &
         0.2283D+03,  0.2298D+03,  0.2307D+03,  0.2343D+03,   &
         0.2391D+03,  0.2416D+03,  0.2411D+03,  0.2383D+03,   &
         0.2344D+03,  0.2294D+03,  0.2247D+03,  0.2245D+03   &
         /
       data (TREF(18,15, mtmp), mtmp=1,12)   &
         /   &
         0.2247D+03,  0.2277D+03,  0.2287D+03,  0.2326D+03,   &
         0.2392D+03,  0.2434D+03,  0.2435D+03,  0.2397D+03,   &
         0.2332D+03,  0.2254D+03,  0.2188D+03,  0.2188D+03   &
         /
       data (TREF(18,16, mtmp), mtmp=1,12)   &
         /   &
         0.2209D+03,  0.2259D+03,  0.2281D+03,  0.2319D+03,   &
         0.2395D+03,  0.2452D+03,  0.2456D+03,  0.2406D+03,   &
         0.2310D+03,  0.2202D+03,  0.2132D+03,  0.2138D+03   &
         /
       data (TREF(18,17, mtmp), mtmp=1,12)   &
         /   &
         0.2169D+03,  0.2244D+03,  0.2275D+03,  0.2313D+03,   &
         0.2396D+03,  0.2463D+03,  0.2467D+03,  0.2406D+03,   &
         0.2281D+03,  0.2148D+03,  0.2085D+03,  0.2092D+03   &
         /
       data (TREF(18,18, mtmp), mtmp=1,12)   &
         /   &
         0.2136D+03,  0.2226D+03,  0.2263D+03,  0.2302D+03,   &
         0.2389D+03,  0.2462D+03,  0.2467D+03,  0.2399D+03,   &
         0.2257D+03,  0.2108D+03,  0.2053D+03,  0.2056D+03   &
         /
       data (TREF(19, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2567D+03,  0.2465D+03,  0.2284D+03,  0.2138D+03,   &
         0.2053D+03,  0.2026D+03,  0.2052D+03,  0.2148D+03,   &
         0.2297D+03,  0.2520D+03,  0.2590D+03,  0.2573D+03   &
         /
       data (TREF(19, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2558D+03,  0.2466D+03,  0.2305D+03,  0.2165D+03,   &
         0.2070D+03,  0.2045D+03,  0.2078D+03,  0.2189D+03,   &
         0.2337D+03,  0.2510D+03,  0.2566D+03,  0.2564D+03   &
         /
       data (TREF(19, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2545D+03,  0.2473D+03,  0.2341D+03,  0.2216D+03,   &
         0.2109D+03,  0.2073D+03,  0.2110D+03,  0.2230D+03,   &
         0.2360D+03,  0.2467D+03,  0.2523D+03,  0.2549D+03   &
         /
       data (TREF(19, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2524D+03,  0.2474D+03,  0.2376D+03,  0.2277D+03,   &
         0.2171D+03,  0.2122D+03,  0.2159D+03,  0.2262D+03,   &
         0.2356D+03,  0.2417D+03,  0.2480D+03,  0.2526D+03   &
         /
       data (TREF(19, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2497D+03,  0.2467D+03,  0.2400D+03,  0.2334D+03,   &
         0.2252D+03,  0.2210D+03,  0.2243D+03,  0.2307D+03,   &
         0.2357D+03,  0.2395D+03,  0.2455D+03,  0.2499D+03   &
         /
       data (TREF(19, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2464D+03,  0.2450D+03,  0.2411D+03,  0.2376D+03,   &
         0.2328D+03,  0.2309D+03,  0.2329D+03,  0.2356D+03,   &
         0.2376D+03,  0.2402D+03,  0.2446D+03,  0.2470D+03   &
         /
       data (TREF(19, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2431D+03,  0.2431D+03,  0.2418D+03,  0.2410D+03,   &
         0.2388D+03,  0.2380D+03,  0.2382D+03,  0.2391D+03,   &
         0.2401D+03,  0.2421D+03,  0.2445D+03,  0.2444D+03   &
         /
       data (TREF(19, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2407D+03,  0.2418D+03,  0.2430D+03,  0.2443D+03,   &
         0.2431D+03,  0.2419D+03,  0.2408D+03,  0.2411D+03,   &
         0.2422D+03,  0.2440D+03,  0.2447D+03,  0.2428D+03   &
         /
       data (TREF(19, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2398D+03,  0.2414D+03,  0.2442D+03,  0.2465D+03,   &
         0.2457D+03,  0.2439D+03,  0.2422D+03,  0.2424D+03,   &
         0.2436D+03,  0.2453D+03,  0.2453D+03,  0.2425D+03   &
         /
       data (TREF(19,10, mtmp), mtmp=1,12)   &
         /   &
         0.2395D+03,  0.2411D+03,  0.2445D+03,  0.2468D+03,   &
         0.2460D+03,  0.2443D+03,  0.2425D+03,  0.2426D+03,   &
         0.2437D+03,  0.2452D+03,  0.2449D+03,  0.2420D+03   &
         /
       data (TREF(19,11, mtmp), mtmp=1,12)   &
         /   &
         0.2390D+03,  0.2407D+03,  0.2437D+03,  0.2458D+03,   &
         0.2454D+03,  0.2440D+03,  0.2424D+03,  0.2421D+03,   &
         0.2426D+03,  0.2434D+03,  0.2430D+03,  0.2408D+03   &
         /
       data (TREF(19,12, mtmp), mtmp=1,12)   &
         /   &
         0.2381D+03,  0.2395D+03,  0.2420D+03,  0.2445D+03,   &
         0.2451D+03,  0.2446D+03,  0.2430D+03,  0.2418D+03,   &
         0.2412D+03,  0.2405D+03,  0.2396D+03,  0.2387D+03   &
         /
       data (TREF(19,13, mtmp), mtmp=1,12)   &
         /   &
         0.2358D+03,  0.2371D+03,  0.2391D+03,  0.2427D+03,   &
         0.2452D+03,  0.2459D+03,  0.2444D+03,  0.2421D+03,   &
         0.2400D+03,  0.2372D+03,  0.2345D+03,  0.2346D+03   &
         /
       data (TREF(19,14, mtmp), mtmp=1,12)   &
         /   &
         0.2325D+03,  0.2341D+03,  0.2357D+03,  0.2404D+03,   &
         0.2455D+03,  0.2478D+03,  0.2466D+03,  0.2433D+03,   &
         0.2391D+03,  0.2337D+03,  0.2285D+03,  0.2288D+03   &
         /
       data (TREF(19,15, mtmp), mtmp=1,12)   &
         /   &
         0.2289D+03,  0.2314D+03,  0.2330D+03,  0.2384D+03,   &
         0.2455D+03,  0.2497D+03,  0.2493D+03,  0.2449D+03,   &
         0.2378D+03,  0.2291D+03,  0.2223D+03,  0.2229D+03   &
         /
       data (TREF(19,16, mtmp), mtmp=1,12)   &
         /   &
         0.2254D+03,  0.2295D+03,  0.2315D+03,  0.2366D+03,   &
         0.2453D+03,  0.2513D+03,  0.2514D+03,  0.2457D+03,   &
         0.2350D+03,  0.2233D+03,  0.2165D+03,  0.2181D+03   &
         /
       data (TREF(19,17, mtmp), mtmp=1,12)   &
         /   &
         0.2219D+03,  0.2282D+03,  0.2301D+03,  0.2348D+03,   &
         0.2447D+03,  0.2520D+03,  0.2523D+03,  0.2452D+03,   &
         0.2313D+03,  0.2173D+03,  0.2115D+03,  0.2137D+03   &
         /
       data (TREF(19,18, mtmp), mtmp=1,12)   &
         /   &
         0.2188D+03,  0.2269D+03,  0.2284D+03,  0.2328D+03,   &
         0.2436D+03,  0.2516D+03,  0.2520D+03,  0.2442D+03,   &
         0.2285D+03,  0.2130D+03,  0.2079D+03,  0.2101D+03   &
         /
       data (TREF(20, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2632D+03,  0.2521D+03,  0.2322D+03,  0.2181D+03,   &
         0.2106D+03,  0.2090D+03,  0.2129D+03,  0.2237D+03,   &
         0.2386D+03,  0.2585D+03,  0.2635D+03,  0.2632D+03   &
         /
       data (TREF(20, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2620D+03,  0.2520D+03,  0.2344D+03,  0.2207D+03,   &
         0.2121D+03,  0.2107D+03,  0.2155D+03,  0.2278D+03,   &
         0.2418D+03,  0.2568D+03,  0.2611D+03,  0.2622D+03   &
         /
       data (TREF(20, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2603D+03,  0.2524D+03,  0.2382D+03,  0.2255D+03,   &
         0.2152D+03,  0.2126D+03,  0.2180D+03,  0.2308D+03,   &
         0.2425D+03,  0.2516D+03,  0.2569D+03,  0.2605D+03   &
         /
       data (TREF(20, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2579D+03,  0.2523D+03,  0.2417D+03,  0.2315D+03,   &
         0.2206D+03,  0.2162D+03,  0.2213D+03,  0.2320D+03,   &
         0.2404D+03,  0.2461D+03,  0.2530D+03,  0.2580D+03   &
         /
       data (TREF(20, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2552D+03,  0.2515D+03,  0.2443D+03,  0.2374D+03,   &
         0.2287D+03,  0.2246D+03,  0.2286D+03,  0.2350D+03,   &
         0.2398D+03,  0.2441D+03,  0.2509D+03,  0.2554D+03   &
         /
       data (TREF(20, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2520D+03,  0.2501D+03,  0.2458D+03,  0.2422D+03,   &
         0.2369D+03,  0.2351D+03,  0.2374D+03,  0.2401D+03,   &
         0.2422D+03,  0.2454D+03,  0.2504D+03,  0.2528D+03   &
         /
       data (TREF(20, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2491D+03,  0.2488D+03,  0.2472D+03,  0.2463D+03,   &
         0.2438D+03,  0.2431D+03,  0.2434D+03,  0.2443D+03,   &
         0.2455D+03,  0.2480D+03,  0.2506D+03,  0.2505D+03   &
         /
       data (TREF(20, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2471D+03,  0.2483D+03,  0.2492D+03,  0.2503D+03,   &
         0.2489D+03,  0.2476D+03,  0.2466D+03,  0.2471D+03,   &
         0.2483D+03,  0.2502D+03,  0.2510D+03,  0.2491D+03   &
         /
       data (TREF(20, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2464D+03,  0.2483D+03,  0.2510D+03,  0.2530D+03,   &
         0.2518D+03,  0.2499D+03,  0.2483D+03,  0.2487D+03,   &
         0.2501D+03,  0.2518D+03,  0.2516D+03,  0.2489D+03   &
         /
       data (TREF(20,10, mtmp), mtmp=1,12)   &
         /   &
         0.2462D+03,  0.2481D+03,  0.2515D+03,  0.2533D+03,   &
         0.2523D+03,  0.2504D+03,  0.2486D+03,  0.2490D+03,   &
         0.2503D+03,  0.2517D+03,  0.2513D+03,  0.2485D+03   &
         /
       data (TREF(20,11, mtmp), mtmp=1,12)   &
         /   &
         0.2456D+03,  0.2474D+03,  0.2504D+03,  0.2520D+03,   &
         0.2515D+03,  0.2500D+03,  0.2482D+03,  0.2481D+03,   &
         0.2489D+03,  0.2496D+03,  0.2493D+03,  0.2472D+03   &
         /
       data (TREF(20,12, mtmp), mtmp=1,12)   &
         /   &
         0.2442D+03,  0.2457D+03,  0.2482D+03,  0.2504D+03,   &
         0.2510D+03,  0.2504D+03,  0.2485D+03,  0.2473D+03,   &
         0.2469D+03,  0.2463D+03,  0.2454D+03,  0.2448D+03   &
         /
       data (TREF(20,13, mtmp), mtmp=1,12)   &
         /   &
         0.2411D+03,  0.2424D+03,  0.2449D+03,  0.2485D+03,   &
         0.2512D+03,  0.2517D+03,  0.2498D+03,  0.2472D+03,   &
         0.2452D+03,  0.2425D+03,  0.2395D+03,  0.2400D+03   &
         /
       data (TREF(20,14, mtmp), mtmp=1,12)   &
         /   &
         0.2370D+03,  0.2385D+03,  0.2409D+03,  0.2465D+03,   &
         0.2515D+03,  0.2536D+03,  0.2520D+03,  0.2483D+03,   &
         0.2439D+03,  0.2383D+03,  0.2327D+03,  0.2334D+03   &
         /
       data (TREF(20,15, mtmp), mtmp=1,12)   &
         /   &
         0.2333D+03,  0.2353D+03,  0.2375D+03,  0.2442D+03,   &
         0.2516D+03,  0.2557D+03,  0.2549D+03,  0.2500D+03,   &
         0.2424D+03,  0.2332D+03,  0.2264D+03,  0.2274D+03   &
         /
       data (TREF(20,16, mtmp), mtmp=1,12)   &
         /   &
         0.2302D+03,  0.2333D+03,  0.2352D+03,  0.2417D+03,   &
         0.2511D+03,  0.2572D+03,  0.2570D+03,  0.2508D+03,   &
         0.2394D+03,  0.2271D+03,  0.2207D+03,  0.2230D+03   &
         /
       data (TREF(20,17, mtmp), mtmp=1,12)   &
         /   &
         0.2272D+03,  0.2322D+03,  0.2332D+03,  0.2390D+03,   &
         0.2502D+03,  0.2578D+03,  0.2578D+03,  0.2501D+03,   &
         0.2352D+03,  0.2208D+03,  0.2157D+03,  0.2190D+03   &
         /
       data (TREF(20,18, mtmp), mtmp=1,12)   &
         /   &
         0.2244D+03,  0.2311D+03,  0.2311D+03,  0.2364D+03,   &
         0.2488D+03,  0.2573D+03,  0.2576D+03,  0.2491D+03,   &
         0.2320D+03,  0.2163D+03,  0.2120D+03,  0.2155D+03   &
         /
       data (TREF(21, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2715D+03,  0.2597D+03,  0.2386D+03,  0.2249D+03,   &
         0.2189D+03,  0.2186D+03,  0.2239D+03,  0.2357D+03,   &
         0.2496D+03,  0.2663D+03,  0.2696D+03,  0.2712D+03   &
         /
       data (TREF(21, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2695D+03,  0.2589D+03,  0.2404D+03,  0.2269D+03,   &
         0.2197D+03,  0.2196D+03,  0.2259D+03,  0.2389D+03,   &
         0.2513D+03,  0.2633D+03,  0.2668D+03,  0.2695D+03   &
         /
       data (TREF(21, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2667D+03,  0.2581D+03,  0.2435D+03,  0.2307D+03,   &
         0.2211D+03,  0.2197D+03,  0.2267D+03,  0.2398D+03,   &
         0.2497D+03,  0.2567D+03,  0.2620D+03,  0.2667D+03   &
         /
       data (TREF(21, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2633D+03,  0.2571D+03,  0.2463D+03,  0.2357D+03,   &
         0.2249D+03,  0.2211D+03,  0.2276D+03,  0.2381D+03,   &
         0.2453D+03,  0.2505D+03,  0.2579D+03,  0.2633D+03   &
         /
       data (TREF(21, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2604D+03,  0.2560D+03,  0.2488D+03,  0.2416D+03,   &
         0.2325D+03,  0.2287D+03,  0.2334D+03,  0.2395D+03,   &
         0.2439D+03,  0.2487D+03,  0.2561D+03,  0.2606D+03   &
         /
       data (TREF(21, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2576D+03,  0.2550D+03,  0.2507D+03,  0.2469D+03,   &
         0.2414D+03,  0.2398D+03,  0.2422D+03,  0.2447D+03,   &
         0.2468D+03,  0.2507D+03,  0.2561D+03,  0.2584D+03   &
         /
       data (TREF(21, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2553D+03,  0.2546D+03,  0.2530D+03,  0.2517D+03,   &
         0.2492D+03,  0.2486D+03,  0.2490D+03,  0.2499D+03,   &
         0.2512D+03,  0.2539D+03,  0.2566D+03,  0.2565D+03   &
         /
       data (TREF(21, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2538D+03,  0.2549D+03,  0.2557D+03,  0.2563D+03,   &
         0.2548D+03,  0.2536D+03,  0.2526D+03,  0.2533D+03,   &
         0.2546D+03,  0.2565D+03,  0.2573D+03,  0.2555D+03   &
         /
       data (TREF(21, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2533D+03,  0.2553D+03,  0.2579D+03,  0.2592D+03,   &
         0.2578D+03,  0.2559D+03,  0.2545D+03,  0.2551D+03,   &
         0.2565D+03,  0.2581D+03,  0.2578D+03,  0.2553D+03   &
         /
       data (TREF(21,10, mtmp), mtmp=1,12)   &
         /   &
         0.2531D+03,  0.2552D+03,  0.2584D+03,  0.2596D+03,   &
         0.2583D+03,  0.2564D+03,  0.2548D+03,  0.2554D+03,   &
         0.2567D+03,  0.2580D+03,  0.2575D+03,  0.2549D+03   &
         /
       data (TREF(21,11, mtmp), mtmp=1,12)   &
         /   &
         0.2524D+03,  0.2542D+03,  0.2571D+03,  0.2581D+03,   &
         0.2574D+03,  0.2559D+03,  0.2542D+03,  0.2543D+03,   &
         0.2552D+03,  0.2559D+03,  0.2555D+03,  0.2537D+03   &
         /
       data (TREF(21,12, mtmp), mtmp=1,12)   &
         /   &
         0.2506D+03,  0.2520D+03,  0.2545D+03,  0.2562D+03,   &
         0.2568D+03,  0.2560D+03,  0.2541D+03,  0.2530D+03,   &
         0.2528D+03,  0.2523D+03,  0.2514D+03,  0.2511D+03   &
         /
       data (TREF(21,13, mtmp), mtmp=1,12)   &
         /   &
         0.2465D+03,  0.2478D+03,  0.2506D+03,  0.2543D+03,   &
         0.2568D+03,  0.2571D+03,  0.2549D+03,  0.2523D+03,   &
         0.2505D+03,  0.2479D+03,  0.2448D+03,  0.2455D+03   &
         /
       data (TREF(21,14, mtmp), mtmp=1,12)   &
         /   &
         0.2415D+03,  0.2429D+03,  0.2461D+03,  0.2523D+03,   &
         0.2572D+03,  0.2591D+03,  0.2571D+03,  0.2532D+03,   &
         0.2487D+03,  0.2431D+03,  0.2373D+03,  0.2381D+03   &
         /
       data (TREF(21,15, mtmp), mtmp=1,12)   &
         /   &
         0.2375D+03,  0.2391D+03,  0.2421D+03,  0.2499D+03,   &
         0.2573D+03,  0.2612D+03,  0.2601D+03,  0.2549D+03,   &
         0.2470D+03,  0.2376D+03,  0.2309D+03,  0.2321D+03   &
         /
       data (TREF(21,16, mtmp), mtmp=1,12)   &
         /   &
         0.2350D+03,  0.2371D+03,  0.2391D+03,  0.2469D+03,   &
         0.2568D+03,  0.2628D+03,  0.2624D+03,  0.2558D+03,   &
         0.2438D+03,  0.2314D+03,  0.2255D+03,  0.2282D+03   &
         /
       data (TREF(21,17, mtmp), mtmp=1,12)   &
         /   &
         0.2326D+03,  0.2361D+03,  0.2367D+03,  0.2436D+03,   &
         0.2558D+03,  0.2635D+03,  0.2633D+03,  0.2552D+03,   &
         0.2396D+03,  0.2251D+03,  0.2207D+03,  0.2248D+03   &
         /
       data (TREF(21,18, mtmp), mtmp=1,12)   &
         /   &
         0.2303D+03,  0.2353D+03,  0.2342D+03,  0.2405D+03,   &
         0.2544D+03,  0.2630D+03,  0.2632D+03,  0.2544D+03,   &
         0.2362D+03,  0.2205D+03,  0.2171D+03,  0.2216D+03   &
         /
       data (TREF(22, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2795D+03,  0.2672D+03,  0.2454D+03,  0.2322D+03,   &
         0.2278D+03,  0.2289D+03,  0.2353D+03,  0.2479D+03,   &
         0.2603D+03,  0.2735D+03,  0.2756D+03,  0.2791D+03   &
         /
       data (TREF(22, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2768D+03,  0.2656D+03,  0.2468D+03,  0.2337D+03,   &
         0.2278D+03,  0.2290D+03,  0.2366D+03,  0.2500D+03,   &
         0.2604D+03,  0.2694D+03,  0.2722D+03,  0.2766D+03   &
         /
       data (TREF(22, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2726D+03,  0.2636D+03,  0.2488D+03,  0.2362D+03,   &
         0.2275D+03,  0.2272D+03,  0.2355D+03,  0.2485D+03,   &
         0.2563D+03,  0.2615D+03,  0.2669D+03,  0.2725D+03   &
         /
       data (TREF(22, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2682D+03,  0.2615D+03,  0.2508D+03,  0.2401D+03,   &
         0.2294D+03,  0.2265D+03,  0.2340D+03,  0.2441D+03,   &
         0.2499D+03,  0.2546D+03,  0.2624D+03,  0.2681D+03   &
         /
       data (TREF(22, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2650D+03,  0.2601D+03,  0.2530D+03,  0.2457D+03,   &
         0.2365D+03,  0.2330D+03,  0.2383D+03,  0.2439D+03,   &
         0.2477D+03,  0.2530D+03,  0.2609D+03,  0.2653D+03   &
         /
       data (TREF(22, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2625D+03,  0.2595D+03,  0.2553D+03,  0.2514D+03,   &
         0.2458D+03,  0.2444D+03,  0.2469D+03,  0.2490D+03,   &
         0.2513D+03,  0.2557D+03,  0.2613D+03,  0.2633D+03   &
         /
       data (TREF(22, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2609D+03,  0.2599D+03,  0.2583D+03,  0.2568D+03,   &
         0.2542D+03,  0.2538D+03,  0.2542D+03,  0.2550D+03,   &
         0.2565D+03,  0.2594D+03,  0.2621D+03,  0.2620D+03   &
         /
       data (TREF(22, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2599D+03,  0.2609D+03,  0.2616D+03,  0.2616D+03,   &
         0.2601D+03,  0.2589D+03,  0.2581D+03,  0.2589D+03,   &
         0.2603D+03,  0.2621D+03,  0.2628D+03,  0.2612D+03   &
         /
       data (TREF(22, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2596D+03,  0.2616D+03,  0.2639D+03,  0.2645D+03,   &
         0.2630D+03,  0.2611D+03,  0.2599D+03,  0.2607D+03,   &
         0.2622D+03,  0.2635D+03,  0.2632D+03,  0.2609D+03   &
         /
       data (TREF(22,10, mtmp), mtmp=1,12)   &
         /   &
         0.2594D+03,  0.2616D+03,  0.2645D+03,  0.2649D+03,   &
         0.2635D+03,  0.2615D+03,  0.2602D+03,  0.2610D+03,   &
         0.2624D+03,  0.2635D+03,  0.2629D+03,  0.2606D+03   &
         /
       data (TREF(22,11, mtmp), mtmp=1,12)   &
         /   &
         0.2588D+03,  0.2604D+03,  0.2631D+03,  0.2633D+03,   &
         0.2627D+03,  0.2611D+03,  0.2596D+03,  0.2599D+03,   &
         0.2609D+03,  0.2615D+03,  0.2611D+03,  0.2596D+03   &
         /
       data (TREF(22,12, mtmp), mtmp=1,12)   &
         /   &
         0.2565D+03,  0.2577D+03,  0.2602D+03,  0.2613D+03,   &
         0.2620D+03,  0.2611D+03,  0.2591D+03,  0.2581D+03,   &
         0.2583D+03,  0.2579D+03,  0.2569D+03,  0.2569D+03   &
         /
       data (TREF(22,13, mtmp), mtmp=1,12)   &
         /   &
         0.2517D+03,  0.2528D+03,  0.2560D+03,  0.2595D+03,   &
         0.2620D+03,  0.2620D+03,  0.2596D+03,  0.2569D+03,   &
         0.2554D+03,  0.2531D+03,  0.2499D+03,  0.2509D+03   &
         /
       data (TREF(22,14, mtmp), mtmp=1,12)   &
         /   &
         0.2459D+03,  0.2471D+03,  0.2510D+03,  0.2577D+03,   &
         0.2624D+03,  0.2639D+03,  0.2617D+03,  0.2576D+03,   &
         0.2533D+03,  0.2477D+03,  0.2419D+03,  0.2428D+03   &
         /
       data (TREF(22,15, mtmp), mtmp=1,12)   &
         /   &
         0.2417D+03,  0.2429D+03,  0.2466D+03,  0.2552D+03,   &
         0.2625D+03,  0.2661D+03,  0.2648D+03,  0.2594D+03,   &
         0.2513D+03,  0.2420D+03,  0.2355D+03,  0.2367D+03   &
         /
       data (TREF(22,16, mtmp), mtmp=1,12)   &
         /   &
         0.2397D+03,  0.2408D+03,  0.2431D+03,  0.2520D+03,   &
         0.2621D+03,  0.2678D+03,  0.2672D+03,  0.2604D+03,   &
         0.2483D+03,  0.2358D+03,  0.2306D+03,  0.2335D+03   &
         /
       data (TREF(22,17, mtmp), mtmp=1,12)   &
         /   &
         0.2380D+03,  0.2400D+03,  0.2403D+03,  0.2482D+03,   &
         0.2612D+03,  0.2687D+03,  0.2684D+03,  0.2601D+03,   &
         0.2440D+03,  0.2298D+03,  0.2262D+03,  0.2308D+03   &
         /
       data (TREF(22,18, mtmp), mtmp=1,12)   &
         /   &
         0.2362D+03,  0.2394D+03,  0.2376D+03,  0.2450D+03,   &
         0.2598D+03,  0.2685D+03,  0.2685D+03,  0.2595D+03,   &
         0.2406D+03,  0.2252D+03,  0.2227D+03,  0.2279D+03   &
         /
       data (TREF(23, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2855D+03,  0.2732D+03,  0.2516D+03,  0.2392D+03,   &
         0.2361D+03,  0.2383D+03,  0.2455D+03,  0.2581D+03,   &
         0.2688D+03,  0.2786D+03,  0.2800D+03,  0.2852D+03   &
         /
       data (TREF(23, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2823D+03,  0.2710D+03,  0.2525D+03,  0.2402D+03,   &
         0.2356D+03,  0.2378D+03,  0.2461D+03,  0.2591D+03,   &
         0.2674D+03,  0.2736D+03,  0.2763D+03,  0.2821D+03   &
         /
       data (TREF(23, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2771D+03,  0.2680D+03,  0.2537D+03,  0.2415D+03,   &
         0.2338D+03,  0.2344D+03,  0.2435D+03,  0.2557D+03,   &
         0.2614D+03,  0.2651D+03,  0.2706D+03,  0.2769D+03   &
         /
       data (TREF(23, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2719D+03,  0.2649D+03,  0.2547D+03,  0.2443D+03,   &
         0.2343D+03,  0.2321D+03,  0.2401D+03,  0.2492D+03,   &
         0.2537D+03,  0.2581D+03,  0.2659D+03,  0.2717D+03   &
         /
       data (TREF(23, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2683D+03,  0.2631D+03,  0.2565D+03,  0.2494D+03,   &
         0.2405D+03,  0.2376D+03,  0.2429D+03,  0.2478D+03,   &
         0.2512D+03,  0.2567D+03,  0.2646D+03,  0.2686D+03   &
         /
       data (TREF(23, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2662D+03,  0.2627D+03,  0.2589D+03,  0.2551D+03,   &
         0.2498D+03,  0.2486D+03,  0.2510D+03,  0.2528D+03,   &
         0.2550D+03,  0.2597D+03,  0.2652D+03,  0.2669D+03   &
         /
       data (TREF(23, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2650D+03,  0.2636D+03,  0.2622D+03,  0.2606D+03,   &
         0.2581D+03,  0.2579D+03,  0.2582D+03,  0.2590D+03,   &
         0.2606D+03,  0.2634D+03,  0.2660D+03,  0.2659D+03   &
         /
       data (TREF(23, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2645D+03,  0.2652D+03,  0.2657D+03,  0.2652D+03,   &
         0.2638D+03,  0.2627D+03,  0.2621D+03,  0.2629D+03,   &
         0.2643D+03,  0.2660D+03,  0.2666D+03,  0.2653D+03   &
         /
       data (TREF(23, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2642D+03,  0.2661D+03,  0.2678D+03,  0.2678D+03,   &
         0.2663D+03,  0.2645D+03,  0.2636D+03,  0.2645D+03,   &
         0.2659D+03,  0.2670D+03,  0.2667D+03,  0.2647D+03   &
         /
       data (TREF(23,10, mtmp), mtmp=1,12)   &
         /   &
         0.2641D+03,  0.2660D+03,  0.2684D+03,  0.2682D+03,   &
         0.2667D+03,  0.2649D+03,  0.2639D+03,  0.2648D+03,   &
         0.2661D+03,  0.2670D+03,  0.2664D+03,  0.2644D+03   &
         /
       data (TREF(23,11, mtmp), mtmp=1,12)   &
         /   &
         0.2635D+03,  0.2649D+03,  0.2672D+03,  0.2668D+03,   &
         0.2662D+03,  0.2646D+03,  0.2633D+03,  0.2638D+03,   &
         0.2649D+03,  0.2654D+03,  0.2650D+03,  0.2638D+03   &
         /
       data (TREF(23,12, mtmp), mtmp=1,12)   &
         /   &
         0.2612D+03,  0.2620D+03,  0.2643D+03,  0.2650D+03,   &
         0.2657D+03,  0.2646D+03,  0.2627D+03,  0.2618D+03,   &
         0.2623D+03,  0.2621D+03,  0.2611D+03,  0.2614D+03   &
         /
       data (TREF(23,13, mtmp), mtmp=1,12)   &
         /   &
         0.2560D+03,  0.2568D+03,  0.2602D+03,  0.2635D+03,   &
         0.2658D+03,  0.2656D+03,  0.2631D+03,  0.2606D+03,   &
         0.2594D+03,  0.2573D+03,  0.2543D+03,  0.2554D+03   &
         /
       data (TREF(23,14, mtmp), mtmp=1,12)   &
         /   &
         0.2498D+03,  0.2509D+03,  0.2553D+03,  0.2620D+03,   &
         0.2663D+03,  0.2676D+03,  0.2653D+03,  0.2613D+03,   &
         0.2571D+03,  0.2518D+03,  0.2464D+03,  0.2473D+03   &
         /
       data (TREF(23,15, mtmp), mtmp=1,12)   &
         /   &
         0.2457D+03,  0.2465D+03,  0.2507D+03,  0.2598D+03,   &
         0.2667D+03,  0.2699D+03,  0.2684D+03,  0.2631D+03,   &
         0.2552D+03,  0.2462D+03,  0.2403D+03,  0.2415D+03   &
         /
       data (TREF(23,16, mtmp), mtmp=1,12)   &
         /   &
         0.2442D+03,  0.2446D+03,  0.2471D+03,  0.2566D+03,   &
         0.2665D+03,  0.2718D+03,  0.2709D+03,  0.2643D+03,   &
         0.2524D+03,  0.2405D+03,  0.2361D+03,  0.2389D+03   &
         /
       data (TREF(23,17, mtmp), mtmp=1,12)   &
         /   &
         0.2433D+03,  0.2439D+03,  0.2441D+03,  0.2528D+03,   &
         0.2659D+03,  0.2730D+03,  0.2724D+03,  0.2644D+03,   &
         0.2485D+03,  0.2348D+03,  0.2322D+03,  0.2370D+03   &
         /
       data (TREF(23,18, mtmp), mtmp=1,12)   &
         /   &
         0.2420D+03,  0.2434D+03,  0.2415D+03,  0.2496D+03,   &
         0.2648D+03,  0.2730D+03,  0.2728D+03,  0.2640D+03,   &
         0.2453D+03,  0.2305D+03,  0.2289D+03,  0.2345D+03   &
         /
       data (TREF(24, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2892D+03,  0.2774D+03,  0.2567D+03,  0.2454D+03,   &
         0.2433D+03,  0.2463D+03,  0.2537D+03,  0.2659D+03,   &
         0.2747D+03,  0.2813D+03,  0.2827D+03,  0.2891D+03   &
         /
       data (TREF(24, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2857D+03,  0.2748D+03,  0.2573D+03,  0.2460D+03,   &
         0.2425D+03,  0.2453D+03,  0.2538D+03,  0.2660D+03,   &
         0.2720D+03,  0.2758D+03,  0.2787D+03,  0.2855D+03   &
         /
       data (TREF(24, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2798D+03,  0.2709D+03,  0.2575D+03,  0.2463D+03,   &
         0.2398D+03,  0.2411D+03,  0.2502D+03,  0.2610D+03,   &
         0.2648D+03,  0.2674D+03,  0.2729D+03,  0.2796D+03   &
         /
       data (TREF(24, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2740D+03,  0.2671D+03,  0.2578D+03,  0.2481D+03,   &
         0.2391D+03,  0.2376D+03,  0.2455D+03,  0.2533D+03,   &
         0.2565D+03,  0.2607D+03,  0.2682D+03,  0.2738D+03   &
         /
       data (TREF(24, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2702D+03,  0.2649D+03,  0.2590D+03,  0.2526D+03,   &
         0.2444D+03,  0.2420D+03,  0.2471D+03,  0.2510D+03,   &
         0.2540D+03,  0.2596D+03,  0.2670D+03,  0.2706D+03   &
         /
       data (TREF(24, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2681D+03,  0.2644D+03,  0.2612D+03,  0.2579D+03,   &
         0.2529D+03,  0.2521D+03,  0.2542D+03,  0.2555D+03,   &
         0.2577D+03,  0.2624D+03,  0.2675D+03,  0.2689D+03   &
         /
       data (TREF(24, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2673D+03,  0.2656D+03,  0.2644D+03,  0.2629D+03,   &
         0.2607D+03,  0.2606D+03,  0.2609D+03,  0.2614D+03,   &
         0.2630D+03,  0.2658D+03,  0.2681D+03,  0.2680D+03   &
         /
       data (TREF(24, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2671D+03,  0.2674D+03,  0.2676D+03,  0.2669D+03,   &
         0.2656D+03,  0.2647D+03,  0.2643D+03,  0.2650D+03,   &
         0.2664D+03,  0.2678D+03,  0.2684D+03,  0.2674D+03   &
         /
       data (TREF(24, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2668D+03,  0.2683D+03,  0.2695D+03,  0.2689D+03,   &
         0.2675D+03,  0.2659D+03,  0.2653D+03,  0.2662D+03,   &
         0.2675D+03,  0.2683D+03,  0.2680D+03,  0.2665D+03   &
         /
       data (TREF(24,10, mtmp), mtmp=1,12)   &
         /   &
         0.2667D+03,  0.2683D+03,  0.2700D+03,  0.2692D+03,   &
         0.2679D+03,  0.2661D+03,  0.2655D+03,  0.2665D+03,   &
         0.2677D+03,  0.2683D+03,  0.2678D+03,  0.2663D+03   &
         /
       data (TREF(24,11, mtmp), mtmp=1,12)   &
         /   &
         0.2664D+03,  0.2673D+03,  0.2691D+03,  0.2683D+03,   &
         0.2677D+03,  0.2662D+03,  0.2652D+03,  0.2657D+03,   &
         0.2669D+03,  0.2673D+03,  0.2669D+03,  0.2661D+03   &
         /
       data (TREF(24,12, mtmp), mtmp=1,12)   &
         /   &
         0.2641D+03,  0.2644D+03,  0.2665D+03,  0.2669D+03,   &
         0.2675D+03,  0.2664D+03,  0.2647D+03,  0.2640D+03,   &
         0.2647D+03,  0.2646D+03,  0.2637D+03,  0.2642D+03   &
         /
       data (TREF(24,13, mtmp), mtmp=1,12)   &
         /   &
         0.2591D+03,  0.2596D+03,  0.2630D+03,  0.2659D+03,   &
         0.2679D+03,  0.2676D+03,  0.2652D+03,  0.2629D+03,   &
         0.2621D+03,  0.2604D+03,  0.2575D+03,  0.2587D+03   &
         /
       data (TREF(24,14, mtmp), mtmp=1,12)   &
         /   &
         0.2530D+03,  0.2538D+03,  0.2586D+03,  0.2650D+03,   &
         0.2688D+03,  0.2698D+03,  0.2675D+03,  0.2637D+03,   &
         0.2600D+03,  0.2552D+03,  0.2502D+03,  0.2510D+03   &
         /
       data (TREF(24,15, mtmp), mtmp=1,12)   &
         /   &
         0.2492D+03,  0.2497D+03,  0.2543D+03,  0.2633D+03,   &
         0.2695D+03,  0.2722D+03,  0.2706D+03,  0.2657D+03,   &
         0.2583D+03,  0.2500D+03,  0.2448D+03,  0.2459D+03   &
         /
       data (TREF(24,16, mtmp), mtmp=1,12)   &
         /   &
         0.2484D+03,  0.2481D+03,  0.2508D+03,  0.2604D+03,   &
         0.2698D+03,  0.2744D+03,  0.2733D+03,  0.2671D+03,   &
         0.2560D+03,  0.2450D+03,  0.2414D+03,  0.2441D+03   &
         /
       data (TREF(24,17, mtmp), mtmp=1,12)   &
         /   &
         0.2482D+03,  0.2476D+03,  0.2480D+03,  0.2570D+03,   &
         0.2696D+03,  0.2759D+03,  0.2752D+03,  0.2678D+03,   &
         0.2527D+03,  0.2400D+03,  0.2382D+03,  0.2429D+03   &
         /
       data (TREF(24,18, mtmp), mtmp=1,12)   &
         /   &
         0.2475D+03,  0.2473D+03,  0.2456D+03,  0.2540D+03,   &
         0.2689D+03,  0.2764D+03,  0.2759D+03,  0.2678D+03,   &
         0.2498D+03,  0.2361D+03,  0.2353D+03,  0.2410D+03   &
         /
       data (TREF(25, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2902D+03,  0.2794D+03,  0.2605D+03,  0.2507D+03,   &
         0.2493D+03,  0.2527D+03,  0.2601D+03,  0.2714D+03,   &
         0.2785D+03,  0.2824D+03,  0.2836D+03,  0.2904D+03   &
         /
       data (TREF(25, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2865D+03,  0.2764D+03,  0.2604D+03,  0.2506D+03,   &
         0.2482D+03,  0.2513D+03,  0.2596D+03,  0.2704D+03,   &
         0.2746D+03,  0.2766D+03,  0.2794D+03,  0.2865D+03   &
         /
       data (TREF(25, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2805D+03,  0.2721D+03,  0.2599D+03,  0.2502D+03,   &
         0.2450D+03,  0.2467D+03,  0.2553D+03,  0.2645D+03,   &
         0.2666D+03,  0.2684D+03,  0.2737D+03,  0.2802D+03   &
         /
       data (TREF(25, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2744D+03,  0.2678D+03,  0.2595D+03,  0.2511D+03,   &
         0.2435D+03,  0.2427D+03,  0.2499D+03,  0.2560D+03,   &
         0.2582D+03,  0.2621D+03,  0.2691D+03,  0.2742D+03   &
         /
       data (TREF(25, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2704D+03,  0.2653D+03,  0.2602D+03,  0.2547D+03,   &
         0.2475D+03,  0.2458D+03,  0.2502D+03,  0.2531D+03,   &
         0.2556D+03,  0.2611D+03,  0.2678D+03,  0.2709D+03   &
         /
       data (TREF(25, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2683D+03,  0.2646D+03,  0.2620D+03,  0.2592D+03,   &
         0.2548D+03,  0.2542D+03,  0.2560D+03,  0.2569D+03,   &
         0.2590D+03,  0.2634D+03,  0.2680D+03,  0.2692D+03   &
         /
       data (TREF(25, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2676D+03,  0.2658D+03,  0.2647D+03,  0.2635D+03,   &
         0.2615D+03,  0.2615D+03,  0.2617D+03,  0.2621D+03,   &
         0.2636D+03,  0.2661D+03,  0.2682D+03,  0.2682D+03   &
         /
       data (TREF(25, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2676D+03,  0.2676D+03,  0.2675D+03,  0.2667D+03,   &
         0.2655D+03,  0.2647D+03,  0.2645D+03,  0.2652D+03,   &
         0.2664D+03,  0.2675D+03,  0.2681D+03,  0.2675D+03   &
         /
       data (TREF(25, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2674D+03,  0.2684D+03,  0.2689D+03,  0.2681D+03,   &
         0.2668D+03,  0.2654D+03,  0.2651D+03,  0.2660D+03,   &
         0.2671D+03,  0.2677D+03,  0.2675D+03,  0.2665D+03   &
         /
       data (TREF(25,10, mtmp), mtmp=1,12)   &
         /   &
         0.2673D+03,  0.2684D+03,  0.2694D+03,  0.2683D+03,   &
         0.2671D+03,  0.2656D+03,  0.2653D+03,  0.2662D+03,   &
         0.2672D+03,  0.2677D+03,  0.2673D+03,  0.2663D+03   &
         /
       data (TREF(25,11, mtmp), mtmp=1,12)   &
         /   &
         0.2670D+03,  0.2675D+03,  0.2687D+03,  0.2677D+03,   &
         0.2672D+03,  0.2660D+03,  0.2653D+03,  0.2658D+03,   &
         0.2669D+03,  0.2672D+03,  0.2669D+03,  0.2665D+03   &
         /
       data (TREF(25,12, mtmp), mtmp=1,12)   &
         /   &
         0.2649D+03,  0.2650D+03,  0.2667D+03,  0.2668D+03,   &
         0.2674D+03,  0.2664D+03,  0.2649D+03,  0.2643D+03,   &
         0.2651D+03,  0.2651D+03,  0.2643D+03,  0.2649D+03   &
         /
       data (TREF(25,13, mtmp), mtmp=1,12)   &
         /   &
         0.2604D+03,  0.2606D+03,  0.2638D+03,  0.2665D+03,   &
         0.2682D+03,  0.2678D+03,  0.2656D+03,  0.2635D+03,   &
         0.2629D+03,  0.2616D+03,  0.2591D+03,  0.2601D+03   &
         /
       data (TREF(25,14, mtmp), mtmp=1,12)   &
         /   &
         0.2549D+03,  0.2556D+03,  0.2603D+03,  0.2662D+03,   &
         0.2695D+03,  0.2702D+03,  0.2680D+03,  0.2646D+03,   &
         0.2613D+03,  0.2572D+03,  0.2529D+03,  0.2535D+03   &
         /
       data (TREF(25,15, mtmp), mtmp=1,12)   &
         /   &
         0.2518D+03,  0.2522D+03,  0.2567D+03,  0.2651D+03,   &
         0.2706D+03,  0.2729D+03,  0.2713D+03,  0.2667D+03,   &
         0.2601D+03,  0.2528D+03,  0.2486D+03,  0.2494D+03   &
         /
       data (TREF(25,16, mtmp), mtmp=1,12)   &
         /   &
         0.2517D+03,  0.2512D+03,  0.2539D+03,  0.2629D+03,   &
         0.2714D+03,  0.2753D+03,  0.2742D+03,  0.2686D+03,   &
         0.2584D+03,  0.2488D+03,  0.2462D+03,  0.2487D+03   &
         /
       data (TREF(25,17, mtmp), mtmp=1,12)   &
         /   &
         0.2523D+03,  0.2512D+03,  0.2516D+03,  0.2601D+03,   &
         0.2718D+03,  0.2773D+03,  0.2765D+03,  0.2698D+03,   &
         0.2560D+03,  0.2449D+03,  0.2440D+03,  0.2483D+03   &
         /
       data (TREF(25,18, mtmp), mtmp=1,12)   &
         /   &
         0.2522D+03,  0.2515D+03,  0.2498D+03,  0.2577D+03,   &
         0.2716D+03,  0.2782D+03,  0.2776D+03,  0.2703D+03,   &
         0.2539D+03,  0.2418D+03,  0.2417D+03,  0.2470D+03   &
         /
       data (TREF(26, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2884D+03,  0.2789D+03,  0.2624D+03,  0.2546D+03,   &
         0.2538D+03,  0.2573D+03,  0.2642D+03,  0.2744D+03,   &
         0.2803D+03,  0.2822D+03,  0.2828D+03,  0.2889D+03   &
         /
       data (TREF(26, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2846D+03,  0.2756D+03,  0.2615D+03,  0.2537D+03,   &
         0.2522D+03,  0.2556D+03,  0.2631D+03,  0.2724D+03,   &
         0.2756D+03,  0.2763D+03,  0.2784D+03,  0.2848D+03   &
         /
       data (TREF(26, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2787D+03,  0.2712D+03,  0.2604D+03,  0.2525D+03,   &
         0.2489D+03,  0.2510D+03,  0.2586D+03,  0.2660D+03,   &
         0.2671D+03,  0.2683D+03,  0.2729D+03,  0.2787D+03   &
         /
       data (TREF(26, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2728D+03,  0.2670D+03,  0.2595D+03,  0.2527D+03,   &
         0.2469D+03,  0.2468D+03,  0.2529D+03,  0.2573D+03,   &
         0.2586D+03,  0.2622D+03,  0.2684D+03,  0.2729D+03   &
         /
       data (TREF(26, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2687D+03,  0.2642D+03,  0.2597D+03,  0.2554D+03,   &
         0.2496D+03,  0.2484D+03,  0.2519D+03,  0.2537D+03,   &
         0.2558D+03,  0.2608D+03,  0.2668D+03,  0.2695D+03   &
         /
       data (TREF(26, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2665D+03,  0.2632D+03,  0.2608D+03,  0.2588D+03,   &
         0.2550D+03,  0.2546D+03,  0.2560D+03,  0.2564D+03,   &
         0.2584D+03,  0.2624D+03,  0.2665D+03,  0.2676D+03   &
         /
       data (TREF(26, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2658D+03,  0.2640D+03,  0.2628D+03,  0.2620D+03,   &
         0.2602D+03,  0.2602D+03,  0.2604D+03,  0.2607D+03,   &
         0.2620D+03,  0.2642D+03,  0.2662D+03,  0.2664D+03   &
         /
       data (TREF(26, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2659D+03,  0.2656D+03,  0.2651D+03,  0.2645D+03,   &
         0.2635D+03,  0.2629D+03,  0.2627D+03,  0.2634D+03,   &
         0.2642D+03,  0.2651D+03,  0.2658D+03,  0.2656D+03   &
         /
       data (TREF(26, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2658D+03,  0.2664D+03,  0.2663D+03,  0.2655D+03,   &
         0.2645D+03,  0.2633D+03,  0.2632D+03,  0.2641D+03,   &
         0.2647D+03,  0.2652D+03,  0.2652D+03,  0.2648D+03   &
         /
       data (TREF(26,10, mtmp), mtmp=1,12)   &
         /   &
         0.2657D+03,  0.2664D+03,  0.2667D+03,  0.2656D+03,   &
         0.2646D+03,  0.2635D+03,  0.2634D+03,  0.2642D+03,   &
         0.2649D+03,  0.2652D+03,  0.2650D+03,  0.2646D+03   &
         /
       data (TREF(26,11, mtmp), mtmp=1,12)   &
         /   &
         0.2654D+03,  0.2655D+03,  0.2662D+03,  0.2652D+03,   &
         0.2648D+03,  0.2639D+03,  0.2634D+03,  0.2639D+03,   &
         0.2646D+03,  0.2649D+03,  0.2648D+03,  0.2647D+03   &
         /
       data (TREF(26,12, mtmp), mtmp=1,12)   &
         /   &
         0.2634D+03,  0.2633D+03,  0.2646D+03,  0.2647D+03,   &
         0.2652D+03,  0.2646D+03,  0.2632D+03,  0.2627D+03,   &
         0.2633D+03,  0.2634D+03,  0.2627D+03,  0.2632D+03   &
         /
       data (TREF(26,13, mtmp), mtmp=1,12)   &
         /   &
         0.2594D+03,  0.2598D+03,  0.2626D+03,  0.2650D+03,   &
         0.2664D+03,  0.2661D+03,  0.2641D+03,  0.2622D+03,   &
         0.2616D+03,  0.2608D+03,  0.2587D+03,  0.2592D+03   &
         /
       data (TREF(26,14, mtmp), mtmp=1,12)   &
         /   &
         0.2550D+03,  0.2558D+03,  0.2600D+03,  0.2653D+03,   &
         0.2680D+03,  0.2687D+03,  0.2666D+03,  0.2634D+03,   &
         0.2606D+03,  0.2575D+03,  0.2541D+03,  0.2542D+03   &
         /
       data (TREF(26,15, mtmp), mtmp=1,12)   &
         /   &
         0.2529D+03,  0.2536D+03,  0.2575D+03,  0.2649D+03,   &
         0.2696D+03,  0.2717D+03,  0.2701D+03,  0.2659D+03,   &
         0.2600D+03,  0.2541D+03,  0.2511D+03,  0.2516D+03   &
         /
       data (TREF(26,16, mtmp), mtmp=1,12)   &
         /   &
         0.2537D+03,  0.2537D+03,  0.2558D+03,  0.2635D+03,   &
         0.2710D+03,  0.2745D+03,  0.2735D+03,  0.2683D+03,   &
         0.2593D+03,  0.2514D+03,  0.2499D+03,  0.2520D+03   &
         /
       data (TREF(26,17, mtmp), mtmp=1,12)   &
         /   &
         0.2550D+03,  0.2548D+03,  0.2547D+03,  0.2617D+03,   &
         0.2720D+03,  0.2768D+03,  0.2761D+03,  0.2700D+03,   &
         0.2580D+03,  0.2489D+03,  0.2488D+03,  0.2525D+03   &
         /
       data (TREF(26,18, mtmp), mtmp=1,12)   &
         /   &
         0.2557D+03,  0.2560D+03,  0.2540D+03,  0.2602D+03,   &
         0.2724D+03,  0.2782D+03,  0.2777D+03,  0.2712D+03,   &
         0.2569D+03,  0.2471D+03,  0.2477D+03,  0.2521D+03   &
         /
       data (TREF(27, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2838D+03,  0.2760D+03,  0.2624D+03,  0.2573D+03,   &
         0.2570D+03,  0.2610D+03,  0.2673D+03,  0.2759D+03,   &
         0.2807D+03,  0.2798D+03,  0.2797D+03,  0.2845D+03   &
         /
       data (TREF(27, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2800D+03,  0.2725D+03,  0.2606D+03,  0.2553D+03,   &
         0.2551D+03,  0.2590D+03,  0.2655D+03,  0.2726D+03,   &
         0.2747D+03,  0.2741D+03,  0.2753D+03,  0.2804D+03   &
         /
       data (TREF(27, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2749D+03,  0.2684D+03,  0.2588D+03,  0.2533D+03,   &
         0.2520D+03,  0.2547D+03,  0.2609D+03,  0.2657D+03,   &
         0.2657D+03,  0.2664D+03,  0.2701D+03,  0.2749D+03   &
         /
       data (TREF(27, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2695D+03,  0.2643D+03,  0.2576D+03,  0.2528D+03,   &
         0.2495D+03,  0.2504D+03,  0.2550D+03,  0.2569D+03,   &
         0.2573D+03,  0.2606D+03,  0.2660D+03,  0.2699D+03   &
         /
       data (TREF(27, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2654D+03,  0.2613D+03,  0.2574D+03,  0.2546D+03,   &
         0.2504D+03,  0.2501D+03,  0.2524D+03,  0.2524D+03,   &
         0.2543D+03,  0.2588D+03,  0.2640D+03,  0.2665D+03   &
         /
       data (TREF(27, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2630D+03,  0.2601D+03,  0.2579D+03,  0.2567D+03,   &
         0.2537D+03,  0.2535D+03,  0.2542D+03,  0.2540D+03,   &
         0.2558D+03,  0.2594D+03,  0.2631D+03,  0.2643D+03   &
         /
       data (TREF(27, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2623D+03,  0.2606D+03,  0.2592D+03,  0.2588D+03,   &
         0.2574D+03,  0.2573D+03,  0.2573D+03,  0.2574D+03,   &
         0.2584D+03,  0.2602D+03,  0.2622D+03,  0.2630D+03   &
         /
       data (TREF(27, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2628D+03,  0.2621D+03,  0.2610D+03,  0.2607D+03,   &
         0.2600D+03,  0.2594D+03,  0.2593D+03,  0.2598D+03,   &
         0.2602D+03,  0.2608D+03,  0.2617D+03,  0.2624D+03   &
         /
       data (TREF(27, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2633D+03,  0.2630D+03,  0.2622D+03,  0.2615D+03,   &
         0.2609D+03,  0.2599D+03,  0.2601D+03,  0.2608D+03,   &
         0.2608D+03,  0.2611D+03,  0.2615D+03,  0.2621D+03   &
         /
       data (TREF(27,10, mtmp), mtmp=1,12)   &
         /   &
         0.2631D+03,  0.2630D+03,  0.2626D+03,  0.2616D+03,   &
         0.2608D+03,  0.2600D+03,  0.2602D+03,  0.2609D+03,   &
         0.2610D+03,  0.2612D+03,  0.2615D+03,  0.2620D+03   &
         /
       data (TREF(27,11, mtmp), mtmp=1,12)   &
         /   &
         0.2622D+03,  0.2620D+03,  0.2619D+03,  0.2609D+03,   &
         0.2607D+03,  0.2603D+03,  0.2601D+03,  0.2604D+03,   &
         0.2606D+03,  0.2609D+03,  0.2610D+03,  0.2615D+03   &
         /
       data (TREF(27,12, mtmp), mtmp=1,12)   &
         /   &
         0.2598D+03,  0.2598D+03,  0.2605D+03,  0.2605D+03,   &
         0.2610D+03,  0.2609D+03,  0.2598D+03,  0.2593D+03,   &
         0.2594D+03,  0.2597D+03,  0.2593D+03,  0.2596D+03   &
         /
       data (TREF(27,13, mtmp), mtmp=1,12)   &
         /   &
         0.2562D+03,  0.2569D+03,  0.2592D+03,  0.2614D+03,   &
         0.2625D+03,  0.2625D+03,  0.2607D+03,  0.2589D+03,   &
         0.2583D+03,  0.2580D+03,  0.2564D+03,  0.2562D+03   &
         /
       data (TREF(27,14, mtmp), mtmp=1,12)   &
         /   &
         0.2528D+03,  0.2540D+03,  0.2577D+03,  0.2624D+03,   &
         0.2646D+03,  0.2653D+03,  0.2632D+03,  0.2602D+03,   &
         0.2578D+03,  0.2559D+03,  0.2538D+03,  0.2529D+03   &
         /
       data (TREF(27,15, mtmp), mtmp=1,12)   &
         /   &
         0.2520D+03,  0.2534D+03,  0.2565D+03,  0.2626D+03,   &
         0.2667D+03,  0.2687D+03,  0.2671D+03,  0.2630D+03,   &
         0.2579D+03,  0.2539D+03,  0.2524D+03,  0.2523D+03   &
         /
       data (TREF(27,16, mtmp), mtmp=1,12)   &
         /   &
         0.2540D+03,  0.2552D+03,  0.2563D+03,  0.2621D+03,   &
         0.2685D+03,  0.2718D+03,  0.2709D+03,  0.2660D+03,   &
         0.2582D+03,  0.2525D+03,  0.2526D+03,  0.2541D+03   &
         /
       data (TREF(27,17, mtmp), mtmp=1,12)   &
         /   &
         0.2563D+03,  0.2580D+03,  0.2569D+03,  0.2615D+03,   &
         0.2701D+03,  0.2744D+03,  0.2739D+03,  0.2685D+03,   &
         0.2583D+03,  0.2519D+03,  0.2530D+03,  0.2558D+03   &
         /
       data (TREF(27,18, mtmp), mtmp=1,12)   &
         /   &
         0.2578D+03,  0.2608D+03,  0.2575D+03,  0.2609D+03,   &
         0.2714D+03,  0.2763D+03,  0.2760D+03,  0.2704D+03,   &
         0.2587D+03,  0.2518D+03,  0.2532D+03,  0.2563D+03   &
         /
       data (TREF(28, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2760D+03,  0.2707D+03,  0.2599D+03,  0.2583D+03,   &
         0.2593D+03,  0.2649D+03,  0.2708D+03,  0.2774D+03,   &
         0.2793D+03,  0.2733D+03,  0.2727D+03,  0.2764D+03   &
         /
       data (TREF(28, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2727D+03,  0.2671D+03,  0.2573D+03,  0.2553D+03,   &
         0.2577D+03,  0.2630D+03,  0.2683D+03,  0.2719D+03,   &
         0.2710D+03,  0.2678D+03,  0.2688D+03,  0.2728D+03   &
         /
       data (TREF(28, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2687D+03,  0.2633D+03,  0.2549D+03,  0.2522D+03,   &
         0.2547D+03,  0.2590D+03,  0.2635D+03,  0.2638D+03,   &
         0.2612D+03,  0.2613D+03,  0.2645D+03,  0.2686D+03   &
         /
       data (TREF(28, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2642D+03,  0.2593D+03,  0.2533D+03,  0.2508D+03,   &
         0.2512D+03,  0.2540D+03,  0.2566D+03,  0.2541D+03,   &
         0.2530D+03,  0.2564D+03,  0.2610D+03,  0.2646D+03   &
         /
       data (TREF(28, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2601D+03,  0.2561D+03,  0.2527D+03,  0.2516D+03,   &
         0.2498D+03,  0.2510D+03,  0.2514D+03,  0.2484D+03,   &
         0.2500D+03,  0.2546D+03,  0.2589D+03,  0.2614D+03   &
         /
       data (TREF(28, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2577D+03,  0.2548D+03,  0.2529D+03,  0.2528D+03,   &
         0.2509D+03,  0.2513D+03,  0.2506D+03,  0.2489D+03,   &
         0.2509D+03,  0.2542D+03,  0.2575D+03,  0.2591D+03   &
         /
       data (TREF(28, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2576D+03,  0.2557D+03,  0.2541D+03,  0.2540D+03,   &
         0.2532D+03,  0.2532D+03,  0.2526D+03,  0.2520D+03,   &
         0.2528D+03,  0.2542D+03,  0.2562D+03,  0.2581D+03   &
         /
       data (TREF(28, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2596D+03,  0.2579D+03,  0.2561D+03,  0.2555D+03,   &
         0.2553D+03,  0.2548D+03,  0.2548D+03,  0.2549D+03,   &
         0.2546D+03,  0.2547D+03,  0.2561D+03,  0.2585D+03   &
         /
       data (TREF(28, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2614D+03,  0.2596D+03,  0.2576D+03,  0.2564D+03,   &
         0.2563D+03,  0.2556D+03,  0.2562D+03,  0.2567D+03,   &
         0.2558D+03,  0.2557D+03,  0.2568D+03,  0.2594D+03   &
         /
       data (TREF(28,10, mtmp), mtmp=1,12)   &
         /   &
         0.2610D+03,  0.2594D+03,  0.2577D+03,  0.2562D+03,   &
         0.2560D+03,  0.2556D+03,  0.2565D+03,  0.2569D+03,   &
         0.2559D+03,  0.2558D+03,  0.2569D+03,  0.2593D+03   &
         /
       data (TREF(28,11, mtmp), mtmp=1,12)   &
         /   &
         0.2587D+03,  0.2574D+03,  0.2563D+03,  0.2549D+03,   &
         0.2550D+03,  0.2552D+03,  0.2555D+03,  0.2557D+03,   &
         0.2551D+03,  0.2553D+03,  0.2560D+03,  0.2577D+03   &
         /
       data (TREF(28,12, mtmp), mtmp=1,12)   &
         /   &
         0.2549D+03,  0.2545D+03,  0.2546D+03,  0.2543D+03,   &
         0.2550D+03,  0.2553D+03,  0.2545D+03,  0.2540D+03,   &
         0.2538D+03,  0.2543D+03,  0.2543D+03,  0.2546D+03   &
         /
       data (TREF(28,13, mtmp), mtmp=1,12)   &
         /   &
         0.2506D+03,  0.2513D+03,  0.2535D+03,  0.2557D+03,   &
         0.2564D+03,  0.2566D+03,  0.2549D+03,  0.2533D+03,   &
         0.2527D+03,  0.2533D+03,  0.2526D+03,  0.2511D+03   &
         /
       data (TREF(28,14, mtmp), mtmp=1,12)   &
         /   &
         0.2475D+03,  0.2492D+03,  0.2529D+03,  0.2573D+03,   &
         0.2587D+03,  0.2595D+03,  0.2574D+03,  0.2544D+03,   &
         0.2524D+03,  0.2523D+03,  0.2519D+03,  0.2495D+03   &
         /
       data (TREF(28,15, mtmp), mtmp=1,12)   &
         /   &
         0.2480D+03,  0.2504D+03,  0.2529D+03,  0.2579D+03,   &
         0.2613D+03,  0.2633D+03,  0.2616D+03,  0.2574D+03,   &
         0.2530D+03,  0.2514D+03,  0.2523D+03,  0.2512D+03   &
         /
       data (TREF(28,16, mtmp), mtmp=1,12)   &
         /   &
         0.2517D+03,  0.2547D+03,  0.2543D+03,  0.2582D+03,   &
         0.2637D+03,  0.2666D+03,  0.2659D+03,  0.2613D+03,   &
         0.2543D+03,  0.2515D+03,  0.2541D+03,  0.2550D+03   &
         /
       data (TREF(28,17, mtmp), mtmp=1,12)   &
         /   &
         0.2555D+03,  0.2600D+03,  0.2567D+03,  0.2586D+03,   &
         0.2660D+03,  0.2695D+03,  0.2692D+03,  0.2646D+03,   &
         0.2561D+03,  0.2530D+03,  0.2562D+03,  0.2580D+03   &
         /
       data (TREF(28,18, mtmp), mtmp=1,12)   &
         /   &
         0.2583D+03,  0.2651D+03,  0.2589D+03,  0.2588D+03,   &
         0.2681D+03,  0.2718D+03,  0.2718D+03,  0.2674D+03,   &
         0.2581D+03,  0.2550D+03,  0.2577D+03,  0.2594D+03   &
         /
       data (TREF(29, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2695D+03,  0.2650D+03,  0.2561D+03,  0.2545D+03,   &
         0.2549D+03,  0.2591D+03,  0.2635D+03,  0.2683D+03,   &
         0.2692D+03,  0.2650D+03,  0.2659D+03,  0.2702D+03   &
         /
       data (TREF(29, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2665D+03,  0.2617D+03,  0.2535D+03,  0.2518D+03,   &
         0.2535D+03,  0.2576D+03,  0.2616D+03,  0.2639D+03,   &
         0.2626D+03,  0.2607D+03,  0.2627D+03,  0.2670D+03   &
         /
       data (TREF(29, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2625D+03,  0.2578D+03,  0.2506D+03,  0.2485D+03,   &
         0.2508D+03,  0.2544D+03,  0.2579D+03,  0.2577D+03,   &
         0.2554D+03,  0.2559D+03,  0.2590D+03,  0.2628D+03   &
         /
       data (TREF(29, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2580D+03,  0.2535D+03,  0.2480D+03,  0.2466D+03,   &
         0.2477D+03,  0.2505D+03,  0.2526D+03,  0.2502D+03,   &
         0.2493D+03,  0.2522D+03,  0.2559D+03,  0.2588D+03   &
         /
       data (TREF(29, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2539D+03,  0.2502D+03,  0.2469D+03,  0.2468D+03,   &
         0.2461D+03,  0.2478D+03,  0.2480D+03,  0.2453D+03,   &
         0.2467D+03,  0.2503D+03,  0.2537D+03,  0.2556D+03   &
         /
       data (TREF(29, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2521D+03,  0.2496D+03,  0.2480D+03,  0.2482D+03,   &
         0.2471D+03,  0.2478D+03,  0.2470D+03,  0.2454D+03,   &
         0.2470D+03,  0.2496D+03,  0.2521D+03,  0.2535D+03   &
         /
       data (TREF(29, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2527D+03,  0.2513D+03,  0.2504D+03,  0.2500D+03,   &
         0.2492D+03,  0.2488D+03,  0.2482D+03,  0.2475D+03,   &
         0.2479D+03,  0.2491D+03,  0.2509D+03,  0.2527D+03   &
         /
       data (TREF(29, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2546D+03,  0.2535D+03,  0.2523D+03,  0.2513D+03,   &
         0.2508D+03,  0.2499D+03,  0.2497D+03,  0.2495D+03,   &
         0.2489D+03,  0.2493D+03,  0.2508D+03,  0.2533D+03   &
         /
       data (TREF(29, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2558D+03,  0.2543D+03,  0.2527D+03,  0.2514D+03,   &
         0.2512D+03,  0.2505D+03,  0.2509D+03,  0.2512D+03,   &
         0.2503D+03,  0.2502D+03,  0.2514D+03,  0.2540D+03   &
         /
       data (TREF(29,10, mtmp), mtmp=1,12)   &
         /   &
         0.2551D+03,  0.2535D+03,  0.2518D+03,  0.2507D+03,   &
         0.2507D+03,  0.2506D+03,  0.2516D+03,  0.2520D+03,   &
         0.2513D+03,  0.2509D+03,  0.2517D+03,  0.2537D+03   &
         /
       data (TREF(29,11, mtmp), mtmp=1,12)   &
         /   &
         0.2530D+03,  0.2516D+03,  0.2503D+03,  0.2494D+03,   &
         0.2499D+03,  0.2504D+03,  0.2511D+03,  0.2516D+03,   &
         0.2514D+03,  0.2511D+03,  0.2512D+03,  0.2523D+03   &
         /
       data (TREF(29,12, mtmp), mtmp=1,12)   &
         /   &
         0.2500D+03,  0.2495D+03,  0.2493D+03,  0.2492D+03,   &
         0.2499D+03,  0.2503D+03,  0.2500D+03,  0.2499D+03,   &
         0.2501D+03,  0.2502D+03,  0.2500D+03,  0.2499D+03   &
         /
       data (TREF(29,13, mtmp), mtmp=1,12)   &
         /   &
         0.2468D+03,  0.2473D+03,  0.2491D+03,  0.2508D+03,   &
         0.2512D+03,  0.2513D+03,  0.2497D+03,  0.2483D+03,   &
         0.2477D+03,  0.2486D+03,  0.2484D+03,  0.2473D+03   &
         /
       data (TREF(29,14, mtmp), mtmp=1,12)   &
         /   &
         0.2443D+03,  0.2458D+03,  0.2491D+03,  0.2525D+03,   &
         0.2534D+03,  0.2539D+03,  0.2517D+03,  0.2487D+03,   &
         0.2466D+03,  0.2473D+03,  0.2476D+03,  0.2460D+03   &
         /
       data (TREF(29,15, mtmp), mtmp=1,12)   &
         /   &
         0.2449D+03,  0.2471D+03,  0.2493D+03,  0.2533D+03,   &
         0.2561D+03,  0.2577D+03,  0.2558D+03,  0.2519D+03,   &
         0.2478D+03,  0.2470D+03,  0.2483D+03,  0.2477D+03   &
         /
       data (TREF(29,16, mtmp), mtmp=1,12)   &
         /   &
         0.2476D+03,  0.2504D+03,  0.2500D+03,  0.2536D+03,   &
         0.2585D+03,  0.2614D+03,  0.2604D+03,  0.2562D+03,   &
         0.2501D+03,  0.2480D+03,  0.2502D+03,  0.2507D+03   &
         /
       data (TREF(29,17, mtmp), mtmp=1,12)   &
         /   &
         0.2507D+03,  0.2544D+03,  0.2512D+03,  0.2536D+03,   &
         0.2607D+03,  0.2646D+03,  0.2640D+03,  0.2598D+03,   &
         0.2526D+03,  0.2500D+03,  0.2524D+03,  0.2533D+03   &
         /
       data (TREF(29,18, mtmp), mtmp=1,12)   &
         /   &
         0.2529D+03,  0.2585D+03,  0.2527D+03,  0.2536D+03,   &
         0.2625D+03,  0.2668D+03,  0.2664D+03,  0.2626D+03,   &
         0.2547D+03,  0.2520D+03,  0.2538D+03,  0.2544D+03   &
         /
       data (TREF(30, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2633D+03,  0.2593D+03,  0.2520D+03,  0.2500D+03,   &
         0.2495D+03,  0.2519D+03,  0.2547D+03,  0.2577D+03,   &
         0.2578D+03,  0.2566D+03,  0.2592D+03,  0.2644D+03   &
         /
       data (TREF(30, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2606D+03,  0.2564D+03,  0.2497D+03,  0.2477D+03,   &
         0.2484D+03,  0.2508D+03,  0.2535D+03,  0.2548D+03,   &
         0.2535D+03,  0.2537D+03,  0.2567D+03,  0.2615D+03   &
         /
       data (TREF(30, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2564D+03,  0.2523D+03,  0.2463D+03,  0.2445D+03,   &
         0.2459D+03,  0.2484D+03,  0.2512D+03,  0.2511D+03,   &
         0.2495D+03,  0.2506D+03,  0.2536D+03,  0.2572D+03   &
         /
       data (TREF(30, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2517D+03,  0.2475D+03,  0.2427D+03,  0.2421D+03,   &
         0.2434D+03,  0.2460D+03,  0.2478D+03,  0.2462D+03,   &
         0.2457D+03,  0.2479D+03,  0.2508D+03,  0.2530D+03   &
         /
       data (TREF(30, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2477D+03,  0.2442D+03,  0.2410D+03,  0.2417D+03,   &
         0.2419D+03,  0.2439D+03,  0.2443D+03,  0.2424D+03,   &
         0.2437D+03,  0.2461D+03,  0.2484D+03,  0.2496D+03   &
         /
       data (TREF(30, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2465D+03,  0.2444D+03,  0.2430D+03,  0.2436D+03,   &
         0.2432D+03,  0.2441D+03,  0.2435D+03,  0.2422D+03,   &
         0.2433D+03,  0.2451D+03,  0.2469D+03,  0.2477D+03   &
         /
       data (TREF(30, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2477D+03,  0.2471D+03,  0.2468D+03,  0.2462D+03,   &
         0.2452D+03,  0.2445D+03,  0.2438D+03,  0.2430D+03,   &
         0.2432D+03,  0.2442D+03,  0.2458D+03,  0.2473D+03   &
         /
       data (TREF(30, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2493D+03,  0.2491D+03,  0.2487D+03,  0.2473D+03,   &
         0.2462D+03,  0.2449D+03,  0.2444D+03,  0.2440D+03,   &
         0.2432D+03,  0.2439D+03,  0.2455D+03,  0.2478D+03   &
         /
       data (TREF(30, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2497D+03,  0.2488D+03,  0.2478D+03,  0.2465D+03,   &
         0.2461D+03,  0.2452D+03,  0.2454D+03,  0.2455D+03,   &
         0.2446D+03,  0.2448D+03,  0.2460D+03,  0.2481D+03   &
         /
       data (TREF(30,10, mtmp), mtmp=1,12)   &
         /   &
         0.2486D+03,  0.2472D+03,  0.2458D+03,  0.2452D+03,   &
         0.2454D+03,  0.2456D+03,  0.2465D+03,  0.2470D+03,   &
         0.2467D+03,  0.2462D+03,  0.2464D+03,  0.2476D+03   &
         /
       data (TREF(30,11, mtmp), mtmp=1,12)   &
         /   &
         0.2469D+03,  0.2456D+03,  0.2443D+03,  0.2440D+03,   &
         0.2448D+03,  0.2457D+03,  0.2467D+03,  0.2476D+03,   &
         0.2480D+03,  0.2471D+03,  0.2466D+03,  0.2468D+03   &
         /
       data (TREF(30,12, mtmp), mtmp=1,12)   &
         /   &
         0.2452D+03,  0.2445D+03,  0.2442D+03,  0.2443D+03,   &
         0.2450D+03,  0.2455D+03,  0.2457D+03,  0.2460D+03,   &
         0.2466D+03,  0.2463D+03,  0.2458D+03,  0.2453D+03   &
         /
       data (TREF(30,13, mtmp), mtmp=1,12)   &
         /   &
         0.2433D+03,  0.2436D+03,  0.2449D+03,  0.2460D+03,   &
         0.2462D+03,  0.2461D+03,  0.2447D+03,  0.2435D+03,   &
         0.2429D+03,  0.2439D+03,  0.2442D+03,  0.2438D+03   &
         /
       data (TREF(30,14, mtmp), mtmp=1,12)   &
         /   &
         0.2415D+03,  0.2428D+03,  0.2454D+03,  0.2477D+03,   &
         0.2483D+03,  0.2484D+03,  0.2460D+03,  0.2431D+03,   &
         0.2408D+03,  0.2420D+03,  0.2431D+03,  0.2426D+03   &
         /
       data (TREF(30,15, mtmp), mtmp=1,12)   &
         /   &
         0.2419D+03,  0.2439D+03,  0.2457D+03,  0.2488D+03,   &
         0.2509D+03,  0.2522D+03,  0.2500D+03,  0.2463D+03,   &
         0.2425D+03,  0.2424D+03,  0.2438D+03,  0.2438D+03   &
         /
       data (TREF(30,16, mtmp), mtmp=1,12)   &
         /   &
         0.2434D+03,  0.2456D+03,  0.2454D+03,  0.2488D+03,   &
         0.2532D+03,  0.2561D+03,  0.2548D+03,  0.2511D+03,   &
         0.2460D+03,  0.2441D+03,  0.2455D+03,  0.2456D+03   &
         /
       data (TREF(30,17, mtmp), mtmp=1,12)   &
         /   &
         0.2452D+03,  0.2477D+03,  0.2449D+03,  0.2483D+03,   &
         0.2552D+03,  0.2597D+03,  0.2586D+03,  0.2550D+03,   &
         0.2490D+03,  0.2464D+03,  0.2475D+03,  0.2476D+03   &
         /
       data (TREF(30,18, mtmp), mtmp=1,12)   &
         /   &
         0.2466D+03,  0.2503D+03,  0.2454D+03,  0.2480D+03,   &
         0.2566D+03,  0.2619D+03,  0.2610D+03,  0.2575D+03,   &
         0.2510D+03,  0.2481D+03,  0.2487D+03,  0.2483D+03   &
         /
       data (TREF(31, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2571D+03,  0.2536D+03,  0.2480D+03,  0.2456D+03,   &
         0.2441D+03,  0.2446D+03,  0.2458D+03,  0.2471D+03,   &
         0.2465D+03,  0.2483D+03,  0.2525D+03,  0.2586D+03   &
         /
       data (TREF(31, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2546D+03,  0.2511D+03,  0.2458D+03,  0.2437D+03,   &
         0.2432D+03,  0.2440D+03,  0.2454D+03,  0.2458D+03,   &
         0.2444D+03,  0.2466D+03,  0.2507D+03,  0.2560D+03   &
         /
       data (TREF(31, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2503D+03,  0.2468D+03,  0.2420D+03,  0.2405D+03,   &
         0.2411D+03,  0.2424D+03,  0.2444D+03,  0.2445D+03,   &
         0.2436D+03,  0.2453D+03,  0.2482D+03,  0.2516D+03   &
         /
       data (TREF(31, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2454D+03,  0.2416D+03,  0.2374D+03,  0.2376D+03,   &
         0.2390D+03,  0.2414D+03,  0.2430D+03,  0.2422D+03,   &
         0.2422D+03,  0.2437D+03,  0.2457D+03,  0.2472D+03   &
         /
       data (TREF(31, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2415D+03,  0.2382D+03,  0.2351D+03,  0.2366D+03,   &
         0.2377D+03,  0.2400D+03,  0.2405D+03,  0.2395D+03,   &
         0.2406D+03,  0.2420D+03,  0.2432D+03,  0.2437D+03   &
         /
       data (TREF(31, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2409D+03,  0.2393D+03,  0.2381D+03,  0.2390D+03,   &
         0.2393D+03,  0.2405D+03,  0.2399D+03,  0.2390D+03,   &
         0.2396D+03,  0.2407D+03,  0.2416D+03,  0.2420D+03   &
         /
       data (TREF(31, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2427D+03,  0.2429D+03,  0.2433D+03,  0.2423D+03,   &
         0.2411D+03,  0.2402D+03,  0.2394D+03,  0.2386D+03,   &
         0.2384D+03,  0.2394D+03,  0.2406D+03,  0.2419D+03   &
         /
       data (TREF(31, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2441D+03,  0.2446D+03,  0.2451D+03,  0.2433D+03,   &
         0.2417D+03,  0.2400D+03,  0.2392D+03,  0.2385D+03,   &
         0.2375D+03,  0.2386D+03,  0.2402D+03,  0.2424D+03   &
         /
       data (TREF(31, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2436D+03,  0.2432D+03,  0.2429D+03,  0.2416D+03,   &
         0.2409D+03,  0.2400D+03,  0.2399D+03,  0.2398D+03,   &
         0.2390D+03,  0.2394D+03,  0.2405D+03,  0.2422D+03   &
         /
       data (TREF(31,10, mtmp), mtmp=1,12)   &
         /   &
         0.2420D+03,  0.2410D+03,  0.2398D+03,  0.2397D+03,   &
         0.2401D+03,  0.2405D+03,  0.2414D+03,  0.2421D+03,   &
         0.2422D+03,  0.2414D+03,  0.2412D+03,  0.2416D+03   &
         /
       data (TREF(31,11, mtmp), mtmp=1,12)   &
         /   &
         0.2409D+03,  0.2395D+03,  0.2383D+03,  0.2387D+03,   &
         0.2397D+03,  0.2409D+03,  0.2423D+03,  0.2436D+03,   &
         0.2446D+03,  0.2432D+03,  0.2419D+03,  0.2412D+03   &
         /
       data (TREF(31,12, mtmp), mtmp=1,12)   &
         /   &
         0.2403D+03,  0.2396D+03,  0.2391D+03,  0.2394D+03,   &
         0.2401D+03,  0.2407D+03,  0.2413D+03,  0.2421D+03,   &
         0.2431D+03,  0.2424D+03,  0.2415D+03,  0.2407D+03   &
         /
       data (TREF(31,13, mtmp), mtmp=1,12)   &
         /   &
         0.2398D+03,  0.2399D+03,  0.2407D+03,  0.2412D+03,   &
         0.2412D+03,  0.2409D+03,  0.2397D+03,  0.2386D+03,   &
         0.2380D+03,  0.2392D+03,  0.2400D+03,  0.2402D+03   &
         /
       data (TREF(31,14, mtmp), mtmp=1,12)   &
         /   &
         0.2387D+03,  0.2398D+03,  0.2418D+03,  0.2430D+03,   &
         0.2431D+03,  0.2429D+03,  0.2403D+03,  0.2374D+03,   &
         0.2350D+03,  0.2368D+03,  0.2385D+03,  0.2391D+03   &
         /
       data (TREF(31,15, mtmp), mtmp=1,12)   &
         /   &
         0.2390D+03,  0.2406D+03,  0.2422D+03,  0.2443D+03,   &
         0.2458D+03,  0.2466D+03,  0.2443D+03,  0.2408D+03,   &
         0.2373D+03,  0.2378D+03,  0.2394D+03,  0.2400D+03   &
         /
       data (TREF(31,16, mtmp), mtmp=1,12)   &
         /   &
         0.2392D+03,  0.2408D+03,  0.2409D+03,  0.2441D+03,   &
         0.2480D+03,  0.2509D+03,  0.2492D+03,  0.2460D+03,   &
         0.2418D+03,  0.2402D+03,  0.2408D+03,  0.2405D+03   &
         /
       data (TREF(31,17, mtmp), mtmp=1,12)   &
         /   &
         0.2398D+03,  0.2410D+03,  0.2387D+03,  0.2430D+03,   &
         0.2497D+03,  0.2548D+03,  0.2533D+03,  0.2501D+03,   &
         0.2454D+03,  0.2428D+03,  0.2427D+03,  0.2418D+03   &
         /
       data (TREF(31,18, mtmp), mtmp=1,12)   &
         /   &
         0.2404D+03,  0.2421D+03,  0.2381D+03,  0.2424D+03,   &
         0.2508D+03,  0.2569D+03,  0.2556D+03,  0.2524D+03,   &
         0.2473D+03,  0.2443D+03,  0.2435D+03,  0.2422D+03   &
         /
       data (TREF(32, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2498D+03,  0.2474D+03,  0.2455D+03,  0.2421D+03,   &
         0.2376D+03,  0.2336D+03,  0.2320D+03,  0.2298D+03,   &
         0.2275D+03,  0.2359D+03,  0.2442D+03,  0.2525D+03   &
         /
       data (TREF(32, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2478D+03,  0.2455D+03,  0.2434D+03,  0.2396D+03,   &
         0.2358D+03,  0.2315D+03,  0.2311D+03,  0.2305D+03,   &
         0.2297D+03,  0.2367D+03,  0.2436D+03,  0.2507D+03   &
         /
       data (TREF(32, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2417D+03,  0.2400D+03,  0.2382D+03,  0.2358D+03,   &
         0.2334D+03,  0.2309D+03,  0.2320D+03,  0.2333D+03,   &
         0.2348D+03,  0.2377D+03,  0.2403D+03,  0.2434D+03   &
         /
       data (TREF(32, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2363D+03,  0.2341D+03,  0.2320D+03,  0.2324D+03,   &
         0.2325D+03,  0.2327D+03,  0.2341D+03,  0.2353D+03,   &
         0.2366D+03,  0.2374D+03,  0.2376D+03,  0.2385D+03   &
         /
       data (TREF(32, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2323D+03,  0.2303D+03,  0.2283D+03,  0.2300D+03,   &
         0.2319D+03,  0.2336D+03,  0.2342D+03,  0.2351D+03,   &
         0.2357D+03,  0.2354D+03,  0.2349D+03,  0.2343D+03   &
         /
       data (TREF(32, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2332D+03,  0.2332D+03,  0.2327D+03,  0.2330D+03,   &
         0.2335D+03,  0.2339D+03,  0.2343D+03,  0.2349D+03,   &
         0.2355D+03,  0.2350D+03,  0.2343D+03,  0.2334D+03   &
         /
       data (TREF(32, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2347D+03,  0.2359D+03,  0.2371D+03,  0.2357D+03,   &
         0.2342D+03,  0.2329D+03,  0.2329D+03,  0.2328D+03,   &
         0.2329D+03,  0.2332D+03,  0.2334D+03,  0.2336D+03   &
         /
       data (TREF(32, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2354D+03,  0.2372D+03,  0.2390D+03,  0.2369D+03,   &
         0.2347D+03,  0.2326D+03,  0.2320D+03,  0.2315D+03,   &
         0.2310D+03,  0.2319D+03,  0.2328D+03,  0.2337D+03   &
         /
       data (TREF(32, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2333D+03,  0.2341D+03,  0.2348D+03,  0.2340D+03,   &
         0.2333D+03,  0.2325D+03,  0.2325D+03,  0.2328D+03,   &
         0.2332D+03,  0.2331D+03,  0.2328D+03,  0.2327D+03   &
         /
       data (TREF(32,10, mtmp), mtmp=1,12)   &
         /   &
         0.2325D+03,  0.2328D+03,  0.2333D+03,  0.2332D+03,   &
         0.2330D+03,  0.2328D+03,  0.2334D+03,  0.2340D+03,   &
         0.2349D+03,  0.2340D+03,  0.2333D+03,  0.2325D+03   &
         /
       data (TREF(32,11, mtmp), mtmp=1,12)   &
         /   &
         0.2320D+03,  0.2314D+03,  0.2310D+03,  0.2320D+03,   &
         0.2328D+03,  0.2338D+03,  0.2355D+03,  0.2373D+03,   &
         0.2390D+03,  0.2370D+03,  0.2348D+03,  0.2326D+03   &
         /
       data (TREF(32,12, mtmp), mtmp=1,12)   &
         /   &
         0.2328D+03,  0.2327D+03,  0.2329D+03,  0.2333D+03,   &
         0.2334D+03,  0.2335D+03,  0.2347D+03,  0.2359D+03,   &
         0.2371D+03,  0.2358D+03,  0.2342D+03,  0.2328D+03   &
         /
       data (TREF(32,13, mtmp), mtmp=1,12)   &
         /   &
         0.2343D+03,  0.2349D+03,  0.2355D+03,  0.2351D+03,   &
         0.2343D+03,  0.2333D+03,  0.2331D+03,  0.2333D+03,   &
         0.2328D+03,  0.2330D+03,  0.2334D+03,  0.2339D+03   &
         /
       data (TREF(32,14, mtmp), mtmp=1,12)   &
         /   &
         0.2343D+03,  0.2349D+03,  0.2357D+03,  0.2354D+03,   &
         0.2350D+03,  0.2343D+03,  0.2323D+03,  0.2303D+03,   &
         0.2282D+03,  0.2300D+03,  0.2317D+03,  0.2336D+03   &
         /
       data (TREF(32,15, mtmp), mtmp=1,12)   &
         /   &
         0.2341D+03,  0.2355D+03,  0.2365D+03,  0.2373D+03,   &
         0.2377D+03,  0.2383D+03,  0.2363D+03,  0.2341D+03,   &
         0.2320D+03,  0.2324D+03,  0.2326D+03,  0.2328D+03   &
         /
       data (TREF(32,16, mtmp), mtmp=1,12)   &
         /   &
         0.2321D+03,  0.2334D+03,  0.2348D+03,  0.2376D+03,   &
         0.2404D+03,  0.2432D+03,  0.2420D+03,  0.2402D+03,   &
         0.2381D+03,  0.2359D+03,  0.2332D+03,  0.2306D+03   &
         /
       data (TREF(32,17, mtmp), mtmp=1,12)   &
         /   &
         0.2310D+03,  0.2307D+03,  0.2296D+03,  0.2369D+03,   &
         0.2437D+03,  0.2503D+03,  0.2482D+03,  0.2458D+03,   &
         0.2433D+03,  0.2393D+03,  0.2356D+03,  0.2317D+03   &
         /
       data (TREF(32,18, mtmp), mtmp=1,12)   &
         /   &
         0.2319D+03,  0.2299D+03,  0.2277D+03,  0.2362D+03,   &
         0.2441D+03,  0.2523D+03,  0.2499D+03,  0.2476D+03,   &
         0.2454D+03,  0.2418D+03,  0.2382D+03,  0.2342D+03   &
         /
       data (TREF(33, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2425D+03,  0.2403D+03,  0.2380D+03,  0.2348D+03,   &
         0.2317D+03,  0.2287D+03,  0.2263D+03,  0.2241D+03,   &
         0.2219D+03,  0.2295D+03,  0.2372D+03,  0.2448D+03   &
         /
       data (TREF(33, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2406D+03,  0.2385D+03,  0.2364D+03,  0.2340D+03,   &
         0.2317D+03,  0.2293D+03,  0.2277D+03,  0.2261D+03,   &
         0.2247D+03,  0.2307D+03,  0.2368D+03,  0.2427D+03   &
         /
       data (TREF(33, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2359D+03,  0.2337D+03,  0.2317D+03,  0.2310D+03,   &
         0.2304D+03,  0.2297D+03,  0.2301D+03,  0.2303D+03,   &
         0.2305D+03,  0.2332D+03,  0.2355D+03,  0.2381D+03   &
         /
       data (TREF(33, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2304D+03,  0.2276D+03,  0.2248D+03,  0.2271D+03,   &
         0.2294D+03,  0.2318D+03,  0.2326D+03,  0.2332D+03,   &
         0.2339D+03,  0.2338D+03,  0.2335D+03,  0.2330D+03   &
         /
       data (TREF(33, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2266D+03,  0.2242D+03,  0.2215D+03,  0.2249D+03,   &
         0.2283D+03,  0.2318D+03,  0.2323D+03,  0.2328D+03,   &
         0.2331D+03,  0.2319D+03,  0.2310D+03,  0.2295D+03   &
         /
       data (TREF(33, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2278D+03,  0.2271D+03,  0.2265D+03,  0.2280D+03,   &
         0.2296D+03,  0.2312D+03,  0.2311D+03,  0.2310D+03,   &
         0.2310D+03,  0.2300D+03,  0.2293D+03,  0.2286D+03   &
         /
       data (TREF(33, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2309D+03,  0.2325D+03,  0.2343D+03,  0.2325D+03,   &
         0.2308D+03,  0.2289D+03,  0.2284D+03,  0.2279D+03,   &
         0.2274D+03,  0.2278D+03,  0.2284D+03,  0.2289D+03   &
         /
       data (TREF(33, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2312D+03,  0.2337D+03,  0.2362D+03,  0.2334D+03,   &
         0.2305D+03,  0.2274D+03,  0.2264D+03,  0.2254D+03,   &
         0.2243D+03,  0.2259D+03,  0.2275D+03,  0.2289D+03   &
         /
       data (TREF(33, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2287D+03,  0.2298D+03,  0.2311D+03,  0.2300D+03,   &
         0.2284D+03,  0.2269D+03,  0.2265D+03,  0.2261D+03,   &
         0.2257D+03,  0.2265D+03,  0.2272D+03,  0.2277D+03   &
         /
       data (TREF(33,10, mtmp), mtmp=1,12)   &
         /   &
         0.2263D+03,  0.2261D+03,  0.2257D+03,  0.2266D+03,   &
         0.2275D+03,  0.2281D+03,  0.2291D+03,  0.2302D+03,   &
         0.2313D+03,  0.2300D+03,  0.2283D+03,  0.2267D+03   &
         /
       data (TREF(33,11, mtmp), mtmp=1,12)   &
         /   &
         0.2263D+03,  0.2254D+03,  0.2244D+03,  0.2260D+03,   &
         0.2276D+03,  0.2293D+03,  0.2315D+03,  0.2340D+03,   &
         0.2364D+03,  0.2335D+03,  0.2303D+03,  0.2273D+03   &
         /
       data (TREF(33,12, mtmp), mtmp=1,12)   &
         /   &
         0.2284D+03,  0.2279D+03,  0.2274D+03,  0.2278D+03,   &
         0.2285D+03,  0.2292D+03,  0.2311D+03,  0.2327D+03,   &
         0.2344D+03,  0.2356D+03,  0.2307D+03,  0.2289D+03   &
         /
       data (TREF(33,13, mtmp), mtmp=1,12)   &
         /   &
         0.2311D+03,  0.2311D+03,  0.2309D+03,  0.2300D+03,   &
         0.2293D+03,  0.2286D+03,  0.2277D+03,  0.2271D+03,   &
         0.2265D+03,  0.2280D+03,  0.2296D+03,  0.2312D+03   &
         /
       data (TREF(33,14, mtmp), mtmp=1,12)   &
         /   &
         0.2323D+03,  0.2327D+03,  0.2330D+03,  0.2319D+03,   &
         0.2310D+03,  0.2296D+03,  0.2267D+03,  0.2242D+03,   &
         0.2215D+03,  0.2250D+03,  0.2283D+03,  0.2317D+03   &
         /
       data (TREF(33,15, mtmp), mtmp=1,12)   &
         /   &
         0.2325D+03,  0.2333D+03,  0.2339D+03,  0.2336D+03,   &
         0.2338D+03,  0.2331D+03,  0.2302D+03,  0.2276D+03,   &
         0.2248D+03,  0.2272D+03,  0.2294D+03,  0.2317D+03   &
         /
       data (TREF(33,16, mtmp), mtmp=1,12)   &
         /   &
         0.2301D+03,  0.2303D+03,  0.2305D+03,  0.2330D+03,   &
         0.2357D+03,  0.2378D+03,  0.2360D+03,  0.2337D+03,   &
         0.2317D+03,  0.2310D+03,  0.2305D+03,  0.2298D+03   &
         /
       data (TREF(33,17, mtmp), mtmp=1,12)   &
         /   &
         0.2279D+03,  0.2260D+03,  0.2247D+03,  0.2306D+03,   &
         0.2367D+03,  0.2428D+03,  0.2405D+03,  0.2384D+03,   &
         0.2364D+03,  0.2340D+03,  0.2316D+03,  0.2293D+03   &
         /
       data (TREF(33,18, mtmp), mtmp=1,12)   &
         /   &
         0.2263D+03,  0.2240D+03,  0.2219D+03,  0.2294D+03,   &
         0.2372D+03,  0.2448D+03,  0.2425D+03,  0.2402D+03,   &
         0.2380D+03,  0.2348D+03,  0.2315D+03,  0.2284D+03   &
         /
       data (TREF(34, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2350D+03,  0.2327D+03,  0.2304D+03,  0.2280D+03,   &
         0.2251D+03,  0.2227D+03,  0.2205D+03,  0.2181D+03,   &
         0.2157D+03,  0.2229D+03,  0.2302D+03,  0.2373D+03   &
         /
       data (TREF(34, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2329D+03,  0.2308D+03,  0.2288D+03,  0.2278D+03,   &
         0.2265D+03,  0.2253D+03,  0.2234D+03,  0.2214D+03,   &
         0.2192D+03,  0.2245D+03,  0.2298D+03,  0.2351D+03   &
         /
       data (TREF(34, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2281D+03,  0.2261D+03,  0.2242D+03,  0.2258D+03,   &
         0.2273D+03,  0.2290D+03,  0.2281D+03,  0.2272D+03,   &
         0.2262D+03,  0.2275D+03,  0.2289D+03,  0.2302D+03   &
         /
       data (TREF(34, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2225D+03,  0.2200D+03,  0.2175D+03,  0.2221D+03,   &
         0.2266D+03,  0.2309D+03,  0.2305D+03,  0.2302D+03,   &
         0.2297D+03,  0.2281D+03,  0.2266D+03,  0.2251D+03   &
         /
       data (TREF(34, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2190D+03,  0.2167D+03,  0.2146D+03,  0.2196D+03,   &
         0.2247D+03,  0.2295D+03,  0.2290D+03,  0.2290D+03,   &
         0.2286D+03,  0.2260D+03,  0.2236D+03,  0.2212D+03   &
         /
       data (TREF(34, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2203D+03,  0.2200D+03,  0.2198D+03,  0.2216D+03,   &
         0.2235D+03,  0.2253D+03,  0.2254D+03,  0.2257D+03,   &
         0.2258D+03,  0.2240D+03,  0.2221D+03,  0.2202D+03   &
         /
       data (TREF(34, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2231D+03,  0.2254D+03,  0.2278D+03,  0.2256D+03,   &
         0.2235D+03,  0.2213D+03,  0.2214D+03,  0.2214D+03,   &
         0.2215D+03,  0.2212D+03,  0.2210D+03,  0.2206D+03   &
         /
       data (TREF(34, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2233D+03,  0.2264D+03,  0.2293D+03,  0.2256D+03,   &
         0.2219D+03,  0.2182D+03,  0.2180D+03,  0.2177D+03,   &
         0.2174D+03,  0.2183D+03,  0.2193D+03,  0.2203D+03   &
         /
       data (TREF(34, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2204D+03,  0.2220D+03,  0.2238D+03,  0.2215D+03,   &
         0.2193D+03,  0.2171D+03,  0.2175D+03,  0.2178D+03,   &
         0.2181D+03,  0.2182D+03,  0.2184D+03,  0.2185D+03   &
         /
       data (TREF(34,10, mtmp), mtmp=1,12)   &
         /   &
         0.2175D+03,  0.2178D+03,  0.2181D+03,  0.2182D+03,   &
         0.2183D+03,  0.2184D+03,  0.2202D+03,  0.2219D+03,   &
         0.2238D+03,  0.2215D+03,  0.2193D+03,  0.2172D+03   &
         /
       data (TREF(34,11, mtmp), mtmp=1,12)   &
         /   &
         0.2181D+03,  0.2177D+03,  0.2175D+03,  0.2183D+03,   &
         0.2193D+03,  0.2202D+03,  0.2233D+03,  0.2263D+03,   &
         0.2293D+03,  0.2256D+03,  0.2219D+03,  0.2183D+03   &
         /
       data (TREF(34,12, mtmp), mtmp=1,12)   &
         /   &
         0.2215D+03,  0.2214D+03,  0.2215D+03,  0.2212D+03,   &
         0.2209D+03,  0.2206D+03,  0.2231D+03,  0.2254D+03,   &
         0.2277D+03,  0.2316D+03,  0.2235D+03,  0.2214D+03   &
         /
       data (TREF(34,13, mtmp), mtmp=1,12)   &
         /   &
         0.2254D+03,  0.2257D+03,  0.2258D+03,  0.2240D+03,   &
         0.2220D+03,  0.2202D+03,  0.2202D+03,  0.2200D+03,   &
         0.2198D+03,  0.2216D+03,  0.2235D+03,  0.2253D+03   &
         /
       data (TREF(34,14, mtmp), mtmp=1,12)   &
         /   &
         0.2293D+03,  0.2289D+03,  0.2286D+03,  0.2261D+03,   &
         0.2235D+03,  0.2211D+03,  0.2190D+03,  0.2167D+03,   &
         0.2146D+03,  0.2197D+03,  0.2246D+03,  0.2296D+03   &
         /
       data (TREF(34,15, mtmp), mtmp=1,12)   &
         /   &
         0.2305D+03,  0.2302D+03,  0.2297D+03,  0.2282D+03,   &
         0.2266D+03,  0.2251D+03,  0.2226D+03,  0.2200D+03,   &
         0.2175D+03,  0.2220D+03,  0.2265D+03,  0.2311D+03   &
         /
       data (TREF(34,16, mtmp), mtmp=1,12)   &
         /   &
         0.2280D+03,  0.2272D+03,  0.2262D+03,  0.2276D+03,   &
         0.2289D+03,  0.2303D+03,  0.2281D+03,  0.2262D+03,   &
         0.2242D+03,  0.2258D+03,  0.2274D+03,  0.2289D+03   &
         /
       data (TREF(34,17, mtmp), mtmp=1,12)   &
         /   &
         0.2233D+03,  0.2213D+03,  0.2191D+03,  0.2245D+03,   &
         0.2298D+03,  0.2352D+03,  0.2329D+03,  0.2308D+03,   &
         0.2288D+03,  0.2277D+03,  0.2266D+03,  0.2255D+03   &
         /
       data (TREF(34,18, mtmp), mtmp=1,12)   &
         /   &
         0.2203D+03,  0.2183D+03,  0.2156D+03,  0.2230D+03,   &
         0.2302D+03,  0.2374D+03,  0.2350D+03,  0.2327D+03,   &
         0.2304D+03,  0.2280D+03,  0.2253D+03,  0.2226D+03   &
         /
       data (TREF(35, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2270D+03,  0.2251D+03,  0.2231D+03,  0.2214D+03,   &
         0.2200D+03,  0.2181D+03,  0.2156D+03,  0.2132D+03,   &
         0.2113D+03,  0.2172D+03,  0.2232D+03,  0.2292D+03   &
         /
       data (TREF(35, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2249D+03,  0.2233D+03,  0.2216D+03,  0.2214D+03,   &
         0.2213D+03,  0.2215D+03,  0.2192D+03,  0.2169D+03,   &
         0.2147D+03,  0.2188D+03,  0.2229D+03,  0.2269D+03   &
         /
       data (TREF(35, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2204D+03,  0.2187D+03,  0.2171D+03,  0.2206D+03,   &
         0.2242D+03,  0.2277D+03,  0.2259D+03,  0.2242D+03,   &
         0.2223D+03,  0.2222D+03,  0.2221D+03,  0.2220D+03   &
         /
       data (TREF(35, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2148D+03,  0.2127D+03,  0.2108D+03,  0.2171D+03,   &
         0.2232D+03,  0.2296D+03,  0.2283D+03,  0.2270D+03,   &
         0.2256D+03,  0.2227D+03,  0.2198D+03,  0.2169D+03   &
         /
       data (TREF(35, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2116D+03,  0.2099D+03,  0.2086D+03,  0.2140D+03,   &
         0.2195D+03,  0.2252D+03,  0.2249D+03,  0.2244D+03,   &
         0.2242D+03,  0.2205D+03,  0.2167D+03,  0.2132D+03   &
         /
       data (TREF(35, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2132D+03,  0.2136D+03,  0.2142D+03,  0.2160D+03,   &
         0.2178D+03,  0.2196D+03,  0.2201D+03,  0.2208D+03,   &
         0.2213D+03,  0.2185D+03,  0.2157D+03,  0.2128D+03   &
         /
       data (TREF(35, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2164D+03,  0.2192D+03,  0.2220D+03,  0.2195D+03,   &
         0.2171D+03,  0.2147D+03,  0.2153D+03,  0.2160D+03,   &
         0.2166D+03,  0.2156D+03,  0.2148D+03,  0.2138D+03   &
         /
       data (TREF(35, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2166D+03,  0.2200D+03,  0.2233D+03,  0.2192D+03,   &
         0.2151D+03,  0.2111D+03,  0.2115D+03,  0.2117D+03,   &
         0.2119D+03,  0.2123D+03,  0.2127D+03,  0.2132D+03   &
         /
       data (TREF(35, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2134D+03,  0.2156D+03,  0.2177D+03,  0.2148D+03,   &
         0.2124D+03,  0.2099D+03,  0.2107D+03,  0.2113D+03,   &
         0.2119D+03,  0.2116D+03,  0.2115D+03,  0.2113D+03   &
         /
       data (TREF(35,10, mtmp), mtmp=1,12)   &
         /   &
         0.2107D+03,  0.2114D+03,  0.2119D+03,  0.2114D+03,   &
         0.2112D+03,  0.2110D+03,  0.2132D+03,  0.2154D+03,   &
         0.2176D+03,  0.2148D+03,  0.2124D+03,  0.2100D+03   &
         /
       data (TREF(35,11, mtmp), mtmp=1,12)   &
         /   &
         0.2115D+03,  0.2118D+03,  0.2119D+03,  0.2122D+03,   &
         0.2126D+03,  0.2130D+03,  0.2165D+03,  0.2199D+03,   &
         0.2233D+03,  0.2191D+03,  0.2152D+03,  0.2112D+03   &
         /
       data (TREF(35,12, mtmp), mtmp=1,12)   &
         /   &
         0.2153D+03,  0.2159D+03,  0.2166D+03,  0.2157D+03,   &
         0.2147D+03,  0.2137D+03,  0.2163D+03,  0.2191D+03,   &
         0.2220D+03,  0.2237D+03,  0.2171D+03,  0.2147D+03   &
         /
       data (TREF(35,13, mtmp), mtmp=1,12)   &
         /   &
         0.2201D+03,  0.2208D+03,  0.2213D+03,  0.2185D+03,   &
         0.2157D+03,  0.2128D+03,  0.2132D+03,  0.2136D+03,   &
         0.2142D+03,  0.2160D+03,  0.2178D+03,  0.2196D+03   &
         /
       data (TREF(35,14, mtmp), mtmp=1,12)   &
         /   &
         0.2247D+03,  0.2246D+03,  0.2242D+03,  0.2206D+03,   &
         0.2169D+03,  0.2131D+03,  0.2116D+03,  0.2099D+03,   &
         0.2086D+03,  0.2140D+03,  0.2196D+03,  0.2251D+03   &
         /
       data (TREF(35,15, mtmp), mtmp=1,12)   &
         /   &
         0.2281D+03,  0.2270D+03,  0.2256D+03,  0.2228D+03,   &
         0.2198D+03,  0.2168D+03,  0.2148D+03,  0.2127D+03,   &
         0.2108D+03,  0.2170D+03,  0.2234D+03,  0.2295D+03   &
         /
       data (TREF(35,16, mtmp), mtmp=1,12)   &
         /   &
         0.2259D+03,  0.2242D+03,  0.2222D+03,  0.2223D+03,   &
         0.2222D+03,  0.2220D+03,  0.2204D+03,  0.2187D+03,   &
         0.2171D+03,  0.2206D+03,  0.2241D+03,  0.2276D+03   &
         /
       data (TREF(35,17, mtmp), mtmp=1,12)   &
         /   &
         0.2189D+03,  0.2172D+03,  0.2148D+03,  0.2190D+03,   &
         0.2228D+03,  0.2268D+03,  0.2250D+03,  0.2233D+03,   &
         0.2216D+03,  0.2216D+03,  0.2213D+03,  0.2209D+03   &
         /
       data (TREF(35,18, mtmp), mtmp=1,12)   &
         /   &
         0.2160D+03,  0.2134D+03,  0.2114D+03,  0.2173D+03,   &
         0.2231D+03,  0.2292D+03,  0.2270D+03,  0.2251D+03,   &
         0.2231D+03,  0.2215D+03,  0.2195D+03,  0.2181D+03   &
         /
       data (TREF(36, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2182D+03,  0.2174D+03,  0.2165D+03,  0.2166D+03,   &
         0.2166D+03,  0.2165D+03,  0.2143D+03,  0.2122D+03,   &
         0.2101D+03,  0.2132D+03,  0.2162D+03,  0.2192D+03   &
         /
       data (TREF(36, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2164D+03,  0.2156D+03,  0.2149D+03,  0.2165D+03,   &
         0.2179D+03,  0.2193D+03,  0.2173D+03,  0.2153D+03,   &
         0.2133D+03,  0.2146D+03,  0.2159D+03,  0.2172D+03   &
         /
       data (TREF(36, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2122D+03,  0.2113D+03,  0.2105D+03,  0.2153D+03,   &
         0.2202D+03,  0.2250D+03,  0.2234D+03,  0.2216D+03,   &
         0.2198D+03,  0.2176D+03,  0.2154D+03,  0.2131D+03   &
         /
       data (TREF(36, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2076D+03,  0.2063D+03,  0.2050D+03,  0.2121D+03,   &
         0.2193D+03,  0.2264D+03,  0.2250D+03,  0.2237D+03,   &
         0.2223D+03,  0.2178D+03,  0.2133D+03,  0.2089D+03   &
         /
       data (TREF(36, 5, mtmp), mtmp=1,12)   &
         /   &
         0.2056D+03,  0.2047D+03,  0.2039D+03,  0.2098D+03,   &
         0.2158D+03,  0.2217D+03,  0.2213D+03,  0.2209D+03,   &
         0.2203D+03,  0.2157D+03,  0.2111D+03,  0.2064D+03   &
         /
       data (TREF(36, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2082D+03,  0.2091D+03,  0.2099D+03,  0.2117D+03,   &
         0.2137D+03,  0.2156D+03,  0.2163D+03,  0.2169D+03,   &
         0.2175D+03,  0.2142D+03,  0.2108D+03,  0.2075D+03   &
         /
       data (TREF(36, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2119D+03,  0.2147D+03,  0.2175D+03,  0.2152D+03,   &
         0.2129D+03,  0.2106D+03,  0.2115D+03,  0.2123D+03,   &
         0.2132D+03,  0.2118D+03,  0.2105D+03,  0.2091D+03   &
         /
       data (TREF(36, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2123D+03,  0.2155D+03,  0.2189D+03,  0.2152D+03,   &
         0.2115D+03,  0.2077D+03,  0.2080D+03,  0.2083D+03,   &
         0.2086D+03,  0.2087D+03,  0.2088D+03,  0.2089D+03   &
         /
       data (TREF(36, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2096D+03,  0.2116D+03,  0.2136D+03,  0.2113D+03,   &
         0.2090D+03,  0.2068D+03,  0.2073D+03,  0.2079D+03,   &
         0.2083D+03,  0.2081D+03,  0.2078D+03,  0.2075D+03   &
         /
       data (TREF(36,10, mtmp), mtmp=1,12)   &
         /   &
         0.2073D+03,  0.2078D+03,  0.2084D+03,  0.2081D+03,   &
         0.2078D+03,  0.2075D+03,  0.2096D+03,  0.2115D+03,   &
         0.2136D+03,  0.2113D+03,  0.2091D+03,  0.2068D+03   &
         /
       data (TREF(36,11, mtmp), mtmp=1,12)   &
         /   &
         0.2080D+03,  0.2083D+03,  0.2086D+03,  0.2087D+03,   &
         0.2088D+03,  0.2088D+03,  0.2122D+03,  0.2155D+03,   &
         0.2189D+03,  0.2152D+03,  0.2115D+03,  0.2076D+03   &
         /
       data (TREF(36,12, mtmp), mtmp=1,12)   &
         /   &
         0.2114D+03,  0.2123D+03,  0.2132D+03,  0.2118D+03,   &
         0.2105D+03,  0.2091D+03,  0.2119D+03,  0.2147D+03,   &
         0.2175D+03,  0.2178D+03,  0.2129D+03,  0.2106D+03   &
         /
       data (TREF(36,13, mtmp), mtmp=1,12)   &
         /   &
         0.2162D+03,  0.2169D+03,  0.2176D+03,  0.2142D+03,   &
         0.2108D+03,  0.2075D+03,  0.2082D+03,  0.2091D+03,   &
         0.2099D+03,  0.2117D+03,  0.2137D+03,  0.2156D+03   &
         /
       data (TREF(36,14, mtmp), mtmp=1,12)   &
         /   &
         0.2213D+03,  0.2208D+03,  0.2203D+03,  0.2157D+03,   &
         0.2111D+03,  0.2063D+03,  0.2056D+03,  0.2047D+03,   &
         0.2039D+03,  0.2098D+03,  0.2158D+03,  0.2218D+03   &
         /
       data (TREF(36,15, mtmp), mtmp=1,12)   &
         /   &
         0.2250D+03,  0.2237D+03,  0.2223D+03,  0.2179D+03,   &
         0.2133D+03,  0.2089D+03,  0.2076D+03,  0.2063D+03,   &
         0.2050D+03,  0.2122D+03,  0.2193D+03,  0.2263D+03   &
         /
       data (TREF(36,16, mtmp), mtmp=1,12)   &
         /   &
         0.2233D+03,  0.2216D+03,  0.2198D+03,  0.2177D+03,   &
         0.2155D+03,  0.2131D+03,  0.2122D+03,  0.2113D+03,   &
         0.2105D+03,  0.2153D+03,  0.2202D+03,  0.2250D+03   &
         /
       data (TREF(36,17, mtmp), mtmp=1,12)   &
         /   &
         0.2173D+03,  0.2154D+03,  0.2133D+03,  0.2146D+03,   &
         0.2159D+03,  0.2172D+03,  0.2163D+03,  0.2156D+03,   &
         0.2149D+03,  0.2164D+03,  0.2179D+03,  0.2193D+03   &
         /
       data (TREF(36,18, mtmp), mtmp=1,12)   &
         /   &
         0.2144D+03,  0.2121D+03,  0.2101D+03,  0.2131D+03,   &
         0.2162D+03,  0.2192D+03,  0.2182D+03,  0.2174D+03,   &
         0.2165D+03,  0.2165D+03,  0.2166D+03,  0.2165D+03   &
         /
       data (TREF(37, 1, mtmp), mtmp=1,12)   &
         /   &
         0.2091D+03,  0.2096D+03,  0.2100D+03,  0.2121D+03,   &
         0.2140D+03,  0.2160D+03,  0.2140D+03,  0.2119D+03,   &
         0.2100D+03,  0.2097D+03,  0.2092D+03,  0.2087D+03   &
         /
       data (TREF(37, 2, mtmp), mtmp=1,12)   &
         /   &
         0.2075D+03,  0.2079D+03,  0.2084D+03,  0.2117D+03,   &
         0.2149D+03,  0.2181D+03,  0.2163D+03,  0.2144D+03,   &
         0.2126D+03,  0.2108D+03,  0.2090D+03,  0.2072D+03   &
         /
       data (TREF(37, 3, mtmp), mtmp=1,12)   &
         /   &
         0.2040D+03,  0.2041D+03,  0.2040D+03,  0.2102D+03,   &
         0.2164D+03,  0.2225D+03,  0.2210D+03,  0.2194D+03,   &
         0.2178D+03,  0.2132D+03,  0.2086D+03,  0.2041D+03   &
         /
       data (TREF(37, 4, mtmp), mtmp=1,12)   &
         /   &
         0.2005D+03,  0.2000D+03,  0.1995D+03,  0.2075D+03,   &
         0.2153D+03,  0.2233D+03,  0.2220D+03,  0.2206D+03,   &
         0.2192D+03,  0.2132D+03,  0.2071D+03,  0.2010D+03   &
         /
       data (TREF(37, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1999D+03,  0.1998D+03,  0.1999D+03,  0.2061D+03,   &
         0.2123D+03,  0.2185D+03,  0.2180D+03,  0.2174D+03,   &
         0.2167D+03,  0.2112D+03,  0.2056D+03,  0.2000D+03   &
         /
       data (TREF(37, 6, mtmp), mtmp=1,12)   &
         /   &
         0.2037D+03,  0.2049D+03,  0.2063D+03,  0.2082D+03,   &
         0.2102D+03,  0.2124D+03,  0.2129D+03,  0.2135D+03,   &
         0.2142D+03,  0.2103D+03,  0.2064D+03,  0.2025D+03   &
         /
       data (TREF(37, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2080D+03,  0.2108D+03,  0.2135D+03,  0.2116D+03,   &
         0.2097D+03,  0.2078D+03,  0.2086D+03,  0.2095D+03,   &
         0.2104D+03,  0.2087D+03,  0.2070D+03,  0.2052D+03   &
         /
       data (TREF(37, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2088D+03,  0.2118D+03,  0.2148D+03,  0.2118D+03,   &
         0.2088D+03,  0.2058D+03,  0.2059D+03,  0.2060D+03,   &
         0.2062D+03,  0.2060D+03,  0.2058D+03,  0.2057D+03   &
         /
       data (TREF(37, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2070D+03,  0.2085D+03,  0.2102D+03,  0.2085D+03,   &
         0.2070D+03,  0.2054D+03,  0.2055D+03,  0.2055D+03,   &
         0.2056D+03,  0.2056D+03,  0.2054D+03,  0.2054D+03   &
         /
       data (TREF(37,10, mtmp), mtmp=1,12)   &
         /   &
         0.2054D+03,  0.2055D+03,  0.2057D+03,  0.2055D+03,   &
         0.2055D+03,  0.2054D+03,  0.2070D+03,  0.2085D+03,   &
         0.2101D+03,  0.2085D+03,  0.2070D+03,  0.2054D+03   &
         /
       data (TREF(37,11, mtmp), mtmp=1,12)   &
         /   &
         0.2059D+03,  0.2060D+03,  0.2061D+03,  0.2060D+03,   &
         0.2058D+03,  0.2057D+03,  0.2088D+03,  0.2118D+03,   &
         0.2148D+03,  0.2118D+03,  0.2088D+03,  0.2058D+03   &
         /
       data (TREF(37,12, mtmp), mtmp=1,12)   &
         /   &
         0.2086D+03,  0.2095D+03,  0.2104D+03,  0.2087D+03,   &
         0.2069D+03,  0.2052D+03,  0.2080D+03,  0.2107D+03,   &
         0.2134D+03,  0.2139D+03,  0.2096D+03,  0.2078D+03   &
         /
       data (TREF(37,13, mtmp), mtmp=1,12)   &
         /   &
         0.2130D+03,  0.2135D+03,  0.2142D+03,  0.2103D+03,   &
         0.2064D+03,  0.2025D+03,  0.2037D+03,  0.2049D+03,   &
         0.2063D+03,  0.2082D+03,  0.2103D+03,  0.2124D+03   &
         /
       data (TREF(37,14, mtmp), mtmp=1,12)   &
         /   &
         0.2180D+03,  0.2174D+03,  0.2168D+03,  0.2111D+03,   &
         0.2056D+03,  0.2000D+03,  0.2000D+03,  0.1999D+03,   &
         0.1998D+03,  0.2061D+03,  0.2123D+03,  0.2185D+03   &
         /
       data (TREF(37,15, mtmp), mtmp=1,12)   &
         /   &
         0.2219D+03,  0.2206D+03,  0.2192D+03,  0.2131D+03,   &
         0.2071D+03,  0.2011D+03,  0.2005D+03,  0.2000D+03,   &
         0.1996D+03,  0.2075D+03,  0.2153D+03,  0.2233D+03   &
         /
       data (TREF(37,16, mtmp), mtmp=1,12)   &
         /   &
         0.2210D+03,  0.2193D+03,  0.2177D+03,  0.2132D+03,   &
         0.2086D+03,  0.2041D+03,  0.2040D+03,  0.2041D+03,   &
         0.2041D+03,  0.2102D+03,  0.2164D+03,  0.2225D+03   &
         /
       data (TREF(37,17, mtmp), mtmp=1,12)   &
         /   &
         0.2162D+03,  0.2144D+03,  0.2125D+03,  0.2107D+03,   &
         0.2090D+03,  0.2072D+03,  0.2075D+03,  0.2079D+03,   &
         0.2084D+03,  0.2116D+03,  0.2149D+03,  0.2181D+03   &
         /
       data (TREF(37,18, mtmp), mtmp=1,12)   &
         /   &
         0.2140D+03,  0.2120D+03,  0.2100D+03,  0.2096D+03,   &
         0.2092D+03,  0.2088D+03,  0.2091D+03,  0.2096D+03,   &
         0.2101D+03,  0.2121D+03,  0.2139D+03,  0.2160D+03   &
         /
       data (TREF(38, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1999D+03,  0.2018D+03,  0.2036D+03,  0.2075D+03,   &
         0.2115D+03,  0.2154D+03,  0.2136D+03,  0.2118D+03,   &
         0.2100D+03,  0.2062D+03,  0.2022D+03,  0.1983D+03   &
         /
       data (TREF(38, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1986D+03,  0.2003D+03,  0.2019D+03,  0.2069D+03,   &
         0.2120D+03,  0.2169D+03,  0.2152D+03,  0.2135D+03,   &
         0.2119D+03,  0.2069D+03,  0.2020D+03,  0.1972D+03   &
         /
       data (TREF(38, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1958D+03,  0.1966D+03,  0.1976D+03,  0.2052D+03,   &
         0.2125D+03,  0.2201D+03,  0.2186D+03,  0.2172D+03,   &
         0.2156D+03,  0.2087D+03,  0.2019D+03,  0.1950D+03   &
         /
       data (TREF(38, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1934D+03,  0.1937D+03,  0.1942D+03,  0.2028D+03,   &
         0.2115D+03,  0.2201D+03,  0.2188D+03,  0.2174D+03,   &
         0.2161D+03,  0.2084D+03,  0.2008D+03,  0.1930D+03   &
         /
       data (TREF(38, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1942D+03,  0.1950D+03,  0.1959D+03,  0.2023D+03,   &
         0.2089D+03,  0.2153D+03,  0.2146D+03,  0.2138D+03,   &
         0.2132D+03,  0.2066D+03,  0.2002D+03,  0.1936D+03   &
         /
       data (TREF(38, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1992D+03,  0.2009D+03,  0.2027D+03,  0.2048D+03,   &
         0.2068D+03,  0.2090D+03,  0.2096D+03,  0.2102D+03,   &
         0.2108D+03,  0.2064D+03,  0.2020D+03,  0.1975D+03   &
         /
       data (TREF(38, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2041D+03,  0.2069D+03,  0.2095D+03,  0.2080D+03,   &
         0.2065D+03,  0.2049D+03,  0.2058D+03,  0.2067D+03,   &
         0.2077D+03,  0.2056D+03,  0.2035D+03,  0.2013D+03   &
         /
       data (TREF(38, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2053D+03,  0.2080D+03,  0.2108D+03,  0.2085D+03,   &
         0.2062D+03,  0.2040D+03,  0.2039D+03,  0.2038D+03,   &
         0.2038D+03,  0.2034D+03,  0.2029D+03,  0.2026D+03   &
         /
       data (TREF(38, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2046D+03,  0.2056D+03,  0.2067D+03,  0.2059D+03,   &
         0.2050D+03,  0.2041D+03,  0.2037D+03,  0.2033D+03,   &
         0.2029D+03,  0.2031D+03,  0.2032D+03,  0.2034D+03   &
         /
       data (TREF(38,10, mtmp), mtmp=1,12)   &
         /   &
         0.2037D+03,  0.2034D+03,  0.2030D+03,  0.2031D+03,   &
         0.2033D+03,  0.2034D+03,  0.2045D+03,  0.2056D+03,   &
         0.2067D+03,  0.2058D+03,  0.2050D+03,  0.2041D+03   &
         /
       data (TREF(38,11, mtmp), mtmp=1,12)   &
         /   &
         0.2039D+03,  0.2039D+03,  0.2037D+03,  0.2034D+03,   &
         0.2029D+03,  0.2026D+03,  0.2053D+03,  0.2080D+03,   &
         0.2108D+03,  0.2085D+03,  0.2062D+03,  0.2040D+03   &
         /
       data (TREF(38,12, mtmp), mtmp=1,12)   &
         /   &
         0.2058D+03,  0.2067D+03,  0.2077D+03,  0.2056D+03,   &
         0.2034D+03,  0.2014D+03,  0.2041D+03,  0.2068D+03,   &
         0.2095D+03,  0.2099D+03,  0.2064D+03,  0.2049D+03   &
         /
       data (TREF(38,13, mtmp), mtmp=1,12)   &
         /   &
         0.2096D+03,  0.2102D+03,  0.2107D+03,  0.2064D+03,   &
         0.2020D+03,  0.1975D+03,  0.1992D+03,  0.2009D+03,   &
         0.2027D+03,  0.2048D+03,  0.2069D+03,  0.2090D+03   &
         /
       data (TREF(38,14, mtmp), mtmp=1,12)   &
         /   &
         0.2146D+03,  0.2139D+03,  0.2132D+03,  0.2066D+03,   &
         0.2002D+03,  0.1936D+03,  0.1943D+03,  0.1951D+03,   &
         0.1958D+03,  0.2023D+03,  0.2088D+03,  0.2153D+03   &
         /
       data (TREF(38,15, mtmp), mtmp=1,12)   &
         /   &
         0.2187D+03,  0.2174D+03,  0.2161D+03,  0.2084D+03,   &
         0.2008D+03,  0.1931D+03,  0.1934D+03,  0.1938D+03,   &
         0.1941D+03,  0.2028D+03,  0.2114D+03,  0.2201D+03   &
         /
       data (TREF(38,16, mtmp), mtmp=1,12)   &
         /   &
         0.2186D+03,  0.2171D+03,  0.2156D+03,  0.2088D+03,   &
         0.2018D+03,  0.1950D+03,  0.1958D+03,  0.1967D+03,   &
         0.1976D+03,  0.2051D+03,  0.2126D+03,  0.2200D+03   &
         /
       data (TREF(38,17, mtmp), mtmp=1,12)   &
         /   &
         0.2152D+03,  0.2135D+03,  0.2118D+03,  0.2069D+03,   &
         0.2020D+03,  0.1971D+03,  0.1986D+03,  0.2003D+03,   &
         0.2019D+03,  0.2069D+03,  0.2119D+03,  0.2170D+03   &
         /
       data (TREF(38,18, mtmp), mtmp=1,12)   &
         /   &
         0.2136D+03,  0.2118D+03,  0.2100D+03,  0.2061D+03,   &
         0.2022D+03,  0.1983D+03,  0.2000D+03,  0.2018D+03,   &
         0.2036D+03,  0.2076D+03,  0.2114D+03,  0.2154D+03   &
         /
       data (TREF(39, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1907D+03,  0.1940D+03,  0.1973D+03,  0.2031D+03,   &
         0.2090D+03,  0.2148D+03,  0.2132D+03,  0.2116D+03,   &
         0.2100D+03,  0.2026D+03,  0.1952D+03,  0.1879D+03   &
         /
       data (TREF(39, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1898D+03,  0.1926D+03,  0.1955D+03,  0.2022D+03,   &
         0.2090D+03,  0.2157D+03,  0.2142D+03,  0.2126D+03,   &
         0.2111D+03,  0.2031D+03,  0.1951D+03,  0.1872D+03   &
         /
       data (TREF(39, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1875D+03,  0.1894D+03,  0.1913D+03,  0.2000D+03,   &
         0.2088D+03,  0.2176D+03,  0.2163D+03,  0.2149D+03,   &
         0.2136D+03,  0.2043D+03,  0.1952D+03,  0.1858D+03   &
         /
       data (TREF(39, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1863D+03,  0.1875D+03,  0.1888D+03,  0.1982D+03,   &
         0.2076D+03,  0.2171D+03,  0.2157D+03,  0.2143D+03,   &
         0.2130D+03,  0.2037D+03,  0.1945D+03,  0.1853D+03   &
         /
       data (TREF(39, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1887D+03,  0.1901D+03,  0.1918D+03,  0.1986D+03,   &
         0.2053D+03,  0.2121D+03,  0.2113D+03,  0.2104D+03,   &
         0.2096D+03,  0.2021D+03,  0.1947D+03,  0.1872D+03   &
         /
       data (TREF(39, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1947D+03,  0.1968D+03,  0.1991D+03,  0.2013D+03,   &
         0.2035D+03,  0.2057D+03,  0.2063D+03,  0.2067D+03,   &
         0.2073D+03,  0.2024D+03,  0.1975D+03,  0.1925D+03   &
         /
       data (TREF(39, 7, mtmp), mtmp=1,12)   &
         /   &
         0.2002D+03,  0.2029D+03,  0.2056D+03,  0.2044D+03,   &
         0.2032D+03,  0.2021D+03,  0.2030D+03,  0.2039D+03,   &
         0.2049D+03,  0.2025D+03,  0.2000D+03,  0.1974D+03   &
         /
       data (TREF(39, 8, mtmp), mtmp=1,12)   &
         /   &
         0.2018D+03,  0.2043D+03,  0.2068D+03,  0.2052D+03,   &
         0.2037D+03,  0.2021D+03,  0.2019D+03,  0.2016D+03,   &
         0.2013D+03,  0.2007D+03,  0.2000D+03,  0.1995D+03   &
         /
       data (TREF(39, 9, mtmp), mtmp=1,12)   &
         /   &
         0.2021D+03,  0.2026D+03,  0.2033D+03,  0.2032D+03,   &
         0.2030D+03,  0.2028D+03,  0.2019D+03,  0.2011D+03,   &
         0.2002D+03,  0.2007D+03,  0.2010D+03,  0.2013D+03   &
         /
       data (TREF(39,10, mtmp), mtmp=1,12)   &
         /   &
         0.2019D+03,  0.2011D+03,  0.2003D+03,  0.2006D+03,   &
         0.2010D+03,  0.2013D+03,  0.2020D+03,  0.2026D+03,   &
         0.2033D+03,  0.2031D+03,  0.2029D+03,  0.2028D+03   &
         /
       data (TREF(39,11, mtmp), mtmp=1,12)   &
         /   &
         0.2018D+03,  0.2017D+03,  0.2014D+03,  0.2007D+03,   &
         0.2000D+03,  0.1994D+03,  0.2018D+03,  0.2043D+03,   &
         0.2068D+03,  0.2052D+03,  0.2037D+03,  0.2021D+03   &
         /
       data (TREF(39,12, mtmp), mtmp=1,12)   &
         /   &
         0.2031D+03,  0.2039D+03,  0.2049D+03,  0.2025D+03,   &
         0.2000D+03,  0.1975D+03,  0.2002D+03,  0.2029D+03,   &
         0.2056D+03,  0.2060D+03,  0.2032D+03,  0.2021D+03   &
         /
       data (TREF(39,13, mtmp), mtmp=1,12)   &
         /   &
         0.2063D+03,  0.2067D+03,  0.2073D+03,  0.2024D+03,   &
         0.1975D+03,  0.1925D+03,  0.1947D+03,  0.1969D+03,   &
         0.1991D+03,  0.2013D+03,  0.2035D+03,  0.2057D+03   &
         /
       data (TREF(39,14, mtmp), mtmp=1,12)   &
         /   &
         0.2113D+03,  0.2105D+03,  0.2096D+03,  0.2021D+03,   &
         0.1946D+03,  0.1871D+03,  0.1886D+03,  0.1902D+03,   &
         0.1918D+03,  0.1985D+03,  0.2054D+03,  0.2121D+03   &
         /
       data (TREF(39,15, mtmp), mtmp=1,12)   &
         /   &
         0.2156D+03,  0.2143D+03,  0.2130D+03,  0.2037D+03,   &
         0.1945D+03,  0.1852D+03,  0.1864D+03,  0.1875D+03,   &
         0.1888D+03,  0.1982D+03,  0.2075D+03,  0.2170D+03   &
         /
       data (TREF(39,16, mtmp), mtmp=1,12)   &
         /   &
         0.2162D+03,  0.2148D+03,  0.2135D+03,  0.2043D+03,   &
         0.1951D+03,  0.1859D+03,  0.1875D+03,  0.1894D+03,   &
         0.1913D+03,  0.1999D+03,  0.2087D+03,  0.2176D+03   &
         /
       data (TREF(39,17, mtmp), mtmp=1,12)   &
         /   &
         0.2142D+03,  0.2126D+03,  0.2111D+03,  0.2031D+03,   &
         0.1951D+03,  0.1870D+03,  0.1898D+03,  0.1926D+03,   &
         0.1955D+03,  0.2021D+03,  0.2090D+03,  0.2158D+03   &
         /
       data (TREF(39,18, mtmp), mtmp=1,12)   &
         /   &
         0.2132D+03,  0.2116D+03,  0.2100D+03,  0.2026D+03,   &
         0.1952D+03,  0.1877D+03,  0.1909D+03,  0.1941D+03,   &
         0.1973D+03,  0.2031D+03,  0.2090D+03,  0.2148D+03   &
         /
       data (TREF(40, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1707D+03,  0.1861D+03,  0.1909D+03,  0.1989D+03,   &
         0.2067D+03,  0.2142D+03,  0.2128D+03,  0.2113D+03,   &
         0.2098D+03,  0.1992D+03,  0.1882D+03,  0.1776D+03   &
         /
       data (TREF(40, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1807D+03,  0.1847D+03,  0.1889D+03,  0.1974D+03,   &
         0.2062D+03,  0.2146D+03,  0.2131D+03,  0.2117D+03,   &
         0.2102D+03,  0.1993D+03,  0.1881D+03,  0.1777D+03   &
         /
       data (TREF(40, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1798D+03,  0.1823D+03,  0.1847D+03,  0.1949D+03,   &
         0.2049D+03,  0.2151D+03,  0.2140D+03,  0.2127D+03,   &
         0.2114D+03,  0.2000D+03,  0.1883D+03,  0.1770D+03   &
         /
       data (TREF(40, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1791D+03,  0.1818D+03,  0.1834D+03,  0.1939D+03,   &
         0.2039D+03,  0.2138D+03,  0.2126D+03,  0.2113D+03,   &
         0.2099D+03,  0.1991D+03,  0.1882D+03,  0.1773D+03   &
         /
       data (TREF(40, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1832D+03,  0.1856D+03,  0.1877D+03,  0.1949D+03,   &
         0.2020D+03,  0.2090D+03,  0.2081D+03,  0.2071D+03,   &
         0.2060D+03,  0.1977D+03,  0.1894D+03,  0.1810D+03   &
         /
       data (TREF(40, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1905D+03,  0.1931D+03,  0.1956D+03,  0.1977D+03,   &
         0.2000D+03,  0.2023D+03,  0.2028D+03,  0.2034D+03,   &
         0.2040D+03,  0.1986D+03,  0.1933D+03,  0.1878D+03   &
         /
       data (TREF(40, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1965D+03,  0.1992D+03,  0.2019D+03,  0.2010D+03,   &
         0.2001D+03,  0.1992D+03,  0.2001D+03,  0.2012D+03,   &
         0.2021D+03,  0.1995D+03,  0.1966D+03,  0.1938D+03   &
         /
       data (TREF(40, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1985D+03,  0.2008D+03,  0.2030D+03,  0.2021D+03,   &
         0.2012D+03,  0.2002D+03,  0.1999D+03,  0.1994D+03,   &
         0.1990D+03,  0.1982D+03,  0.1973D+03,  0.1964D+03   &
         /
       data (TREF(40, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1995D+03,  0.1998D+03,  0.2002D+03,  0.2007D+03,   &
         0.2010D+03,  0.2015D+03,  0.2002D+03,  0.1989D+03,   &
         0.1978D+03,  0.1983D+03,  0.1988D+03,  0.1994D+03   &
         /
       data (TREF(40,10, mtmp), mtmp=1,12)   &
         /   &
         0.2002D+03,  0.1989D+03,  0.1978D+03,  0.1983D+03,   &
         0.1988D+03,  0.1994D+03,  0.1996D+03,  0.2000D+03,   &
         0.2002D+03,  0.2006D+03,  0.2010D+03,  0.2015D+03   &
         /
       data (TREF(40,11, mtmp), mtmp=1,12)   &
         /   &
         0.1999D+03,  0.1994D+03,  0.1990D+03,  0.1982D+03,   &
         0.1973D+03,  0.1965D+03,  0.1986D+03,  0.2008D+03,   &
         0.2029D+03,  0.2021D+03,  0.2012D+03,  0.2003D+03   &
         /
       data (TREF(40,12, mtmp), mtmp=1,12)   &
         /   &
         0.2002D+03,  0.2012D+03,  0.2022D+03,  0.1995D+03,   &
         0.1966D+03,  0.1938D+03,  0.1966D+03,  0.1992D+03,   &
         0.2019D+03,  0.2018D+03,  0.2001D+03,  0.1991D+03   &
         /
       data (TREF(40,13, mtmp), mtmp=1,12)   &
         /   &
         0.2028D+03,  0.2034D+03,  0.2040D+03,  0.1986D+03,   &
         0.1932D+03,  0.1878D+03,  0.1905D+03,  0.1931D+03,   &
         0.1956D+03,  0.1977D+03,  0.2000D+03,  0.2023D+03   &
         /
       data (TREF(40,14, mtmp), mtmp=1,12)   &
         /   &
         0.2078D+03,  0.2070D+03,  0.2061D+03,  0.1977D+03,   &
         0.1893D+03,  0.1810D+03,  0.1832D+03,  0.1856D+03,   &
         0.1877D+03,  0.1949D+03,  0.2019D+03,  0.2088D+03   &
         /
       data (TREF(40,15, mtmp), mtmp=1,12)   &
         /   &
         0.2126D+03,  0.2112D+03,  0.2098D+03,  0.1992D+03,   &
         0.1884D+03,  0.1775D+03,  0.1792D+03,  0.1818D+03,   &
         0.1834D+03,  0.1939D+03,  0.2039D+03,  0.2139D+03   &
         /
       data (TREF(40,16, mtmp), mtmp=1,12)   &
         /   &
         0.2138D+03,  0.2127D+03,  0.2114D+03,  0.1999D+03,   &
         0.1886D+03,  0.1767D+03,  0.1798D+03,  0.1825D+03,   &
         0.1847D+03,  0.1951D+03,  0.2052D+03,  0.2152D+03   &
         /
       data (TREF(40,17, mtmp), mtmp=1,12)   &
         /   &
         0.2131D+03,  0.2117D+03,  0.2102D+03,  0.1992D+03,   &
         0.1883D+03,  0.1776D+03,  0.1811D+03,  0.1849D+03,   &
         0.1888D+03,  0.1973D+03,  0.2059D+03,  0.2145D+03   &
         /
       data (TREF(40,18, mtmp), mtmp=1,12)   &
         /   &
         0.2128D+03,  0.2114D+03,  0.2098D+03,  0.1990D+03,   &
         0.1884D+03,  0.1780D+03,  0.1816D+03,  0.1863D+03,   &
         0.1908D+03,  0.1987D+03,  0.2065D+03,  0.2143D+03   &
         /
       data (TREF(41, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(41, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(41, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(41, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(41, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(41, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(41, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(41, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(41, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(41,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(41,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(41,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(41,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(41,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(41,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(41,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(41,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(41,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(42, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(42, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(42, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(42, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(42, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(42, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(42, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(42, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(42, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(42,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(42,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(42,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(42,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(42,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(42,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(42,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(42,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(42,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(43, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(43, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(43, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(43, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(43, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(43, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(43, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(43, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(43, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(43,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(43,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(43,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(43,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(43,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(43,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(43,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(43,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(43,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(44, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(44, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(44, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(44, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(44, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(44, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(44, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(44, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(44, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(44,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(44,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(44,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(44,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(44,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(44,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(44,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(44,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(44,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(45, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(45, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(45, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(45, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(45, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(45, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(45, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(45, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(45, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(45,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(45,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(45,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(45,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(45,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(45,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(45,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(45,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(45,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(46, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(46, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(46, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(46, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(46, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(46, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(46, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(46, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(46, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(46,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(46,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(46,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(46,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(46,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(46,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(46,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(46,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(46,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(47, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(47, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(47, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(47, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(47, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(47, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(47, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(47, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(47, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(47,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(47,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(47,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(47,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(47,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(47,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(47,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(47,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(47,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(48, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(48, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(48, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(48, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(48, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(48, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(48, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(48, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(48, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(48,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(48,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(48,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(48,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(48,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(48,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(48,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(48,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(48,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(49, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(49, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(49, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(49, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(49, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(49, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(49, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(49, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(49, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(49,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(49,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(49,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(49,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(49,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(49,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(49,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(49,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(49,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(50, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(50, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(50, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(50, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(50, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(50, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(50, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(50, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(50, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(50,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(50,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(50,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(50,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(50,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(50,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(50,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(50,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(50,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
       data (TREF(51, 1, mtmp), mtmp=1,12)   &
         /   &
         0.1704D+03,  0.1817D+03,  0.1871D+03,  0.1960D+03,   &
         0.2050D+03,  0.2142D+03,  0.2125D+03,  0.2107D+03,   &
         0.2091D+03,  0.1960D+03,  0.1833D+03,  0.1600D+03   &
         /
       data (TREF(51, 2, mtmp), mtmp=1,12)   &
         /   &
         0.1690D+03,  0.1804D+03,  0.1854D+03,  0.1951D+03,   &
         0.2045D+03,  0.2141D+03,  0.2125D+03,  0.2107D+03,   &
         0.2089D+03,  0.1960D+03,  0.1833D+03,  0.1590D+03   &
         /
       data (TREF(51, 3, mtmp), mtmp=1,12)   &
         /   &
         0.1662D+03,  0.1778D+03,  0.1819D+03,  0.1925D+03,   &
         0.2036D+03,  0.2143D+03,  0.2125D+03,  0.2109D+03,   &
         0.2092D+03,  0.1962D+03,  0.1834D+03,  0.1702D+03   &
         /
       data (TREF(51, 4, mtmp), mtmp=1,12)   &
         /   &
         0.1747D+03,  0.1775D+03,  0.1813D+03,  0.1913D+03,   &
         0.2019D+03,  0.2125D+03,  0.2110D+03,  0.2089D+03,   &
         0.2071D+03,  0.1951D+03,  0.1832D+03,  0.1713D+03   &
         /
       data (TREF(51, 5, mtmp), mtmp=1,12)   &
         /   &
         0.1792D+03,  0.1825D+03,  0.1865D+03,  0.1934D+03,   &
         0.2005D+03,  0.2076D+03,  0.2059D+03,  0.2048D+03,   &
         0.2032D+03,  0.1939D+03,  0.1848D+03,  0.1756D+03   &
         /
       data (TREF(51, 6, mtmp), mtmp=1,12)   &
         /   &
         0.1872D+03,  0.1903D+03,  0.1938D+03,  0.1963D+03,   &
         0.1986D+03,  0.2009D+03,  0.2011D+03,  0.2011D+03,   &
         0.2012D+03,  0.1954D+03,  0.1897D+03,  0.1839D+03   &
         /
       data (TREF(51, 7, mtmp), mtmp=1,12)   &
         /   &
         0.1938D+03,  0.1965D+03,  0.1993D+03,  0.1986D+03,   &
         0.1979D+03,  0.1974D+03,  0.1983D+03,  0.1991D+03,   &
         0.1998D+03,  0.1969D+03,  0.1939D+03,  0.1911D+03   &
         /
       data (TREF(51, 8, mtmp), mtmp=1,12)   &
         /   &
         0.1963D+03,  0.1984D+03,  0.2007D+03,  0.1999D+03,   &
         0.1991D+03,  0.1984D+03,  0.1981D+03,  0.1977D+03,   &
         0.1973D+03,  0.1962D+03,  0.1953D+03,  0.1943D+03   &
         /
       data (TREF(51, 9, mtmp), mtmp=1,12)   &
         /   &
         0.1979D+03,  0.1980D+03,  0.1983D+03,  0.1989D+03,   &
         0.1993D+03,  0.1998D+03,  0.1986D+03,  0.1974D+03,   &
         0.1962D+03,  0.1967D+03,  0.1971D+03,  0.1976D+03   &
         /
       data (TREF(51,10, mtmp), mtmp=1,12)   &
         /   &
         0.1987D+03,  0.1975D+03,  0.1962D+03,  0.1967D+03,   &
         0.1971D+03,  0.1976D+03,  0.1978D+03,  0.1980D+03,   &
         0.1984D+03,  0.1988D+03,  0.1993D+03,  0.1998D+03   &
         /
       data (TREF(51,11, mtmp), mtmp=1,12)   &
         /   &
         0.1981D+03,  0.1977D+03,  0.1973D+03,  0.1963D+03,   &
         0.1953D+03,  0.1942D+03,  0.1964D+03,  0.1985D+03,   &
         0.2007D+03,  0.1998D+03,  0.1991D+03,  0.1984D+03   &
         /
       data (TREF(51,12, mtmp), mtmp=1,12)   &
         /   &
         0.1983D+03,  0.1990D+03,  0.1998D+03,  0.1970D+03,   &
         0.1939D+03,  0.1910D+03,  0.1938D+03,  0.1966D+03,   &
         0.1993D+03,  0.1988D+03,  0.1980D+03,  0.1975D+03   &
         /
       data (TREF(51,13, mtmp), mtmp=1,12)   &
         /   &
         0.2010D+03,  0.2011D+03,  0.2012D+03,  0.1954D+03,   &
         0.1897D+03,  0.1839D+03,  0.1872D+03,  0.1904D+03,   &
         0.1938D+03,  0.1963D+03,  0.1986D+03,  0.2009D+03   &
         /
       data (TREF(51,14, mtmp), mtmp=1,12)   &
         /   &
         0.2062D+03,  0.2047D+03,  0.2031D+03,  0.1940D+03,   &
         0.1847D+03,  0.1756D+03,  0.1791D+03,  0.1826D+03,   &
         0.1864D+03,  0.1934D+03,  0.2006D+03,  0.2077D+03   &
         /
       data (TREF(51,15, mtmp), mtmp=1,12)   &
         /   &
         0.2108D+03,  0.2090D+03,  0.2071D+03,  0.1950D+03,   &
         0.1830D+03,  0.1711D+03,  0.1748D+03,  0.1774D+03,   &
         0.1812D+03,  0.1913D+03,  0.2021D+03,  0.2128D+03   &
         /
       data (TREF(51,16, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2109D+03,  0.2093D+03,  0.1961D+03,   &
         0.1831D+03,  0.1705D+03,  0.1651D+03,  0.1775D+03,   &
         0.1818D+03,  0.1921D+03,  0.2031D+03,  0.2141D+03   &
         /
       data (TREF(51,17, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2107D+03,  0.2089D+03,  0.1960D+03,   &
         0.1831D+03,  0.1701D+03,  0.1676D+03,  0.1803D+03,   &
         0.1854D+03,  0.1951D+03,  0.2047D+03,  0.2143D+03   &
         /
       data (TREF(51,18, mtmp), mtmp=1,12)   &
         /   &
         0.2125D+03,  0.2106D+03,  0.2090D+03,  0.1961D+03,   &
         0.1831D+03,  0.1577D+03,  0.1691D+03,  0.1817D+03,   &
         0.1872D+03,  0.1962D+03,  0.2052D+03,  0.2142D+03   &
         /
         
        end module module_fastj_data 
