

    MODULE module_wave_data

      implicit none

      integer, parameter :: dp = selected_real_kind(14,300)

!-------------------------------------------------------
!     public interfaces
!-------------------------------------------------------
      public :: r01, r04, r44, r08, r06, r10, r11, r14, r15, r17, r18, &
                wave_data_inti, xs_mvk, xs_macr

!-------------------------------------------------------
!     private interfaces
!-------------------------------------------------------
      private :: r44_inti, r08_inti

!-------------------------------------------------------
!     public variables
!-------------------------------------------------------
      integer, public, parameter :: nw = 18
      integer, public, parameter :: nj = 56
!     integer, public, parameter :: tuv_jmax = 28
      integer, public, parameter :: tuv_jmax = 30

      real(dp), public :: sflx(nw), wl(nw), wc(nw), wu(nw), deltaw(nw)
      real(dp), public :: xso3(nw), s226(nw), s263(nw), s298(nw)
      real(dp), public :: c20(5,tuv_jmax), c40(5,tuv_jmax), c60(5,tuv_jmax), c80(5,tuv_jmax)

      real(dp), public, allocatable :: sq(:,:,:)

!-------------------------------------------------------
!     private variables
!-------------------------------------------------------
      real(dp), private :: r01g1(nw), r01g2(nw), r01g3(nw), r01g4(nw)
      real(dp), private :: r04g(nw) 
      real(dp), private :: r08g(nw) 
      real(dp), private :: r06g1(nw), r06g2(nw) 
      real(dp), private :: r10g1(nw), r10g2(nw), r10g3(nw), r10g4(nw), r10g5(nw)
      real(dp), private :: r11g(nw), r11g1(nw), r11g2(nw), r11g3(nw), r11g4(nw)
      real(dp), private :: r14g(nw), r14g1(nw), r14g2(nw)
      real(dp), private :: r15g(nw), r15g1(nw), r15g2(nw), r15g3(nw)
      real(dp), private :: r17g(nw), r17g1(nw)
      real(dp), private :: r18g(nw), r18g2(nw)

      real(dp), private :: sjref(nw,nj)

      real(dp), private :: acrolein_xs(nw)

      real(dp), private, allocatable :: a(:), b(:)
      real(dp), private, allocatable :: suma(:), sumb(:)

      integer, private :: ii, kk

!-------------------------------------------------------
! NOTE wavelength
!-------------------------------------------------------
      data (wl(ii),ii=1,18)/  &
            0.1786E+03_dp, 0.1800E+03_dp, 0.1830E+03_dp, 0.1870E+03_dp, 0.1920E+03_dp,  &
            0.1980E+03_dp, 0.2050E+03_dp, 0.2130E+03_dp, 0.2220E+03_dp, 0.2410E+03_dp,  &
            0.2899E+03_dp, 0.3055E+03_dp, 0.3135E+03_dp, 0.3375E+03_dp, 0.4200E+03_dp,  &
            0.4750E+03_dp, 0.7290E+03_dp, 0.7436E+03_dp /

      data (wc(ii),ii=1,17)/  &
            0.1793E+03_dp, 0.1815E+03_dp, 0.1850E+03_dp, 0.1895E+03_dp, 0.1950E+03_dp,  &
            0.2015E+03_dp, 0.2090E+03_dp, 0.2175E+03_dp, 0.2265E+03_dp, 0.2655E+03_dp,  &
            0.2977E+03_dp, 0.3095E+03_dp, 0.3255E+03_dp, 0.3788E+03_dp, 0.4475E+03_dp,  &
            0.6020E+03_dp, 0.7363E+03_dp /

      data (wu(ii),ii=1,17)/  &
            0.1800E+03_dp, 0.1830E+03_dp, 0.1870E+03_dp, 0.1920E+03_dp, 0.1980E+03_dp,  &
            0.2050E+03_dp, 0.2130E+03_dp, 0.2220E+03_dp, 0.2310E+03_dp, 0.2899E+03_dp,  &
            0.3055E+03_dp, 0.3135E+03_dp, 0.3375E+03_dp, 0.4200E+03_dp, 0.4750E+03_dp,  &
            0.7290E+03_dp, 0.7436E+03_dp /

      data (deltaw(ii),ii=1,17)/  &
            0.1265E+15_dp, 0.2744E+15_dp, 0.3729E+15_dp, 0.4774E+15_dp, 0.5896E+15_dp,  &
            0.7108E+15_dp, 0.8425E+15_dp, 0.9864E+15_dp, 0.1027E+16_dp, 0.6541E+16_dp,  &
            0.2340E+16_dp, 0.1248E+16_dp, 0.3936E+16_dp, 0.1575E+17_dp, 0.1240E+17_dp,  &
            0.7705E+17_dp, 0.5417E+16_dp /

!-------------------------------------------------------
! NOTE top solar flux (1-wl,2-flux)
!-------------------------------------------------------
      data (sflx(ii),ii=1,17)/  &
            0.1628E-02_dp, 0.2184E-02_dp, 0.2459E-02_dp, 0.3736E-02_dp, 0.5386E-02_dp,  &
            0.8259E-02_dp, 0.2115E-01_dp, 0.4013E-01_dp, 0.4934E-01_dp, 0.1674E+00_dp,  &
            0.5534E+00_dp, 0.6459E+00_dp, 0.8579E+00_dp, 0.9751E+00_dp, 0.1878E+01_dp,  &
            0.1706E+01_dp, 0.1301E+01_dp /

!-------------------------------------------------------
! NOTE O3 cross (wl,xso3,s226,s263,s298)
!-------------------------------------------------------
      data (xso3(ii),ii=1,17)/  &
            0.7858E-18_dp, 0.7516E-18_dp, 0.6632E-18_dp, 0.5325E-18_dp, 0.4089E-18_dp,  &
            0.3319E-18_dp, 0.4999E-18_dp, 0.1396E-17_dp, 0.5096E-17_dp, 0.7774E-17_dp,  &
            0.6241E-18_dp, 0.1152E-18_dp, 0.1831E-19_dp, 0.1494E-21_dp, 0.2066E-21_dp,  &
            0.2476E-20_dp, 0.4732E-21_dp /

      data (s226(ii),ii=1,17)/  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.2299E-18_dp, 0.7880E-17_dp,  &
            0.5887E-18_dp, 0.1018E-18_dp, 0.1533E-19_dp, 0.8263E-22_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp /

      data (s263(ii),ii=1,17)/  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.2284E-18_dp, 0.7854E-17_dp,  &
            0.6065E-18_dp, 0.1079E-18_dp, 0.1704E-19_dp, 0.1115E-21_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp /

      data (s298(ii),ii=1,17)/  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.2290E-18_dp, 0.7867E-17_dp,  &
            0.6320E-18_dp, 0.1176E-18_dp, 0.1945E-19_dp, 0.1497E-21_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp /

!-------------------------------------------------------
! NOTE temperature dependence of parameter
!-------------------------------------------------------

!-------------------------------------------------------
! O3 -> O2 + O(3P)
!-------------------------------------------------------
      data (r01g1(ii),ii=1,17)/  &
            0.9600E+00, 0.9600E+00, 0.9600E+00, 0.9600E+00, 0.9600E+00,  &
            0.9600E+00, 0.9600E+00, 0.9600E+00, 0.9600E+00, 0.9600E+00,  &
            0.9600E+00, 0.2747E+01, 0.1280E+02, 0.1120E+02, 0.1120E+02,  &
            0.1120E+02, 0.1120E+02 /

      data (r01g2(ii),ii=1,17)/  &
            0.5659E+01, 0.5659E+01, 0.5659E+01, 0.5659E+01, 0.5659E+01,  &
            0.5659E+01, 0.5659E+01, 0.5659E+01, 0.5659E+01, 0.5659E+01,  &
            0.5746E+01, 0.3976E+03, 0.1769E+04, 0.2065E+04, 0.2065E+04,  &
            0.2065E+04, 0.2065E+04 /

      data (r01g3(ii),ii=1,17)/  &
            0.7266E+03, 0.7147E+03, 0.6899E+03, 0.6698E+03, 0.6460E+03,  &
            0.6140E+03, 0.5968E+03, 0.5913E+03, 0.5606E+03, 0.5450E+03,  &
            0.5221E+03, 0.5096E+03, 0.4906E+03, 0.4668E+03, 0.4516E+03,  &
            0.4326E+03, 0.4158E+03 /

      data (r01g4(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! N2O5 -> NO3 + NO2
!-------------------------------------------------------
      data (r04g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.6227E-17, 0.6199E-17, 0.3001E-17, 0.1030E-17, 0.2288E-18,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! H2O2 -> 2 OH
!-------------------------------------------------------
      data (r08g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2614E-18, 0.5668E-18,  &
            0.4562E-18, 0.3673E-18, 0.2829E-18, 0.1749E-18, 0.4953E-19,  &
            0.8043E-20, 0.4051E-20, 0.1756E-20, 0.8721E-22, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HNO3 -> OH + NO2
!-------------------------------------------------------
      data (r06g1(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.3924E+03, 0.1386E+04, 0.1011E+04,  &
            0.4960E+03, 0.1419E+03, 0.2597E+02, 0.5679E+01, 0.1612E+01,  &
            0.3449E+00, 0.9030E-01, 0.1428E-01, 0.1162E-03, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r06g2(ii),ii=1,17)/  &
            0.1700E+01, 0.1700E+01, 0.1700E+01, 0.1700E+01, 0.1692E+01,  &
            0.1691E+01, 0.1919E+01, 0.2160E+01, 0.1902E+01, 0.1524E+01,  &
            0.2895E+01, 0.4240E+01, 0.7779E+01, 0.9579E+01, 0.9300E+01,  &
            0.9300E+01, 0.9300E+01 /

!-------------------------------------------------------
! HCHO -> H2 + CO
!-------------------------------------------------------
      data (r10g1(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.1401E-43, 0.1401E-44, 0.4764E-43, 0.0000E+00,  &
            0.0000E+00, 0.4764E-43, 0.1401E-44, 0.0000E+00, 0.0000E+00,  &
            0.4147E-33, 0.4147E-33 /

      data (r10g2(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2517E-22, 0.9677E-20,  &
            0.2944E-19, 0.2061E-19, 0.1965E-19, 0.2352E-20, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r10g3(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            -.6612E-23, 0.3843E-23, -.1605E-22, -.6776E-23, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r10g4(ii),ii=1,17)/  &
            0.3200E+00, 0.3200E+00, 0.3200E+00, 0.3200E+00, 0.3200E+00,  &
            0.3200E+00, 0.3200E+00, 0.3200E+00, 0.3200E+00, 0.4116E+00,  &
            0.7417E+00, 0.7470E+00, 0.4245E+00, 0.2078E-03, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r10g5(ii),ii=1,17)/  &
            0.4900E+00, 0.4900E+00, 0.4900E+00, 0.4900E+00, 0.4900E+00,  &
            0.4900E+00, 0.4900E+00, 0.4900E+00, 0.4900E+00, 0.4390E+00,  &
            0.2662E+00, 0.2596E+00, 0.5374E+00, 0.1096E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3CHO -> CH3CO + H
!-------------------------------------------------------
      data (r11g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.2360E-21, 0.5041E-21, 0.5357E-21, 0.2195E-20, 0.2829E-19,  &
            0.4195E-19, 0.2992E-19, 0.1144E-19, 0.1073E-21, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r11g1(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2833E+00,  &
            0.4510E+00, 0.2919E+00, 0.5863E-01, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r11g2(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1218E+00,  &
            0.1668E-02, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r11g3(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r11g4(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1528E+01, 0.4668E+01, 0.4616E+01, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3COCHO -> products
!-------------------------------------------------------
      data (r14g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.3316E-20, 0.1626E-19, 0.3444E-19,  &
            0.3923E-19, 0.2396E-19, 0.9245E-20, 0.3321E-19, 0.6271E-19,  &
            0.9944E-23, 0.0000E+00 /

      data (r14g1(ii),ii=1,17)/  &
            0.0000E+00, 0.2126E+01, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1401E-44, 0.0000E+00, 0.1401E-44, 0.2286E+01, 0.0000E+00,  &
            0.4204E-44, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2127E+01,  &
            0.1067E-07, 0.6409E-09 /

      data (r14g2(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3COCH3
!-------------------------------------------------------
      data (r15g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1636E-20, 0.1205E-20, 0.1660E-20, 0.6857E-20, 0.3884E-19,  &
            0.3123E-19, 0.1487E-19, 0.2983E-20, 0.5364E-23, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r15g1(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.8408E-44, 0.8408E-44, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r15g2(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r15g3(ii),ii=1,17)/  &
            0.1401E-44, 0.0000E+00, 0.0000E+00, 0.5605E-44, 0.0000E+00,  &
            0.0000E+00, 0.2278E+01, 0.0000E+00, 0.2285E+01, 0.1401E-44,  &
            0.0000E+00, 0.2286E+01, 0.0000E+00, 0.2275E+01, 0.2119E+01,  &
            0.0000E+00, 0.2275E+01 /

!-------------------------------------------------------
! CH3ONO2 -> CH3O+NO2
!-------------------------------------------------------
      data (r17g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1739E-19, 0.2671E-19,  &
            0.4845E-20, 0.1333E-20, 0.2144E-21, 0.8327E-24, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r17g1(ii),ii=1,17)/  &
            0.3350E-02, 0.3350E-02, 0.3350E-02, 0.3350E-02, 0.3350E-02,  &
            0.3350E-02, 0.3350E-02, 0.3350E-02, 0.3374E-02, 0.3214E-02,  &
            0.4746E-02, 0.6248E-02, 0.1142E-01, 0.1610E-01, 0.1610E-01,  &
            0.1610E-01, 0.1610E-01 /

!-------------------------------------------------------
! PAN + hv -> products
!-------------------------------------------------------
      data (r18g(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1385E-17,  &
            0.3352E-17, 0.2129E-17, 0.1113E-17, 0.4450E-18, 0.6841E-19,  &
            0.2748E-20, 0.7224E-21, 0.1850E-21, 0.4999E-23, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

      data (r18g2(ii),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.6283E-03,  &
            0.1183E-02, 0.7700E-03, 0.1256E-02, 0.2424E-02, 0.4971E-02,  &
            0.8197E-02, 0.9115E-02, 0.1055E-01, 0.1876E-02, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! O2 + hv -> O + O
!-------------------------------------------------------
      data (sjref(ii,01),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.3473E-23, 0.6642E-23, 0.5002E-23, 0.2480E-23, 0.4111E-25,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! O3 -> O2 + O(1D)
!-------------------------------------------------------
      data (sjref(ii,02),ii=1,17)/  &
            0.6836E-18, 0.6539E-18, 0.5770E-18, 0.4632E-18, 0.3557E-18,  &
            0.2887E-18, 0.4349E-18, 0.1214E-17, 0.4433E-17, 0.6838E-17,  &
            0.5868E-18, 0.7389E-19, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! O3 -> O2 + O(3P)
!-------------------------------------------------------
      data (sjref(ii,03),ii=1,17)/  &
            0.1022E-18, 0.9770E-19, 0.8622E-19, 0.6922E-19, 0.5315E-19,  &
            0.4314E-19, 0.6499E-19, 0.1814E-18, 0.6625E-18, 0.1022E-17,  &
            0.3088E-19, 0.3828E-19, 0.1810E-19, 0.1494E-21, 0.2066E-21,  &
            0.2476E-20, 0.4732E-21 /

!-------------------------------------------------------
! NO2 -> NO + O(3P)
!-------------------------------------------------------
      data (sjref(ii,04),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1808E-18, 0.4635E-18, 0.4744E-18, 0.2462E-18, 0.4284E-19,  &
            0.1225E-18, 0.1815E-18, 0.2798E-18, 0.4150E-18, 0.1583E-22,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! NO3 -> NO + O2
!-------------------------------------------------------
      data (sjref(ii,05),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.5840E-18, 0.0000E+00 /

!-------------------------------------------------------
! NO3 -> NO2 + O(3P)
!-------------------------------------------------------
      data (sjref(ii,06),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1024E-19, 0.2811E-18,  &
            0.1085E-17, 0.0000E+00 /

!-------------------------------------------------------
! N2O5 -> NO3 + NO + O
!-------------------------------------------------------
      data (sjref(ii,07),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.6227E-17, 0.6199E-17, 0.3001E-17, 0.8927E-18, 0.9888E-19,  &
            0.7750E-21, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! N2O5 -> NO3 + NO2
!-------------------------------------------------------
      data (sjref(ii,08),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1369E-18, 0.1299E-18,  &
            0.3999E-19, 0.1973E-19, 0.7371E-20, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! N2O + hv -> N2 + O(1
!-------------------------------------------------------
      data (sjref(ii,09),ii=1,17)/  &
            0.1417E-18, 0.1441E-18, 0.1366E-18, 0.1106E-18, 0.6920E-19,  &
            0.3004E-19, 0.8198E-20, 0.1335E-20, 0.4760E-22, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HO2 + hv -> OH + O
!-------------------------------------------------------
      data (sjref(ii,10),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1152E-19, 0.4251E-18,  &
            0.9602E-18, 0.1522E-17, 0.1892E-17, 0.1668E-17, 0.1727E-18,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! H2O2 -> 2 OH
!-------------------------------------------------------
      data (sjref(ii,11),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2614E-18, 0.5668E-18,  &
            0.4562E-18, 0.3673E-18, 0.2829E-18, 0.1749E-18, 0.4953E-19,  &
            0.7495E-20, 0.3722E-20, 0.1378E-20, 0.3749E-21, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HNO2 -> OH + NO
!-------------------------------------------------------
      data (sjref(ii,12),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.1047E-19, 0.6659E-19, 0.9813E-19, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HNO3 -> OH + NO2
!-------------------------------------------------------
      data (sjref(ii,13),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.3796E-17, 0.1341E-16, 0.9779E-17,  &
            0.4798E-17, 0.1367E-17, 0.2489E-18, 0.5471E-19, 0.1564E-19,  &
            0.3259E-20, 0.8310E-21, 0.1226E-21, 0.9635E-24, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HNO4 -> HO2 + NO2
!-------------------------------------------------------
      data (sjref(ii,14),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.3904E-17, 0.8071E-17,  &
            0.5075E-17, 0.2702E-17, 0.1419E-17, 0.7767E-18, 0.2486E-18,  &
            0.2041E-19, 0.5706E-20, 0.1144E-20, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! HCHO -> H + HCO
!-------------------------------------------------------
      data (sjref(ii,15),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.8056E-23, 0.3983E-20,  &
            0.2183E-19, 0.1541E-19, 0.8306E-20, 0.4813E-24, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH2O -> H2 + CO
!-------------------------------------------------------
      data (sjref(ii,16),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1234E-22, 0.4248E-20,  &
            0.7835E-20, 0.5357E-20, 0.1052E-19, 0.1582E-21, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3CHO -> CH3 + HCO
!-------------------------------------------------------
      data (sjref(ii,17),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.8013E-20,  &
            0.1853E-19, 0.8492E-20, 0.6520E-21, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3CHO -> CH4 + CO
!-------------------------------------------------------
      data (sjref(ii,18),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.3445E-20,  &
            0.6997E-22, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3CHO -> CH3CO + H
!-------------------------------------------------------
      data (sjref(ii,19),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! C2H5CHO -> C2H5 + HC
!-------------------------------------------------------
      data (sjref(ii,20),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.3277E-19, 0.2222E-19, 0.3489E-20, 0.1042E-24, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CHOCHO -> products
!-------------------------------------------------------
      data (sjref(ii,21),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.7555E-21, 0.7623E-20,  &
            0.1313E-19, 0.1112E-19, 0.3667E-21, 0.5683E-21, 0.1817E-20,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3COCHO -> products
!-------------------------------------------------------
      data (sjref(ii,22),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.1492E-20, 0.7317E-20, 0.1550E-19,  &
            0.1765E-19, 0.9996E-20, 0.3344E-20, 0.5892E-20, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3COCH3
!-------------------------------------------------------
      data (sjref(ii,23),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1636E-20, 0.1205E-20, 0.1660E-20, 0.6857E-20, 0.3884E-19,  &
            0.7735E-20, 0.9000E-21, 0.7830E-22, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3OOH -> CH3O + OH
!-------------------------------------------------------
      data (sjref(ii,24),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.1058E-18, 0.1847E-18, 0.9326E-19, 0.2451E-19,  &
            0.4842E-20, 0.2490E-20, 0.1101E-20, 0.9321E-22, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3ONO2 -> CH3O+NO2
!-------------------------------------------------------
      data (sjref(ii,25),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1627E-19, 0.2508E-19,  &
            0.4415E-20, 0.1180E-20, 0.1714E-21, 0.6073E-24, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! PAN + hv -> products
!-------------------------------------------------------
      data (sjref(ii,26),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1368E-17,  &
            0.3275E-17, 0.2097E-17, 0.1086E-17, 0.4244E-18, 0.6206E-19,  &
            0.2340E-20, 0.6042E-21, 0.1504E-21, 0.4819E-23, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! ClOO + hv -> Product
!-------------------------------------------------------
      data (sjref(ii,27),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.1431E-17, 0.1648E-16, 0.1280E-16,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! ClONO2 + hv -> Cl +
!-------------------------------------------------------
      data (sjref(ii,28),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.6062E-18,  &
            0.1691E-17, 0.1862E-17, 0.2042E-17, 0.1170E-17, 0.1932E-18,  &
            0.2182E-19, 0.9468E-20, 0.4360E-20, 0.1328E-20, 0.4907E-22,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! ClONO2 + hv -> ClO +
!-------------------------------------------------------
      data (sjref(ii,29),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.4041E-18,  &
            0.1127E-17, 0.1241E-17, 0.1361E-17, 0.7799E-18, 0.1288E-18,  &
            0.1455E-19, 0.6034E-20, 0.1653E-20, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CH3Cl + hv -> Produc
!-------------------------------------------------------
      data (sjref(ii,30),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.5782E-19, 0.1421E-18, 0.5267E-19,  &
            0.1384E-19, 0.2628E-20, 0.1801E-21, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CCl2O + hv -> Produc
!-------------------------------------------------------
      data (sjref(ii,31),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.1283E-17, 0.1195E-17, 0.5590E-18,  &
            0.2495E-18, 0.1489E-18, 0.1234E-18, 0.4404E-19, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CCl4 + hv -> Product
!-------------------------------------------------------
      data (sjref(ii,32),ii=1,17)/  &
            0.8434E-17, 0.6384E-17, 0.3864E-17, 0.1696E-17, 0.7502E-18,  &
            0.6283E-18, 0.4862E-18, 0.2369E-18, 0.4361E-19, 0.8880E-21,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CClFO + hv -> Produc
!-------------------------------------------------------
      data (sjref(ii,33),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.3825E-19, 0.1351E-18, 0.1255E-18,  &
            0.1216E-18, 0.1004E-18, 0.6294E-19, 0.1102E-19, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

!-------------------------------------------------------
! CF2O + hv -> Product
!-------------------------------------------------------
      data (sjref(ii,34),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.1339E-19, 0.4267E-19, 0.2636E-19,  &
            0.1225E-19, 0.4416E-20, 0.1115E-20, 0.9727E-22, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2ClCFCl2 (CFC-113)
      data (sjref(ii,35),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.8049E-18, 0.6998E-18, 0.3166E-18,  &
            0.9827E-19, 0.2275E-19, 0.3931E-20, 0.2737E-21, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2ClCF2Cl (CFC-114)
      data (sjref(ii,36),ii=1,17)/  &
            0.2880E-18, 0.2147E-18, 0.1310E-18, 0.6113E-19, 0.2178E-19,  &
            0.6132E-20, 0.1327E-20, 0.1991E-21, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF3CF2Cl (CFC-115) +
      data (sjref(ii,37),ii=1,17)/  &
            0.1660E-19, 0.1158E-19, 0.6494E-20, 0.3055E-20, 0.1155E-20,  &
            0.3346E-21, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CCl3F (CFC-11) + hv
      data (sjref(ii,38),ii=1,17)/  &
            0.3100E-17, 0.2925E-17, 0.2465E-17, 0.1838E-17, 0.1100E-17,  &
            0.5342E-18, 0.1850E-18, 0.4170E-19, 0.4090E-20, 0.3713E-22,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CCl2F2 (CFC-12) + hv
      data (sjref(ii,39),ii=1,17)/  &
            0.1806E-17, 0.1617E-17, 0.1205E-17, 0.6804E-18, 0.2623E-18,  &
            0.6733E-19, 0.1216E-19, 0.1473E-20, 0.9542E-22, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CH3CCl3 + hv -> Prod
      data (sjref(ii,40),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.1258E-17, 0.2007E-17, 0.1365E-17,  &
            0.7141E-18, 0.2853E-18, 0.7284E-19, 0.8014E-20, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF3CHCl2 (HCFC-123)
      data (sjref(ii,41),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2399E-18,  &
            0.7356E-19, 0.1688E-19, 0.3281E-20, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF3CHFCl (HCFC-124)
      data (sjref(ii,42),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2450E-20,  &
            0.7010E-21, 0.1547E-21, 0.3603E-22, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CH3CFCl2 (HCFC-141b)
      data (sjref(ii,43),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2974E-18, 0.4178E-18,  &
            0.1328E-18, 0.2962E-19, 0.4478E-20, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CH3CF2Cl (HCFC-142b)
      data (sjref(ii,44),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2907E-20,  &
            0.7364E-21, 0.1479E-21, 0.2526E-22, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF3CF2CHCl2 (HCFC-22
      data (sjref(ii,45),ii=1,17)/  &
            0.1790E-17, 0.1626E-17, 0.1283E-17, 0.8094E-18, 0.3940E-18,  &
            0.1395E-18, 0.3959E-19, 0.8927E-20, 0.8714E-21, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2ClCF2CHFCl (HCFC-
      data (sjref(ii,46),ii=1,17)/  &
            0.2464E-18, 0.1743E-18, 0.9730E-19, 0.4340E-19, 0.1599E-19,  &
            0.5669E-20, 0.1816E-20, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CHClF2 (HCFC-22) + h
      data (sjref(ii,47),ii=1,17)/  &
            0.2207E-19, 0.1453E-19, 0.7236E-20, 0.2882E-20, 0.9112E-21,  &
            0.2275E-21, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! BrONO2 + hv -> Br +
      data (sjref(ii,48),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.1007E-17, 0.1060E-17, 0.8014E-18, 0.5760E-18, 0.1392E-18,  &
            0.5338E-19, 0.3872E-19, 0.2723E-19, 0.1113E-19, 0.2644E-20,  &
            0.5404E-22, 0.0000E+00 /

! BrONO2 + hv -> BrO +
      data (sjref(ii,49),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.2465E-17, 0.2596E-17, 0.1962E-17, 0.1410E-17, 0.3407E-18,  &
            0.1307E-18, 0.9481E-19, 0.6667E-19, 0.2725E-19, 0.6474E-20,  &
            0.1323E-21, 0.0000E+00 /

! CH3Br + hv -> Produc
      data (sjref(ii,50),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1948E-18, 0.6517E-18,  &
            0.7879E-18, 0.6941E-18, 0.4525E-18, 0.1482E-18, 0.4843E-20,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CHBr3
      data (sjref(ii,51),ii=1,17)/  &
            0.3990E-17, 0.3990E-17, 0.3990E-17, 0.3912E-17, 0.3645E-17,  &
            0.4246E-17, 0.4651E-17, 0.5596E-17, 0.4158E-17, 0.8230E-18,  &
            0.8168E-20, 0.1454E-20, 0.1400E-21, 0.2931E-23, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF3Br (Halon-1301) +
      data (sjref(ii,52),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2792E-19, 0.8983E-19,  &
            0.1155E-18, 0.1202E-18, 0.8986E-19, 0.2972E-19, 0.8513E-21,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2BrCF2Br (Halon-24
      data (sjref(ii,53),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.4481E-18, 0.1200E-17,  &
            0.1227E-17, 0.1086E-17, 0.7878E-18, 0.3245E-18, 0.1949E-19,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2Br2 (Halon-1202)
      data (sjref(ii,54),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.4482E-18, 0.9550E-18,  &
            0.7511E-18, 0.1054E-17, 0.1957E-17, 0.2161E-17, 0.2699E-18,  &
            0.5915E-21, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! CF2BrCl (Halon-1211)
      data (sjref(ii,55),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.2109E-18, 0.7667E-18,  &
            0.1140E-17, 0.1178E-17, 0.9150E-18, 0.3996E-18, 0.3035E-19,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00 /

! Cl2 + hv -> Cl + Cl
      data (sjref(ii,56),ii=1,17)/  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
            0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.1341E-19,  &
            0.1068E-18, 0.1806E-18, 0.2395E-18, 0.8432E-19, 0.4492E-20,  &
            0.0000E+00, 0.0000E+00 /

! acolein cross sections
!     data (acrolein_xs(ii),ii=1,18)/  &
!           0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00,  &
!           0.0000E+00, 0.0000E+00, 0.0000E+00, 0.7242E-20, 0.6807E-20,  &
!           0.2450E-19, 0.3803E-19, 0.5302E-19, 0.1754E-19, 0.0000E+00,  &
!           0.0000E+00, 0.0000E+00, 0.0000E+00 /
!------------------------------------------------------------------
!	... updated from mz4.5
!------------------------------------------------------------------
      data (acrolein_xs(ii),ii=1,18)/  &
            0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
            0._dp, 0._dp, 0._dp, 3.253e-22_dp, 8.705e-21_dp, &
            3.255e-20_dp, 4.899e-20_dp, 6.26e-20_dp, 1.852e-20_dp, 0._dp, &
            0._dp, 0._dp, 0._dp /

!-------------------------------------------------------
! correction coef. for zenith=20
!-------------------------------------------------------
      data ((c20(ii,kk),ii=1,5),kk=1,30)/  &
            0.7070E+01_dp, 0.3759E+00_dp, -.1308E+01_dp, 0.2779E+00_dp, -.1295E-01_dp,  &
            0.3696E+02_dp, -.3947E+02_dp, 0.1206E+02_dp, -.1179E+01_dp, 0.3640E-01_dp,  &
            -.2446E+01_dp, -.1012E+01_dp, 0.2398E+00_dp, -.2085E-01_dp, 0.5971E-03_dp,  &
            0.1162E+02_dp, 0.4995E+00_dp, -.1370E+00_dp, 0.1473E-01_dp, -.5209E-03_dp,  &
            -.7467E+02_dp, -.4068E-01_dp, 0.3046E-02_dp, -.3493E-03_dp, 0.1300E-04_dp,  &
            0.3233E+01_dp, 0.2210E+00_dp, -.9869E-01_dp, 0.1192E-01_dp, -.4533E-03_dp,  &
            0.1156E+02_dp, -.8101E+01_dp, 0.1430E+01_dp, 0.6346E-01_dp, -.1035E-01_dp,  &
            0.2245E+02_dp, -.3740E+01_dp, 0.2204E+01_dp, -.2758E+00_dp, 0.1017E-01_dp,  &
            -.1997E+02_dp, 0.3596E+02_dp, -.1341E+02_dp, 0.1726E+01_dp, -.6627E-01_dp,  &
            0.2146E+02_dp, -.1454E+02_dp, 0.3728E+01_dp, -.3417E+00_dp, 0.1067E-01_dp,  &
            -.7225E+01_dp, -.1905E+02_dp, 0.3493E+01_dp, -.2899E+00_dp, 0.8709E-02_dp,  &
            0.7219E+01_dp, 0.1184E+01_dp, -.3897E+00_dp, 0.4558E-01_dp, -.1691E-02_dp,  &
            -.2406E+00_dp, -.2155E+01_dp, 0.1012E+01_dp, -.1102E+00_dp, 0.3265E-02_dp,  &
            0.6289E+01_dp, -.5259E+01_dp, 0.1010E+01_dp, -.9599E-01_dp, 0.2999E-02_dp,  &
            0.5790E+01_dp, 0.3564E+01_dp, -.9204E+00_dp, 0.7470E-01_dp, -.2067E-02_dp,  &
            -.7339E+01_dp, 0.8577E+01_dp, -.1439E+01_dp, 0.1715E+00_dp, -.6845E-02_dp,  &
            0.6873E+01_dp, 0.9925E+01_dp, -.1103E+01_dp, 0.3600E-01_dp, -.4397E-03_dp,  &
            0.2127E+03_dp, -.1728E+03_dp, 0.3302E+02_dp, -.2579E+01_dp, 0.7060E-01_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            -.2486E+01_dp, 0.1277E+02_dp, -.2734E+01_dp, 0.2094E+00_dp, -.5546E-02_dp,  &
            0.1594E+02_dp, 0.2352E+01_dp, -.5208E+00_dp, 0.4645E-01_dp, -.1468E-02_dp,  &
            -.8191E+01_dp, -.1325E+01_dp, 0.3376E+00_dp, -.3625E-01_dp, 0.1290E-02_dp,  &
!             58.88973_dp,   -67.7546_dp,    17.7761_dp,   -2.26103_dp,    0.10354_dp,  &
            0.1569E+02_dp, -.7515E+01_dp, 0.3110E+01_dp, -.3417E+00_dp, 0.1105E-01_dp,  &
            0.8295E+01_dp, -.4326E+01_dp, 0.7690E+00_dp, -.5752E-01_dp, 0.1458E-02_dp,  &
            0.8573E+01_dp, -.6433E+01_dp, 0.1910E+01_dp, -.1765E+00_dp, 0.4821E-02_dp,  &
            0.5567E+01_dp, -.3415E+01_dp, 0.9974E+00_dp, -.1327E+00_dp, 0.5125E-02_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp /

!-------------------------------------------------------
! correction coef. for zenith=40
!-------------------------------------------------------
      data ((c40(ii,kk),ii=1,5),kk=1,30)/  &
            -.1895E+00_dp, 0.1173E+02_dp, -.4908E+01_dp, 0.7820E+00_dp, -.3439E-01_dp,  &
            0.1962E+02_dp, -.2455E+02_dp, 0.9490E+01_dp, -.1049E+01_dp, 0.3501E-01_dp,  &
            -.3079E+01_dp, -.5048E+00_dp, 0.1277E+00_dp, -.1175E-01_dp, 0.3456E-03_dp,  &
            0.1153E+02_dp, 0.5407E+00_dp, -.1458E+00_dp, 0.1569E-01_dp, -.5555E-03_dp,  &
            -.7465E+02_dp, -.7051E-01_dp, 0.8473E-02_dp, -.9057E-03_dp, 0.3180E-04_dp,  &
            0.3155E+01_dp, 0.3559E+00_dp, -.1534E+00_dp, 0.1835E-01_dp, -.6973E-03_dp,  &
            0.2650E+02_dp, -.2605E+02_dp, 0.7603E+01_dp, -.5420E+00_dp, 0.7451E-02_dp,  &
            0.1966E+02_dp, 0.5411E-01_dp, 0.1362E+01_dp, -.2107E+00_dp, 0.8579E-02_dp,  &
            -.2380E+02_dp, 0.3767E+02_dp, -.1202E+02_dp, 0.1779E+01_dp, -.7717E-01_dp,  &
            0.2125E+02_dp, -.1242E+02_dp, 0.2822E+01_dp, -.1615E+00_dp, 0.1873E-02_dp,  &
            -.1070E+02_dp, -.1866E+02_dp, 0.3452E+01_dp, -.2876E+00_dp, 0.8628E-02_dp,  &
            0.6843E+01_dp, 0.1299E+01_dp, -.4284E+00_dp, 0.5045E-01_dp, -.1890E-02_dp,  &
            -.1506E+02_dp, 0.1398E+02_dp, -.2476E+01_dp, 0.1543E+00_dp, -.3430E-02_dp,  &
            0.2068E+01_dp, -.7057E+00_dp, -.1971E+00_dp, 0.9200E-02_dp, -.5000E-05_dp,  &
            0.5924E+01_dp, 0.4186E+01_dp, -.1217E+01_dp, 0.1055E+00_dp, -.3038E-02_dp,  &
            -.7911E+01_dp, 0.8992E+01_dp, -.1554E+01_dp, 0.1856E+00_dp, -.7309E-02_dp,  &
            0.5082E+01_dp, 0.1396E+02_dp, -.2272E+01_dp, 0.1452E+00_dp, -.3790E-02_dp,  &
            0.1701E+03_dp, -.1574E+03_dp, 0.3097E+02_dp, -.2461E+01_dp, 0.6813E-01_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            -.9485E+00_dp, 0.1351E+02_dp, -.3240E+01_dp, 0.2661E+00_dp, -.7396E-02_dp,  &
            0.1571E+02_dp, 0.2718E+01_dp, -.6571E+00_dp, 0.5990E-01_dp, -.1893E-02_dp,  &
            -.8311E+01_dp, -.1182E+01_dp, 0.3142E+00_dp, -.3576E-01_dp, 0.1336E-02_dp,  &
!             59.04684_dp,  -67.68378_dp,   17.67471_dp, -2.24201_dp,      0.10236_dp,  &
            0.4926E+01_dp, 0.3918E+01_dp, 0.3607E+00_dp, -.1143E+00_dp, 0.4793E-02_dp,  &
            0.6043E+01_dp, -.2715E+01_dp, 0.3730E+00_dp, -.2205E-01_dp, 0.3954E-03_dp,  &
            -.6693E-02_dp, 0.1872E+01_dp, -.8570E-01_dp, -.1044E-01_dp, 0.2336E-03_dp,  &
            0.5017E-01_dp, 0.4719E+01_dp, -.1084E+01_dp, 0.4456E-01_dp, 0.1960E-03_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp /

!-------------------------------------------------------
! correction coef. for zenith=60
!-------------------------------------------------------
      data ((c60(ii,kk),ii=1,5),kk=1,30)/  &
            -.1638E+02_dp, 0.3958E+02_dp, -.1606E+02_dp, 0.2488E+01_dp, -.1077E+00_dp,  &
            -.2315E+02_dp, 0.2426E+02_dp, -.2826E+01_dp, -.3649E-03_dp, 0.5939E-02_dp,  &
            -.3974E+01_dp, 0.3165E+00_dp, -.7318E-01_dp, 0.5292E-02_dp, -.1394E-03_dp,  &
            0.1136E+02_dp, 0.5802E+00_dp, -.1499E+00_dp, 0.1645E-01_dp, -.5966E-03_dp,  &
            -.7464E+02_dp, -.1207E+00_dp, 0.1455E-01_dp, -.1564E-02_dp, 0.5550E-04_dp,  &
            0.2808E+01_dp, 0.6323E+00_dp, -.2726E+00_dp, 0.3265E-01_dp, -.1250E-02_dp,  &
            0.6710E+02_dp, -.7909E+02_dp, 0.2461E+02_dp, -.2071E+01_dp, 0.4810E-01_dp,  &
            0.1837E+02_dp, 0.4619E+01_dp, 0.2547E+00_dp, -.1197E+00_dp, 0.6375E-02_dp,  &
            -.5101E+02_dp, 0.9591E+02_dp, -.3419E+02_dp, 0.5055E+01_dp, -.2158E+00_dp,  &
            -.4153E+01_dp, 0.2473E+02_dp, -.1137E+02_dp, 0.1819E+01_dp, -.7925E-01_dp,  &
            -.1660E+02_dp, -.1775E+02_dp, 0.3260E+01_dp, -.2704E+00_dp, 0.8049E-02_dp,  &
            0.5976E+01_dp, 0.1501E+01_dp, -.4931E+00_dp, 0.5883E-01_dp, -.2256E-02_dp,  &
            -.1125E+02_dp, 0.2029E+02_dp, -.5391E+01_dp, 0.4692E+00_dp, -.1363E-01_dp,  &
            0.4837E+00_dp, 0.2130E+01_dp, -.1477E+01_dp, 0.1459E+00_dp, -.4428E-02_dp,  &
            0.8633E+01_dp, 0.2963E+01_dp, -.1277E+01_dp, 0.1250E+00_dp, -.3843E-02_dp,  &
            -.8969E+01_dp, 0.9657E+01_dp, -.1778E+01_dp, 0.2186E+00_dp, -.8465E-02_dp,  &
            0.6672E+01_dp, 0.1784E+02_dp, -.3836E+01_dp, 0.3077E+00_dp, -.9108E-02_dp,  &
            0.6373E+02_dp, -.1009E+03_dp, 0.2045E+02_dp, -.1652E+01_dp, 0.4621E-01_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.6551E+01_dp, 0.1004E+02_dp, -.3142E+01_dp, 0.2893E+00_dp, -.8648E-02_dp,  &
            0.1623E+02_dp, 0.2482E+01_dp, -.7158E+00_dp, 0.6861E-01_dp, -.2212E-02_dp,  &
            -.7875E+01_dp, -.1366E+01_dp, 0.3688E+00_dp, -.4288E-01_dp, 0.1665E-02_dp,  &
!           60.2912_dp,     -68.21459_dp,   17.65838_dp,   -2.22646_dp,    0.10101_dp,  &
            -.9723E+01_dp, 0.2415E+02_dp, -.5494E+01_dp, 0.4353E+00_dp, -.1185E-01_dp,  &
            0.2494E+01_dp, -.1060E+00_dp, -.3462E+00_dp, 0.4881E-01_dp, -.1885E-02_dp,  &
            -.1241E+02_dp, 0.1633E+02_dp, -.4155E+01_dp, 0.3659E+00_dp, -.1103E-01_dp,  &
            0.3754E+01_dp, 0.4798E+01_dp, -.2051E+01_dp, 0.1749E+00_dp, -.4421E-02_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp /

!-------------------------------------------------------
! correction coef. for zenith=80
!-------------------------------------------------------
      data ((c80(ii,kk),ii=1,5),kk=1,30)/  &
            -.1932E+02_dp, 0.4848E+02_dp, -.1816E+02_dp, 0.2644E+01_dp, -.1113E+00_dp,  &
            0.1728E+02_dp, 0.8264E+01_dp, -.4332E+01_dp, 0.4240E+00_dp, -.1205E-01_dp,  &
            -.3679E+01_dp, 0.3203E+00_dp, -.2073E+00_dp, 0.2292E-01_dp, -.8063E-03_dp,  &
            0.1162E+02_dp, -.1252E+00_dp, 0.1497E+00_dp, -.1788E-01_dp, 0.6020E-03_dp,  &
            -.7465E+02_dp, -.3094E+00_dp, 0.2662E-01_dp, -.3132E-02_dp, 0.1261E-03_dp,  &
            0.1354E+01_dp, 0.1268E+01_dp, -.6397E+00_dp, 0.7837E-01_dp, -.3072E-02_dp,  &
            0.4900E+02_dp, -.4330E+02_dp, 0.1243E+02_dp, -.6545E+00_dp, -.3124E-02_dp,  &
            0.3719E+02_dp, -.5631E+01_dp, 0.2814E+01_dp, -.3031E+00_dp, 0.1144E-01_dp,  &
            -.4231E+02_dp, 0.1101E+03_dp, -.3837E+02_dp, 0.5405E+01_dp, -.2250E+00_dp,  &
            -.1008E+02_dp, 0.3177E+02_dp, -.1279E+02_dp, 0.1910E+01_dp, -.8098E-01_dp,  &
            -.2675E+02_dp, -.1888E+02_dp, 0.3767E+01_dp, -.3337E+00_dp, 0.1035E-01_dp,  &
            0.5699E+01_dp, -.2313E+00_dp, 0.1181E+00_dp, -.1085E-01_dp, 0.9490E-04_dp,  &
            0.1952E+02_dp, -.9656E+01_dp, 0.3008E+00_dp, 0.3705E-01_dp, -.1937E-02_dp,  &
            0.1146E+02_dp, -.1376E+02_dp, 0.1489E+01_dp, -.8155E-01_dp, 0.1865E-02_dp,  &
            0.1915E+02_dp, -.9104E+01_dp, 0.1121E+01_dp, -.5157E-01_dp, 0.7693E-03_dp,  &
            -.1538E+02_dp, 0.1580E+02_dp, -.3802E+01_dp, 0.4911E+00_dp, -.1826E-01_dp,  &
            0.3248E+02_dp, 0.1777E+01_dp, -.1424E+01_dp, 0.1013E+00_dp, -.2249E-02_dp,  &
            -.7258E+02_dp, -.1391E+02_dp, 0.2730E+01_dp, -.2204E+00_dp, 0.6206E-02_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.2933E+02_dp, -.1389E+02_dp, 0.1774E+01_dp, -.1105E+00_dp, 0.2751E-02_dp,  &
            0.2003E+02_dp, -.1591E+01_dp, 0.3060E-01_dp, 0.9648E-02_dp, -.5457E-03_dp,  &
            -.6542E+01_dp, -.2002E+01_dp, 0.5333E+00_dp, -.5663E-01_dp, 0.2222E-02_dp,  &
!           67.51654_dp,    -74.30246_dp,   19.69406_dp,   -2.53227_dp,     0.1171_dp,  &
            0.2831E+02_dp, -.4422E+01_dp, -.1020E+01_dp, 0.1347E+00_dp, -.4307E-02_dp,  &
            0.4106E+01_dp, -.4695E+01_dp, 0.8728E+00_dp, -.5511E-01_dp, 0.9340E-03_dp,  &
            0.1123E+02_dp, -.3881E+01_dp, -.7454E+00_dp, 0.1149E+00_dp, -.4054E-02_dp,  &
            0.2265E+02_dp, -.2158E+02_dp, 0.4002E+01_dp, -.3497E+00_dp, 0.1110E-01_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp,  &
            0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp, 0.0000E+00_dp /

      contains

      subroutine wave_data_inti( nz )

      implicit none

!-------------------------------------------------------
!     input arguments
!-------------------------------------------------------
      integer, intent(in) :: nz

!-------------------------------------------------------
!     local arguments
!-------------------------------------------------------
      integer :: astat, ij, iw

      if( .not. allocated(sq) ) then
!-------------------------------------------------------
!     allocate memory space
!-------------------------------------------------------
        allocate( sq(nw-1,nz,nj), stat=astat )
        if( astat /= 0 ) then
          write(*,*) 'wave_data_inti: sq allocate failed; error = ',astat
          stop
        end if

!-------------------------------------------------------
!     intialize sq
!-------------------------------------------------------
        do ij = 1, nj
          do iw = 1, nw-1
            sq(iw,:,ij) = sjref(iw,ij)
          enddo
        enddo

!-------------------------------------------------------
!	... initialize cross section functions
!-------------------------------------------------------
        call r44_inti
        call r08_inti
      endif

      end subroutine wave_data_inti

      subroutine r01( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide the product of (cross section) x (quantum yield) for the two
! o3 photolysis reactions:
! (a) o3 + hv -> o2 + o(1d)
! (b) o3 + hv -> o2 + o(3p)
! cross section: combined data from wmo 85 ozone assessment (use 273k
! value from 175.439-847.5 nm) and data from molina and
! molina (use in hartley and huggins bans (240.5-350 nm)
! quantum yield: choice between
! (1) data from michelsen et al, 1994
! (2) jpl 87 recommendation
! (3) jpl 90/92 recommendation (no "tail")
! (4) data from shetter et al., 1996
! (5) jpl 97 recommendation
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
! edit history:
! 05/98 original, adapted from former jspec1 subroutine
!-----------------------------------------------------------------------------
! this program is free software; you can redistribute it and/or modify
! it under the terms of the gnu general public license as published by the
! free software foundation; either version 2 of the license, or (at your
! option) any later version.
! the tuv package is distributed in the hope that it will be useful, but
! without any warranty; without even the implied warranty of merchantibi-
! lity or fitness for a particular purpose. see the gnu general public
! license for more details.
! free software foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      real(dp), parameter :: c0 = 12._dp/19._dp
      real(dp), parameter :: a1 = 0.887_dp
      real(dp), parameter :: a2 = 2.35_dp
      real(dp), parameter :: a3 = 57.0_dp
      real(dp), parameter :: wc1 = 302._dp
      real(dp), parameter :: wc2 = 311.1_dp
      real(dp), parameter :: wc3 = 313.9_dp
      real(dp), parameter :: v2 = 820.0_dp
      real(dp), parameter :: v3 = 1190.0_dp
      real(dp), parameter :: w1 = 7.9_dp
      real(dp), parameter :: w2 = 2.2_dp
      real(dp), parameter :: w3 = 7.4_dp
      real(dp), parameter :: xk = 0.695_dp

      integer  :: i, iw
      real(dp) :: qy1d, qy3p, so3, wrk, tinv
      logical  :: tl

!-----------------------------------------------------------------------------
! ... o3 photodissociation
!-----------------------------------------------------------------------------
      j = j + 1
      jlabel(j) = 'o3 -> o2 + o(1d)'
      j = j + 1
      jlabel(j) = 'o3 -> o2 + o(3p)'

level_loop : &
      do i = 1,nz
         tinv = 1./tlev(i)
         tl = tlev(i) < 263._dp
         if( tl ) then
            wrk = (tlev(i) - 226._dp)/(263._dp - 226._dp)
         else
            wrk = (tlev(i) - 263._dp)/(298._dp - 263._dp)
         end if
wave_loop : &
         do iw = 1,nw-1
            if( wl(iw) > 240.5_dp .and. wl(iw+1) < 350._dp ) then
               if( tl ) then
                  so3 = s226(iw) + (s263(iw) - s226(iw)) * wrk
               else
                  so3 = s263(iw) + (s298(iw) - s263(iw)) * wrk
               end if
            else
               so3 = xso3(iw)
            end if
!-----------------------------------------------------------------------------
! ... from jpl97
!-----------------------------------------------------------------------------
             if( wc(iw) < 271._dp ) then
                qy1d = .87_dp
             else if( wc(iw) >= 271._dp .and. wc(iw) < 290._dp ) then
                qy1d = .87_dp + (wc(iw) - 271._dp)*c0
             else if( wc(iw) >= 290._dp .and. wc(iw) < 305._dp ) then
                qy1d = .95_dp
             else if( wc(iw) >= 305._dp .and. wc(iw) <= 325._dp ) then
                qy1d = r01g1(iw) * exp ( -r01g2(iw)*tinv )
             else
                qy1d = 0._dp
             end if
!-------------------------------------------------------------------------------
! ... from jpl2000
!-------------------------------------------------------------------------------
             if( wc(iw) < 300._dp ) then
                qy1d = 0.95_dp
             else if( wc(iw) >= 300._dp .and. wc(iw) < 331._dp ) then
                qy1d = a1*exp( -((wc(iw) - wc1 )/w1)**4 ) &
                     + a2*(tlev(i)/300._dp)**4*exp( -v2/xk*tinv ) &
                    * exp( -((wc(iw) - wc2)/w2)**2 ) &
                     + a3*exp( -v3/xk*tinv ) * exp( -((wc(iw) - wc3)/w3)**2 ) &
                     + 0.06_dp
             else if( wc(iw) .ge. 331._dp .and. wc(iw) .lt. 345._dp ) then
                qy1d = 0.06_dp
             else
                qy1d = 0._dp
             end if

             qy1d = fo3qy( wc(iw), tlev(i) )

             sq(iw,i,j-1) = qy1d*so3
             qy3p       = 1._dp - qy1d
             sq(iw,i,j) = qy3p*so3
         end do wave_loop
      end do level_loop

      end subroutine r01

      function fo3qy( w, t )
!-----------------------------------------------------------------------------
!   PURPOSE:
! function to calculate the quantum yield O3 + hv -> O(1D) + O2,
! according to:                                                             
! Matsumi, Y., F. J. Comes, G. Hancock, A. Hofzumanhays, A. J. Hynes,
! M. Kawasaki, and A. R. Ravishankara, QUantum yields for production of O(1D)
! in the ultraviolet photolysis of ozone:  Recommendation based on evaluation
! of laboratory data, J. Geophys. Res., 107, 10.1029/2001JD000510, 2002.
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      real(dp), intent(in)  :: w
      real(dp), intent(in)  :: t

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      real(dp) :: kt
      real(dp) :: q1
      real(dp) :: q2 
      real(dp) :: tfac
      real(dp) :: a(3)  = (/ 0.8036_dp, 8.9061_dp, 0.1192_dp /)
      real(dp) :: x(3)  = (/ 304.225_dp, 314.957_dp, 310.737_dp /)
      real(dp) :: om(3) = (/ 5.576_dp, 6.601_dp, 2.187_dp /)

!-----------------------------------------------------------------------------
!	... function declarations
!-----------------------------------------------------------------------------
      real(dp) :: fo3qy
      
      fo3qy = 0._dp
      kt = 0.695_dp * t
      q1 = 1._dp
      q2 = exp( -825.518_dp/kt )
      
      if( w <= 305._dp ) then
         fo3qy = .90_dp
      else if( w > 305._dp .and. w <= 328._dp ) then
         tfac  = t/300._dp
         fo3qy = 0.0765_dp &
                + a(1)*           (q1/(q1+q2))*exp( -((x(1) - w)/om(1))**4 ) &
                + a(2)*(tfac)**2 *(q2/(q1+q2))*exp( -((x(2) - w)/om(2))**2 ) &
                + a(3)*(tfac)**1.5_dp         *exp( -((x(3) - w)/om(3))**2 )
      else if( w > 328._dp .and. w <= 340._dp ) then
         fo3qy = 0.08_dp
      else if( w > 340._dp ) then
         fo3qy = 0._dp
      end if

      end function fo3qy

      subroutine r04( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product of (cross section) x (quantum yiels) for n2o5 photolysis
! reactions:
! (a) n2o5 + hv -> no3 + no + o(3p)
! (b) n2o5 + hv -> no3 + no2
! cross section from jpl97: use tabulated values up to 280 nm, use expon.
! expression for >285nm, linearly interpolate
! between s(280) and s(285,t) in between
! quantum yield: analysis of data in jpl94 (->dataj1/yld/n2o5.qy)
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
! edit history:
! 05/98 original, adapted from former jspec1 subroutine
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in) :: nz
      integer, intent(inout) :: j
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      real(dp), parameter :: xs280 = 1.16999993e-19_dp

      integer  :: i, iw
      real(dp) :: qy
      real(dp) :: xs, xst285
      real(dp) :: t
!-----------------------------------------------------------------------------
! ... n2o5 photodissociation
!-----------------------------------------------------------------------------
      j = j + 1
      jlabel(j) = 'n2o5 -> no3 + no + o(3p)'
      j = j + 1
      jlabel(j) = 'n2o5 -> no3 + no2'
!-----------------------------------------------------------------------------
! ... cross section from jpl97, table up to 280 nm
! quantum yield : see dataj1/yld/n2o5.qy for explanation
! correct for t-dependence of cross section
!-----------------------------------------------------------------------------
      do i = 1,nz
!-----------------------------------------------------------------------------
! ... temperature dependence only valid for 225 - 300 k.
!-----------------------------------------------------------------------------
         t = 1./max( 225._dp,min( tlev(i),300._dp ) )
         do iw = 1,nw-1
            qy = max( 0._dp,min( 1._dp, 3.832441_dp - 0.012809638_dp * wc(iw) ) )
!-----------------------------------------------------------------------------
! ... evaluate exponential
!-----------------------------------------------------------------------------
            if( wl(iw) >= 285._dp .and. wl(iw+1) <= 380._dp ) then
               sq(iw,i,j-1) = qy * 1.e-20_dp*exp( 2.735_dp + (4728.5_dp - 17.127_dp*wc(iw)) * t )
               sq(iw,i,j) = (1._dp - qy) * 1.e-20_dp*exp( 2.735_dp + (4728.5_dp - 17.127_dp*wc(iw)) * t )
!-----------------------------------------------------------------------------
! ... between 280 and 285, interpolate between temperature evaluated exponential
! at 285 nm and the tabulated value at 280 nm.
!-----------------------------------------------------------------------------
            else if( wl(iw) >= 280._dp .and. wl(iw+1) <= 286._dp ) then
               xst285 = 1.e-20_dp* exp( 2.735_dp + (4728.5_dp - 17.127_dp*286._dp)*t )
               xs = xs280 + (wc(iw) - 280._dp)*(xst285 - xs280)/(286._dp - 280._dp)
               sq(iw,i,j-1) = qy * xs
               sq(iw,i,j)   = (1._dp - qy) * xs
!-----------------------------------------------------------------------------
! ... use tabulated values
!-----------------------------------------------------------------------------
            else if (wl(iw) <= 280._dp ) then
               sq(iw,i,j-1) = qy * r04g(iw)
               sq(iw,i,j)   = (1._dp - qy) * r04g(iw)
!-----------------------------------------------------------------------------
! ... beyond 380 nm, set to zero
!-----------------------------------------------------------------------------
            else
               sq(iw,i,j-1) = 0._dp
               sq(iw,i,j)   = 0._dp
            end if
         end do
      end do

      end subroutine r04

      subroutine r44_inti( )
!-----------------------------------------------------------------------------
! ... initialize subroutine r44
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
! ... cross sections according to jpl97 recommendation (identical to 94 rec.)
! see file dataj1/abs/n2o_jpl94.abs for detail
!-----------------------------------------------------------------------------
      real(dp), parameter :: a0 = 68.21023_dp
      real(dp), parameter :: a1 = -4.071805_dp
      real(dp), parameter :: a2 = 4.301146e-02_dp
      real(dp), parameter :: a3 = -1.777846e-04_dp
      real(dp), parameter :: a4 = 2.520672e-07_dp
      real(dp), parameter :: b0 = 123.4014_dp
      real(dp), parameter :: b1 = -2.116255_dp
      real(dp), parameter :: b2 = 1.111572e-02_dp
      real(dp), parameter :: b3 = -1.881058e-05_dp

      integer  :: iw, astat
      real(dp) :: lambda

      allocate( a(nw-1), b(nw-1), stat=astat )
      if( astat /= 0 ) then
         write(*,*) 'r44_inti: a,b allocate failed; error = ',astat
         stop
      end if
      do iw = 1,nw-1
         lambda = wc(iw)
         if( lambda >= 173._dp .and. lambda <= 240._dp ) then
            a(iw) = (((a4*lambda + a3)*lambda + a2)*lambda + a1)*lambda + a0
            b(iw) = ((b3*lambda + b2)*lambda + b1)*lambda + b0
         end if
      end do

      end subroutine r44_inti

      subroutine r44( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for n2o photolysis:
! n2o + hv -> n2 + o(1d)
! cross section: from jpl 97 recommendation
! quantum yield: assumed to be unity, based on greenblatt and ravishankara
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
! edit history:
! 05/98 original, adapted from former jspec1 subroutine
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer :: i
      real(dp) :: t
!-----------------------------------------------------------------------------
! ... n2o photodissociation
!-----------------------------------------------------------------------------
      j = j+1
      jlabel(j) = 'n2o + hv -> n2 + o(1d)'
!-----------------------------------------------------------------------------
! ... quantum yield of n(4s) and no(2pi) is less than 1% (greenblatt and
! ravishankara), so quantum yield of o(1d) is assumed to be unity
!-----------------------------------------------------------------------------
      do i = 1,nz
         t = max( 194._dp,min( tlev(i),320._dp ) ) - 300._dp
         where( wc(:nw-1) >= 173._dp .and. wc(:nw-1) <= 240._dp )
            sq(:nw-1,i,j) = exp( a(:nw-1) + t*exp( b(:nw-1) ) )
         elsewhere
            sq(:nw-1,i,j) = 0._dp
         endwhere
      end do

      end subroutine r44

      subroutine r08_inti( )
!-----------------------------------------------------------------------------
! ... initialize subroutine r08
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      real(dp), parameter :: a0 = 6.4761e+04_dp
      real(dp), parameter :: a1 = -9.2170972e+02_dp
      real(dp), parameter :: a2 = 4.535649_dp
      real(dp), parameter :: a3 = -4.4589016e-03_dp
      real(dp), parameter :: a4 = -4.035101e-05_dp
      real(dp), parameter :: a5 = 1.6878206e-07_dp
      real(dp), parameter :: a6 = -2.652014e-10_dp
      real(dp), parameter :: a7 = 1.5534675e-13_dp
      real(dp), parameter :: b0 = 6.8123e+03_dp
      real(dp), parameter :: b1 = -5.1351e+01_dp
      real(dp), parameter :: b2 = 1.1522e-01_dp
      real(dp), parameter :: b3 = -3.0493e-05_dp
      real(dp), parameter :: b4 = -1.0924e-07_dp

      integer  :: iw, astat
      real(dp) :: lambda

      allocate( suma(nw-1), sumb(nw-1), stat=astat )
      if( astat /= 0 ) then
         write(*,*) 'r08_inti: suma,sumb allocate failed; error = ',astat
         stop
      end if
      do iw = 1,nw-1
         if( wl(iw) >= 260._dp .and. wl(iw) < 350._dp ) then
            lambda = wc(iw)
            suma(iw) = ((((((a7*lambda + a6)*lambda + a5)*lambda + a4)*lambda +a3)*lambda + a2)*lambda + a1)*lambda + a0
            sumb(iw) = (((b4*lambda + b3)*lambda + b2)*lambda + b1)*lambda + b0
         end if
      end do

      end subroutine r08_inti

      subroutine r08( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product of (cross section) x (quantum yield) for h2o2 photolysis
! h2o2 + hv -> 2 oh
! cross section: from jpl97, tabulated values @ 298k for <260nm, t-depend.
! parameterization for 260-350nm
! quantum yield: assumed to be unity
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
! edit history:
! 05/98 original, adapted from former jspec1 subroutine
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer :: i
      real(dp) :: t
      real(dp) :: chi
!-----------------------------------------------------------------------------
! ... h2o2 photodissociation
! cross section from lin et al. 1978
!-----------------------------------------------------------------------------
      j = j + 1
      jlabel(j) = 'h2o2 -> 2 oh'
      do i = 1,nz
         t = 1._dp/min( max( tlev(i),200._dp ),400._dp )
         chi = 1._dp/(1._dp + exp( -1265._dp*t ))
!-----------------------------------------------------------------------------
! ... parameterization (jpl94)
! range 260-350 nm; 200-400 k
!-----------------------------------------------------------------------------
         where( wl(:nw-1) > 260._dp .and. wl(:nw-1) < 350._dp )
            sq(:nw-1,i,j) = (chi * suma(:nw-1) + (1._dp - chi)*sumb(:nw-1))*1.e-21_dp
         elsewhere
            sq(:nw-1,i,j) = r08g(:nw-1)
         endwhere
      end do

      end subroutine r08

      subroutine r06( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product of (cross section) x (quantum yield) for hno3 photolysis
! hno3 + hv -> oh + no2
! cross section: burkholder et al., 1993
! quantum yield: assumed to be unity
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: k
      real(dp) :: wrk
!-----------------------------------------------------------------------------
! ... hno3 photodissociation
!-----------------------------------------------------------------------------
       j = j + 1
       jlabel(j) = 'hno3 -> oh + no2'
!-----------------------------------------------------------------------------
! ... hno3 cross section parameters from burkholder et al. 1993
! quantum yield = 1
! correct for temperature dependence
!-----------------------------------------------------------------------------
      do k = 1,nz
         wrk = 1.e-3_dp*(tlev(k) - 298._dp)
         sq(:nw-1,k,j) = r06g1(:nw-1) * 1.e-20_dp * exp( r06g2(:nw-1)*wrk )
      end do

      end subroutine r06

      subroutine r10( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product of (cross section) x (quantum yield) for ch2o photolysis *
! (a) ch2o + hv -> h + hco
! (b) ch2o + hv -> h2 + co
! cross section: choice between
! 1) bass et al., 1980 (resolution: 0.025 nm)
! 2) moortgat and schneider (resolution: 1 nm)
! 3) cantrell et al. (orig res.) for > 301 nm,
! iupac 92, 97 elsewhere
! 4) cantrell et al. (2.5 nm res.) for > 301 nm,
! iupac 92, 97 elsewhere
! 5) rogers et al., 1990
! 6) new ncar recommendation, based on averages of
! cantrell et al., moortgat and schneider, and rogers
! et al.
! quantum yield: choice between
! 1) evaluation by madronich 1991 (unpublished)
! 2) iupac 89, 92, 97
! 3) madronich, based on 1), updated 1998.
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer, parameter :: mopt1 = 6
      integer, parameter :: mopt2 = 1
      real(dp), parameter :: c0 = 1._dp/70._dp

      integer  :: i, iw
      real(dp) :: phi1, phi2, phi20, ak300, akt
      real(dp) :: qy, qy1, qy2, qy3, t, t1
      real(dp) :: sigma, sig, slope
!-----------------------------------------------------------------------------
! ... ch2o photodissociatation
!-----------------------------------------------------------------------------
      j = j+1
      jlabel(j) = 'ch2o -> h + hco'
      j = j+1
      jlabel(j) = 'ch2o -> h2 + co'
!-----------------------------------------------------------------------------
! ... combine
! y1 = xsect
! y2 = xsect(223), cantrell et al.
! y3 = xsect(293), cantrell et al.
! y4 = qy for radical channel
! y5 = qy for molecular channel
! pressure and temperature dependent for w > 330.
!-----------------------------------------------------------------------------
      do i = 1,nz
         t = max( 223.15_dp,min( tlev(i),293.15_dp ) )
         t1 = airlev(i)
         do iw = 1,nw-1
            if( mopt1 == 6 ) then
               sig = r10g2(iw)
            else
               sig = r10g1(iw)
            end if
!-----------------------------------------------------------------------------
! ... correct cross section for temperature dependence for > 301. nm
!-----------------------------------------------------------------------------
            if( wl(iw) >= 301._dp ) then
               if( mopt1 == 3 .or. mopt1 == 6 ) then
                  sig = r10g2(iw) + r10g3(iw) * (t - 273.15_dp)
               else if( mopt1 == 4 ) then
                  slope = (r10g3(iw) - r10g2(iw)) * c0
                  slope = (r10g3(iw) - r10g2(iw)) * c0
                  sig = r10g2(iw) + slope * (t - 223._dp)
               end if
            end if
            sig = max( sig,0._dp )
!-----------------------------------------------------------------------------
! ... quantum yields:
! temperature and pressure dependence beyond 330 nm
!-----------------------------------------------------------------------------
            qy1 = r10g4(iw)
            if( wc(iw) >= 330._dp .and. r10g5(iw) > 0._dp ) then
               phi1 = r10g4(iw)
               phi2 = r10g5(iw)
               phi20 = 1._dp - phi1
               ak300 = ((phi20 - phi2)/(phi2*phi20))/2.54e+19_dp
               akt = ak300*(1. + 61.69_dp*(1._dp - tlev(i)/300._dp)*(wc(iw)/329._dp - 1._dp))
               qy2 = 1._dp / ((1._dp/phi20) + t1*akt)
            else
               qy2 = r10g5(iw)
            end if
            qy2 = max( 0._dp,qy2 )
            qy2 = min( 1._dp,qy2 )
            sq(iw,i,j-1) = sig * qy1
            sq(iw,i,j)   = sig * qy2
         end do
      end do

      end subroutine r10

      subroutine r11( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for ch3cho photolysis:
! (a) ch3cho + hv -> ch3 + hco
! (b) ch3cho + hv -> ch4 + co
! (c) ch3cho + hv -> ch3co + h
! cross section: choice between
! (1) iupac 97 data, from martinez et al.
! (2) calvert and pitts
! (3) martinez et al., table 1 scanned from paper
! (4) kfa tabulations
! quantum yields: choice between
! (1) iupac 97, pressure correction using horowith and
! calvert, 1982
! (2) ncar data file, from moortgat, 1986
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer, parameter  :: mabs = 3
      integer, parameter  :: myld = 1
      real(dp), parameter :: c0 = 1._dp/2.465e19_dp

      integer  :: i, iw
      real(dp) :: qy1, qy2, qy3
      real(dp) :: sig, t
!-----------------------------------------------------------------------------
! ... ch3cho photolysis
! 1: ch3 + hco
! 2: ch4 + co
! 3: ch3co + h
!-----------------------------------------------------------------------------
      j = j+1
      jlabel(j) = 'ch3cho -> ch3 + hco'
      j = j+1
      jlabel(j) = 'ch3cho -> ch4 + co'
      j = j+1
      jlabel(j) = 'ch3cho -> ch3co + h'
!-----------------------------------------------------------------------------
! ... options
! mabs for cross sections
! myld for quantum yields
!
! absorption:
! 1: iupac-97 data, from martinez et al.
! 2: calvert and pitts
! 3: martinez et al., table 1 scanned from paper
! 4: kfa tabulations, 6 choices, see file open statements
!
! quantum yield
! 1: dataj1/ch3cho/ch3cho_iup.yld
! pressure correction using horowitz and calvert 1982,
! based on slope/intercept of stern-volmer plots
!
! 2: ncar data file, from moortgat 1986.
!-----------------------------------------------------------------------------
      do i = 1,nz
         t = airlev(i)*c0
         do iw = 1,nw-1
            sig = r11g(iw)
            qy1 = r11g1(iw)
            qy2 = r11g2(iw)
            qy3 = r11g3(iw)
!-----------------------------------------------------------------------------
! ... pressure correction for channel 1, ch3 + cho
! based on horowitz and calvert 1982.
!-----------------------------------------------------------------------------
            qy1 = qy1 * (1._dp + r11g4(iw))/(1._dp + r11g4(iw)*t)
            qy1 = min( 1._dp,max( 0._dp,qy1 ) )
            sq(iw,i,j-2) = sig * qy1
            sq(iw,i,j-1) = sig * qy2
            sq(iw,i,j)   = sig * qy3
         end do
      end do

      end subroutine r11

      subroutine r14( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide the product (cross section) x (quantum yield) for ch3cocho
! photolysis:
! ch3cocho + hv -> products
!
! cross section: choice between
! (1) from meller et al., 1991, as tabulated by iupac 97
! 5 nm resolution (table 1) for < 402 nm
! 2 nm resolution (table 2) for > 402 nm
! (2) average at 1 nm of staffelbach et al., 1995, and
! meller et al., 1991
! (3) plum et al., 1983, as tabulated by kfa
! (4) meller et al., 1991 (0.033 nm res.), as tab. by kfa
! (5) meller et al., 1991 (1.0 nm res.), as tab. by kfa
! (6) staffelbach et al., 1995, as tabulated by kfa
! quantum yield: choice between
! (1) plum et al., fixed at 0.107
! (2) plum et al., divided by 2, fixed at 0.0535
! (3) staffelbach et al., 0.45 for < 300 nm, 0 for > 430 nm
! linear interp. in between
! (4) koch and moortgat, prv. comm., 1997
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      real(dp), parameter :: sig2 = .45_dp
      real(dp), parameter :: sig3 = 1._dp/130._dp

      integer  :: i, iw
      real(dp) :: phi0
      real(dp) :: kq
      real(dp) :: qy
!-----------------------------------------------------------------------------
! ... ch3cocho photolysis
!-----------------------------------------------------------------------------
      j = j+1
      jlabel(j) = 'ch3cocho -> products'
!-----------------------------------------------------------------------------
!           absorption:
!           1:  from meller et al. (1991), as tabulated by iupac-97
!               for wc < 402, use coarse data (5 nm, table 1)
!               for wc > 402, use finer data (2 nm, table 2)
!           2: average at 1nm of  staffelbach et al. 1995 and meller et al. 1991
!               cross section from kfa tables:
!           3: ch3cocho.001 - plum et al. 1983
!           4: ch3cocho.002 - meller et al. 1991, 0.033 nm resolution
!           5: ch3cocho.003 - meller et al. 1991, 1.0   nm resolution
!           6: ch3cocho.004 - staffelbach et al. 1995
!
!           quantum yield
!           1:  plum et al., 0.107
!           2:  plum et al., divided by two = 0.0535
!           3:  staffelbach et al., 0.45 at wc .le. 300, 0 for wc .gt. 430, linear 
!               interp in between
!           4:  koch and moortgat, prv. comm. 1997. - pressure-dependent
!         * 5:  Chen, Y., W. Wang, and L. Zhu, Wavelength-dependent photolysis of methylglyoxal
!         *      in the 290-440 nm region, J Phys Chem A, 104, 11126-11131, 2000
!-----------------------------------------------------------------------------
      do i = 1,nz
         do iw = 1,nw-1
            phi0 = 1._dp - (wc(iw) - 380._dp)/60._dp
            phi0 = max( 0._dp,min( phi0,1._dp ) )
            kq = 1.36e8_dp * exp( -8793._dp/wc(iw) )
            if( phi0 > 0._dp ) then
               if( wc(iw) >= 380._dp .and. wc(iw) <= 440._dp ) then
                  qy = phi0 / (phi0 + kq * airlev(i) * 760._dp/2.456e19_dp)
               else
                  qy = phi0
               end if
            else
               qy = 0._dp
            end if
            sq(iw,i,j) = r14g(iw) * qy
         end do
      end do

      end subroutine r14

      subroutine r15( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for ch3coch3 photolysis
! ch3coch3 + hv -> products
!
! cross section: choice between
! (1) calvert and pitts
! (2) martinez et al., 1991, alson in iupac 97
! (3) noaa, 1998, unpublished as of 01/98
! quantum yield: choice between
! (1) gardiner et al, 1984
! (2) iupac 97
! (3) mckeen et al., 1997
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer, parameter :: mabs = 2
      integer, parameter :: myld = 3

      integer :: i, iw
      real(dp) :: qy
      real(dp) :: sig
      real(dp) :: m, t, fco, fac, w

!-----------------------------------------------------------------------------
!	... ch3coch3 photodissociation
!-----------------------------------------------------------------------------
!           absorption:
!           1:  cross section from calvert and  pitts
!           2:  martinez et al. 1991, also in iupac97
!           3:  noaa 1998, unpublished as of jan 98.
!
!           quantum yield
!           1:  gardiner et al. 1984
!           2:  iupac 97
!           3:  mckeen, s. a., t. gierczak, j. b. burkholder, p. o. wennberg, t. f. hanisco,
!               e. r. keim, r.-s. gao, s. c. liu, a. r. ravishankara, and d. w. fahey, 
!               the photochemistry of acetone in the upper troposphere:  a source of 
!               odd-hydrogen radicals, geophys. res. lett., 24, 3177-3180, 1997.
!           4:  Blitz, M. A., D. E. Heard, M. J. Pilling, S. R. Arnold, and M. P. Chipperfield 
!              (2004), Pressure and temperature-dependent quantum yields for the 
!               photodissociation of acetone between 279 and 327.5 nm, Geophys. 
!               Res. Lett., 31, L06111, doi:10.1029/2003GL018793.
!-----------------------------------------------------------------------------
      j = j + 1
      jlabel(j) = 'ch3coch3 '

      do i = 1,nz
         m = airlev(i)
         t = tlev(i)
         do iw = 1,nw-1
            sig = r15g(iw)
            w   = wc(iw)
            call qyacet( w, t, m, fco, fac )
            qy = min( 1._dp,max( 0._dp,fac ) )
            sq(iw,i,j) = sig*qy
         end do
      end do

      end subroutine r15

      subroutine qyacet( w, t, m, fco, fac )
!-----------------------------------------------------------------------------
! Compute acetone quantum yields according to the parameterization of:
! Blitz, M. A., D. E. Heard, M. J. Pilling, S. R. Arnold, and M. P. Chipperfield 
!       (2004), Pressure and temperature-dependent quantum yields for the 
!       photodissociation of acetone between 279 and 327.5 nm, Geophys. 
!       Res. Lett., 31, L06111, doi:10.1029/2003GL018793.
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      real(dp), intent(in)  :: w            ! w = wavelength (nm)
      real(dp), intent(in)  :: t            ! T = temperature (K)
      real(dp), intent(in)  :: m            ! m = air number density (molec/cm^3)
      real(dp), intent(out) :: fco          ! fco = quantum yield for product CO
      real(dp), intent(out) :: fac          ! fac = quantum yield for product CH3CO (acetyl radical)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      real(dp) :: a0, a1, a2, a3, a4
      real(dp) :: b0, b1, b2, b3, b4
      real(dp) :: c3
      real(dp) :: cA0, cA1, cA2, cA3, cA4
      real(dp) :: twrk
      real(dp) :: fwrk

!-----------------------------------------------------------------------------
!** set out-of-range values:
! use low pressure limits for shorter wavelengths
! set to zero beyound 327.5
!-----------------------------------------------------------------------------
      if( w < 279._dp ) then
         fco = 0.05_dp
         fac = 0.95_dp
      else if( w > 327.5_dp ) then
         fco = 0._dp
         fac = 0._dp
      else
         twrk = t/295._dp
         fwrk = 1.e7_dp/w
!-----------------------------------------------------------------------------
!	... CO (carbon monoxide) quantum yields
!-----------------------------------------------------------------------------
         a0  = .350_dp * twrk**(-1.28_dp)
         b0  = .068_dp * twrk**(-2.65_dp)
         cA0 = exp( b0*(w - 248._dp) ) * a0 / (1._dp - a0)
         fco = 1._dp / (1._dp + cA0)
!-----------------------------------------------------------------------------
!	... CH3CO (acetyl radical) quantum yields:
!-----------------------------------------------------------------------------
         if( w >= 279._dp .and. w < 302._dp ) then
            a1  = 1.600e-19_dp * twrk**(-2.38_dp)
            b1  = 0.55e-3_dp   * twrk**(-3.19_dp)
            cA1 = a1 * exp( -b1*(fwrk - 33113._dp) )
            fac = (1._dp - fco) / (1._dp + cA1 * m)
         else if( w >= 302._dp .and. w < 327.5_dp ) then
            a2  = 1.62e-17_dp * twrk**(-10.03_dp)
            b2  = 1.79e-3_dp  * twrk**(-1.364_dp)
            cA2 = a2 * exp( -b2*(fwrk - 30488._dp) )
            a3  = 26.29_dp   * twrk**(-6.59_dp)
            b3  = 5.72e-7_dp * twrk**(-2.93_dp)
            c3  = 30006._dp   * twrk**(-0.064_dp)
            ca3 = a3 * exp( -b3*(fwrk - c3)**2._dp )
            a4  = 1.67e-15_dp * twrk**(-7.25_dp)
            b4  = 2.08e-3_dp  * twrk**(-1.16_dp)
            cA4 = a4 * exp( -b4*(fwrk - 30488._dp) )
            fac = (1._dp - fco) * (1._dp + cA3 + cA4 * m) &
                  /((1._dp + cA3 + cA2 * m)*(1._dp + cA4 * m))
         end if
      end if

      end subroutine qyacet

      subroutine r17( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for ch3ono2
! photolysis:
! ch3ono2 + hv -> ch3o + no2
!
! cross section: choice between
! (1) calvert and pitts, 1966
! (2) talukdar, burkholder, hunter, gilles, roberts,
! ravishankara, 1997
! (3) iupac 97, table of values for 198k
! (4) iupac 97, temperature-dependent equation
! (5) taylor et al, 1980
! (6) fit from roberts and fajer, 1989
! (7) rattigan et al., 1992
! (8) libuda and zabel, 1995
! quantum yield: assumed to be unity
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in) :: nz
      integer, intent(inout) :: j
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: i, iw
      real(dp) :: qy, t, sig
!-----------------------------------------------------------------------------
! ... ch3ono2 photodissociation
!-----------------------------------------------------------------------------
      j = j + 1
      jlabel(j) = 'ch3ono2 -> ch3o+no2'
!-----------------------------------------------------------------------------
! ... mabs: absorption cross section options:
! 1: calvert and pitts 1966
! 2: talukdar, burkholder, hunter, gilles, roberts, ravishankara, 1997.
! 3: iupac-97, table of values for 298k.
! 4: iupac-97, temperature-dependent equation
! 5: taylor et al. 1980
! 6: fit from roberts and fajer, 1989
! 7: rattigan et al. 1992
! 8: libuda and zabel 1995
!-----------------------------------------------------------------------------
      do i = 1,nz
         t = tlev(i) - 298._dp
         sq(:nw-1,i,j) = r17g(:nw-1) * exp( r17g1(:nw-1)*t )
      end do

      end subroutine r17

      subroutine r18( nz, tlev, airlev, j, jlabel )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for pan photolysis:
! pan + hv -> products
!
! cross section: from talukdar et al., 1995
! quantum yield: assumed to be unity
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! j - integer, counter for number of weighting functions defined (io)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
! jlabel - character*40, string identifier for each photolysis reaction (o)
! defined
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: nz
      integer, intent(inout) :: j
      real(dp), intent(in)   :: tlev(nz)
      real(dp), intent(in)   :: airlev(nz)
      character(len=40), intent(out) :: jlabel(nj)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: i
      real(dp) :: t
!-----------------------------------------------------------------------------
! ... pan photodissociation
!-----------------------------------------------------------------------------
      j = j+1
      jlabel(j) = 'pan + hv -> products'
!-----------------------------------------------------------------------------
! ... cross section from senum et al., 1984, j.phys.chem. 88/7, 1269-1270
! quantum yield
! yet unknown, but assumed to be 1.0 (talukdar et al., 1995)
!-----------------------------------------------------------------------------
      do i = 1,nz
         t = tlev(i) - 298._dp
         sq(:nw-1,i,j) = r18g(:nw-1) * exp( r18g2(:nw-1)*t )
      end do

      end subroutine r18

      subroutine xs_mvk( nz, tlev, airlev )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for mvk photolysis:
! mvk + hv -> products
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)  :: nz
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: k
      real(dp) :: qy(nw-1)
      real(dp) :: denomi

!     do k = 1,nz
!        qy = .0766 + .09415*exp( -airlev(k)/3.222e18 )
!        sq(:nw-1,k,27) = qy * acrolein_xs(:nw-1)
!     end do
      do k = 1,nz
         denomi         = 1._dp/(5.5_dp + 9.2e-19_dp*airlev(k))
         qy(:nw-1)      = exp( -.055_dp*(wc(:nw-1) - 308._dp) )*denomi
         sq(:nw-1,k,27) = min( qy(:nw-1),1._dp ) * acrolein_xs(:nw-1)
      end do

      end subroutine xs_mvk

      subroutine xs_macr( nz, tlev, airlev )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for macr photolysis:
! macr + hv -> products
!-----------------------------------------------------------------------------
! parameters:
! nw - integer, number of specified intervals + 1 in working (i)
! wavelength grid
! wl - real(dp), vector of lower limits of wavelength intervals in (i)
! working wavelength grid
! wc - real(dp), vector of center points of wavelength intervals in (i)
! working wavelength grid
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
! sq - real(dp), cross section x quantum yield (cm^2) for each (o)
! photolysis reaction defined, at each defined wavelength and
! at each defined altitude level
!-----------------------------------------------------------------------------
      implicit none
!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)  :: nz
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)
!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: l, k
      real(dp) :: phi, ph313, ph334, qy
      real(dp) :: factor
!     do k = 1,nz
!        ph313 = .004 + 1./(.086 + 1.613e-17*airlev(k))
!        ph334 = .005 + 1./(9.54 + 6.170e-17*airlev(k))
!        factor = (ph334 - ph313)/21.
!        do l = 1,nw-1
!           phi = ph313 + factor*(wc(l) - 313.)
!           qy = max( 0._dp, min( 1._dp, phi ) )
!           sq(l,k,28) = qy * acrolein_xs(l)
!        end do
!     end do
!-----------------------------------------------------------------------------
! 	... from mz4.5
!-----------------------------------------------------------------------------
      do k = 1,nz
         sq(:nw-1,k,28) = (/ 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
                             0._dp, 0._dp, 0._dp, 3.881e-23_dp, 5.908e-23_dp, &
                             3.182e-22_dp, 5.087e-22_dp, 6.586e-22_dp, 1.858e-22_dp, 0._dp, &
                             0._dp, 0._dp /)
      end do

      end subroutine xs_macr

      subroutine xs_hyac( nz, tlev, airlev )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for hyac photolysis:
! hyac + hv -> products
!-----------------------------------------------------------------------------
! parameters:
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)  :: nz
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)

!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: k

!-----------------------------------------------------------------------------
! 	... from mz4.5
!-----------------------------------------------------------------------------
      do k = 1,nz
         sq(:nw-1,k,29) = (/ 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
                             0._dp, 0._dp, 0._dp, 2.164e-21_dp, 1.714e-20_dp, &
                             4.927e-21_dp, 1.052e-21_dp, 2.39e-22_dp, 0._dp, 0._dp, &
                             0._dp, 0._dp /)
      end do

      end subroutine xs_hyac

      subroutine xs_glyald( nz, tlev, airlev )
!-----------------------------------------------------------------------------
! purpose:
! provide product (cross section) x (quantum yield) for glyald photolysis:
! glyald + hv -> products
!-----------------------------------------------------------------------------
! parameters:
! nz - integer, number of altitude levels in working altitude grid (i)
! tlev - real(dp), temperature (k) at each specified altitude level (i)
! airlev - real(dp), air density (molec/cc) at each altitude level (i)
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
! ... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)  :: nz
      real(dp), intent(in) :: tlev(nz)
      real(dp), intent(in) :: airlev(nz)

!-----------------------------------------------------------------------------
! ... local variables
!-----------------------------------------------------------------------------
      integer  :: k

!-----------------------------------------------------------------------------
! 	... from mz4.5
!-----------------------------------------------------------------------------
      do k = 1,nz
         sq(:nw-1,k,30) = (/ 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
                             2.864e-22_dp, 1.123e-19_dp, 2.659e-20_dp, 4.5e-21_dp, 1.998e-20_dp, &
                             1.6e-20_dp, 6.617e-21_dp, 1.151e-21_dp, 0._dp, 0._dp, &
                             0._dp, 0._dp /)
      end do

      end subroutine xs_glyald

    END MODULE module_wave_data
