! **************************************************************************************
!   This computer software was developed by Dr. Yang Zhang and her research group      *
!   at North Carolina State University (NCSU) with support  from the NSF Career Award  *
!   No. Atm-0348819, and the Memorandum of Understanding between the                   *
!   U.S. Environmental Protection Agency (EPA) and the U.S. Department of              *
!   Commerce's National Oceanic and Atmospheric Administration (NOAA)		       *
!   and under agreement number DW13921548, and the U.S. EPA/Office of                  *
!   Air Quality Planning & Standards via RTI International contract #4-321-0210288.    *
!										       *
!   NEITHER ANY COSPONSORS, NCSU, NOR ANY PERSON ACTING ON BEHALF                      *
!   OF ANY OF THEM MAKES ANY WARRANTY OR REPRESENTATION                                *
!   WHATSOEVER, EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR                       *
!   THE USE OF THIS SOFTWARE.  THIS SOFTWARE OR PART OF IT MAY BE                      *
!   COPYRIGHTED AND IS PERMITTED BY ORIGINAL CODE DEVELOPERS FOR                       *
!   NONPROFIT USE AND SUBJECTED TO RESTRICTIONS                       		       *
!                                                                                      *
!  Contact information: 							       *
!  Dr. Yang Zhang		                                                       * 
!  Principal Investigator						               *
!  Department of Marine, Earth, and Atmospheric Sciences 			       *
!  North Carolina State University						       *
!  Campus Box 8208 								       *
!  Room 5151, Jordan Hall, 2800 Faucette Drive 					       *
!  Raleigh, NC 27695-8208, USA 							       *
!  Tel:  (919) 515-9688 (Office) 						       *
!  Fax:  (919) 515-7802								       *
!  E-Mail:  yang_zhang@ncsu.edu 						       *
!                                                                                      *
! **************************************************************************************
!  FUNCTION: PROVIDE BOUNDARY VALUES FOR CB05 MADRID extension GAS-PHASE SPECIES       *
!  PRECONDITION REQUIRED: use for CB05 MADRID extension gas-phase mechanism            *
!  RETURN VALUES:								       *			         
!  KEY SUBROUTINES AND FUNCTIONS CALLED: None                                          *
!  REVISION HISTORY:                                                                   *
!         This code was based on module_cb05_initmixrats.F,                            *
!               developed by J.P. Huang and Y. Zhang, NCSU, Mar.-Oct. 2006             *
!         Revised by Ying Pan and Yang Zhang, NCSU, Nov. 2007-Nov. 2008	 	       *
!               to couple MADRID with CB05 MADRID extension gas-phase mechanism        * 
!         Revised by Yang Zhang, Xiao-Ming Hu, and Ying Pan, NCSU, Sept.-Nov., 2008    *
!         	Code cleaned up for NOAA WRF/Chem repository checkin     	       *               
!         Revised by Ying Pan and Yang Zhang, NCSU, Sep. 2009                          *
!               to transfer the code to WRF/Chem v3.1.1                                *
!***************************************************************************************


!-----------------------------------------------------------------------
      subroutine bdy_chem_value_cb05_vbs (id_bdy, chem_bv,kk, nch,config_flags,numgas )

        use module_configure, only:  grid_config_rec_type
	use module_input_chem_data, only:  bdy_chem_value

	implicit none

! arguments
	REAL,    INTENT(OUT)  :: chem_bv    ! boundary value for chem(-,-,-,nch)
!	REAL,    INTENT(IN)   :: z          ! height
	INTEGER, INTENT(IN)   :: nch        ! index number of chemical species
        INTEGER, INTENT(IN)   :: numgas     ! index number of last gas species
        INTEGER, INTENT(IN)   :: kk         ! level
        INTEGER, INTENT(IN)   :: id_bdy     ! id of bdy: 1 = YS, 2 = YE, 3=XS, 4 =XE
        TYPE(grid_config_rec_type), INTENT(IN) :: config_flags
! local variables
	real chem_bv_ald, chem_bv_hc3, chem_bv_hc5,   &
	     chem_bv_hc8, chem_bv_ket, chem_bv_oli,   &
	     chem_bv_olt, chem_bv_ora2
	real, parameter :: chem_bv_def = 1.0e-20
      character (len=100)    :: record 
      character (len=20)     ::  chem_var
      real                  :: cmaq_bc9(106,4,34)
      integer               :: iv, i,j,k

! The following boundary values were taken from CMAQ, July, 2001 episode
!
! for NO2  
      data (cmaq_bc9(1,1,k),k=1,34)&
         / 9.9999997E-06,   9.9999997E-06,   9.9999997E-06,   &
       9.9999997E-06,  9.9999997E-06,   9.6428539E-06,   9.2857072E-06,&
       7.4999953E-06,  5.7142838E-06,   5.7142838E-06, 24*0./
      data (cmaq_bc9(1,2,k),k=1,34)&
         / 9.9999997E-06,   9.9999997E-06,   9.9999997E-06,   &
       9.9999997E-06, 9.9999997E-06,   9.6428539E-06,   9.2857072E-06,& 
       7.4999953E-06, 5.7142838E-06,   5.7142838E-06, 24*0./
      data (cmaq_bc9(1,3,k),k=1,34)&
          /1.6700001E-04,  1.6700001E-04,  1.6700001E-04,&
          1.6700001E-04,  1.6700001E-04,  1.6403571E-04, 1.6107140E-04,&
          1.4625001E-04,  1.3142861E-04,  1.3142861E-04, 8.3999999E-05,&
          8.3999999E-05,  8.3999999E-05,  5.6000019E-05, 5.6000019E-05,&
          2.5454530E-05,  2.5454530E-05,  2.5454530E-05, 7.4999953E-06,&
          5.7142838E-06,  5.7142838E-06, 13*0./
      data (cmaq_bc9(1,4,k),k=1,34)&
          /1.6700001E-04,  1.6700001E-04,  1.6700001E-04,& 
          1.6700001E-04,  1.6700001E-04,  1.6403571E-04, 1.6107140E-04,&
          1.4625001E-04,  1.3142861E-04,  1.3142861E-04, 8.3999999E-05,&
          8.3999999E-05,  8.3999999E-05,  5.6000019E-05, 5.6000019E-05,&
          2.5454530E-05,  2.5454530E-05,  2.5454530E-05, 7.4999953E-06,&
          5.7142838E-06,  5.7142838E-06, 13*0./

! for NO
      data (cmaq_bc9(2,1,k),k=1,34)&
          / 9.9999997E-06,9.9999997E-06,9.9999997E-06, &
          9.9999997E-06, 9.9999997E-06,9.6428539E-06, 9.2857072E-06,&
          7.4999953E-06, 5.7142838E-06,5.7142838E-06,24*0./ 
      data (cmaq_bc9(2,2,k),k=1,34)&
         /34*0./
      data (cmaq_bc9(2,3,k),k=1,34)&
         / 5*8.2999999E-05, 8.1535698E-05, 8.0071397E-05,&
           7.2749986E-05, 6.5428569E-05, 6.5428569E-05, 4.2000000E-05,&
           4.2000000E-05, 4.2000000E-05, 2.8000009E-05, 2.8000009E-05,&
           1.2727260E-05, 1.2727260E-05, 1.2727260E-05, 16*0./
      data (cmaq_bc9(2,4,k),k=1,34)&
         / 5*8.2999999E-05, 8.1535698E-05, 8.0071397E-05,& 
           7.2749986E-05,   2*6.5428569E-05,3*4.2000000E-05,& 
           2*2.8000009E-05, 3*1.2727260E-05, 16*0./

! for O
      data ((cmaq_bc9(3,i,k),k=1,34),i=1,4)&
      /136*0./

! for O3 (CAM profile corporated)
      data (cmaq_bc9(4,1,k),k=1,34)&
      /2*2.9999999E-02, 3.0714281E-02,&
      3.1785712E-02, 3.2857139E-02, 3.4107145E-02, 0.034610,&
      0.034933, 0.035268, 0.035629, 0.035993,&
      0.036361, 0.036940, 0.037728, 0.038633,&
      0.039955, 0.041303, 0.042877, 0.044563,&
      0.046555, 0.048089, 0.049924, 0.052937,&
      0.056136, 0.059363, 0.062810, &
      0.064494, 0.065790, 0.069328, 0.074218, &
      0.086511, 0.100520, 0.117374, 0.182958  /
      data (cmaq_bc9(4,2,k),k=1,34)&
      /2*2.9999999E-02, 3.0714281E-02,&
      3.1785712E-02, 3.2857139E-02, 3.4107145E-02, 0.034610,&
      0.034933, 0.035268, 0.035629, 0.035993,&
      0.036361, 0.036940, 0.037728, 0.038633,&
      0.039955, 0.041303, 0.042877, 0.044563,&
      0.046555, 0.048089, 0.049924, 0.052937,&
      0.056136, 0.059363, 0.062810, &
      0.064494, 0.065790, 0.069328, 0.074218, &
      0.086511, 0.100520, 0.117374, 0.182958  /
      data (cmaq_bc9(4,3,k),k=1,34)&
      /5*3.5000000E-02,3.5178576E-02,0.034610,&
       0.034933,0.035268,0.035629,0.035993,&
       0.036361,0.036940,0.037728,0.038633,&
       0.039955,0.041303,0.042877,0.044563,&
       0.046555,0.048089,0.049924,0.052937,&
       0.056136, 0.059363, 0.062810, &
       0.064494, 0.065790, 0.069328, 0.074218, &
       0.086511, 0.100520, 0.117374, 0.182958 /
      data (cmaq_bc9(4,4,k),k=1,34)&
      /5*3.5000000E-02,3.5178576E-02,0.034610,&
       0.034933,0.035268,0.035629,0.035993,&
       0.036361,0.036940,0.037728,0.038633,&
       0.039955,0.041303,0.042877,0.044563,&
       0.046555,0.048089,0.049924,0.052937,&
       0.056136, 0.059363, 0.062810, &
       0.064494, 0.065790, 0.069328, 0.074218, &
       0.086511, 0.100520, 0.117374, 0.182958 /

! for no3
      data ((cmaq_bc9(5,i,k),k=1,34),i=1,4)&
      /136*0./

! for o1d
      data ((cmaq_bc9(6,i,k),k=1,34),i=1,4)&
      /136*0./

! for oh
      data ((cmaq_bc9(7,i,k),k=1,34),i=1,4)&
      /136*0./ 

! for ho2
      data ((cmaq_bc9(8,i,k),k=1,34),i=1,4)&
      /136*0./

! for n2o5
      data ((cmaq_bc9(9,i,k),k=1,34),i=1,4)&
      /136*0./

! for hno3
      data (cmaq_bc9(10,1,k),k=1,34)&
      /25*4.9999999E-05,3*9.9999997E-05,1.2500001E-04,5*1.5000001E-04/
      data (cmaq_bc9(10,2,k),k=1,34)&
      /25*4.9999999E-05,3*9.9999997E-05,1.2500001E-04,5*1.5000001E-04/
      data (cmaq_bc9(10,3,k),k=1,34)&
      /18*4.9999999E-05,2*5.1851850E-05, 5.5370372E-05,&
        5.8888891E-05, 6.3518521E-05, 2*6.8148147E-05,&
        3*8.5000000E-05,9.2499999E-05,5*9.9999997E-05/
      data (cmaq_bc9(10,4,k),k=1,34)&
      /18*4.9999999E-05,2*5.1851850E-05, 5.5370372E-05,&
        5.8888891E-05, 6.3518521E-05, 2*6.8148147E-05,&
        3*8.5000000E-05,9.2499999E-05,5*9.9999997E-05/

! for hono
     data ((cmaq_bc9(11,i,k),k=1,34),i=1,4)&
      /136*9.9999997E-10/

! for pna
     data ((cmaq_bc9(12,i,k),k=1,34),i=1,4)&
      /136*1.9999999E-09/

! for h2o2
     data (cmaq_bc9(13,1,k),k=1,34)&
      /18*2.0000001E-03,2*1.9537040E-03, 1.8657411E-03,&
       1.7777780E-03, 1.6620370E-03, 1.5462959E-03,    &
       1.5462959E-03, 1.2500000E-03, 1.2500000E-03,    &
       1.2500000E-03, 1.1250000E-03, 5*1.0000000E-03/
     data (cmaq_bc9(13,2,k),k=1,34)&
      /18*2.0000001E-03,2*1.9537040E-03, 1.8657411E-03,&
       1.7777780E-03, 1.6620370E-03, 1.5462959E-03,    &
       1.5462959E-03, 1.2500000E-03, 1.2500000E-03,    &
       1.2500000E-03, 1.1250000E-03, 5*1.0000000E-03/
     data (cmaq_bc9(13,3,k),k=1,34)&
      /5*1.0000000E-03, 1.0178576E-03,1.0357150E-03,&
      1.1250004E-03,1.2142860E-03,1.2142860E-03,3*1.5000000E-03,&
      2*1.3333330E-03,3*1.1515151E-03,2*9.8148151E-04,&
      9.4629632E-04,9.1111113E-04,8.6481485E-04,2*8.1851851E-04,&
      3*5.0000002E-04, 3.5000002E-04,5*1.9999999E-04/
     data (cmaq_bc9(13,4,k),k=1,34)&
      /5*1.0000000E-03, 1.0178576E-03,1.0357150E-03,&
      1.1250004E-03,1.2142860E-03,1.2142860E-03,3*1.5000000E-03,&
      2*1.3333330E-03,3*1.1515151E-03,2*9.8148151E-04,&
      9.4629632E-04,9.1111113E-04,8.6481485E-04,2*8.1851851E-04,&
      3*5.0000002E-04, 3.5000002E-04,5*1.9999999E-04/

! for xo2
     data ((cmaq_bc9(14,i,k),k=1,34),i=1,4)&
      /136*0./

! for xo2n
     data ((cmaq_bc9(15,i,k),k=1,34),i=1,4)&
      /136*0./

! for ntr
     data ((cmaq_bc9(16,i,k),k=1,34),i=1,4)&
      /136*0./ 

! for rooh
     data ((cmaq_bc9(17,i,k),k=1,34),i=1,4)&
      /136*0./  

! for form
     data ((cmaq_bc9(18,i,k),k=1,34),i=1,4)&
      /136*0./ 

! for ald2
     data ((cmaq_bc9(19,i,k),k=1,34),i=1,4)&
      /136*0./  

! for aldx
     data ((cmaq_bc9(20,i,k),k=1,34),i=1,4)&
      /136*0./  

! for par
     data ((cmaq_bc9(21,i,k),k=1,34),i=1,4)&
      /136*0./  

! for co
     data (cmaq_bc9(22,1,k),k=1,34)&
      /18*7.0000000E-02,2*6.9537044E-02,6.8657413E-02,&
       6.7777783E-02,6.6620372E-02,2*6.5462962E-02,&
       3*5.9999999E-02,5.7499997E-02,5*5.5000000E-02/
      data (cmaq_bc9(22,2,k),k=1,34)&  
      /13*7.9999998E-02,2*7.8333333E-02,3*7.6515153E-02,&
       2*7.4537039E-02, 7.3657408E-02, 7.2777778E-02,7.1620367E-02,&
       7.0462957E-02,   7.0462957E-02, 6.7500003E-02, 6.7500003E-02,&
       6.7500003E-02,   6.6249996E-02, 5*6.4999998E-02/
      data (cmaq_bc9(22,3,k),k=1,34)&   
      /13*7.9999998E-02,2*7.6666668E-02,3*7.3030300E-02,&
       2*6.9537044E-02,6.8657413E-02,6.7777783E-02,6.6620372E-02,&
       6.5462962E-02, 6.5462962E-02, 5.7500001E-02, 5.7500001E-02,&
       5.7500001E-02, 5.3750001E-02, 5*5.0000001E-02/
      data (cmaq_bc9(22,4,k),k=1,34)&
      /13*7.9999998E-02,2*7.6666668E-02,3*7.3030300E-02,&
       2*6.9537044E-02,6.8657413E-02,6.7777783E-02,6.6620372E-02,&
       6.5462962E-02, 6.5462962E-02, 5.7500001E-02, 5.7500001E-02,&
       5.7500001E-02, 5.3750001E-02, 5*5.0000001E-02/

! for meo2
     data ((cmaq_bc9(23,i,k),k=1,34),i=1,4)&
      /136*0./

! for mepx
      data (cmaq_bc9(24,1,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07, &
       2*1.9537040E-07,1.8657411E-07,1.7777781E-07,1.6620371E-07,&
       2*1.5462960E-07,3*1.2500000E-07,1.1250000E-07,&
       5*1.0000000E-07/  
      data (cmaq_bc9(24,2,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07, &
       2*1.9537040E-07,1.8657411E-07,1.7777781E-07,1.6620371E-07,&
       2*1.5462960E-07,3*1.2500000E-07,1.1250000E-07,&
       5*1.0000000E-07/
      data (cmaq_bc9(24,3,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9074071E-07,1.7314815E-07,1.5555560E-07,1.3240745E-07,&
       1.0925930E-07,1.0925930E-07,3*7.5000003E-08,6.2500000E-08,&
       5*5.0000001E-08/
     data (cmaq_bc9(24,4,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9074071E-07,1.7314815E-07,1.5555560E-07,1.3240745E-07,&
       1.0925930E-07,1.0925930E-07,3*7.5000003E-08,6.2500000E-08,&
       5*5.0000001E-08/

! for meoh
     data ((cmaq_bc9(25,i,k),k=1,34),i=1,4)&
      /136*0./

! for hco3
     data ((cmaq_bc9(26,i,k),k=1,34),i=1,4)&    
      /136*0./ 

! for facd
     data (cmaq_bc9(27,1,k),k=1,34)&
     /2*1.5000001E-06,1.3571430E-06,1.1428572E-06,&
      9.2857141E-07,7.1428570E-07,28*5.0000000E-07/
     data (cmaq_bc9(27,2,k),k=1,34)&
     /2*1.5000001E-06,1.3571430E-06,1.1428572E-06,&
      9.2857141E-07,7.1428570E-07,28*5.0000000E-07/
     data (cmaq_bc9(27,3,k),k=1,34)&
     /5*1.0000000E-06,9.8214264E-07,9.6428539E-07,&
        8.7499978E-07,7.8571418E-07,7.8571418E-07,&
        15*5.0000000E-07,3*2.5000000E-07,1.2500000E-07,&
        5*0./
     data (cmaq_bc9(27,4,k),k=1,34)&
     /5*1.0000000E-06,9.8214264E-07,9.6428539E-07,&
        8.7499978E-07,7.8571418E-07,7.8571418E-07,&
        15*5.0000000E-07,3*2.5000000E-07,1.2500000E-07,&
        5*0./

! for c2o3
     data ((cmaq_bc9(28,i,k),k=1,34),i=1,4)&
     /136*9.9999997E-10/

! for pan
     data ((cmaq_bc9(29,i,k),k=1,34),i=1,2)&
     /68*1.5000000E-05/
     data (cmaq_bc9(29,3,k),k=1,34)&
     /5*9.9999997E-05,9.8214266E-05,9.6428543E-05,&
      8.7499982E-05,7.8571422E-05,7.8571422E-05,8*4.9999999E-05,&
      2*4.6759251E-05, 4.0601852E-05,3.4444449E-05,2.6342594E-05,&
      2*1.8240740E-05, 3*7.4999998E-06,3.7499999E-06,5*0./
     data (cmaq_bc9(29,4,k),k=1,34)&
     /5*9.9999997E-05,9.8214266E-05,9.6428543E-05,&
      8.7499982E-05,7.8571422E-05,7.8571422E-05,8*4.9999999E-05,&
      2*4.6759251E-05, 4.0601852E-05,3.4444449E-05,2.6342594E-05,&
      2*1.8240740E-05, 3*7.4999998E-06,3.7499999E-06,5*0./

! for pacd
     data (cmaq_bc9(30,1,k),k=1,34)&
      /18*9.9999997E-05,2*9.5370357E-05,8.6574073E-05,&
       7.7777782E-05,6.6203706E-05,5.4629629E-05,5.4629629E-05,&
       9*4.9999999E-05/
     data (cmaq_bc9(30,2,k),k=1,34)&
      /34*4.9999999E-05/
     data (cmaq_bc9(30,3,k),k=1,34)&
      /13*2.9999999E-05,2*2.8333330E-05,3*2.6515150E-05,&
        2*2.4537039E-05,2.3657409E-05,2.2777780E-05,2.1620370E-05,&
        2*2.0462960E-05, 3*1.7500000E-05,1.6250000E-05,5*1.5000000E-05/
     data (cmaq_bc9(30,4,k),k=1,34)&
      /13*2.9999999E-05,2*2.8333330E-05,3*2.6515150E-05,&
        2*2.4537039E-05,2.3657409E-05,2.2777780E-05,2.1620370E-05,&
        2*2.0462960E-05, 3*1.7500000E-05,1.6250000E-05,5*1.5000000E-05/

! for aacd
      data (cmaq_bc9(31,1,k),k=1,34)&
        /2*1.5000001E-06, 1.3571430E-06,1.1428572E-06,9.2857141E-07,&
        7.1428570E-07,  28*5.0000000E-07/
      data (cmaq_bc9(31,2,k),k=1,34)&
        /2*1.5000001E-06, 1.3571430E-06,1.1428572E-06,9.2857141E-07,&
        7.1428570E-07,  28*5.0000000E-07/
      data (cmaq_bc9(31,3,k),k=1,34)&
       /5*1.0000000E-06,9.8214264E-07,9.6428539E-07,&
        8.7499978E-07,7.8571418E-07,7.8571418E-07,15*5.0000000E-07,&
        3*2.5000000E-07,1.2500000E-07,5*0/
      data (cmaq_bc9(31,4,k),k=1,34)&
       /5*1.0000000E-06,9.8214264E-07,9.6428539E-07,&
        8.7499978E-07,7.8571418E-07,7.8571418E-07,15*5.0000000E-07,&
        3*2.5000000E-07,1.2500000E-07,5*0/ 

! for cxo3
     data ((cmaq_bc9(32,i,k),k=1,34),i=1,4)&
      /136*9.9999997E-10/

! for panx
     data ((cmaq_bc9(33,i,k),k=1,34),i=1,4)&
      /136*9.9999997E-10/

! for ror
     data ((cmaq_bc9(34,i,k),k=1,34),i=1,4)&
      /136*0./

! for ole
     data ((cmaq_bc9(35,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(35,3,k),k=1,34)&
      /5*2.0000000E-07,1.9642854E-07,1.9285710E-07,&
      1.7499994E-07,2*1.5714279E-07,3*1.0000000E-07,2*6.6666693E-08,&
      3*3.0303010E-08,16*0./
     data (cmaq_bc9(35,4,k),k=1,34)&
      /5*2.0000000E-07,1.9642854E-07,1.9285710E-07,&
      1.7499994E-07,2*1.5714279E-07,3*1.0000000E-07,2*6.6666693E-08,&
      3*3.0303010E-08,16*0./

! for eth
     data ((cmaq_bc9(36,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(36,3,k),k=1,34)&
      /2*4.9999999E-06, 4.7142862E-06,4.2857146E-06,&
      3.8571429E-06,3.3928568E-06,2.9285709E-06,2.7499996E-06,&
      2*2.5714280E-06,3*2.0000000E-06,2*1.6666670E-06,3*1.3030300E-06,&
      7*1.0000000E-06, 3* 5.0000000E-07,2.5000000E-07,5*0./
     data (cmaq_bc9(36,4,k),k=1,34)&
      /2*4.9999999E-06, 4.7142862E-06,4.2857146E-06,&
      3.8571429E-06,3.3928568E-06,2.9285709E-06,2.7499996E-06,&
      2*2.5714280E-06,3*2.0000000E-06,2*1.6666670E-06,3*1.3030300E-06,&
      7*1.0000000E-06, 3* 5.0000000E-07,2.5000000E-07,5*0./

! for iole
     data ((cmaq_bc9(37,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(37,3,k),k=1,34)&
      /5*1.0000000E-07,9.6428536E-08,9.2857071E-08,&
       7.4999960E-08,2*5.7142849E-08,24*0./
     data (cmaq_bc9(37,4,k),k=1,34)&
      /5*1.0000000E-07,9.6428536E-08,9.2857071E-08,&
       7.4999960E-08,2*5.7142849E-08,24*0./

! for tol
     data ((cmaq_bc9(38,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(38,3,k),k=1,34)&
      /18*1.0000000E-06, 2*9.0740730E-07,&
       7.3148146E-07,5.5555557E-07,3.2407408E-07,&
       2*9.2592600E-08,9*0./
     data (cmaq_bc9(38,4,k),k=1,34)&
      /18*1.0000000E-06, 2*9.0740730E-07,&
       7.3148146E-07,5.5555557E-07,3.2407408E-07,&
       2*9.2592600E-08,9*0./

! for cres
     data ((cmaq_bc9(39,i,k),k=1,34),i=1,4)&
      /136*9.9999997E-10/

! for to2
     data ((cmaq_bc9(40,i,k),k=1,34),i=1,4)&
      /136*9.9999997E-10/

! for tolaer1
     data ((cmaq_bc9(41,i,k),k=1,34),i=1,4)&
      /136*0./
! for tolaer2
     data ((cmaq_bc9(42,i,k),k=1,34),i=1,4)&
      /136*0./

! for open
     data (cmaq_bc9(43,1,k),k=1,34)&
      /13*2.5000000E-07, 2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9537040E-07, 1.8657411E-07,1.7777781E-07,1.6620371E-07,&
       2*1.5462960E-07,3*1.2500000E-07,1.1250000E-07,5*1.0000000E-07/
     data (cmaq_bc9(43,2,k),k=1,34)&
      /13*2.5000000E-07, 2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9537040E-07, 1.8657411E-07,1.7777781E-07,1.6620371E-07,&
       2*1.5462960E-07,3*1.2500000E-07,1.1250000E-07,5*1.0000000E-07/
     data (cmaq_bc9(43,3,k),k=1,34)&
      / 13*2.5000000E-07, 2*2.3333330E-07,&
        3*2.1515150E-07, 2*1.9074071E-07,1.7314815E-07,1.5555560E-07,&
        1.3240745E-07,2*1.0925930E-07,&
        3*7.5000003E-08, 6.2500000E-08, 5*5.0000001E-08/
     data (cmaq_bc9(43,4,k),k=1,34)&
      / 13*2.5000000E-07, 2*2.3333330E-07,&
        3*2.1515150E-07, 2*1.9074071E-07,1.7314815E-07,1.5555560E-07,&
        1.3240745E-07,2*1.0925930E-07,&
        3*7.5000003E-08, 6.2500000E-08, 5*5.0000001E-08/

! for cro
      data ((cmaq_bc9(44,i,k),k=1,34),i=1,4)&
      /136*0./

! for cslaer
     data ((cmaq_bc9(45,i,k),k=1,34),i=1,4)&
      /136*0./

! for mgly
     data (cmaq_bc9(46,1,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9537040E-07, 1.8657411E-07, 1.7777781E-07, 1.6620371E-07,&
       2*1.5462960E-07, 3*1.2500000E-07,1.1250000E-07,5*1.0000000E-07/
     data (cmaq_bc9(46,2,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9537040E-07, 1.8657411E-07, 1.7777781E-07, 1.6620371E-07,&
       2*1.5462960E-07, 3*1.2500000E-07,1.1250000E-07,5*1.0000000E-07/
     data (cmaq_bc9(46,3,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9074071E-07,1.7314815E-07,1.5555560E-07,1.3240745E-07,&
       2*1.0925930E-07, 3*7.5000003E-08,6.2500000E-08,&
       5*5.0000001E-08 /
     data (cmaq_bc9(46,4,k),k=1,34)&
      /13*2.5000000E-07,2*2.3333330E-07,3*2.1515150E-07,&
       2*1.9074071E-07,1.7314815E-07,1.5555560E-07,1.3240745E-07,&
       2*1.0925930E-07, 3*7.5000003E-08,6.2500000E-08,&
       5*5.0000001E-08 /

! for xyl
     data ((cmaq_bc9(47,i,k),k=1,34),i=1,2)&
      /68*0./ 
      data (cmaq_bc9(47,3,k),k=1,34)&
      / 5*2.0000000E-07,1.9642854E-07,1.9285710E-07,&
        1.7499994E-07,2*1.5714279E-07,3*1.0000000E-07,&
         2*6.6666693E-08,3*3.0303010E-08, 16*0.0/
      data (cmaq_bc9(47,4,k),k=1,34)&
      / 5*2.0000000E-07,1.9642854E-07,1.9285710E-07,&
        1.7499994E-07,2*1.5714279E-07,3*1.0000000E-07,&
         2*6.6666693E-08,3*3.0303010E-08, 16*0.0/

! for xylaer1
      data ((cmaq_bc9(48,i,k),k=1,34),i=1,4)&
      /136*0./ 

! for xylaer2
      data ((cmaq_bc9(49,i,k),k=1,34),i=1,4)&
      /136*0./

! for isop
     data ((cmaq_bc9(50,i,k),k=1,34),i=1,2)&
      /68*0./  
     data (cmaq_bc9(50,3,k),k=1,34)& 
      /5*1.5000001E-04,1.4464281E-04,1.3928561E-04,&
       1.1249994E-04,2*8.5714273E-05,24*0./
     data (cmaq_bc9(50,4,k),k=1,34)&
      /5*1.5000001E-04,1.4464281E-04,1.3928561E-04,&
       1.1249994E-04,2*8.5714273E-05,24*0./

! for ispd
      data ((cmaq_bc9(51,i,k),k=1,34),i=1,4)&
      /136*0./  

! for isoaer1
      data ((cmaq_bc9(52,i,k),k=1,34),i=1,4)&
      /136*0./

! for isoaer2
      data ((cmaq_bc9(53,i,k),k=1,34),i=1,4)&
      /136*0./

! so2
     data ((cmaq_bc9(54,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(54,3,k),k=1,34)&
      /2*3.0000001E-04,2.8571431E-04, 2.6428571E-04,&
       2.4285710E-04,2.1785710E-04,1.9285710E-04,&
       1.7499995E-04,2*1.5714280E-04,1.5714280E-04,8*9.9999997E-05,&
       2*9.2592578E-05,7.8518511E-05,6.4444437E-05,4.5925924E-05,&
       2*2.7407410E-05,3*1.5000000E-05,5*9.9999997E-06/
     data (cmaq_bc9(54,4,k),k=1,34)&
      /2*3.0000001E-04,2.8571431E-04, 2.6428571E-04,&
       2.4285710E-04,2.1785710E-04,1.9285710E-04,&
       1.7499995E-04,2*1.5714280E-04,1.5714280E-04,8*9.9999997E-05,&
       2*9.2592578E-05,7.8518511E-05,6.4444437E-05,4.5925924E-05,&
       2*2.7407410E-05,3*1.5000000E-05,5*9.9999997E-06/

! sulf
     data ((cmaq_bc9(55,i,k),k=1,34),i=1,4)&
      /136*1.0000000E-30/

! sulfaer
      data ((cmaq_bc9(56,i,k),k=1,34),i=1,4)&
      /136*0./  

! etoh 
      data ((cmaq_bc9(57,i,k),k=1,34),i=1,4)&
      /136*0./

! etha
      data (cmaq_bc9(58,1,k),k=1,34)&
      /13*9.9999997E-05,2*8.9000008E-05,&
       3*7.6999990E-05,16*6.7000001E-05/
      data (cmaq_bc9(58,2,k),k=1,34)&
      /13*9.9999997E-05,2*8.9000008E-05,&
       3*7.6999990E-05,2*6.3851847E-05,&
       5.7870369E-05,5.1888888E-05,4.4018518E-05,&
       2*3.6148151E-05,9*3.3000000E-05/
     data (cmaq_bc9(58,3,k),k=1,34)&
      /5*9.9999997E-05,9.9285702E-05,9.8571407E-05,&
       9.4999989E-05,2*9.1428570E-05,3*7.9999998E-05,&
       2*6.3333340E-05, 3*4.5151501E-05,&
       2*2.8148141E-05, 2.4629626E-05, 2.1111109E-05,1.6481479E-05,&
       2*1.1851850E-05, 3*4.9999999E-06,2.4999999E-06,5*0./  
     data (cmaq_bc9(58,4,k),k=1,34)&
      /5*9.9999997E-05,9.9285702E-05,9.8571407E-05,&
       9.4999989E-05,2*9.1428570E-05,3*7.9999998E-05,&
       2*6.3333340E-05, 3*4.5151501E-05,&
       2*2.8148141E-05, 2.4629626E-05, 2.1111109E-05,1.6481479E-05,&
       2*1.1851850E-05, 3*4.9999999E-06,2.4999999E-06,5*0./

! for terp
     data ((cmaq_bc9(59,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(59,3,k),k=1,34)&
      / 5*3.7500002E-05,3.6160702E-05,3.4821402E-05,&
       2.8124985E-05, 2*2.1428570E-05,24*0./
     data (cmaq_bc9(59,4,k),k=1,34)&
      / 5*3.7500002E-05,3.6160702E-05,3.4821402E-05,&
       2.8124985E-05, 2*2.1428570E-05,24*0./

! terpaer
      data ((cmaq_bc9(60,i,k),k=1,34),i=1,4)&
      /136*0./

! for hum
     data ((cmaq_bc9(61,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(61,3,k),k=1,34)&
      / 5*1.2412500662E-05,1.1969192362E-05,1.1525884062E-05,&
       0.9309370035E-05, 2*0.709285667E-05,24*0./
     data (cmaq_bc9(61,4,k),k=1,34)&
      / 5*1.218262564974E-05,1.174752725874E-05,1.131242886774E-05,&
       0.913696387695E-05, 2*0.69614995359E-05,24*0./

! for humaer
      data ((cmaq_bc9(62,i,k),k=1,34),i=1,4)&
      /136*0./

! for lim
     data ((cmaq_bc9(63,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(63,3,k),k=1,34)&
      / 5*0.506250027E-05,0.488269477E-05,0.470088927E-05,&
       0.3796872975E-05, 2*0.289285695E-05,24*0./
     data (cmaq_bc9(63,4,k),k=1,34)&
      / 5*0.3016087660858E-05,0.2908369101158E-05,0.2800650541458E-05,&
       0.2262064418565E-05, 2*0.172347845653E-05,24*0./

! for limaer1
      data ((cmaq_bc9(64,i,k),k=1,34),i=1,4)&
      /136*0./

! for limaer2
      data ((cmaq_bc9(65,i,k),k=1,34),i=1,4)&
      /136*0./

! for oci
     data ((cmaq_bc9(66,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(66,3,k),k=1,34)&
      / 5*0.8137500434E-05,0.7846872334E-05,0.7556244234E-05,&
       0.6103121745E-05, 2*0.464999969E-05,24*0./
     data (cmaq_bc9(66,4,k),k=1,34)&
      / 5*0.6262500334E-05,0.6038837234E-05,0.5815174134E-05,&
       0.4696872495E-05, 2*0.357857119E-05,24*0./

! for ociaer1
      data ((cmaq_bc9(67,i,k),k=1,34),i=1,4)&
      /136*0./

! for ociaer2
      data ((cmaq_bc9(68,i,k),k=1,34),i=1,4)&
      /136*0./

! for apin
     data ((cmaq_bc9(69,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(69,3,k),k=1,34)&
      / 5*0.331875E-05,0.3200222127E-05,0.3081694077E-05,&
       0.24890611725E-05, 2*0.1896428445E-05,24*0./
     data (cmaq_bc9(69,4,k),k=1,34)&
      / 5*0.69192375E-05,0.6672119608126E-05,0.6425001347226E-05,&
       0.5189425357305E-05, 2*0.395384973641E-05,24*0./

! for apinaer1
      data ((cmaq_bc9(70,i,k),k=1,34),i=1,4)&
      /136*0./

! for apinaer2
      data ((cmaq_bc9(71,i,k),k=1,34),i=1,4)&
      /136*0./

! for apinaer3
      data ((cmaq_bc9(72,i,k),k=1,34),i=1,4)&
      /136*0./

! for apinaer4
      data ((cmaq_bc9(73,i,k),k=1,34),i=1,4)&
      /136*0./

! for bpin
     data ((cmaq_bc9(74,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(74,3,k),k=1,34)&
      / 5*0.2587500138E-05,0.2495088438E-05,0.2402676738E-05,&
       0.1940623965E-05, 2*0.147857133E-05,24*0./
     data (cmaq_bc9(74,4,k),k=1,34)&
      / 5*0.85875E-05,0.8280800758E-05,0.7974101058E-05,&
       0.6440621565E-05, 2*0.490714253E-05,24*0./

! for bpinaer1
      data ((cmaq_bc9(75,i,k),k=1,34),i=1,4)&
      /136*0./

! for bpinaer2
      data ((cmaq_bc9(76,i,k),k=1,34),i=1,4)&
      /136*0./

! for bpinaer3
      data ((cmaq_bc9(77,i,k),k=1,34),i=1,4)&
      /136*0./

! for bpinaer4
      data ((cmaq_bc9(78,i,k),k=1,34),i=1,4)&
      /136*0./

! for bpinaer5
      data ((cmaq_bc9(79,i,k),k=1,34),i=1,4)&
      /136*0./

! for ter

     data ((cmaq_bc9(80,i,k),k=1,34),i=1,2)&
      /68*0./
     data (cmaq_bc9(80,3,k),k=1,34)&
      / 5*0.5925000316E-05,0.5713390916E-05,0.5501781516E-05,&
       0.444374763E-05, 2*0.338571406E-05,24*0./
     data (cmaq_bc9(80,4,k),k=1,34)&
      / 5*0.0532237528386E-05,0.0513228843486E-05,0.0494220158586E-05,&
       0.0399177912105E-05, 2*0.030413569401E-05,24*0./

! for teraer1
      data ((cmaq_bc9(81,i,k),k=1,34),i=1,4)&
      /136*0./

! for teraer2
      data ((cmaq_bc9(82,i,k),k=1,34),i=1,4)&
      /136*0./

! for alkh
      data ((cmaq_bc9(83,i,k),k=1,34),i=1,4)&
      /136*0./

! for alkhaer1
      data ((cmaq_bc9(84,i,k),k=1,34),i=1,4)&
      /136*0./

! for pah
      data ((cmaq_bc9(85,i,k),k=1,34),i=1,4)&
      /136*0./

! for pahaer1
      data ((cmaq_bc9(86,i,k),k=1,34),i=1,4)&
      /136*0./

! for pahaer2
      data ((cmaq_bc9(87,i,k),k=1,34),i=1,4)&
      /136*0./

! for cvasoa1
      data ((cmaq_bc9(88,i,k),k=1,34),i=1,4)&
      /136*0./

! for cvasoa2
      data ((cmaq_bc9(89,i,k),k=1,34),i=1,4)&
      /136*0./

! for cvasoa3
      data ((cmaq_bc9(90,i,k),k=1,34),i=1,4)&
      /136*0./

! for cvasoa4
      data ((cmaq_bc9(91,i,k),k=1,34),i=1,4)&
      /136*0./

! for cvbsoa1
      data ((cmaq_bc9(92,i,k),k=1,34),i=1,4)&
      /136*0./
! for cvbsoa2
      data ((cmaq_bc9(93,i,k),k=1,34),i=1,4)&
      /136*0./
! for cvbsoa3
      data ((cmaq_bc9(94,i,k),k=1,34),i=1,4)&
      /136*0./
! for cvbsoa4
      data ((cmaq_bc9(95,i,k),k=1,34),i=1,4)&
      /136*0./

! for h2
      data ((cmaq_bc9(96,i,k),k=1,34),i=1,4)&
      /136*0.5/

! for ch4
      data ((cmaq_bc9(97,i,k),k=1,34),i=1,4)&
      /136*1.7/

! for cl
      data ((cmaq_bc9(98,i,k),k=1,34),i=1,4)&
      /136*0./

! for hcl
      data ((cmaq_bc9(99,i,k),k=1,34),i=1,4)&
      /136*0./

! for fmcl
      data ((cmaq_bc9(100,i,k),k=1,34),i=1,4)&
      /136*0./
! for hg0
      data ((cmaq_bc9(101,i,k),k=1,34),i=1,4)&
      /136*0./
! for hg2
      data ((cmaq_bc9(102,i,k),k=1,34),i=1,4)&
      /136*0./
! for hocl
      data ((cmaq_bc9(103,i,k),k=1,34),i=1,4)&
      /136*0./
! for clo
      data ((cmaq_bc9(104,i,k),k=1,34),i=1,4)&
      /136*0./
! for cl2
      data ((cmaq_bc9(105,i,k),k=1,34),i=1,4)&
      /136*0./
! for nh3
      data ((cmaq_bc9(106,i,k),k=1,34),i=1,4)&
      /136*0./

       if (id_bdy .eq. 1 ) then
          chem_bv = cmaq_bc9(nch-1,1,kk)
       elseif (id_bdy .eq. 2 ) then
          chem_bv = cmaq_bc9(nch-1,3,kk)
       elseif (id_bdy .eq. 3 ) then
          chem_bv = cmaq_bc9(nch-1,4,kk)
       elseif (id_bdy .eq. 4 ) then
          chem_bv = cmaq_bc9(nch-1,2,kk)
       endif
       if (nch==98 .and. id_bdy.eq.1) then
!       print*,"chem_bv=,",chem_bv
!       print*, "calling cb05 BC 101 option!!!"
       endif
       return
       end subroutine bdy_chem_value_cb05_vbs

