	SUBROUTINE CADN30( IDN, ADN )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    CADN30
C   PRGMMR: ATOR             ORG: NP12       DATE: 2004-08-18
C
C ABSTRACT:  GIVEN THE BIT-WISE REPRESENTATION OF THE FXY VALUE
C   FOR A DESCRIPTOR, THIS ROUTINE CALLS FUNCTION ADN30 AND STORES
C   ITS RETURN VALUE (I.E. THE ASCII-EQUIVALENT FXY VALUE) AS THE
C   ROUTINE OUTPUT VALUE.  THIS MECHANISM (I.E. A FORTRAN SUBROUTINE
C   WRAPPER RETURNING ADN AS A CALL PARAMETER, RATHER THAN DIRECTLY
C   CALLING THE FORTRAN FUNCTION ADN30 FROM WITHIN A C ROUTINE)
C   ALLOWS SAFE AND PORTABLE (ALBEIT INDIRECT) ACCESS TO THE ADN30
C   FUNCTION LOGIC FROM WITHIN A C ROUTINE SUCH AS RESTD.
C
C PROGRAM HISTORY LOG:
C 2004-08-18  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    CADN30( IDN, ADN )
C   INPUT ARGUMENT LIST:
C     IDN      - INTEGER: BIT-WISE REPRESENTATION OF FXY VALUE
C
C   OUTPUT ARGUMENT LIST:
C     ADN      - CHARACTER*(*): ASCII-CHARACTER FORM OF IDN
C
C REMARKS:
C    THIS ROUTINE CALLS:        ADN30
C    THIS ROUTINE IS CALLED BY: RESTD
C                               Normally not called by application
C                               programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	CHARACTER*(*)	ADN
	CHARACTER*6	ADN30

	ADN = ADN30( IDN, 6 )

	RETURN
	END
